#!/bin/bash

set -ex

# Create the namespace for the HCO
oc create ns kubevirt-hyperconverged || true

# Create an OperatorGroup
cat <<EOF | oc create -f -
apiVersion: operators.coreos.com/v1alpha2
kind: OperatorGroup
metadata:
  name: hco-operatorgroup
  namespace: kubevirt-hyperconverged
EOF

# Create a Catalog Source backed by a grpc registry
cat <<EOF | oc create -f -
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: hco-catalogsource
  namespace: openshift-operator-lifecycle-manager
  imagePullPolicy: Always
spec:
  sourceType: grpc
  image: registry.redhat.io/container-native-virtualization/hco-bundle-registry:${HCO_BUNDLE_REGISTRY_TAG:-v2.0.0-42}
  displayName: KubeVirt HyperConverged
  publisher: Red Hat
EOF

echo "Waiting up to ${POD_TIMEOUT:=360s} for catalogsource to appear..."
oc wait pods -n openshift-operator-lifecycle-manager -l olm.catalogSource=hco-catalogsource --for condition=Ready --timeout="${POD_TIMEOUT}"

# Create a subscription
cat <<EOF | oc create -f -
apiVersion: operators.coreos.com/v1alpha1
kind: Subscription
metadata:
  name: hco-subscription
  namespace: kubevirt-hyperconverged
spec:
  channel: alpha
  name: kubevirt-hyperconverged
  source: hco-catalogsource
  sourceNamespace: openshift-operator-lifecycle-manager
EOF

echo "Give the operators some time to start..."
sleep ${OPERATORS_SLEEP:=30}

VIRT_POD=`oc get pods -n kubevirt-hyperconverged | grep virt-operator | head -1 | awk '{ print $1 }'`
CDI_POD=`oc get pods -n kubevirt-hyperconverged | grep cdi-operator | head -1 | awk '{ print $1 }'`
WEBUI_POD=`oc get pods -n kubevirt-hyperconverged | grep kubevirt-web-ui-operator | head -1 | awk '{ print $1 }'`
NETWORK_ADDONS_POD=`oc get pods -n kubevirt-hyperconverged | grep cluster-network-addons-operator | head -1 | awk '{ print $1 }'`
oc wait pod $VIRT_POD --for condition=Ready -n kubevirt-hyperconverged --timeout="${POD_TIMEOUT}"
oc wait pod $CDI_POD --for condition=Ready -n kubevirt-hyperconverged --timeout="${POD_TIMEOUT}"
oc wait pod $WEBUI_POD --for condition=Ready -n kubevirt-hyperconverged --timeout="${POD_TIMEOUT}"
oc wait pod $NETWORK_ADDONS_POD --for condition=Ready -n kubevirt-hyperconverged --timeout="${POD_TIMEOUT}"

echo "Launching CNV..."
cat <<EOF | oc create -f -
apiVersion: hco.kubevirt.io/v1alpha1
kind: HyperConverged
metadata:
  name: hyperconverged-cluster
  namespace: kubevirt-hyperconverged
EOF
