#!/bin/bash -ex

readonly CSV_MERGER_POD_NAME=csv-merger
readonly BUNDLE_DIR="olm-catalog/kubevirt-hyperconverged/2.1.0"
readonly CSV_FILE_PATH="${BUNDLE_DIR}/kubevirt-hyperconverged-operator.v2.1.0.clusterserviceversion.yaml"
readonly TEMP_CSV_FILE_PATH="CSVs/kubevirt-hyperconverged-operator.v2.1.0.clusterserviceversion.yaml"


if [ -z "$MANUAL_BUILD" ]
then
  hco_image_csv=$(echo ${HYPERCONVERGED_CLUSTER_OPERATOR_BUILD_INFO_JSON} | python3 -c 'import json,sys;obj=json.load(sys.stdin);print(obj["extra"]["image"]["index"]["pull"][1])')
  hco_image_pipeline="${HYPERCONVERGED_CLUSTER_OPERATOR_IMAGE_PULL_URL:?}"
  ims_v2v_image=$(echo ${KUBEVIRT_V2V_CONVERSION_BUILD_INFO_JSON} | python3 -c 'import json,sys;obj=json.load(sys.stdin);print(obj["extra"]["image"]["index"]["pull"][1])')
  ims_vmware_image=$(echo ${KUBEVIRT_VMWARE_BUILD_INFO_JSON} | python3 -c 'import json,sys;obj=json.load(sys.stdin);print(obj["extra"]["image"]["index"]["pull"][1])')
else
  echo "!!! Manual execution !!!"
  python update_env_vars.py
  source downstream_vars
  export $(cut -d= -f1 downstream_vars)
  hco_image_csv=$(echo ${HYPERCONVERGED_CLUSTER_OPERATOR_BUILD_INFO_JSON} | python3 -c 'import json,sys;obj=json.load(sys.stdin);print(obj["extra"]["image"]["index"]["pull"][1])')
  hco_image_pipeline=${hco_image_csv}
  ims_v2v_image=$(echo ${KUBEVIRT_V2V_CONVERSION_BUILD_INFO_JSON} | python3 -c 'import json,sys;obj=json.load(sys.stdin);print(obj["extra"]["image"]["index"]["pull"][1])')
  ims_vmware_image=$(echo ${KUBEVIRT_VMWARE_BUILD_INFO_JSON} | python3 -c 'import json,sys;obj=json.load(sys.stdin);print(obj["extra"]["image"]["index"]["pull"][1])')
fi

get_fcontent(){
    csv_path=$1
    if test -f "${csv_path}"; then
        cat ${csv_path}
        return
    fi
    echo "ERROR: ${csv_path} is missing."
    exit 1
}

clean_env(){
    rm -rf CSVs
    rm -rf CRDs
}

init_env(){
    clean_env
    mkdir CSVs
    mkdir CRDs
}



# Create 'CSVs' and 'CRDs' directories
init_env

# Create all CSV and CRDs files
python3 cnv-operators-csv-generator.py
if [[ $? != 0 ]]; then
    echo "ERROR: CSVs generation failed"
    exit 1
fi

cnaCsv=$(get_fcontent "CSVs/cluster-network-addons-operator-container.csv")
virtCsv=$(get_fcontent "CSVs/virt-operator-container.csv")
sspCsv=$(get_fcontent "CSVs/kubevirt-ssp-operator-container.csv")
cdiCsv=$(get_fcontent "CSVs/virt-cdi-operator-container.csv")
nmoCsv=$(get_fcontent "CSVs/node-maintenance-operator-container.csv")

specDescription=$(get_fcontent "description.txt")
specDisplayName="Container-native virtualization Operator"

# OC - HCO - Using all the other CSVs
run_with_oc(){
    oc run \
        "${CSV_MERGER_POD_NAME}" \
        -i -t \
        --serviceaccount='jenkins' \
        --quiet=true \
        --image="${hco_image_pipeline}" \
        --restart="Never" \
        --command -- /usr/local/bin/csv-merger \
        --cna-csv="${cnaCsv}" \
        --virt-csv="${virtCsv}" \
        --ssp-csv="${sspCsv}" \
        --cdi-csv="${cdiCsv}" \
        --nmo-csv="${nmoCsv}" \
	--ims-conversion-image-name="${ims_v2v_image}" \
	--ims-vmware-image-name="${ims_vmware_image}" \
        --operator-image-name="${hco_image_csv}" \
        --csv-version=2.1.0 \
        --spec-description="${specDescription}" \
        --spec-displayname="${specDisplayName}" \
    | sed -e "s/\r//" > "${TEMP_CSV_FILE_PATH}"

    cp CRDs/* "${BUNDLE_DIR}"
}

clean_pod() {
    oc delete pod --ignore-not-found "${CSV_MERGER_POD_NAME}" 2>/dev/null
}

# DOCKER - HCO - Using all the other CSVs
run_with_docker(){
    docker run \
        --rm --entrypoint=/usr/local/bin/csv-merger \
        "${hco_image_pipeline}" \
        --cna-csv="${cnaCsv}" \
        --virt-csv="${virtCsv}" \
        --ssp-csv="${sspCsv}" \
        --cdi-csv="${cdiCsv}" \
        --nmo-csv="${nmoCsv}" \
	--ims-conversion-image-name="${ims_v2v_image}" \
	--ims-vmware-image-name="${ims_vmware_image}" \
        --operator-image-name="${hco_image_csv}" \
        --csv-version=2.1.0 \
        --spec-description="${specDescription}" \
        --spec-displayname="${specDisplayName}" \
    | sed -e "s/\r//" > "${TEMP_CSV_FILE_PATH}"

    cp CRDs/* "${BUNDLE_DIR}"
}

if [[ -z "${MANUAL_BUILD}" ]]; then
  # TODO: Add kubectl
  if [ -x /usr/bin/oc ]; then
    clean_pod
    trap 'clean_pod' EXIT
    run_with_oc
  elif [ -x /usr/bin/docker ]; then
    run_with_docker
  else
    echo "ERROR: Nor oc or docker are installed."
    exit 1
  fi
else
  run_with_docker
fi

if  [ $(diff ${TEMP_CSV_FILE_PATH} ${CSV_FILE_PATH} | grep '[<>]' | wc -l) == 2 ] && \
    [ "$(diff ${TEMP_CSV_FILE_PATH} ${CSV_FILE_PATH} | grep -e '<*createdAt:')" != "" ]
then
    echo "The CSV has not changed"
else
    cp ${TEMP_CSV_FILE_PATH} ${CSV_FILE_PATH}
fi

clean_env

