#!/bin/bash

set -x

QUAY_REGISTRY="${QUAY_REGISTRY:-rh-osbs-operators}"
BUNDLE_VERSION="${BUNDLE_VERSION:-}"
QUAY_TOKEN="${QUAY_TOKEN:-}"

QUAY_USERNAME="${QUAY_USERNAME:-}"
QUAY_PASSWORD="${QUAY_PASSWORD:-}"

if [ -z "${QUAY_TOKEN}" ]; then
    if [ -z "${QUAY_USERNAME}" ]; then
	echo "QUAY_USERNAME is unset"
	exit 1
    fi

    if [ -z "${QUAY_PASSWORD}" ]; then
	echo "QUAY_PASSWORD is unset"
	exit 1
    fi

    QUAY_TOKEN=$(curl -sH "Content-Type: application/json" -XPOST https://quay.io/cnr/api/v1/users/login -d '
{
    "user": {
        "username": "'"${QUAY_USERNAME}"'",
        "password": "'"${QUAY_PASSWORD}"'"
    }
}' | jq -r '.token')

    echo $QUAY_TOKEN
    if [ "${QUAY_TOKEN}" == "null" ]; then
	echo "QUAY_TOKEN was 'null'.  Did you enter the correct quay Username & Password?"
	exit 1
    fi
fi

if [ -z "${BUNDLE_VERSION}" ]; then
    BUNDLE_VERSION=$(oc get csc -n openshift-marketplace hco-catalogsource-config -o jsonpath='{.status.packageRepositioryVersions.kubevirt-hyperconverged}')
fi

if [ -z "${BUNDLE_VERSION}" ]; then
    curl -H "Authorization: $QUAY_TOKEN" https://quay.io/cnr/api/v1/packages/${QUAY_REGISTRY}/kubevirt-hyperconverged/ | jq '.[]["release"]'
    echo "Provide a BUNDLE_VERSION"
    read BUNDLE_VERSION
fi

curl -H "Authorization: $QUAY_TOKEN" https://quay.io/cnr/api/v1/packages/${QUAY_REGISTRY}/kubevirt-hyperconverged/${BUNDLE_VERSION}/helm/pull --output hco-bundle.tar.gz 

rm -rf /tmp/hco-bundle
mkdir /tmp/hco-bundle
tar -xvf hco-bundle.tar.gz -C /tmp/hco-bundle

bundle=$(ls /tmp/hco-bundle)

cat /tmp/hco-bundle/${bundle}/2.1.0/kubevirt-hyperconverged-operator.v2.1.0.clusterserviceversion.yaml | grep -E ".+(:v[0-9\.\-]*)"
