/*
Copyright 2020 The hostpath provisioner operator Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/hostpath-provisioner-operator/pkg/apis/hostpathprovisioner/v1beta1"
)

// HostPathProvisionerLister helps list HostPathProvisioners.
// All objects returned here must be treated as read-only.
type HostPathProvisionerLister interface {
	// List lists all HostPathProvisioners in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.HostPathProvisioner, err error)
	// Get retrieves the HostPathProvisioner from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.HostPathProvisioner, error)
	HostPathProvisionerListerExpansion
}

// hostPathProvisionerLister implements the HostPathProvisionerLister interface.
type hostPathProvisionerLister struct {
	indexer cache.Indexer
}

// NewHostPathProvisionerLister returns a new HostPathProvisionerLister.
func NewHostPathProvisionerLister(indexer cache.Indexer) HostPathProvisionerLister {
	return &hostPathProvisionerLister{indexer: indexer}
}

// List lists all HostPathProvisioners in the indexer.
func (s *hostPathProvisionerLister) List(selector labels.Selector) (ret []*v1beta1.HostPathProvisioner, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.HostPathProvisioner))
	})
	return ret, err
}

// Get retrieves the HostPathProvisioner from the index for a given name.
func (s *hostPathProvisionerLister) Get(name string) (*v1beta1.HostPathProvisioner, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("hostpathprovisioner"), name)
	}
	return obj.(*v1beta1.HostPathProvisioner), nil
}
