/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/MarSik/kubevirt-ssp-operator/pkg/apis/kubevirt/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// KubevirtCommonTemplatesBundleLister helps list KubevirtCommonTemplatesBundles.
type KubevirtCommonTemplatesBundleLister interface {
	// List lists all KubevirtCommonTemplatesBundles in the indexer.
	List(selector labels.Selector) (ret []*v1.KubevirtCommonTemplatesBundle, err error)
	// KubevirtCommonTemplatesBundles returns an object that can list and get KubevirtCommonTemplatesBundles.
	KubevirtCommonTemplatesBundles(namespace string) KubevirtCommonTemplatesBundleNamespaceLister
	KubevirtCommonTemplatesBundleListerExpansion
}

// kubevirtCommonTemplatesBundleLister implements the KubevirtCommonTemplatesBundleLister interface.
type kubevirtCommonTemplatesBundleLister struct {
	indexer cache.Indexer
}

// NewKubevirtCommonTemplatesBundleLister returns a new KubevirtCommonTemplatesBundleLister.
func NewKubevirtCommonTemplatesBundleLister(indexer cache.Indexer) KubevirtCommonTemplatesBundleLister {
	return &kubevirtCommonTemplatesBundleLister{indexer: indexer}
}

// List lists all KubevirtCommonTemplatesBundles in the indexer.
func (s *kubevirtCommonTemplatesBundleLister) List(selector labels.Selector) (ret []*v1.KubevirtCommonTemplatesBundle, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.KubevirtCommonTemplatesBundle))
	})
	return ret, err
}

// KubevirtCommonTemplatesBundles returns an object that can list and get KubevirtCommonTemplatesBundles.
func (s *kubevirtCommonTemplatesBundleLister) KubevirtCommonTemplatesBundles(namespace string) KubevirtCommonTemplatesBundleNamespaceLister {
	return kubevirtCommonTemplatesBundleNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// KubevirtCommonTemplatesBundleNamespaceLister helps list and get KubevirtCommonTemplatesBundles.
type KubevirtCommonTemplatesBundleNamespaceLister interface {
	// List lists all KubevirtCommonTemplatesBundles in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.KubevirtCommonTemplatesBundle, err error)
	// Get retrieves the KubevirtCommonTemplatesBundle from the indexer for a given namespace and name.
	Get(name string) (*v1.KubevirtCommonTemplatesBundle, error)
	KubevirtCommonTemplatesBundleNamespaceListerExpansion
}

// kubevirtCommonTemplatesBundleNamespaceLister implements the KubevirtCommonTemplatesBundleNamespaceLister
// interface.
type kubevirtCommonTemplatesBundleNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all KubevirtCommonTemplatesBundles in the indexer for a given namespace.
func (s kubevirtCommonTemplatesBundleNamespaceLister) List(selector labels.Selector) (ret []*v1.KubevirtCommonTemplatesBundle, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.KubevirtCommonTemplatesBundle))
	})
	return ret, err
}

// Get retrieves the KubevirtCommonTemplatesBundle from the indexer for a given namespace and name.
func (s kubevirtCommonTemplatesBundleNamespaceLister) Get(name string) (*v1.KubevirtCommonTemplatesBundle, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("kubevirtcommontemplatesbundle"), name)
	}
	return obj.(*v1.KubevirtCommonTemplatesBundle), nil
}
