/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
	v1alpha1 "kubevirt.io/containerized-data-importer/pkg/apis/upload/v1alpha1"
	scheme "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned/scheme"
)

// UploadTokenRequestsGetter has a method to return a UploadTokenRequestInterface.
// A group's client should implement this interface.
type UploadTokenRequestsGetter interface {
	UploadTokenRequests(namespace string) UploadTokenRequestInterface
}

// UploadTokenRequestInterface has methods to work with UploadTokenRequest resources.
type UploadTokenRequestInterface interface {
	Create(*v1alpha1.UploadTokenRequest) (*v1alpha1.UploadTokenRequest, error)
	Update(*v1alpha1.UploadTokenRequest) (*v1alpha1.UploadTokenRequest, error)
	UpdateStatus(*v1alpha1.UploadTokenRequest) (*v1alpha1.UploadTokenRequest, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.UploadTokenRequest, error)
	List(opts v1.ListOptions) (*v1alpha1.UploadTokenRequestList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.UploadTokenRequest, err error)
	UploadTokenRequestExpansion
}

// uploadTokenRequests implements UploadTokenRequestInterface
type uploadTokenRequests struct {
	client rest.Interface
	ns     string
}

// newUploadTokenRequests returns a UploadTokenRequests
func newUploadTokenRequests(c *UploadV1alpha1Client, namespace string) *uploadTokenRequests {
	return &uploadTokenRequests{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the uploadTokenRequest, and returns the corresponding uploadTokenRequest object, and an error if there is any.
func (c *uploadTokenRequests) Get(name string, options v1.GetOptions) (result *v1alpha1.UploadTokenRequest, err error) {
	result = &v1alpha1.UploadTokenRequest{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of UploadTokenRequests that match those selectors.
func (c *uploadTokenRequests) List(opts v1.ListOptions) (result *v1alpha1.UploadTokenRequestList, err error) {
	result = &v1alpha1.UploadTokenRequestList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested uploadTokenRequests.
func (c *uploadTokenRequests) Watch(opts v1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a uploadTokenRequest and creates it.  Returns the server's representation of the uploadTokenRequest, and an error, if there is any.
func (c *uploadTokenRequests) Create(uploadTokenRequest *v1alpha1.UploadTokenRequest) (result *v1alpha1.UploadTokenRequest, err error) {
	result = &v1alpha1.UploadTokenRequest{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		Body(uploadTokenRequest).
		Do().
		Into(result)
	return
}

// Update takes the representation of a uploadTokenRequest and updates it. Returns the server's representation of the uploadTokenRequest, and an error, if there is any.
func (c *uploadTokenRequests) Update(uploadTokenRequest *v1alpha1.UploadTokenRequest) (result *v1alpha1.UploadTokenRequest, err error) {
	result = &v1alpha1.UploadTokenRequest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		Name(uploadTokenRequest.Name).
		Body(uploadTokenRequest).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *uploadTokenRequests) UpdateStatus(uploadTokenRequest *v1alpha1.UploadTokenRequest) (result *v1alpha1.UploadTokenRequest, err error) {
	result = &v1alpha1.UploadTokenRequest{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		Name(uploadTokenRequest.Name).
		SubResource("status").
		Body(uploadTokenRequest).
		Do().
		Into(result)
	return
}

// Delete takes name of the uploadTokenRequest and deletes it. Returns an error if one occurs.
func (c *uploadTokenRequests) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *uploadTokenRequests) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched uploadTokenRequest.
func (c *uploadTokenRequests) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.UploadTokenRequest, err error) {
	result = &v1alpha1.UploadTokenRequest{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("uploadtokenrequests").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
