/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	kubevirtv1 "github.com/MarSik/kubevirt-ssp-operator/pkg/apis/kubevirt/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeKubevirtNodeLabellerBundles implements KubevirtNodeLabellerBundleInterface
type FakeKubevirtNodeLabellerBundles struct {
	Fake *FakeKubevirtV1
	ns   string
}

var kubevirtnodelabellerbundlesResource = schema.GroupVersionResource{Group: "kubevirt.io", Version: "v1", Resource: "kubevirtnodelabellerbundles"}

var kubevirtnodelabellerbundlesKind = schema.GroupVersionKind{Group: "kubevirt.io", Version: "v1", Kind: "KubevirtNodeLabellerBundle"}

// Get takes name of the kubevirtNodeLabellerBundle, and returns the corresponding kubevirtNodeLabellerBundle object, and an error if there is any.
func (c *FakeKubevirtNodeLabellerBundles) Get(name string, options v1.GetOptions) (result *kubevirtv1.KubevirtNodeLabellerBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(kubevirtnodelabellerbundlesResource, c.ns, name), &kubevirtv1.KubevirtNodeLabellerBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtNodeLabellerBundle), err
}

// List takes label and field selectors, and returns the list of KubevirtNodeLabellerBundles that match those selectors.
func (c *FakeKubevirtNodeLabellerBundles) List(opts v1.ListOptions) (result *kubevirtv1.KubevirtNodeLabellerBundleList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(kubevirtnodelabellerbundlesResource, kubevirtnodelabellerbundlesKind, c.ns, opts), &kubevirtv1.KubevirtNodeLabellerBundleList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &kubevirtv1.KubevirtNodeLabellerBundleList{ListMeta: obj.(*kubevirtv1.KubevirtNodeLabellerBundleList).ListMeta}
	for _, item := range obj.(*kubevirtv1.KubevirtNodeLabellerBundleList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kubevirtNodeLabellerBundles.
func (c *FakeKubevirtNodeLabellerBundles) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(kubevirtnodelabellerbundlesResource, c.ns, opts))

}

// Create takes the representation of a kubevirtNodeLabellerBundle and creates it.  Returns the server's representation of the kubevirtNodeLabellerBundle, and an error, if there is any.
func (c *FakeKubevirtNodeLabellerBundles) Create(kubevirtNodeLabellerBundle *kubevirtv1.KubevirtNodeLabellerBundle) (result *kubevirtv1.KubevirtNodeLabellerBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(kubevirtnodelabellerbundlesResource, c.ns, kubevirtNodeLabellerBundle), &kubevirtv1.KubevirtNodeLabellerBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtNodeLabellerBundle), err
}

// Update takes the representation of a kubevirtNodeLabellerBundle and updates it. Returns the server's representation of the kubevirtNodeLabellerBundle, and an error, if there is any.
func (c *FakeKubevirtNodeLabellerBundles) Update(kubevirtNodeLabellerBundle *kubevirtv1.KubevirtNodeLabellerBundle) (result *kubevirtv1.KubevirtNodeLabellerBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(kubevirtnodelabellerbundlesResource, c.ns, kubevirtNodeLabellerBundle), &kubevirtv1.KubevirtNodeLabellerBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtNodeLabellerBundle), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKubevirtNodeLabellerBundles) UpdateStatus(kubevirtNodeLabellerBundle *kubevirtv1.KubevirtNodeLabellerBundle) (*kubevirtv1.KubevirtNodeLabellerBundle, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(kubevirtnodelabellerbundlesResource, "status", c.ns, kubevirtNodeLabellerBundle), &kubevirtv1.KubevirtNodeLabellerBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtNodeLabellerBundle), err
}

// Delete takes name of the kubevirtNodeLabellerBundle and deletes it. Returns an error if one occurs.
func (c *FakeKubevirtNodeLabellerBundles) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(kubevirtnodelabellerbundlesResource, c.ns, name), &kubevirtv1.KubevirtNodeLabellerBundle{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKubevirtNodeLabellerBundles) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(kubevirtnodelabellerbundlesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &kubevirtv1.KubevirtNodeLabellerBundleList{})
	return err
}

// Patch applies the patch and returns the patched kubevirtNodeLabellerBundle.
func (c *FakeKubevirtNodeLabellerBundles) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *kubevirtv1.KubevirtNodeLabellerBundle, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(kubevirtnodelabellerbundlesResource, c.ns, name, data, subresources...), &kubevirtv1.KubevirtNodeLabellerBundle{})

	if obj == nil {
		return nil, err
	}
	return obj.(*kubevirtv1.KubevirtNodeLabellerBundle), err
}
