/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/MarSik/kubevirt-ssp-operator/pkg/apis/kubevirt/v1"
	scheme "github.com/MarSik/kubevirt-ssp-operator/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KubevirtNodeLabellerBundlesGetter has a method to return a KubevirtNodeLabellerBundleInterface.
// A group's client should implement this interface.
type KubevirtNodeLabellerBundlesGetter interface {
	KubevirtNodeLabellerBundles(namespace string) KubevirtNodeLabellerBundleInterface
}

// KubevirtNodeLabellerBundleInterface has methods to work with KubevirtNodeLabellerBundle resources.
type KubevirtNodeLabellerBundleInterface interface {
	Create(*v1.KubevirtNodeLabellerBundle) (*v1.KubevirtNodeLabellerBundle, error)
	Update(*v1.KubevirtNodeLabellerBundle) (*v1.KubevirtNodeLabellerBundle, error)
	UpdateStatus(*v1.KubevirtNodeLabellerBundle) (*v1.KubevirtNodeLabellerBundle, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.KubevirtNodeLabellerBundle, error)
	List(opts metav1.ListOptions) (*v1.KubevirtNodeLabellerBundleList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubevirtNodeLabellerBundle, err error)
	KubevirtNodeLabellerBundleExpansion
}

// kubevirtNodeLabellerBundles implements KubevirtNodeLabellerBundleInterface
type kubevirtNodeLabellerBundles struct {
	client rest.Interface
	ns     string
}

// newKubevirtNodeLabellerBundles returns a KubevirtNodeLabellerBundles
func newKubevirtNodeLabellerBundles(c *KubevirtV1Client, namespace string) *kubevirtNodeLabellerBundles {
	return &kubevirtNodeLabellerBundles{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the kubevirtNodeLabellerBundle, and returns the corresponding kubevirtNodeLabellerBundle object, and an error if there is any.
func (c *kubevirtNodeLabellerBundles) Get(name string, options metav1.GetOptions) (result *v1.KubevirtNodeLabellerBundle, err error) {
	result = &v1.KubevirtNodeLabellerBundle{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KubevirtNodeLabellerBundles that match those selectors.
func (c *kubevirtNodeLabellerBundles) List(opts metav1.ListOptions) (result *v1.KubevirtNodeLabellerBundleList, err error) {
	result = &v1.KubevirtNodeLabellerBundleList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kubevirtNodeLabellerBundles.
func (c *kubevirtNodeLabellerBundles) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Watch()
}

// Create takes the representation of a kubevirtNodeLabellerBundle and creates it.  Returns the server's representation of the kubevirtNodeLabellerBundle, and an error, if there is any.
func (c *kubevirtNodeLabellerBundles) Create(kubevirtNodeLabellerBundle *v1.KubevirtNodeLabellerBundle) (result *v1.KubevirtNodeLabellerBundle, err error) {
	result = &v1.KubevirtNodeLabellerBundle{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		Body(kubevirtNodeLabellerBundle).
		Do().
		Into(result)
	return
}

// Update takes the representation of a kubevirtNodeLabellerBundle and updates it. Returns the server's representation of the kubevirtNodeLabellerBundle, and an error, if there is any.
func (c *kubevirtNodeLabellerBundles) Update(kubevirtNodeLabellerBundle *v1.KubevirtNodeLabellerBundle) (result *v1.KubevirtNodeLabellerBundle, err error) {
	result = &v1.KubevirtNodeLabellerBundle{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		Name(kubevirtNodeLabellerBundle.Name).
		Body(kubevirtNodeLabellerBundle).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *kubevirtNodeLabellerBundles) UpdateStatus(kubevirtNodeLabellerBundle *v1.KubevirtNodeLabellerBundle) (result *v1.KubevirtNodeLabellerBundle, err error) {
	result = &v1.KubevirtNodeLabellerBundle{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		Name(kubevirtNodeLabellerBundle.Name).
		SubResource("status").
		Body(kubevirtNodeLabellerBundle).
		Do().
		Into(result)
	return
}

// Delete takes name of the kubevirtNodeLabellerBundle and deletes it. Returns an error if one occurs.
func (c *kubevirtNodeLabellerBundles) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kubevirtNodeLabellerBundles) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched kubevirtNodeLabellerBundle.
func (c *kubevirtNodeLabellerBundles) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubevirtNodeLabellerBundle, err error) {
	result = &v1.KubevirtNodeLabellerBundle{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("kubevirtnodelabellerbundles").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
