/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1

import (
	time "time"

	kubevirtv1 "github.com/MarSik/kubevirt-ssp-operator/pkg/apis/kubevirt/v1"
	versioned "github.com/MarSik/kubevirt-ssp-operator/pkg/client/clientset/versioned"
	internalinterfaces "github.com/MarSik/kubevirt-ssp-operator/pkg/client/informers/externalversions/internalinterfaces"
	v1 "github.com/MarSik/kubevirt-ssp-operator/pkg/client/listers/kubevirt/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// KubevirtCommonTemplatesBundleInformer provides access to a shared informer and lister for
// KubevirtCommonTemplatesBundles.
type KubevirtCommonTemplatesBundleInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1.KubevirtCommonTemplatesBundleLister
}

type kubevirtCommonTemplatesBundleInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewKubevirtCommonTemplatesBundleInformer constructs a new informer for KubevirtCommonTemplatesBundle type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewKubevirtCommonTemplatesBundleInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredKubevirtCommonTemplatesBundleInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredKubevirtCommonTemplatesBundleInformer constructs a new informer for KubevirtCommonTemplatesBundle type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredKubevirtCommonTemplatesBundleInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options metav1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KubevirtV1().KubevirtCommonTemplatesBundles(namespace).List(options)
			},
			WatchFunc: func(options metav1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.KubevirtV1().KubevirtCommonTemplatesBundles(namespace).Watch(options)
			},
		},
		&kubevirtv1.KubevirtCommonTemplatesBundle{},
		resyncPeriod,
		indexers,
	)
}

func (f *kubevirtCommonTemplatesBundleInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredKubevirtCommonTemplatesBundleInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *kubevirtCommonTemplatesBundleInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&kubevirtv1.KubevirtCommonTemplatesBundle{}, f.defaultInformer)
}

func (f *kubevirtCommonTemplatesBundleInformer) Lister() v1.KubevirtCommonTemplatesBundleLister {
	return v1.NewKubevirtCommonTemplatesBundleLister(f.Informer().GetIndexer())
}
