# Design

The system is implemented as an k8s operator using the [operator-sdk](https://github.com/operator-framework/operator-sdk)
but is deployed as a DaemonSet instead of Deployment with [filtering](https://github.com/operator-framework/operator-sdk/blob/master/doc/user/event-filtering.md) only events for the DaemonSet pod node.

There are two controllers one for [Node](https://godoc.org/k8s.io/api/core/v1#Node)
and the other for the CRD NodeNeworkState.

## Components

- [Node Controller](developer-guide-node.md) - developer guide and design of `Node` handler.
- [NodeNetworkState Controller](developer-guide-state.md) - developer guide and design of `NodeNetworkState` handler.
- [NodeNetworkConfigurationPolicy Controller](developer-guide-policy.md) - developer guide and design of `NodeNetworkConfigurationPolicy` handler.

# Development

[Development guide](developer-guide-commands.md) is a go-to reference point for
development helper commands, building, testing, container images and local
cluster.

# Releasing

To cut a release, push images to quay and publish it on GitHub
the command `make release` do all this automatically, the version  is at
`version/version.go` and the description at `version/description`.

So the step would be:
 - Change version/version.go and versions/description
 - Create a PR to review it
 - Merge it to master
 - Call `make release` from master

The environment variable GITHUB_TOKEN is needed to publish at GitHub and it must
point to a token generated by github to access projects.
