#!/bin/bash

set -e

if [ -z "$1" ]; then
	echo "usage: $0 tag (WITHOUT the leading 'v')"
	exit 1
fi
TAG="${1}"

curl -L https://github.com/ksimon1/kubevirt-node-labeller/archive/v${TAG}.tar.gz -o kubevirt-node-labeller-${TAG}.tar.gz

export VERSION="v${TAG}"
# hack to avoid expansion of GOPATH
export GOPATH='${GOPATH}'
envsubst < Dockerfile.in > Dockerfile