#!/bin/bash

set -e

if [ -z "$1" ]; then
	echo "usage: $0 tag (WITHOUT the leading 'v')"
	exit 1
fi
export TAG="${1}"

curl -L https://github.com/fromanirh/kvm-info-nfd-plugin/archive/v${TAG}.tar.gz -o kvm-info-nfd-plugin-${TAG}.tar.gz

export VERSION="v${TAG}"
# hack to avoid expansion of GOPATH
export GOPATH='${GOPATH}'
envsubst < Dockerfile.in > Dockerfile
