#!/bin/bash

set -e

if [ -z "$1" ]; then
	echo "usage: $0 tag (WITHOUT the leading 'v')"
	exit 1
fi
TAG="${1}"

curl -L https://github.com/fromanirh/kubevirt-template-validator/archive/v${TAG}.tar.gz -o kubevirt-template-validator-${TAG}.tar.gz

export VERSION="v${TAG}"
# hack to avoid expansion of GOPATH
export GOPATH='${GOPATH}'
envsubst < Dockerfile.in > Dockerfile
