# Must be called from dist-git root directory

set -ex

if [ x${UPSTREAM_TAG} = x ] ; then
  echo Set UPSTREAM_TAG variable
  exit 1
fi

sed -i "s/^GIT_TAG=.*$/GIT_TAG=${UPSTREAM_TAG}/g" upstream/build-backend.sh # sources are from .tgz, not cloned git repo
sed -i "s/^yarn install.*$/yarn install --offline --use-yarnrc \.\/\.yarnrc/g" upstream/build-frontend.sh # helps debugging in local Docker environment

# Based on: https://errata.devel.redhat.com/package/show/kubevirt-v2v-conversion-container
# Future work: Following V2V images will be either deployed outside of the web-ui or images will be configured via application configuration
#sed -i "s/^const REGISTRY_V2V_URL.*$/const REGISTRY_V2V_URL = 'registry.connect.redhat.com\/';/g" upstream/frontend/public/kubevirt/components/init.js
#sed -i "s/^const REGISTRY_V2V_CONVERSION_TAG.*$/const REGISTRY_V2V_CONVERSION_TAG = '2.0.0';/g" upstream/frontend/public/kubevirt/components/init.js
#sed -i "s/^const REGISTRY_V2V_VMWARE_TAG.*$/const REGISTRY_V2V_VMWARE_TAG = '2.0.0';/g" upstream/frontend/public/kubevirt/components/init.js

