// Code generated by protoc-gen-go. DO NOT EDIT.
// source: hapi/services/tiller.proto

/*
Package services is a generated protocol buffer package.

It is generated from these files:
	hapi/services/tiller.proto

It has these top-level messages:
	ListReleasesRequest
	ListSort
	ListReleasesResponse
	GetReleaseStatusRequest
	GetReleaseStatusResponse
	GetReleaseContentRequest
	GetReleaseContentResponse
	UpdateReleaseRequest
	UpdateReleaseResponse
	RollbackReleaseRequest
	RollbackReleaseResponse
	InstallReleaseRequest
	InstallReleaseResponse
	UninstallReleaseRequest
	UninstallReleaseResponse
	GetVersionRequest
	GetVersionResponse
	GetHistoryRequest
	GetHistoryResponse
	TestReleaseRequest
	TestReleaseResponse
*/
package services

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import hapi_chart3 "k8s.io/helm/pkg/proto/hapi/chart"
import hapi_chart "k8s.io/helm/pkg/proto/hapi/chart"
import hapi_release5 "k8s.io/helm/pkg/proto/hapi/release"
import hapi_release4 "k8s.io/helm/pkg/proto/hapi/release"
import hapi_release1 "k8s.io/helm/pkg/proto/hapi/release"
import hapi_release3 "k8s.io/helm/pkg/proto/hapi/release"
import hapi_version "k8s.io/helm/pkg/proto/hapi/version"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// SortBy defines sort operations.
type ListSort_SortBy int32

const (
	ListSort_UNKNOWN       ListSort_SortBy = 0
	ListSort_NAME          ListSort_SortBy = 1
	ListSort_LAST_RELEASED ListSort_SortBy = 2
	ListSort_CHART_NAME    ListSort_SortBy = 3
)

var ListSort_SortBy_name = map[int32]string{
	0: "UNKNOWN",
	1: "NAME",
	2: "LAST_RELEASED",
	3: "CHART_NAME",
}
var ListSort_SortBy_value = map[string]int32{
	"UNKNOWN":       0,
	"NAME":          1,
	"LAST_RELEASED": 2,
	"CHART_NAME":    3,
}

func (x ListSort_SortBy) String() string {
	return proto.EnumName(ListSort_SortBy_name, int32(x))
}
func (ListSort_SortBy) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 0} }

// SortOrder defines sort orders to augment sorting operations.
type ListSort_SortOrder int32

const (
	ListSort_ASC  ListSort_SortOrder = 0
	ListSort_DESC ListSort_SortOrder = 1
)

var ListSort_SortOrder_name = map[int32]string{
	0: "ASC",
	1: "DESC",
}
var ListSort_SortOrder_value = map[string]int32{
	"ASC":  0,
	"DESC": 1,
}

func (x ListSort_SortOrder) String() string {
	return proto.EnumName(ListSort_SortOrder_name, int32(x))
}
func (ListSort_SortOrder) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1, 1} }

// ListReleasesRequest requests a list of releases.
//
// Releases can be retrieved in chunks by setting limit and offset.
//
// Releases can be sorted according to a few pre-determined sort strategies.
type ListReleasesRequest struct {
	// Limit is the maximum number of releases to be returned.
	Limit int64 `protobuf:"varint,1,opt,name=limit" json:"limit,omitempty"`
	// Offset is the last release name that was seen. The next listing
	// operation will start with the name after this one.
	// Example: If list one returns albert, bernie, carl, and sets 'next: dennis'.
	// dennis is the offset. Supplying 'dennis' for the next request should
	// cause the next batch to return a set of results starting with 'dennis'.
	Offset string `protobuf:"bytes,2,opt,name=offset" json:"offset,omitempty"`
	// SortBy is the sort field that the ListReleases server should sort data before returning.
	SortBy ListSort_SortBy `protobuf:"varint,3,opt,name=sort_by,json=sortBy,enum=hapi.services.tiller.ListSort_SortBy" json:"sort_by,omitempty"`
	// Filter is a regular expression used to filter which releases should be listed.
	//
	// Anything that matches the regexp will be included in the results.
	Filter string `protobuf:"bytes,4,opt,name=filter" json:"filter,omitempty"`
	// SortOrder is the ordering directive used for sorting.
	SortOrder   ListSort_SortOrder          `protobuf:"varint,5,opt,name=sort_order,json=sortOrder,enum=hapi.services.tiller.ListSort_SortOrder" json:"sort_order,omitempty"`
	StatusCodes []hapi_release3.Status_Code `protobuf:"varint,6,rep,packed,name=status_codes,json=statusCodes,enum=hapi.release.Status_Code" json:"status_codes,omitempty"`
	// Namespace is the filter to select releases only from a specific namespace.
	Namespace string `protobuf:"bytes,7,opt,name=namespace" json:"namespace,omitempty"`
}

func (m *ListReleasesRequest) Reset()                    { *m = ListReleasesRequest{} }
func (m *ListReleasesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListReleasesRequest) ProtoMessage()               {}
func (*ListReleasesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ListReleasesRequest) GetLimit() int64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *ListReleasesRequest) GetOffset() string {
	if m != nil {
		return m.Offset
	}
	return ""
}

func (m *ListReleasesRequest) GetSortBy() ListSort_SortBy {
	if m != nil {
		return m.SortBy
	}
	return ListSort_UNKNOWN
}

func (m *ListReleasesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListReleasesRequest) GetSortOrder() ListSort_SortOrder {
	if m != nil {
		return m.SortOrder
	}
	return ListSort_ASC
}

func (m *ListReleasesRequest) GetStatusCodes() []hapi_release3.Status_Code {
	if m != nil {
		return m.StatusCodes
	}
	return nil
}

func (m *ListReleasesRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// ListSort defines sorting fields on a release list.
type ListSort struct {
}

func (m *ListSort) Reset()                    { *m = ListSort{} }
func (m *ListSort) String() string            { return proto.CompactTextString(m) }
func (*ListSort) ProtoMessage()               {}
func (*ListSort) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// ListReleasesResponse is a list of releases.
type ListReleasesResponse struct {
	// Count is the expected total number of releases to be returned.
	Count int64 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
	// Next is the name of the next release. If this is other than an empty
	// string, it means there are more results.
	Next string `protobuf:"bytes,2,opt,name=next" json:"next,omitempty"`
	// Total is the total number of queryable releases.
	Total int64 `protobuf:"varint,3,opt,name=total" json:"total,omitempty"`
	// Releases is the list of found release objects.
	Releases []*hapi_release5.Release `protobuf:"bytes,4,rep,name=releases" json:"releases,omitempty"`
}

func (m *ListReleasesResponse) Reset()                    { *m = ListReleasesResponse{} }
func (m *ListReleasesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListReleasesResponse) ProtoMessage()               {}
func (*ListReleasesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ListReleasesResponse) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *ListReleasesResponse) GetNext() string {
	if m != nil {
		return m.Next
	}
	return ""
}

func (m *ListReleasesResponse) GetTotal() int64 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *ListReleasesResponse) GetReleases() []*hapi_release5.Release {
	if m != nil {
		return m.Releases
	}
	return nil
}

// GetReleaseStatusRequest is a request to get the status of a release.
type GetReleaseStatusRequest struct {
	// Name is the name of the release
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Version is the version of the release
	Version int32 `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
}

func (m *GetReleaseStatusRequest) Reset()                    { *m = GetReleaseStatusRequest{} }
func (m *GetReleaseStatusRequest) String() string            { return proto.CompactTextString(m) }
func (*GetReleaseStatusRequest) ProtoMessage()               {}
func (*GetReleaseStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *GetReleaseStatusRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetReleaseStatusRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// GetReleaseStatusResponse is the response indicating the status of the named release.
type GetReleaseStatusResponse struct {
	// Name is the name of the release.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Info contains information about the release.
	Info *hapi_release4.Info `protobuf:"bytes,2,opt,name=info" json:"info,omitempty"`
	// Namespace the release was released into
	Namespace string `protobuf:"bytes,3,opt,name=namespace" json:"namespace,omitempty"`
}

func (m *GetReleaseStatusResponse) Reset()                    { *m = GetReleaseStatusResponse{} }
func (m *GetReleaseStatusResponse) String() string            { return proto.CompactTextString(m) }
func (*GetReleaseStatusResponse) ProtoMessage()               {}
func (*GetReleaseStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *GetReleaseStatusResponse) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetReleaseStatusResponse) GetInfo() *hapi_release4.Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *GetReleaseStatusResponse) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// GetReleaseContentRequest is a request to get the contents of a release.
type GetReleaseContentRequest struct {
	// The name of the release
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Version is the version of the release
	Version int32 `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
}

func (m *GetReleaseContentRequest) Reset()                    { *m = GetReleaseContentRequest{} }
func (m *GetReleaseContentRequest) String() string            { return proto.CompactTextString(m) }
func (*GetReleaseContentRequest) ProtoMessage()               {}
func (*GetReleaseContentRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *GetReleaseContentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetReleaseContentRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// GetReleaseContentResponse is a response containing the contents of a release.
type GetReleaseContentResponse struct {
	// The release content
	Release *hapi_release5.Release `protobuf:"bytes,1,opt,name=release" json:"release,omitempty"`
}

func (m *GetReleaseContentResponse) Reset()                    { *m = GetReleaseContentResponse{} }
func (m *GetReleaseContentResponse) String() string            { return proto.CompactTextString(m) }
func (*GetReleaseContentResponse) ProtoMessage()               {}
func (*GetReleaseContentResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *GetReleaseContentResponse) GetRelease() *hapi_release5.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

// UpdateReleaseRequest updates a release.
type UpdateReleaseRequest struct {
	// The name of the release
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Chart is the protobuf representation of a chart.
	Chart *hapi_chart3.Chart `protobuf:"bytes,2,opt,name=chart" json:"chart,omitempty"`
	// Values is a string containing (unparsed) YAML values.
	Values *hapi_chart.Config `protobuf:"bytes,3,opt,name=values" json:"values,omitempty"`
	// dry_run, if true, will run through the release logic, but neither create
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun" json:"dry_run,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the upgrade.
	DisableHooks bool `protobuf:"varint,5,opt,name=disable_hooks,json=disableHooks" json:"disable_hooks,omitempty"`
	// Performs pods restart for resources if applicable
	Recreate bool `protobuf:"varint,6,opt,name=recreate" json:"recreate,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,7,opt,name=timeout" json:"timeout,omitempty"`
	// ResetValues will cause Tiller to ignore stored values, resetting to default values.
	ResetValues bool `protobuf:"varint,8,opt,name=reset_values,json=resetValues" json:"reset_values,omitempty"`
	// wait, if true, will wait until all Pods, PVCs, and Services are in a ready state
	// before marking the release as successful. It will wait for as long as timeout
	Wait bool `protobuf:"varint,9,opt,name=wait" json:"wait,omitempty"`
	// ReuseValues will cause Tiller to reuse the values from the last release.
	// This is ignored if reset_values is set.
	ReuseValues bool `protobuf:"varint,10,opt,name=reuse_values,json=reuseValues" json:"reuse_values,omitempty"`
	// Force resource update through delete/recreate if needed.
	Force bool `protobuf:"varint,11,opt,name=force" json:"force,omitempty"`
	// Description, if set, will set the description for the updated release
	Description string `protobuf:"bytes,12,opt,name=description" json:"description,omitempty"`
}

func (m *UpdateReleaseRequest) Reset()                    { *m = UpdateReleaseRequest{} }
func (m *UpdateReleaseRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateReleaseRequest) ProtoMessage()               {}
func (*UpdateReleaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *UpdateReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateReleaseRequest) GetChart() *hapi_chart3.Chart {
	if m != nil {
		return m.Chart
	}
	return nil
}

func (m *UpdateReleaseRequest) GetValues() *hapi_chart.Config {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *UpdateReleaseRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *UpdateReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *UpdateReleaseRequest) GetRecreate() bool {
	if m != nil {
		return m.Recreate
	}
	return false
}

func (m *UpdateReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *UpdateReleaseRequest) GetResetValues() bool {
	if m != nil {
		return m.ResetValues
	}
	return false
}

func (m *UpdateReleaseRequest) GetWait() bool {
	if m != nil {
		return m.Wait
	}
	return false
}

func (m *UpdateReleaseRequest) GetReuseValues() bool {
	if m != nil {
		return m.ReuseValues
	}
	return false
}

func (m *UpdateReleaseRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *UpdateReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// UpdateReleaseResponse is the response to an update request.
type UpdateReleaseResponse struct {
	Release *hapi_release5.Release `protobuf:"bytes,1,opt,name=release" json:"release,omitempty"`
}

func (m *UpdateReleaseResponse) Reset()                    { *m = UpdateReleaseResponse{} }
func (m *UpdateReleaseResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateReleaseResponse) ProtoMessage()               {}
func (*UpdateReleaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *UpdateReleaseResponse) GetRelease() *hapi_release5.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

type RollbackReleaseRequest struct {
	// The name of the release
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// dry_run, if true, will run through the release logic but no create
	DryRun bool `protobuf:"varint,2,opt,name=dry_run,json=dryRun" json:"dry_run,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the rollback
	DisableHooks bool `protobuf:"varint,3,opt,name=disable_hooks,json=disableHooks" json:"disable_hooks,omitempty"`
	// Version is the version of the release to deploy.
	Version int32 `protobuf:"varint,4,opt,name=version" json:"version,omitempty"`
	// Performs pods restart for resources if applicable
	Recreate bool `protobuf:"varint,5,opt,name=recreate" json:"recreate,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,6,opt,name=timeout" json:"timeout,omitempty"`
	// wait, if true, will wait until all Pods, PVCs, and Services are in a ready state
	// before marking the release as successful. It will wait for as long as timeout
	Wait bool `protobuf:"varint,7,opt,name=wait" json:"wait,omitempty"`
	// Force resource update through delete/recreate if needed.
	Force bool `protobuf:"varint,8,opt,name=force" json:"force,omitempty"`
	// Description, if set, will set the description for the rollback
	Description string `protobuf:"bytes,9,opt,name=description" json:"description,omitempty"`
}

func (m *RollbackReleaseRequest) Reset()                    { *m = RollbackReleaseRequest{} }
func (m *RollbackReleaseRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackReleaseRequest) ProtoMessage()               {}
func (*RollbackReleaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *RollbackReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RollbackReleaseRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *RollbackReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *RollbackReleaseRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *RollbackReleaseRequest) GetRecreate() bool {
	if m != nil {
		return m.Recreate
	}
	return false
}

func (m *RollbackReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *RollbackReleaseRequest) GetWait() bool {
	if m != nil {
		return m.Wait
	}
	return false
}

func (m *RollbackReleaseRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *RollbackReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// RollbackReleaseResponse is the response to an update request.
type RollbackReleaseResponse struct {
	Release *hapi_release5.Release `protobuf:"bytes,1,opt,name=release" json:"release,omitempty"`
}

func (m *RollbackReleaseResponse) Reset()                    { *m = RollbackReleaseResponse{} }
func (m *RollbackReleaseResponse) String() string            { return proto.CompactTextString(m) }
func (*RollbackReleaseResponse) ProtoMessage()               {}
func (*RollbackReleaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *RollbackReleaseResponse) GetRelease() *hapi_release5.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

// InstallReleaseRequest is the request for an installation of a chart.
type InstallReleaseRequest struct {
	// Chart is the protobuf representation of a chart.
	Chart *hapi_chart3.Chart `protobuf:"bytes,1,opt,name=chart" json:"chart,omitempty"`
	// Values is a string containing (unparsed) YAML values.
	Values *hapi_chart.Config `protobuf:"bytes,2,opt,name=values" json:"values,omitempty"`
	// DryRun, if true, will run through the release logic, but neither create
	// a release object nor deploy to Kubernetes. The release object returned
	// in the response will be fake.
	DryRun bool `protobuf:"varint,3,opt,name=dry_run,json=dryRun" json:"dry_run,omitempty"`
	// Name is the candidate release name. This must be unique to the
	// namespace, otherwise the server will return an error. If it is not
	// supplied, the server will autogenerate one.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the install.
	DisableHooks bool `protobuf:"varint,5,opt,name=disable_hooks,json=disableHooks" json:"disable_hooks,omitempty"`
	// Namespace is the kubernetes namespace of the release.
	Namespace string `protobuf:"bytes,6,opt,name=namespace" json:"namespace,omitempty"`
	// Reuse_name requests that Tiller re-uses a name, instead of erroring out.
	ReuseName bool `protobuf:"varint,7,opt,name=reuse_name,json=reuseName" json:"reuse_name,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,8,opt,name=timeout" json:"timeout,omitempty"`
	// wait, if true, will wait until all Pods, PVCs, and Services are in a ready state
	// before marking the release as successful. It will wait for as long as timeout
	Wait           bool `protobuf:"varint,9,opt,name=wait" json:"wait,omitempty"`
	DisableCrdHook bool `protobuf:"varint,10,opt,name=disable_crd_hook,json=disableCrdHook" json:"disable_crd_hook,omitempty"`
	// Description, if set, will set the description for the installed release
	Description string `protobuf:"bytes,11,opt,name=description" json:"description,omitempty"`
}

func (m *InstallReleaseRequest) Reset()                    { *m = InstallReleaseRequest{} }
func (m *InstallReleaseRequest) String() string            { return proto.CompactTextString(m) }
func (*InstallReleaseRequest) ProtoMessage()               {}
func (*InstallReleaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *InstallReleaseRequest) GetChart() *hapi_chart3.Chart {
	if m != nil {
		return m.Chart
	}
	return nil
}

func (m *InstallReleaseRequest) GetValues() *hapi_chart.Config {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *InstallReleaseRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *InstallReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstallReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *InstallReleaseRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *InstallReleaseRequest) GetReuseName() bool {
	if m != nil {
		return m.ReuseName
	}
	return false
}

func (m *InstallReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *InstallReleaseRequest) GetWait() bool {
	if m != nil {
		return m.Wait
	}
	return false
}

func (m *InstallReleaseRequest) GetDisableCrdHook() bool {
	if m != nil {
		return m.DisableCrdHook
	}
	return false
}

func (m *InstallReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// InstallReleaseResponse is the response from a release installation.
type InstallReleaseResponse struct {
	Release *hapi_release5.Release `protobuf:"bytes,1,opt,name=release" json:"release,omitempty"`
}

func (m *InstallReleaseResponse) Reset()                    { *m = InstallReleaseResponse{} }
func (m *InstallReleaseResponse) String() string            { return proto.CompactTextString(m) }
func (*InstallReleaseResponse) ProtoMessage()               {}
func (*InstallReleaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *InstallReleaseResponse) GetRelease() *hapi_release5.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

// UninstallReleaseRequest represents a request to uninstall a named release.
type UninstallReleaseRequest struct {
	// Name is the name of the release to delete.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// DisableHooks causes the server to skip running any hooks for the uninstall.
	DisableHooks bool `protobuf:"varint,2,opt,name=disable_hooks,json=disableHooks" json:"disable_hooks,omitempty"`
	// Purge removes the release from the store and make its name free for later use.
	Purge bool `protobuf:"varint,3,opt,name=purge" json:"purge,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,4,opt,name=timeout" json:"timeout,omitempty"`
	// Description, if set, will set the description for the uninnstalled release
	Description string `protobuf:"bytes,5,opt,name=description" json:"description,omitempty"`
}

func (m *UninstallReleaseRequest) Reset()                    { *m = UninstallReleaseRequest{} }
func (m *UninstallReleaseRequest) String() string            { return proto.CompactTextString(m) }
func (*UninstallReleaseRequest) ProtoMessage()               {}
func (*UninstallReleaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *UninstallReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UninstallReleaseRequest) GetDisableHooks() bool {
	if m != nil {
		return m.DisableHooks
	}
	return false
}

func (m *UninstallReleaseRequest) GetPurge() bool {
	if m != nil {
		return m.Purge
	}
	return false
}

func (m *UninstallReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *UninstallReleaseRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// UninstallReleaseResponse represents a successful response to an uninstall request.
type UninstallReleaseResponse struct {
	// Release is the release that was marked deleted.
	Release *hapi_release5.Release `protobuf:"bytes,1,opt,name=release" json:"release,omitempty"`
	// Info is an uninstall message
	Info string `protobuf:"bytes,2,opt,name=info" json:"info,omitempty"`
}

func (m *UninstallReleaseResponse) Reset()                    { *m = UninstallReleaseResponse{} }
func (m *UninstallReleaseResponse) String() string            { return proto.CompactTextString(m) }
func (*UninstallReleaseResponse) ProtoMessage()               {}
func (*UninstallReleaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *UninstallReleaseResponse) GetRelease() *hapi_release5.Release {
	if m != nil {
		return m.Release
	}
	return nil
}

func (m *UninstallReleaseResponse) GetInfo() string {
	if m != nil {
		return m.Info
	}
	return ""
}

// GetVersionRequest requests for version information.
type GetVersionRequest struct {
}

func (m *GetVersionRequest) Reset()                    { *m = GetVersionRequest{} }
func (m *GetVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVersionRequest) ProtoMessage()               {}
func (*GetVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type GetVersionResponse struct {
	Version *hapi_version.Version `protobuf:"bytes,1,opt,name=Version" json:"Version,omitempty"`
}

func (m *GetVersionResponse) Reset()                    { *m = GetVersionResponse{} }
func (m *GetVersionResponse) String() string            { return proto.CompactTextString(m) }
func (*GetVersionResponse) ProtoMessage()               {}
func (*GetVersionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetVersionResponse) GetVersion() *hapi_version.Version {
	if m != nil {
		return m.Version
	}
	return nil
}

// GetHistoryRequest requests a release's history.
type GetHistoryRequest struct {
	// The name of the release.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The maximum number of releases to include.
	Max int32 `protobuf:"varint,2,opt,name=max" json:"max,omitempty"`
}

func (m *GetHistoryRequest) Reset()                    { *m = GetHistoryRequest{} }
func (m *GetHistoryRequest) String() string            { return proto.CompactTextString(m) }
func (*GetHistoryRequest) ProtoMessage()               {}
func (*GetHistoryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *GetHistoryRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetHistoryRequest) GetMax() int32 {
	if m != nil {
		return m.Max
	}
	return 0
}

// GetHistoryResponse is received in response to a GetHistory rpc.
type GetHistoryResponse struct {
	Releases []*hapi_release5.Release `protobuf:"bytes,1,rep,name=releases" json:"releases,omitempty"`
}

func (m *GetHistoryResponse) Reset()                    { *m = GetHistoryResponse{} }
func (m *GetHistoryResponse) String() string            { return proto.CompactTextString(m) }
func (*GetHistoryResponse) ProtoMessage()               {}
func (*GetHistoryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *GetHistoryResponse) GetReleases() []*hapi_release5.Release {
	if m != nil {
		return m.Releases
	}
	return nil
}

// TestReleaseRequest is a request to get the status of a release.
type TestReleaseRequest struct {
	// Name is the name of the release
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// timeout specifies the max amount of time any kubernetes client command can run.
	Timeout int64 `protobuf:"varint,2,opt,name=timeout" json:"timeout,omitempty"`
	// cleanup specifies whether or not to attempt pod deletion after test completes
	Cleanup bool `protobuf:"varint,3,opt,name=cleanup" json:"cleanup,omitempty"`
}

func (m *TestReleaseRequest) Reset()                    { *m = TestReleaseRequest{} }
func (m *TestReleaseRequest) String() string            { return proto.CompactTextString(m) }
func (*TestReleaseRequest) ProtoMessage()               {}
func (*TestReleaseRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *TestReleaseRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TestReleaseRequest) GetTimeout() int64 {
	if m != nil {
		return m.Timeout
	}
	return 0
}

func (m *TestReleaseRequest) GetCleanup() bool {
	if m != nil {
		return m.Cleanup
	}
	return false
}

// TestReleaseResponse represents a message from executing a test
type TestReleaseResponse struct {
	Msg    string                       `protobuf:"bytes,1,opt,name=msg" json:"msg,omitempty"`
	Status hapi_release1.TestRun_Status `protobuf:"varint,2,opt,name=status,enum=hapi.release.TestRun_Status" json:"status,omitempty"`
}

func (m *TestReleaseResponse) Reset()                    { *m = TestReleaseResponse{} }
func (m *TestReleaseResponse) String() string            { return proto.CompactTextString(m) }
func (*TestReleaseResponse) ProtoMessage()               {}
func (*TestReleaseResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *TestReleaseResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *TestReleaseResponse) GetStatus() hapi_release1.TestRun_Status {
	if m != nil {
		return m.Status
	}
	return hapi_release1.TestRun_UNKNOWN
}

func init() {
	proto.RegisterType((*ListReleasesRequest)(nil), "hapi.services.tiller.ListReleasesRequest")
	proto.RegisterType((*ListSort)(nil), "hapi.services.tiller.ListSort")
	proto.RegisterType((*ListReleasesResponse)(nil), "hapi.services.tiller.ListReleasesResponse")
	proto.RegisterType((*GetReleaseStatusRequest)(nil), "hapi.services.tiller.GetReleaseStatusRequest")
	proto.RegisterType((*GetReleaseStatusResponse)(nil), "hapi.services.tiller.GetReleaseStatusResponse")
	proto.RegisterType((*GetReleaseContentRequest)(nil), "hapi.services.tiller.GetReleaseContentRequest")
	proto.RegisterType((*GetReleaseContentResponse)(nil), "hapi.services.tiller.GetReleaseContentResponse")
	proto.RegisterType((*UpdateReleaseRequest)(nil), "hapi.services.tiller.UpdateReleaseRequest")
	proto.RegisterType((*UpdateReleaseResponse)(nil), "hapi.services.tiller.UpdateReleaseResponse")
	proto.RegisterType((*RollbackReleaseRequest)(nil), "hapi.services.tiller.RollbackReleaseRequest")
	proto.RegisterType((*RollbackReleaseResponse)(nil), "hapi.services.tiller.RollbackReleaseResponse")
	proto.RegisterType((*InstallReleaseRequest)(nil), "hapi.services.tiller.InstallReleaseRequest")
	proto.RegisterType((*InstallReleaseResponse)(nil), "hapi.services.tiller.InstallReleaseResponse")
	proto.RegisterType((*UninstallReleaseRequest)(nil), "hapi.services.tiller.UninstallReleaseRequest")
	proto.RegisterType((*UninstallReleaseResponse)(nil), "hapi.services.tiller.UninstallReleaseResponse")
	proto.RegisterType((*GetVersionRequest)(nil), "hapi.services.tiller.GetVersionRequest")
	proto.RegisterType((*GetVersionResponse)(nil), "hapi.services.tiller.GetVersionResponse")
	proto.RegisterType((*GetHistoryRequest)(nil), "hapi.services.tiller.GetHistoryRequest")
	proto.RegisterType((*GetHistoryResponse)(nil), "hapi.services.tiller.GetHistoryResponse")
	proto.RegisterType((*TestReleaseRequest)(nil), "hapi.services.tiller.TestReleaseRequest")
	proto.RegisterType((*TestReleaseResponse)(nil), "hapi.services.tiller.TestReleaseResponse")
	proto.RegisterEnum("hapi.services.tiller.ListSort_SortBy", ListSort_SortBy_name, ListSort_SortBy_value)
	proto.RegisterEnum("hapi.services.tiller.ListSort_SortOrder", ListSort_SortOrder_name, ListSort_SortOrder_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ReleaseService service

type ReleaseServiceClient interface {
	// ListReleases retrieves release history.
	// TODO: Allow filtering the set of releases by
	// release status. By default, ListAllReleases returns the releases who
	// current status is "Active".
	ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (ReleaseService_ListReleasesClient, error)
	// GetReleasesStatus retrieves status information for the specified release.
	GetReleaseStatus(ctx context.Context, in *GetReleaseStatusRequest, opts ...grpc.CallOption) (*GetReleaseStatusResponse, error)
	// GetReleaseContent retrieves the release content (chart + value) for the specified release.
	GetReleaseContent(ctx context.Context, in *GetReleaseContentRequest, opts ...grpc.CallOption) (*GetReleaseContentResponse, error)
	// UpdateRelease updates release content.
	UpdateRelease(ctx context.Context, in *UpdateReleaseRequest, opts ...grpc.CallOption) (*UpdateReleaseResponse, error)
	// InstallRelease requests installation of a chart as a new release.
	InstallRelease(ctx context.Context, in *InstallReleaseRequest, opts ...grpc.CallOption) (*InstallReleaseResponse, error)
	// UninstallRelease requests deletion of a named release.
	UninstallRelease(ctx context.Context, in *UninstallReleaseRequest, opts ...grpc.CallOption) (*UninstallReleaseResponse, error)
	// GetVersion returns the current version of the server.
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*GetVersionResponse, error)
	// RollbackRelease rolls back a release to a previous version.
	RollbackRelease(ctx context.Context, in *RollbackReleaseRequest, opts ...grpc.CallOption) (*RollbackReleaseResponse, error)
	// ReleaseHistory retrieves a releasse's history.
	GetHistory(ctx context.Context, in *GetHistoryRequest, opts ...grpc.CallOption) (*GetHistoryResponse, error)
	// RunReleaseTest executes the tests defined of a named release
	RunReleaseTest(ctx context.Context, in *TestReleaseRequest, opts ...grpc.CallOption) (ReleaseService_RunReleaseTestClient, error)
}

type releaseServiceClient struct {
	cc *grpc.ClientConn
}

func NewReleaseServiceClient(cc *grpc.ClientConn) ReleaseServiceClient {
	return &releaseServiceClient{cc}
}

func (c *releaseServiceClient) ListReleases(ctx context.Context, in *ListReleasesRequest, opts ...grpc.CallOption) (ReleaseService_ListReleasesClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ReleaseService_serviceDesc.Streams[0], c.cc, "/hapi.services.tiller.ReleaseService/ListReleases", opts...)
	if err != nil {
		return nil, err
	}
	x := &releaseServiceListReleasesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ReleaseService_ListReleasesClient interface {
	Recv() (*ListReleasesResponse, error)
	grpc.ClientStream
}

type releaseServiceListReleasesClient struct {
	grpc.ClientStream
}

func (x *releaseServiceListReleasesClient) Recv() (*ListReleasesResponse, error) {
	m := new(ListReleasesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *releaseServiceClient) GetReleaseStatus(ctx context.Context, in *GetReleaseStatusRequest, opts ...grpc.CallOption) (*GetReleaseStatusResponse, error) {
	out := new(GetReleaseStatusResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetReleaseStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) GetReleaseContent(ctx context.Context, in *GetReleaseContentRequest, opts ...grpc.CallOption) (*GetReleaseContentResponse, error) {
	out := new(GetReleaseContentResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetReleaseContent", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) UpdateRelease(ctx context.Context, in *UpdateReleaseRequest, opts ...grpc.CallOption) (*UpdateReleaseResponse, error) {
	out := new(UpdateReleaseResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/UpdateRelease", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) InstallRelease(ctx context.Context, in *InstallReleaseRequest, opts ...grpc.CallOption) (*InstallReleaseResponse, error) {
	out := new(InstallReleaseResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/InstallRelease", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) UninstallRelease(ctx context.Context, in *UninstallReleaseRequest, opts ...grpc.CallOption) (*UninstallReleaseResponse, error) {
	out := new(UninstallReleaseResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/UninstallRelease", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*GetVersionResponse, error) {
	out := new(GetVersionResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) RollbackRelease(ctx context.Context, in *RollbackReleaseRequest, opts ...grpc.CallOption) (*RollbackReleaseResponse, error) {
	out := new(RollbackReleaseResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/RollbackRelease", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) GetHistory(ctx context.Context, in *GetHistoryRequest, opts ...grpc.CallOption) (*GetHistoryResponse, error) {
	out := new(GetHistoryResponse)
	err := grpc.Invoke(ctx, "/hapi.services.tiller.ReleaseService/GetHistory", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *releaseServiceClient) RunReleaseTest(ctx context.Context, in *TestReleaseRequest, opts ...grpc.CallOption) (ReleaseService_RunReleaseTestClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ReleaseService_serviceDesc.Streams[1], c.cc, "/hapi.services.tiller.ReleaseService/RunReleaseTest", opts...)
	if err != nil {
		return nil, err
	}
	x := &releaseServiceRunReleaseTestClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ReleaseService_RunReleaseTestClient interface {
	Recv() (*TestReleaseResponse, error)
	grpc.ClientStream
}

type releaseServiceRunReleaseTestClient struct {
	grpc.ClientStream
}

func (x *releaseServiceRunReleaseTestClient) Recv() (*TestReleaseResponse, error) {
	m := new(TestReleaseResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for ReleaseService service

type ReleaseServiceServer interface {
	// ListReleases retrieves release history.
	// TODO: Allow filtering the set of releases by
	// release status. By default, ListAllReleases returns the releases who
	// current status is "Active".
	ListReleases(*ListReleasesRequest, ReleaseService_ListReleasesServer) error
	// GetReleasesStatus retrieves status information for the specified release.
	GetReleaseStatus(context.Context, *GetReleaseStatusRequest) (*GetReleaseStatusResponse, error)
	// GetReleaseContent retrieves the release content (chart + value) for the specified release.
	GetReleaseContent(context.Context, *GetReleaseContentRequest) (*GetReleaseContentResponse, error)
	// UpdateRelease updates release content.
	UpdateRelease(context.Context, *UpdateReleaseRequest) (*UpdateReleaseResponse, error)
	// InstallRelease requests installation of a chart as a new release.
	InstallRelease(context.Context, *InstallReleaseRequest) (*InstallReleaseResponse, error)
	// UninstallRelease requests deletion of a named release.
	UninstallRelease(context.Context, *UninstallReleaseRequest) (*UninstallReleaseResponse, error)
	// GetVersion returns the current version of the server.
	GetVersion(context.Context, *GetVersionRequest) (*GetVersionResponse, error)
	// RollbackRelease rolls back a release to a previous version.
	RollbackRelease(context.Context, *RollbackReleaseRequest) (*RollbackReleaseResponse, error)
	// ReleaseHistory retrieves a releasse's history.
	GetHistory(context.Context, *GetHistoryRequest) (*GetHistoryResponse, error)
	// RunReleaseTest executes the tests defined of a named release
	RunReleaseTest(*TestReleaseRequest, ReleaseService_RunReleaseTestServer) error
}

func RegisterReleaseServiceServer(s *grpc.Server, srv ReleaseServiceServer) {
	s.RegisterService(&_ReleaseService_serviceDesc, srv)
}

func _ReleaseService_ListReleases_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListReleasesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ReleaseServiceServer).ListReleases(m, &releaseServiceListReleasesServer{stream})
}

type ReleaseService_ListReleasesServer interface {
	Send(*ListReleasesResponse) error
	grpc.ServerStream
}

type releaseServiceListReleasesServer struct {
	grpc.ServerStream
}

func (x *releaseServiceListReleasesServer) Send(m *ListReleasesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ReleaseService_GetReleaseStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetReleaseStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetReleaseStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetReleaseStatus(ctx, req.(*GetReleaseStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_GetReleaseContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReleaseContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetReleaseContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetReleaseContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetReleaseContent(ctx, req.(*GetReleaseContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_UpdateRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).UpdateRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/UpdateRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).UpdateRelease(ctx, req.(*UpdateReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_InstallRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstallReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).InstallRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/InstallRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).InstallRelease(ctx, req.(*InstallReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_UninstallRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UninstallReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).UninstallRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/UninstallRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).UninstallRelease(ctx, req.(*UninstallReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_RollbackRelease_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackReleaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).RollbackRelease(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/RollbackRelease",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).RollbackRelease(ctx, req.(*RollbackReleaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_GetHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReleaseServiceServer).GetHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/hapi.services.tiller.ReleaseService/GetHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReleaseServiceServer).GetHistory(ctx, req.(*GetHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReleaseService_RunReleaseTest_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TestReleaseRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ReleaseServiceServer).RunReleaseTest(m, &releaseServiceRunReleaseTestServer{stream})
}

type ReleaseService_RunReleaseTestServer interface {
	Send(*TestReleaseResponse) error
	grpc.ServerStream
}

type releaseServiceRunReleaseTestServer struct {
	grpc.ServerStream
}

func (x *releaseServiceRunReleaseTestServer) Send(m *TestReleaseResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _ReleaseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "hapi.services.tiller.ReleaseService",
	HandlerType: (*ReleaseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetReleaseStatus",
			Handler:    _ReleaseService_GetReleaseStatus_Handler,
		},
		{
			MethodName: "GetReleaseContent",
			Handler:    _ReleaseService_GetReleaseContent_Handler,
		},
		{
			MethodName: "UpdateRelease",
			Handler:    _ReleaseService_UpdateRelease_Handler,
		},
		{
			MethodName: "InstallRelease",
			Handler:    _ReleaseService_InstallRelease_Handler,
		},
		{
			MethodName: "UninstallRelease",
			Handler:    _ReleaseService_UninstallRelease_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _ReleaseService_GetVersion_Handler,
		},
		{
			MethodName: "RollbackRelease",
			Handler:    _ReleaseService_RollbackRelease_Handler,
		},
		{
			MethodName: "GetHistory",
			Handler:    _ReleaseService_GetHistory_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListReleases",
			Handler:       _ReleaseService_ListReleases_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "RunReleaseTest",
			Handler:       _ReleaseService_RunReleaseTest_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "hapi/services/tiller.proto",
}

func init() { proto.RegisterFile("hapi/services/tiller.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1276 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0x6e, 0xe2, 0xfc, 0x9e, 0x74, 0x43, 0x76, 0x36, 0xdb, 0x7a, 0xcd, 0x82, 0x82, 0x11, 0x6c,
	0x76, 0x61, 0x53, 0x08, 0xdc, 0x20, 0x21, 0xa4, 0x6e, 0x36, 0x6a, 0x0b, 0xa5, 0x2b, 0x39, 0xed,
	0x22, 0x21, 0x50, 0xe4, 0x26, 0x93, 0xd6, 0xac, 0x63, 0x07, 0xcf, 0xb8, 0x6c, 0x1f, 0x00, 0x24,
	0xde, 0x83, 0x07, 0xe1, 0x3d, 0x78, 0x0e, 0xee, 0x91, 0xe7, 0xc7, 0xf5, 0x38, 0x76, 0x6a, 0x7a,
	0xd3, 0x78, 0xe6, 0x9c, 0x39, 0x3f, 0xdf, 0x37, 0xe7, 0xcc, 0x29, 0x18, 0x97, 0xf6, 0xca, 0xd9,
	0x23, 0x38, 0xb8, 0x72, 0x66, 0x98, 0xec, 0x51, 0xc7, 0x75, 0x71, 0x30, 0x58, 0x05, 0x3e, 0xf5,
	0x51, 0x37, 0x92, 0x0d, 0xa4, 0x6c, 0xc0, 0x65, 0xc6, 0x0e, 0x3b, 0x31, 0xbb, 0xb4, 0x03, 0xca,
	0xff, 0x72, 0x6d, 0x63, 0x37, 0xb9, 0xef, 0x7b, 0x0b, 0xe7, 0x42, 0x08, 0xb8, 0x8b, 0x00, 0xbb,
	0xd8, 0x26, 0x58, 0xfe, 0x2a, 0x87, 0xa4, 0xcc, 0xf1, 0x16, 0xbe, 0x10, 0xbc, 0xab, 0x08, 0x28,
	0x26, 0x74, 0x1a, 0x84, 0x9e, 0x10, 0x3e, 0x52, 0x84, 0x84, 0xda, 0x34, 0x24, 0x8a, 0xb3, 0x2b,
	0x1c, 0x10, 0xc7, 0xf7, 0xe4, 0x2f, 0x97, 0x99, 0x7f, 0x97, 0xe1, 0xc1, 0xb1, 0x43, 0xa8, 0xc5,
	0x0f, 0x12, 0x0b, 0xff, 0x1a, 0x62, 0x42, 0x51, 0x17, 0xaa, 0xae, 0xb3, 0x74, 0xa8, 0x5e, 0xea,
	0x95, 0xfa, 0x9a, 0xc5, 0x17, 0x68, 0x07, 0x6a, 0xfe, 0x62, 0x41, 0x30, 0xd5, 0xcb, 0xbd, 0x52,
	0xbf, 0x69, 0x89, 0x15, 0xfa, 0x06, 0xea, 0xc4, 0x0f, 0xe8, 0xf4, 0xfc, 0x5a, 0xd7, 0x7a, 0xa5,
	0x7e, 0x7b, 0xf8, 0xd1, 0x20, 0x0b, 0xa7, 0x41, 0xe4, 0x69, 0xe2, 0x07, 0x74, 0x10, 0xfd, 0x79,
	0x71, 0x6d, 0xd5, 0x08, 0xfb, 0x8d, 0xec, 0x2e, 0x1c, 0x97, 0xe2, 0x40, 0xaf, 0x70, 0xbb, 0x7c,
	0x85, 0x0e, 0x00, 0x98, 0x5d, 0x3f, 0x98, 0xe3, 0x40, 0xaf, 0x32, 0xd3, 0xfd, 0x02, 0xa6, 0x5f,
	0x45, 0xfa, 0x56, 0x93, 0xc8, 0x4f, 0xf4, 0x35, 0x6c, 0x73, 0x48, 0xa6, 0x33, 0x7f, 0x8e, 0x89,
	0x5e, 0xeb, 0x69, 0xfd, 0xf6, 0xf0, 0x11, 0x37, 0x25, 0xe1, 0x9f, 0x70, 0xd0, 0x46, 0xfe, 0x1c,
	0x5b, 0x2d, 0xae, 0x1e, 0x7d, 0x13, 0xf4, 0x18, 0x9a, 0x9e, 0xbd, 0xc4, 0x64, 0x65, 0xcf, 0xb0,
	0x5e, 0x67, 0x11, 0xde, 0x6c, 0x98, 0x1e, 0x34, 0xa4, 0x73, 0xf3, 0x05, 0xd4, 0x78, 0x6a, 0xa8,
	0x05, 0xf5, 0xb3, 0x93, 0xef, 0x4e, 0x5e, 0xfd, 0x70, 0xd2, 0xd9, 0x42, 0x0d, 0xa8, 0x9c, 0xec,
	0x7f, 0x3f, 0xee, 0x94, 0xd0, 0x7d, 0xb8, 0x77, 0xbc, 0x3f, 0x39, 0x9d, 0x5a, 0xe3, 0xe3, 0xf1,
	0xfe, 0x64, 0xfc, 0xb2, 0x53, 0x46, 0x6d, 0x80, 0xd1, 0xe1, 0xbe, 0x75, 0x3a, 0x65, 0x2a, 0x9a,
	0xf9, 0x3e, 0x34, 0xe3, 0x1c, 0x50, 0x1d, 0xb4, 0xfd, 0xc9, 0x88, 0x9b, 0x78, 0x39, 0x9e, 0x8c,
	0x3a, 0x25, 0xf3, 0xcf, 0x12, 0x74, 0x55, 0xca, 0xc8, 0xca, 0xf7, 0x08, 0x8e, 0x38, 0x9b, 0xf9,
	0xa1, 0x17, 0x73, 0xc6, 0x16, 0x08, 0x41, 0xc5, 0xc3, 0x6f, 0x25, 0x63, 0xec, 0x3b, 0xd2, 0xa4,
	0x3e, 0xb5, 0x5d, 0xc6, 0x96, 0x66, 0xf1, 0x05, 0xfa, 0x1c, 0x1a, 0x02, 0x0a, 0xa2, 0x57, 0x7a,
	0x5a, 0xbf, 0x35, 0x7c, 0xa8, 0x02, 0x24, 0x3c, 0x5a, 0xb1, 0x9a, 0x79, 0x00, 0xbb, 0x07, 0x58,
	0x46, 0xc2, 0xf1, 0x93, 0x37, 0x28, 0xf2, 0x6b, 0x2f, 0x31, 0x0b, 0x26, 0xf2, 0x6b, 0x2f, 0x31,
	0xd2, 0xa1, 0x2e, 0xae, 0x1f, 0x0b, 0xa7, 0x6a, 0xc9, 0xa5, 0x49, 0x41, 0x5f, 0x37, 0x24, 0xf2,
	0xca, 0xb2, 0xf4, 0x31, 0x54, 0xa2, 0xca, 0x60, 0x66, 0x5a, 0x43, 0xa4, 0xc6, 0x79, 0xe4, 0x2d,
	0x7c, 0x8b, 0xc9, 0x55, 0xea, 0xb4, 0x34, 0x75, 0x87, 0x49, 0xaf, 0x23, 0xdf, 0xa3, 0xd8, 0xa3,
	0x77, 0x8b, 0xff, 0x18, 0x1e, 0x65, 0x58, 0x12, 0x09, 0xec, 0x41, 0x5d, 0x84, 0xc6, 0xac, 0xe5,
	0xe2, 0x2a, 0xb5, 0xcc, 0xdf, 0x35, 0xe8, 0x9e, 0xad, 0xe6, 0x36, 0xc5, 0x52, 0xb4, 0x21, 0xa8,
	0x27, 0x50, 0x65, 0x1d, 0x46, 0x60, 0x71, 0x9f, 0xdb, 0xe6, 0x6d, 0x68, 0x14, 0xfd, 0xb5, 0xb8,
	0x1c, 0x3d, 0x83, 0xda, 0x95, 0xed, 0x86, 0x98, 0x30, 0x20, 0x62, 0xd4, 0x84, 0x26, 0x6b, 0x4f,
	0x96, 0xd0, 0x40, 0xbb, 0x50, 0x9f, 0x07, 0xd7, 0x51, 0x7f, 0x61, 0x25, 0xd9, 0xb0, 0x6a, 0xf3,
	0xe0, 0xda, 0x0a, 0x3d, 0xf4, 0x21, 0xdc, 0x9b, 0x3b, 0xc4, 0x3e, 0x77, 0xf1, 0xf4, 0xd2, 0xf7,
	0xdf, 0x10, 0x56, 0x95, 0x0d, 0x6b, 0x5b, 0x6c, 0x1e, 0x46, 0x7b, 0xc8, 0x88, 0x6e, 0xd2, 0x2c,
	0xc0, 0x36, 0xc5, 0x7a, 0x8d, 0xc9, 0xe3, 0x75, 0x84, 0x21, 0x75, 0x96, 0xd8, 0x0f, 0x29, 0x2b,
	0x25, 0xcd, 0x92, 0x4b, 0xf4, 0x01, 0x6c, 0x07, 0x98, 0x60, 0x3a, 0x15, 0x51, 0x36, 0xd8, 0xc9,
	0x16, 0xdb, 0x7b, 0xcd, 0xc3, 0x42, 0x50, 0xf9, 0xcd, 0x76, 0xa8, 0xde, 0x64, 0x22, 0xf6, 0xcd,
	0x8f, 0x85, 0x04, 0xcb, 0x63, 0x20, 0x8f, 0x85, 0x04, 0x8b, 0x63, 0x5d, 0xa8, 0x2e, 0xfc, 0x60,
	0x86, 0xf5, 0x16, 0x93, 0xf1, 0x05, 0xea, 0x41, 0x6b, 0x8e, 0xc9, 0x2c, 0x70, 0x56, 0x34, 0x62,
	0x74, 0x9b, 0x61, 0x9a, 0xdc, 0x32, 0x0f, 0xe1, 0x61, 0x8a, 0x86, 0xbb, 0x32, 0xfa, 0x47, 0x19,
	0x76, 0x2c, 0xdf, 0x75, 0xcf, 0xed, 0xd9, 0x9b, 0x02, 0x9c, 0x26, 0xe0, 0x2f, 0x6f, 0x86, 0x5f,
	0xcb, 0x80, 0x3f, 0x71, 0x4d, 0x2b, 0xca, 0x35, 0x55, 0x88, 0xa9, 0xe6, 0x13, 0x53, 0x53, 0x89,
	0x91, 0xa8, 0xd7, 0x13, 0xa8, 0xc7, 0x90, 0x36, 0x36, 0x40, 0xda, 0x5c, 0x87, 0xf4, 0x5b, 0xd8,
	0x5d, 0xc3, 0xe1, 0xae, 0xa0, 0xfe, 0x5b, 0x86, 0x87, 0x47, 0x1e, 0xa1, 0xb6, 0xeb, 0xa6, 0x30,
	0x8d, 0x6b, 0xa2, 0x54, 0xb8, 0x26, 0xca, 0xff, 0xa7, 0x26, 0x34, 0x85, 0x14, 0xc9, 0x60, 0x25,
	0xc1, 0x60, 0xa1, 0x3a, 0x51, 0xba, 0x53, 0x2d, 0xd5, 0x9d, 0xd0, 0x7b, 0x00, 0xfc, 0x62, 0x33,
	0xe3, 0x1c, 0xfc, 0x26, 0xdb, 0x39, 0x11, 0xcd, 0x48, 0xf2, 0xd5, 0xc8, 0xe6, 0x2b, 0x59, 0x25,
	0x7d, 0xe8, 0xc8, 0x78, 0x66, 0xc1, 0x9c, 0xc5, 0x24, 0x2a, 0xa5, 0x2d, 0xf6, 0x47, 0xc1, 0x3c,
	0x8a, 0x2a, 0xcd, 0x61, 0x6b, 0x9d, 0xc3, 0x23, 0xd8, 0x49, 0xc3, 0x7e, 0x57, 0x0a, 0xff, 0x2a,
	0xc1, 0xee, 0x99, 0xe7, 0x64, 0x92, 0x98, 0x55, 0x18, 0x6b, 0xb0, 0x96, 0x33, 0x60, 0xed, 0x42,
	0x75, 0x15, 0x06, 0x17, 0x58, 0xd0, 0xc4, 0x17, 0x49, 0xbc, 0x2a, 0x2a, 0x5e, 0xa9, 0x8c, 0xab,
	0xeb, 0x19, 0x4f, 0x41, 0x5f, 0x8f, 0xf2, 0x8e, 0x39, 0x47, 0x79, 0xc5, 0x6f, 0x57, 0x93, 0xbf,
	0x53, 0xe6, 0x03, 0xb8, 0x7f, 0x80, 0xe9, 0x6b, 0x5e, 0xa6, 0x02, 0x00, 0x73, 0x0c, 0x28, 0xb9,
	0x79, 0xe3, 0x4f, 0x6c, 0xa9, 0xfe, 0xe4, 0x60, 0x27, 0xf5, 0xa5, 0x96, 0xf9, 0x15, 0xb3, 0x7d,
	0xe8, 0x10, 0xea, 0x07, 0xd7, 0x9b, 0xc0, 0xed, 0x80, 0xb6, 0xb4, 0xdf, 0x8a, 0xa7, 0x2d, 0xfa,
	0x34, 0x0f, 0x58, 0x04, 0xf1, 0x51, 0x11, 0x41, 0x72, 0x50, 0x28, 0x15, 0x1b, 0x14, 0x7e, 0x02,
	0x74, 0x8a, 0xe3, 0x99, 0xe5, 0x96, 0x37, 0x56, 0xd2, 0x54, 0x56, 0x69, 0xd2, 0xa1, 0x3e, 0x73,
	0xb1, 0xed, 0x85, 0x2b, 0x41, 0xac, 0x5c, 0x9a, 0x3f, 0xc3, 0x03, 0xc5, 0xba, 0x88, 0x33, 0xca,
	0x87, 0x5c, 0x08, 0xeb, 0xd1, 0x27, 0xfa, 0x12, 0x6a, 0x7c, 0xb0, 0x63, 0xb6, 0xdb, 0xc3, 0xc7,
	0x6a, 0xdc, 0xcc, 0x48, 0xe8, 0x89, 0x49, 0xd0, 0x12, 0xba, 0xc3, 0x7f, 0x1a, 0xd0, 0x96, 0xa3,
	0x09, 0x1f, 0x3b, 0x91, 0x03, 0xdb, 0xc9, 0x19, 0x0c, 0x3d, 0xcd, 0x9f, 0x4a, 0x53, 0xa3, 0xb5,
	0xf1, 0xac, 0x88, 0x2a, 0xcf, 0xc0, 0xdc, 0xfa, 0xac, 0x84, 0x08, 0x74, 0xd2, 0xa3, 0x11, 0x7a,
	0x9e, 0x6d, 0x23, 0x67, 0x16, 0x33, 0x06, 0x45, 0xd5, 0xa5, 0x5b, 0x74, 0xc5, 0xee, 0x8c, 0x3a,
	0xcf, 0xa0, 0x5b, 0xcd, 0xa8, 0x23, 0x94, 0xb1, 0x57, 0x58, 0x3f, 0xf6, 0xfb, 0x0b, 0xdc, 0x53,
	0x5e, 0x5c, 0x94, 0x83, 0x56, 0xd6, 0x74, 0x64, 0x7c, 0x52, 0x48, 0x37, 0xf6, 0xb5, 0x84, 0xb6,
	0xda, 0xc6, 0x50, 0x8e, 0x81, 0xcc, 0x37, 0xc6, 0xf8, 0xb4, 0x98, 0x72, 0xec, 0x8e, 0x40, 0x27,
	0xdd, 0x43, 0xf2, 0x78, 0xcc, 0xe9, 0x88, 0x79, 0x3c, 0xe6, 0xb5, 0x26, 0x73, 0x0b, 0xd9, 0x00,
	0x37, 0x2d, 0x04, 0x3d, 0xc9, 0x25, 0x44, 0xed, 0x3c, 0x46, 0xff, 0x76, 0xc5, 0xd8, 0xc5, 0x0a,
	0xde, 0x49, 0xbd, 0xe8, 0x28, 0x07, 0x9a, 0xec, 0x01, 0xc8, 0x78, 0x5e, 0x50, 0x3b, 0x95, 0x94,
	0xe8, 0x4a, 0x1b, 0x92, 0x52, 0x5b, 0xde, 0x86, 0xa4, 0x52, 0x0d, 0xce, 0xdc, 0x42, 0x0e, 0xb4,
	0xad, 0xd0, 0x13, 0xae, 0xa3, 0xb6, 0x80, 0x72, 0x4e, 0xaf, 0x77, 0x35, 0xe3, 0x69, 0x01, 0xcd,
	0x9b, 0xfa, 0x7e, 0x01, 0x3f, 0x36, 0xa4, 0xea, 0x79, 0x8d, 0xfd, 0x57, 0xfe, 0xc5, 0x7f, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x38, 0x07, 0x4c, 0x12, 0x83, 0x10, 0x00, 0x00,
}
