// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Package Package
//
// Package object
// swagger:model Package
type Package struct {

	// channels
	Channels []string `json:"channels"`

	// content
	Content *OciDescriptor `json:"content,omitempty"`

	// created_at
	//
	// Package creation date
	// Pattern: \d{4}-\d{1,2}-\d{1,2}T\d{2}:\d{2}:\d{2}.\d+
	CreatedAt string `json:"created_at,omitempty"`

	// media-type
	//
	// manifest-type
	MediaType string `json:"mediaType,omitempty"`

	// package-name
	//
	// Package name
	Package string `json:"package,omitempty"`

	// package-release
	//
	// Package release
	Release string `json:"release,omitempty"`
}

// Validate validates this package
func (m *Package) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Package) validateContent(formats strfmt.Registry) error {

	if swag.IsZero(m.Content) { // not required
		return nil
	}

	if m.Content != nil {
		if err := m.Content.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("content")
			}
			return err
		}
	}

	return nil
}

func (m *Package) validateCreatedAt(formats strfmt.Registry) error {

	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.Pattern("created_at", "body", string(m.CreatedAt), `\d{4}-\d{1,2}-\d{1,2}T\d{2}:\d{2}:\d{2}.\d+`); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Package) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Package) UnmarshalBinary(b []byte) error {
	var res Package
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
