/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "github.com/kubernetes-csi/external-snapshotter/pkg/apis/volumesnapshot/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeVolumeSnapshotContents implements VolumeSnapshotContentInterface
type FakeVolumeSnapshotContents struct {
	Fake *FakeSnapshotV1alpha1
}

var volumesnapshotcontentsResource = schema.GroupVersionResource{Group: "snapshot.storage.k8s.io", Version: "v1alpha1", Resource: "volumesnapshotcontents"}

var volumesnapshotcontentsKind = schema.GroupVersionKind{Group: "snapshot.storage.k8s.io", Version: "v1alpha1", Kind: "VolumeSnapshotContent"}

// Get takes name of the volumeSnapshotContent, and returns the corresponding volumeSnapshotContent object, and an error if there is any.
func (c *FakeVolumeSnapshotContents) Get(name string, options v1.GetOptions) (result *v1alpha1.VolumeSnapshotContent, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(volumesnapshotcontentsResource, name), &v1alpha1.VolumeSnapshotContent{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VolumeSnapshotContent), err
}

// List takes label and field selectors, and returns the list of VolumeSnapshotContents that match those selectors.
func (c *FakeVolumeSnapshotContents) List(opts v1.ListOptions) (result *v1alpha1.VolumeSnapshotContentList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(volumesnapshotcontentsResource, volumesnapshotcontentsKind, opts), &v1alpha1.VolumeSnapshotContentList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.VolumeSnapshotContentList{ListMeta: obj.(*v1alpha1.VolumeSnapshotContentList).ListMeta}
	for _, item := range obj.(*v1alpha1.VolumeSnapshotContentList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested volumeSnapshotContents.
func (c *FakeVolumeSnapshotContents) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(volumesnapshotcontentsResource, opts))
}

// Create takes the representation of a volumeSnapshotContent and creates it.  Returns the server's representation of the volumeSnapshotContent, and an error, if there is any.
func (c *FakeVolumeSnapshotContents) Create(volumeSnapshotContent *v1alpha1.VolumeSnapshotContent) (result *v1alpha1.VolumeSnapshotContent, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(volumesnapshotcontentsResource, volumeSnapshotContent), &v1alpha1.VolumeSnapshotContent{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VolumeSnapshotContent), err
}

// Update takes the representation of a volumeSnapshotContent and updates it. Returns the server's representation of the volumeSnapshotContent, and an error, if there is any.
func (c *FakeVolumeSnapshotContents) Update(volumeSnapshotContent *v1alpha1.VolumeSnapshotContent) (result *v1alpha1.VolumeSnapshotContent, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(volumesnapshotcontentsResource, volumeSnapshotContent), &v1alpha1.VolumeSnapshotContent{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VolumeSnapshotContent), err
}

// Delete takes name of the volumeSnapshotContent and deletes it. Returns an error if one occurs.
func (c *FakeVolumeSnapshotContents) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(volumesnapshotcontentsResource, name), &v1alpha1.VolumeSnapshotContent{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVolumeSnapshotContents) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(volumesnapshotcontentsResource, listOptions)

	_, err := c.Fake.Invokes(action, &v1alpha1.VolumeSnapshotContentList{})
	return err
}

// Patch applies the patch and returns the patched volumeSnapshotContent.
func (c *FakeVolumeSnapshotContents) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.VolumeSnapshotContent, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(volumesnapshotcontentsResource, name, pt, data, subresources...), &v1alpha1.VolumeSnapshotContent{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VolumeSnapshotContent), err
}
