// Code generated by go-swagger; DO NOT EDIT.

package appr

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewPullPackageJSONParams creates a new PullPackageJSONParams object
// with the default values initialized.
func NewPullPackageJSONParams() *PullPackageJSONParams {
	var ()
	return &PullPackageJSONParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewPullPackageJSONParamsWithTimeout creates a new PullPackageJSONParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPullPackageJSONParamsWithTimeout(timeout time.Duration) *PullPackageJSONParams {
	var ()
	return &PullPackageJSONParams{

		timeout: timeout,
	}
}

// NewPullPackageJSONParamsWithContext creates a new PullPackageJSONParams object
// with the default values initialized, and the ability to set a context for a request
func NewPullPackageJSONParamsWithContext(ctx context.Context) *PullPackageJSONParams {
	var ()
	return &PullPackageJSONParams{

		Context: ctx,
	}
}

// NewPullPackageJSONParamsWithHTTPClient creates a new PullPackageJSONParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPullPackageJSONParamsWithHTTPClient(client *http.Client) *PullPackageJSONParams {
	var ()
	return &PullPackageJSONParams{
		HTTPClient: client,
	}
}

/*PullPackageJSONParams contains all the parameters to send to the API endpoint
for the pull package Json operation typically these are written to a http.Request
*/
type PullPackageJSONParams struct {

	/*Format
	  reponse format: json or blob

	*/
	Format *string
	/*MediaType
	  content type

	*/
	MediaType string
	/*Namespace
	  namespace

	*/
	Namespace string
	/*Package
	  package name

	*/
	Package string
	/*Release
	  release name

	*/
	Release string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the pull package Json params
func (o *PullPackageJSONParams) WithTimeout(timeout time.Duration) *PullPackageJSONParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the pull package Json params
func (o *PullPackageJSONParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the pull package Json params
func (o *PullPackageJSONParams) WithContext(ctx context.Context) *PullPackageJSONParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the pull package Json params
func (o *PullPackageJSONParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the pull package Json params
func (o *PullPackageJSONParams) WithHTTPClient(client *http.Client) *PullPackageJSONParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the pull package Json params
func (o *PullPackageJSONParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFormat adds the format to the pull package Json params
func (o *PullPackageJSONParams) WithFormat(format *string) *PullPackageJSONParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the pull package Json params
func (o *PullPackageJSONParams) SetFormat(format *string) {
	o.Format = format
}

// WithMediaType adds the mediaType to the pull package Json params
func (o *PullPackageJSONParams) WithMediaType(mediaType string) *PullPackageJSONParams {
	o.SetMediaType(mediaType)
	return o
}

// SetMediaType adds the mediaType to the pull package Json params
func (o *PullPackageJSONParams) SetMediaType(mediaType string) {
	o.MediaType = mediaType
}

// WithNamespace adds the namespace to the pull package Json params
func (o *PullPackageJSONParams) WithNamespace(namespace string) *PullPackageJSONParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the pull package Json params
func (o *PullPackageJSONParams) SetNamespace(namespace string) {
	o.Namespace = namespace
}

// WithPackage adds the packageVar to the pull package Json params
func (o *PullPackageJSONParams) WithPackage(packageVar string) *PullPackageJSONParams {
	o.SetPackage(packageVar)
	return o
}

// SetPackage adds the package to the pull package Json params
func (o *PullPackageJSONParams) SetPackage(packageVar string) {
	o.Package = packageVar
}

// WithRelease adds the release to the pull package Json params
func (o *PullPackageJSONParams) WithRelease(release string) *PullPackageJSONParams {
	o.SetRelease(release)
	return o
}

// SetRelease adds the release to the pull package Json params
func (o *PullPackageJSONParams) SetRelease(release string) {
	o.Release = release
}

// WriteToRequest writes these params to a swagger request
func (o *PullPackageJSONParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Format != nil {

		// query param format
		var qrFormat string
		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {
			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}

	}

	// path param media_type
	if err := r.SetPathParam("media_type", o.MediaType); err != nil {
		return err
	}

	// path param namespace
	if err := r.SetPathParam("namespace", o.Namespace); err != nil {
		return err
	}

	// path param package
	if err := r.SetPathParam("package", o.Package); err != nil {
		return err
	}

	// path param release
	if err := r.SetPathParam("release", o.Release); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
