// Code generated by go-swagger; DO NOT EDIT.

package channel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/operator-framework/go-appr/models"
)

// ListChannelsReader is a Reader for the ListChannels structure.
type ListChannelsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListChannelsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewListChannelsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 401:
		result := NewListChannelsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewListChannelsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewListChannelsOK creates a ListChannelsOK with default headers values
func NewListChannelsOK() *ListChannelsOK {
	return &ListChannelsOK{}
}

/*ListChannelsOK handles this case with default header values.

successful operation
*/
type ListChannelsOK struct {
	Payload []*models.Channel
}

func (o *ListChannelsOK) Error() string {
	return fmt.Sprintf("[GET /api/v1/packages/{namespace}/{package}/channels][%d] listChannelsOK  %+v", 200, o.Payload)
}

func (o *ListChannelsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListChannelsUnauthorized creates a ListChannelsUnauthorized with default headers values
func NewListChannelsUnauthorized() *ListChannelsUnauthorized {
	return &ListChannelsUnauthorized{}
}

/*ListChannelsUnauthorized handles this case with default header values.

Not authorized to read the package
*/
type ListChannelsUnauthorized struct {
	Payload *models.Error
}

func (o *ListChannelsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /api/v1/packages/{namespace}/{package}/channels][%d] listChannelsUnauthorized  %+v", 401, o.Payload)
}

func (o *ListChannelsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListChannelsNotFound creates a ListChannelsNotFound with default headers values
func NewListChannelsNotFound() *ListChannelsNotFound {
	return &ListChannelsNotFound{}
}

/*ListChannelsNotFound handles this case with default header values.

Package not found
*/
type ListChannelsNotFound struct {
	Payload *models.Error
}

func (o *ListChannelsNotFound) Error() string {
	return fmt.Sprintf("[GET /api/v1/packages/{namespace}/{package}/channels][%d] listChannelsNotFound  %+v", 404, o.Payload)
}

func (o *ListChannelsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
