// Code generated by go-swagger; DO NOT EDIT.

package channel

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/operator-framework/go-appr/models"
)

// CreateChannelReader is a Reader for the CreateChannel structure.
type CreateChannelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateChannelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewCreateChannelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 401:
		result := NewCreateChannelUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 404:
		result := NewCreateChannelNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 409:
		result := NewCreateChannelConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewCreateChannelOK creates a CreateChannelOK with default headers values
func NewCreateChannelOK() *CreateChannelOK {
	return &CreateChannelOK{}
}

/*CreateChannelOK handles this case with default header values.

successful operation
*/
type CreateChannelOK struct {
	Payload *models.Channel
}

func (o *CreateChannelOK) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages/{namespace}/{package}/channels][%d] createChannelOK  %+v", 200, o.Payload)
}

func (o *CreateChannelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Channel)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateChannelUnauthorized creates a CreateChannelUnauthorized with default headers values
func NewCreateChannelUnauthorized() *CreateChannelUnauthorized {
	return &CreateChannelUnauthorized{}
}

/*CreateChannelUnauthorized handles this case with default header values.

Not authorized to create the channel
*/
type CreateChannelUnauthorized struct {
	Payload *models.Error
}

func (o *CreateChannelUnauthorized) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages/{namespace}/{package}/channels][%d] createChannelUnauthorized  %+v", 401, o.Payload)
}

func (o *CreateChannelUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateChannelNotFound creates a CreateChannelNotFound with default headers values
func NewCreateChannelNotFound() *CreateChannelNotFound {
	return &CreateChannelNotFound{}
}

/*CreateChannelNotFound handles this case with default header values.

Package not found
*/
type CreateChannelNotFound struct {
	Payload *models.Error
}

func (o *CreateChannelNotFound) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages/{namespace}/{package}/channels][%d] createChannelNotFound  %+v", 404, o.Payload)
}

func (o *CreateChannelNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateChannelConflict creates a CreateChannelConflict with default headers values
func NewCreateChannelConflict() *CreateChannelConflict {
	return &CreateChannelConflict{}
}

/*CreateChannelConflict handles this case with default header values.

Channel already exists
*/
type CreateChannelConflict struct {
	Payload *models.Error
}

func (o *CreateChannelConflict) Error() string {
	return fmt.Sprintf("[POST /api/v1/packages/{namespace}/{package}/channels][%d] createChannelConflict  %+v", 409, o.Payload)
}

func (o *CreateChannelConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
