# KubeVirt Adopters

| Type | Name | Since | Website | Use-Case |
|:-|:-|:-|:-|:-|
| End-User | arm | 2021 | [link](https://www.arm.com) | KubeVirt enables seamless transition from legacy Virtual Machine based workloads to cloud-native container platforms. Arm believes KubeVirt addresses this challenge, allowing Virtual Machines workloads to easily deploy and scale in the cloud and at the edge. <br><br>Arm is an active contributor to the project, focused on enabling and optimizing Kubevirt performance on aarch64 and working with the ecosystem to facilitate users in deploying their workloads on cloud-native platforms. |
| End-user| Civo | 2020 | [link](https://www.civo.com) | We are using KubeVirt as part of our stack to enable tenant cluster provisioning within Civo cloud. |
| End-user | CoreWeave | 2020 | [link](https://www.coreweave.com) | A Kubernetes native cloud provider with focus on GPUs at scale. KubeVirt allows us to co-locate non-containerizable workloads such as Virtual Desktops next to compute intensive containers executing on bare metal. All orchestrated via the Kubernetes API leveraging the same network policies and persistent volumes for both VM and containerized workloads. |
| End-user | NVIDIA | 2018 | [link](https://www.nvidia.com) | NVIDIA's latest computing platform is built on open-source projects like Kubernetes and KubeVirt to power products like [GeForce NOW](https://www.nvidia.com/en-us/geforce-now/) with more to come. |
| Integration | minikube | 2020 | [link](https://minikube.sigs.k8s.io) | |
| Integration | oVirt | | [link](https://www.ovirt.org/documentation/administration_guide/index.html#proc-adding-kubevirt-openshift-as-an-external-provider_external_providers) | |
| Integration | okd | 2020 | [link](https://minikube.sigs.k8s.io) | |
| Vendor | EQUINIX | | [link](https://metal.equinix.com/) | |
| Vendor | H3C | 2019 | [link](https://www.h3c.com/en/Products_Technology/Enterprise_Products/Cloud_Computing/Cloud_Computing_Products/H3C_CloudOS/H3C_CloudOS_full-stack/) | We distribute KubeVirt as part of CloudOS to enable VM workloads on Kubernetes at customer sites. |
| Vendor | KUBERMATIC | 2019 | [link](https://www.kubermatic.com/products/kubevirt/) | As a distributor we are running KubeVirt to enable VM workload on Kubermatic Virtualization. |
| Vendor | PLATFORM9 | | [link](https://platform9.com/managed-kubevirt/) | Run Legacy and Cloud-Native Applications on Platform9 |
| Vendor | Red Hat, Inc. | 2016 | [link](https://www.redhat.com) | As a distributor we are building OpenShift Virtualization on KubeVirt in order to enable VM workloads and -flows on Kubernetes. |
| Vendor | SUSE | 2020 | [link](https://www.suse.com/) | SUSE believes KubeVirt is the best open source way to handle Virtual Machines on Kubernetes today. We offer this additional possibility to our customers by leveraging KubeVirt in our products. |
