/*
Copyright 2022 The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"

	v1alpha1 "kubevirt.io/api/flavor/v1alpha1"
)

// FakeVirtualMachineClusterFlavors implements VirtualMachineClusterFlavorInterface
type FakeVirtualMachineClusterFlavors struct {
	Fake *FakeFlavorV1alpha1
}

var virtualmachineclusterflavorsResource = schema.GroupVersionResource{Group: "flavor.kubevirt.io", Version: "v1alpha1", Resource: "virtualmachineclusterflavors"}

var virtualmachineclusterflavorsKind = schema.GroupVersionKind{Group: "flavor.kubevirt.io", Version: "v1alpha1", Kind: "VirtualMachineClusterFlavor"}

// Get takes name of the virtualMachineClusterFlavor, and returns the corresponding virtualMachineClusterFlavor object, and an error if there is any.
func (c *FakeVirtualMachineClusterFlavors) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.VirtualMachineClusterFlavor, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(virtualmachineclusterflavorsResource, name), &v1alpha1.VirtualMachineClusterFlavor{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachineClusterFlavor), err
}

// List takes label and field selectors, and returns the list of VirtualMachineClusterFlavors that match those selectors.
func (c *FakeVirtualMachineClusterFlavors) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.VirtualMachineClusterFlavorList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(virtualmachineclusterflavorsResource, virtualmachineclusterflavorsKind, opts), &v1alpha1.VirtualMachineClusterFlavorList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.VirtualMachineClusterFlavorList{ListMeta: obj.(*v1alpha1.VirtualMachineClusterFlavorList).ListMeta}
	for _, item := range obj.(*v1alpha1.VirtualMachineClusterFlavorList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested virtualMachineClusterFlavors.
func (c *FakeVirtualMachineClusterFlavors) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(virtualmachineclusterflavorsResource, opts))
}

// Create takes the representation of a virtualMachineClusterFlavor and creates it.  Returns the server's representation of the virtualMachineClusterFlavor, and an error, if there is any.
func (c *FakeVirtualMachineClusterFlavors) Create(ctx context.Context, virtualMachineClusterFlavor *v1alpha1.VirtualMachineClusterFlavor, opts v1.CreateOptions) (result *v1alpha1.VirtualMachineClusterFlavor, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(virtualmachineclusterflavorsResource, virtualMachineClusterFlavor), &v1alpha1.VirtualMachineClusterFlavor{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachineClusterFlavor), err
}

// Update takes the representation of a virtualMachineClusterFlavor and updates it. Returns the server's representation of the virtualMachineClusterFlavor, and an error, if there is any.
func (c *FakeVirtualMachineClusterFlavors) Update(ctx context.Context, virtualMachineClusterFlavor *v1alpha1.VirtualMachineClusterFlavor, opts v1.UpdateOptions) (result *v1alpha1.VirtualMachineClusterFlavor, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(virtualmachineclusterflavorsResource, virtualMachineClusterFlavor), &v1alpha1.VirtualMachineClusterFlavor{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachineClusterFlavor), err
}

// Delete takes name of the virtualMachineClusterFlavor and deletes it. Returns an error if one occurs.
func (c *FakeVirtualMachineClusterFlavors) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(virtualmachineclusterflavorsResource, name), &v1alpha1.VirtualMachineClusterFlavor{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVirtualMachineClusterFlavors) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(virtualmachineclusterflavorsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.VirtualMachineClusterFlavorList{})
	return err
}

// Patch applies the patch and returns the patched virtualMachineClusterFlavor.
func (c *FakeVirtualMachineClusterFlavors) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.VirtualMachineClusterFlavor, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(virtualmachineclusterflavorsResource, name, pt, data, subresources...), &v1alpha1.VirtualMachineClusterFlavor{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.VirtualMachineClusterFlavor), err
}
