package static

import (
	"github.com/machacekondra/fakeovirt/internal/app/imagetransfer"
	"io/ioutil"
	"net/http"
	"os"
	"strings"
)

const (
	defaultNamespace      = "cdi"
	defaultAuthToken      = "thessotoken"
	jsonContentType       = "application/json"
	xmlContentType        = "application/xml"
	defaultSize           = "46137344"
	defaultImageioService = "imageio"
	defaultImageioPort    = "12345"
	defaultImageioImage   = "cirros"
)

var images = map[string]string{
	"invalid": "invalid",
}

// GetNamespace endpoint return the namespace which will be used by fake ovirt
func GetNamespace(w http.ResponseWriter, r *http.Request) {
	namespace, available := os.LookupEnv("NAMESPACE")
	if !available {
		namespace = defaultNamespace
	}

	setContentType(w, jsonContentType)
	w.Write([]byte("{\"namespace\": \"" + namespace + "\"}"))
}

// SsoToken endpoint fake the answer to SSO token request
func SsoToken(w http.ResponseWriter, r *http.Request) {
	token, available := os.LookupEnv("TOKEN")
	if !available {
		token = defaultAuthToken
	}

	setContentType(w, jsonContentType)
	w.Write([]byte("{\"access_token\":\"" + token + "\",\"scope\":\"\",\"exp\":\"9223372036854775807\",\"token_type\":\"bearer\"}"))
}

// OvirtVms host Vms endpotint
func OvirtVms(w http.ResponseWriter, r *http.Request) {
	//TODO: add support for searching with name and cluster name
	setContentType(w, xmlContentType)
	content, err := ioutil.ReadFile("stubs/vms/123/content")
	if err != nil {
		w.Write([]byte("<error/>"))
	}
	w.Write([]byte("<vms>" + string(content) + "</vms>"))
}

func OvirtVMSubresource(vmsPrefix string) func(w http.ResponseWriter, r *http.Request) {
	return func(w http.ResponseWriter, r *http.Request) {
		vmID := r.URL.Path[len(vmsPrefix):]
		setContentType(w, xmlContentType)
		content, err := ioutil.ReadFile("stubs/vms/" + vmID)
		if err != nil {
			w.Write([]byte("<error/>"))
		}
		w.Write(content)
	}
}

func OvirtResoruceHandler(resource string) func(http.ResponseWriter, *http.Request) {
	return func(w http.ResponseWriter, r *http.Request) {
		id := r.URL.Query().Get(":id")
		setContentType(w, xmlContentType)
		content, err := ioutil.ReadFile("stubs/" + resource + "/" + id + "/content")
		if err != nil {
			w.Write([]byte("<error/>"))
		}
		w.Write(content)
	}
}

// OvirtDisks host disks endpoint
func OvirtDisks(w http.ResponseWriter, r *http.Request) {
	diskSize, available := os.LookupEnv("DISKSIZE")
	if !available {
		diskSize = defaultSize
	}

	id := r.URL.Query().Get(":id")
	setContentType(w, xmlContentType)
	content, err := ioutil.ReadFile("stubs/disks/" + id + "/content")
	if err != nil {
		w.Write([]byte("<error/>"))
	}
	w.Write([]byte(strings.ReplaceAll(string(content), "@DISKSIZE", diskSize)))
}

// OvirtImageTransfers host imagetransfer endpoint
func OvirtImageTransfers(w http.ResponseWriter, r *http.Request) {
	port, available := os.LookupEnv("PORT")
	if !available {
		port = defaultImageioPort
	}
	service, available := os.LookupEnv("SERVICE")
	if !available {
		service = defaultImageioService

	}
	imageName, available := images[imagetransfer.GetImageId(r)]
	if !available {
		imageName = defaultImageioImage

	}
	namespace, available := os.LookupEnv("NAMESPACE")
	if !available {
		namespace = defaultNamespace
	}

	setContentType(w, xmlContentType)
	w.Write([]byte("<image_transfer id=\"64302e7f-3f08-4d32-9fe1-59b6c383acb5\"><signed_ticket>abc123</signed_ticket><phase>transferring</phase><transfer_url>https://" + service + "." + namespace + ":" + port + "/images/" + imageName + "</transfer_url></image_transfer>"))
}

func setContentType(w http.ResponseWriter, contentType string) {
	w.Header().Set("Content-Type", contentType)
}