/*
Copyright 2020 The vm import Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	scheme "github.com/kubevirt/vm-import-operator/pkg/api-client/clientset/versioned/scheme"
	v1beta1 "github.com/kubevirt/vm-import-operator/pkg/apis/v2v/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ResourceMappingsGetter has a method to return a ResourceMappingInterface.
// A group's client should implement this interface.
type ResourceMappingsGetter interface {
	ResourceMappings(namespace string) ResourceMappingInterface
}

// ResourceMappingInterface has methods to work with ResourceMapping resources.
type ResourceMappingInterface interface {
	Create(ctx context.Context, resourceMapping *v1beta1.ResourceMapping, opts v1.CreateOptions) (*v1beta1.ResourceMapping, error)
	Update(ctx context.Context, resourceMapping *v1beta1.ResourceMapping, opts v1.UpdateOptions) (*v1beta1.ResourceMapping, error)
	UpdateStatus(ctx context.Context, resourceMapping *v1beta1.ResourceMapping, opts v1.UpdateOptions) (*v1beta1.ResourceMapping, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.ResourceMapping, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ResourceMappingList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ResourceMapping, err error)
	ResourceMappingExpansion
}

// resourceMappings implements ResourceMappingInterface
type resourceMappings struct {
	client rest.Interface
	ns     string
}

// newResourceMappings returns a ResourceMappings
func newResourceMappings(c *V2vV1beta1Client, namespace string) *resourceMappings {
	return &resourceMappings{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the resourceMapping, and returns the corresponding resourceMapping object, and an error if there is any.
func (c *resourceMappings) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.ResourceMapping, err error) {
	result = &v1beta1.ResourceMapping{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("resourcemappings").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ResourceMappings that match those selectors.
func (c *resourceMappings) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ResourceMappingList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.ResourceMappingList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("resourcemappings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested resourceMappings.
func (c *resourceMappings) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("resourcemappings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a resourceMapping and creates it.  Returns the server's representation of the resourceMapping, and an error, if there is any.
func (c *resourceMappings) Create(ctx context.Context, resourceMapping *v1beta1.ResourceMapping, opts v1.CreateOptions) (result *v1beta1.ResourceMapping, err error) {
	result = &v1beta1.ResourceMapping{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("resourcemappings").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resourceMapping).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a resourceMapping and updates it. Returns the server's representation of the resourceMapping, and an error, if there is any.
func (c *resourceMappings) Update(ctx context.Context, resourceMapping *v1beta1.ResourceMapping, opts v1.UpdateOptions) (result *v1beta1.ResourceMapping, err error) {
	result = &v1beta1.ResourceMapping{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("resourcemappings").
		Name(resourceMapping.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resourceMapping).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *resourceMappings) UpdateStatus(ctx context.Context, resourceMapping *v1beta1.ResourceMapping, opts v1.UpdateOptions) (result *v1beta1.ResourceMapping, err error) {
	result = &v1beta1.ResourceMapping{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("resourcemappings").
		Name(resourceMapping.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(resourceMapping).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the resourceMapping and deletes it. Returns an error if one occurs.
func (c *resourceMappings) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("resourcemappings").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *resourceMappings) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("resourcemappings").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched resourceMapping.
func (c *resourceMappings) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ResourceMapping, err error) {
	result = &v1beta1.ResourceMapping{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("resourcemappings").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
