import ExecutionPathOptions from '../ExecutionPathOptions';
import MagicString from 'magic-string';
import { ExpressionNode, NodeBase } from './shared/Node';
import { NodeType } from './NodeType';
import { NodeRenderOptions, RenderOptions } from '../../utils/renderHelpers';
import { ObjectPath } from '../values';
import CallOptions from '../CallOptions';
import { ForEachReturnExpressionCallback } from './shared/Expression';
export default class SequenceExpression extends NodeBase {
    type: NodeType.SequenceExpression;
    expressions: ExpressionNode[];
    forEachReturnExpressionWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, callback: ForEachReturnExpressionCallback, options: ExecutionPathOptions): void;
    getValue(): any;
    hasEffects(options: ExecutionPathOptions): boolean;
    hasEffectsWhenAccessedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenAssignedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, options: ExecutionPathOptions): boolean;
    includeInBundle(): boolean;
    reassignPath(path: ObjectPath, options: ExecutionPathOptions): void;
    render(code: MagicString, options: RenderOptions, {renderedParentType, isCalleeOfRenderedParent}?: NodeRenderOptions): void;
}
