import { ObjectPath } from '../values';
import CallOptions from '../CallOptions';
import ExecutionPathOptions from '../ExecutionPathOptions';
import { ForEachReturnExpressionCallback, SomeReturnExpressionCallback } from './shared/Expression';
import { NodeType } from './NodeType';
import { ExpressionNode, NodeBase } from './shared/Node';
import { NodeRenderOptions, RenderOptions } from '../../utils/renderHelpers';
import MagicString from 'magic-string';
export declare type LogicalOperator = '||' | '&&';
export default class LogicalExpression extends NodeBase {
    type: NodeType.LogicalExpression;
    operator: LogicalOperator;
    left: ExpressionNode;
    right: ExpressionNode;
    forEachReturnExpressionWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, callback: ForEachReturnExpressionCallback, options: ExecutionPathOptions): void;
    getValue(): any;
    hasEffects(options: ExecutionPathOptions): boolean;
    hasEffectsWhenAccessedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenAssignedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, options: ExecutionPathOptions): boolean;
    includeInBundle(): boolean;
    reassignPath(path: ObjectPath, options: ExecutionPathOptions): void;
    render(code: MagicString, options: RenderOptions, {renderedParentType, isCalleeOfRenderedParent}?: NodeRenderOptions): void;
    someReturnExpressionWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, predicateFunction: SomeReturnExpressionCallback, options: ExecutionPathOptions): boolean;
    private forEachRelevantBranch(callback);
    private someRelevantBranch(predicateFunction);
}
