// +build !ignore_autogenerated

/*
Copyright 2020 The Jetstack cert-manager contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	unsafe "unsafe"

	v1alpha2 "github.com/jetstack/cert-manager/pkg/apis/acme/v1alpha2"
	metav1 "github.com/jetstack/cert-manager/pkg/apis/meta/v1"
	acme "github.com/jetstack/cert-manager/pkg/internal/apis/acme"
	meta "github.com/jetstack/cert-manager/pkg/internal/apis/meta"
	v1 "k8s.io/api/core/v1"
	v1beta1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1"
	apismetav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEAuthorization)(nil), (*acme.ACMEAuthorization)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEAuthorization_To_acme_ACMEAuthorization(a.(*v1alpha2.ACMEAuthorization), b.(*acme.ACMEAuthorization), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEAuthorization)(nil), (*v1alpha2.ACMEAuthorization)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEAuthorization_To_v1alpha2_ACMEAuthorization(a.(*acme.ACMEAuthorization), b.(*v1alpha2.ACMEAuthorization), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallenge)(nil), (*acme.ACMEChallenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallenge_To_acme_ACMEChallenge(a.(*v1alpha2.ACMEChallenge), b.(*acme.ACMEChallenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallenge)(nil), (*v1alpha2.ACMEChallenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallenge_To_v1alpha2_ACMEChallenge(a.(*acme.ACMEChallenge), b.(*v1alpha2.ACMEChallenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolver)(nil), (*acme.ACMEChallengeSolver)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(a.(*v1alpha2.ACMEChallengeSolver), b.(*acme.ACMEChallengeSolver), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolver)(nil), (*v1alpha2.ACMEChallengeSolver)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolver_To_v1alpha2_ACMEChallengeSolver(a.(*acme.ACMEChallengeSolver), b.(*v1alpha2.ACMEChallengeSolver), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverDNS01)(nil), (*acme.ACMEChallengeSolverDNS01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(a.(*v1alpha2.ACMEChallengeSolverDNS01), b.(*acme.ACMEChallengeSolverDNS01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverDNS01)(nil), (*v1alpha2.ACMEChallengeSolverDNS01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverDNS01_To_v1alpha2_ACMEChallengeSolverDNS01(a.(*acme.ACMEChallengeSolverDNS01), b.(*v1alpha2.ACMEChallengeSolverDNS01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverHTTP01)(nil), (*acme.ACMEChallengeSolverHTTP01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(a.(*v1alpha2.ACMEChallengeSolverHTTP01), b.(*acme.ACMEChallengeSolverHTTP01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01)(nil), (*v1alpha2.ACMEChallengeSolverHTTP01)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01_To_v1alpha2_ACMEChallengeSolverHTTP01(a.(*acme.ACMEChallengeSolverHTTP01), b.(*v1alpha2.ACMEChallengeSolverHTTP01), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverHTTP01Ingress)(nil), (*acme.ACMEChallengeSolverHTTP01Ingress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(a.(*v1alpha2.ACMEChallengeSolverHTTP01Ingress), b.(*acme.ACMEChallengeSolverHTTP01Ingress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01Ingress)(nil), (*v1alpha2.ACMEChallengeSolverHTTP01Ingress)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1alpha2_ACMEChallengeSolverHTTP01Ingress(a.(*acme.ACMEChallengeSolverHTTP01Ingress), b.(*v1alpha2.ACMEChallengeSolverHTTP01Ingress), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), (*acme.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(a.(*v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta), b.(*acme.ACMEChallengeSolverHTTP01IngressObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), (*v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta(a.(*acme.ACMEChallengeSolverHTTP01IngressObjectMeta), b.(*v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(a.(*v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta), b.(*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), (*v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta(a.(*acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta), b.(*v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(a.(*v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec), b.(*acme.ACMEChallengeSolverHTTP01IngressPodSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), (*v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec(a.(*acme.ACMEChallengeSolverHTTP01IngressPodSpec), b.(*v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), (*acme.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(a.(*v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate), b.(*acme.ACMEChallengeSolverHTTP01IngressPodTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), (*v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate(a.(*acme.ACMEChallengeSolverHTTP01IngressPodTemplate), b.(*v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate)(nil), (*acme.ACMEChallengeSolverHTTP01IngressTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(a.(*v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate), b.(*acme.ACMEChallengeSolverHTTP01IngressTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEChallengeSolverHTTP01IngressTemplate)(nil), (*v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate(a.(*acme.ACMEChallengeSolverHTTP01IngressTemplate), b.(*v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEExternalAccountBinding)(nil), (*acme.ACMEExternalAccountBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(a.(*v1alpha2.ACMEExternalAccountBinding), b.(*acme.ACMEExternalAccountBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEExternalAccountBinding)(nil), (*v1alpha2.ACMEExternalAccountBinding)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEExternalAccountBinding_To_v1alpha2_ACMEExternalAccountBinding(a.(*acme.ACMEExternalAccountBinding), b.(*v1alpha2.ACMEExternalAccountBinding), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuer)(nil), (*acme.ACMEIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuer_To_acme_ACMEIssuer(a.(*v1alpha2.ACMEIssuer), b.(*acme.ACMEIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuer)(nil), (*v1alpha2.ACMEIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuer_To_v1alpha2_ACMEIssuer(a.(*acme.ACMEIssuer), b.(*v1alpha2.ACMEIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS)(nil), (*acme.ACMEIssuerDNS01ProviderAcmeDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(a.(*v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS), b.(*acme.ACMEIssuerDNS01ProviderAcmeDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderAcmeDNS)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS(a.(*acme.ACMEIssuerDNS01ProviderAcmeDNS), b.(*v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderAkamai)(nil), (*acme.ACMEIssuerDNS01ProviderAkamai)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(a.(*v1alpha2.ACMEIssuerDNS01ProviderAkamai), b.(*acme.ACMEIssuerDNS01ProviderAkamai), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderAkamai)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderAkamai)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1alpha2_ACMEIssuerDNS01ProviderAkamai(a.(*acme.ACMEIssuerDNS01ProviderAkamai), b.(*v1alpha2.ACMEIssuerDNS01ProviderAkamai), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderAzureDNS)(nil), (*acme.ACMEIssuerDNS01ProviderAzureDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(a.(*v1alpha2.ACMEIssuerDNS01ProviderAzureDNS), b.(*acme.ACMEIssuerDNS01ProviderAzureDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderAzureDNS)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderAzureDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS(a.(*acme.ACMEIssuerDNS01ProviderAzureDNS), b.(*v1alpha2.ACMEIssuerDNS01ProviderAzureDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderCloudDNS)(nil), (*acme.ACMEIssuerDNS01ProviderCloudDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(a.(*v1alpha2.ACMEIssuerDNS01ProviderCloudDNS), b.(*acme.ACMEIssuerDNS01ProviderCloudDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderCloudDNS)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderCloudDNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS(a.(*acme.ACMEIssuerDNS01ProviderCloudDNS), b.(*v1alpha2.ACMEIssuerDNS01ProviderCloudDNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderCloudflare)(nil), (*acme.ACMEIssuerDNS01ProviderCloudflare)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(a.(*v1alpha2.ACMEIssuerDNS01ProviderCloudflare), b.(*acme.ACMEIssuerDNS01ProviderCloudflare), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderCloudflare)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderCloudflare)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1alpha2_ACMEIssuerDNS01ProviderCloudflare(a.(*acme.ACMEIssuerDNS01ProviderCloudflare), b.(*v1alpha2.ACMEIssuerDNS01ProviderCloudflare), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean)(nil), (*acme.ACMEIssuerDNS01ProviderDigitalOcean)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(a.(*v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean), b.(*acme.ACMEIssuerDNS01ProviderDigitalOcean), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderDigitalOcean)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean(a.(*acme.ACMEIssuerDNS01ProviderDigitalOcean), b.(*v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderRFC2136)(nil), (*acme.ACMEIssuerDNS01ProviderRFC2136)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(a.(*v1alpha2.ACMEIssuerDNS01ProviderRFC2136), b.(*acme.ACMEIssuerDNS01ProviderRFC2136), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderRFC2136)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderRFC2136)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1alpha2_ACMEIssuerDNS01ProviderRFC2136(a.(*acme.ACMEIssuerDNS01ProviderRFC2136), b.(*v1alpha2.ACMEIssuerDNS01ProviderRFC2136), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderRoute53)(nil), (*acme.ACMEIssuerDNS01ProviderRoute53)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(a.(*v1alpha2.ACMEIssuerDNS01ProviderRoute53), b.(*acme.ACMEIssuerDNS01ProviderRoute53), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderRoute53)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderRoute53)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1alpha2_ACMEIssuerDNS01ProviderRoute53(a.(*acme.ACMEIssuerDNS01ProviderRoute53), b.(*v1alpha2.ACMEIssuerDNS01ProviderRoute53), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerDNS01ProviderWebhook)(nil), (*acme.ACMEIssuerDNS01ProviderWebhook)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(a.(*v1alpha2.ACMEIssuerDNS01ProviderWebhook), b.(*acme.ACMEIssuerDNS01ProviderWebhook), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerDNS01ProviderWebhook)(nil), (*v1alpha2.ACMEIssuerDNS01ProviderWebhook)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1alpha2_ACMEIssuerDNS01ProviderWebhook(a.(*acme.ACMEIssuerDNS01ProviderWebhook), b.(*v1alpha2.ACMEIssuerDNS01ProviderWebhook), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ACMEIssuerStatus)(nil), (*acme.ACMEIssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(a.(*v1alpha2.ACMEIssuerStatus), b.(*acme.ACMEIssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ACMEIssuerStatus)(nil), (*v1alpha2.ACMEIssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ACMEIssuerStatus_To_v1alpha2_ACMEIssuerStatus(a.(*acme.ACMEIssuerStatus), b.(*v1alpha2.ACMEIssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.CertificateDNSNameSelector)(nil), (*acme.CertificateDNSNameSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(a.(*v1alpha2.CertificateDNSNameSelector), b.(*acme.CertificateDNSNameSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.CertificateDNSNameSelector)(nil), (*v1alpha2.CertificateDNSNameSelector)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_CertificateDNSNameSelector_To_v1alpha2_CertificateDNSNameSelector(a.(*acme.CertificateDNSNameSelector), b.(*v1alpha2.CertificateDNSNameSelector), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.Challenge)(nil), (*acme.Challenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Challenge_To_acme_Challenge(a.(*v1alpha2.Challenge), b.(*acme.Challenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.Challenge)(nil), (*v1alpha2.Challenge)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_Challenge_To_v1alpha2_Challenge(a.(*acme.Challenge), b.(*v1alpha2.Challenge), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ChallengeList)(nil), (*acme.ChallengeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ChallengeList_To_acme_ChallengeList(a.(*v1alpha2.ChallengeList), b.(*acme.ChallengeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ChallengeList)(nil), (*v1alpha2.ChallengeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ChallengeList_To_v1alpha2_ChallengeList(a.(*acme.ChallengeList), b.(*v1alpha2.ChallengeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.ChallengeStatus)(nil), (*acme.ChallengeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ChallengeStatus_To_acme_ChallengeStatus(a.(*v1alpha2.ChallengeStatus), b.(*acme.ChallengeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.ChallengeStatus)(nil), (*v1alpha2.ChallengeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ChallengeStatus_To_v1alpha2_ChallengeStatus(a.(*acme.ChallengeStatus), b.(*v1alpha2.ChallengeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.Order)(nil), (*acme.Order)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Order_To_acme_Order(a.(*v1alpha2.Order), b.(*acme.Order), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.Order)(nil), (*v1alpha2.Order)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_Order_To_v1alpha2_Order(a.(*acme.Order), b.(*v1alpha2.Order), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.OrderList)(nil), (*acme.OrderList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_OrderList_To_acme_OrderList(a.(*v1alpha2.OrderList), b.(*acme.OrderList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.OrderList)(nil), (*v1alpha2.OrderList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_OrderList_To_v1alpha2_OrderList(a.(*acme.OrderList), b.(*v1alpha2.OrderList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha2.OrderStatus)(nil), (*acme.OrderStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_OrderStatus_To_acme_OrderStatus(a.(*v1alpha2.OrderStatus), b.(*acme.OrderStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*acme.OrderStatus)(nil), (*v1alpha2.OrderStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_OrderStatus_To_v1alpha2_OrderStatus(a.(*acme.OrderStatus), b.(*v1alpha2.OrderStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*acme.ChallengeSpec)(nil), (*v1alpha2.ChallengeSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_ChallengeSpec_To_v1alpha2_ChallengeSpec(a.(*acme.ChallengeSpec), b.(*v1alpha2.ChallengeSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*acme.OrderSpec)(nil), (*v1alpha2.OrderSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_acme_OrderSpec_To_v1alpha2_OrderSpec(a.(*acme.OrderSpec), b.(*v1alpha2.OrderSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha2.ChallengeSpec)(nil), (*acme.ChallengeSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_ChallengeSpec_To_acme_ChallengeSpec(a.(*v1alpha2.ChallengeSpec), b.(*acme.ChallengeSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha2.OrderSpec)(nil), (*acme.OrderSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_OrderSpec_To_acme_OrderSpec(a.(*v1alpha2.OrderSpec), b.(*acme.OrderSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_ACMEAuthorization_To_acme_ACMEAuthorization(in *v1alpha2.ACMEAuthorization, out *acme.ACMEAuthorization, s conversion.Scope) error {
	out.URL = in.URL
	out.Identifier = in.Identifier
	out.Wildcard = (*bool)(unsafe.Pointer(in.Wildcard))
	out.InitialState = acme.State(in.InitialState)
	out.Challenges = *(*[]acme.ACMEChallenge)(unsafe.Pointer(&in.Challenges))
	return nil
}

// Convert_v1alpha2_ACMEAuthorization_To_acme_ACMEAuthorization is an autogenerated conversion function.
func Convert_v1alpha2_ACMEAuthorization_To_acme_ACMEAuthorization(in *v1alpha2.ACMEAuthorization, out *acme.ACMEAuthorization, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEAuthorization_To_acme_ACMEAuthorization(in, out, s)
}

func autoConvert_acme_ACMEAuthorization_To_v1alpha2_ACMEAuthorization(in *acme.ACMEAuthorization, out *v1alpha2.ACMEAuthorization, s conversion.Scope) error {
	out.URL = in.URL
	out.Identifier = in.Identifier
	out.Wildcard = (*bool)(unsafe.Pointer(in.Wildcard))
	out.InitialState = v1alpha2.State(in.InitialState)
	out.Challenges = *(*[]v1alpha2.ACMEChallenge)(unsafe.Pointer(&in.Challenges))
	return nil
}

// Convert_acme_ACMEAuthorization_To_v1alpha2_ACMEAuthorization is an autogenerated conversion function.
func Convert_acme_ACMEAuthorization_To_v1alpha2_ACMEAuthorization(in *acme.ACMEAuthorization, out *v1alpha2.ACMEAuthorization, s conversion.Scope) error {
	return autoConvert_acme_ACMEAuthorization_To_v1alpha2_ACMEAuthorization(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallenge_To_acme_ACMEChallenge(in *v1alpha2.ACMEChallenge, out *acme.ACMEChallenge, s conversion.Scope) error {
	out.URL = in.URL
	out.Token = in.Token
	out.Type = in.Type
	return nil
}

// Convert_v1alpha2_ACMEChallenge_To_acme_ACMEChallenge is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallenge_To_acme_ACMEChallenge(in *v1alpha2.ACMEChallenge, out *acme.ACMEChallenge, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallenge_To_acme_ACMEChallenge(in, out, s)
}

func autoConvert_acme_ACMEChallenge_To_v1alpha2_ACMEChallenge(in *acme.ACMEChallenge, out *v1alpha2.ACMEChallenge, s conversion.Scope) error {
	out.URL = in.URL
	out.Token = in.Token
	out.Type = in.Type
	return nil
}

// Convert_acme_ACMEChallenge_To_v1alpha2_ACMEChallenge is an autogenerated conversion function.
func Convert_acme_ACMEChallenge_To_v1alpha2_ACMEChallenge(in *acme.ACMEChallenge, out *v1alpha2.ACMEChallenge, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallenge_To_v1alpha2_ACMEChallenge(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(in *v1alpha2.ACMEChallengeSolver, out *acme.ACMEChallengeSolver, s conversion.Scope) error {
	out.Selector = (*acme.CertificateDNSNameSelector)(unsafe.Pointer(in.Selector))
	out.HTTP01 = (*acme.ACMEChallengeSolverHTTP01)(unsafe.Pointer(in.HTTP01))
	out.DNS01 = (*acme.ACMEChallengeSolverDNS01)(unsafe.Pointer(in.DNS01))
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolver_To_acme_ACMEChallengeSolver is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(in *v1alpha2.ACMEChallengeSolver, out *acme.ACMEChallengeSolver, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolver_To_v1alpha2_ACMEChallengeSolver(in *acme.ACMEChallengeSolver, out *v1alpha2.ACMEChallengeSolver, s conversion.Scope) error {
	out.Selector = (*v1alpha2.CertificateDNSNameSelector)(unsafe.Pointer(in.Selector))
	out.HTTP01 = (*v1alpha2.ACMEChallengeSolverHTTP01)(unsafe.Pointer(in.HTTP01))
	out.DNS01 = (*v1alpha2.ACMEChallengeSolverDNS01)(unsafe.Pointer(in.DNS01))
	return nil
}

// Convert_acme_ACMEChallengeSolver_To_v1alpha2_ACMEChallengeSolver is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolver_To_v1alpha2_ACMEChallengeSolver(in *acme.ACMEChallengeSolver, out *v1alpha2.ACMEChallengeSolver, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolver_To_v1alpha2_ACMEChallengeSolver(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(in *v1alpha2.ACMEChallengeSolverDNS01, out *acme.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	out.CNAMEStrategy = acme.CNAMEStrategy(in.CNAMEStrategy)
	out.Akamai = (*acme.ACMEIssuerDNS01ProviderAkamai)(unsafe.Pointer(in.Akamai))
	out.CloudDNS = (*acme.ACMEIssuerDNS01ProviderCloudDNS)(unsafe.Pointer(in.CloudDNS))
	out.Cloudflare = (*acme.ACMEIssuerDNS01ProviderCloudflare)(unsafe.Pointer(in.Cloudflare))
	out.Route53 = (*acme.ACMEIssuerDNS01ProviderRoute53)(unsafe.Pointer(in.Route53))
	out.AzureDNS = (*acme.ACMEIssuerDNS01ProviderAzureDNS)(unsafe.Pointer(in.AzureDNS))
	out.DigitalOcean = (*acme.ACMEIssuerDNS01ProviderDigitalOcean)(unsafe.Pointer(in.DigitalOcean))
	out.AcmeDNS = (*acme.ACMEIssuerDNS01ProviderAcmeDNS)(unsafe.Pointer(in.AcmeDNS))
	out.RFC2136 = (*acme.ACMEIssuerDNS01ProviderRFC2136)(unsafe.Pointer(in.RFC2136))
	out.Webhook = (*acme.ACMEIssuerDNS01ProviderWebhook)(unsafe.Pointer(in.Webhook))
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01 is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(in *v1alpha2.ACMEChallengeSolverDNS01, out *acme.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverDNS01_To_acme_ACMEChallengeSolverDNS01(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverDNS01_To_v1alpha2_ACMEChallengeSolverDNS01(in *acme.ACMEChallengeSolverDNS01, out *v1alpha2.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	out.CNAMEStrategy = v1alpha2.CNAMEStrategy(in.CNAMEStrategy)
	out.Akamai = (*v1alpha2.ACMEIssuerDNS01ProviderAkamai)(unsafe.Pointer(in.Akamai))
	out.CloudDNS = (*v1alpha2.ACMEIssuerDNS01ProviderCloudDNS)(unsafe.Pointer(in.CloudDNS))
	out.Cloudflare = (*v1alpha2.ACMEIssuerDNS01ProviderCloudflare)(unsafe.Pointer(in.Cloudflare))
	out.Route53 = (*v1alpha2.ACMEIssuerDNS01ProviderRoute53)(unsafe.Pointer(in.Route53))
	out.AzureDNS = (*v1alpha2.ACMEIssuerDNS01ProviderAzureDNS)(unsafe.Pointer(in.AzureDNS))
	out.DigitalOcean = (*v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean)(unsafe.Pointer(in.DigitalOcean))
	out.AcmeDNS = (*v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS)(unsafe.Pointer(in.AcmeDNS))
	out.RFC2136 = (*v1alpha2.ACMEIssuerDNS01ProviderRFC2136)(unsafe.Pointer(in.RFC2136))
	out.Webhook = (*v1alpha2.ACMEIssuerDNS01ProviderWebhook)(unsafe.Pointer(in.Webhook))
	return nil
}

// Convert_acme_ACMEChallengeSolverDNS01_To_v1alpha2_ACMEChallengeSolverDNS01 is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverDNS01_To_v1alpha2_ACMEChallengeSolverDNS01(in *acme.ACMEChallengeSolverDNS01, out *v1alpha2.ACMEChallengeSolverDNS01, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverDNS01_To_v1alpha2_ACMEChallengeSolverDNS01(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(in *v1alpha2.ACMEChallengeSolverHTTP01, out *acme.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	out.Ingress = (*acme.ACMEChallengeSolverHTTP01Ingress)(unsafe.Pointer(in.Ingress))
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01 is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(in *v1alpha2.ACMEChallengeSolverHTTP01, out *acme.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverHTTP01_To_acme_ACMEChallengeSolverHTTP01(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01_To_v1alpha2_ACMEChallengeSolverHTTP01(in *acme.ACMEChallengeSolverHTTP01, out *v1alpha2.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	out.Ingress = (*v1alpha2.ACMEChallengeSolverHTTP01Ingress)(unsafe.Pointer(in.Ingress))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01_To_v1alpha2_ACMEChallengeSolverHTTP01 is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01_To_v1alpha2_ACMEChallengeSolverHTTP01(in *acme.ACMEChallengeSolverHTTP01, out *v1alpha2.ACMEChallengeSolverHTTP01, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01_To_v1alpha2_ACMEChallengeSolverHTTP01(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(in *v1alpha2.ACMEChallengeSolverHTTP01Ingress, out *acme.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	out.ServiceType = v1.ServiceType(in.ServiceType)
	out.Class = (*string)(unsafe.Pointer(in.Class))
	out.Name = in.Name
	out.PodTemplate = (*acme.ACMEChallengeSolverHTTP01IngressPodTemplate)(unsafe.Pointer(in.PodTemplate))
	out.IngressTemplate = (*acme.ACMEChallengeSolverHTTP01IngressTemplate)(unsafe.Pointer(in.IngressTemplate))
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(in *v1alpha2.ACMEChallengeSolverHTTP01Ingress, out *acme.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverHTTP01Ingress_To_acme_ACMEChallengeSolverHTTP01Ingress(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1alpha2_ACMEChallengeSolverHTTP01Ingress(in *acme.ACMEChallengeSolverHTTP01Ingress, out *v1alpha2.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	out.ServiceType = v1.ServiceType(in.ServiceType)
	out.Class = (*string)(unsafe.Pointer(in.Class))
	out.Name = in.Name
	out.PodTemplate = (*v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate)(unsafe.Pointer(in.PodTemplate))
	out.IngressTemplate = (*v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate)(unsafe.Pointer(in.IngressTemplate))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1alpha2_ACMEChallengeSolverHTTP01Ingress is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1alpha2_ACMEChallengeSolverHTTP01Ingress(in *acme.ACMEChallengeSolverHTTP01Ingress, out *v1alpha2.ACMEChallengeSolverHTTP01Ingress, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01Ingress_To_v1alpha2_ACMEChallengeSolverHTTP01Ingress(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(in *v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(in *v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, out *v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressObjectMeta, out *v1alpha2.ACMEChallengeSolverHTTP01IngressObjectMeta, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	out.Annotations = *(*map[string]string)(unsafe.Pointer(&in.Annotations))
	out.Labels = *(*map[string]string)(unsafe.Pointer(&in.Labels))
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in *acme.ACMEChallengeSolverHTTP01IngressPodObjectMeta, out *v1alpha2.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(in *v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec, out *acme.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.Affinity = (*v1.Affinity)(unsafe.Pointer(in.Affinity))
	out.Tolerations = *(*[]v1.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.PriorityClassName = in.PriorityClassName
	out.ServiceAccountName = in.ServiceAccountName
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(in *v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec, out *acme.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec(in *acme.ACMEChallengeSolverHTTP01IngressPodSpec, out *v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	out.Affinity = (*v1.Affinity)(unsafe.Pointer(in.Affinity))
	out.Tolerations = *(*[]v1.Toleration)(unsafe.Pointer(&in.Tolerations))
	out.PriorityClassName = in.PriorityClassName
	out.ServiceAccountName = in.ServiceAccountName
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec(in *acme.ACMEChallengeSolverHTTP01IngressPodSpec, out *v1alpha2.ACMEChallengeSolverHTTP01IngressPodSpec, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(in *v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate, out *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	if err := Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta(&in.ACMEChallengeSolverHTTP01IngressPodObjectMeta, &out.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec_To_acme_ACMEChallengeSolverHTTP01IngressPodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(in *v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate, out *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate_To_acme_ACMEChallengeSolverHTTP01IngressPodTemplate(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate(in *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, out *v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	if err := Convert_acme_ACMEChallengeSolverHTTP01IngressPodObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodObjectMeta(&in.ACMEChallengeSolverHTTP01IngressPodObjectMeta, &out.ACMEChallengeSolverHTTP01IngressPodObjectMeta, s); err != nil {
		return err
	}
	if err := Convert_acme_ACMEChallengeSolverHTTP01IngressPodSpec_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate(in *acme.ACMEChallengeSolverHTTP01IngressPodTemplate, out *v1alpha2.ACMEChallengeSolverHTTP01IngressPodTemplate, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressPodTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressPodTemplate(in, out, s)
}

func autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(in *v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate, out *acme.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	if err := Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta_To_acme_ACMEChallengeSolverHTTP01IngressObjectMeta(&in.ACMEChallengeSolverHTTP01IngressObjectMeta, &out.ACMEChallengeSolverHTTP01IngressObjectMeta, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate is an autogenerated conversion function.
func Convert_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(in *v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate, out *acme.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate_To_acme_ACMEChallengeSolverHTTP01IngressTemplate(in, out, s)
}

func autoConvert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate(in *acme.ACMEChallengeSolverHTTP01IngressTemplate, out *v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	if err := Convert_acme_ACMEChallengeSolverHTTP01IngressObjectMeta_To_v1alpha2_ACMEChallengeSolverHTTP01IngressObjectMeta(&in.ACMEChallengeSolverHTTP01IngressObjectMeta, &out.ACMEChallengeSolverHTTP01IngressObjectMeta, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate is an autogenerated conversion function.
func Convert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate(in *acme.ACMEChallengeSolverHTTP01IngressTemplate, out *v1alpha2.ACMEChallengeSolverHTTP01IngressTemplate, s conversion.Scope) error {
	return autoConvert_acme_ACMEChallengeSolverHTTP01IngressTemplate_To_v1alpha2_ACMEChallengeSolverHTTP01IngressTemplate(in, out, s)
}

func autoConvert_v1alpha2_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(in *v1alpha2.ACMEExternalAccountBinding, out *acme.ACMEExternalAccountBinding, s conversion.Scope) error {
	out.KeyID = in.KeyID
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.Key, &out.Key, 0); err != nil {
		return err
	}
	out.KeyAlgorithm = acme.HMACKeyAlgorithm(in.KeyAlgorithm)
	return nil
}

// Convert_v1alpha2_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding is an autogenerated conversion function.
func Convert_v1alpha2_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(in *v1alpha2.ACMEExternalAccountBinding, out *acme.ACMEExternalAccountBinding, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEExternalAccountBinding_To_acme_ACMEExternalAccountBinding(in, out, s)
}

func autoConvert_acme_ACMEExternalAccountBinding_To_v1alpha2_ACMEExternalAccountBinding(in *acme.ACMEExternalAccountBinding, out *v1alpha2.ACMEExternalAccountBinding, s conversion.Scope) error {
	out.KeyID = in.KeyID
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.Key, &out.Key, 0); err != nil {
		return err
	}
	out.KeyAlgorithm = v1alpha2.HMACKeyAlgorithm(in.KeyAlgorithm)
	return nil
}

// Convert_acme_ACMEExternalAccountBinding_To_v1alpha2_ACMEExternalAccountBinding is an autogenerated conversion function.
func Convert_acme_ACMEExternalAccountBinding_To_v1alpha2_ACMEExternalAccountBinding(in *acme.ACMEExternalAccountBinding, out *v1alpha2.ACMEExternalAccountBinding, s conversion.Scope) error {
	return autoConvert_acme_ACMEExternalAccountBinding_To_v1alpha2_ACMEExternalAccountBinding(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuer_To_acme_ACMEIssuer(in *v1alpha2.ACMEIssuer, out *acme.ACMEIssuer, s conversion.Scope) error {
	out.Email = in.Email
	out.Server = in.Server
	out.PreferredChain = in.PreferredChain
	out.SkipTLSVerify = in.SkipTLSVerify
	out.ExternalAccountBinding = (*acme.ACMEExternalAccountBinding)(unsafe.Pointer(in.ExternalAccountBinding))
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.PrivateKey, &out.PrivateKey, 0); err != nil {
		return err
	}
	out.Solvers = *(*[]acme.ACMEChallengeSolver)(unsafe.Pointer(&in.Solvers))
	out.DisableAccountKeyGeneration = in.DisableAccountKeyGeneration
	out.EnableDurationFeature = in.EnableDurationFeature
	return nil
}

// Convert_v1alpha2_ACMEIssuer_To_acme_ACMEIssuer is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuer_To_acme_ACMEIssuer(in *v1alpha2.ACMEIssuer, out *acme.ACMEIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuer_To_acme_ACMEIssuer(in, out, s)
}

func autoConvert_acme_ACMEIssuer_To_v1alpha2_ACMEIssuer(in *acme.ACMEIssuer, out *v1alpha2.ACMEIssuer, s conversion.Scope) error {
	out.Email = in.Email
	out.Server = in.Server
	out.PreferredChain = in.PreferredChain
	out.SkipTLSVerify = in.SkipTLSVerify
	out.ExternalAccountBinding = (*v1alpha2.ACMEExternalAccountBinding)(unsafe.Pointer(in.ExternalAccountBinding))
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.PrivateKey, &out.PrivateKey, 0); err != nil {
		return err
	}
	out.Solvers = *(*[]v1alpha2.ACMEChallengeSolver)(unsafe.Pointer(&in.Solvers))
	out.DisableAccountKeyGeneration = in.DisableAccountKeyGeneration
	out.EnableDurationFeature = in.EnableDurationFeature
	return nil
}

// Convert_acme_ACMEIssuer_To_v1alpha2_ACMEIssuer is an autogenerated conversion function.
func Convert_acme_ACMEIssuer_To_v1alpha2_ACMEIssuer(in *acme.ACMEIssuer, out *v1alpha2.ACMEIssuer, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuer_To_v1alpha2_ACMEIssuer(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(in *v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS, out *acme.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	out.Host = in.Host
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.AccountSecret, &out.AccountSecret, 0); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(in *v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS, out *acme.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS_To_acme_ACMEIssuerDNS01ProviderAcmeDNS(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS(in *acme.ACMEIssuerDNS01ProviderAcmeDNS, out *v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	out.Host = in.Host
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.AccountSecret, &out.AccountSecret, 0); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS(in *acme.ACMEIssuerDNS01ProviderAcmeDNS, out *v1alpha2.ACMEIssuerDNS01ProviderAcmeDNS, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderAcmeDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAcmeDNS(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(in *v1alpha2.ACMEIssuerDNS01ProviderAkamai, out *acme.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	out.ServiceConsumerDomain = in.ServiceConsumerDomain
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.ClientToken, &out.ClientToken, 0); err != nil {
		return err
	}
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.ClientSecret, &out.ClientSecret, 0); err != nil {
		return err
	}
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.AccessToken, &out.AccessToken, 0); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(in *v1alpha2.ACMEIssuerDNS01ProviderAkamai, out *acme.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderAkamai_To_acme_ACMEIssuerDNS01ProviderAkamai(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1alpha2_ACMEIssuerDNS01ProviderAkamai(in *acme.ACMEIssuerDNS01ProviderAkamai, out *v1alpha2.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	out.ServiceConsumerDomain = in.ServiceConsumerDomain
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.ClientToken, &out.ClientToken, 0); err != nil {
		return err
	}
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.ClientSecret, &out.ClientSecret, 0); err != nil {
		return err
	}
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.AccessToken, &out.AccessToken, 0); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1alpha2_ACMEIssuerDNS01ProviderAkamai is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1alpha2_ACMEIssuerDNS01ProviderAkamai(in *acme.ACMEIssuerDNS01ProviderAkamai, out *v1alpha2.ACMEIssuerDNS01ProviderAkamai, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderAkamai_To_v1alpha2_ACMEIssuerDNS01ProviderAkamai(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(in *v1alpha2.ACMEIssuerDNS01ProviderAzureDNS, out *acme.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	out.ClientID = in.ClientID
	out.ClientSecret = (*meta.SecretKeySelector)(unsafe.Pointer(in.ClientSecret))
	out.SubscriptionID = in.SubscriptionID
	out.TenantID = in.TenantID
	out.ResourceGroupName = in.ResourceGroupName
	out.HostedZoneName = in.HostedZoneName
	out.Environment = acme.AzureDNSEnvironment(in.Environment)
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(in *v1alpha2.ACMEIssuerDNS01ProviderAzureDNS, out *acme.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS_To_acme_ACMEIssuerDNS01ProviderAzureDNS(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS(in *acme.ACMEIssuerDNS01ProviderAzureDNS, out *v1alpha2.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	out.ClientID = in.ClientID
	out.ClientSecret = (*metav1.SecretKeySelector)(unsafe.Pointer(in.ClientSecret))
	out.SubscriptionID = in.SubscriptionID
	out.TenantID = in.TenantID
	out.ResourceGroupName = in.ResourceGroupName
	out.HostedZoneName = in.HostedZoneName
	out.Environment = v1alpha2.AzureDNSEnvironment(in.Environment)
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS(in *acme.ACMEIssuerDNS01ProviderAzureDNS, out *v1alpha2.ACMEIssuerDNS01ProviderAzureDNS, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderAzureDNS_To_v1alpha2_ACMEIssuerDNS01ProviderAzureDNS(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(in *v1alpha2.ACMEIssuerDNS01ProviderCloudDNS, out *acme.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	out.ServiceAccount = (*meta.SecretKeySelector)(unsafe.Pointer(in.ServiceAccount))
	out.Project = in.Project
	out.HostedZoneName = in.HostedZoneName
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(in *v1alpha2.ACMEIssuerDNS01ProviderCloudDNS, out *acme.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS_To_acme_ACMEIssuerDNS01ProviderCloudDNS(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS(in *acme.ACMEIssuerDNS01ProviderCloudDNS, out *v1alpha2.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	out.ServiceAccount = (*metav1.SecretKeySelector)(unsafe.Pointer(in.ServiceAccount))
	out.Project = in.Project
	out.HostedZoneName = in.HostedZoneName
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS(in *acme.ACMEIssuerDNS01ProviderCloudDNS, out *v1alpha2.ACMEIssuerDNS01ProviderCloudDNS, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderCloudDNS_To_v1alpha2_ACMEIssuerDNS01ProviderCloudDNS(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(in *v1alpha2.ACMEIssuerDNS01ProviderCloudflare, out *acme.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	out.Email = in.Email
	out.APIKey = (*meta.SecretKeySelector)(unsafe.Pointer(in.APIKey))
	out.APIToken = (*meta.SecretKeySelector)(unsafe.Pointer(in.APIToken))
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(in *v1alpha2.ACMEIssuerDNS01ProviderCloudflare, out *acme.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderCloudflare_To_acme_ACMEIssuerDNS01ProviderCloudflare(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1alpha2_ACMEIssuerDNS01ProviderCloudflare(in *acme.ACMEIssuerDNS01ProviderCloudflare, out *v1alpha2.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	out.Email = in.Email
	out.APIKey = (*metav1.SecretKeySelector)(unsafe.Pointer(in.APIKey))
	out.APIToken = (*metav1.SecretKeySelector)(unsafe.Pointer(in.APIToken))
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1alpha2_ACMEIssuerDNS01ProviderCloudflare is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1alpha2_ACMEIssuerDNS01ProviderCloudflare(in *acme.ACMEIssuerDNS01ProviderCloudflare, out *v1alpha2.ACMEIssuerDNS01ProviderCloudflare, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderCloudflare_To_v1alpha2_ACMEIssuerDNS01ProviderCloudflare(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(in *v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean, out *acme.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.Token, &out.Token, 0); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(in *v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean, out *acme.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean_To_acme_ACMEIssuerDNS01ProviderDigitalOcean(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean(in *acme.ACMEIssuerDNS01ProviderDigitalOcean, out *v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.Token, &out.Token, 0); err != nil {
		return err
	}
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean(in *acme.ACMEIssuerDNS01ProviderDigitalOcean, out *v1alpha2.ACMEIssuerDNS01ProviderDigitalOcean, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderDigitalOcean_To_v1alpha2_ACMEIssuerDNS01ProviderDigitalOcean(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(in *v1alpha2.ACMEIssuerDNS01ProviderRFC2136, out *acme.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	out.Nameserver = in.Nameserver
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.TSIGSecret, &out.TSIGSecret, 0); err != nil {
		return err
	}
	out.TSIGKeyName = in.TSIGKeyName
	out.TSIGAlgorithm = in.TSIGAlgorithm
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136 is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(in *v1alpha2.ACMEIssuerDNS01ProviderRFC2136, out *acme.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderRFC2136_To_acme_ACMEIssuerDNS01ProviderRFC2136(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1alpha2_ACMEIssuerDNS01ProviderRFC2136(in *acme.ACMEIssuerDNS01ProviderRFC2136, out *v1alpha2.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	out.Nameserver = in.Nameserver
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.TSIGSecret, &out.TSIGSecret, 0); err != nil {
		return err
	}
	out.TSIGKeyName = in.TSIGKeyName
	out.TSIGAlgorithm = in.TSIGAlgorithm
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1alpha2_ACMEIssuerDNS01ProviderRFC2136 is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1alpha2_ACMEIssuerDNS01ProviderRFC2136(in *acme.ACMEIssuerDNS01ProviderRFC2136, out *v1alpha2.ACMEIssuerDNS01ProviderRFC2136, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderRFC2136_To_v1alpha2_ACMEIssuerDNS01ProviderRFC2136(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(in *v1alpha2.ACMEIssuerDNS01ProviderRoute53, out *acme.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	out.AccessKeyID = in.AccessKeyID
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.SecretAccessKey, &out.SecretAccessKey, 0); err != nil {
		return err
	}
	out.Role = in.Role
	out.HostedZoneID = in.HostedZoneID
	out.Region = in.Region
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53 is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(in *v1alpha2.ACMEIssuerDNS01ProviderRoute53, out *acme.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderRoute53_To_acme_ACMEIssuerDNS01ProviderRoute53(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1alpha2_ACMEIssuerDNS01ProviderRoute53(in *acme.ACMEIssuerDNS01ProviderRoute53, out *v1alpha2.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	out.AccessKeyID = in.AccessKeyID
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.SecretAccessKey, &out.SecretAccessKey, 0); err != nil {
		return err
	}
	out.Role = in.Role
	out.HostedZoneID = in.HostedZoneID
	out.Region = in.Region
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1alpha2_ACMEIssuerDNS01ProviderRoute53 is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1alpha2_ACMEIssuerDNS01ProviderRoute53(in *acme.ACMEIssuerDNS01ProviderRoute53, out *v1alpha2.ACMEIssuerDNS01ProviderRoute53, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderRoute53_To_v1alpha2_ACMEIssuerDNS01ProviderRoute53(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(in *v1alpha2.ACMEIssuerDNS01ProviderWebhook, out *acme.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	out.GroupName = in.GroupName
	out.SolverName = in.SolverName
	out.Config = (*v1beta1.JSON)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_v1alpha2_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(in *v1alpha2.ACMEIssuerDNS01ProviderWebhook, out *acme.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerDNS01ProviderWebhook_To_acme_ACMEIssuerDNS01ProviderWebhook(in, out, s)
}

func autoConvert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1alpha2_ACMEIssuerDNS01ProviderWebhook(in *acme.ACMEIssuerDNS01ProviderWebhook, out *v1alpha2.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	out.GroupName = in.GroupName
	out.SolverName = in.SolverName
	out.Config = (*v1beta1.JSON)(unsafe.Pointer(in.Config))
	return nil
}

// Convert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1alpha2_ACMEIssuerDNS01ProviderWebhook is an autogenerated conversion function.
func Convert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1alpha2_ACMEIssuerDNS01ProviderWebhook(in *acme.ACMEIssuerDNS01ProviderWebhook, out *v1alpha2.ACMEIssuerDNS01ProviderWebhook, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerDNS01ProviderWebhook_To_v1alpha2_ACMEIssuerDNS01ProviderWebhook(in, out, s)
}

func autoConvert_v1alpha2_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(in *v1alpha2.ACMEIssuerStatus, out *acme.ACMEIssuerStatus, s conversion.Scope) error {
	out.URI = in.URI
	out.LastRegisteredEmail = in.LastRegisteredEmail
	return nil
}

// Convert_v1alpha2_ACMEIssuerStatus_To_acme_ACMEIssuerStatus is an autogenerated conversion function.
func Convert_v1alpha2_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(in *v1alpha2.ACMEIssuerStatus, out *acme.ACMEIssuerStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_ACMEIssuerStatus_To_acme_ACMEIssuerStatus(in, out, s)
}

func autoConvert_acme_ACMEIssuerStatus_To_v1alpha2_ACMEIssuerStatus(in *acme.ACMEIssuerStatus, out *v1alpha2.ACMEIssuerStatus, s conversion.Scope) error {
	out.URI = in.URI
	out.LastRegisteredEmail = in.LastRegisteredEmail
	return nil
}

// Convert_acme_ACMEIssuerStatus_To_v1alpha2_ACMEIssuerStatus is an autogenerated conversion function.
func Convert_acme_ACMEIssuerStatus_To_v1alpha2_ACMEIssuerStatus(in *acme.ACMEIssuerStatus, out *v1alpha2.ACMEIssuerStatus, s conversion.Scope) error {
	return autoConvert_acme_ACMEIssuerStatus_To_v1alpha2_ACMEIssuerStatus(in, out, s)
}

func autoConvert_v1alpha2_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(in *v1alpha2.CertificateDNSNameSelector, out *acme.CertificateDNSNameSelector, s conversion.Scope) error {
	out.MatchLabels = *(*map[string]string)(unsafe.Pointer(&in.MatchLabels))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.DNSZones = *(*[]string)(unsafe.Pointer(&in.DNSZones))
	return nil
}

// Convert_v1alpha2_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector is an autogenerated conversion function.
func Convert_v1alpha2_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(in *v1alpha2.CertificateDNSNameSelector, out *acme.CertificateDNSNameSelector, s conversion.Scope) error {
	return autoConvert_v1alpha2_CertificateDNSNameSelector_To_acme_CertificateDNSNameSelector(in, out, s)
}

func autoConvert_acme_CertificateDNSNameSelector_To_v1alpha2_CertificateDNSNameSelector(in *acme.CertificateDNSNameSelector, out *v1alpha2.CertificateDNSNameSelector, s conversion.Scope) error {
	out.MatchLabels = *(*map[string]string)(unsafe.Pointer(&in.MatchLabels))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.DNSZones = *(*[]string)(unsafe.Pointer(&in.DNSZones))
	return nil
}

// Convert_acme_CertificateDNSNameSelector_To_v1alpha2_CertificateDNSNameSelector is an autogenerated conversion function.
func Convert_acme_CertificateDNSNameSelector_To_v1alpha2_CertificateDNSNameSelector(in *acme.CertificateDNSNameSelector, out *v1alpha2.CertificateDNSNameSelector, s conversion.Scope) error {
	return autoConvert_acme_CertificateDNSNameSelector_To_v1alpha2_CertificateDNSNameSelector(in, out, s)
}

func autoConvert_v1alpha2_Challenge_To_acme_Challenge(in *v1alpha2.Challenge, out *acme.Challenge, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_ChallengeSpec_To_acme_ChallengeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_ChallengeStatus_To_acme_ChallengeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_Challenge_To_acme_Challenge is an autogenerated conversion function.
func Convert_v1alpha2_Challenge_To_acme_Challenge(in *v1alpha2.Challenge, out *acme.Challenge, s conversion.Scope) error {
	return autoConvert_v1alpha2_Challenge_To_acme_Challenge(in, out, s)
}

func autoConvert_acme_Challenge_To_v1alpha2_Challenge(in *acme.Challenge, out *v1alpha2.Challenge, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_acme_ChallengeSpec_To_v1alpha2_ChallengeSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_acme_ChallengeStatus_To_v1alpha2_ChallengeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_Challenge_To_v1alpha2_Challenge is an autogenerated conversion function.
func Convert_acme_Challenge_To_v1alpha2_Challenge(in *acme.Challenge, out *v1alpha2.Challenge, s conversion.Scope) error {
	return autoConvert_acme_Challenge_To_v1alpha2_Challenge(in, out, s)
}

func autoConvert_v1alpha2_ChallengeList_To_acme_ChallengeList(in *v1alpha2.ChallengeList, out *acme.ChallengeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]acme.Challenge, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_Challenge_To_acme_Challenge(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_ChallengeList_To_acme_ChallengeList is an autogenerated conversion function.
func Convert_v1alpha2_ChallengeList_To_acme_ChallengeList(in *v1alpha2.ChallengeList, out *acme.ChallengeList, s conversion.Scope) error {
	return autoConvert_v1alpha2_ChallengeList_To_acme_ChallengeList(in, out, s)
}

func autoConvert_acme_ChallengeList_To_v1alpha2_ChallengeList(in *acme.ChallengeList, out *v1alpha2.ChallengeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha2.Challenge, len(*in))
		for i := range *in {
			if err := Convert_acme_Challenge_To_v1alpha2_Challenge(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_acme_ChallengeList_To_v1alpha2_ChallengeList is an autogenerated conversion function.
func Convert_acme_ChallengeList_To_v1alpha2_ChallengeList(in *acme.ChallengeList, out *v1alpha2.ChallengeList, s conversion.Scope) error {
	return autoConvert_acme_ChallengeList_To_v1alpha2_ChallengeList(in, out, s)
}

func autoConvert_v1alpha2_ChallengeSpec_To_acme_ChallengeSpec(in *v1alpha2.ChallengeSpec, out *acme.ChallengeSpec, s conversion.Scope) error {
	out.URL = in.URL
	// WARNING: in.AuthzURL requires manual conversion: does not exist in peer-type
	out.DNSName = in.DNSName
	out.Wildcard = in.Wildcard
	out.Type = acme.ACMEChallengeType(in.Type)
	out.Token = in.Token
	out.Key = in.Key
	if err := Convert_v1alpha2_ACMEChallengeSolver_To_acme_ACMEChallengeSolver(&in.Solver, &out.Solver, s); err != nil {
		return err
	}
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	return nil
}

func autoConvert_acme_ChallengeSpec_To_v1alpha2_ChallengeSpec(in *acme.ChallengeSpec, out *v1alpha2.ChallengeSpec, s conversion.Scope) error {
	out.URL = in.URL
	// WARNING: in.AuthorizationURL requires manual conversion: does not exist in peer-type
	out.DNSName = in.DNSName
	out.Wildcard = in.Wildcard
	out.Type = v1alpha2.ACMEChallengeType(in.Type)
	out.Token = in.Token
	out.Key = in.Key
	if err := Convert_acme_ACMEChallengeSolver_To_v1alpha2_ACMEChallengeSolver(&in.Solver, &out.Solver, s); err != nil {
		return err
	}
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_ChallengeStatus_To_acme_ChallengeStatus(in *v1alpha2.ChallengeStatus, out *acme.ChallengeStatus, s conversion.Scope) error {
	out.Processing = in.Processing
	out.Presented = in.Presented
	out.Reason = in.Reason
	out.State = acme.State(in.State)
	return nil
}

// Convert_v1alpha2_ChallengeStatus_To_acme_ChallengeStatus is an autogenerated conversion function.
func Convert_v1alpha2_ChallengeStatus_To_acme_ChallengeStatus(in *v1alpha2.ChallengeStatus, out *acme.ChallengeStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_ChallengeStatus_To_acme_ChallengeStatus(in, out, s)
}

func autoConvert_acme_ChallengeStatus_To_v1alpha2_ChallengeStatus(in *acme.ChallengeStatus, out *v1alpha2.ChallengeStatus, s conversion.Scope) error {
	out.Processing = in.Processing
	out.Presented = in.Presented
	out.Reason = in.Reason
	out.State = v1alpha2.State(in.State)
	return nil
}

// Convert_acme_ChallengeStatus_To_v1alpha2_ChallengeStatus is an autogenerated conversion function.
func Convert_acme_ChallengeStatus_To_v1alpha2_ChallengeStatus(in *acme.ChallengeStatus, out *v1alpha2.ChallengeStatus, s conversion.Scope) error {
	return autoConvert_acme_ChallengeStatus_To_v1alpha2_ChallengeStatus(in, out, s)
}

func autoConvert_v1alpha2_Order_To_acme_Order(in *v1alpha2.Order, out *acme.Order, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha2_OrderSpec_To_acme_OrderSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha2_OrderStatus_To_acme_OrderStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha2_Order_To_acme_Order is an autogenerated conversion function.
func Convert_v1alpha2_Order_To_acme_Order(in *v1alpha2.Order, out *acme.Order, s conversion.Scope) error {
	return autoConvert_v1alpha2_Order_To_acme_Order(in, out, s)
}

func autoConvert_acme_Order_To_v1alpha2_Order(in *acme.Order, out *v1alpha2.Order, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_acme_OrderSpec_To_v1alpha2_OrderSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_acme_OrderStatus_To_v1alpha2_OrderStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_acme_Order_To_v1alpha2_Order is an autogenerated conversion function.
func Convert_acme_Order_To_v1alpha2_Order(in *acme.Order, out *v1alpha2.Order, s conversion.Scope) error {
	return autoConvert_acme_Order_To_v1alpha2_Order(in, out, s)
}

func autoConvert_v1alpha2_OrderList_To_acme_OrderList(in *v1alpha2.OrderList, out *acme.OrderList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]acme.Order, len(*in))
		for i := range *in {
			if err := Convert_v1alpha2_Order_To_acme_Order(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha2_OrderList_To_acme_OrderList is an autogenerated conversion function.
func Convert_v1alpha2_OrderList_To_acme_OrderList(in *v1alpha2.OrderList, out *acme.OrderList, s conversion.Scope) error {
	return autoConvert_v1alpha2_OrderList_To_acme_OrderList(in, out, s)
}

func autoConvert_acme_OrderList_To_v1alpha2_OrderList(in *acme.OrderList, out *v1alpha2.OrderList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha2.Order, len(*in))
		for i := range *in {
			if err := Convert_acme_Order_To_v1alpha2_Order(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_acme_OrderList_To_v1alpha2_OrderList is an autogenerated conversion function.
func Convert_acme_OrderList_To_v1alpha2_OrderList(in *acme.OrderList, out *v1alpha2.OrderList, s conversion.Scope) error {
	return autoConvert_acme_OrderList_To_v1alpha2_OrderList(in, out, s)
}

func autoConvert_v1alpha2_OrderSpec_To_acme_OrderSpec(in *v1alpha2.OrderSpec, out *acme.OrderSpec, s conversion.Scope) error {
	// WARNING: in.CSR requires manual conversion: does not exist in peer-type
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	out.CommonName = in.CommonName
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.Duration = (*apismetav1.Duration)(unsafe.Pointer(in.Duration))
	return nil
}

func autoConvert_acme_OrderSpec_To_v1alpha2_OrderSpec(in *acme.OrderSpec, out *v1alpha2.OrderSpec, s conversion.Scope) error {
	// WARNING: in.Request requires manual conversion: does not exist in peer-type
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	out.CommonName = in.CommonName
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.Duration = (*apismetav1.Duration)(unsafe.Pointer(in.Duration))
	return nil
}

func autoConvert_v1alpha2_OrderStatus_To_acme_OrderStatus(in *v1alpha2.OrderStatus, out *acme.OrderStatus, s conversion.Scope) error {
	out.URL = in.URL
	out.FinalizeURL = in.FinalizeURL
	out.Authorizations = *(*[]acme.ACMEAuthorization)(unsafe.Pointer(&in.Authorizations))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.State = acme.State(in.State)
	out.Reason = in.Reason
	out.FailureTime = (*apismetav1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_v1alpha2_OrderStatus_To_acme_OrderStatus is an autogenerated conversion function.
func Convert_v1alpha2_OrderStatus_To_acme_OrderStatus(in *v1alpha2.OrderStatus, out *acme.OrderStatus, s conversion.Scope) error {
	return autoConvert_v1alpha2_OrderStatus_To_acme_OrderStatus(in, out, s)
}

func autoConvert_acme_OrderStatus_To_v1alpha2_OrderStatus(in *acme.OrderStatus, out *v1alpha2.OrderStatus, s conversion.Scope) error {
	out.URL = in.URL
	out.FinalizeURL = in.FinalizeURL
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.State = v1alpha2.State(in.State)
	out.Reason = in.Reason
	out.Authorizations = *(*[]v1alpha2.ACMEAuthorization)(unsafe.Pointer(&in.Authorizations))
	out.FailureTime = (*apismetav1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_acme_OrderStatus_To_v1alpha2_OrderStatus is an autogenerated conversion function.
func Convert_acme_OrderStatus_To_v1alpha2_OrderStatus(in *acme.OrderStatus, out *v1alpha2.OrderStatus, s conversion.Scope) error {
	return autoConvert_acme_OrderStatus_To_v1alpha2_OrderStatus(in, out, s)
}
