// +build !ignore_autogenerated

/*
Copyright 2020 The Jetstack cert-manager contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha3

import (
	unsafe "unsafe"

	acmev1alpha3 "github.com/jetstack/cert-manager/pkg/apis/acme/v1alpha3"
	v1alpha3 "github.com/jetstack/cert-manager/pkg/apis/certmanager/v1alpha3"
	metav1 "github.com/jetstack/cert-manager/pkg/apis/meta/v1"
	acme "github.com/jetstack/cert-manager/pkg/internal/apis/acme"
	certmanager "github.com/jetstack/cert-manager/pkg/internal/apis/certmanager"
	meta "github.com/jetstack/cert-manager/pkg/internal/apis/meta"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CAIssuer)(nil), (*certmanager.CAIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(a.(*v1alpha3.CAIssuer), b.(*certmanager.CAIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CAIssuer)(nil), (*v1alpha3.CAIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(a.(*certmanager.CAIssuer), b.(*v1alpha3.CAIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.Certificate)(nil), (*certmanager.Certificate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Certificate_To_certmanager_Certificate(a.(*v1alpha3.Certificate), b.(*certmanager.Certificate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.Certificate)(nil), (*v1alpha3.Certificate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_Certificate_To_v1alpha3_Certificate(a.(*certmanager.Certificate), b.(*v1alpha3.Certificate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateCondition)(nil), (*certmanager.CertificateCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(a.(*v1alpha3.CertificateCondition), b.(*certmanager.CertificateCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateCondition)(nil), (*v1alpha3.CertificateCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(a.(*certmanager.CertificateCondition), b.(*v1alpha3.CertificateCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateKeystores)(nil), (*certmanager.CertificateKeystores)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(a.(*v1alpha3.CertificateKeystores), b.(*certmanager.CertificateKeystores), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateKeystores)(nil), (*v1alpha3.CertificateKeystores)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(a.(*certmanager.CertificateKeystores), b.(*v1alpha3.CertificateKeystores), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateList)(nil), (*certmanager.CertificateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateList_To_certmanager_CertificateList(a.(*v1alpha3.CertificateList), b.(*certmanager.CertificateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateList)(nil), (*v1alpha3.CertificateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateList_To_v1alpha3_CertificateList(a.(*certmanager.CertificateList), b.(*v1alpha3.CertificateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificatePrivateKey)(nil), (*certmanager.CertificatePrivateKey)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(a.(*v1alpha3.CertificatePrivateKey), b.(*certmanager.CertificatePrivateKey), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateRequest)(nil), (*certmanager.CertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(a.(*v1alpha3.CertificateRequest), b.(*certmanager.CertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequest)(nil), (*v1alpha3.CertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(a.(*certmanager.CertificateRequest), b.(*v1alpha3.CertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateRequestCondition)(nil), (*certmanager.CertificateRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(a.(*v1alpha3.CertificateRequestCondition), b.(*certmanager.CertificateRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestCondition)(nil), (*v1alpha3.CertificateRequestCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(a.(*certmanager.CertificateRequestCondition), b.(*v1alpha3.CertificateRequestCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateRequestList)(nil), (*certmanager.CertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(a.(*v1alpha3.CertificateRequestList), b.(*certmanager.CertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestList)(nil), (*v1alpha3.CertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(a.(*certmanager.CertificateRequestList), b.(*v1alpha3.CertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateRequestStatus)(nil), (*certmanager.CertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(a.(*v1alpha3.CertificateRequestStatus), b.(*certmanager.CertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateRequestStatus)(nil), (*v1alpha3.CertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(a.(*certmanager.CertificateRequestStatus), b.(*v1alpha3.CertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.CertificateStatus)(nil), (*certmanager.CertificateStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(a.(*v1alpha3.CertificateStatus), b.(*certmanager.CertificateStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.CertificateStatus)(nil), (*v1alpha3.CertificateStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(a.(*certmanager.CertificateStatus), b.(*v1alpha3.CertificateStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.ClusterIssuer)(nil), (*certmanager.ClusterIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(a.(*v1alpha3.ClusterIssuer), b.(*certmanager.ClusterIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ClusterIssuer)(nil), (*v1alpha3.ClusterIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(a.(*certmanager.ClusterIssuer), b.(*v1alpha3.ClusterIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.ClusterIssuerList)(nil), (*certmanager.ClusterIssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(a.(*v1alpha3.ClusterIssuerList), b.(*certmanager.ClusterIssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.ClusterIssuerList)(nil), (*v1alpha3.ClusterIssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(a.(*certmanager.ClusterIssuerList), b.(*v1alpha3.ClusterIssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.Issuer)(nil), (*certmanager.Issuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Issuer_To_certmanager_Issuer(a.(*v1alpha3.Issuer), b.(*certmanager.Issuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.Issuer)(nil), (*v1alpha3.Issuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_Issuer_To_v1alpha3_Issuer(a.(*certmanager.Issuer), b.(*v1alpha3.Issuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.IssuerCondition)(nil), (*certmanager.IssuerCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(a.(*v1alpha3.IssuerCondition), b.(*certmanager.IssuerCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerCondition)(nil), (*v1alpha3.IssuerCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(a.(*certmanager.IssuerCondition), b.(*v1alpha3.IssuerCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.IssuerConfig)(nil), (*certmanager.IssuerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(a.(*v1alpha3.IssuerConfig), b.(*certmanager.IssuerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerConfig)(nil), (*v1alpha3.IssuerConfig)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(a.(*certmanager.IssuerConfig), b.(*v1alpha3.IssuerConfig), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.IssuerList)(nil), (*certmanager.IssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerList_To_certmanager_IssuerList(a.(*v1alpha3.IssuerList), b.(*certmanager.IssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerList)(nil), (*v1alpha3.IssuerList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerList_To_v1alpha3_IssuerList(a.(*certmanager.IssuerList), b.(*v1alpha3.IssuerList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.IssuerSpec)(nil), (*certmanager.IssuerSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(a.(*v1alpha3.IssuerSpec), b.(*certmanager.IssuerSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerSpec)(nil), (*v1alpha3.IssuerSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(a.(*certmanager.IssuerSpec), b.(*v1alpha3.IssuerSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.IssuerStatus)(nil), (*certmanager.IssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(a.(*v1alpha3.IssuerStatus), b.(*certmanager.IssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.IssuerStatus)(nil), (*v1alpha3.IssuerStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(a.(*certmanager.IssuerStatus), b.(*v1alpha3.IssuerStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.JKSKeystore)(nil), (*certmanager.JKSKeystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(a.(*v1alpha3.JKSKeystore), b.(*certmanager.JKSKeystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.JKSKeystore)(nil), (*v1alpha3.JKSKeystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(a.(*certmanager.JKSKeystore), b.(*v1alpha3.JKSKeystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.PKCS12Keystore)(nil), (*certmanager.PKCS12Keystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(a.(*v1alpha3.PKCS12Keystore), b.(*certmanager.PKCS12Keystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.PKCS12Keystore)(nil), (*v1alpha3.PKCS12Keystore)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(a.(*certmanager.PKCS12Keystore), b.(*v1alpha3.PKCS12Keystore), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.SelfSignedIssuer)(nil), (*certmanager.SelfSignedIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(a.(*v1alpha3.SelfSignedIssuer), b.(*certmanager.SelfSignedIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.SelfSignedIssuer)(nil), (*v1alpha3.SelfSignedIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(a.(*certmanager.SelfSignedIssuer), b.(*v1alpha3.SelfSignedIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VaultAppRole)(nil), (*certmanager.VaultAppRole)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(a.(*v1alpha3.VaultAppRole), b.(*certmanager.VaultAppRole), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultAppRole)(nil), (*v1alpha3.VaultAppRole)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(a.(*certmanager.VaultAppRole), b.(*v1alpha3.VaultAppRole), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VaultAuth)(nil), (*certmanager.VaultAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(a.(*v1alpha3.VaultAuth), b.(*certmanager.VaultAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultAuth)(nil), (*v1alpha3.VaultAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(a.(*certmanager.VaultAuth), b.(*v1alpha3.VaultAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VaultIssuer)(nil), (*certmanager.VaultIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(a.(*v1alpha3.VaultIssuer), b.(*certmanager.VaultIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultIssuer)(nil), (*v1alpha3.VaultIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(a.(*certmanager.VaultIssuer), b.(*v1alpha3.VaultIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VaultKubernetesAuth)(nil), (*certmanager.VaultKubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(a.(*v1alpha3.VaultKubernetesAuth), b.(*certmanager.VaultKubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VaultKubernetesAuth)(nil), (*v1alpha3.VaultKubernetesAuth)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth(a.(*certmanager.VaultKubernetesAuth), b.(*v1alpha3.VaultKubernetesAuth), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VenafiCloud)(nil), (*certmanager.VenafiCloud)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(a.(*v1alpha3.VenafiCloud), b.(*certmanager.VenafiCloud), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiCloud)(nil), (*v1alpha3.VenafiCloud)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(a.(*certmanager.VenafiCloud), b.(*v1alpha3.VenafiCloud), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VenafiIssuer)(nil), (*certmanager.VenafiIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(a.(*v1alpha3.VenafiIssuer), b.(*certmanager.VenafiIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiIssuer)(nil), (*v1alpha3.VenafiIssuer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(a.(*certmanager.VenafiIssuer), b.(*v1alpha3.VenafiIssuer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.VenafiTPP)(nil), (*certmanager.VenafiTPP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(a.(*v1alpha3.VenafiTPP), b.(*certmanager.VenafiTPP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certmanager.VenafiTPP)(nil), (*v1alpha3.VenafiTPP)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(a.(*certmanager.VenafiTPP), b.(*v1alpha3.VenafiTPP), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha3.X509Subject)(nil), (*certmanager.X509Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_X509Subject_To_certmanager_X509Subject(a.(*v1alpha3.X509Subject), b.(*certmanager.X509Subject), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.CertificatePrivateKey)(nil), (*v1alpha3.CertificatePrivateKey)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificatePrivateKey_To_v1alpha3_CertificatePrivateKey(a.(*certmanager.CertificatePrivateKey), b.(*v1alpha3.CertificatePrivateKey), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.CertificateRequestSpec)(nil), (*v1alpha3.CertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateRequestSpec_To_v1alpha3_CertificateRequestSpec(a.(*certmanager.CertificateRequestSpec), b.(*v1alpha3.CertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.CertificateSpec)(nil), (*v1alpha3.CertificateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_CertificateSpec_To_v1alpha3_CertificateSpec(a.(*certmanager.CertificateSpec), b.(*v1alpha3.CertificateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*certmanager.X509Subject)(nil), (*v1alpha3.X509Subject)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certmanager_X509Subject_To_v1alpha3_X509Subject(a.(*certmanager.X509Subject), b.(*v1alpha3.X509Subject), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha3.CertificateRequestSpec)(nil), (*certmanager.CertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(a.(*v1alpha3.CertificateRequestSpec), b.(*certmanager.CertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha3.CertificateSpec)(nil), (*certmanager.CertificateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_CertificateSpec_To_certmanager_CertificateSpec(a.(*v1alpha3.CertificateSpec), b.(*certmanager.CertificateSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(in *v1alpha3.CAIssuer, out *certmanager.CAIssuer, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_v1alpha3_CAIssuer_To_certmanager_CAIssuer is an autogenerated conversion function.
func Convert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(in *v1alpha3.CAIssuer, out *certmanager.CAIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_CAIssuer_To_certmanager_CAIssuer(in, out, s)
}

func autoConvert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(in *certmanager.CAIssuer, out *v1alpha3.CAIssuer, s conversion.Scope) error {
	out.SecretName = in.SecretName
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_certmanager_CAIssuer_To_v1alpha3_CAIssuer is an autogenerated conversion function.
func Convert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(in *certmanager.CAIssuer, out *v1alpha3.CAIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_CAIssuer_To_v1alpha3_CAIssuer(in, out, s)
}

func autoConvert_v1alpha3_Certificate_To_certmanager_Certificate(in *v1alpha3.Certificate, out *certmanager.Certificate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_CertificateSpec_To_certmanager_CertificateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_Certificate_To_certmanager_Certificate is an autogenerated conversion function.
func Convert_v1alpha3_Certificate_To_certmanager_Certificate(in *v1alpha3.Certificate, out *certmanager.Certificate, s conversion.Scope) error {
	return autoConvert_v1alpha3_Certificate_To_certmanager_Certificate(in, out, s)
}

func autoConvert_certmanager_Certificate_To_v1alpha3_Certificate(in *certmanager.Certificate, out *v1alpha3.Certificate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_CertificateSpec_To_v1alpha3_CertificateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_Certificate_To_v1alpha3_Certificate is an autogenerated conversion function.
func Convert_certmanager_Certificate_To_v1alpha3_Certificate(in *certmanager.Certificate, out *v1alpha3.Certificate, s conversion.Scope) error {
	return autoConvert_certmanager_Certificate_To_v1alpha3_Certificate(in, out, s)
}

func autoConvert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(in *v1alpha3.CertificateCondition, out *certmanager.CertificateCondition, s conversion.Scope) error {
	out.Type = certmanager.CertificateConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition is an autogenerated conversion function.
func Convert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(in *v1alpha3.CertificateCondition, out *certmanager.CertificateCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateCondition_To_certmanager_CertificateCondition(in, out, s)
}

func autoConvert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(in *certmanager.CertificateCondition, out *v1alpha3.CertificateCondition, s conversion.Scope) error {
	out.Type = v1alpha3.CertificateConditionType(in.Type)
	out.Status = metav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition is an autogenerated conversion function.
func Convert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(in *certmanager.CertificateCondition, out *v1alpha3.CertificateCondition, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateCondition_To_v1alpha3_CertificateCondition(in, out, s)
}

func autoConvert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(in *v1alpha3.CertificateKeystores, out *certmanager.CertificateKeystores, s conversion.Scope) error {
	out.JKS = (*certmanager.JKSKeystore)(unsafe.Pointer(in.JKS))
	out.PKCS12 = (*certmanager.PKCS12Keystore)(unsafe.Pointer(in.PKCS12))
	return nil
}

// Convert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores is an autogenerated conversion function.
func Convert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(in *v1alpha3.CertificateKeystores, out *certmanager.CertificateKeystores, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateKeystores_To_certmanager_CertificateKeystores(in, out, s)
}

func autoConvert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(in *certmanager.CertificateKeystores, out *v1alpha3.CertificateKeystores, s conversion.Scope) error {
	out.JKS = (*v1alpha3.JKSKeystore)(unsafe.Pointer(in.JKS))
	out.PKCS12 = (*v1alpha3.PKCS12Keystore)(unsafe.Pointer(in.PKCS12))
	return nil
}

// Convert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores is an autogenerated conversion function.
func Convert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(in *certmanager.CertificateKeystores, out *v1alpha3.CertificateKeystores, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateKeystores_To_v1alpha3_CertificateKeystores(in, out, s)
}

func autoConvert_v1alpha3_CertificateList_To_certmanager_CertificateList(in *v1alpha3.CertificateList, out *certmanager.CertificateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.Certificate, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_Certificate_To_certmanager_Certificate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_CertificateList_To_certmanager_CertificateList is an autogenerated conversion function.
func Convert_v1alpha3_CertificateList_To_certmanager_CertificateList(in *v1alpha3.CertificateList, out *certmanager.CertificateList, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateList_To_certmanager_CertificateList(in, out, s)
}

func autoConvert_certmanager_CertificateList_To_v1alpha3_CertificateList(in *certmanager.CertificateList, out *v1alpha3.CertificateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha3.Certificate, len(*in))
		for i := range *in {
			if err := Convert_certmanager_Certificate_To_v1alpha3_Certificate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_CertificateList_To_v1alpha3_CertificateList is an autogenerated conversion function.
func Convert_certmanager_CertificateList_To_v1alpha3_CertificateList(in *certmanager.CertificateList, out *v1alpha3.CertificateList, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateList_To_v1alpha3_CertificateList(in, out, s)
}

func autoConvert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in *v1alpha3.CertificatePrivateKey, out *certmanager.CertificatePrivateKey, s conversion.Scope) error {
	out.RotationPolicy = certmanager.PrivateKeyRotationPolicy(in.RotationPolicy)
	return nil
}

// Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey is an autogenerated conversion function.
func Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in *v1alpha3.CertificatePrivateKey, out *certmanager.CertificatePrivateKey, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(in, out, s)
}

func autoConvert_certmanager_CertificatePrivateKey_To_v1alpha3_CertificatePrivateKey(in *certmanager.CertificatePrivateKey, out *v1alpha3.CertificatePrivateKey, s conversion.Scope) error {
	out.RotationPolicy = v1alpha3.PrivateKeyRotationPolicy(in.RotationPolicy)
	// WARNING: in.Encoding requires manual conversion: does not exist in peer-type
	// WARNING: in.Algorithm requires manual conversion: does not exist in peer-type
	// WARNING: in.Size requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(in *v1alpha3.CertificateRequest, out *certmanager.CertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(in *v1alpha3.CertificateRequest, out *certmanager.CertificateRequest, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(in, out, s)
}

func autoConvert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(in *certmanager.CertificateRequest, out *v1alpha3.CertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_CertificateRequestSpec_To_v1alpha3_CertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest is an autogenerated conversion function.
func Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(in *certmanager.CertificateRequest, out *v1alpha3.CertificateRequest, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(in, out, s)
}

func autoConvert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in *v1alpha3.CertificateRequestCondition, out *certmanager.CertificateRequestCondition, s conversion.Scope) error {
	out.Type = certmanager.CertificateRequestConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in *v1alpha3.CertificateRequestCondition, out *certmanager.CertificateRequestCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequestCondition_To_certmanager_CertificateRequestCondition(in, out, s)
}

func autoConvert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(in *certmanager.CertificateRequestCondition, out *v1alpha3.CertificateRequestCondition, s conversion.Scope) error {
	out.Type = v1alpha3.CertificateRequestConditionType(in.Type)
	out.Status = metav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(in *certmanager.CertificateRequestCondition, out *v1alpha3.CertificateRequestCondition, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestCondition_To_v1alpha3_CertificateRequestCondition(in, out, s)
}

func autoConvert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(in *v1alpha3.CertificateRequestList, out *certmanager.CertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]certmanager.CertificateRequest, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_CertificateRequest_To_certmanager_CertificateRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(in *v1alpha3.CertificateRequestList, out *certmanager.CertificateRequestList, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequestList_To_certmanager_CertificateRequestList(in, out, s)
}

func autoConvert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(in *certmanager.CertificateRequestList, out *v1alpha3.CertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1alpha3.CertificateRequest, len(*in))
		for i := range *in {
			if err := Convert_certmanager_CertificateRequest_To_v1alpha3_CertificateRequest(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(in *certmanager.CertificateRequestList, out *v1alpha3.CertificateRequestList, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestList_To_v1alpha3_CertificateRequestList(in, out, s)
}

func autoConvert_v1alpha3_CertificateRequestSpec_To_certmanager_CertificateRequestSpec(in *v1alpha3.CertificateRequestSpec, out *certmanager.CertificateRequestSpec, s conversion.Scope) error {
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	// WARNING: in.CSRPEM requires manual conversion: does not exist in peer-type
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanager.KeyUsage)(unsafe.Pointer(&in.Usages))
	return nil
}

func autoConvert_certmanager_CertificateRequestSpec_To_v1alpha3_CertificateRequestSpec(in *certmanager.CertificateRequestSpec, out *v1alpha3.CertificateRequestSpec, s conversion.Scope) error {
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	// WARNING: in.Request requires manual conversion: does not exist in peer-type
	out.IsCA = in.IsCA
	out.Usages = *(*[]v1alpha3.KeyUsage)(unsafe.Pointer(&in.Usages))
	return nil
}

func autoConvert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in *v1alpha3.CertificateRequestStatus, out *certmanager.CertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.CertificateRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.CA = *(*[]byte)(unsafe.Pointer(&in.CA))
	out.FailureTime = (*v1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus is an autogenerated conversion function.
func Convert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in *v1alpha3.CertificateRequestStatus, out *certmanager.CertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateRequestStatus_To_certmanager_CertificateRequestStatus(in, out, s)
}

func autoConvert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(in *certmanager.CertificateRequestStatus, out *v1alpha3.CertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]v1alpha3.CertificateRequestCondition)(unsafe.Pointer(&in.Conditions))
	out.Certificate = *(*[]byte)(unsafe.Pointer(&in.Certificate))
	out.CA = *(*[]byte)(unsafe.Pointer(&in.CA))
	out.FailureTime = (*v1.Time)(unsafe.Pointer(in.FailureTime))
	return nil
}

// Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus is an autogenerated conversion function.
func Convert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(in *certmanager.CertificateRequestStatus, out *v1alpha3.CertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateRequestStatus_To_v1alpha3_CertificateRequestStatus(in, out, s)
}

func autoConvert_v1alpha3_CertificateSpec_To_certmanager_CertificateSpec(in *v1alpha3.CertificateSpec, out *certmanager.CertificateSpec, s conversion.Scope) error {
	if in.Subject != nil {
		in, out := &in.Subject, &out.Subject
		*out = new(certmanager.X509Subject)
		if err := Convert_v1alpha3_X509Subject_To_certmanager_X509Subject(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Subject = nil
	}
	out.CommonName = in.CommonName
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	out.RenewBefore = (*v1.Duration)(unsafe.Pointer(in.RenewBefore))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.URISANs = *(*[]string)(unsafe.Pointer(&in.URISANs))
	out.EmailSANs = *(*[]string)(unsafe.Pointer(&in.EmailSANs))
	out.SecretName = in.SecretName
	out.Keystores = (*certmanager.CertificateKeystores)(unsafe.Pointer(in.Keystores))
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	out.IsCA = in.IsCA
	out.Usages = *(*[]certmanager.KeyUsage)(unsafe.Pointer(&in.Usages))
	// WARNING: in.KeySize requires manual conversion: does not exist in peer-type
	// WARNING: in.KeyAlgorithm requires manual conversion: does not exist in peer-type
	// WARNING: in.KeyEncoding requires manual conversion: does not exist in peer-type
	if in.PrivateKey != nil {
		in, out := &in.PrivateKey, &out.PrivateKey
		*out = new(certmanager.CertificatePrivateKey)
		if err := Convert_v1alpha3_CertificatePrivateKey_To_certmanager_CertificatePrivateKey(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PrivateKey = nil
	}
	out.EncodeUsagesInRequest = (*bool)(unsafe.Pointer(in.EncodeUsagesInRequest))
	return nil
}

func autoConvert_certmanager_CertificateSpec_To_v1alpha3_CertificateSpec(in *certmanager.CertificateSpec, out *v1alpha3.CertificateSpec, s conversion.Scope) error {
	if in.Subject != nil {
		in, out := &in.Subject, &out.Subject
		*out = new(v1alpha3.X509Subject)
		if err := Convert_certmanager_X509Subject_To_v1alpha3_X509Subject(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Subject = nil
	}
	out.CommonName = in.CommonName
	out.Duration = (*v1.Duration)(unsafe.Pointer(in.Duration))
	out.RenewBefore = (*v1.Duration)(unsafe.Pointer(in.RenewBefore))
	out.DNSNames = *(*[]string)(unsafe.Pointer(&in.DNSNames))
	out.IPAddresses = *(*[]string)(unsafe.Pointer(&in.IPAddresses))
	out.URISANs = *(*[]string)(unsafe.Pointer(&in.URISANs))
	out.EmailSANs = *(*[]string)(unsafe.Pointer(&in.EmailSANs))
	out.SecretName = in.SecretName
	out.Keystores = (*v1alpha3.CertificateKeystores)(unsafe.Pointer(in.Keystores))
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.IssuerRef, &out.IssuerRef, 0); err != nil {
		return err
	}
	out.IsCA = in.IsCA
	out.Usages = *(*[]v1alpha3.KeyUsage)(unsafe.Pointer(&in.Usages))
	if in.PrivateKey != nil {
		in, out := &in.PrivateKey, &out.PrivateKey
		*out = new(v1alpha3.CertificatePrivateKey)
		if err := Convert_certmanager_CertificatePrivateKey_To_v1alpha3_CertificatePrivateKey(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PrivateKey = nil
	}
	out.EncodeUsagesInRequest = (*bool)(unsafe.Pointer(in.EncodeUsagesInRequest))
	return nil
}

func autoConvert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(in *v1alpha3.CertificateStatus, out *certmanager.CertificateStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.CertificateCondition)(unsafe.Pointer(&in.Conditions))
	out.LastFailureTime = (*v1.Time)(unsafe.Pointer(in.LastFailureTime))
	out.NotBefore = (*v1.Time)(unsafe.Pointer(in.NotBefore))
	out.NotAfter = (*v1.Time)(unsafe.Pointer(in.NotAfter))
	out.RenewalTime = (*v1.Time)(unsafe.Pointer(in.RenewalTime))
	out.Revision = (*int)(unsafe.Pointer(in.Revision))
	out.NextPrivateKeySecretName = (*string)(unsafe.Pointer(in.NextPrivateKeySecretName))
	return nil
}

// Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus is an autogenerated conversion function.
func Convert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(in *v1alpha3.CertificateStatus, out *certmanager.CertificateStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_CertificateStatus_To_certmanager_CertificateStatus(in, out, s)
}

func autoConvert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(in *certmanager.CertificateStatus, out *v1alpha3.CertificateStatus, s conversion.Scope) error {
	out.Conditions = *(*[]v1alpha3.CertificateCondition)(unsafe.Pointer(&in.Conditions))
	out.LastFailureTime = (*v1.Time)(unsafe.Pointer(in.LastFailureTime))
	out.NotBefore = (*v1.Time)(unsafe.Pointer(in.NotBefore))
	out.NotAfter = (*v1.Time)(unsafe.Pointer(in.NotAfter))
	out.RenewalTime = (*v1.Time)(unsafe.Pointer(in.RenewalTime))
	out.Revision = (*int)(unsafe.Pointer(in.Revision))
	out.NextPrivateKeySecretName = (*string)(unsafe.Pointer(in.NextPrivateKeySecretName))
	return nil
}

// Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus is an autogenerated conversion function.
func Convert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(in *certmanager.CertificateStatus, out *v1alpha3.CertificateStatus, s conversion.Scope) error {
	return autoConvert_certmanager_CertificateStatus_To_v1alpha3_CertificateStatus(in, out, s)
}

func autoConvert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(in *v1alpha3.ClusterIssuer, out *certmanager.ClusterIssuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer is an autogenerated conversion function.
func Convert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(in *v1alpha3.ClusterIssuer, out *certmanager.ClusterIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_ClusterIssuer_To_certmanager_ClusterIssuer(in, out, s)
}

func autoConvert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(in *certmanager.ClusterIssuer, out *v1alpha3.ClusterIssuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer is an autogenerated conversion function.
func Convert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(in *certmanager.ClusterIssuer, out *v1alpha3.ClusterIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_ClusterIssuer_To_v1alpha3_ClusterIssuer(in, out, s)
}

func autoConvert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(in *v1alpha3.ClusterIssuerList, out *certmanager.ClusterIssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certmanager.ClusterIssuer)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList is an autogenerated conversion function.
func Convert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(in *v1alpha3.ClusterIssuerList, out *certmanager.ClusterIssuerList, s conversion.Scope) error {
	return autoConvert_v1alpha3_ClusterIssuerList_To_certmanager_ClusterIssuerList(in, out, s)
}

func autoConvert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(in *certmanager.ClusterIssuerList, out *v1alpha3.ClusterIssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha3.ClusterIssuer)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList is an autogenerated conversion function.
func Convert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(in *certmanager.ClusterIssuerList, out *v1alpha3.ClusterIssuerList, s conversion.Scope) error {
	return autoConvert_certmanager_ClusterIssuerList_To_v1alpha3_ClusterIssuerList(in, out, s)
}

func autoConvert_v1alpha3_Issuer_To_certmanager_Issuer(in *v1alpha3.Issuer, out *certmanager.Issuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_Issuer_To_certmanager_Issuer is an autogenerated conversion function.
func Convert_v1alpha3_Issuer_To_certmanager_Issuer(in *v1alpha3.Issuer, out *certmanager.Issuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_Issuer_To_certmanager_Issuer(in, out, s)
}

func autoConvert_certmanager_Issuer_To_v1alpha3_Issuer(in *certmanager.Issuer, out *v1alpha3.Issuer, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_Issuer_To_v1alpha3_Issuer is an autogenerated conversion function.
func Convert_certmanager_Issuer_To_v1alpha3_Issuer(in *certmanager.Issuer, out *v1alpha3.Issuer, s conversion.Scope) error {
	return autoConvert_certmanager_Issuer_To_v1alpha3_Issuer(in, out, s)
}

func autoConvert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(in *v1alpha3.IssuerCondition, out *certmanager.IssuerCondition, s conversion.Scope) error {
	out.Type = certmanager.IssuerConditionType(in.Type)
	out.Status = meta.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition is an autogenerated conversion function.
func Convert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(in *v1alpha3.IssuerCondition, out *certmanager.IssuerCondition, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerCondition_To_certmanager_IssuerCondition(in, out, s)
}

func autoConvert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(in *certmanager.IssuerCondition, out *v1alpha3.IssuerCondition, s conversion.Scope) error {
	out.Type = v1alpha3.IssuerConditionType(in.Type)
	out.Status = metav1.ConditionStatus(in.Status)
	out.LastTransitionTime = (*v1.Time)(unsafe.Pointer(in.LastTransitionTime))
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition is an autogenerated conversion function.
func Convert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(in *certmanager.IssuerCondition, out *v1alpha3.IssuerCondition, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerCondition_To_v1alpha3_IssuerCondition(in, out, s)
}

func autoConvert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(in *v1alpha3.IssuerConfig, out *certmanager.IssuerConfig, s conversion.Scope) error {
	out.ACME = (*acme.ACMEIssuer)(unsafe.Pointer(in.ACME))
	out.CA = (*certmanager.CAIssuer)(unsafe.Pointer(in.CA))
	out.Vault = (*certmanager.VaultIssuer)(unsafe.Pointer(in.Vault))
	out.SelfSigned = (*certmanager.SelfSignedIssuer)(unsafe.Pointer(in.SelfSigned))
	out.Venafi = (*certmanager.VenafiIssuer)(unsafe.Pointer(in.Venafi))
	return nil
}

// Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig is an autogenerated conversion function.
func Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(in *v1alpha3.IssuerConfig, out *certmanager.IssuerConfig, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(in, out, s)
}

func autoConvert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(in *certmanager.IssuerConfig, out *v1alpha3.IssuerConfig, s conversion.Scope) error {
	out.ACME = (*acmev1alpha3.ACMEIssuer)(unsafe.Pointer(in.ACME))
	out.CA = (*v1alpha3.CAIssuer)(unsafe.Pointer(in.CA))
	out.Vault = (*v1alpha3.VaultIssuer)(unsafe.Pointer(in.Vault))
	out.SelfSigned = (*v1alpha3.SelfSignedIssuer)(unsafe.Pointer(in.SelfSigned))
	out.Venafi = (*v1alpha3.VenafiIssuer)(unsafe.Pointer(in.Venafi))
	return nil
}

// Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig is an autogenerated conversion function.
func Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(in *certmanager.IssuerConfig, out *v1alpha3.IssuerConfig, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(in, out, s)
}

func autoConvert_v1alpha3_IssuerList_To_certmanager_IssuerList(in *v1alpha3.IssuerList, out *certmanager.IssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certmanager.Issuer)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha3_IssuerList_To_certmanager_IssuerList is an autogenerated conversion function.
func Convert_v1alpha3_IssuerList_To_certmanager_IssuerList(in *v1alpha3.IssuerList, out *certmanager.IssuerList, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerList_To_certmanager_IssuerList(in, out, s)
}

func autoConvert_certmanager_IssuerList_To_v1alpha3_IssuerList(in *certmanager.IssuerList, out *v1alpha3.IssuerList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1alpha3.Issuer)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_certmanager_IssuerList_To_v1alpha3_IssuerList is an autogenerated conversion function.
func Convert_certmanager_IssuerList_To_v1alpha3_IssuerList(in *certmanager.IssuerList, out *v1alpha3.IssuerList, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerList_To_v1alpha3_IssuerList(in, out, s)
}

func autoConvert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(in *v1alpha3.IssuerSpec, out *certmanager.IssuerSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_IssuerConfig_To_certmanager_IssuerConfig(&in.IssuerConfig, &out.IssuerConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec is an autogenerated conversion function.
func Convert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(in *v1alpha3.IssuerSpec, out *certmanager.IssuerSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerSpec_To_certmanager_IssuerSpec(in, out, s)
}

func autoConvert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(in *certmanager.IssuerSpec, out *v1alpha3.IssuerSpec, s conversion.Scope) error {
	if err := Convert_certmanager_IssuerConfig_To_v1alpha3_IssuerConfig(&in.IssuerConfig, &out.IssuerConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec is an autogenerated conversion function.
func Convert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(in *certmanager.IssuerSpec, out *v1alpha3.IssuerSpec, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerSpec_To_v1alpha3_IssuerSpec(in, out, s)
}

func autoConvert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(in *v1alpha3.IssuerStatus, out *certmanager.IssuerStatus, s conversion.Scope) error {
	out.Conditions = *(*[]certmanager.IssuerCondition)(unsafe.Pointer(&in.Conditions))
	out.ACME = (*acme.ACMEIssuerStatus)(unsafe.Pointer(in.ACME))
	return nil
}

// Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus is an autogenerated conversion function.
func Convert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(in *v1alpha3.IssuerStatus, out *certmanager.IssuerStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_IssuerStatus_To_certmanager_IssuerStatus(in, out, s)
}

func autoConvert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(in *certmanager.IssuerStatus, out *v1alpha3.IssuerStatus, s conversion.Scope) error {
	out.Conditions = *(*[]v1alpha3.IssuerCondition)(unsafe.Pointer(&in.Conditions))
	out.ACME = (*acmev1alpha3.ACMEIssuerStatus)(unsafe.Pointer(in.ACME))
	return nil
}

// Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus is an autogenerated conversion function.
func Convert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(in *certmanager.IssuerStatus, out *v1alpha3.IssuerStatus, s conversion.Scope) error {
	return autoConvert_certmanager_IssuerStatus_To_v1alpha3_IssuerStatus(in, out, s)
}

func autoConvert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(in *v1alpha3.JKSKeystore, out *certmanager.JKSKeystore, s conversion.Scope) error {
	out.Create = in.Create
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.PasswordSecretRef, &out.PasswordSecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore is an autogenerated conversion function.
func Convert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(in *v1alpha3.JKSKeystore, out *certmanager.JKSKeystore, s conversion.Scope) error {
	return autoConvert_v1alpha3_JKSKeystore_To_certmanager_JKSKeystore(in, out, s)
}

func autoConvert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(in *certmanager.JKSKeystore, out *v1alpha3.JKSKeystore, s conversion.Scope) error {
	out.Create = in.Create
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.PasswordSecretRef, &out.PasswordSecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore is an autogenerated conversion function.
func Convert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(in *certmanager.JKSKeystore, out *v1alpha3.JKSKeystore, s conversion.Scope) error {
	return autoConvert_certmanager_JKSKeystore_To_v1alpha3_JKSKeystore(in, out, s)
}

func autoConvert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(in *v1alpha3.PKCS12Keystore, out *certmanager.PKCS12Keystore, s conversion.Scope) error {
	out.Create = in.Create
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.PasswordSecretRef, &out.PasswordSecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore is an autogenerated conversion function.
func Convert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(in *v1alpha3.PKCS12Keystore, out *certmanager.PKCS12Keystore, s conversion.Scope) error {
	return autoConvert_v1alpha3_PKCS12Keystore_To_certmanager_PKCS12Keystore(in, out, s)
}

func autoConvert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(in *certmanager.PKCS12Keystore, out *v1alpha3.PKCS12Keystore, s conversion.Scope) error {
	out.Create = in.Create
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.PasswordSecretRef, &out.PasswordSecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore is an autogenerated conversion function.
func Convert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(in *certmanager.PKCS12Keystore, out *v1alpha3.PKCS12Keystore, s conversion.Scope) error {
	return autoConvert_certmanager_PKCS12Keystore_To_v1alpha3_PKCS12Keystore(in, out, s)
}

func autoConvert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in *v1alpha3.SelfSignedIssuer, out *certmanager.SelfSignedIssuer, s conversion.Scope) error {
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer is an autogenerated conversion function.
func Convert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in *v1alpha3.SelfSignedIssuer, out *certmanager.SelfSignedIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_SelfSignedIssuer_To_certmanager_SelfSignedIssuer(in, out, s)
}

func autoConvert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(in *certmanager.SelfSignedIssuer, out *v1alpha3.SelfSignedIssuer, s conversion.Scope) error {
	out.CRLDistributionPoints = *(*[]string)(unsafe.Pointer(&in.CRLDistributionPoints))
	return nil
}

// Convert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer is an autogenerated conversion function.
func Convert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(in *certmanager.SelfSignedIssuer, out *v1alpha3.SelfSignedIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_SelfSignedIssuer_To_v1alpha3_SelfSignedIssuer(in, out, s)
}

func autoConvert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(in *v1alpha3.VaultAppRole, out *certmanager.VaultAppRole, s conversion.Scope) error {
	out.Path = in.Path
	out.RoleId = in.RoleId
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.SecretRef, &out.SecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole is an autogenerated conversion function.
func Convert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(in *v1alpha3.VaultAppRole, out *certmanager.VaultAppRole, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultAppRole_To_certmanager_VaultAppRole(in, out, s)
}

func autoConvert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(in *certmanager.VaultAppRole, out *v1alpha3.VaultAppRole, s conversion.Scope) error {
	out.Path = in.Path
	out.RoleId = in.RoleId
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.SecretRef, &out.SecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole is an autogenerated conversion function.
func Convert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(in *certmanager.VaultAppRole, out *v1alpha3.VaultAppRole, s conversion.Scope) error {
	return autoConvert_certmanager_VaultAppRole_To_v1alpha3_VaultAppRole(in, out, s)
}

func autoConvert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(in *v1alpha3.VaultAuth, out *certmanager.VaultAuth, s conversion.Scope) error {
	out.TokenSecretRef = (*meta.SecretKeySelector)(unsafe.Pointer(in.TokenSecretRef))
	out.AppRole = (*certmanager.VaultAppRole)(unsafe.Pointer(in.AppRole))
	out.Kubernetes = (*certmanager.VaultKubernetesAuth)(unsafe.Pointer(in.Kubernetes))
	return nil
}

// Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth is an autogenerated conversion function.
func Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(in *v1alpha3.VaultAuth, out *certmanager.VaultAuth, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(in, out, s)
}

func autoConvert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(in *certmanager.VaultAuth, out *v1alpha3.VaultAuth, s conversion.Scope) error {
	out.TokenSecretRef = (*metav1.SecretKeySelector)(unsafe.Pointer(in.TokenSecretRef))
	out.AppRole = (*v1alpha3.VaultAppRole)(unsafe.Pointer(in.AppRole))
	out.Kubernetes = (*v1alpha3.VaultKubernetesAuth)(unsafe.Pointer(in.Kubernetes))
	return nil
}

// Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth is an autogenerated conversion function.
func Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(in *certmanager.VaultAuth, out *v1alpha3.VaultAuth, s conversion.Scope) error {
	return autoConvert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(in, out, s)
}

func autoConvert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(in *v1alpha3.VaultIssuer, out *certmanager.VaultIssuer, s conversion.Scope) error {
	if err := Convert_v1alpha3_VaultAuth_To_certmanager_VaultAuth(&in.Auth, &out.Auth, s); err != nil {
		return err
	}
	out.Server = in.Server
	out.Path = in.Path
	out.Namespace = in.Namespace
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	return nil
}

// Convert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer is an autogenerated conversion function.
func Convert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(in *v1alpha3.VaultIssuer, out *certmanager.VaultIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultIssuer_To_certmanager_VaultIssuer(in, out, s)
}

func autoConvert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(in *certmanager.VaultIssuer, out *v1alpha3.VaultIssuer, s conversion.Scope) error {
	if err := Convert_certmanager_VaultAuth_To_v1alpha3_VaultAuth(&in.Auth, &out.Auth, s); err != nil {
		return err
	}
	out.Server = in.Server
	out.Path = in.Path
	out.Namespace = in.Namespace
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	return nil
}

// Convert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer is an autogenerated conversion function.
func Convert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(in *certmanager.VaultIssuer, out *v1alpha3.VaultIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_VaultIssuer_To_v1alpha3_VaultIssuer(in, out, s)
}

func autoConvert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in *v1alpha3.VaultKubernetesAuth, out *certmanager.VaultKubernetesAuth, s conversion.Scope) error {
	out.Path = in.Path
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.SecretRef, &out.SecretRef, 0); err != nil {
		return err
	}
	out.Role = in.Role
	return nil
}

// Convert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth is an autogenerated conversion function.
func Convert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in *v1alpha3.VaultKubernetesAuth, out *certmanager.VaultKubernetesAuth, s conversion.Scope) error {
	return autoConvert_v1alpha3_VaultKubernetesAuth_To_certmanager_VaultKubernetesAuth(in, out, s)
}

func autoConvert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth(in *certmanager.VaultKubernetesAuth, out *v1alpha3.VaultKubernetesAuth, s conversion.Scope) error {
	out.Path = in.Path
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.SecretRef, &out.SecretRef, 0); err != nil {
		return err
	}
	out.Role = in.Role
	return nil
}

// Convert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth is an autogenerated conversion function.
func Convert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth(in *certmanager.VaultKubernetesAuth, out *v1alpha3.VaultKubernetesAuth, s conversion.Scope) error {
	return autoConvert_certmanager_VaultKubernetesAuth_To_v1alpha3_VaultKubernetesAuth(in, out, s)
}

func autoConvert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(in *v1alpha3.VenafiCloud, out *certmanager.VenafiCloud, s conversion.Scope) error {
	out.URL = in.URL
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.APITokenSecretRef, &out.APITokenSecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud is an autogenerated conversion function.
func Convert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(in *v1alpha3.VenafiCloud, out *certmanager.VenafiCloud, s conversion.Scope) error {
	return autoConvert_v1alpha3_VenafiCloud_To_certmanager_VenafiCloud(in, out, s)
}

func autoConvert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(in *certmanager.VenafiCloud, out *v1alpha3.VenafiCloud, s conversion.Scope) error {
	out.URL = in.URL
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.APITokenSecretRef, &out.APITokenSecretRef, 0); err != nil {
		return err
	}
	return nil
}

// Convert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud is an autogenerated conversion function.
func Convert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(in *certmanager.VenafiCloud, out *v1alpha3.VenafiCloud, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiCloud_To_v1alpha3_VenafiCloud(in, out, s)
}

func autoConvert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(in *v1alpha3.VenafiIssuer, out *certmanager.VenafiIssuer, s conversion.Scope) error {
	out.Zone = in.Zone
	out.TPP = (*certmanager.VenafiTPP)(unsafe.Pointer(in.TPP))
	out.Cloud = (*certmanager.VenafiCloud)(unsafe.Pointer(in.Cloud))
	return nil
}

// Convert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer is an autogenerated conversion function.
func Convert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(in *v1alpha3.VenafiIssuer, out *certmanager.VenafiIssuer, s conversion.Scope) error {
	return autoConvert_v1alpha3_VenafiIssuer_To_certmanager_VenafiIssuer(in, out, s)
}

func autoConvert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(in *certmanager.VenafiIssuer, out *v1alpha3.VenafiIssuer, s conversion.Scope) error {
	out.Zone = in.Zone
	out.TPP = (*v1alpha3.VenafiTPP)(unsafe.Pointer(in.TPP))
	out.Cloud = (*v1alpha3.VenafiCloud)(unsafe.Pointer(in.Cloud))
	return nil
}

// Convert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer is an autogenerated conversion function.
func Convert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(in *certmanager.VenafiIssuer, out *v1alpha3.VenafiIssuer, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiIssuer_To_v1alpha3_VenafiIssuer(in, out, s)
}

func autoConvert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(in *v1alpha3.VenafiTPP, out *certmanager.VenafiTPP, s conversion.Scope) error {
	out.URL = in.URL
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.CredentialsRef, &out.CredentialsRef, 0); err != nil {
		return err
	}
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	return nil
}

// Convert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP is an autogenerated conversion function.
func Convert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(in *v1alpha3.VenafiTPP, out *certmanager.VenafiTPP, s conversion.Scope) error {
	return autoConvert_v1alpha3_VenafiTPP_To_certmanager_VenafiTPP(in, out, s)
}

func autoConvert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(in *certmanager.VenafiTPP, out *v1alpha3.VenafiTPP, s conversion.Scope) error {
	out.URL = in.URL
	// TODO: Inefficient conversion - can we improve it?
	if err := s.Convert(&in.CredentialsRef, &out.CredentialsRef, 0); err != nil {
		return err
	}
	out.CABundle = *(*[]byte)(unsafe.Pointer(&in.CABundle))
	return nil
}

// Convert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP is an autogenerated conversion function.
func Convert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(in *certmanager.VenafiTPP, out *v1alpha3.VenafiTPP, s conversion.Scope) error {
	return autoConvert_certmanager_VenafiTPP_To_v1alpha3_VenafiTPP(in, out, s)
}

func autoConvert_v1alpha3_X509Subject_To_certmanager_X509Subject(in *v1alpha3.X509Subject, out *certmanager.X509Subject, s conversion.Scope) error {
	out.Organizations = *(*[]string)(unsafe.Pointer(&in.Organizations))
	out.Countries = *(*[]string)(unsafe.Pointer(&in.Countries))
	out.OrganizationalUnits = *(*[]string)(unsafe.Pointer(&in.OrganizationalUnits))
	out.Localities = *(*[]string)(unsafe.Pointer(&in.Localities))
	out.Provinces = *(*[]string)(unsafe.Pointer(&in.Provinces))
	out.StreetAddresses = *(*[]string)(unsafe.Pointer(&in.StreetAddresses))
	out.PostalCodes = *(*[]string)(unsafe.Pointer(&in.PostalCodes))
	out.SerialNumber = in.SerialNumber
	return nil
}

// Convert_v1alpha3_X509Subject_To_certmanager_X509Subject is an autogenerated conversion function.
func Convert_v1alpha3_X509Subject_To_certmanager_X509Subject(in *v1alpha3.X509Subject, out *certmanager.X509Subject, s conversion.Scope) error {
	return autoConvert_v1alpha3_X509Subject_To_certmanager_X509Subject(in, out, s)
}

func autoConvert_certmanager_X509Subject_To_v1alpha3_X509Subject(in *certmanager.X509Subject, out *v1alpha3.X509Subject, s conversion.Scope) error {
	out.Organizations = *(*[]string)(unsafe.Pointer(&in.Organizations))
	out.Countries = *(*[]string)(unsafe.Pointer(&in.Countries))
	out.OrganizationalUnits = *(*[]string)(unsafe.Pointer(&in.OrganizationalUnits))
	out.Localities = *(*[]string)(unsafe.Pointer(&in.Localities))
	out.Provinces = *(*[]string)(unsafe.Pointer(&in.Provinces))
	out.StreetAddresses = *(*[]string)(unsafe.Pointer(&in.StreetAddresses))
	out.PostalCodes = *(*[]string)(unsafe.Pointer(&in.PostalCodes))
	out.SerialNumber = in.SerialNumber
	return nil
}
