/*
Copyright 2020 The Jetstack cert-manager contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package externalversions

import (
	"fmt"

	v1 "github.com/jetstack/cert-manager/pkg/apis/acme/v1"
	v1alpha2 "github.com/jetstack/cert-manager/pkg/apis/acme/v1alpha2"
	v1alpha3 "github.com/jetstack/cert-manager/pkg/apis/acme/v1alpha3"
	v1beta1 "github.com/jetstack/cert-manager/pkg/apis/acme/v1beta1"
	certmanagerv1 "github.com/jetstack/cert-manager/pkg/apis/certmanager/v1"
	certmanagerv1alpha2 "github.com/jetstack/cert-manager/pkg/apis/certmanager/v1alpha2"
	certmanagerv1alpha3 "github.com/jetstack/cert-manager/pkg/apis/certmanager/v1alpha3"
	certmanagerv1beta1 "github.com/jetstack/cert-manager/pkg/apis/certmanager/v1beta1"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=acme.cert-manager.io, Version=v1
	case v1.SchemeGroupVersion.WithResource("challenges"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1().Challenges().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("orders"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1().Orders().Informer()}, nil

		// Group=acme.cert-manager.io, Version=v1alpha2
	case v1alpha2.SchemeGroupVersion.WithResource("challenges"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1alpha2().Challenges().Informer()}, nil
	case v1alpha2.SchemeGroupVersion.WithResource("orders"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1alpha2().Orders().Informer()}, nil

		// Group=acme.cert-manager.io, Version=v1alpha3
	case v1alpha3.SchemeGroupVersion.WithResource("challenges"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1alpha3().Challenges().Informer()}, nil
	case v1alpha3.SchemeGroupVersion.WithResource("orders"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1alpha3().Orders().Informer()}, nil

		// Group=acme.cert-manager.io, Version=v1beta1
	case v1beta1.SchemeGroupVersion.WithResource("challenges"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1beta1().Challenges().Informer()}, nil
	case v1beta1.SchemeGroupVersion.WithResource("orders"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Acme().V1beta1().Orders().Informer()}, nil

		// Group=cert-manager.io, Version=v1
	case certmanagerv1.SchemeGroupVersion.WithResource("certificates"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1().Certificates().Informer()}, nil
	case certmanagerv1.SchemeGroupVersion.WithResource("certificaterequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1().CertificateRequests().Informer()}, nil
	case certmanagerv1.SchemeGroupVersion.WithResource("clusterissuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1().ClusterIssuers().Informer()}, nil
	case certmanagerv1.SchemeGroupVersion.WithResource("issuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1().Issuers().Informer()}, nil

		// Group=cert-manager.io, Version=v1alpha2
	case certmanagerv1alpha2.SchemeGroupVersion.WithResource("certificates"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha2().Certificates().Informer()}, nil
	case certmanagerv1alpha2.SchemeGroupVersion.WithResource("certificaterequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha2().CertificateRequests().Informer()}, nil
	case certmanagerv1alpha2.SchemeGroupVersion.WithResource("clusterissuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha2().ClusterIssuers().Informer()}, nil
	case certmanagerv1alpha2.SchemeGroupVersion.WithResource("issuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha2().Issuers().Informer()}, nil

		// Group=cert-manager.io, Version=v1alpha3
	case certmanagerv1alpha3.SchemeGroupVersion.WithResource("certificates"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha3().Certificates().Informer()}, nil
	case certmanagerv1alpha3.SchemeGroupVersion.WithResource("certificaterequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha3().CertificateRequests().Informer()}, nil
	case certmanagerv1alpha3.SchemeGroupVersion.WithResource("clusterissuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha3().ClusterIssuers().Informer()}, nil
	case certmanagerv1alpha3.SchemeGroupVersion.WithResource("issuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1alpha3().Issuers().Informer()}, nil

		// Group=cert-manager.io, Version=v1beta1
	case certmanagerv1beta1.SchemeGroupVersion.WithResource("certificates"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1beta1().Certificates().Informer()}, nil
	case certmanagerv1beta1.SchemeGroupVersion.WithResource("certificaterequests"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1beta1().CertificateRequests().Informer()}, nil
	case certmanagerv1beta1.SchemeGroupVersion.WithResource("clusterissuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1beta1().ClusterIssuers().Informer()}, nil
	case certmanagerv1beta1.SchemeGroupVersion.WithResource("issuers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Certmanager().V1beta1().Issuers().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
