// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediaconnect

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddFlowOutputs = "AddFlowOutputs"

// AddFlowOutputsRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowOutputs for more information on using the AddFlowOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddFlowOutputsRequest method.
//    req, resp := client.AddFlowOutputsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs
func (c *MediaConnect) AddFlowOutputsRequest(input *AddFlowOutputsInput) (req *request.Request, output *AddFlowOutputsOutput) {
	op := &request.Operation{
		Name:       opAddFlowOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/outputs",
	}

	if input == nil {
		input = &AddFlowOutputsInput{}
	}

	output = &AddFlowOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowOutputs API operation for AWS MediaConnect.
//
// Adds outputs to an existing flow. You can create up to 50 outputs per flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowOutputs for usage and error information.
//
// Returned Error Types:
//   * AddFlowOutputs420Exception
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowOutputs
func (c *MediaConnect) AddFlowOutputs(input *AddFlowOutputsInput) (*AddFlowOutputsOutput, error) {
	req, out := c.AddFlowOutputsRequest(input)
	return out, req.Send()
}

// AddFlowOutputsWithContext is the same as AddFlowOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowOutputsWithContext(ctx aws.Context, input *AddFlowOutputsInput, opts ...request.Option) (*AddFlowOutputsOutput, error) {
	req, out := c.AddFlowOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddFlowSources = "AddFlowSources"

// AddFlowSourcesRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowSources for more information on using the AddFlowSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddFlowSourcesRequest method.
//    req, resp := client.AddFlowSourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources
func (c *MediaConnect) AddFlowSourcesRequest(input *AddFlowSourcesInput) (req *request.Request, output *AddFlowSourcesOutput) {
	op := &request.Operation{
		Name:       opAddFlowSources,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/source",
	}

	if input == nil {
		input = &AddFlowSourcesInput{}
	}

	output = &AddFlowSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowSources API operation for AWS MediaConnect.
//
// Adds Sources to flow
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowSources for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowSources
func (c *MediaConnect) AddFlowSources(input *AddFlowSourcesInput) (*AddFlowSourcesOutput, error) {
	req, out := c.AddFlowSourcesRequest(input)
	return out, req.Send()
}

// AddFlowSourcesWithContext is the same as AddFlowSources with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowSourcesWithContext(ctx aws.Context, input *AddFlowSourcesInput, opts ...request.Option) (*AddFlowSourcesOutput, error) {
	req, out := c.AddFlowSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddFlowVpcInterfaces = "AddFlowVpcInterfaces"

// AddFlowVpcInterfacesRequest generates a "aws/request.Request" representing the
// client's request for the AddFlowVpcInterfaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddFlowVpcInterfaces for more information on using the AddFlowVpcInterfaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddFlowVpcInterfacesRequest method.
//    req, resp := client.AddFlowVpcInterfacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces
func (c *MediaConnect) AddFlowVpcInterfacesRequest(input *AddFlowVpcInterfacesInput) (req *request.Request, output *AddFlowVpcInterfacesOutput) {
	op := &request.Operation{
		Name:       opAddFlowVpcInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/vpcInterfaces",
	}

	if input == nil {
		input = &AddFlowVpcInterfacesInput{}
	}

	output = &AddFlowVpcInterfacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddFlowVpcInterfaces API operation for AWS MediaConnect.
//
// Adds VPC interfaces to flow
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation AddFlowVpcInterfaces for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/AddFlowVpcInterfaces
func (c *MediaConnect) AddFlowVpcInterfaces(input *AddFlowVpcInterfacesInput) (*AddFlowVpcInterfacesOutput, error) {
	req, out := c.AddFlowVpcInterfacesRequest(input)
	return out, req.Send()
}

// AddFlowVpcInterfacesWithContext is the same as AddFlowVpcInterfaces with the addition of
// the ability to pass a context and additional request options.
//
// See AddFlowVpcInterfaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) AddFlowVpcInterfacesWithContext(ctx aws.Context, input *AddFlowVpcInterfacesInput, opts ...request.Option) (*AddFlowVpcInterfacesOutput, error) {
	req, out := c.AddFlowVpcInterfacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlow = "CreateFlow"

// CreateFlowRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlow for more information on using the CreateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFlowRequest method.
//    req, resp := client.CreateFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow
func (c *MediaConnect) CreateFlowRequest(input *CreateFlowInput) (req *request.Request, output *CreateFlowOutput) {
	op := &request.Operation{
		Name:       opCreateFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows",
	}

	if input == nil {
		input = &CreateFlowInput{}
	}

	output = &CreateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlow API operation for AWS MediaConnect.
//
// Creates a new flow. The request must include one source. The request optionally
// can include outputs (up to 50) and entitlements (up to 50).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation CreateFlow for usage and error information.
//
// Returned Error Types:
//   * CreateFlow420Exception
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/CreateFlow
func (c *MediaConnect) CreateFlow(input *CreateFlowInput) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	return out, req.Send()
}

// CreateFlowWithContext is the same as CreateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) CreateFlowWithContext(ctx aws.Context, input *CreateFlowInput, opts ...request.Option) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlow = "DeleteFlow"

// DeleteFlowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlow for more information on using the DeleteFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFlowRequest method.
//    req, resp := client.DeleteFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow
func (c *MediaConnect) DeleteFlowRequest(input *DeleteFlowInput) (req *request.Request, output *DeleteFlowOutput) {
	op := &request.Operation{
		Name:       opDeleteFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &DeleteFlowInput{}
	}

	output = &DeleteFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlow API operation for AWS MediaConnect.
//
// Deletes a flow. Before you can delete a flow, you must stop the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DeleteFlow for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DeleteFlow
func (c *MediaConnect) DeleteFlow(input *DeleteFlowInput) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	return out, req.Send()
}

// DeleteFlowWithContext is the same as DeleteFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DeleteFlowWithContext(ctx aws.Context, input *DeleteFlowInput, opts ...request.Option) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFlow = "DescribeFlow"

// DescribeFlowRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFlow for more information on using the DescribeFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFlowRequest method.
//    req, resp := client.DescribeFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow
func (c *MediaConnect) DescribeFlowRequest(input *DescribeFlowInput) (req *request.Request, output *DescribeFlowOutput) {
	op := &request.Operation{
		Name:       opDescribeFlow,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &DescribeFlowInput{}
	}

	output = &DescribeFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFlow API operation for AWS MediaConnect.
//
// Displays the details of a flow. The response includes the flow ARN, name,
// and Availability Zone, as well as details about the source, outputs, and
// entitlements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation DescribeFlow for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/DescribeFlow
func (c *MediaConnect) DescribeFlow(input *DescribeFlowInput) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	return out, req.Send()
}

// DescribeFlowWithContext is the same as DescribeFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) DescribeFlowWithContext(ctx aws.Context, input *DescribeFlowInput, opts ...request.Option) (*DescribeFlowOutput, error) {
	req, out := c.DescribeFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGrantFlowEntitlements = "GrantFlowEntitlements"

// GrantFlowEntitlementsRequest generates a "aws/request.Request" representing the
// client's request for the GrantFlowEntitlements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GrantFlowEntitlements for more information on using the GrantFlowEntitlements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GrantFlowEntitlementsRequest method.
//    req, resp := client.GrantFlowEntitlementsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements
func (c *MediaConnect) GrantFlowEntitlementsRequest(input *GrantFlowEntitlementsInput) (req *request.Request, output *GrantFlowEntitlementsOutput) {
	op := &request.Operation{
		Name:       opGrantFlowEntitlements,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements",
	}

	if input == nil {
		input = &GrantFlowEntitlementsInput{}
	}

	output = &GrantFlowEntitlementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GrantFlowEntitlements API operation for AWS MediaConnect.
//
// Grants entitlements to an existing flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation GrantFlowEntitlements for usage and error information.
//
// Returned Error Types:
//   * GrantFlowEntitlements420Exception
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/GrantFlowEntitlements
func (c *MediaConnect) GrantFlowEntitlements(input *GrantFlowEntitlementsInput) (*GrantFlowEntitlementsOutput, error) {
	req, out := c.GrantFlowEntitlementsRequest(input)
	return out, req.Send()
}

// GrantFlowEntitlementsWithContext is the same as GrantFlowEntitlements with the addition of
// the ability to pass a context and additional request options.
//
// See GrantFlowEntitlements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) GrantFlowEntitlementsWithContext(ctx aws.Context, input *GrantFlowEntitlementsInput, opts ...request.Option) (*GrantFlowEntitlementsOutput, error) {
	req, out := c.GrantFlowEntitlementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEntitlements = "ListEntitlements"

// ListEntitlementsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitlements operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitlements for more information on using the ListEntitlements
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEntitlementsRequest method.
//    req, resp := client.ListEntitlementsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements
func (c *MediaConnect) ListEntitlementsRequest(input *ListEntitlementsInput) (req *request.Request, output *ListEntitlementsOutput) {
	op := &request.Operation{
		Name:       opListEntitlements,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/entitlements",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitlementsInput{}
	}

	output = &ListEntitlementsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitlements API operation for AWS MediaConnect.
//
// Displays a list of all entitlements that have been granted to this account.
// This request returns 20 results per page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListEntitlements for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListEntitlements
func (c *MediaConnect) ListEntitlements(input *ListEntitlementsInput) (*ListEntitlementsOutput, error) {
	req, out := c.ListEntitlementsRequest(input)
	return out, req.Send()
}

// ListEntitlementsWithContext is the same as ListEntitlements with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitlements for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListEntitlementsWithContext(ctx aws.Context, input *ListEntitlementsInput, opts ...request.Option) (*ListEntitlementsOutput, error) {
	req, out := c.ListEntitlementsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitlementsPages iterates over the pages of a ListEntitlements operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntitlements method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEntitlements operation.
//    pageNum := 0
//    err := client.ListEntitlementsPages(params,
//        func(page *mediaconnect.ListEntitlementsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaConnect) ListEntitlementsPages(input *ListEntitlementsInput, fn func(*ListEntitlementsOutput, bool) bool) error {
	return c.ListEntitlementsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitlementsPagesWithContext same as ListEntitlementsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListEntitlementsPagesWithContext(ctx aws.Context, input *ListEntitlementsInput, fn func(*ListEntitlementsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitlementsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitlementsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntitlementsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlows = "ListFlows"

// ListFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlows for more information on using the ListFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFlowsRequest method.
//    req, resp := client.ListFlowsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows
func (c *MediaConnect) ListFlowsRequest(input *ListFlowsInput) (req *request.Request, output *ListFlowsOutput) {
	op := &request.Operation{
		Name:       opListFlows,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/flows",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowsInput{}
	}

	output = &ListFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlows API operation for AWS MediaConnect.
//
// Displays a list of flows that are associated with this account. This request
// returns a paginated result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListFlows for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListFlows
func (c *MediaConnect) ListFlows(input *ListFlowsInput) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	return out, req.Send()
}

// ListFlowsWithContext is the same as ListFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListFlowsWithContext(ctx aws.Context, input *ListFlowsInput, opts ...request.Option) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowsPages iterates over the pages of a ListFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFlows operation.
//    pageNum := 0
//    err := client.ListFlowsPages(params,
//        func(page *mediaconnect.ListFlowsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MediaConnect) ListFlowsPages(input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool) error {
	return c.ListFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowsPagesWithContext same as ListFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListFlowsPagesWithContext(ctx aws.Context, input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource
func (c *MediaConnect) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS MediaConnect.
//
// List all tags on an AWS Elemental MediaConnect resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/ListTagsForResource
func (c *MediaConnect) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFlowOutput = "RemoveFlowOutput"

// RemoveFlowOutputRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowOutput for more information on using the RemoveFlowOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveFlowOutputRequest method.
//    req, resp := client.RemoveFlowOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput
func (c *MediaConnect) RemoveFlowOutputRequest(input *RemoveFlowOutputInput) (req *request.Request, output *RemoveFlowOutputOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowOutput,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/outputs/{outputArn}",
	}

	if input == nil {
		input = &RemoveFlowOutputInput{}
	}

	output = &RemoveFlowOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowOutput API operation for AWS MediaConnect.
//
// Removes an output from an existing flow. This request can be made only on
// an output that does not have an entitlement associated with it. If the output
// has an entitlement, you must revoke the entitlement instead. When an entitlement
// is revoked from a flow, the service automatically removes the associated
// output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowOutput for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowOutput
func (c *MediaConnect) RemoveFlowOutput(input *RemoveFlowOutputInput) (*RemoveFlowOutputOutput, error) {
	req, out := c.RemoveFlowOutputRequest(input)
	return out, req.Send()
}

// RemoveFlowOutputWithContext is the same as RemoveFlowOutput with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowOutputWithContext(ctx aws.Context, input *RemoveFlowOutputInput, opts ...request.Option) (*RemoveFlowOutputOutput, error) {
	req, out := c.RemoveFlowOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFlowSource = "RemoveFlowSource"

// RemoveFlowSourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowSource for more information on using the RemoveFlowSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveFlowSourceRequest method.
//    req, resp := client.RemoveFlowSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource
func (c *MediaConnect) RemoveFlowSourceRequest(input *RemoveFlowSourceInput) (req *request.Request, output *RemoveFlowSourceOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/source/{sourceArn}",
	}

	if input == nil {
		input = &RemoveFlowSourceInput{}
	}

	output = &RemoveFlowSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowSource API operation for AWS MediaConnect.
//
// Removes a source from an existing flow. This request can be made only if
// there is more than one source on the flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowSource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowSource
func (c *MediaConnect) RemoveFlowSource(input *RemoveFlowSourceInput) (*RemoveFlowSourceOutput, error) {
	req, out := c.RemoveFlowSourceRequest(input)
	return out, req.Send()
}

// RemoveFlowSourceWithContext is the same as RemoveFlowSource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowSourceWithContext(ctx aws.Context, input *RemoveFlowSourceInput, opts ...request.Option) (*RemoveFlowSourceOutput, error) {
	req, out := c.RemoveFlowSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveFlowVpcInterface = "RemoveFlowVpcInterface"

// RemoveFlowVpcInterfaceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveFlowVpcInterface operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveFlowVpcInterface for more information on using the RemoveFlowVpcInterface
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveFlowVpcInterfaceRequest method.
//    req, resp := client.RemoveFlowVpcInterfaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface
func (c *MediaConnect) RemoveFlowVpcInterfaceRequest(input *RemoveFlowVpcInterfaceInput) (req *request.Request, output *RemoveFlowVpcInterfaceOutput) {
	op := &request.Operation{
		Name:       opRemoveFlowVpcInterface,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/vpcInterfaces/{vpcInterfaceName}",
	}

	if input == nil {
		input = &RemoveFlowVpcInterfaceInput{}
	}

	output = &RemoveFlowVpcInterfaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveFlowVpcInterface API operation for AWS MediaConnect.
//
// Removes a VPC Interface from an existing flow. This request can be made only
// on a VPC interface that does not have a Source or Output associated with
// it. If the VPC interface is referenced by a Source or Output, you must first
// delete or update the Source or Output to no longer reference the VPC interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RemoveFlowVpcInterface for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RemoveFlowVpcInterface
func (c *MediaConnect) RemoveFlowVpcInterface(input *RemoveFlowVpcInterfaceInput) (*RemoveFlowVpcInterfaceOutput, error) {
	req, out := c.RemoveFlowVpcInterfaceRequest(input)
	return out, req.Send()
}

// RemoveFlowVpcInterfaceWithContext is the same as RemoveFlowVpcInterface with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveFlowVpcInterface for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RemoveFlowVpcInterfaceWithContext(ctx aws.Context, input *RemoveFlowVpcInterfaceInput, opts ...request.Option) (*RemoveFlowVpcInterfaceOutput, error) {
	req, out := c.RemoveFlowVpcInterfaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeFlowEntitlement = "RevokeFlowEntitlement"

// RevokeFlowEntitlementRequest generates a "aws/request.Request" representing the
// client's request for the RevokeFlowEntitlement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeFlowEntitlement for more information on using the RevokeFlowEntitlement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeFlowEntitlementRequest method.
//    req, resp := client.RevokeFlowEntitlementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement
func (c *MediaConnect) RevokeFlowEntitlementRequest(input *RevokeFlowEntitlementInput) (req *request.Request, output *RevokeFlowEntitlementOutput) {
	op := &request.Operation{
		Name:       opRevokeFlowEntitlement,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements/{entitlementArn}",
	}

	if input == nil {
		input = &RevokeFlowEntitlementInput{}
	}

	output = &RevokeFlowEntitlementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RevokeFlowEntitlement API operation for AWS MediaConnect.
//
// Revokes an entitlement from a flow. Once an entitlement is revoked, the content
// becomes unavailable to the subscriber and the associated output is removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation RevokeFlowEntitlement for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/RevokeFlowEntitlement
func (c *MediaConnect) RevokeFlowEntitlement(input *RevokeFlowEntitlementInput) (*RevokeFlowEntitlementOutput, error) {
	req, out := c.RevokeFlowEntitlementRequest(input)
	return out, req.Send()
}

// RevokeFlowEntitlementWithContext is the same as RevokeFlowEntitlement with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeFlowEntitlement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) RevokeFlowEntitlementWithContext(ctx aws.Context, input *RevokeFlowEntitlementInput, opts ...request.Option) (*RevokeFlowEntitlementOutput, error) {
	req, out := c.RevokeFlowEntitlementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartFlow = "StartFlow"

// StartFlowRequest generates a "aws/request.Request" representing the
// client's request for the StartFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartFlow for more information on using the StartFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartFlowRequest method.
//    req, resp := client.StartFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow
func (c *MediaConnect) StartFlowRequest(input *StartFlowInput) (req *request.Request, output *StartFlowOutput) {
	op := &request.Operation{
		Name:       opStartFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/start/{flowArn}",
	}

	if input == nil {
		input = &StartFlowInput{}
	}

	output = &StartFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartFlow API operation for AWS MediaConnect.
//
// Starts a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation StartFlow for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StartFlow
func (c *MediaConnect) StartFlow(input *StartFlowInput) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	return out, req.Send()
}

// StartFlowWithContext is the same as StartFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StartFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) StartFlowWithContext(ctx aws.Context, input *StartFlowInput, opts ...request.Option) (*StartFlowOutput, error) {
	req, out := c.StartFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopFlow = "StopFlow"

// StopFlowRequest generates a "aws/request.Request" representing the
// client's request for the StopFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopFlow for more information on using the StopFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopFlowRequest method.
//    req, resp := client.StopFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow
func (c *MediaConnect) StopFlowRequest(input *StopFlowInput) (req *request.Request, output *StopFlowOutput) {
	op := &request.Operation{
		Name:       opStopFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/flows/stop/{flowArn}",
	}

	if input == nil {
		input = &StopFlowInput{}
	}

	output = &StopFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopFlow API operation for AWS MediaConnect.
//
// Stops a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation StopFlow for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/StopFlow
func (c *MediaConnect) StopFlow(input *StopFlowInput) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	return out, req.Send()
}

// StopFlowWithContext is the same as StopFlow with the addition of
// the ability to pass a context and additional request options.
//
// See StopFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) StopFlowWithContext(ctx aws.Context, input *StopFlowInput, opts ...request.Option) (*StopFlowOutput, error) {
	req, out := c.StopFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource
func (c *MediaConnect) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS MediaConnect.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed. When a resource is deleted, the tags associated with
// that resource are deleted as well.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/TagResource
func (c *MediaConnect) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource
func (c *MediaConnect) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS MediaConnect.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UntagResource
func (c *MediaConnect) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlow = "UpdateFlow"

// UpdateFlowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlow for more information on using the UpdateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowRequest method.
//    req, resp := client.UpdateFlowRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow
func (c *MediaConnect) UpdateFlowRequest(input *UpdateFlowInput) (req *request.Request, output *UpdateFlowOutput) {
	op := &request.Operation{
		Name:       opUpdateFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}",
	}

	if input == nil {
		input = &UpdateFlowInput{}
	}

	output = &UpdateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlow API operation for AWS MediaConnect.
//
// Updates flow
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlow for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlow
func (c *MediaConnect) UpdateFlow(input *UpdateFlowInput) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	return out, req.Send()
}

// UpdateFlowWithContext is the same as UpdateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowWithContext(ctx aws.Context, input *UpdateFlowInput, opts ...request.Option) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowEntitlement = "UpdateFlowEntitlement"

// UpdateFlowEntitlementRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowEntitlement operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowEntitlement for more information on using the UpdateFlowEntitlement
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowEntitlementRequest method.
//    req, resp := client.UpdateFlowEntitlementRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement
func (c *MediaConnect) UpdateFlowEntitlementRequest(input *UpdateFlowEntitlementInput) (req *request.Request, output *UpdateFlowEntitlementOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowEntitlement,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/entitlements/{entitlementArn}",
	}

	if input == nil {
		input = &UpdateFlowEntitlementInput{}
	}

	output = &UpdateFlowEntitlementOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowEntitlement API operation for AWS MediaConnect.
//
// You can change an entitlement's description, subscribers, and encryption.
// If you change the subscribers, the service will remove the outputs that are
// are used by the subscribers that are removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowEntitlement for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowEntitlement
func (c *MediaConnect) UpdateFlowEntitlement(input *UpdateFlowEntitlementInput) (*UpdateFlowEntitlementOutput, error) {
	req, out := c.UpdateFlowEntitlementRequest(input)
	return out, req.Send()
}

// UpdateFlowEntitlementWithContext is the same as UpdateFlowEntitlement with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowEntitlement for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowEntitlementWithContext(ctx aws.Context, input *UpdateFlowEntitlementInput, opts ...request.Option) (*UpdateFlowEntitlementOutput, error) {
	req, out := c.UpdateFlowEntitlementRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowOutput = "UpdateFlowOutput"

// UpdateFlowOutputRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowOutput operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowOutput for more information on using the UpdateFlowOutput
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowOutputRequest method.
//    req, resp := client.UpdateFlowOutputRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput
func (c *MediaConnect) UpdateFlowOutputRequest(input *UpdateFlowOutputInput) (req *request.Request, output *UpdateFlowOutputOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowOutput,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/outputs/{outputArn}",
	}

	if input == nil {
		input = &UpdateFlowOutputInput{}
	}

	output = &UpdateFlowOutputOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowOutput API operation for AWS MediaConnect.
//
// Updates an existing flow output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowOutput for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowOutput
func (c *MediaConnect) UpdateFlowOutput(input *UpdateFlowOutputInput) (*UpdateFlowOutputOutput, error) {
	req, out := c.UpdateFlowOutputRequest(input)
	return out, req.Send()
}

// UpdateFlowOutputWithContext is the same as UpdateFlowOutput with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowOutput for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowOutputWithContext(ctx aws.Context, input *UpdateFlowOutputInput, opts ...request.Option) (*UpdateFlowOutputOutput, error) {
	req, out := c.UpdateFlowOutputRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowSource = "UpdateFlowSource"

// UpdateFlowSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowSource for more information on using the UpdateFlowSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowSourceRequest method.
//    req, resp := client.UpdateFlowSourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource
func (c *MediaConnect) UpdateFlowSourceRequest(input *UpdateFlowSourceInput) (req *request.Request, output *UpdateFlowSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/flows/{flowArn}/source/{sourceArn}",
	}

	if input == nil {
		input = &UpdateFlowSourceInput{}
	}

	output = &UpdateFlowSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowSource API operation for AWS MediaConnect.
//
// Updates the source of a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS MediaConnect's
// API operation UpdateFlowSource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * InternalServerErrorException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ForbiddenException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * NotFoundException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * ServiceUnavailableException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
//   * TooManyRequestsException
//   Exception raised by AWS Elemental MediaConnect. See the error message and
//   documentation for the operation for more information on the cause of this
//   exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/UpdateFlowSource
func (c *MediaConnect) UpdateFlowSource(input *UpdateFlowSourceInput) (*UpdateFlowSourceOutput, error) {
	req, out := c.UpdateFlowSourceRequest(input)
	return out, req.Send()
}

// UpdateFlowSourceWithContext is the same as UpdateFlowSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MediaConnect) UpdateFlowSourceWithContext(ctx aws.Context, input *UpdateFlowSourceInput, opts ...request.Option) (*UpdateFlowSourceOutput, error) {
	req, out := c.UpdateFlowSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type AddFlowOutputs420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AddFlowOutputs420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowOutputs420Exception) GoString() string {
	return s.String()
}

func newErrorAddFlowOutputs420Exception(v protocol.ResponseMetadata) error {
	return &AddFlowOutputs420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AddFlowOutputs420Exception) Code() string {
	return "AddFlowOutputs420Exception"
}

// Message returns the exception's message.
func (s *AddFlowOutputs420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AddFlowOutputs420Exception) OrigErr() error {
	return nil
}

func (s *AddFlowOutputs420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AddFlowOutputs420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AddFlowOutputs420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Adds outputs to an existing flow. You can create up to 50 outputs per flow.
type AddFlowOutputsInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of outputs that you want to add.
	//
	// Outputs is a required field
	Outputs []*AddOutputRequest `locationName:"outputs" type:"list" required:"true"`
}

// String returns the string representation
func (s AddFlowOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowOutputsInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.Outputs == nil {
		invalidParams.Add(request.NewErrParamRequired("Outputs"))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowOutputsInput) SetFlowArn(v string) *AddFlowOutputsInput {
	s.FlowArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddFlowOutputsInput) SetOutputs(v []*AddOutputRequest) *AddFlowOutputsInput {
	s.Outputs = v
	return s
}

// The result of a successful AddOutput request. The response includes the details
// of the newly added outputs.
type AddFlowOutputsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these outputs were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added outputs.
	Outputs []*Output `locationName:"outputs" type:"list"`
}

// String returns the string representation
func (s AddFlowOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowOutputsOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowOutputsOutput) SetFlowArn(v string) *AddFlowOutputsOutput {
	s.FlowArn = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *AddFlowOutputsOutput) SetOutputs(v []*Output) *AddFlowOutputsOutput {
	s.Outputs = v
	return s
}

// Adds sources to an existing flow.
type AddFlowSourcesInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of sources that you want to add.
	//
	// Sources is a required field
	Sources []*SetSourceRequest `locationName:"sources" type:"list" required:"true"`
}

// String returns the string representation
func (s AddFlowSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowSourcesInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowSourcesInput) SetFlowArn(v string) *AddFlowSourcesInput {
	s.FlowArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AddFlowSourcesInput) SetSources(v []*SetSourceRequest) *AddFlowSourcesInput {
	s.Sources = v
	return s
}

// The result of a successful AddFlowSources request. The response includes
// the details of the newly added sources.
type AddFlowSourcesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these sources were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added sources.
	Sources []*Source `locationName:"sources" type:"list"`
}

// String returns the string representation
func (s AddFlowSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowSourcesOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowSourcesOutput) SetFlowArn(v string) *AddFlowSourcesOutput {
	s.FlowArn = &v
	return s
}

// SetSources sets the Sources field's value.
func (s *AddFlowSourcesOutput) SetSources(v []*Source) *AddFlowSourcesOutput {
	s.Sources = v
	return s
}

// Adds VPC interfaces to an existing flow.
type AddFlowVpcInterfacesInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// A list of VPC interfaces that you want to add.
	//
	// VpcInterfaces is a required field
	VpcInterfaces []*VpcInterfaceRequest `locationName:"vpcInterfaces" type:"list" required:"true"`
}

// String returns the string representation
func (s AddFlowVpcInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowVpcInterfacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddFlowVpcInterfacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddFlowVpcInterfacesInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.VpcInterfaces == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcInterfaces"))
	}
	if s.VpcInterfaces != nil {
		for i, v := range s.VpcInterfaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VpcInterfaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowVpcInterfacesInput) SetFlowArn(v string) *AddFlowVpcInterfacesInput {
	s.FlowArn = &v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *AddFlowVpcInterfacesInput) SetVpcInterfaces(v []*VpcInterfaceRequest) *AddFlowVpcInterfacesInput {
	s.VpcInterfaces = v
	return s
}

// The result of a successful AddFlowVpcInterfaces request. The response includes
// the details of the newly added VPC interfaces.
type AddFlowVpcInterfacesOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that these VPC interfaces were added to.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The details of the newly added VPC interfaces.
	VpcInterfaces []*VpcInterface `locationName:"vpcInterfaces" type:"list"`
}

// String returns the string representation
func (s AddFlowVpcInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddFlowVpcInterfacesOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *AddFlowVpcInterfacesOutput) SetFlowArn(v string) *AddFlowVpcInterfacesOutput {
	s.FlowArn = &v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *AddFlowVpcInterfacesOutput) SetVpcInterfaces(v []*VpcInterface) *AddFlowVpcInterfacesOutput {
	s.VpcInterfaces = v
	return s
}

// The output that you want to add to this flow.
type AddOutputRequest struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []*string `locationName:"cidrAllowList" type:"list"`

	// A description of the output. This description appears only on the AWS Elemental
	// MediaConnect console and will not be seen by the end user.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The name of the output. This value must be unique within the current flow.
	Name *string `locationName:"name" type:"string"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// The protocol to use for the output.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The remote ID for the Zixi-pull output stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation
func (s AddOutputRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddOutputRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddOutputRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddOutputRequest"}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrAllowList sets the CidrAllowList field's value.
func (s *AddOutputRequest) SetCidrAllowList(v []*string) *AddOutputRequest {
	s.CidrAllowList = v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddOutputRequest) SetDescription(v string) *AddOutputRequest {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *AddOutputRequest) SetDestination(v string) *AddOutputRequest {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *AddOutputRequest) SetEncryption(v *Encryption) *AddOutputRequest {
	s.Encryption = v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *AddOutputRequest) SetMaxLatency(v int64) *AddOutputRequest {
	s.MaxLatency = &v
	return s
}

// SetName sets the Name field's value.
func (s *AddOutputRequest) SetName(v string) *AddOutputRequest {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *AddOutputRequest) SetPort(v int64) *AddOutputRequest {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *AddOutputRequest) SetProtocol(v string) *AddOutputRequest {
	s.Protocol = &v
	return s
}

// SetRemoteId sets the RemoteId field's value.
func (s *AddOutputRequest) SetRemoteId(v string) *AddOutputRequest {
	s.RemoteId = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *AddOutputRequest) SetSmoothingLatency(v int64) *AddOutputRequest {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *AddOutputRequest) SetStreamId(v string) *AddOutputRequest {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *AddOutputRequest) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *AddOutputRequest {
	s.VpcInterfaceAttachment = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type CreateFlow420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CreateFlow420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlow420Exception) GoString() string {
	return s.String()
}

func newErrorCreateFlow420Exception(v protocol.ResponseMetadata) error {
	return &CreateFlow420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CreateFlow420Exception) Code() string {
	return "CreateFlow420Exception"
}

// Message returns the exception's message.
func (s *CreateFlow420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CreateFlow420Exception) OrigErr() error {
	return nil
}

func (s *CreateFlow420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CreateFlow420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CreateFlow420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Creates a new flow. The request must include one source. The request optionally
// can include outputs (up to 50) and one entitlement.
type CreateFlowInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that you want to create the flow in. These options
	// are limited to the Availability Zones within the current AWS Region.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The entitlements that you want to grant on a flow.
	Entitlements []*GrantEntitlementRequest `locationName:"entitlements" type:"list"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs that you want to add to this flow.
	Outputs []*AddOutputRequest `locationName:"outputs" type:"list"`

	// The settings for the source of the flow.
	Source *SetSourceRequest `locationName:"source" type:"structure"`

	// The settings for source failover
	SourceFailoverConfig *FailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`

	Sources []*SetSourceRequest `locationName:"sources" type:"list"`

	// The VPC interfaces you want on the flow.
	VpcInterfaces []*VpcInterfaceRequest `locationName:"vpcInterfaces" type:"list"`
}

// String returns the string representation
func (s CreateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Entitlements != nil {
		for i, v := range s.Entitlements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entitlements", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcInterfaces != nil {
		for i, v := range s.VpcInterfaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VpcInterfaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateFlowInput) SetAvailabilityZone(v string) *CreateFlowInput {
	s.AvailabilityZone = &v
	return s
}

// SetEntitlements sets the Entitlements field's value.
func (s *CreateFlowInput) SetEntitlements(v []*GrantEntitlementRequest) *CreateFlowInput {
	s.Entitlements = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowInput) SetName(v string) *CreateFlowInput {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *CreateFlowInput) SetOutputs(v []*AddOutputRequest) *CreateFlowInput {
	s.Outputs = v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateFlowInput) SetSource(v *SetSourceRequest) *CreateFlowInput {
	s.Source = v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *CreateFlowInput) SetSourceFailoverConfig(v *FailoverConfig) *CreateFlowInput {
	s.SourceFailoverConfig = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateFlowInput) SetSources(v []*SetSourceRequest) *CreateFlowInput {
	s.Sources = v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *CreateFlowInput) SetVpcInterfaces(v []*VpcInterfaceRequest) *CreateFlowInput {
	s.VpcInterfaces = v
	return s
}

// The result of a successful CreateFlow request.
type CreateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`
}

// String returns the string representation
func (s CreateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *CreateFlowOutput) SetFlow(v *Flow) *CreateFlowOutput {
	s.Flow = v
	return s
}

type DeleteFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *DeleteFlowInput) SetFlowArn(v string) *DeleteFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful DeleteFlow request.
type DeleteFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that was deleted.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the DeleteFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s DeleteFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *DeleteFlowOutput) SetFlowArn(v string) *DeleteFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteFlowOutput) SetStatus(v string) *DeleteFlowOutput {
	s.Status = &v
	return s
}

type DescribeFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *DescribeFlowInput) SetFlowArn(v string) *DescribeFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful DescribeFlow request.
type DescribeFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`

	// Messages that provide the state of the flow.
	Messages *Messages `locationName:"messages" type:"structure"`
}

// String returns the string representation
func (s DescribeFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *DescribeFlowOutput) SetFlow(v *Flow) *DescribeFlowOutput {
	s.Flow = v
	return s
}

// SetMessages sets the Messages field's value.
func (s *DescribeFlowOutput) SetMessages(v *Messages) *DescribeFlowOutput {
	s.Messages = v
	return s
}

// Information about the encryption of the flow.
type Encryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	//
	// Algorithm is a required field
	Algorithm *string `locationName:"algorithm" type:"string" required:"true" enum:"Algorithm"`

	// A 128-bit, 16-byte hex value represented by a 32-character string, to be
	// used with the key for encrypting content. This parameter is not valid for
	// static key encryption.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The value of one of the devices that you configured with your digital rights
	// management (DRM) platform key provider. This parameter is required for SPEKE
	// encryption and is not valid for static key encryption.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType *string `locationName:"keyType" type:"string" enum:"KeyType"`

	// The AWS Region that the API Gateway proxy endpoint was created in. This parameter
	// is required for SPEKE encryption and is not valid for static key encryption.
	Region *string `locationName:"region" type:"string"`

	// An identifier for the content. The service sends this value to the key server
	// to identify the current endpoint. The resource ID is also known as the content
	// ID. This parameter is required for SPEKE encryption and is not valid for
	// static key encryption.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The ARN of the secret that you created in AWS Secrets Manager to store the
	// encryption key. This parameter is required for static key encryption and
	// is not valid for SPEKE encryption.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The URL from the API Gateway proxy that you set up to talk to your key server.
	// This parameter is required for SPEKE encryption and is not valid for static
	// key encryption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s Encryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Encryption) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Encryption) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Encryption"}
	if s.Algorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("Algorithm"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *Encryption) SetAlgorithm(v string) *Encryption {
	s.Algorithm = &v
	return s
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *Encryption) SetConstantInitializationVector(v string) *Encryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *Encryption) SetDeviceId(v string) *Encryption {
	s.DeviceId = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *Encryption) SetKeyType(v string) *Encryption {
	s.KeyType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Encryption) SetRegion(v string) *Encryption {
	s.Region = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *Encryption) SetResourceId(v string) *Encryption {
	s.ResourceId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Encryption) SetRoleArn(v string) *Encryption {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *Encryption) SetSecretArn(v string) *Encryption {
	s.SecretArn = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Encryption) SetUrl(v string) *Encryption {
	s.Url = &v
	return s
}

// The settings for a flow entitlement.
type Entitlement struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the entitlement.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// An indication of whether the entitlement is enabled.
	EntitlementStatus *string `locationName:"entitlementStatus" type:"string" enum:"EntitlementStatus"`

	// The name of the entitlement.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flow using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []*string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation
func (s Entitlement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entitlement) GoString() string {
	return s.String()
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *Entitlement) SetDataTransferSubscriberFeePercent(v int64) *Entitlement {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Entitlement) SetDescription(v string) *Entitlement {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Entitlement) SetEncryption(v *Encryption) *Entitlement {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Entitlement) SetEntitlementArn(v string) *Entitlement {
	s.EntitlementArn = &v
	return s
}

// SetEntitlementStatus sets the EntitlementStatus field's value.
func (s *Entitlement) SetEntitlementStatus(v string) *Entitlement {
	s.EntitlementStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *Entitlement) SetName(v string) *Entitlement {
	s.Name = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *Entitlement) SetSubscribers(v []*string) *Entitlement {
	s.Subscribers = v
	return s
}

// The settings for source failover
type FailoverConfig struct {
	_ struct{} `type:"structure"`

	// Search window time to look for dash-7 packets
	RecoveryWindow *int64 `locationName:"recoveryWindow" type:"integer"`

	State *string `locationName:"state" type:"string" enum:"State"`
}

// String returns the string representation
func (s FailoverConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailoverConfig) GoString() string {
	return s.String()
}

// SetRecoveryWindow sets the RecoveryWindow field's value.
func (s *FailoverConfig) SetRecoveryWindow(v int64) *FailoverConfig {
	s.RecoveryWindow = &v
	return s
}

// SetState sets the State field's value.
func (s *FailoverConfig) SetState(v string) *FailoverConfig {
	s.State = &v
	return s
}

// The settings for a flow, including its source, outputs, and entitlements.
type Flow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that you want to create the flow in. These options
	// are limited to the Availability Zones within the current AWS.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The IP address from which video will be sent to output destinations.
	EgressIp *string `locationName:"egressIp" type:"string"`

	// The entitlements in this flow.
	//
	// Entitlements is a required field
	Entitlements []*Entitlement `locationName:"entitlements" type:"list" required:"true"`

	// The Amazon Resource Name (ARN), a unique identifier for any AWS resource,
	// of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The outputs in this flow.
	//
	// Outputs is a required field
	Outputs []*Output `locationName:"outputs" type:"list" required:"true"`

	// The settings for the source of the flow.
	//
	// Source is a required field
	Source *Source `locationName:"source" type:"structure" required:"true"`

	// The settings for source failover
	SourceFailoverConfig *FailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`

	Sources []*Source `locationName:"sources" type:"list"`

	// The current status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`

	// The VPC Interfaces for this flow.
	VpcInterfaces []*VpcInterface `locationName:"vpcInterfaces" type:"list"`
}

// String returns the string representation
func (s Flow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Flow) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Flow) SetAvailabilityZone(v string) *Flow {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Flow) SetDescription(v string) *Flow {
	s.Description = &v
	return s
}

// SetEgressIp sets the EgressIp field's value.
func (s *Flow) SetEgressIp(v string) *Flow {
	s.EgressIp = &v
	return s
}

// SetEntitlements sets the Entitlements field's value.
func (s *Flow) SetEntitlements(v []*Entitlement) *Flow {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *Flow) SetFlowArn(v string) *Flow {
	s.FlowArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Flow) SetName(v string) *Flow {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *Flow) SetOutputs(v []*Output) *Flow {
	s.Outputs = v
	return s
}

// SetSource sets the Source field's value.
func (s *Flow) SetSource(v *Source) *Flow {
	s.Source = v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *Flow) SetSourceFailoverConfig(v *FailoverConfig) *Flow {
	s.SourceFailoverConfig = v
	return s
}

// SetSources sets the Sources field's value.
func (s *Flow) SetSources(v []*Source) *Flow {
	s.Sources = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Flow) SetStatus(v string) *Flow {
	s.Status = &v
	return s
}

// SetVpcInterfaces sets the VpcInterfaces field's value.
func (s *Flow) SetVpcInterfaces(v []*VpcInterface) *Flow {
	s.VpcInterfaces = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The entitlements that you want to grant on a flow.
type GrantEntitlementRequest struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the entitlement. This description appears only on the AWS
	// Elemental MediaConnect console and will not be seen by the subscriber or
	// end user.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output that is associated
	// with this entitlement.
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// An indication of whether the new entitlement should be enabled or disabled
	// as soon as it is created. If you don’t specify the entitlementStatus field
	// in your request, MediaConnect sets it to ENABLED.
	EntitlementStatus *string `locationName:"entitlementStatus" type:"string" enum:"EntitlementStatus"`

	// The name of the entitlement. This value must be unique within the current
	// flow.
	Name *string `locationName:"name" type:"string"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flows using your
	// content as the source.
	//
	// Subscribers is a required field
	Subscribers []*string `locationName:"subscribers" type:"list" required:"true"`
}

// String returns the string representation
func (s GrantEntitlementRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantEntitlementRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantEntitlementRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantEntitlementRequest"}
	if s.Subscribers == nil {
		invalidParams.Add(request.NewErrParamRequired("Subscribers"))
	}
	if s.Encryption != nil {
		if err := s.Encryption.Validate(); err != nil {
			invalidParams.AddNested("Encryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *GrantEntitlementRequest) SetDataTransferSubscriberFeePercent(v int64) *GrantEntitlementRequest {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GrantEntitlementRequest) SetDescription(v string) *GrantEntitlementRequest {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *GrantEntitlementRequest) SetEncryption(v *Encryption) *GrantEntitlementRequest {
	s.Encryption = v
	return s
}

// SetEntitlementStatus sets the EntitlementStatus field's value.
func (s *GrantEntitlementRequest) SetEntitlementStatus(v string) *GrantEntitlementRequest {
	s.EntitlementStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *GrantEntitlementRequest) SetName(v string) *GrantEntitlementRequest {
	s.Name = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *GrantEntitlementRequest) SetSubscribers(v []*string) *GrantEntitlementRequest {
	s.Subscribers = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type GrantFlowEntitlements420Exception struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s GrantFlowEntitlements420Exception) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantFlowEntitlements420Exception) GoString() string {
	return s.String()
}

func newErrorGrantFlowEntitlements420Exception(v protocol.ResponseMetadata) error {
	return &GrantFlowEntitlements420Exception{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *GrantFlowEntitlements420Exception) Code() string {
	return "GrantFlowEntitlements420Exception"
}

// Message returns the exception's message.
func (s *GrantFlowEntitlements420Exception) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *GrantFlowEntitlements420Exception) OrigErr() error {
	return nil
}

func (s *GrantFlowEntitlements420Exception) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *GrantFlowEntitlements420Exception) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *GrantFlowEntitlements420Exception) RequestID() string {
	return s.RespMetadata.RequestID
}

// Grants an entitlement on a flow.
type GrantFlowEntitlementsInput struct {
	_ struct{} `type:"structure"`

	// The list of entitlements that you want to grant.
	//
	// Entitlements is a required field
	Entitlements []*GrantEntitlementRequest `locationName:"entitlements" type:"list" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GrantFlowEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantFlowEntitlementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantFlowEntitlementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantFlowEntitlementsInput"}
	if s.Entitlements == nil {
		invalidParams.Add(request.NewErrParamRequired("Entitlements"))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.Entitlements != nil {
		for i, v := range s.Entitlements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entitlements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntitlements sets the Entitlements field's value.
func (s *GrantFlowEntitlementsInput) SetEntitlements(v []*GrantEntitlementRequest) *GrantFlowEntitlementsInput {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *GrantFlowEntitlementsInput) SetFlowArn(v string) *GrantFlowEntitlementsInput {
	s.FlowArn = &v
	return s
}

// The entitlements that were just granted.
type GrantFlowEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// The entitlements that were just granted.
	Entitlements []*Entitlement `locationName:"entitlements" type:"list"`

	// The ARN of the flow that these entitlements were granted to.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s GrantFlowEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantFlowEntitlementsOutput) GoString() string {
	return s.String()
}

// SetEntitlements sets the Entitlements field's value.
func (s *GrantFlowEntitlementsOutput) SetEntitlements(v []*Entitlement) *GrantFlowEntitlementsOutput {
	s.Entitlements = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *GrantFlowEntitlementsOutput) SetFlowArn(v string) *GrantFlowEntitlementsOutput {
	s.FlowArn = &v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListEntitlementsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitlementsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitlementsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitlementsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitlementsInput) SetMaxResults(v int64) *ListEntitlementsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitlementsInput) SetNextToken(v string) *ListEntitlementsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListEntitlements request. The response includes
// the ARN of each entitlement, the name of the associated flow, and the NextToken
// to use in a subsequent ListEntitlements request.
type ListEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// A list of entitlements that have been granted to you from other AWS accounts.
	Entitlements []*ListedEntitlement `locationName:"entitlements" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListEntitlements request with MaxResults set at 5.
	// The service returns the first batch of results (up to 5) and a NextToken
	// value. To see the next batch of results, you can submit the ListEntitlements
	// request a second time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitlementsOutput) GoString() string {
	return s.String()
}

// SetEntitlements sets the Entitlements field's value.
func (s *ListEntitlementsOutput) SetEntitlements(v []*ListedEntitlement) *ListEntitlementsOutput {
	s.Entitlements = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitlementsOutput) SetNextToken(v string) *ListEntitlementsOutput {
	s.NextToken = &v
	return s
}

type ListFlowsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowsInput) SetMaxResults(v int64) *ListFlowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsInput) SetNextToken(v string) *ListFlowsInput {
	s.NextToken = &v
	return s
}

// The result of a successful ListFlows request. The response includes flow
// summaries and the NextToken to use in a subsequent ListFlows request.
type ListFlowsOutput struct {
	_ struct{} `type:"structure"`

	// A list of flow summaries.
	Flows []*ListedFlow `locationName:"flows" type:"list"`

	// The token that identifies which batch of results that you want to see. For
	// example, you submit a ListFlows request with MaxResults set at 5. The service
	// returns the first batch of results (up to 5) and a NextToken value. To see
	// the next batch of results, you can submit the ListFlows request a second
	// time and specify the NextToken value.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowsOutput) GoString() string {
	return s.String()
}

// SetFlows sets the Flows field's value.
func (s *ListFlowsOutput) SetFlows(v []*ListedFlow) *ListFlowsOutput {
	s.Flows = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsOutput) SetNextToken(v string) *ListFlowsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

// The tags for the resource.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map from tag keys to values. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// An entitlement that has been granted to you from other AWS accounts.
type ListedEntitlement struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// The ARN of the entitlement.
	//
	// EntitlementArn is a required field
	EntitlementArn *string `locationName:"entitlementArn" type:"string" required:"true"`

	// The name of the entitlement.
	//
	// EntitlementName is a required field
	EntitlementName *string `locationName:"entitlementName" type:"string" required:"true"`
}

// String returns the string representation
func (s ListedEntitlement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedEntitlement) GoString() string {
	return s.String()
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *ListedEntitlement) SetDataTransferSubscriberFeePercent(v int64) *ListedEntitlement {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *ListedEntitlement) SetEntitlementArn(v string) *ListedEntitlement {
	s.EntitlementArn = &v
	return s
}

// SetEntitlementName sets the EntitlementName field's value.
func (s *ListedEntitlement) SetEntitlementName(v string) *ListedEntitlement {
	s.EntitlementName = &v
	return s
}

// Provides a summary of a flow, including its ARN, Availability Zone, and source
// type.
type ListedFlow struct {
	_ struct{} `type:"structure"`

	// The Availability Zone that the flow was created in.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// A description of the flow.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The ARN of the flow.
	//
	// FlowArn is a required field
	FlowArn *string `locationName:"flowArn" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of source. This value is either owned (originated somewhere other
	// than an AWS Elemental MediaConnect flow owned by another AWS account) or
	// entitled (originated at an AWS Elemental MediaConnect flow owned by another
	// AWS account).
	//
	// SourceType is a required field
	SourceType *string `locationName:"sourceType" type:"string" required:"true" enum:"SourceType"`

	// The current status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation
func (s ListedFlow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListedFlow) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ListedFlow) SetAvailabilityZone(v string) *ListedFlow {
	s.AvailabilityZone = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListedFlow) SetDescription(v string) *ListedFlow {
	s.Description = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *ListedFlow) SetFlowArn(v string) *ListedFlow {
	s.FlowArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListedFlow) SetName(v string) *ListedFlow {
	s.Name = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ListedFlow) SetSourceType(v string) *ListedFlow {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListedFlow) SetStatus(v string) *ListedFlow {
	s.Status = &v
	return s
}

// Messages that provide the state of the flow.
type Messages struct {
	_ struct{} `type:"structure"`

	// A list of errors that might have been generated from processes on this flow.
	//
	// Errors is a required field
	Errors []*string `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation
func (s Messages) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Messages) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *Messages) SetErrors(v []*string) *Messages {
	s.Errors = v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The settings for an output.
type Output struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// A description of the output.
	Description *string `locationName:"description" type:"string"`

	// The address where you want to send the output.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *Encryption `locationName:"encryption" type:"structure"`

	// The ARN of the entitlement on the originator''s flow. This value is relevant
	// only on entitled flows.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant
	// only for outputs that were added by creating a MediaLive input.
	MediaLiveInputArn *string `locationName:"mediaLiveInputArn" type:"string"`

	// The name of the output. This value must be unique within the current flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the output.
	//
	// OutputArn is a required field
	OutputArn *string `locationName:"outputArn" type:"string" required:"true"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// Attributes related to the transport stream that are used in the output.
	Transport *Transport `locationName:"transport" type:"structure"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *Output) SetDataTransferSubscriberFeePercent(v int64) *Output {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Output) SetDescription(v string) *Output {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *Output) SetDestination(v string) *Output {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *Output) SetEncryption(v *Encryption) *Output {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Output) SetEntitlementArn(v string) *Output {
	s.EntitlementArn = &v
	return s
}

// SetMediaLiveInputArn sets the MediaLiveInputArn field's value.
func (s *Output) SetMediaLiveInputArn(v string) *Output {
	s.MediaLiveInputArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Output) SetName(v string) *Output {
	s.Name = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *Output) SetOutputArn(v string) *Output {
	s.OutputArn = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Output) SetPort(v int64) *Output {
	s.Port = &v
	return s
}

// SetTransport sets the Transport field's value.
func (s *Output) SetTransport(v *Transport) *Output {
	s.Transport = v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *Output) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *Output {
	s.VpcInterfaceAttachment = v
	return s
}

type RemoveFlowOutputInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// OutputArn is a required field
	OutputArn *string `location:"uri" locationName:"outputArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveFlowOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowOutputInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.OutputArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArn"))
	}
	if s.OutputArn != nil && len(*s.OutputArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowOutputInput) SetFlowArn(v string) *RemoveFlowOutputInput {
	s.FlowArn = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *RemoveFlowOutputInput) SetOutputArn(v string) *RemoveFlowOutputInput {
	s.OutputArn = &v
	return s
}

// The result of a successful RemoveFlowOutput request including the flow ARN
// and the output ARN that was removed.
type RemoveFlowOutputOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the output you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The ARN of the output that was removed.
	OutputArn *string `locationName:"outputArn" type:"string"`
}

// String returns the string representation
func (s RemoveFlowOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowOutputOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowOutputOutput) SetFlowArn(v string) *RemoveFlowOutputOutput {
	s.FlowArn = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *RemoveFlowOutputOutput) SetOutputArn(v string) *RemoveFlowOutputOutput {
	s.OutputArn = &v
	return s
}

type RemoveFlowSourceInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// SourceArn is a required field
	SourceArn *string `location:"uri" locationName:"sourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveFlowSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowSourceInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowSourceInput) SetFlowArn(v string) *RemoveFlowSourceInput {
	s.FlowArn = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *RemoveFlowSourceInput) SetSourceArn(v string) *RemoveFlowSourceInput {
	s.SourceArn = &v
	return s
}

// The result of a successful RemoveFlowSource request including the flow ARN
// and the source ARN that was removed.
type RemoveFlowSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the source you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The ARN of the source that was removed.
	SourceArn *string `locationName:"sourceArn" type:"string"`
}

// String returns the string representation
func (s RemoveFlowSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowSourceOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowSourceOutput) SetFlowArn(v string) *RemoveFlowSourceOutput {
	s.FlowArn = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *RemoveFlowSourceOutput) SetSourceArn(v string) *RemoveFlowSourceOutput {
	s.SourceArn = &v
	return s
}

type RemoveFlowVpcInterfaceInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// VpcInterfaceName is a required field
	VpcInterfaceName *string `location:"uri" locationName:"vpcInterfaceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveFlowVpcInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowVpcInterfaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveFlowVpcInterfaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveFlowVpcInterfaceInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.VpcInterfaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcInterfaceName"))
	}
	if s.VpcInterfaceName != nil && len(*s.VpcInterfaceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcInterfaceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowVpcInterfaceInput) SetFlowArn(v string) *RemoveFlowVpcInterfaceInput {
	s.FlowArn = &v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *RemoveFlowVpcInterfaceInput) SetVpcInterfaceName(v string) *RemoveFlowVpcInterfaceInput {
	s.VpcInterfaceName = &v
	return s
}

// The result of a successful RemoveFlowVpcInterface request including the flow
// ARN and the VPC interface name that was removed.
type RemoveFlowVpcInterfaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the VPC interface you removed.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// IDs of network interfaces associated with the removed VPC interface that
	// Media Connect was unable to remove.
	NonDeletedNetworkInterfaceIds []*string `locationName:"nonDeletedNetworkInterfaceIds" type:"list"`

	// The name of the VPC interface that was removed.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`
}

// String returns the string representation
func (s RemoveFlowVpcInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveFlowVpcInterfaceOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *RemoveFlowVpcInterfaceOutput) SetFlowArn(v string) *RemoveFlowVpcInterfaceOutput {
	s.FlowArn = &v
	return s
}

// SetNonDeletedNetworkInterfaceIds sets the NonDeletedNetworkInterfaceIds field's value.
func (s *RemoveFlowVpcInterfaceOutput) SetNonDeletedNetworkInterfaceIds(v []*string) *RemoveFlowVpcInterfaceOutput {
	s.NonDeletedNetworkInterfaceIds = v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *RemoveFlowVpcInterfaceOutput) SetVpcInterfaceName(v string) *RemoveFlowVpcInterfaceOutput {
	s.VpcInterfaceName = &v
	return s
}

type RevokeFlowEntitlementInput struct {
	_ struct{} `type:"structure"`

	// EntitlementArn is a required field
	EntitlementArn *string `location:"uri" locationName:"entitlementArn" type:"string" required:"true"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeFlowEntitlementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeFlowEntitlementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeFlowEntitlementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeFlowEntitlementInput"}
	if s.EntitlementArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntitlementArn"))
	}
	if s.EntitlementArn != nil && len(*s.EntitlementArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntitlementArn", 1))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *RevokeFlowEntitlementInput) SetEntitlementArn(v string) *RevokeFlowEntitlementInput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *RevokeFlowEntitlementInput) SetFlowArn(v string) *RevokeFlowEntitlementInput {
	s.FlowArn = &v
	return s
}

// The result of a successful RevokeFlowEntitlement request. The response includes
// the ARN of the flow that was updated and the ARN of the entitlement that
// was revoked.
type RevokeFlowEntitlementOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the entitlement that was revoked.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The ARN of the flow that the entitlement was revoked from.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s RevokeFlowEntitlementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeFlowEntitlementOutput) GoString() string {
	return s.String()
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *RevokeFlowEntitlementOutput) SetEntitlementArn(v string) *RevokeFlowEntitlementOutput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *RevokeFlowEntitlementOutput) SetFlowArn(v string) *RevokeFlowEntitlementOutput {
	s.FlowArn = &v
	return s
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The settings for the source of the flow.
type SetSourceRequest struct {
	_ struct{} `type:"structure"`

	// The type of encryption that is used on the content ingested from this source.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to this flow. The
	// entitlement is set by the flow originator, and the ARN is generated as part
	// of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based
	// and Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The name of the source.
	Name *string `locationName:"name" type:"string"`

	// The protocol that is used by the source.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface to use for this source.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s SetSourceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSourceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetSourceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetSourceRequest"}
	if s.Decryption != nil {
		if err := s.Decryption.Validate(); err != nil {
			invalidParams.AddNested("Decryption", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecryption sets the Decryption field's value.
func (s *SetSourceRequest) SetDecryption(v *Encryption) *SetSourceRequest {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *SetSourceRequest) SetDescription(v string) *SetSourceRequest {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *SetSourceRequest) SetEntitlementArn(v string) *SetSourceRequest {
	s.EntitlementArn = &v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *SetSourceRequest) SetIngestPort(v int64) *SetSourceRequest {
	s.IngestPort = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *SetSourceRequest) SetMaxBitrate(v int64) *SetSourceRequest {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *SetSourceRequest) SetMaxLatency(v int64) *SetSourceRequest {
	s.MaxLatency = &v
	return s
}

// SetName sets the Name field's value.
func (s *SetSourceRequest) SetName(v string) *SetSourceRequest {
	s.Name = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *SetSourceRequest) SetProtocol(v string) *SetSourceRequest {
	s.Protocol = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *SetSourceRequest) SetStreamId(v string) *SetSourceRequest {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *SetSourceRequest) SetVpcInterfaceName(v string) *SetSourceRequest {
	s.VpcInterfaceName = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *SetSourceRequest) SetWhitelistCidr(v string) *SetSourceRequest {
	s.WhitelistCidr = &v
	return s
}

// The settings for the source of the flow.
type Source struct {
	_ struct{} `type:"structure"`

	// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
	DataTransferSubscriberFeePercent *int64 `locationName:"dataTransferSubscriberFeePercent" type:"integer"`

	// The type of encryption that is used on the content ingested from this source.
	Decryption *Encryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to content that comes
	// from another AWS account. The entitlement is set by the content originator
	// and the ARN is generated as part of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// The IP address that the flow will be listening on for incoming content.
	IngestIp *string `locationName:"ingestIp" type:"string"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The name of the source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the source.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" type:"string" required:"true"`

	// Attributes related to the transport stream that are used in the source.
	Transport *Transport `locationName:"transport" type:"structure"`

	// The name of the VPC Interface this Source is configured with.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// SetDataTransferSubscriberFeePercent sets the DataTransferSubscriberFeePercent field's value.
func (s *Source) SetDataTransferSubscriberFeePercent(v int64) *Source {
	s.DataTransferSubscriberFeePercent = &v
	return s
}

// SetDecryption sets the Decryption field's value.
func (s *Source) SetDecryption(v *Encryption) *Source {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Source) SetDescription(v string) *Source {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *Source) SetEntitlementArn(v string) *Source {
	s.EntitlementArn = &v
	return s
}

// SetIngestIp sets the IngestIp field's value.
func (s *Source) SetIngestIp(v string) *Source {
	s.IngestIp = &v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *Source) SetIngestPort(v int64) *Source {
	s.IngestPort = &v
	return s
}

// SetName sets the Name field's value.
func (s *Source) SetName(v string) *Source {
	s.Name = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *Source) SetSourceArn(v string) *Source {
	s.SourceArn = &v
	return s
}

// SetTransport sets the Transport field's value.
func (s *Source) SetTransport(v *Transport) *Source {
	s.Transport = v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *Source) SetVpcInterfaceName(v string) *Source {
	s.VpcInterfaceName = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *Source) SetWhitelistCidr(v string) *Source {
	s.WhitelistCidr = &v
	return s
}

type StartFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s StartFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *StartFlowInput) SetFlowArn(v string) *StartFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful StartFlow request.
type StartFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you started.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the StartFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s StartFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *StartFlowOutput) SetFlowArn(v string) *StartFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartFlowOutput) SetStatus(v string) *StartFlowOutput {
	s.Status = &v
	return s
}

type StopFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`
}

// String returns the string representation
func (s StopFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *StopFlowInput) SetFlowArn(v string) *StopFlowInput {
	s.FlowArn = &v
	return s
}

// The result of a successful StopFlow request.
type StopFlowOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you stopped.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The status of the flow when the StopFlow process begins.
	Status *string `locationName:"status" type:"string" enum:"Status"`
}

// String returns the string representation
func (s StopFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopFlowOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *StopFlowOutput) SetFlowArn(v string) *StopFlowOutput {
	s.FlowArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StopFlowOutput) SetStatus(v string) *StopFlowOutput {
	s.Status = &v
	return s
}

// The tags to add to the resource. Tag keys can have a maximum character length
// of 128 characters, and tag values can have a maximum length of 256 characters.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A map from tag keys to values. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Exception raised by AWS Elemental MediaConnect. See the error message and
// documentation for the operation for more information on the cause of this
// exception.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Attributes related to the transport stream that are used in a source or output.
type Transport struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []*string `locationName:"cidrAllowList" type:"list"`

	// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based
	// and Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The protocol that is used by the source or output.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The remote ID for the Zixi-pull stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`
}

// String returns the string representation
func (s Transport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transport) GoString() string {
	return s.String()
}

// SetCidrAllowList sets the CidrAllowList field's value.
func (s *Transport) SetCidrAllowList(v []*string) *Transport {
	s.CidrAllowList = v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *Transport) SetMaxBitrate(v int64) *Transport {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *Transport) SetMaxLatency(v int64) *Transport {
	s.MaxLatency = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Transport) SetProtocol(v string) *Transport {
	s.Protocol = &v
	return s
}

// SetRemoteId sets the RemoteId field's value.
func (s *Transport) SetRemoteId(v string) *Transport {
	s.RemoteId = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *Transport) SetSmoothingLatency(v int64) *Transport {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *Transport) SetStreamId(v string) *Transport {
	s.StreamId = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Information about the encryption of the flow.
type UpdateEncryption struct {
	_ struct{} `type:"structure"`

	// The type of algorithm that is used for the encryption (such as aes128, aes192,
	// or aes256).
	Algorithm *string `locationName:"algorithm" type:"string" enum:"Algorithm"`

	// A 128-bit, 16-byte hex value represented by a 32-character string, to be
	// used with the key for encrypting content. This parameter is not valid for
	// static key encryption.
	ConstantInitializationVector *string `locationName:"constantInitializationVector" type:"string"`

	// The value of one of the devices that you configured with your digital rights
	// management (DRM) platform key provider. This parameter is required for SPEKE
	// encryption and is not valid for static key encryption.
	DeviceId *string `locationName:"deviceId" type:"string"`

	// The type of key that is used for the encryption. If no keyType is provided,
	// the service will use the default setting (static-key).
	KeyType *string `locationName:"keyType" type:"string" enum:"KeyType"`

	// The AWS Region that the API Gateway proxy endpoint was created in. This parameter
	// is required for SPEKE encryption and is not valid for static key encryption.
	Region *string `locationName:"region" type:"string"`

	// An identifier for the content. The service sends this value to the key server
	// to identify the current endpoint. The resource ID is also known as the content
	// ID. This parameter is required for SPEKE encryption and is not valid for
	// static key encryption.
	ResourceId *string `locationName:"resourceId" type:"string"`

	// The ARN of the role that you created during setup (when you set up AWS Elemental
	// MediaConnect as a trusted entity).
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The ARN of the secret that you created in AWS Secrets Manager to store the
	// encryption key. This parameter is required for static key encryption and
	// is not valid for SPEKE encryption.
	SecretArn *string `locationName:"secretArn" type:"string"`

	// The URL from the API Gateway proxy that you set up to talk to your key server.
	// This parameter is required for SPEKE encryption and is not valid for static
	// key encryption.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation
func (s UpdateEncryption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEncryption) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *UpdateEncryption) SetAlgorithm(v string) *UpdateEncryption {
	s.Algorithm = &v
	return s
}

// SetConstantInitializationVector sets the ConstantInitializationVector field's value.
func (s *UpdateEncryption) SetConstantInitializationVector(v string) *UpdateEncryption {
	s.ConstantInitializationVector = &v
	return s
}

// SetDeviceId sets the DeviceId field's value.
func (s *UpdateEncryption) SetDeviceId(v string) *UpdateEncryption {
	s.DeviceId = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *UpdateEncryption) SetKeyType(v string) *UpdateEncryption {
	s.KeyType = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *UpdateEncryption) SetRegion(v string) *UpdateEncryption {
	s.Region = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateEncryption) SetResourceId(v string) *UpdateEncryption {
	s.ResourceId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateEncryption) SetRoleArn(v string) *UpdateEncryption {
	s.RoleArn = &v
	return s
}

// SetSecretArn sets the SecretArn field's value.
func (s *UpdateEncryption) SetSecretArn(v string) *UpdateEncryption {
	s.SecretArn = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *UpdateEncryption) SetUrl(v string) *UpdateEncryption {
	s.Url = &v
	return s
}

// The settings for source failover
type UpdateFailoverConfig struct {
	_ struct{} `type:"structure"`

	// Recovery window time to look for dash-7 packets
	RecoveryWindow *int64 `locationName:"recoveryWindow" type:"integer"`

	State *string `locationName:"state" type:"string" enum:"State"`
}

// String returns the string representation
func (s UpdateFailoverConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFailoverConfig) GoString() string {
	return s.String()
}

// SetRecoveryWindow sets the RecoveryWindow field's value.
func (s *UpdateFailoverConfig) SetRecoveryWindow(v int64) *UpdateFailoverConfig {
	s.RecoveryWindow = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateFailoverConfig) SetState(v string) *UpdateFailoverConfig {
	s.State = &v
	return s
}

// The updates that you want to make to a specific entitlement.
type UpdateFlowEntitlementInput struct {
	_ struct{} `type:"structure"`

	// A description of the entitlement. This description appears only on the AWS
	// Elemental MediaConnect console and will not be seen by the subscriber or
	// end user.
	Description *string `locationName:"description" type:"string"`

	// The type of encryption that will be used on the output associated with this
	// entitlement.
	Encryption *UpdateEncryption `locationName:"encryption" type:"structure"`

	// EntitlementArn is a required field
	EntitlementArn *string `location:"uri" locationName:"entitlementArn" type:"string" required:"true"`

	// An indication of whether you want to enable the entitlement to allow access,
	// or disable it to stop streaming content to the subscriber’s flow temporarily.
	// If you don’t specify the entitlementStatus field in your request, MediaConnect
	// leaves the value unchanged.
	EntitlementStatus *string `locationName:"entitlementStatus" type:"string" enum:"EntitlementStatus"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The AWS account IDs that you want to share your content with. The receiving
	// accounts (subscribers) will be allowed to create their own flow using your
	// content as the source.
	Subscribers []*string `locationName:"subscribers" type:"list"`
}

// String returns the string representation
func (s UpdateFlowEntitlementInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowEntitlementInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowEntitlementInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowEntitlementInput"}
	if s.EntitlementArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntitlementArn"))
	}
	if s.EntitlementArn != nil && len(*s.EntitlementArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EntitlementArn", 1))
	}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowEntitlementInput) SetDescription(v string) *UpdateFlowEntitlementInput {
	s.Description = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *UpdateFlowEntitlementInput) SetEncryption(v *UpdateEncryption) *UpdateFlowEntitlementInput {
	s.Encryption = v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *UpdateFlowEntitlementInput) SetEntitlementArn(v string) *UpdateFlowEntitlementInput {
	s.EntitlementArn = &v
	return s
}

// SetEntitlementStatus sets the EntitlementStatus field's value.
func (s *UpdateFlowEntitlementInput) SetEntitlementStatus(v string) *UpdateFlowEntitlementInput {
	s.EntitlementStatus = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowEntitlementInput) SetFlowArn(v string) *UpdateFlowEntitlementInput {
	s.FlowArn = &v
	return s
}

// SetSubscribers sets the Subscribers field's value.
func (s *UpdateFlowEntitlementInput) SetSubscribers(v []*string) *UpdateFlowEntitlementInput {
	s.Subscribers = v
	return s
}

// The result of a successful UpdateFlowEntitlement request. The response includes
// the ARN of the flow that was updated and the updated entitlement configuration.
type UpdateFlowEntitlementOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow entitlement.
	Entitlement *Entitlement `locationName:"entitlement" type:"structure"`

	// The ARN of the flow that this entitlement was granted on.
	FlowArn *string `locationName:"flowArn" type:"string"`
}

// String returns the string representation
func (s UpdateFlowEntitlementOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowEntitlementOutput) GoString() string {
	return s.String()
}

// SetEntitlement sets the Entitlement field's value.
func (s *UpdateFlowEntitlementOutput) SetEntitlement(v *Entitlement) *UpdateFlowEntitlementOutput {
	s.Entitlement = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowEntitlementOutput) SetFlowArn(v string) *UpdateFlowEntitlementOutput {
	s.FlowArn = &v
	return s
}

// Updates an existing flow.
type UpdateFlowInput struct {
	_ struct{} `type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The settings for source failover
	SourceFailoverConfig *UpdateFailoverConfig `locationName:"sourceFailoverConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowInput) SetFlowArn(v string) *UpdateFlowInput {
	s.FlowArn = &v
	return s
}

// SetSourceFailoverConfig sets the SourceFailoverConfig field's value.
func (s *UpdateFlowInput) SetSourceFailoverConfig(v *UpdateFailoverConfig) *UpdateFlowInput {
	s.SourceFailoverConfig = v
	return s
}

// Updates an existing flow.
type UpdateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The settings for a flow, including its source, outputs, and entitlements.
	Flow *Flow `locationName:"flow" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowOutput) GoString() string {
	return s.String()
}

// SetFlow sets the Flow field's value.
func (s *UpdateFlowOutput) SetFlow(v *Flow) *UpdateFlowOutput {
	s.Flow = v
	return s
}

// The updates that you want to make to an existing output of an existing flow.
type UpdateFlowOutputInput struct {
	_ struct{} `type:"structure"`

	// The range of IP addresses that should be allowed to initiate output requests
	// to this flow. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	CidrAllowList []*string `locationName:"cidrAllowList" type:"list"`

	// A description of the output. This description appears only on the AWS Elemental
	// MediaConnect console and will not be seen by the end user.
	Description *string `locationName:"description" type:"string"`

	// The IP address where you want to send the output.
	Destination *string `locationName:"destination" type:"string"`

	// The type of key used for the encryption. If no keyType is provided, the service
	// will use the default setting (static-key).
	Encryption *UpdateEncryption `locationName:"encryption" type:"structure"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The maximum latency in milliseconds for Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// OutputArn is a required field
	OutputArn *string `location:"uri" locationName:"outputArn" type:"string" required:"true"`

	// The port to use when content is distributed to this output.
	Port *int64 `locationName:"port" type:"integer"`

	// The protocol to use for the output.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The remote ID for the Zixi-pull stream.
	RemoteId *string `locationName:"remoteId" type:"string"`

	// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
	SmoothingLatency *int64 `locationName:"smoothingLatency" type:"integer"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC interface attachment to use for this output.
	VpcInterfaceAttachment *VpcInterfaceAttachment `locationName:"vpcInterfaceAttachment" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowOutputInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowOutputInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowOutputInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.OutputArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputArn"))
	}
	if s.OutputArn != nil && len(*s.OutputArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrAllowList sets the CidrAllowList field's value.
func (s *UpdateFlowOutputInput) SetCidrAllowList(v []*string) *UpdateFlowOutputInput {
	s.CidrAllowList = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowOutputInput) SetDescription(v string) *UpdateFlowOutputInput {
	s.Description = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *UpdateFlowOutputInput) SetDestination(v string) *UpdateFlowOutputInput {
	s.Destination = &v
	return s
}

// SetEncryption sets the Encryption field's value.
func (s *UpdateFlowOutputInput) SetEncryption(v *UpdateEncryption) *UpdateFlowOutputInput {
	s.Encryption = v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowOutputInput) SetFlowArn(v string) *UpdateFlowOutputInput {
	s.FlowArn = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *UpdateFlowOutputInput) SetMaxLatency(v int64) *UpdateFlowOutputInput {
	s.MaxLatency = &v
	return s
}

// SetOutputArn sets the OutputArn field's value.
func (s *UpdateFlowOutputInput) SetOutputArn(v string) *UpdateFlowOutputInput {
	s.OutputArn = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateFlowOutputInput) SetPort(v int64) *UpdateFlowOutputInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateFlowOutputInput) SetProtocol(v string) *UpdateFlowOutputInput {
	s.Protocol = &v
	return s
}

// SetRemoteId sets the RemoteId field's value.
func (s *UpdateFlowOutputInput) SetRemoteId(v string) *UpdateFlowOutputInput {
	s.RemoteId = &v
	return s
}

// SetSmoothingLatency sets the SmoothingLatency field's value.
func (s *UpdateFlowOutputInput) SetSmoothingLatency(v int64) *UpdateFlowOutputInput {
	s.SmoothingLatency = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *UpdateFlowOutputInput) SetStreamId(v string) *UpdateFlowOutputInput {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceAttachment sets the VpcInterfaceAttachment field's value.
func (s *UpdateFlowOutputInput) SetVpcInterfaceAttachment(v *VpcInterfaceAttachment) *UpdateFlowOutputInput {
	s.VpcInterfaceAttachment = v
	return s
}

// The result of a successful UpdateFlowOutput request including the flow ARN
// and the updated output.
type UpdateFlowOutputOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that is associated with the updated output.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The settings for an output.
	Output *Output `locationName:"output" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowOutputOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowOutputOutput) SetFlowArn(v string) *UpdateFlowOutputOutput {
	s.FlowArn = &v
	return s
}

// SetOutput sets the Output field's value.
func (s *UpdateFlowOutputOutput) SetOutput(v *Output) *UpdateFlowOutputOutput {
	s.Output = v
	return s
}

// The settings for the updated source of the flow.
type UpdateFlowSourceInput struct {
	_ struct{} `type:"structure"`

	// The type of encryption used on the content ingested from this source.
	Decryption *UpdateEncryption `locationName:"decryption" type:"structure"`

	// A description for the source. This value is not used or seen outside of the
	// current AWS Elemental MediaConnect account.
	Description *string `locationName:"description" type:"string"`

	// The ARN of the entitlement that allows you to subscribe to this flow. The
	// entitlement is set by the flow originator, and the ARN is generated as part
	// of the originator's flow.
	EntitlementArn *string `locationName:"entitlementArn" type:"string"`

	// FlowArn is a required field
	FlowArn *string `location:"uri" locationName:"flowArn" type:"string" required:"true"`

	// The port that the flow will be listening on for incoming content.
	IngestPort *int64 `locationName:"ingestPort" type:"integer"`

	// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
	MaxBitrate *int64 `locationName:"maxBitrate" type:"integer"`

	// The maximum latency in milliseconds. This parameter applies only to RIST-based
	// and Zixi-based streams.
	MaxLatency *int64 `locationName:"maxLatency" type:"integer"`

	// The protocol that is used by the source.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// SourceArn is a required field
	SourceArn *string `location:"uri" locationName:"sourceArn" type:"string" required:"true"`

	// The stream ID that you want to use for this transport. This parameter applies
	// only to Zixi-based streams.
	StreamId *string `locationName:"streamId" type:"string"`

	// The name of the VPC Interface to configure this Source with.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`

	// The range of IP addresses that should be allowed to contribute content to
	// your source. These IP addresses should be in the form of a Classless Inter-Domain
	// Routing (CIDR) block; for example, 10.0.0.0/16.
	WhitelistCidr *string `locationName:"whitelistCidr" type:"string"`
}

// String returns the string representation
func (s UpdateFlowSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowSourceInput"}
	if s.FlowArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowArn"))
	}
	if s.FlowArn != nil && len(*s.FlowArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowArn", 1))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecryption sets the Decryption field's value.
func (s *UpdateFlowSourceInput) SetDecryption(v *UpdateEncryption) *UpdateFlowSourceInput {
	s.Decryption = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowSourceInput) SetDescription(v string) *UpdateFlowSourceInput {
	s.Description = &v
	return s
}

// SetEntitlementArn sets the EntitlementArn field's value.
func (s *UpdateFlowSourceInput) SetEntitlementArn(v string) *UpdateFlowSourceInput {
	s.EntitlementArn = &v
	return s
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowSourceInput) SetFlowArn(v string) *UpdateFlowSourceInput {
	s.FlowArn = &v
	return s
}

// SetIngestPort sets the IngestPort field's value.
func (s *UpdateFlowSourceInput) SetIngestPort(v int64) *UpdateFlowSourceInput {
	s.IngestPort = &v
	return s
}

// SetMaxBitrate sets the MaxBitrate field's value.
func (s *UpdateFlowSourceInput) SetMaxBitrate(v int64) *UpdateFlowSourceInput {
	s.MaxBitrate = &v
	return s
}

// SetMaxLatency sets the MaxLatency field's value.
func (s *UpdateFlowSourceInput) SetMaxLatency(v int64) *UpdateFlowSourceInput {
	s.MaxLatency = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateFlowSourceInput) SetProtocol(v string) *UpdateFlowSourceInput {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *UpdateFlowSourceInput) SetSourceArn(v string) *UpdateFlowSourceInput {
	s.SourceArn = &v
	return s
}

// SetStreamId sets the StreamId field's value.
func (s *UpdateFlowSourceInput) SetStreamId(v string) *UpdateFlowSourceInput {
	s.StreamId = &v
	return s
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *UpdateFlowSourceInput) SetVpcInterfaceName(v string) *UpdateFlowSourceInput {
	s.VpcInterfaceName = &v
	return s
}

// SetWhitelistCidr sets the WhitelistCidr field's value.
func (s *UpdateFlowSourceInput) SetWhitelistCidr(v string) *UpdateFlowSourceInput {
	s.WhitelistCidr = &v
	return s
}

// The result of a successful UpdateFlowSource request. The response includes
// the ARN of the flow that was updated and the updated source configuration.
type UpdateFlowSourceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the flow that you want to update.
	FlowArn *string `locationName:"flowArn" type:"string"`

	// The settings for the source of the flow.
	Source *Source `locationName:"source" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowSourceOutput) GoString() string {
	return s.String()
}

// SetFlowArn sets the FlowArn field's value.
func (s *UpdateFlowSourceOutput) SetFlowArn(v string) *UpdateFlowSourceOutput {
	s.FlowArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *UpdateFlowSourceOutput) SetSource(v *Source) *UpdateFlowSourceOutput {
	s.Source = v
	return s
}

// The settings for a VPC Source.
type VpcInterface struct {
	_ struct{} `type:"structure"`

	// Immutable and has to be a unique against other VpcInterfaces in this Flow
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// IDs of the network interfaces created in customer's account by MediaConnect.
	//
	// NetworkInterfaceIds is a required field
	NetworkInterfaceIds []*string `locationName:"networkInterfaceIds" type:"list" required:"true"`

	// Role Arn MediaConnect can assumes to create ENIs in customer's account
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Security Group IDs to be used on ENI.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// Subnet must be in the AZ of the Flow
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s VpcInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcInterface) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *VpcInterface) SetName(v string) *VpcInterface {
	s.Name = &v
	return s
}

// SetNetworkInterfaceIds sets the NetworkInterfaceIds field's value.
func (s *VpcInterface) SetNetworkInterfaceIds(v []*string) *VpcInterface {
	s.NetworkInterfaceIds = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *VpcInterface) SetRoleArn(v string) *VpcInterface {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcInterface) SetSecurityGroupIds(v []*string) *VpcInterface {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *VpcInterface) SetSubnetId(v string) *VpcInterface {
	s.SubnetId = &v
	return s
}

// The settings for attaching a VPC interface to an output.
type VpcInterfaceAttachment struct {
	_ struct{} `type:"structure"`

	// The name of the VPC interface to use for this output.
	VpcInterfaceName *string `locationName:"vpcInterfaceName" type:"string"`
}

// String returns the string representation
func (s VpcInterfaceAttachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcInterfaceAttachment) GoString() string {
	return s.String()
}

// SetVpcInterfaceName sets the VpcInterfaceName field's value.
func (s *VpcInterfaceAttachment) SetVpcInterfaceName(v string) *VpcInterfaceAttachment {
	s.VpcInterfaceName = &v
	return s
}

// Desired VPC Interface for a Flow
type VpcInterfaceRequest struct {
	_ struct{} `type:"structure"`

	// The name of the VPC Interface. This value must be unique within the current
	// flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Role Arn MediaConnect can assumes to create ENIs in customer's account
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Security Group IDs to be used on ENI.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// Subnet must be in the AZ of the Flow
	//
	// SubnetId is a required field
	SubnetId *string `locationName:"subnetId" type:"string" required:"true"`
}

// String returns the string representation
func (s VpcInterfaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcInterfaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcInterfaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcInterfaceRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *VpcInterfaceRequest) SetName(v string) *VpcInterfaceRequest {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *VpcInterfaceRequest) SetRoleArn(v string) *VpcInterfaceRequest {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcInterfaceRequest) SetSecurityGroupIds(v []*string) *VpcInterfaceRequest {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *VpcInterfaceRequest) SetSubnetId(v string) *VpcInterfaceRequest {
	s.SubnetId = &v
	return s
}

const (
	// AlgorithmAes128 is a Algorithm enum value
	AlgorithmAes128 = "aes128"

	// AlgorithmAes192 is a Algorithm enum value
	AlgorithmAes192 = "aes192"

	// AlgorithmAes256 is a Algorithm enum value
	AlgorithmAes256 = "aes256"
)

// Algorithm_Values returns all elements of the Algorithm enum
func Algorithm_Values() []string {
	return []string{
		AlgorithmAes128,
		AlgorithmAes192,
		AlgorithmAes256,
	}
}

const (
	// EntitlementStatusEnabled is a EntitlementStatus enum value
	EntitlementStatusEnabled = "ENABLED"

	// EntitlementStatusDisabled is a EntitlementStatus enum value
	EntitlementStatusDisabled = "DISABLED"
)

// EntitlementStatus_Values returns all elements of the EntitlementStatus enum
func EntitlementStatus_Values() []string {
	return []string{
		EntitlementStatusEnabled,
		EntitlementStatusDisabled,
	}
}

const (
	// KeyTypeSpeke is a KeyType enum value
	KeyTypeSpeke = "speke"

	// KeyTypeStaticKey is a KeyType enum value
	KeyTypeStaticKey = "static-key"
)

// KeyType_Values returns all elements of the KeyType enum
func KeyType_Values() []string {
	return []string{
		KeyTypeSpeke,
		KeyTypeStaticKey,
	}
}

const (
	// ProtocolZixiPush is a Protocol enum value
	ProtocolZixiPush = "zixi-push"

	// ProtocolRtpFec is a Protocol enum value
	ProtocolRtpFec = "rtp-fec"

	// ProtocolRtp is a Protocol enum value
	ProtocolRtp = "rtp"

	// ProtocolZixiPull is a Protocol enum value
	ProtocolZixiPull = "zixi-pull"

	// ProtocolRist is a Protocol enum value
	ProtocolRist = "rist"
)

// Protocol_Values returns all elements of the Protocol enum
func Protocol_Values() []string {
	return []string{
		ProtocolZixiPush,
		ProtocolRtpFec,
		ProtocolRtp,
		ProtocolZixiPull,
		ProtocolRist,
	}
}

const (
	// SourceTypeOwned is a SourceType enum value
	SourceTypeOwned = "OWNED"

	// SourceTypeEntitled is a SourceType enum value
	SourceTypeEntitled = "ENTITLED"
)

// SourceType_Values returns all elements of the SourceType enum
func SourceType_Values() []string {
	return []string{
		SourceTypeOwned,
		SourceTypeEntitled,
	}
}

const (
	// StateEnabled is a State enum value
	StateEnabled = "ENABLED"

	// StateDisabled is a State enum value
	StateDisabled = "DISABLED"
)

// State_Values returns all elements of the State enum
func State_Values() []string {
	return []string{
		StateEnabled,
		StateDisabled,
	}
}

const (
	// StatusStandby is a Status enum value
	StatusStandby = "STANDBY"

	// StatusActive is a Status enum value
	StatusActive = "ACTIVE"

	// StatusUpdating is a Status enum value
	StatusUpdating = "UPDATING"

	// StatusDeleting is a Status enum value
	StatusDeleting = "DELETING"

	// StatusStarting is a Status enum value
	StatusStarting = "STARTING"

	// StatusStopping is a Status enum value
	StatusStopping = "STOPPING"

	// StatusError is a Status enum value
	StatusError = "ERROR"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusStandby,
		StatusActive,
		StatusUpdating,
		StatusDeleting,
		StatusStarting,
		StatusStopping,
		StatusError,
	}
}
