package apis

import (
	"k8s.io/apimachinery/pkg/runtime"
)

// LockedResource represents a resource to be enforced in a LockedResourceController and can be used in a API specification
// +k8s:openapi-gen=true
type LockedResource struct {

	// Object is a yaml representation of an API resource
	// +kubebuilder:validation:Required
	Object runtime.RawExtension `json:"object"`

	// ExludedPaths are a set of json paths that need not be considered by the LockedResourceReconciler
	// +kubebuilder:validation:Optional
	// +listType=set
	ExcludedPaths []string `json:"excludedPaths,omitempty"`
}

// LockedResourceTemplate represents a resource template in go language to be enforced in a LockedResourceController and can be used in a API specification
// +k8s:openapi-gen=true
type LockedResourceTemplate struct {

	// ObjectTemplate is a goland template. Whne processed, it must resolve to a yaml representation of an API resource
	// +kubebuilder:validation:Required
	ObjectTemplate string `json:"objectTemplate"`

	// ExludedPaths are a set of json paths that need not be considered by the LockedResourceReconciler
	// +kubebuilder:validation:Optional
	// +listType=set
	ExcludedPaths []string `json:"excludedPaths,omitempty"`
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LockedResource) DeepCopyInto(out *LockedResource) {
	*out = *in
	in.Object.DeepCopyInto(&out.Object)
	if in.ExcludedPaths != nil {
		in, out := &in.ExcludedPaths, &out.ExcludedPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ReconcileStatus.
func (in *LockedResource) DeepCopy() *LockedResource {
	if in == nil {
		return nil
	}
	out := new(LockedResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *LockedResourceTemplate) DeepCopyInto(out *LockedResourceTemplate) {
	*out = *in
	if in.ExcludedPaths != nil {
		in, out := &in.ExcludedPaths, &out.ExcludedPaths
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	return
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ReconcileStatus.
func (in *LockedResourceTemplate) DeepCopy() *LockedResourceTemplate {
	if in == nil {
		return nil
	}
	out := new(LockedResourceTemplate)
	in.DeepCopyInto(out)
	return out
}
