// Copyright Red Hat

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/identitatem/idp-client-api/api/identitatem/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeIDPConfigs implements IDPConfigInterface
type FakeIDPConfigs struct {
	Fake *FakeIdentityconfigV1alpha1
	ns   string
}

var idpconfigsResource = schema.GroupVersionResource{Group: "identityconfig.identitatem.io", Version: "v1alpha1", Resource: "idpconfigs"}

var idpconfigsKind = schema.GroupVersionKind{Group: "identityconfig.identitatem.io", Version: "v1alpha1", Kind: "IDPConfig"}

// Get takes name of the iDPConfig, and returns the corresponding iDPConfig object, and an error if there is any.
func (c *FakeIDPConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.IDPConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(idpconfigsResource, c.ns, name), &v1alpha1.IDPConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IDPConfig), err
}

// List takes label and field selectors, and returns the list of IDPConfigs that match those selectors.
func (c *FakeIDPConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.IDPConfigList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(idpconfigsResource, idpconfigsKind, c.ns, opts), &v1alpha1.IDPConfigList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.IDPConfigList{ListMeta: obj.(*v1alpha1.IDPConfigList).ListMeta}
	for _, item := range obj.(*v1alpha1.IDPConfigList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested iDPConfigs.
func (c *FakeIDPConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(idpconfigsResource, c.ns, opts))

}

// Create takes the representation of a iDPConfig and creates it.  Returns the server's representation of the iDPConfig, and an error, if there is any.
func (c *FakeIDPConfigs) Create(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.CreateOptions) (result *v1alpha1.IDPConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(idpconfigsResource, c.ns, iDPConfig), &v1alpha1.IDPConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IDPConfig), err
}

// Update takes the representation of a iDPConfig and updates it. Returns the server's representation of the iDPConfig, and an error, if there is any.
func (c *FakeIDPConfigs) Update(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.UpdateOptions) (result *v1alpha1.IDPConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(idpconfigsResource, c.ns, iDPConfig), &v1alpha1.IDPConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IDPConfig), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeIDPConfigs) UpdateStatus(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.UpdateOptions) (*v1alpha1.IDPConfig, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(idpconfigsResource, "status", c.ns, iDPConfig), &v1alpha1.IDPConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IDPConfig), err
}

// Delete takes name of the iDPConfig and deletes it. Returns an error if one occurs.
func (c *FakeIDPConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(idpconfigsResource, c.ns, name), &v1alpha1.IDPConfig{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeIDPConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(idpconfigsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.IDPConfigList{})
	return err
}

// Patch applies the patch and returns the patched iDPConfig.
func (c *FakeIDPConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.IDPConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(idpconfigsResource, c.ns, name, pt, data, subresources...), &v1alpha1.IDPConfig{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.IDPConfig), err
}
