// Copyright Red Hat

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"github.com/identitatem/idp-client-api/api/client/clientset/versioned/scheme"
	v1alpha1 "github.com/identitatem/idp-client-api/api/identitatem/v1alpha1"
	rest "k8s.io/client-go/rest"
)

type IdentityconfigV1alpha1Interface interface {
	RESTClient() rest.Interface
	AuthRealmsGetter
	ClusterOAuthsGetter
	IDPConfigsGetter
	StrategiesGetter
}

// IdentityconfigV1alpha1Client is used to interact with features provided by the identityconfig.identitatem.io group.
type IdentityconfigV1alpha1Client struct {
	restClient rest.Interface
}

func (c *IdentityconfigV1alpha1Client) AuthRealms(namespace string) AuthRealmInterface {
	return newAuthRealms(c, namespace)
}

func (c *IdentityconfigV1alpha1Client) ClusterOAuths(namespace string) ClusterOAuthInterface {
	return newClusterOAuths(c, namespace)
}

func (c *IdentityconfigV1alpha1Client) IDPConfigs(namespace string) IDPConfigInterface {
	return newIDPConfigs(c, namespace)
}

func (c *IdentityconfigV1alpha1Client) Strategies(namespace string) StrategyInterface {
	return newStrategies(c, namespace)
}

// NewForConfig creates a new IdentityconfigV1alpha1Client for the given config.
func NewForConfig(c *rest.Config) (*IdentityconfigV1alpha1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &IdentityconfigV1alpha1Client{client}, nil
}

// NewForConfigOrDie creates a new IdentityconfigV1alpha1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *IdentityconfigV1alpha1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new IdentityconfigV1alpha1Client for the given RESTClient.
func New(c rest.Interface) *IdentityconfigV1alpha1Client {
	return &IdentityconfigV1alpha1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1alpha1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *IdentityconfigV1alpha1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
