// Copyright Red Hat

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	scheme "github.com/identitatem/idp-client-api/api/client/clientset/versioned/scheme"
	v1alpha1 "github.com/identitatem/idp-client-api/api/identitatem/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// IDPConfigsGetter has a method to return a IDPConfigInterface.
// A group's client should implement this interface.
type IDPConfigsGetter interface {
	IDPConfigs(namespace string) IDPConfigInterface
}

// IDPConfigInterface has methods to work with IDPConfig resources.
type IDPConfigInterface interface {
	Create(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.CreateOptions) (*v1alpha1.IDPConfig, error)
	Update(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.UpdateOptions) (*v1alpha1.IDPConfig, error)
	UpdateStatus(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.UpdateOptions) (*v1alpha1.IDPConfig, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.IDPConfig, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.IDPConfigList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.IDPConfig, err error)
	IDPConfigExpansion
}

// iDPConfigs implements IDPConfigInterface
type iDPConfigs struct {
	client rest.Interface
	ns     string
}

// newIDPConfigs returns a IDPConfigs
func newIDPConfigs(c *IdentityconfigV1alpha1Client, namespace string) *iDPConfigs {
	return &iDPConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the iDPConfig, and returns the corresponding iDPConfig object, and an error if there is any.
func (c *iDPConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.IDPConfig, err error) {
	result = &v1alpha1.IDPConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("idpconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of IDPConfigs that match those selectors.
func (c *iDPConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.IDPConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.IDPConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("idpconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested iDPConfigs.
func (c *iDPConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("idpconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a iDPConfig and creates it.  Returns the server's representation of the iDPConfig, and an error, if there is any.
func (c *iDPConfigs) Create(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.CreateOptions) (result *v1alpha1.IDPConfig, err error) {
	result = &v1alpha1.IDPConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("idpconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(iDPConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a iDPConfig and updates it. Returns the server's representation of the iDPConfig, and an error, if there is any.
func (c *iDPConfigs) Update(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.UpdateOptions) (result *v1alpha1.IDPConfig, err error) {
	result = &v1alpha1.IDPConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("idpconfigs").
		Name(iDPConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(iDPConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *iDPConfigs) UpdateStatus(ctx context.Context, iDPConfig *v1alpha1.IDPConfig, opts v1.UpdateOptions) (result *v1alpha1.IDPConfig, err error) {
	result = &v1alpha1.IDPConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("idpconfigs").
		Name(iDPConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(iDPConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the iDPConfig and deletes it. Returns an error if one occurs.
func (c *iDPConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("idpconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *iDPConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("idpconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched iDPConfig.
func (c *iDPConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.IDPConfig, err error) {
	result = &v1alpha1.IDPConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("idpconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
