// Copyright Red Hat

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/identitatem/idp-client-api/api/identitatem/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterOAuthLister helps list ClusterOAuths.
// All objects returned here must be treated as read-only.
type ClusterOAuthLister interface {
	// List lists all ClusterOAuths in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ClusterOAuth, err error)
	// ClusterOAuths returns an object that can list and get ClusterOAuths.
	ClusterOAuths(namespace string) ClusterOAuthNamespaceLister
	ClusterOAuthListerExpansion
}

// clusterOAuthLister implements the ClusterOAuthLister interface.
type clusterOAuthLister struct {
	indexer cache.Indexer
}

// NewClusterOAuthLister returns a new ClusterOAuthLister.
func NewClusterOAuthLister(indexer cache.Indexer) ClusterOAuthLister {
	return &clusterOAuthLister{indexer: indexer}
}

// List lists all ClusterOAuths in the indexer.
func (s *clusterOAuthLister) List(selector labels.Selector) (ret []*v1alpha1.ClusterOAuth, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ClusterOAuth))
	})
	return ret, err
}

// ClusterOAuths returns an object that can list and get ClusterOAuths.
func (s *clusterOAuthLister) ClusterOAuths(namespace string) ClusterOAuthNamespaceLister {
	return clusterOAuthNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterOAuthNamespaceLister helps list and get ClusterOAuths.
// All objects returned here must be treated as read-only.
type ClusterOAuthNamespaceLister interface {
	// List lists all ClusterOAuths in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ClusterOAuth, err error)
	// Get retrieves the ClusterOAuth from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.ClusterOAuth, error)
	ClusterOAuthNamespaceListerExpansion
}

// clusterOAuthNamespaceLister implements the ClusterOAuthNamespaceLister
// interface.
type clusterOAuthNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterOAuths in the indexer for a given namespace.
func (s clusterOAuthNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ClusterOAuth, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ClusterOAuth))
	})
	return ret, err
}

// Get retrieves the ClusterOAuth from the indexer for a given namespace and name.
func (s clusterOAuthNamespaceLister) Get(name string) (*v1alpha1.ClusterOAuth, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("clusteroauth"), name)
	}
	return obj.(*v1alpha1.ClusterOAuth), nil
}
