// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/openshift/api/console/v1alpha1"
	scheme "github.com/openshift/client-go/console/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ConsolePluginsGetter has a method to return a ConsolePluginInterface.
// A group's client should implement this interface.
type ConsolePluginsGetter interface {
	ConsolePlugins() ConsolePluginInterface
}

// ConsolePluginInterface has methods to work with ConsolePlugin resources.
type ConsolePluginInterface interface {
	Create(ctx context.Context, consolePlugin *v1alpha1.ConsolePlugin, opts v1.CreateOptions) (*v1alpha1.ConsolePlugin, error)
	Update(ctx context.Context, consolePlugin *v1alpha1.ConsolePlugin, opts v1.UpdateOptions) (*v1alpha1.ConsolePlugin, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ConsolePlugin, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ConsolePluginList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ConsolePlugin, err error)
	ConsolePluginExpansion
}

// consolePlugins implements ConsolePluginInterface
type consolePlugins struct {
	client rest.Interface
}

// newConsolePlugins returns a ConsolePlugins
func newConsolePlugins(c *ConsoleV1alpha1Client) *consolePlugins {
	return &consolePlugins{
		client: c.RESTClient(),
	}
}

// Get takes name of the consolePlugin, and returns the corresponding consolePlugin object, and an error if there is any.
func (c *consolePlugins) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ConsolePlugin, err error) {
	result = &v1alpha1.ConsolePlugin{}
	err = c.client.Get().
		Resource("consoleplugins").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ConsolePlugins that match those selectors.
func (c *consolePlugins) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ConsolePluginList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ConsolePluginList{}
	err = c.client.Get().
		Resource("consoleplugins").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested consolePlugins.
func (c *consolePlugins) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("consoleplugins").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a consolePlugin and creates it.  Returns the server's representation of the consolePlugin, and an error, if there is any.
func (c *consolePlugins) Create(ctx context.Context, consolePlugin *v1alpha1.ConsolePlugin, opts v1.CreateOptions) (result *v1alpha1.ConsolePlugin, err error) {
	result = &v1alpha1.ConsolePlugin{}
	err = c.client.Post().
		Resource("consoleplugins").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(consolePlugin).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a consolePlugin and updates it. Returns the server's representation of the consolePlugin, and an error, if there is any.
func (c *consolePlugins) Update(ctx context.Context, consolePlugin *v1alpha1.ConsolePlugin, opts v1.UpdateOptions) (result *v1alpha1.ConsolePlugin, err error) {
	result = &v1alpha1.ConsolePlugin{}
	err = c.client.Put().
		Resource("consoleplugins").
		Name(consolePlugin.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(consolePlugin).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the consolePlugin and deletes it. Returns an error if one occurs.
func (c *consolePlugins) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("consoleplugins").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *consolePlugins) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("consoleplugins").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched consolePlugin.
func (c *consolePlugins) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ConsolePlugin, err error) {
	result = &v1alpha1.ConsolePlugin{}
	err = c.client.Patch(pt).
		Resource("consoleplugins").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
