// Copyright Red Hat

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/identitatem/idp-client-api/api/identitatem/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// StrategyLister helps list Strategies.
// All objects returned here must be treated as read-only.
type StrategyLister interface {
	// List lists all Strategies in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.Strategy, err error)
	// Strategies returns an object that can list and get Strategies.
	Strategies(namespace string) StrategyNamespaceLister
	StrategyListerExpansion
}

// strategyLister implements the StrategyLister interface.
type strategyLister struct {
	indexer cache.Indexer
}

// NewStrategyLister returns a new StrategyLister.
func NewStrategyLister(indexer cache.Indexer) StrategyLister {
	return &strategyLister{indexer: indexer}
}

// List lists all Strategies in the indexer.
func (s *strategyLister) List(selector labels.Selector) (ret []*v1alpha1.Strategy, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Strategy))
	})
	return ret, err
}

// Strategies returns an object that can list and get Strategies.
func (s *strategyLister) Strategies(namespace string) StrategyNamespaceLister {
	return strategyNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// StrategyNamespaceLister helps list and get Strategies.
// All objects returned here must be treated as read-only.
type StrategyNamespaceLister interface {
	// List lists all Strategies in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.Strategy, err error)
	// Get retrieves the Strategy from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.Strategy, error)
	StrategyNamespaceListerExpansion
}

// strategyNamespaceLister implements the StrategyNamespaceLister
// interface.
type strategyNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Strategies in the indexer for a given namespace.
func (s strategyNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Strategy, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Strategy))
	})
	return ret, err
}

// Get retrieves the Strategy from the indexer for a given namespace and name.
func (s strategyNamespaceLister) Get(name string) (*v1alpha1.Strategy, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("strategy"), name)
	}
	return obj.(*v1alpha1.Strategy), nil
}
