// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/secondary-scheduler-operator/pkg/apis/secondaryscheduler/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SecondarySchedulerLister helps list SecondarySchedulers.
// All objects returned here must be treated as read-only.
type SecondarySchedulerLister interface {
	// List lists all SecondarySchedulers in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SecondaryScheduler, err error)
	// SecondarySchedulers returns an object that can list and get SecondarySchedulers.
	SecondarySchedulers(namespace string) SecondarySchedulerNamespaceLister
	SecondarySchedulerListerExpansion
}

// secondarySchedulerLister implements the SecondarySchedulerLister interface.
type secondarySchedulerLister struct {
	indexer cache.Indexer
}

// NewSecondarySchedulerLister returns a new SecondarySchedulerLister.
func NewSecondarySchedulerLister(indexer cache.Indexer) SecondarySchedulerLister {
	return &secondarySchedulerLister{indexer: indexer}
}

// List lists all SecondarySchedulers in the indexer.
func (s *secondarySchedulerLister) List(selector labels.Selector) (ret []*v1.SecondaryScheduler, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SecondaryScheduler))
	})
	return ret, err
}

// SecondarySchedulers returns an object that can list and get SecondarySchedulers.
func (s *secondarySchedulerLister) SecondarySchedulers(namespace string) SecondarySchedulerNamespaceLister {
	return secondarySchedulerNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SecondarySchedulerNamespaceLister helps list and get SecondarySchedulers.
// All objects returned here must be treated as read-only.
type SecondarySchedulerNamespaceLister interface {
	// List lists all SecondarySchedulers in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.SecondaryScheduler, err error)
	// Get retrieves the SecondaryScheduler from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.SecondaryScheduler, error)
	SecondarySchedulerNamespaceListerExpansion
}

// secondarySchedulerNamespaceLister implements the SecondarySchedulerNamespaceLister
// interface.
type secondarySchedulerNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SecondarySchedulers in the indexer for a given namespace.
func (s secondarySchedulerNamespaceLister) List(selector labels.Selector) (ret []*v1.SecondaryScheduler, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SecondaryScheduler))
	})
	return ret, err
}

// Get retrieves the SecondaryScheduler from the indexer for a given namespace and name.
func (s secondarySchedulerNamespaceLister) Get(name string) (*v1.SecondaryScheduler, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("secondaryscheduler"), name)
	}
	return obj.(*v1.SecondaryScheduler), nil
}
