var falafel = require('../../');
var test = require('tape');

test('first opts arg', function (t) {
    t.plan(5);
    
    var src = '(function () {'
        + 'var xs = [ 1, 2, [ 3, 4 ] ];'
        + 'var ys = [ 5, 6 ];'
        + 'g([ xs, ys ]);'
    + '})()';
    
    var output = falafel({ source: src }, function (node) {
        if (node.type === 'ArrayExpression') {
            node.update('fn(' + node.source() + ')');
        }
    });
    
    var arrays = [
        [ 3, 4 ],
        [ 1, 2, [ 3, 4 ] ],
        [ 5, 6 ],
        [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ],
    ];
    
    Function(['fn','g'], output)(
        function (xs) {
            t.same(arrays.shift(), xs);
            return xs;
        },
        function (xs) {
            t.same(xs, [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ]);
        }
    );
});

test('opts.source', function (t) {
    t.plan(5);
    
    var src = '(function () {'
        + 'var xs = [ 1, 2, [ 3, 4 ] ];'
        + 'var ys = [ 5, 6 ];'
        + 'g([ xs, ys ]);'
    + '})()';
    
    var output = falafel(undefined, { source: src }, function (node) {
        if (node.type === 'ArrayExpression') {
            node.update('fn(' + node.source() + ')');
        }
    });
    
    var arrays = [
        [ 3, 4 ],
        [ 1, 2, [ 3, 4 ] ],
        [ 5, 6 ],
        [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ],
    ];
    
    Function(['fn','g'], output)(
        function (xs) {
            t.same(arrays.shift(), xs);
            return xs;
        },
        function (xs) {
            t.same(xs, [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ]);
        }
    );
});

test('Buffer opts.source', function (t) {
    t.plan(5);
    
    var src = Buffer('(function () {'
        + 'var xs = [ 1, 2, [ 3, 4 ] ];'
        + 'var ys = [ 5, 6 ];'
        + 'g([ xs, ys ]);'
    + '})()');
    
    var output = falafel({ source: src }, function (node) {
        if (node.type === 'ArrayExpression') {
            node.update('fn(' + node.source() + ')');
        }
    });
    
    var arrays = [
        [ 3, 4 ],
        [ 1, 2, [ 3, 4 ] ],
        [ 5, 6 ],
        [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ],
    ];
    
    Function(['fn','g'], output)(
        function (xs) {
            t.same(arrays.shift(), xs);
            return xs;
        },
        function (xs) {
            t.same(xs, [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ]);
        }
    );
});

test('Buffer source', function (t) {
    t.plan(5);
    
    var src = Buffer('(function () {'
        + 'var xs = [ 1, 2, [ 3, 4 ] ];'
        + 'var ys = [ 5, 6 ];'
        + 'g([ xs, ys ]);'
    + '})()');
    
    var output = falafel(src, function (node) {
        if (node.type === 'ArrayExpression') {
            node.update('fn(' + node.source() + ')');
        }
    });
    
    var arrays = [
        [ 3, 4 ],
        [ 1, 2, [ 3, 4 ] ],
        [ 5, 6 ],
        [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ],
    ];
    
    Function(['fn','g'], output)(
        function (xs) {
            t.same(arrays.shift(), xs);
            return xs;
        },
        function (xs) {
            t.same(xs, [ [ 1, 2, [ 3, 4 ] ], [ 5, 6 ] ]);
        }
    );
});
