# Antora CLI

The command line interface (CLI) for Antora.

[Antora](https://antora.org) is a modular static site generator designed for creating documentation sites from AsciiDoc documents.
Its site generator pipeline aggregates documents from versioned content repositories and processes them using [Asciidoctor](https://asciidoctor.org).

To run Antora, you need both the CLI and a site generator pipeline.
Once these packages are installed, you can use the `antora` command to generate your site.

## How to Install

Let's start by installing the CLI.

```sh
npm install -g @antora/cli
```

This package adds the `antora` command to your PATH.
You can check by running:

```sh
antora -v
```

Next, install a site generator.
The default site generator will be sufficient for most users.

```sh
npm install -g @antora/site-generator-default
```

The `antora` command (specifically the implicit `generate` subcommand) will look for this package by default.

## How to Use

To run Antora, you'll need a playbook file and at least one content (source) repository.
Consult the [evaluation quickstart](https://gitlab.com/antora/antora#readme) to find an example.

Once you have your content sources set up, just point the `antora` command at your playbook file:

```sh
antora antora-playbook.yml
```

The `antora` command will output the generated site to the _build/site_ folder by default.

## Copyright and License

Copyright (C) 2017-2020 [OpenDevise Inc.](https://opendevise.com) and the [Antora Project](https://antora.org).

Use of this software is granted under the terms of the [Mozilla Public License Version 2.0](https://www.mozilla.org/en-US/MPL/2.0/) (MPL-2.0).
