# sitelib for noarch packages, sitearch for others (remove the unneeded one)
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%global pythonver %(%{__python} -c "import sys; print sys.version[:3]" 2>/dev/null || echo 0.0)

Name:           aura
Version:        1.0.0
Release:        0%{?dist}
Summary:        Utility for transforming DocBook or AsciiDoc to various formats

Group:          Applications/System
License:        TODO
Source0:        %{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

%if 0%{?fedora} >= 25
Provides:       python2-%{name} = %{version}
%{?python_provide:%python_provide python2-%name}
%else
Provides:       python-%{name} = %{version}
%endif

Requires:       python-click
Requires:       python-lxml >= 2.3.2
Requires:       python-num2words
Requires:       python-requests
#Requires:       ffmpeg
Requires:       numpy
Requires:       publican >= 4.3.2
Requires:       wkhtmltopdf
Requires:       rubygem-asciidoctor >= 1.5.2-2
Requires:       rubygem-asciidoctor-diagram >= 1.5.5
Requires:       python-pillow >= 2.2.1
Requires:       GitPython >= 0.3.2

BuildArch:      noarch
BuildRequires:  python-devel
BuildRequires:  python-setuptools
BuildRequires:  python-click
BuildRequires:  python-num2words
BuildRequires:  python-lxml >= 2.3.2
BuildRequires:  python-requests
BuildRequires:  numpy
BuildRequires:  pytest
BuildRequires:  python-mock >= 1.0.1
BuildRequires:  python-pillow >= 2.2.1

%if 0%{?el6}
Requires:       python-importlib
BuildRequires:  python-importlib
%endif


%description
A utility for transforming DocBook or AsciiDoc to various formats, such as HTML, PDF & ePub


%prep
%setup -q -n aura-%{version}

# Update the data files path to be absolute
sed -i "s;'etc/;'/etc/;" setup.py


%build
%{__python} setup.py build


%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install -O1 --skip-build --root $RPM_BUILD_ROOT


%check
PYTHONPATH=$(pwd) py.test-%{pythonver} tests --tb=long --verbose --capture=no


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc LICENSE
%{_sysconfdir}/bash_completion.d
%config(noreplace) %{_sysconfdir}/aura/aura.conf
%{_bindir}/aura
# For noarch packages: sitelib
%{python_sitelib}/*


%changelog
* Thu May 17 2018 Lee Newson <lnewson@redhat.com> - 1.0.0-0
- Initial package
