# Created by pyp2rpm-1.1.1
%global pypi_name num2words

%if 0%{?fedora} >= 12 || 0%{?rhel} >= 8
%global with_python3 1
%endif

%if 0%{?rhel} && 0%{?rhel} <= 6
%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python2_sitearch: %global python2_sitearch %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

%if 0%{?fedora} >= 25
Name:           python2-%{pypi_name}
%{?python_provide:%python_provide python2-%pypi_name}
%else
Name:           python-%{pypi_name}
%endif
Version:        0.5.2
Release:        1%{?dist}
Summary:        Modules to convert numbers to words. Easily extensible

License:        LGPL
URL:            https://github.com/savoirfairelinux/num2words
Source0:        https://pypi.python.org/packages/source/n/%{pypi_name}/%{pypi_name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

BuildRequires:  python-devel
BuildRequires:  python-setuptools

%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
%endif # if with_python3


%description
num2words - Convert numbers to words in multiple languages
==========================================================

``num2words`` is a
library that converts numbers like ``42`` to words like ``forty-two``. It
supports multiple languages (English, French, Spanish, German and Lithuanian)
and can even generate
ordinal numbers like ``forty-second`` (altough this last
feature is a bit buggy at the ...

%if 0%{?with_python3}
%package -n     python3-%{pypi_name}
Summary:        Modules to convert numbers to words. Easily extensible


%description -n python3-%{pypi_name}
num2words - Convert numbers to words in multiple languages
==========================================================

``num2words`` is a
library that converts numbers like ``42`` to words like ``forty-two``. It
supports multiple languages (English, French, Spanish, German and Lithuanian)
and can even generate
ordinal numbers like ``forty-second`` (altough this last
feature is a bit buggy at the ...

%endif


%prep
%setup -q -n %{pypi_name}-%{version}
# Remove bundled egg-info
rm -rf %{pypi_name}.egg-info

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3


%build
%{__python2} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf %{buildroot}

# Must do the subpackages' install first because the scripts in /usr/bin are
# overwritten with every setup.py install (and we want the python2 version
# to be the default for now).
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root %{buildroot}
popd
%endif # with_python3

%{__python2} setup.py install --skip-build --root %{buildroot}


%check
%{__python2} setup.py test

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py test
popd
%endif # with_python3


%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root,-)
%doc README.rst
%{python2_sitelib}/%{pypi_name}
%{python2_sitelib}/%{pypi_name}-%{version}-py?.?.egg-info
%exclude %{python2_sitelib}/tests

%if 0%{?with_python3}
%files -n python3-%{pypi_name}
%defattr(-,root,root,-)
%doc README.rst
%{python3_sitelib}/%{pypi_name}
%{python3_sitelib}/%{pypi_name}-%{version}-py?.?.egg-info
%exclude %{python3_sitelib}/tests
%endif # with_python3

%changelog
* Fri Jan 23 2015 Virgil Dupras - 0.5.2-1
- Added Latvian localization.
- Improved Spanish localization.
- Improved Lithuanian localization.

* Fri Mar 14 2014 Virgil Dupras - 0.5.1-1
- Added Python 3 support with 2to3.
- Fixed big numbers in spanish.
- Fixed bugs in tanslation from 30 to 40 in spanish.
- Fixed word joining in english.

* Tue May 28 2013 Virgil Dupras - 0.5.0-1
- Created num2words based on the old pynum2word project.