# Created by pyp2rpm-3.2.2
%global pypi_name shaape

# Disable python 3 builds, as pango isn't available
%global with_python3 0

%if 0%{?rhel} && 0%{?rhel} <= 6
%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python2_sitearch: %global python2_sitearch %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

%if 0%{?fedora} >= 25
Name:           python2-%{pypi_name}
%{?python_provide:%python_provide python2-%pypi_name}
%else
Name:           python-%{pypi_name}
%endif
Version:        1.1.1
Release:        1%{?dist}
Summary:        Shaape - ascii art to image converter

License:        LICENSE
URL:            http://github.com/christiangoltz/shaape
Source0:        https://files.pythonhosted.org/packages/source/s/%{pypi_name}/%{pypi_name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  python2-devel
BuildRequires:  python-nose
BuildRequires:  python-setuptools
BuildRequires:  pycairo

%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-nose
BuildRequires:  python3-setuptools
BuildRequires:  python3-cairo
%endif

# Needed for pango dependency
BuildRequires:  pygtk2

Requires:       python-networkx
Requires:       PyYAML

%if 0%{?with_python3}
Requires:       python3-networkx
Requires:       python3-PyYAML
%endif

%description
UNKNOWN

%if 0%{?with_python3}
%package -n     python3-%{pypi_name}
Summary:        %{summary}
%{?python_provide:%python_provide python3-%{pypi_name}}

%description -n python3-%{pypi_name}
UNKNOWN
%endif


%prep
%setup -n %{pypi_name}-%{version}
# Remove bundled egg-info
rm -rf %{pypi_name}.egg-info

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3


%build
%{__python2} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3

%install
%if 0%{?with_python3}
# Must do the subpackages' install first because the scripts in /usr/bin are
# overwritten with every setup.py install.
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root %{buildroot}
cp %{buildroot}/%{_bindir}/shaape %{buildroot}/%{_bindir}/shaape-%{python3_version}
ln -s %{_bindir}/shaape-%{python3_version} %{buildroot}/%{_bindir}/shaape-3
popd
%endif

%{__python2} setup.py install --skip-build --root %{buildroot}
cp %{buildroot}/%{_bindir}/shaape %{buildroot}/%{_bindir}/shaape-%{python2_version}
ln -s %{_bindir}/shaape-%{python2_version} %{buildroot}/%{_bindir}/shaape-2


%check
%{__python2} setup.py test

%if 0%{?with_python3}
%{__python3} setup.py test
%endif

%files
%doc
%{_bindir}/shaape
%{_bindir}/shaape-2
%{_bindir}/shaape-%{python2_version}
%{python2_sitelib}/%{pypi_name}
%{python2_sitelib}/%{pypi_name}-%{version}-py?.?.egg-info

%if 0%{?with_python3}
%files -n python3-%{pypi_name}
%doc
%{_bindir}/shaape-3
%{_bindir}/shaape-%{python3_version}
%{python3_sitelib}/%{pypi_name}
%{python3_sitelib}/%{pypi_name}-%{version}-py?.?.egg-info
%endif

%changelog
* Mon Aug 21 2017 Lee Newson <lnewso@hotmail.com> - 1.1.1-1
- Initial package.