%global pypi_name     blockdiag
%if 0%{?fedora} >= 12 || 0%{?rhel} >= 8
%global with_python3 1
%endif

%if 0%{?rhel} && 0%{?rhel} <= 6
%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python2_sitearch: %global python2_sitearch %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif


Name:           python-%{pypi_name}
Version:        1.5.3
Release:        4%{?dist}
Summary:        Generate block-diagram images from text

License:        ASL 2.0
URL:            http://blockdiag.com/
Source0:        https://pypi.python.org/packages/source/b/%{pypi_name}/%{pypi_name}-%{version}.tar.gz
Source1:        description-%{pypi_name}.txt
Patch0001:      blockdiag-0001-Disable-eggs-downloading-from-pypi.patch

BuildArch:      noarch
BuildRequires:  python2-devel
BuildRequires:  python-docutils
BuildRequires:  python-funcparserlib >= 0.3.6
BuildRequires:  python-mock
BuildRequires:  python-nose
BuildRequires:  python-pep8
BuildRequires:  python-pillow
BuildRequires:  python-reportlab
BuildRequires:  python-setuptools
BuildRequires:  python-webcolors
BuildRequires:  python-pillow >= 2.2.1

%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-docutils
BuildRequires:  python3-funcparserlib >= 0.3.6
BuildRequires:  python3-mock
BuildRequires:  python3-nose
BuildRequires:  python3-pep8
BuildRequires:  python3-pillow
BuildRequires:  python3-reportlab
BuildRequires:  python3-setuptools
BuildRequires:  python3-webcolors
%endif

# upstream uses ipagp.ttf as its default font
BuildRequires:  ipa-pgothic-fonts

Requires:       ipa-pgothic-fonts
Requires:       python-funcparserlib >= 0.3.6
Requires:       python-pillow >= 2.2.1
Requires:       python-setuptools
Requires:       python-webcolors


%description
%(cat %{SOURCE1})


%package -n python-%{pypi_name}-devel
Summary:        Development files for python-%{pypi_name}
Requires:       python-%{pypi_name} = %{version}-%{release}


%description -n python-%{pypi_name}-devel
Development files for python-%{pypi_name}.


%if 0%{?with_python3}
%package -n python3-%{pypi_name}
Summary:        %{summary}
Requires:       ipa-pgothic-fonts
Requires:       python3-funcparserlib
Requires:       python3-pillow
Requires:       python3-setuptools
Requires:       python3-webcolors


%description -n python3-%{pypi_name}
%(cat %{SOURCE1})

This package installs the %{pypi_name} module for Python 3.


%package -n python3-%{pypi_name}-devel
Summary:        Development files for python3-%{pypi_name}
Requires:       python3-%{pypi_name} = %{version}-%{release}


%description -n python3-%{pypi_name}-devel
Development files for python3-%{pypi_name}.
%endif


%prep
%setup -qn %{pypi_name}-%{version}
%patch0001 -p1

rm -rf src/*.egg-info
find           -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python2}|'

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}

find %{py3dir} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'
%endif


%build
%{__python2} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif


%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root %{buildroot}
mv %{buildroot}%{_bindir}/%{pypi_name} %{buildroot}%{_bindir}/%{pypi_name}-%{python3_version}
install -pm 644 -D %{pypi_name}.1 %{buildroot}%{_mandir}/man1/%{pypi_name}-%{python3_version}.1
popd
%endif

%{__python2} setup.py install -O1 --skip-build --root %{buildroot}
install -pm 644 -D %{pypi_name}.1 %{buildroot}%{_mandir}/man1/%{pypi_name}.1


%check
%{__python2} setup.py test ||:

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py test ||:
popd
%endif


%files
%doc LICENSE
%{_bindir}/%{pypi_name}
%{_mandir}/man1/%{pypi_name}.1*
%{python2_sitelib}/%{pypi_name}*


%files -n python-%{pypi_name}-devel
%{python2_sitelib}/%{pypi_name}/tests


%if 0%{?with_python3}
%files -n python3-%{pypi_name}
%license LICENSE
%{_bindir}/%{pypi_name}-%{python3_version}
%{_mandir}/man1/%{pypi_name}-%{python3_version}.1*
%{python3_sitelib}/__pycache__/*
%{python3_sitelib}/%{pypi_name}*


%files -n python3-%{pypi_name}-devel
%{python3_sitelib}/%{pypi_name}/tests
%endif


%changelog
* Tue Jul 19 2016 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.5.3-4
- https://fedoraproject.org/wiki/Changes/Automatic_Provides_for_Python_RPM_Packages

* Thu Feb 04 2016 Fedora Release Engineering <releng@fedoraproject.org> - 1.5.3-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Tue Nov 10 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.5.3-2
- Rebuilt for https://fedoraproject.org/wiki/Changes/python3.5

* Thu Aug 20 2015 Haïkel Guémar <hguemar@fedoraproject.org> - 1.5.3-1
- Upstream 1.5.3

* Thu Jun 18 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.3.2-7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Sat Jun 07 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.3.2-6
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Mon May 19 2014 Bohuslav Kabrda <bkabrda@redhat.com> - 1.3.2-5
- Rebuilt for https://fedoraproject.org/wiki/Changes/Python_3.4

* Mon Mar 03 2014 Dridi Boukelmoune <dridi.boukelmoune@gmail.com> 1.3.2-4
- Switched to the source tarball from bitbucket
- Added missing dependencies

* Sun Feb 16 2014 Dridi Boukelmoune <dridi.boukelmoune@gmail.com> 1.3.2-3
- Added devel packages needed by other *diag packages

* Tue Dec 31 2013 Dridi Boukelmoune <dridi.boukelmoune@gmail.com> 1.3.2-2
- Fixed python => python2 where relevant
- New slightly different summary

* Sat Dec 28 2013 Dridi Boukelmoune <dridi.boukelmoune@gmail.com> 1.3.2-1
- Initial spec