%global pypi_name     seqdiag
%if 0%{?fedora} >= 12 || 0%{?rhel} >= 8
%global with_python3 1
%endif

%if 0%{?rhel} && 0%{?rhel} <= 6
%{!?__python2: %global __python2 /usr/bin/python2}
%{!?python2_sitelib: %global python2_sitelib %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python2_sitearch: %global python2_sitearch %(%{__python2} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

Name:           python-%{pypi_name}
Version:        0.9.5
Release:        6%{?dist}
Summary:        seqdiag generates sequence-diagram images from text

License:        ASL 2.0
URL:            http://blockdiag.com/
Source0:        https://pypi.python.org/packages/source/s/seqdiag/%{pypi_name}-%{version}.tar.gz
Source1:        description-%{pypi_name}.txt
Patch0001:      seqdiag-0001-Disable-eggs-downloading-from-pypi.patch

BuildArch:      noarch
BuildRequires:  python2-devel
BuildRequires:  python-blockdiag-devel
BuildRequires:  python-docutils
BuildRequires:  python-nose
BuildRequires:  python-pillow >= 2.2.1
BuildRequires:  python-reportlab
BuildRequires:  python-setuptools

Requires:       python-blockdiag
Requires:       python-reportlab


%description
%(cat %{SOURCE1})


%if 0%{?with_python3}
%package -n python3-%{pypi_name}
Summary:        %{summary}

BuildRequires:  python3-blockdiag-devel
BuildRequires:  python3-devel
BuildRequires:  python3-docutils
BuildRequires:  python3-nose
BuildRequires:  python3-pillow >= 2.2.1
BuildRequires:  python3-reportlab
BuildRequires:  python3-setuptools

Requires:       python3-blockdiag
Requires:       python3-reportlab


%description -n python3-%{pypi_name}
%(cat %{SOURCE1})

This package installs the %{pypi_name} module for Python 3.
%endif


%prep
%setup -q -n %{pypi_name}-%{version}
%patch0001 -p1

# Upstream dropped pep8 tests, they are no longer maintained:
# https://bitbucket.org/blockdiag/seqdiag/commits/671b4b5
rm src/*/tests/test_pep8.py

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
find %{py3dir} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'
%endif

find           -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python2}|'


%build
%{__python2} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif


%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root %{buildroot}
mv %{buildroot}%{_bindir}/%{pypi_name} %{buildroot}%{_bindir}/%{pypi_name}-%{python3_version}
install -m 0644 -D %{pypi_name}.1 %{buildroot}%{_mandir}/man1/%{pypi_name}-%{python3_version}.1
popd
%endif

%{__python2} setup.py install -O1 --skip-build --root %{buildroot}
install -m 0644 -D %{pypi_name}.1 %{buildroot}%{_mandir}/man1/%{pypi_name}.1


%check
%{__python2} setup.py test

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py test
popd
%endif


%files
%doc LICENSE
%{_bindir}/%{pypi_name}
%{_mandir}/man1/%{pypi_name}.1*
%{python2_sitelib}/%{pypi_name}*
%exclude %{python2_sitelib}/%{pypi_name}/tests

%if 0%{?with_python3}
%files -n python3-%{pypi_name}
%{_pkgdocdir}
%{_bindir}/%{pypi_name}-%{python3_version}
%{_mandir}/man1/%{pypi_name}-%{python3_version}.1*
%{python3_sitelib}/__pycache__/*
%{python3_sitelib}/%{pypi_name}*
%exclude %{python3_sitelib}/%{pypi_name}/tests
%endif


%changelog
* Tue Jul 19 2016 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.9.5-6
- https://fedoraproject.org/wiki/Changes/Automatic_Provides_for_Python_RPM_Packages

* Mon Feb 22 2016 Dridi Boukelmoune <dridi.boukelmoune@gmail.com> - 0.9.5-5
- Drop pep8 test retired upstream

* Thu Feb 04 2016 Fedora Release Engineering <releng@fedoraproject.org> - 0.9.5-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Tue Nov 10 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.9.5-3
- Rebuilt for https://fedoraproject.org/wiki/Changes/python3.5

* Sat Sep  5 2015 Haïkel Guémar <hguemar@fedoraproject.org> - 0.9.5-2
- Enable python3 subpackage

* Wed Aug 26 2015 Haïkel Guémar <hguemar@fedoraproject.org> - 0.9.5-1
- Upstream 0.9.5

* Thu Jun 18 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.9.0-5
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Sat Jun 07 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.9.0-4
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Mon May 19 2014 Bohuslav Kabrda <bkabrda@redhat.com> - 0.9.0-3
- Rebuilt for https://fedoraproject.org/wiki/Changes/Python_3.4

* Tue Mar 04 2014 Dridi Boukelmoune <dridi.boukelmoune@gmail.com> - 0.9.0-2
- Fixed changelog format.
- Fixed man page permissions.

* Sun Mar 02 2014 Dridi Boukelmoune <dridi.boukelmoune@gmail.com> - 0.9.0-1
- Initial version.
