%global gem_name asciidoctor-diagram
%global mandir %{_mandir}/man1

%define pre %nil

Summary:       An extension for asciidoctor that adds support for UML diagram generation using PlantUML
Name:          rubygem-%{gem_name}
Version:       1.5.5
Release:       0%{?dist}
Group:         Development/Languages
License:       MIT
URL:           https://github.com/asciidoctor/asciidoctor-diagram
Source0:       https://rubygems.org/gems/%{gem_name}-%{version}%{pre}.gem
BuildRoot:     %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:     noarch
Patch0:        asciidoc-diagram-Updated-to-be-ruby-1.8-compatible.patch

%if 0%{?fedora} >= 19 || 0%{?el7}
Requires:      ruby(release)
BuildRequires: ruby(release)
%endif
%if 0%{?el6}
Requires:      ruby(abi) = 1.8
BuildRequires: ruby(abi) = 1.8
%endif
Requires:      ruby(rubygems)
Requires:      rubygem(asciidoctor) => 1.5.0
Requires:      rubygem(json)
Requires:      graphviz
Requires:      ImageMagick
Requires:      java-devel >= 1.7
Requires:      python-actdiag
Requires:      python-blockdiag
Requires:      python-nwdiag
Requires:      python-seqdiag

BuildRequires: rubygems-devel
BuildRequires: ruby

Provides:      rubygem(%{gem_name}) = %{version}

%if %{?pre:1}
%global gem_instdir %{gem_dir}/gems/%{gem_name}-%{version}%{pre}
%global gem_cache   %{gem_dir}/cache/%{gem_name}-%{version}%{pre}.gem
%global gem_spec    %{gem_dir}/specifications/%{gem_name}-%{version}%{pre}.gemspec
%global gem_docdir  %{gem_dir}/doc/%{gem_name}-%{version}%{pre}
%endif

%description
Asciidoctor diagramming extension.

%package doc
Summary: Documentation for %{name}
Group: Documentation
Requires: %{name} = %{version}-%{release}
BuildArch: noarch

%description doc
Documentation for %{name}

%prep
gem unpack %{SOURCE0}

%setup -q -D -T -n  %{gem_name}-%{version}

gem spec %{SOURCE0} -l --ruby > %{gem_name}.gemspec

%if 0%{?el6}
# RHEL 6 uses Ruby 1.8 which doesn't have requires_relative, so patch to only use requires
%patch0 -p1
sed -i 's;s.files = \[;s.files = \["lib/asciidoctor-diagram/util/open3.rb", ;' %{gem_name}.gemspec
%endif

%build
# Create the gem as gem install only works on a gem file
gem build %{gem_name}.gemspec

# %%gem_install compiles any C extensions and installs the gem into ./%%gem_dir
# by default, so that we can move it into the buildroot in %%install
%gem_install

%install
mkdir -p %{buildroot}%{gem_dir}
cp -a .%{gem_dir}/* \
        %{buildroot}%{gem_dir}/

rm -rf %{buildroot}%{gem_instdir}/.yardoc

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%dir %{gem_instdir}
%doc %{gem_instdir}/CHANGELOG.adoc
%doc %{gem_instdir}/LICENSE.txt
%doc %{gem_instdir}/README*.*
%exclude %{gem_instdir}/Rakefile
%exclude %{gem_instdir}/spec
%{gem_libdir}
%exclude %{gem_cache}
%{gem_spec}

%files doc
%defattr(-,root,root,-)
%doc %{gem_docdir}
%{gem_instdir}/examples/
%{gem_instdir}/images/

%changelog
* Mon Aug 21 2017 Lee Newson - 1.5.5-0
- Updated to upstream version 1.5.5.

* Tue Jun 28 2016 Lee Newson - 1.2.1-4
- Fixed missing dependencies.

* Tue Jan 27 2015 Lee Newson - 1.2.1-1
- Initial package