/* eslint-env node, es6 */
const functionCall = Function.call;
const Opal = require('opal-runtime').Opal;
// save and restore Function.call until https://github.com/opal/opal/issues/1846 is fixed
Function.call = functionCall;

// Node module
(function (root, factory) {
  module.exports = factory;
// eslint-disable-next-line no-unused-vars
}(this, function (moduleConfig) {
/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/electron/io"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $send = Opal.send, $gvars = Opal.gvars, $writer = nil;
  if ($gvars.stdout == null) $gvars.stdout = nil;
  if ($gvars.stderr == null) $gvars.stderr = nil;

  Opal.add_stubs(['$write_proc=', '$-']);
  
  
  $writer = [function(s){console.log(s)}];
  $send($gvars.stdout, 'write_proc=', Opal.to_a($writer));
  $writer[$rb_minus($writer["length"], 1)];;
  
  $writer = [function(s){console.error(s)}];
  $send($gvars.stderr, 'write_proc=', Opal.to_a($writer));
  return $writer[$rb_minus($writer["length"], 1)];;
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/node"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$==', '$require']);
  
  
  var isElectron = typeof navigator === 'object' && typeof navigator.userAgent === 'string' && typeof navigator.userAgent.indexOf('Electron') !== -1,
      platform,
      engine,
      framework,
      ioModule;

  if (typeof moduleConfig === 'object' && typeof moduleConfig.runtime === 'object') {
    var runtime = moduleConfig.runtime;
    platform = runtime.platform;
    engine = runtime.engine;
    framework = runtime.framework;
    ioModule = runtime.ioModule;
  }

  ioModule = ioModule || 'node';
  platform = platform || 'node';
  engine = engine || 'v8';
  if (isElectron) {
    framework = framework || 'electron';
  } else {
    framework = framework || '';
  }
;
  Opal.const_set($nesting[0], 'JAVASCRIPT_IO_MODULE', ioModule);
  Opal.const_set($nesting[0], 'JAVASCRIPT_PLATFORM', platform);
  Opal.const_set($nesting[0], 'JAVASCRIPT_ENGINE', engine);
  Opal.const_set($nesting[0], 'JAVASCRIPT_FRAMEWORK', framework);
  if ($$($nesting, 'JAVASCRIPT_FRAMEWORK')['$==']("electron")) {
    self.$require("asciidoctor/js/opal_ext/electron/io")};
  
// Load Opal modules
Opal.load("pathname");
Opal.load("base64");
Opal.load("open-uri");
Opal.load("nodejs");
;
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["set"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send, $module = Opal.module;

  Opal.add_stubs(['$include', '$new', '$nil?', '$===', '$raise', '$each', '$add', '$merge', '$class', '$respond_to?', '$subtract', '$dup', '$join', '$to_a', '$equal?', '$instance_of?', '$==', '$instance_variable_get', '$is_a?', '$size', '$all?', '$include?', '$[]=', '$-', '$enum_for', '$[]', '$<<', '$replace', '$delete', '$select', '$each_key', '$to_proc', '$empty?', '$eql?', '$instance_eval', '$clear', '$<', '$<=', '$keys']);
  
  (function($base, $super, $parent_nesting) {
    function $Set(){};
    var self = $Set = $klass($base, $super, 'Set', $Set);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Set_$$_1, TMP_Set_initialize_2, TMP_Set_dup_4, TMP_Set_$_5, TMP_Set_inspect_6, TMP_Set_$eq$eq_7, TMP_Set_add_9, TMP_Set_classify_10, TMP_Set_collect$B_13, TMP_Set_delete_15, TMP_Set_delete$q_16, TMP_Set_delete_if_17, TMP_Set_add$q_20, TMP_Set_each_21, TMP_Set_empty$q_22, TMP_Set_eql$q_23, TMP_Set_clear_25, TMP_Set_include$q_26, TMP_Set_merge_27, TMP_Set_replace_29, TMP_Set_size_30, TMP_Set_subtract_31, TMP_Set_$_33, TMP_Set_superset$q_34, TMP_Set_proper_superset$q_36, TMP_Set_subset$q_38, TMP_Set_proper_subset$q_40, TMP_Set_to_a_42;

    def.hash = nil;
    
    self.$include($$($nesting, 'Enumerable'));
    Opal.defs(self, '$[]', TMP_Set_$$_1 = function($a) {
      var $post_args, ary, self = this;

      
      
      $post_args = Opal.slice.call(arguments, 0, arguments.length);
      
      ary = $post_args;;
      return self.$new(ary);
    }, TMP_Set_$$_1.$$arity = -1);
    
    Opal.def(self, '$initialize', TMP_Set_initialize_2 = function $$initialize(enum$) {
      var $iter = TMP_Set_initialize_2.$$p, block = $iter || nil, TMP_3, self = this;

      if ($iter) TMP_Set_initialize_2.$$p = null;
      
      
      if ($iter) TMP_Set_initialize_2.$$p = null;;
      
      if (enum$ == null) {
        enum$ = nil;
      };
      self.hash = $hash2([], {});
      if ($truthy(enum$['$nil?']())) {
        return nil};
      if ($truthy($$($nesting, 'Enumerable')['$==='](enum$))) {
      } else {
        self.$raise($$($nesting, 'ArgumentError'), "value must be enumerable")
      };
      if ($truthy(block)) {
        return $send(enum$, 'each', [], (TMP_3 = function(item){var self = TMP_3.$$s || this;

        
          
          if (item == null) {
            item = nil;
          };
          return self.$add(Opal.yield1(block, item));}, TMP_3.$$s = self, TMP_3.$$arity = 1, TMP_3))
      } else {
        return self.$merge(enum$)
      };
    }, TMP_Set_initialize_2.$$arity = -1);
    
    Opal.def(self, '$dup', TMP_Set_dup_4 = function $$dup() {
      var self = this, result = nil;

      
      result = self.$class().$new();
      return result.$merge(self);
    }, TMP_Set_dup_4.$$arity = 0);
    
    Opal.def(self, '$-', TMP_Set_$_5 = function(enum$) {
      var self = this;

      
      if ($truthy(enum$['$respond_to?']("each"))) {
      } else {
        self.$raise($$($nesting, 'ArgumentError'), "value must be enumerable")
      };
      return self.$dup().$subtract(enum$);
    }, TMP_Set_$_5.$$arity = 1);
    Opal.alias(self, "difference", "-");
    
    Opal.def(self, '$inspect', TMP_Set_inspect_6 = function $$inspect() {
      var self = this;

      return "" + "#<Set: {" + (self.$to_a().$join(",")) + "}>"
    }, TMP_Set_inspect_6.$$arity = 0);
    
    Opal.def(self, '$==', TMP_Set_$eq$eq_7 = function(other) {
      var $a, TMP_8, self = this;

      if ($truthy(self['$equal?'](other))) {
        return true
      } else if ($truthy(other['$instance_of?'](self.$class()))) {
        return self.hash['$=='](other.$instance_variable_get("@hash"))
      } else if ($truthy(($truthy($a = other['$is_a?']($$($nesting, 'Set'))) ? self.$size()['$=='](other.$size()) : $a))) {
        return $send(other, 'all?', [], (TMP_8 = function(o){var self = TMP_8.$$s || this;
          if (self.hash == null) self.hash = nil;

        
          
          if (o == null) {
            o = nil;
          };
          return self.hash['$include?'](o);}, TMP_8.$$s = self, TMP_8.$$arity = 1, TMP_8))
      } else {
        return false
      }
    }, TMP_Set_$eq$eq_7.$$arity = 1);
    
    Opal.def(self, '$add', TMP_Set_add_9 = function $$add(o) {
      var self = this, $writer = nil;

      
      
      $writer = [o, true];
      $send(self.hash, '[]=', Opal.to_a($writer));
      $writer[$rb_minus($writer["length"], 1)];;
      return self;
    }, TMP_Set_add_9.$$arity = 1);
    Opal.alias(self, "<<", "add");
    
    Opal.def(self, '$classify', TMP_Set_classify_10 = function $$classify() {
      var $iter = TMP_Set_classify_10.$$p, block = $iter || nil, TMP_11, TMP_12, self = this, result = nil;

      if ($iter) TMP_Set_classify_10.$$p = null;
      
      
      if ($iter) TMP_Set_classify_10.$$p = null;;
      if ((block !== nil)) {
      } else {
        return self.$enum_for("classify")
      };
      result = $send($$($nesting, 'Hash'), 'new', [], (TMP_11 = function(h, k){var self = TMP_11.$$s || this, $writer = nil;

      
        
        if (h == null) {
          h = nil;
        };
        
        if (k == null) {
          k = nil;
        };
        $writer = [k, self.$class().$new()];
        $send(h, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];}, TMP_11.$$s = self, TMP_11.$$arity = 2, TMP_11));
      $send(self, 'each', [], (TMP_12 = function(item){var self = TMP_12.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return result['$[]'](Opal.yield1(block, item)).$add(item);}, TMP_12.$$s = self, TMP_12.$$arity = 1, TMP_12));
      return result;
    }, TMP_Set_classify_10.$$arity = 0);
    
    Opal.def(self, '$collect!', TMP_Set_collect$B_13 = function() {
      var $iter = TMP_Set_collect$B_13.$$p, block = $iter || nil, TMP_14, self = this, result = nil;

      if ($iter) TMP_Set_collect$B_13.$$p = null;
      
      
      if ($iter) TMP_Set_collect$B_13.$$p = null;;
      if ((block !== nil)) {
      } else {
        return self.$enum_for("collect!")
      };
      result = self.$class().$new();
      $send(self, 'each', [], (TMP_14 = function(item){var self = TMP_14.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return result['$<<'](Opal.yield1(block, item));}, TMP_14.$$s = self, TMP_14.$$arity = 1, TMP_14));
      return self.$replace(result);
    }, TMP_Set_collect$B_13.$$arity = 0);
    Opal.alias(self, "map!", "collect!");
    
    Opal.def(self, '$delete', TMP_Set_delete_15 = function(o) {
      var self = this;

      
      self.hash.$delete(o);
      return self;
    }, TMP_Set_delete_15.$$arity = 1);
    
    Opal.def(self, '$delete?', TMP_Set_delete$q_16 = function(o) {
      var self = this;

      if ($truthy(self['$include?'](o))) {
        
        self.$delete(o);
        return self;
      } else {
        return nil
      }
    }, TMP_Set_delete$q_16.$$arity = 1);
    
    Opal.def(self, '$delete_if', TMP_Set_delete_if_17 = function $$delete_if() {
      var TMP_18, TMP_19, $iter = TMP_Set_delete_if_17.$$p, $yield = $iter || nil, self = this;

      if ($iter) TMP_Set_delete_if_17.$$p = null;
      
      if (($yield !== nil)) {
      } else {
        return self.$enum_for("delete_if")
      };
      $send($send(self, 'select', [], (TMP_18 = function(o){var self = TMP_18.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return Opal.yield1($yield, o);;}, TMP_18.$$s = self, TMP_18.$$arity = 1, TMP_18)), 'each', [], (TMP_19 = function(o){var self = TMP_19.$$s || this;
        if (self.hash == null) self.hash = nil;

      
        
        if (o == null) {
          o = nil;
        };
        return self.hash.$delete(o);}, TMP_19.$$s = self, TMP_19.$$arity = 1, TMP_19));
      return self;
    }, TMP_Set_delete_if_17.$$arity = 0);
    
    Opal.def(self, '$add?', TMP_Set_add$q_20 = function(o) {
      var self = this;

      if ($truthy(self['$include?'](o))) {
        return nil
      } else {
        return self.$add(o)
      }
    }, TMP_Set_add$q_20.$$arity = 1);
    
    Opal.def(self, '$each', TMP_Set_each_21 = function $$each() {
      var $iter = TMP_Set_each_21.$$p, block = $iter || nil, self = this;

      if ($iter) TMP_Set_each_21.$$p = null;
      
      
      if ($iter) TMP_Set_each_21.$$p = null;;
      if ((block !== nil)) {
      } else {
        return self.$enum_for("each")
      };
      $send(self.hash, 'each_key', [], block.$to_proc());
      return self;
    }, TMP_Set_each_21.$$arity = 0);
    
    Opal.def(self, '$empty?', TMP_Set_empty$q_22 = function() {
      var self = this;

      return self.hash['$empty?']()
    }, TMP_Set_empty$q_22.$$arity = 0);
    
    Opal.def(self, '$eql?', TMP_Set_eql$q_23 = function(other) {
      var TMP_24, self = this;

      return self.hash['$eql?']($send(other, 'instance_eval', [], (TMP_24 = function(){var self = TMP_24.$$s || this;
        if (self.hash == null) self.hash = nil;

      return self.hash}, TMP_24.$$s = self, TMP_24.$$arity = 0, TMP_24)))
    }, TMP_Set_eql$q_23.$$arity = 1);
    
    Opal.def(self, '$clear', TMP_Set_clear_25 = function $$clear() {
      var self = this;

      
      self.hash.$clear();
      return self;
    }, TMP_Set_clear_25.$$arity = 0);
    
    Opal.def(self, '$include?', TMP_Set_include$q_26 = function(o) {
      var self = this;

      return self.hash['$include?'](o)
    }, TMP_Set_include$q_26.$$arity = 1);
    Opal.alias(self, "member?", "include?");
    
    Opal.def(self, '$merge', TMP_Set_merge_27 = function $$merge(enum$) {
      var TMP_28, self = this;

      
      $send(enum$, 'each', [], (TMP_28 = function(item){var self = TMP_28.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return self.$add(item);}, TMP_28.$$s = self, TMP_28.$$arity = 1, TMP_28));
      return self;
    }, TMP_Set_merge_27.$$arity = 1);
    
    Opal.def(self, '$replace', TMP_Set_replace_29 = function $$replace(enum$) {
      var self = this;

      
      self.$clear();
      self.$merge(enum$);
      return self;
    }, TMP_Set_replace_29.$$arity = 1);
    
    Opal.def(self, '$size', TMP_Set_size_30 = function $$size() {
      var self = this;

      return self.hash.$size()
    }, TMP_Set_size_30.$$arity = 0);
    Opal.alias(self, "length", "size");
    
    Opal.def(self, '$subtract', TMP_Set_subtract_31 = function $$subtract(enum$) {
      var TMP_32, self = this;

      
      $send(enum$, 'each', [], (TMP_32 = function(item){var self = TMP_32.$$s || this;

      
        
        if (item == null) {
          item = nil;
        };
        return self.$delete(item);}, TMP_32.$$s = self, TMP_32.$$arity = 1, TMP_32));
      return self;
    }, TMP_Set_subtract_31.$$arity = 1);
    
    Opal.def(self, '$|', TMP_Set_$_33 = function(enum$) {
      var self = this;

      
      if ($truthy(enum$['$respond_to?']("each"))) {
      } else {
        self.$raise($$($nesting, 'ArgumentError'), "value must be enumerable")
      };
      return self.$dup().$merge(enum$);
    }, TMP_Set_$_33.$$arity = 1);
    
    Opal.def(self, '$superset?', TMP_Set_superset$q_34 = function(set) {
      var $a, TMP_35, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_lt(self.$size(), set.$size()))) {
        return false};
      return $send(set, 'all?', [], (TMP_35 = function(o){var self = TMP_35.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return self['$include?'](o);}, TMP_35.$$s = self, TMP_35.$$arity = 1, TMP_35));
    }, TMP_Set_superset$q_34.$$arity = 1);
    Opal.alias(self, ">=", "superset?");
    
    Opal.def(self, '$proper_superset?', TMP_Set_proper_superset$q_36 = function(set) {
      var $a, TMP_37, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_le(self.$size(), set.$size()))) {
        return false};
      return $send(set, 'all?', [], (TMP_37 = function(o){var self = TMP_37.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return self['$include?'](o);}, TMP_37.$$s = self, TMP_37.$$arity = 1, TMP_37));
    }, TMP_Set_proper_superset$q_36.$$arity = 1);
    Opal.alias(self, ">", "proper_superset?");
    
    Opal.def(self, '$subset?', TMP_Set_subset$q_38 = function(set) {
      var $a, TMP_39, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_lt(set.$size(), self.$size()))) {
        return false};
      return $send(self, 'all?', [], (TMP_39 = function(o){var self = TMP_39.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return set['$include?'](o);}, TMP_39.$$s = self, TMP_39.$$arity = 1, TMP_39));
    }, TMP_Set_subset$q_38.$$arity = 1);
    Opal.alias(self, "<=", "subset?");
    
    Opal.def(self, '$proper_subset?', TMP_Set_proper_subset$q_40 = function(set) {
      var $a, TMP_41, self = this;

      
      ($truthy($a = set['$is_a?']($$($nesting, 'Set'))) ? $a : self.$raise($$($nesting, 'ArgumentError'), "value must be a set"));
      if ($truthy($rb_le(set.$size(), self.$size()))) {
        return false};
      return $send(self, 'all?', [], (TMP_41 = function(o){var self = TMP_41.$$s || this;

      
        
        if (o == null) {
          o = nil;
        };
        return set['$include?'](o);}, TMP_41.$$s = self, TMP_41.$$arity = 1, TMP_41));
    }, TMP_Set_proper_subset$q_40.$$arity = 1);
    Opal.alias(self, "<", "proper_subset?");
    Opal.alias(self, "+", "|");
    Opal.alias(self, "union", "|");
    return (Opal.def(self, '$to_a', TMP_Set_to_a_42 = function $$to_a() {
      var self = this;

      return self.hash.$keys()
    }, TMP_Set_to_a_42.$$arity = 0), nil) && 'to_a';
  })($nesting[0], null, $nesting);
  return (function($base, $parent_nesting) {
    function $Enumerable() {};
    var self = $Enumerable = $module($base, 'Enumerable', $Enumerable);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Enumerable_to_set_43;

    
    Opal.def(self, '$to_set', TMP_Enumerable_to_set_43 = function $$to_set($a, $b) {
      var $iter = TMP_Enumerable_to_set_43.$$p, block = $iter || nil, $post_args, klass, args, self = this;

      if ($iter) TMP_Enumerable_to_set_43.$$p = null;
      
      
      if ($iter) TMP_Enumerable_to_set_43.$$p = null;;
      
      $post_args = Opal.slice.call(arguments, 0, arguments.length);
      
      if ($post_args.length > 0) {
        klass = $post_args[0];
        $post_args.splice(0, 1);
      }
      if (klass == null) {
        klass = $$($nesting, 'Set');
      };
      
      args = $post_args;;
      return $send(klass, 'new', [self].concat(Opal.to_a(args)), block.$to_proc());
    }, TMP_Enumerable_to_set_43.$$arity = -1)
  })($nesting[0], $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/file"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $send = Opal.send, $klass = Opal.klass, $truthy = Opal.truthy, $gvars = Opal.gvars;

  Opal.add_stubs(['$new', '$attr_reader', '$delete', '$gsub', '$read', '$size', '$to_enum', '$chomp', '$each_line', '$readlines', '$split']);
  
  (function($base, $parent_nesting) {
    function $Kernel() {};
    var self = $Kernel = $module($base, 'Kernel', $Kernel);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Kernel_open_1;

    
    Opal.def(self, '$open', TMP_Kernel_open_1 = function $$open(path, $a) {
      var $post_args, rest, $iter = TMP_Kernel_open_1.$$p, $yield = $iter || nil, self = this, file = nil;

      if ($iter) TMP_Kernel_open_1.$$p = null;
      
      
      $post_args = Opal.slice.call(arguments, 1, arguments.length);
      
      rest = $post_args;;
      file = $send($$($nesting, 'File'), 'new', [path].concat(Opal.to_a(rest)));
      if (($yield !== nil)) {
        return Opal.yield1($yield, file);
      } else {
        return file
      };
    }, TMP_Kernel_open_1.$$arity = -2)
  })($nesting[0], $nesting);
  (function($base, $super, $parent_nesting) {
    function $File(){};
    var self = $File = $klass($base, $super, 'File', $File);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_File_initialize_2, TMP_File_read_3, TMP_File_each_line_4, TMP_File_readlines_5;

    def.eof = def.path = nil;
    
    self.$attr_reader("eof");
    self.$attr_reader("lineno");
    self.$attr_reader("path");
    
    Opal.def(self, '$initialize', TMP_File_initialize_2 = function $$initialize(path, flags) {
      var self = this, encoding_flag_regexp = nil;

      
      
      if (flags == null) {
        flags = "r";
      };
      self.path = path;
      self.contents = nil;
      self.eof = false;
      self.lineno = 0;
      flags = flags.$delete("b");
      encoding_flag_regexp = /:(.*)/;
      flags = flags.$gsub(encoding_flag_regexp, "");
      return (self.flags = flags);
    }, TMP_File_initialize_2.$$arity = -2);
    
    Opal.def(self, '$read', TMP_File_read_3 = function $$read() {
      var self = this, res = nil;

      if ($truthy(self.eof)) {
        return ""
      } else {
        
        res = $$($nesting, 'File').$read(self.path);
        self.eof = true;
        self.lineno = res.$size();
        return res;
      }
    }, TMP_File_read_3.$$arity = 0);
    
    Opal.def(self, '$each_line', TMP_File_each_line_4 = function $$each_line(separator) {
      var $iter = TMP_File_each_line_4.$$p, block = $iter || nil, self = this, lines = nil;
      if ($gvars["/"] == null) $gvars["/"] = nil;

      if ($iter) TMP_File_each_line_4.$$p = null;
      
      
      if ($iter) TMP_File_each_line_4.$$p = null;;
      
      if (separator == null) {
        separator = $gvars["/"];
      };
      if ($truthy(self.eof)) {
        return (function() {if ((block !== nil)) {
          return self
        } else {
          return [].$to_enum()
        }; return nil; })()};
      if ((block !== nil)) {
        
        lines = $$($nesting, 'File').$read(self.path);
        
        self.eof = false;
        self.lineno = 0;
        var chomped  = lines.$chomp(),
            trailing = lines.length != chomped.length,
            splitted = chomped.split(separator);
        for (var i = 0, length = splitted.length; i < length; i++) {
          self.lineno += 1;
          if (i < length - 1 || trailing) {
            Opal.yield1(block, splitted[i] + separator);
          }
          else {
            Opal.yield1(block, splitted[i]);
          }
        }
        self.eof = true;
      ;
        return self;
      } else {
        return self.$read().$each_line()
      };
    }, TMP_File_each_line_4.$$arity = -1);
    
    Opal.def(self, '$readlines', TMP_File_readlines_5 = function $$readlines() {
      var self = this;

      return $$($nesting, 'File').$readlines(self.path)
    }, TMP_File_readlines_5.$$arity = 0);
    return (function(self, $parent_nesting) {
      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_readlines_6, TMP_file$q_7, TMP_readable$q_8, TMP_read_9;

      
      
      Opal.def(self, '$readlines', TMP_readlines_6 = function $$readlines(path, separator) {
        var self = this, content = nil;
        if ($gvars["/"] == null) $gvars["/"] = nil;

        
        
        if (separator == null) {
          separator = $gvars["/"];
        };
        content = $$($nesting, 'File').$read(path);
        return content.$split(separator);
      }, TMP_readlines_6.$$arity = -2);
      
      Opal.def(self, '$file?', TMP_file$q_7 = function(path) {
        var self = this;

        return true
      }, TMP_file$q_7.$$arity = 1);
      
      Opal.def(self, '$readable?', TMP_readable$q_8 = function(path) {
        var self = this;

        return true
      }, TMP_readable$q_8.$$arity = 1);
      return (Opal.def(self, '$read', TMP_read_9 = function $$read(path) {
        var self = this;

        return ""
      }, TMP_read_9.$$arity = 1), nil) && 'read';
    })(Opal.get_singleton_class(self), $nesting);
  })($nesting[0], null, $nesting);
  return (function($base, $super, $parent_nesting) {
    function $IO(){};
    var self = $IO = $klass($base, $super, 'IO', $IO);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_IO_read_10;

    return (Opal.defs(self, '$read', TMP_IO_read_10 = function $$read(path) {
      var self = this;

      return $$($nesting, 'File').$read(path)
    }, TMP_IO_read_10.$$arity = 1), nil) && 'read'
  })($nesting[0], null, $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/match_data"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $send = Opal.send;

  Opal.add_stubs(['$[]=', '$-']);
  return (function($base, $super, $parent_nesting) {
    function $MatchData(){};
    var self = $MatchData = $klass($base, $super, 'MatchData', $MatchData);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_MatchData_$$$eq_1;

    def.matches = nil;
    return (Opal.def(self, '$[]=', TMP_MatchData_$$$eq_1 = function(idx, val) {
      var self = this, $writer = nil;

      
      $writer = [idx, val];
      $send(self.matches, '[]=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];
    }, TMP_MatchData_$$$eq_1.$$arity = 2), nil) && '[]='
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/kernel"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module;

  return (function($base, $parent_nesting) {
    function $Kernel() {};
    var self = $Kernel = $module($base, 'Kernel', $Kernel);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Kernel_freeze_1;

    
    Opal.def(self, '$freeze', TMP_Kernel_freeze_1 = function $$freeze() {
      var self = this;

      return self
    }, TMP_Kernel_freeze_1.$$arity = 0)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/thread_safe"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass;

  return (function($base, $parent_nesting) {
    function $ThreadSafe() {};
    var self = $ThreadSafe = $module($base, 'ThreadSafe', $ThreadSafe);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Cache(){};
      var self = $Cache = $klass($base, $super, 'Cache', $Cache);

      var def = self.prototype, $nesting = [self].concat($parent_nesting);

      return nil
    })($nesting[0], $$$('::', 'Hash'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/string"] = function(Opal) {
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$method_defined?', '$<', '$length', '$bytes', '$to_s', '$byteslice', '$==', '$with_index', '$select', '$[]', '$even?', '$_original_unpack']);
  return (function($base, $super, $parent_nesting) {
    function $String(){};
    var self = $String = $klass($base, $super, 'String', $String);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_String_limit_bytesize_1, TMP_String_unpack_2;

    
    if ($truthy(self['$method_defined?']("limit_bytesize"))) {
    } else {
      
      Opal.def(self, '$limit_bytesize', TMP_String_limit_bytesize_1 = function $$limit_bytesize(size) {
        var self = this, result = nil;

        
        if ($truthy($rb_lt(size, self.$bytes().$length()))) {
        } else {
          return self.$to_s()
        };
        result = self.$byteslice(0, size);
        return result.$to_s();
      }, TMP_String_limit_bytesize_1.$$arity = 1)
    };
    if ($truthy(self['$method_defined?']("limit"))) {
    } else {
      Opal.alias(self, "limit", "limit_bytesize")
    };
    Opal.alias(self, "_original_unpack", "unpack");
    return (Opal.def(self, '$unpack', TMP_String_unpack_2 = function $$unpack(format) {
      var TMP_3, self = this;

      if (format['$==']("C3")) {
        return $send(self['$[]'](0, 3).$bytes().$select(), 'with_index', [], (TMP_3 = function(_, i){var self = TMP_3.$$s || this;

        
          
          if (_ == null) {
            _ = nil;
          };
          
          if (i == null) {
            i = nil;
          };
          return i['$even?']();}, TMP_3.$$s = self, TMP_3.$$arity = 2, TMP_3))
      } else {
        return self.$_original_unpack(format)
      }
    }, TMP_String_unpack_2.$$arity = 1), nil) && 'unpack';
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/uri"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module;

  Opal.add_stubs(['$extend']);
  return (function($base, $parent_nesting) {
    function $URI() {};
    var self = $URI = $module($base, 'URI', $URI);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_URI_parse_1, TMP_URI_path_2;

    
    Opal.defs(self, '$parse', TMP_URI_parse_1 = function $$parse(str) {
      var self = this;

      return str.$extend($$($nesting, 'URI'))
    }, TMP_URI_parse_1.$$arity = 1);
    
    Opal.def(self, '$path', TMP_URI_path_2 = function $$path() {
      var self = this;

      return self
    }, TMP_URI_path_2.$$arity = 0);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$require']);
  
  self.$require("asciidoctor/js/opal_ext/file");
  self.$require("asciidoctor/js/opal_ext/match_data");
  self.$require("asciidoctor/js/opal_ext/kernel");
  self.$require("asciidoctor/js/opal_ext/thread_safe");
  self.$require("asciidoctor/js/opal_ext/string");
  self.$require("asciidoctor/js/opal_ext/uri");
  
// Load specific implementation
self.$require("asciidoctor/js/opal_ext/node");
;
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/rx"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $send = Opal.send, $gvars = Opal.gvars, $truthy = Opal.truthy;

  Opal.add_stubs(['$gsub', '$+', '$unpack_hex_range']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Asciidoctor_unpack_hex_range_1;

    
    Opal.const_set($nesting[0], 'HEX_RANGE_RX', /([A-F0-9]{4})(?:-([A-F0-9]{4}))?/);
    Opal.defs(self, '$unpack_hex_range', TMP_Asciidoctor_unpack_hex_range_1 = function $$unpack_hex_range(str) {
      var TMP_2, self = this;

      return $send(str, 'gsub', [$$($nesting, 'HEX_RANGE_RX')], (TMP_2 = function(){var self = TMP_2.$$s || this, $a, $b;

      return "" + "\\u" + ((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))) + (($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](2))) ? "" + "-\\u" + ((($b = $gvars['~']) === nil ? nil : $b['$[]'](2))) : $a))}, TMP_2.$$s = self, TMP_2.$$arity = 0, TMP_2))
    }, TMP_Asciidoctor_unpack_hex_range_1.$$arity = 1);
    Opal.const_set($nesting[0], 'P_L', $rb_plus("A-Za-z", self.$unpack_hex_range("00AA00B500BA00C0-00D600D8-00F600F8-02C102C6-02D102E0-02E402EC02EE0370-037403760377037A-037D037F03860388-038A038C038E-03A103A3-03F503F7-0481048A-052F0531-055605590561-058705D0-05EA05F0-05F20620-064A066E066F0671-06D306D506E506E606EE06EF06FA-06FC06FF07100712-072F074D-07A507B107CA-07EA07F407F507FA0800-0815081A082408280840-085808A0-08B20904-0939093D09500958-09610971-09800985-098C098F09900993-09A809AA-09B009B209B6-09B909BD09CE09DC09DD09DF-09E109F009F10A05-0A0A0A0F0A100A13-0A280A2A-0A300A320A330A350A360A380A390A59-0A5C0A5E0A72-0A740A85-0A8D0A8F-0A910A93-0AA80AAA-0AB00AB20AB30AB5-0AB90ABD0AD00AE00AE10B05-0B0C0B0F0B100B13-0B280B2A-0B300B320B330B35-0B390B3D0B5C0B5D0B5F-0B610B710B830B85-0B8A0B8E-0B900B92-0B950B990B9A0B9C0B9E0B9F0BA30BA40BA8-0BAA0BAE-0BB90BD00C05-0C0C0C0E-0C100C12-0C280C2A-0C390C3D0C580C590C600C610C85-0C8C0C8E-0C900C92-0CA80CAA-0CB30CB5-0CB90CBD0CDE0CE00CE10CF10CF20D05-0D0C0D0E-0D100D12-0D3A0D3D0D4E0D600D610D7A-0D7F0D85-0D960D9A-0DB10DB3-0DBB0DBD0DC0-0DC60E01-0E300E320E330E40-0E460E810E820E840E870E880E8A0E8D0E94-0E970E99-0E9F0EA1-0EA30EA50EA70EAA0EAB0EAD-0EB00EB20EB30EBD0EC0-0EC40EC60EDC-0EDF0F000F40-0F470F49-0F6C0F88-0F8C1000-102A103F1050-1055105A-105D106110651066106E-10701075-1081108E10A0-10C510C710CD10D0-10FA10FC-1248124A-124D1250-12561258125A-125D1260-1288128A-128D1290-12B012B2-12B512B8-12BE12C012C2-12C512C8-12D612D8-13101312-13151318-135A1380-138F13A0-13F41401-166C166F-167F1681-169A16A0-16EA16F1-16F81700-170C170E-17111720-17311740-17511760-176C176E-17701780-17B317D717DC1820-18771880-18A818AA18B0-18F51900-191E1950-196D1970-19741980-19AB19C1-19C71A00-1A161A20-1A541AA71B05-1B331B45-1B4B1B83-1BA01BAE1BAF1BBA-1BE51C00-1C231C4D-1C4F1C5A-1C7D1CE9-1CEC1CEE-1CF11CF51CF61D00-1DBF1E00-1F151F18-1F1D1F20-1F451F48-1F4D1F50-1F571F591F5B1F5D1F5F-1F7D1F80-1FB41FB6-1FBC1FBE1FC2-1FC41FC6-1FCC1FD0-1FD31FD6-1FDB1FE0-1FEC1FF2-1FF41FF6-1FFC2071207F2090-209C21022107210A-211321152119-211D212421262128212A-212D212F-2139213C-213F2145-2149214E218321842C00-2C2E2C30-2C5E2C60-2CE42CEB-2CEE2CF22CF32D00-2D252D272D2D2D30-2D672D6F2D80-2D962DA0-2DA62DA8-2DAE2DB0-2DB62DB8-2DBE2DC0-2DC62DC8-2DCE2DD0-2DD62DD8-2DDE2E2F300530063031-3035303B303C3041-3096309D-309F30A1-30FA30FC-30FF3105-312D3131-318E31A0-31BA31F0-31FF3400-4DB54E00-9FCCA000-A48CA4D0-A4FDA500-A60CA610-A61FA62AA62BA640-A66EA67F-A69DA6A0-A6E5A717-A71FA722-A788A78B-A78EA790-A7ADA7B0A7B1A7F7-A801A803-A805A807-A80AA80C-A822A840-A873A882-A8B3A8F2-A8F7A8FBA90A-A925A930-A946A960-A97CA984-A9B2A9CFA9E0-A9E4A9E6-A9EFA9FA-A9FEAA00-AA28AA40-AA42AA44-AA4BAA60-AA76AA7AAA7E-AAAFAAB1AAB5AAB6AAB9-AABDAAC0AAC2AADB-AADDAAE0-AAEAAAF2-AAF4AB01-AB06AB09-AB0EAB11-AB16AB20-AB26AB28-AB2EAB30-AB5AAB5C-AB5FAB64AB65ABC0-ABE2AC00-D7A3D7B0-D7C6D7CB-D7FBF900-FA6DFA70-FAD9FB00-FB06FB13-FB17FB1DFB1F-FB28FB2A-FB36FB38-FB3CFB3EFB40FB41FB43FB44FB46-FBB1FBD3-FD3DFD50-FD8FFD92-FDC7FDF0-FDFBFE70-FE74FE76-FEFCFF21-FF3AFF41-FF5AFF66-FFBEFFC2-FFC7FFCA-FFCFFFD2-FFD7FFDA-FFDC")));
    Opal.const_set($nesting[0], 'P_Nl', self.$unpack_hex_range("16EE-16F02160-21822185-218830073021-30293038-303AA6E6-A6EF"));
    Opal.const_set($nesting[0], 'P_Nd', $rb_plus("0-9", self.$unpack_hex_range("0660-066906F0-06F907C0-07C90966-096F09E6-09EF0A66-0A6F0AE6-0AEF0B66-0B6F0BE6-0BEF0C66-0C6F0CE6-0CEF0D66-0D6F0DE6-0DEF0E50-0E590ED0-0ED90F20-0F291040-10491090-109917E0-17E91810-18191946-194F19D0-19D91A80-1A891A90-1A991B50-1B591BB0-1BB91C40-1C491C50-1C59A620-A629A8D0-A8D9A900-A909A9D0-A9D9A9F0-A9F9AA50-AA59ABF0-ABF9FF10-FF19")));
    Opal.const_set($nesting[0], 'P_Pc', self.$unpack_hex_range("005F203F20402054FE33FE34FE4D-FE4FFF3F"));
    Opal.const_set($nesting[0], 'CC_ALPHA', "" + ($$($nesting, 'P_L')) + ($$($nesting, 'P_Nl')));
    Opal.const_set($nesting[0], 'CG_ALPHA', "" + "[" + ($$($nesting, 'CC_ALPHA')) + "]");
    Opal.const_set($nesting[0], 'CC_ALNUM', "" + ($$($nesting, 'CC_ALPHA')) + ($$($nesting, 'P_Nd')));
    Opal.const_set($nesting[0], 'CG_ALNUM', "" + "[" + ($$($nesting, 'CC_ALNUM')) + "]");
    Opal.const_set($nesting[0], 'CC_WORD', "" + ($$($nesting, 'CC_ALNUM')) + ($$($nesting, 'P_Pc')));
    Opal.const_set($nesting[0], 'CG_WORD', "" + "[" + ($$($nesting, 'CC_WORD')) + "]");
    Opal.const_set($nesting[0], 'CG_BLANK', "[ \\t]");
    Opal.const_set($nesting[0], 'CC_EOL', "(?=\\n|$)");
    Opal.const_set($nesting[0], 'CG_GRAPH', "[^\\s\\x00-\\x1F\\x7F]");
    Opal.const_set($nesting[0], 'CC_ALL', "[\\s\\S]");
    Opal.const_set($nesting[0], 'CC_ANY', "[^\\n]");
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["strscan"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $send = Opal.send;

  Opal.add_stubs(['$attr_reader', '$anchor', '$scan_until', '$length', '$size', '$rest', '$pos=', '$-', '$private']);
  return (function($base, $super, $parent_nesting) {
    function $StringScanner(){};
    var self = $StringScanner = $klass($base, $super, 'StringScanner', $StringScanner);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_StringScanner_initialize_1, TMP_StringScanner_beginning_of_line$q_2, TMP_StringScanner_scan_3, TMP_StringScanner_scan_until_4, TMP_StringScanner_$$_5, TMP_StringScanner_check_6, TMP_StringScanner_check_until_7, TMP_StringScanner_peek_8, TMP_StringScanner_eos$q_9, TMP_StringScanner_exist$q_10, TMP_StringScanner_skip_11, TMP_StringScanner_skip_until_12, TMP_StringScanner_get_byte_13, TMP_StringScanner_match$q_14, TMP_StringScanner_pos$eq_15, TMP_StringScanner_matched_size_16, TMP_StringScanner_post_match_17, TMP_StringScanner_pre_match_18, TMP_StringScanner_reset_19, TMP_StringScanner_rest_20, TMP_StringScanner_rest$q_21, TMP_StringScanner_rest_size_22, TMP_StringScanner_terminate_23, TMP_StringScanner_unscan_24, TMP_StringScanner_anchor_25;

    def.pos = def.string = def.working = def.matched = def.prev_pos = def.match = nil;
    
    self.$attr_reader("pos");
    self.$attr_reader("matched");
    
    Opal.def(self, '$initialize', TMP_StringScanner_initialize_1 = function $$initialize(string) {
      var self = this;

      
      self.string = string;
      self.pos = 0;
      self.matched = nil;
      self.working = string;
      return (self.match = []);
    }, TMP_StringScanner_initialize_1.$$arity = 1);
    self.$attr_reader("string");
    
    Opal.def(self, '$beginning_of_line?', TMP_StringScanner_beginning_of_line$q_2 = function() {
      var self = this;

      return self.pos === 0 || self.string.charAt(self.pos - 1) === "\n"
    }, TMP_StringScanner_beginning_of_line$q_2.$$arity = 0);
    Opal.alias(self, "bol?", "beginning_of_line?");
    
    Opal.def(self, '$scan', TMP_StringScanner_scan_3 = function $$scan(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return self.matched = nil;
      }
      else if (typeof(result) === 'object') {
        self.prev_pos = self.pos;
        self.pos     += result[0].length;
        self.working  = self.working.substring(result[0].length);
        self.matched  = result[0];
        self.match    = result;

        return result[0];
      }
      else if (typeof(result) === 'string') {
        self.pos     += result.length;
        self.working  = self.working.substring(result.length);

        return result;
      }
      else {
        return nil;
      }
    ;
    }, TMP_StringScanner_scan_3.$$arity = 1);
    
    Opal.def(self, '$scan_until', TMP_StringScanner_scan_until_4 = function $$scan_until(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var pos     = self.pos,
          working = self.working,
          result;

      while (true) {
        result   = pattern.exec(working);
        pos     += 1;
        working  = working.substr(1);

        if (result == null) {
          if (working.length === 0) {
            return self.matched = nil;
          }

          continue;
        }

        self.matched  = self.string.substr(self.pos, pos - self.pos - 1 + result[0].length);
        self.prev_pos = pos - 1;
        self.pos      = pos;
        self.working  = working.substr(result[0].length);

        return self.matched;
      }
    ;
    }, TMP_StringScanner_scan_until_4.$$arity = 1);
    
    Opal.def(self, '$[]', TMP_StringScanner_$$_5 = function(idx) {
      var self = this;

      
      var match = self.match;

      if (idx < 0) {
        idx += match.length;
      }

      if (idx < 0 || idx >= match.length) {
        return nil;
      }

      if (match[idx] == null) {
        return nil;
      }

      return match[idx];
    
    }, TMP_StringScanner_$$_5.$$arity = 1);
    
    Opal.def(self, '$check', TMP_StringScanner_check_6 = function $$check(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return self.matched = nil;
      }

      return self.matched = result[0];
    ;
    }, TMP_StringScanner_check_6.$$arity = 1);
    
    Opal.def(self, '$check_until', TMP_StringScanner_check_until_7 = function $$check_until(pattern) {
      var self = this;

      
      var prev_pos = self.prev_pos,
          pos      = self.pos;

      var result = self.$scan_until(pattern);

      if (result !== nil) {
        self.matched = result.substr(-1);
        self.working = self.string.substr(pos);
      }

      self.prev_pos = prev_pos;
      self.pos      = pos;

      return result;
    
    }, TMP_StringScanner_check_until_7.$$arity = 1);
    
    Opal.def(self, '$peek', TMP_StringScanner_peek_8 = function $$peek(length) {
      var self = this;

      return self.working.substring(0, length)
    }, TMP_StringScanner_peek_8.$$arity = 1);
    
    Opal.def(self, '$eos?', TMP_StringScanner_eos$q_9 = function() {
      var self = this;

      return self.working.length === 0
    }, TMP_StringScanner_eos$q_9.$$arity = 0);
    
    Opal.def(self, '$exist?', TMP_StringScanner_exist$q_10 = function(pattern) {
      var self = this;

      
      var result = pattern.exec(self.working);

      if (result == null) {
        return nil;
      }
      else if (result.index == 0) {
        return 0;
      }
      else {
        return result.index + 1;
      }
    
    }, TMP_StringScanner_exist$q_10.$$arity = 1);
    
    Opal.def(self, '$skip', TMP_StringScanner_skip_11 = function $$skip(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return self.matched = nil;
      }
      else {
        var match_str = result[0];
        var match_len = match_str.length;

        self.matched   = match_str;
        self.prev_pos  = self.pos;
        self.pos      += match_len;
        self.working   = self.working.substring(match_len);

        return match_len;
      }
    ;
    }, TMP_StringScanner_skip_11.$$arity = 1);
    
    Opal.def(self, '$skip_until', TMP_StringScanner_skip_until_12 = function $$skip_until(pattern) {
      var self = this;

      
      var result = self.$scan_until(pattern);

      if (result === nil) {
        return nil;
      }
      else {
        self.matched = result.substr(-1);

        return result.length;
      }
    
    }, TMP_StringScanner_skip_until_12.$$arity = 1);
    
    Opal.def(self, '$get_byte', TMP_StringScanner_get_byte_13 = function $$get_byte() {
      var self = this;

      
      var result = nil;

      if (self.pos < self.string.length) {
        self.prev_pos  = self.pos;
        self.pos      += 1;
        result      = self.matched = self.working.substring(0, 1);
        self.working   = self.working.substring(1);
      }
      else {
        self.matched = nil;
      }

      return result;
    
    }, TMP_StringScanner_get_byte_13.$$arity = 0);
    Opal.alias(self, "getch", "get_byte");
    
    Opal.def(self, '$match?', TMP_StringScanner_match$q_14 = function(pattern) {
      var self = this;

      
      pattern = self.$anchor(pattern);
      
      var result = pattern.exec(self.working);

      if (result == null) {
        return nil;
      }
      else {
        self.prev_pos = self.pos;

        return result[0].length;
      }
    ;
    }, TMP_StringScanner_match$q_14.$$arity = 1);
    
    Opal.def(self, '$pos=', TMP_StringScanner_pos$eq_15 = function(pos) {
      var self = this;

      
      
      if (pos < 0) {
        pos += self.string.$length();
      }
    ;
      self.pos = pos;
      return (self.working = self.string.slice(pos));
    }, TMP_StringScanner_pos$eq_15.$$arity = 1);
    
    Opal.def(self, '$matched_size', TMP_StringScanner_matched_size_16 = function $$matched_size() {
      var self = this;

      
      if (self.matched === nil) {
        return nil;
      }

      return self.matched.length
    
    }, TMP_StringScanner_matched_size_16.$$arity = 0);
    
    Opal.def(self, '$post_match', TMP_StringScanner_post_match_17 = function $$post_match() {
      var self = this;

      
      if (self.matched === nil) {
        return nil;
      }

      return self.string.substr(self.pos);
    
    }, TMP_StringScanner_post_match_17.$$arity = 0);
    
    Opal.def(self, '$pre_match', TMP_StringScanner_pre_match_18 = function $$pre_match() {
      var self = this;

      
      if (self.matched === nil) {
        return nil;
      }

      return self.string.substr(0, self.prev_pos);
    
    }, TMP_StringScanner_pre_match_18.$$arity = 0);
    
    Opal.def(self, '$reset', TMP_StringScanner_reset_19 = function $$reset() {
      var self = this;

      
      self.working = self.string;
      self.matched = nil;
      return (self.pos = 0);
    }, TMP_StringScanner_reset_19.$$arity = 0);
    
    Opal.def(self, '$rest', TMP_StringScanner_rest_20 = function $$rest() {
      var self = this;

      return self.working
    }, TMP_StringScanner_rest_20.$$arity = 0);
    
    Opal.def(self, '$rest?', TMP_StringScanner_rest$q_21 = function() {
      var self = this;

      return self.working.length !== 0
    }, TMP_StringScanner_rest$q_21.$$arity = 0);
    
    Opal.def(self, '$rest_size', TMP_StringScanner_rest_size_22 = function $$rest_size() {
      var self = this;

      return self.$rest().$size()
    }, TMP_StringScanner_rest_size_22.$$arity = 0);
    
    Opal.def(self, '$terminate', TMP_StringScanner_terminate_23 = function $$terminate() {
      var self = this, $writer = nil;

      
      self.match = nil;
      
      $writer = [self.string.$length()];
      $send(self, 'pos=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];;
    }, TMP_StringScanner_terminate_23.$$arity = 0);
    
    Opal.def(self, '$unscan', TMP_StringScanner_unscan_24 = function $$unscan() {
      var self = this;

      
      self.pos = self.prev_pos;
      self.prev_pos = nil;
      self.match = nil;
      return self;
    }, TMP_StringScanner_unscan_24.$$arity = 0);
    self.$private();
    return (Opal.def(self, '$anchor', TMP_StringScanner_anchor_25 = function $$anchor(pattern) {
      var self = this;

      
      var flags = pattern.toString().match(/\/([^\/]+)$/);
      flags = flags ? flags[1] : undefined;
      return new RegExp('^(?:' + pattern.source + ')', flags);
    
    }, TMP_StringScanner_anchor_25.$$arity = 1), nil) && 'anchor';
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$require']);
  
  self.$require("asciidoctor/js/opal_ext");
  self.$require("asciidoctor/js/rx");
  return self.$require("strscan");
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["logger"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $module = Opal.module, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$include', '$to_h', '$map', '$constants', '$const_get', '$to_s', '$format', '$chr', '$strftime', '$message_as_string', '$===', '$+', '$message', '$class', '$join', '$backtrace', '$inspect', '$attr_reader', '$attr_accessor', '$new', '$key', '$upcase', '$raise', '$add', '$to_proc', '$<=', '$<', '$write', '$call', '$[]', '$now']);
  return (function($base, $super, $parent_nesting) {
    function $Logger(){};
    var self = $Logger = $klass($base, $super, 'Logger', $Logger);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Logger_1, TMP_Logger_initialize_4, TMP_Logger_level$eq_5, TMP_Logger_info_6, TMP_Logger_debug_7, TMP_Logger_warn_8, TMP_Logger_error_9, TMP_Logger_fatal_10, TMP_Logger_unknown_11, TMP_Logger_info$q_12, TMP_Logger_debug$q_13, TMP_Logger_warn$q_14, TMP_Logger_error$q_15, TMP_Logger_fatal$q_16, TMP_Logger_add_17;

    def.level = def.progname = def.pipe = def.formatter = nil;
    
    (function($base, $parent_nesting) {
      function $Severity() {};
      var self = $Severity = $module($base, 'Severity', $Severity);

      var def = self.prototype, $nesting = [self].concat($parent_nesting);

      
      Opal.const_set($nesting[0], 'DEBUG', 0);
      Opal.const_set($nesting[0], 'INFO', 1);
      Opal.const_set($nesting[0], 'WARN', 2);
      Opal.const_set($nesting[0], 'ERROR', 3);
      Opal.const_set($nesting[0], 'FATAL', 4);
      Opal.const_set($nesting[0], 'UNKNOWN', 5);
    })($nesting[0], $nesting);
    self.$include($$($nesting, 'Severity'));
    Opal.const_set($nesting[0], 'SEVERITY_LABELS', $send($$($nesting, 'Severity').$constants(), 'map', [], (TMP_Logger_1 = function(s){var self = TMP_Logger_1.$$s || this;

    
      
      if (s == null) {
        s = nil;
      };
      return [$$($nesting, 'Severity').$const_get(s), s.$to_s()];}, TMP_Logger_1.$$s = self, TMP_Logger_1.$$arity = 1, TMP_Logger_1)).$to_h());
    (function($base, $super, $parent_nesting) {
      function $Formatter(){};
      var self = $Formatter = $klass($base, $super, 'Formatter', $Formatter);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Formatter_call_2, TMP_Formatter_message_as_string_3;

      
      Opal.const_set($nesting[0], 'MESSAGE_FORMAT', "%s, [%s] %5s -- %s: %s\n");
      Opal.const_set($nesting[0], 'DATE_TIME_FORMAT', "%Y-%m-%dT%H:%M:%S.%6N");
      
      Opal.def(self, '$call', TMP_Formatter_call_2 = function $$call(severity, time, progname, msg) {
        var self = this;

        return self.$format($$($nesting, 'MESSAGE_FORMAT'), severity.$chr(), time.$strftime($$($nesting, 'DATE_TIME_FORMAT')), severity, progname, self.$message_as_string(msg))
      }, TMP_Formatter_call_2.$$arity = 4);
      return (Opal.def(self, '$message_as_string', TMP_Formatter_message_as_string_3 = function $$message_as_string(msg) {
        var $a, self = this, $case = nil;

        return (function() {$case = msg;
        if ($$$('::', 'String')['$===']($case)) {return msg}
        else if ($$$('::', 'Exception')['$===']($case)) {return $rb_plus("" + (msg.$message()) + " (" + (msg.$class()) + ")\n", ($truthy($a = msg.$backtrace()) ? $a : []).$join("\n"))}
        else {return msg.$inspect()}})()
      }, TMP_Formatter_message_as_string_3.$$arity = 1), nil) && 'message_as_string';
    })($nesting[0], null, $nesting);
    self.$attr_reader("level");
    self.$attr_accessor("progname");
    self.$attr_accessor("formatter");
    
    Opal.def(self, '$initialize', TMP_Logger_initialize_4 = function $$initialize(pipe) {
      var self = this;

      
      self.pipe = pipe;
      self.level = $$($nesting, 'DEBUG');
      return (self.formatter = $$($nesting, 'Formatter').$new());
    }, TMP_Logger_initialize_4.$$arity = 1);
    
    Opal.def(self, '$level=', TMP_Logger_level$eq_5 = function(severity) {
      var self = this, level = nil;

      if ($truthy($$$('::', 'Integer')['$==='](severity))) {
        return (self.level = severity)
      } else if ($truthy((level = $$($nesting, 'SEVERITY_LABELS').$key(severity.$to_s().$upcase())))) {
        return (self.level = level)
      } else {
        return self.$raise($$($nesting, 'ArgumentError'), "" + "invalid log level: " + (severity))
      }
    }, TMP_Logger_level$eq_5.$$arity = 1);
    
    Opal.def(self, '$info', TMP_Logger_info_6 = function $$info(progname) {
      var $iter = TMP_Logger_info_6.$$p, block = $iter || nil, self = this;

      if ($iter) TMP_Logger_info_6.$$p = null;
      
      
      if ($iter) TMP_Logger_info_6.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'INFO'), nil, progname], block.$to_proc());
    }, TMP_Logger_info_6.$$arity = -1);
    
    Opal.def(self, '$debug', TMP_Logger_debug_7 = function $$debug(progname) {
      var $iter = TMP_Logger_debug_7.$$p, block = $iter || nil, self = this;

      if ($iter) TMP_Logger_debug_7.$$p = null;
      
      
      if ($iter) TMP_Logger_debug_7.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'DEBUG'), nil, progname], block.$to_proc());
    }, TMP_Logger_debug_7.$$arity = -1);
    
    Opal.def(self, '$warn', TMP_Logger_warn_8 = function $$warn(progname) {
      var $iter = TMP_Logger_warn_8.$$p, block = $iter || nil, self = this;

      if ($iter) TMP_Logger_warn_8.$$p = null;
      
      
      if ($iter) TMP_Logger_warn_8.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'WARN'), nil, progname], block.$to_proc());
    }, TMP_Logger_warn_8.$$arity = -1);
    
    Opal.def(self, '$error', TMP_Logger_error_9 = function $$error(progname) {
      var $iter = TMP_Logger_error_9.$$p, block = $iter || nil, self = this;

      if ($iter) TMP_Logger_error_9.$$p = null;
      
      
      if ($iter) TMP_Logger_error_9.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'ERROR'), nil, progname], block.$to_proc());
    }, TMP_Logger_error_9.$$arity = -1);
    
    Opal.def(self, '$fatal', TMP_Logger_fatal_10 = function $$fatal(progname) {
      var $iter = TMP_Logger_fatal_10.$$p, block = $iter || nil, self = this;

      if ($iter) TMP_Logger_fatal_10.$$p = null;
      
      
      if ($iter) TMP_Logger_fatal_10.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'FATAL'), nil, progname], block.$to_proc());
    }, TMP_Logger_fatal_10.$$arity = -1);
    
    Opal.def(self, '$unknown', TMP_Logger_unknown_11 = function $$unknown(progname) {
      var $iter = TMP_Logger_unknown_11.$$p, block = $iter || nil, self = this;

      if ($iter) TMP_Logger_unknown_11.$$p = null;
      
      
      if ($iter) TMP_Logger_unknown_11.$$p = null;;
      
      if (progname == null) {
        progname = nil;
      };
      return $send(self, 'add', [$$($nesting, 'UNKNOWN'), nil, progname], block.$to_proc());
    }, TMP_Logger_unknown_11.$$arity = -1);
    
    Opal.def(self, '$info?', TMP_Logger_info$q_12 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'INFO'))
    }, TMP_Logger_info$q_12.$$arity = 0);
    
    Opal.def(self, '$debug?', TMP_Logger_debug$q_13 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'DEBUG'))
    }, TMP_Logger_debug$q_13.$$arity = 0);
    
    Opal.def(self, '$warn?', TMP_Logger_warn$q_14 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'WARN'))
    }, TMP_Logger_warn$q_14.$$arity = 0);
    
    Opal.def(self, '$error?', TMP_Logger_error$q_15 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'ERROR'))
    }, TMP_Logger_error$q_15.$$arity = 0);
    
    Opal.def(self, '$fatal?', TMP_Logger_fatal$q_16 = function() {
      var self = this;

      return $rb_le(self.level, $$($nesting, 'FATAL'))
    }, TMP_Logger_fatal$q_16.$$arity = 0);
    return (Opal.def(self, '$add', TMP_Logger_add_17 = function $$add(severity, message, progname) {
      var $iter = TMP_Logger_add_17.$$p, block = $iter || nil, $a, self = this;

      if ($iter) TMP_Logger_add_17.$$p = null;
      
      
      if ($iter) TMP_Logger_add_17.$$p = null;;
      
      if (message == null) {
        message = nil;
      };
      
      if (progname == null) {
        progname = nil;
      };
      if ($truthy($rb_lt((severity = ($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), self.level))) {
        return true};
      progname = ($truthy($a = progname) ? $a : self.progname);
      if ($truthy(message)) {
      } else if ((block !== nil)) {
        message = Opal.yieldX(block, [])
      } else {
        
        message = progname;
        progname = self.progname;
      };
      self.pipe.$write(self.formatter.$call(($truthy($a = $$($nesting, 'SEVERITY_LABELS')['$[]'](severity)) ? $a : "ANY"), $$$('::', 'Time').$now(), progname, message));
      return true;
    }, TMP_Logger_add_17.$$arity = -2), nil) && 'add';
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/logging"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2, $gvars = Opal.gvars;

  Opal.add_stubs(['$require', '$attr_reader', '$progname=', '$-', '$new', '$formatter=', '$level=', '$>', '$[]', '$===', '$inspect', '$map', '$constants', '$const_get', '$to_sym', '$<<', '$clear', '$empty?', '$max', '$attr_accessor', '$memoize_logger', '$private', '$alias_method', '$==', '$define_method', '$extend', '$logger', '$merge']);
  
  self.$require("logger");
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      function $Logger(){};
      var self = $Logger = $klass($base, $super, 'Logger', $Logger);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Logger_initialize_1, TMP_Logger_add_2;

      def.max_severity = nil;
      
      self.$attr_reader("max_severity");
      
      Opal.def(self, '$initialize', TMP_Logger_initialize_1 = function $$initialize($a) {
        var $post_args, args, $iter = TMP_Logger_initialize_1.$$p, $yield = $iter || nil, self = this, $writer = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Logger_initialize_1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        $post_args = Opal.slice.call(arguments, 0, arguments.length);
        
        args = $post_args;;
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Logger_initialize_1, false), $zuper, $iter);
        
        $writer = ["asciidoctor"];
        $send(self, 'progname=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = [$$($nesting, 'BasicFormatter').$new()];
        $send(self, 'formatter=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = [$$($nesting, 'WARN')];
        $send(self, 'level=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];;
      }, TMP_Logger_initialize_1.$$arity = -1);
      
      Opal.def(self, '$add', TMP_Logger_add_2 = function $$add(severity, message, progname) {
        var $a, $iter = TMP_Logger_add_2.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Logger_add_2.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (message == null) {
          message = nil;
        };
        
        if (progname == null) {
          progname = nil;
        };
        if ($truthy($rb_gt((severity = ($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), (self.max_severity = ($truthy($a = self.max_severity) ? $a : severity))))) {
          self.max_severity = severity};
        return $send(self, Opal.find_super_dispatcher(self, 'add', TMP_Logger_add_2, false), $zuper, $iter);
      }, TMP_Logger_add_2.$$arity = -2);
      (function($base, $super, $parent_nesting) {
        function $BasicFormatter(){};
        var self = $BasicFormatter = $klass($base, $super, 'BasicFormatter', $BasicFormatter);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_BasicFormatter_call_3;

        
        Opal.const_set($nesting[0], 'SEVERITY_LABELS', $hash2(["WARN", "FATAL"], {"WARN": "WARNING", "FATAL": "FAILED"}));
        return (Opal.def(self, '$call', TMP_BasicFormatter_call_3 = function $$call(severity, _, progname, msg) {
          var $a, self = this;

          return "" + (progname) + ": " + (($truthy($a = $$($nesting, 'SEVERITY_LABELS')['$[]'](severity)) ? $a : severity)) + ": " + ((function() {if ($truthy($$$('::', 'String')['$==='](msg))) {
            return msg
          } else {
            return msg.$inspect()
          }; return nil; })()) + "\n"
        }, TMP_BasicFormatter_call_3.$$arity = 4), nil) && 'call';
      })($nesting[0], $$($nesting, 'Formatter'), $nesting);
      return (function($base, $parent_nesting) {
        function $AutoFormattingMessage() {};
        var self = $AutoFormattingMessage = $module($base, 'AutoFormattingMessage', $AutoFormattingMessage);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_AutoFormattingMessage_inspect_4;

        
        Opal.def(self, '$inspect', TMP_AutoFormattingMessage_inspect_4 = function $$inspect() {
          var self = this, sloc = nil;

          if ($truthy((sloc = self['$[]']("source_location")))) {
            return "" + (sloc) + ": " + (self['$[]']("text"))
          } else {
            return self['$[]']("text")
          }
        }, TMP_AutoFormattingMessage_inspect_4.$$arity = 0)
      })($nesting[0], $nesting);
    })($nesting[0], $$$('::', 'Logger'), $nesting);
    (function($base, $super, $parent_nesting) {
      function $MemoryLogger(){};
      var self = $MemoryLogger = $klass($base, $super, 'MemoryLogger', $MemoryLogger);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_MemoryLogger_5, TMP_MemoryLogger_initialize_6, TMP_MemoryLogger_add_7, TMP_MemoryLogger_clear_8, TMP_MemoryLogger_empty$q_9, TMP_MemoryLogger_max_severity_10;

      def.messages = nil;
      
      Opal.const_set($nesting[0], 'SEVERITY_LABELS', $$$('::', 'Hash')['$[]']($send($$($nesting, 'Severity').$constants(), 'map', [], (TMP_MemoryLogger_5 = function(c){var self = TMP_MemoryLogger_5.$$s || this;

      
        
        if (c == null) {
          c = nil;
        };
        return [$$($nesting, 'Severity').$const_get(c), c.$to_sym()];}, TMP_MemoryLogger_5.$$s = self, TMP_MemoryLogger_5.$$arity = 1, TMP_MemoryLogger_5))));
      self.$attr_reader("messages");
      
      Opal.def(self, '$initialize', TMP_MemoryLogger_initialize_6 = function $$initialize() {
        var self = this, $writer = nil;

        
        
        $writer = [$$($nesting, 'WARN')];
        $send(self, 'level=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        return (self.messages = []);
      }, TMP_MemoryLogger_initialize_6.$$arity = 0);
      
      Opal.def(self, '$add', TMP_MemoryLogger_add_7 = function $$add(severity, message, progname) {
        var $a, $iter = TMP_MemoryLogger_add_7.$$p, $yield = $iter || nil, self = this;

        if ($iter) TMP_MemoryLogger_add_7.$$p = null;
        
        
        if (message == null) {
          message = nil;
        };
        
        if (progname == null) {
          progname = nil;
        };
        if ($truthy(message)) {
        } else {
          message = (function() {if (($yield !== nil)) {
            return Opal.yieldX($yield, []);
          } else {
            return progname
          }; return nil; })()
        };
        self.messages['$<<']($hash2(["severity", "message"], {"severity": $$($nesting, 'SEVERITY_LABELS')['$[]'](($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), "message": message}));
        return true;
      }, TMP_MemoryLogger_add_7.$$arity = -2);
      
      Opal.def(self, '$clear', TMP_MemoryLogger_clear_8 = function $$clear() {
        var self = this;

        return self.messages.$clear()
      }, TMP_MemoryLogger_clear_8.$$arity = 0);
      
      Opal.def(self, '$empty?', TMP_MemoryLogger_empty$q_9 = function() {
        var self = this;

        return self.messages['$empty?']()
      }, TMP_MemoryLogger_empty$q_9.$$arity = 0);
      return (Opal.def(self, '$max_severity', TMP_MemoryLogger_max_severity_10 = function $$max_severity() {
        var TMP_11, self = this;

        if ($truthy(self['$empty?']())) {
          return nil
        } else {
          return $send(self.messages, 'map', [], (TMP_11 = function(m){var self = TMP_11.$$s || this;

          
            
            if (m == null) {
              m = nil;
            };
            return $$($nesting, 'Severity').$const_get(m['$[]']("severity"));}, TMP_11.$$s = self, TMP_11.$$arity = 1, TMP_11)).$max()
        }
      }, TMP_MemoryLogger_max_severity_10.$$arity = 0), nil) && 'max_severity';
    })($nesting[0], $$$('::', 'Logger'), $nesting);
    (function($base, $super, $parent_nesting) {
      function $NullLogger(){};
      var self = $NullLogger = $klass($base, $super, 'NullLogger', $NullLogger);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_NullLogger_initialize_12, TMP_NullLogger_add_13;

      def.max_severity = nil;
      
      self.$attr_reader("max_severity");
      
      Opal.def(self, '$initialize', TMP_NullLogger_initialize_12 = function $$initialize() {
        var self = this;

        return nil
      }, TMP_NullLogger_initialize_12.$$arity = 0);
      return (Opal.def(self, '$add', TMP_NullLogger_add_13 = function $$add(severity, message, progname) {
        var $a, self = this;

        
        
        if (message == null) {
          message = nil;
        };
        
        if (progname == null) {
          progname = nil;
        };
        if ($truthy($rb_gt((severity = ($truthy($a = severity) ? $a : $$($nesting, 'UNKNOWN'))), (self.max_severity = ($truthy($a = self.max_severity) ? $a : severity))))) {
          self.max_severity = severity};
        return true;
      }, TMP_NullLogger_add_13.$$arity = -2), nil) && 'add';
    })($nesting[0], $$$('::', 'Logger'), $nesting);
    (function($base, $parent_nesting) {
      function $LoggerManager() {};
      var self = $LoggerManager = $module($base, 'LoggerManager', $LoggerManager);

      var def = self.prototype, $nesting = [self].concat($parent_nesting);

      
      self.logger_class = $$($nesting, 'Logger');
      (function(self, $parent_nesting) {
        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_logger_14, TMP_logger$eq_15, TMP_memoize_logger_16;

        
        self.$attr_accessor("logger_class");
        
        Opal.def(self, '$logger', TMP_logger_14 = function $$logger(pipe) {
          var $a, self = this;
          if (self.logger == null) self.logger = nil;
          if (self.logger_class == null) self.logger_class = nil;
          if ($gvars.stderr == null) $gvars.stderr = nil;

          
          
          if (pipe == null) {
            pipe = $gvars.stderr;
          };
          self.$memoize_logger();
          return (self.logger = ($truthy($a = self.logger) ? $a : self.logger_class.$new(pipe)));
        }, TMP_logger_14.$$arity = -1);
        
        Opal.def(self, '$logger=', TMP_logger$eq_15 = function(logger) {
          var $a, self = this;
          if (self.logger_class == null) self.logger_class = nil;
          if ($gvars.stderr == null) $gvars.stderr = nil;

          return (self.logger = ($truthy($a = logger) ? $a : self.logger_class.$new($gvars.stderr)))
        }, TMP_logger$eq_15.$$arity = 1);
        self.$private();
        return (Opal.def(self, '$memoize_logger', TMP_memoize_logger_16 = function $$memoize_logger() {
          var self = this;

          return (function(self, $parent_nesting) {
            var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_17;

            
            self.$alias_method("logger", "logger");
            if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
              return $send(self, 'define_method', ["logger"], (TMP_17 = function(){var self = TMP_17.$$s || this;
                if (self.logger == null) self.logger = nil;

              return self.logger}, TMP_17.$$s = self, TMP_17.$$arity = 0, TMP_17))
            } else {
              return nil
            };
          })(Opal.get_singleton_class(self), $nesting)
        }, TMP_memoize_logger_16.$$arity = 0), nil) && 'memoize_logger';
      })(Opal.get_singleton_class(self), $nesting);
    })($nesting[0], $nesting);
    (function($base, $parent_nesting) {
      function $Logging() {};
      var self = $Logging = $module($base, 'Logging', $Logging);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Logging_included_18, TMP_Logging_logger_19, TMP_Logging_message_with_context_20;

      
      Opal.defs(self, '$included', TMP_Logging_included_18 = function $$included(into) {
        var self = this;

        return into.$extend($$($nesting, 'Logging'))
      }, TMP_Logging_included_18.$$arity = 1);
      self.$private();
      
      Opal.def(self, '$logger', TMP_Logging_logger_19 = function $$logger() {
        var self = this;

        return $$($nesting, 'LoggerManager').$logger()
      }, TMP_Logging_logger_19.$$arity = 0);
      
      Opal.def(self, '$message_with_context', TMP_Logging_message_with_context_20 = function $$message_with_context(text, context) {
        var self = this;

        
        
        if (context == null) {
          context = $hash2([], {});
        };
        return $hash2(["text"], {"text": text}).$merge(context).$extend($$$($$($nesting, 'Logger'), 'AutoFormattingMessage'));
      }, TMP_Logging_message_with_context_20.$$arity = -2);
    })($nesting[0], $nesting);
  })($nesting[0], $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/timings"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy, $gvars = Opal.gvars;

  Opal.add_stubs(['$now', '$[]=', '$-', '$delete', '$reduce', '$+', '$[]', '$>', '$time', '$puts', '$%', '$to_f', '$read_parse', '$convert', '$read_parse_convert', '$const_defined?', '$respond_to?', '$clock_gettime']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Timings(){};
      var self = $Timings = $klass($base, $super, 'Timings', $Timings);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Timings_initialize_1, TMP_Timings_start_2, TMP_Timings_record_3, TMP_Timings_time_4, TMP_Timings_read_6, TMP_Timings_parse_7, TMP_Timings_read_parse_8, TMP_Timings_convert_9, TMP_Timings_read_parse_convert_10, TMP_Timings_write_11, TMP_Timings_total_12, TMP_Timings_print_report_13, $a, TMP_Timings_now_14, TMP_Timings_now_15;

      def.timers = def.log = nil;
      
      
      Opal.def(self, '$initialize', TMP_Timings_initialize_1 = function $$initialize() {
        var self = this;

        
        self.log = $hash2([], {});
        return (self.timers = $hash2([], {}));
      }, TMP_Timings_initialize_1.$$arity = 0);
      
      Opal.def(self, '$start', TMP_Timings_start_2 = function $$start(key) {
        var self = this, $writer = nil;

        
        $writer = [key, self.$now()];
        $send(self.timers, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];
      }, TMP_Timings_start_2.$$arity = 1);
      
      Opal.def(self, '$record', TMP_Timings_record_3 = function $$record(key) {
        var self = this, $writer = nil;

        
        $writer = [key, $rb_minus(self.$now(), self.timers.$delete(key))];
        $send(self.log, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];
      }, TMP_Timings_record_3.$$arity = 1);
      
      Opal.def(self, '$time', TMP_Timings_time_4 = function $$time($a) {
        var $post_args, keys, TMP_5, self = this, time = nil;

        
        
        $post_args = Opal.slice.call(arguments, 0, arguments.length);
        
        keys = $post_args;;
        time = $send(keys, 'reduce', [0], (TMP_5 = function(sum, key){var self = TMP_5.$$s || this, $b;
          if (self.log == null) self.log = nil;

        
          
          if (sum == null) {
            sum = nil;
          };
          
          if (key == null) {
            key = nil;
          };
          return $rb_plus(sum, ($truthy($b = self.log['$[]'](key)) ? $b : 0));}, TMP_5.$$s = self, TMP_5.$$arity = 2, TMP_5));
        if ($truthy($rb_gt(time, 0))) {
          return time
        } else {
          return nil
        };
      }, TMP_Timings_time_4.$$arity = -1);
      
      Opal.def(self, '$read', TMP_Timings_read_6 = function $$read() {
        var self = this;

        return self.$time("read")
      }, TMP_Timings_read_6.$$arity = 0);
      
      Opal.def(self, '$parse', TMP_Timings_parse_7 = function $$parse() {
        var self = this;

        return self.$time("parse")
      }, TMP_Timings_parse_7.$$arity = 0);
      
      Opal.def(self, '$read_parse', TMP_Timings_read_parse_8 = function $$read_parse() {
        var self = this;

        return self.$time("read", "parse")
      }, TMP_Timings_read_parse_8.$$arity = 0);
      
      Opal.def(self, '$convert', TMP_Timings_convert_9 = function $$convert() {
        var self = this;

        return self.$time("convert")
      }, TMP_Timings_convert_9.$$arity = 0);
      
      Opal.def(self, '$read_parse_convert', TMP_Timings_read_parse_convert_10 = function $$read_parse_convert() {
        var self = this;

        return self.$time("read", "parse", "convert")
      }, TMP_Timings_read_parse_convert_10.$$arity = 0);
      
      Opal.def(self, '$write', TMP_Timings_write_11 = function $$write() {
        var self = this;

        return self.$time("write")
      }, TMP_Timings_write_11.$$arity = 0);
      
      Opal.def(self, '$total', TMP_Timings_total_12 = function $$total() {
        var self = this;

        return self.$time("read", "parse", "convert", "write")
      }, TMP_Timings_total_12.$$arity = 0);
      
      Opal.def(self, '$print_report', TMP_Timings_print_report_13 = function $$print_report(to, subject) {
        var self = this;
        if ($gvars.stdout == null) $gvars.stdout = nil;

        
        
        if (to == null) {
          to = $gvars.stdout;
        };
        
        if (subject == null) {
          subject = nil;
        };
        if ($truthy(subject)) {
          to.$puts("" + "Input file: " + (subject))};
        to.$puts("" + "  Time to read and parse source: " + ("%05.5f"['$%'](self.$read_parse().$to_f())));
        to.$puts("" + "  Time to convert document: " + ("%05.5f"['$%'](self.$convert().$to_f())));
        return to.$puts("" + "  Total time (read, parse and convert): " + ("%05.5f"['$%'](self.$read_parse_convert().$to_f())));
      }, TMP_Timings_print_report_13.$$arity = -1);
      if ($truthy(($truthy($a = $$$('::', 'Process')['$const_defined?']("CLOCK_MONOTONIC")) ? $$$('::', 'Process')['$respond_to?']("clock_gettime") : $a))) {
        
        Opal.const_set($nesting[0], 'CLOCK_ID', $$$($$$('::', 'Process'), 'CLOCK_MONOTONIC'));
        return (Opal.def(self, '$now', TMP_Timings_now_14 = function $$now() {
          var self = this;

          return $$$('::', 'Process').$clock_gettime($$($nesting, 'CLOCK_ID'))
        }, TMP_Timings_now_14.$$arity = 0), nil) && 'now';
      } else {
        return (Opal.def(self, '$now', TMP_Timings_now_15 = function $$now() {
          var self = this;

          return $$$('::', 'Time').$now()
        }, TMP_Timings_now_15.$$arity = 0), nil) && 'now'
      };
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/version"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module;

  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    Opal.const_set($nesting[0], 'VERSION', "1.5.8")
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/nil_or_empty"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$method_defined?']);
  
  (function($base, $super, $parent_nesting) {
    function $NilClass(){};
    var self = $NilClass = $klass($base, $super, 'NilClass', $NilClass);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "nil?")
    }
  })($nesting[0], null, $nesting);
  (function($base, $super, $parent_nesting) {
    function $String(){};
    var self = $String = $klass($base, $super, 'String', $String);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "empty?")
    }
  })($nesting[0], null, $nesting);
  (function($base, $super, $parent_nesting) {
    function $Array(){};
    var self = $Array = $klass($base, $super, 'Array', $Array);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "empty?")
    }
  })($nesting[0], null, $nesting);
  (function($base, $super, $parent_nesting) {
    function $Hash(){};
    var self = $Hash = $klass($base, $super, 'Hash', $Hash);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "empty?")
    }
  })($nesting[0], null, $nesting);
  return (function($base, $super, $parent_nesting) {
    function $Numeric(){};
    var self = $Numeric = $klass($base, $super, 'Numeric', $Numeric);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("nil_or_empty?"))) {
      return nil
    } else {
      return Opal.alias(self, "nil_or_empty?", "nil?")
    }
  })($nesting[0], null, $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/regexp/is_match"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$method_defined?']);
  return (function($base, $super, $parent_nesting) {
    function $Regexp(){};
    var self = $Regexp = $klass($base, $super, 'Regexp', $Regexp);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    if ($truthy(self['$method_defined?']("match?"))) {
      return nil
    } else {
      return Opal.alias(self, "match?", "===")
    }
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/string/limit_bytesize"] = function(Opal) {
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$method_defined?', '$<', '$bytesize', '$valid_encoding?', '$force_encoding', '$byteslice', '$-']);
  return (function($base, $super, $parent_nesting) {
    function $String(){};
    var self = $String = $klass($base, $super, 'String', $String);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_String_limit_bytesize_1;

    if ($truthy(self['$method_defined?']("limit_bytesize"))) {
      return nil
    } else {
      return (Opal.def(self, '$limit_bytesize', TMP_String_limit_bytesize_1 = function $$limit_bytesize(size) {
        var $a, self = this, result = nil;

        
        if ($truthy($rb_lt(size, self.$bytesize()))) {
        } else {
          return self
        };
        while (!($truthy((result = self.$byteslice(0, size)).$force_encoding($$$($$$('::', 'Encoding'), 'UTF_8'))['$valid_encoding?']()))) {
          size = $rb_minus(size, 1)
        };
        return result;
      }, TMP_String_limit_bytesize_1.$$arity = 1), nil) && 'limit_bytesize'
    }
  })($nesting[0], null, $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/1.8.7/io/binread"] = function(Opal) {
  var TMP_binread_1, self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$respond_to?', '$open', '$==', '$seek', '$read']);
  if ($truthy($$($nesting, 'IO')['$respond_to?']("binread"))) {
    return nil
  } else {
    return (Opal.defs($$($nesting, 'IO'), '$binread', TMP_binread_1 = function $$binread(name, length, offset) {
      var TMP_2, self = this;

      
      
      if (length == null) {
        length = nil;
      };
      
      if (offset == null) {
        offset = 0;
      };
      return $send($$($nesting, 'File'), 'open', [name, "rb"], (TMP_2 = function(f){var self = TMP_2.$$s || this;

      
        
        if (f == null) {
          f = nil;
        };
        if (offset['$=='](0)) {
        } else {
          f.$seek(offset)
        };
        if ($truthy(length)) {
          
          return f.$read(length);
        } else {
          return f.$read()
        };}, TMP_2.$$s = self, TMP_2.$$arity = 1, TMP_2));
    }, TMP_binread_1.$$arity = -2), nil) && 'binread'
  }
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext/1.8.7/io/write"] = function(Opal) {
  var TMP_write_1, self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$respond_to?', '$open', '$write']);
  if ($truthy($$($nesting, 'IO')['$respond_to?']("write"))) {
    return nil
  } else {
    return (Opal.defs($$($nesting, 'IO'), '$write', TMP_write_1 = function $$write(name, string, offset, opts) {
      var TMP_2, self = this;

      
      
      if (offset == null) {
        offset = 0;
      };
      
      if (opts == null) {
        opts = nil;
      };
      return $send($$($nesting, 'File'), 'open', [name, "w"], (TMP_2 = function(f){var self = TMP_2.$$s || this;

      
        
        if (f == null) {
          f = nil;
        };
        return f.$write(string);}, TMP_2.$$s = self, TMP_2.$$arity = 1, TMP_2));
    }, TMP_write_1.$$arity = -3), nil) && 'write'
  }
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/core_ext"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $truthy = Opal.truthy;

  Opal.add_stubs(['$require', '$==', '$!=']);
  
  self.$require("asciidoctor/core_ext/nil_or_empty");
  self.$require("asciidoctor/core_ext/regexp/is_match");
  if ($truthy($$($nesting, 'RUBY_MIN_VERSION_1_9'))) {
    
    self.$require("asciidoctor/core_ext/string/limit_bytesize");
    if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      
      self.$require("asciidoctor/core_ext/1.8.7/io/binread");
      return self.$require("asciidoctor/core_ext/1.8.7/io/write");
    } else {
      return nil
    };
  } else if ($truthy($$($nesting, 'RUBY_ENGINE')['$!=']("opal"))) {
    return nil
  } else {
    return nil
  };
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/helpers"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $truthy = Opal.truthy, $send = Opal.send, $gvars = Opal.gvars, $hash2 = Opal.hash2;

  Opal.add_stubs(['$require', '$include?', '$include', '$==', '$===', '$raise', '$warn', '$logger', '$chomp', '$message', '$normalize_lines_from_string', '$normalize_lines_array', '$empty?', '$unpack', '$[]', '$slice', '$join', '$map', '$each_line', '$encode', '$force_encoding', '$length', '$rstrip', '$[]=', '$-', '$encoding', '$nil_or_empty?', '$match?', '$=~', '$gsub', '$each_byte', '$sprintf', '$rindex', '$basename', '$extname', '$directory?', '$dirname', '$mkdir_p', '$mkdir', '$divmod', '$*']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      function $Helpers() {};
      var self = $Helpers = $module($base, 'Helpers', $Helpers);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Helpers_require_library_1, TMP_Helpers_normalize_lines_2, TMP_Helpers_normalize_lines_array_3, TMP_Helpers_normalize_lines_from_string_8, TMP_Helpers_uriish$q_10, TMP_Helpers_uri_prefix_11, TMP_Helpers_uri_encode_12, TMP_Helpers_rootname_15, TMP_Helpers_basename_16, TMP_Helpers_mkdir_p_17, TMP_Helpers_int_to_roman_18;

      
      Opal.defs(self, '$require_library', TMP_Helpers_require_library_1 = function $$require_library(name, gem_name, on_failure) {
        var self = this, e = nil, $case = nil;

        
        
        if (gem_name == null) {
          gem_name = true;
        };
        
        if (on_failure == null) {
          on_failure = "abort";
        };
        try {
          return self.$require(name)
        } catch ($err) {
          if (Opal.rescue($err, [$$$('::', 'LoadError')])) {e = $err;
            try {
              
              if ($truthy(self['$include?']($$($nesting, 'Logging')))) {
              } else {
                self.$include($$($nesting, 'Logging'))
              };
              if ($truthy(gem_name)) {
                
                if (gem_name['$=='](true)) {
                  gem_name = name};
                $case = on_failure;
                if ("abort"['$===']($case)) {self.$raise($$$('::', 'LoadError'), "" + "asciidoctor: FAILED: required gem '" + (gem_name) + "' is not installed. Processing aborted.")}
                else if ("warn"['$===']($case)) {self.$logger().$warn("" + "optional gem '" + (gem_name) + "' is not installed. Functionality disabled.")};
              } else {
                $case = on_failure;
                if ("abort"['$===']($case)) {self.$raise($$$('::', 'LoadError'), "" + "asciidoctor: FAILED: " + (e.$message().$chomp(".")) + ". Processing aborted.")}
                else if ("warn"['$===']($case)) {self.$logger().$warn("" + (e.$message().$chomp(".")) + ". Functionality disabled.")}
              };
              return nil;
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };
      }, TMP_Helpers_require_library_1.$$arity = -2);
      Opal.defs(self, '$normalize_lines', TMP_Helpers_normalize_lines_2 = function $$normalize_lines(data) {
        var self = this;

        if ($truthy($$$('::', 'String')['$==='](data))) {
          
          return self.$normalize_lines_from_string(data);
        } else {
          
          return self.$normalize_lines_array(data);
        }
      }, TMP_Helpers_normalize_lines_2.$$arity = 1);
      Opal.defs(self, '$normalize_lines_array', TMP_Helpers_normalize_lines_array_3 = function $$normalize_lines_array(data) {
        var TMP_4, TMP_5, TMP_6, TMP_7, self = this, leading_bytes = nil, first_line = nil, utf8 = nil, leading_2_bytes = nil, $writer = nil;

        
        if ($truthy(data['$empty?']())) {
          return data};
        leading_bytes = (first_line = data['$[]'](0)).$unpack("C3");
        if ($truthy($$($nesting, 'COERCE_ENCODING'))) {
          
          utf8 = $$$($$$('::', 'Encoding'), 'UTF_8');
          if ((leading_2_bytes = leading_bytes.$slice(0, 2))['$==']($$($nesting, 'BOM_BYTES_UTF_16LE'))) {
            
            data = data.$join();
            return $send(data.$force_encoding($$$($$$('::', 'Encoding'), 'UTF_16LE')).$slice(1, data.$length()).$encode(utf8).$each_line(), 'map', [], (TMP_4 = function(line){var self = TMP_4.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$rstrip();}, TMP_4.$$s = self, TMP_4.$$arity = 1, TMP_4));
          } else if (leading_2_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_16BE'))) {
            
            
            $writer = [0, first_line.$force_encoding($$$($$$('::', 'Encoding'), 'UTF_16BE')).$slice(1, first_line.$length())];
            $send(data, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return $send(data, 'map', [], (TMP_5 = function(line){var self = TMP_5.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              return line.$force_encoding($$$($$$('::', 'Encoding'), 'UTF_16BE')).$encode(utf8).$rstrip();}, TMP_5.$$s = self, TMP_5.$$arity = 1, TMP_5));
          } else if (leading_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_8'))) {
            
            $writer = [0, first_line.$force_encoding(utf8).$slice(1, first_line.$length())];
            $send(data, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          return $send(data, 'map', [], (TMP_6 = function(line){var self = TMP_6.$$s || this;

          
            
            if (line == null) {
              line = nil;
            };
            if (line.$encoding()['$=='](utf8)) {
              return line.$rstrip()
            } else {
              return line.$force_encoding(utf8).$rstrip()
            };}, TMP_6.$$s = self, TMP_6.$$arity = 1, TMP_6));
        } else {
          
          if (leading_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_8'))) {
            
            $writer = [0, first_line.$slice(3, first_line.$length())];
            $send(data, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          return $send(data, 'map', [], (TMP_7 = function(line){var self = TMP_7.$$s || this;

          
            
            if (line == null) {
              line = nil;
            };
            return line.$rstrip();}, TMP_7.$$s = self, TMP_7.$$arity = 1, TMP_7));
        };
      }, TMP_Helpers_normalize_lines_array_3.$$arity = 1);
      Opal.defs(self, '$normalize_lines_from_string', TMP_Helpers_normalize_lines_from_string_8 = function $$normalize_lines_from_string(data) {
        var TMP_9, self = this, leading_bytes = nil, utf8 = nil, leading_2_bytes = nil;

        
        if ($truthy(data['$nil_or_empty?']())) {
          return []};
        leading_bytes = data.$unpack("C3");
        if ($truthy($$($nesting, 'COERCE_ENCODING'))) {
          
          utf8 = $$$($$$('::', 'Encoding'), 'UTF_8');
          if ((leading_2_bytes = leading_bytes.$slice(0, 2))['$==']($$($nesting, 'BOM_BYTES_UTF_16LE'))) {
            data = data.$force_encoding($$$($$$('::', 'Encoding'), 'UTF_16LE')).$slice(1, data.$length()).$encode(utf8)
          } else if (leading_2_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_16BE'))) {
            data = data.$force_encoding($$$($$$('::', 'Encoding'), 'UTF_16BE')).$slice(1, data.$length()).$encode(utf8)
          } else if (leading_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_8'))) {
            data = (function() {if (data.$encoding()['$=='](utf8)) {
              
              return data.$slice(1, data.$length());
            } else {
              
              return data.$force_encoding(utf8).$slice(1, data.$length());
            }; return nil; })()
          } else if (data.$encoding()['$=='](utf8)) {
          } else {
            data = data.$force_encoding(utf8)
          };
        } else if (leading_bytes['$==']($$($nesting, 'BOM_BYTES_UTF_8'))) {
          data = data.$slice(3, data.$length())};
        return $send(data.$each_line(), 'map', [], (TMP_9 = function(line){var self = TMP_9.$$s || this;

        
          
          if (line == null) {
            line = nil;
          };
          return line.$rstrip();}, TMP_9.$$s = self, TMP_9.$$arity = 1, TMP_9));
      }, TMP_Helpers_normalize_lines_from_string_8.$$arity = 1);
      Opal.defs(self, '$uriish?', TMP_Helpers_uriish$q_10 = function(str) {
        var $a, self = this;

        return ($truthy($a = str['$include?'](":")) ? $$($nesting, 'UriSniffRx')['$match?'](str) : $a)
      }, TMP_Helpers_uriish$q_10.$$arity = 1);
      Opal.defs(self, '$uri_prefix', TMP_Helpers_uri_prefix_11 = function $$uri_prefix(str) {
        var $a, self = this;

        if ($truthy(($truthy($a = str['$include?'](":")) ? $$($nesting, 'UriSniffRx')['$=~'](str) : $a))) {
          return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0))
        } else {
          return nil
        }
      }, TMP_Helpers_uri_prefix_11.$$arity = 1);
      Opal.const_set($nesting[0], 'REGEXP_ENCODE_URI_CHARS', /[^\w\-.!~*';:@=+$,()\[\]]/);
      Opal.defs(self, '$uri_encode', TMP_Helpers_uri_encode_12 = function $$uri_encode(str) {
        var TMP_13, self = this;

        return $send(str, 'gsub', [$$($nesting, 'REGEXP_ENCODE_URI_CHARS')], (TMP_13 = function(){var self = TMP_13.$$s || this, $a, TMP_14;

        return $send((($a = $gvars['~']) === nil ? nil : $a['$[]'](0)).$each_byte(), 'map', [], (TMP_14 = function(c){var self = TMP_14.$$s || this;

          
            
            if (c == null) {
              c = nil;
            };
            return self.$sprintf("%%%02X", c);}, TMP_14.$$s = self, TMP_14.$$arity = 1, TMP_14)).$join()}, TMP_13.$$s = self, TMP_13.$$arity = 0, TMP_13))
      }, TMP_Helpers_uri_encode_12.$$arity = 1);
      Opal.defs(self, '$rootname', TMP_Helpers_rootname_15 = function $$rootname(filename) {
        var $a, self = this;

        return filename.$slice(0, ($truthy($a = filename.$rindex(".")) ? $a : filename.$length()))
      }, TMP_Helpers_rootname_15.$$arity = 1);
      Opal.defs(self, '$basename', TMP_Helpers_basename_16 = function $$basename(filename, drop_ext) {
        var self = this;

        
        
        if (drop_ext == null) {
          drop_ext = nil;
        };
        if ($truthy(drop_ext)) {
          return $$$('::', 'File').$basename(filename, (function() {if (drop_ext['$=='](true)) {
            
            return $$$('::', 'File').$extname(filename);
          } else {
            return drop_ext
          }; return nil; })())
        } else {
          return $$$('::', 'File').$basename(filename)
        };
      }, TMP_Helpers_basename_16.$$arity = -2);
      Opal.defs(self, '$mkdir_p', TMP_Helpers_mkdir_p_17 = function $$mkdir_p(dir) {
        var self = this, parent_dir = nil;

        if ($truthy($$$('::', 'File')['$directory?'](dir))) {
          return nil
        } else {
          
          if ((parent_dir = $$$('::', 'File').$dirname(dir))['$=='](".")) {
          } else {
            self.$mkdir_p(parent_dir)
          };
          
          try {
            return $$$('::', 'Dir').$mkdir(dir)
          } catch ($err) {
            if (Opal.rescue($err, [$$$('::', 'SystemCallError')])) {
              try {
                if ($truthy($$$('::', 'File')['$directory?'](dir))) {
                  return nil
                } else {
                  return self.$raise()
                }
              } finally { Opal.pop_exception() }
            } else { throw $err; }
          };;
        }
      }, TMP_Helpers_mkdir_p_17.$$arity = 1);
      Opal.const_set($nesting[0], 'ROMAN_NUMERALS', $hash2(["M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"], {"M": 1000, "CM": 900, "D": 500, "CD": 400, "C": 100, "XC": 90, "L": 50, "XL": 40, "X": 10, "IX": 9, "V": 5, "IV": 4, "I": 1}));
      Opal.defs(self, '$int_to_roman', TMP_Helpers_int_to_roman_18 = function $$int_to_roman(val) {
        var TMP_19, self = this;

        return $send($$($nesting, 'ROMAN_NUMERALS'), 'map', [], (TMP_19 = function(l, i){var self = TMP_19.$$s || this, $a, $b, repeat = nil;

        
          
          if (l == null) {
            l = nil;
          };
          
          if (i == null) {
            i = nil;
          };
          $b = val.$divmod(i), $a = Opal.to_ary($b), (repeat = ($a[0] == null ? nil : $a[0])), (val = ($a[1] == null ? nil : $a[1])), $b;
          return $rb_times(l, repeat);}, TMP_19.$$s = self, TMP_19.$$arity = 2, TMP_19)).$join()
      }, TMP_Helpers_int_to_roman_18.$$arity = 1);
    })($nesting[0], $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/substitutors"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $hash2 = Opal.hash2, $hash = Opal.hash, $truthy = Opal.truthy, $send = Opal.send, $gvars = Opal.gvars;

  Opal.add_stubs(['$freeze', '$+', '$keys', '$chr', '$attr_reader', '$empty?', '$!', '$===', '$[]', '$join', '$include?', '$extract_passthroughs', '$each', '$sub_specialchars', '$sub_quotes', '$sub_attributes', '$sub_replacements', '$sub_macros', '$highlight_source', '$sub_callouts', '$sub_post_replacements', '$warn', '$logger', '$restore_passthroughs', '$split', '$apply_subs', '$compat_mode', '$gsub', '$==', '$length', '$>', '$*', '$-', '$end_with?', '$slice', '$parse_quoted_text_attributes', '$size', '$[]=', '$unescape_brackets', '$resolve_pass_subs', '$start_with?', '$extract_inner_passthrough', '$to_sym', '$attributes', '$basebackend?', '$=~', '$to_i', '$convert', '$new', '$clear', '$match?', '$convert_quoted_text', '$do_replacement', '$sub', '$shift', '$store_attribute', '$!=', '$attribute_undefined', '$counter', '$key?', '$downcase', '$attribute_missing', '$tr_s', '$delete', '$reject', '$strip', '$index', '$min', '$compact', '$map', '$chop', '$unescape_bracketed_text', '$pop', '$rstrip', '$extensions', '$inline_macros?', '$inline_macros', '$regexp', '$instance', '$names', '$config', '$dup', '$nil_or_empty?', '$parse_attributes', '$process_method', '$register', '$tr', '$basename', '$split_simple_csv', '$normalize_string', '$!~', '$parse', '$uri_encode', '$sub_inline_xrefs', '$sub_inline_anchors', '$find', '$footnotes', '$id', '$text', '$style', '$lstrip', '$parse_into', '$extname', '$catalog', '$fetch', '$outfilesuffix', '$natural_xrefs', '$key', '$attr?', '$attr', '$to_s', '$read_next_id', '$callouts', '$<', '$<<', '$shorthand_property_syntax', '$concat', '$each_char', '$drop', '$&', '$resolve_subs', '$nil?', '$require_library', '$sub_source', '$resolve_lines_to_highlight', '$highlight', '$find_by_alias', '$find_by_mimetype', '$name', '$option?', '$count', '$to_a', '$uniq', '$sort', '$resolve_block_subs']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      function $Substitutors() {};
      var self = $Substitutors = $module($base, 'Substitutors', $Substitutors);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Substitutors_apply_subs_1, TMP_Substitutors_apply_normal_subs_3, TMP_Substitutors_apply_title_subs_4, TMP_Substitutors_apply_reftext_subs_5, TMP_Substitutors_apply_header_subs_6, TMP_Substitutors_extract_passthroughs_7, TMP_Substitutors_extract_inner_passthrough_11, TMP_Substitutors_restore_passthroughs_12, TMP_Substitutors_sub_quotes_14, TMP_Substitutors_sub_replacements_17, TMP_Substitutors_sub_specialchars_20, TMP_Substitutors_sub_specialchars_21, TMP_Substitutors_do_replacement_23, TMP_Substitutors_sub_attributes_24, TMP_Substitutors_sub_macros_29, TMP_Substitutors_sub_inline_anchors_46, TMP_Substitutors_sub_inline_xrefs_49, TMP_Substitutors_sub_callouts_51, TMP_Substitutors_sub_post_replacements_53, TMP_Substitutors_convert_quoted_text_56, TMP_Substitutors_parse_quoted_text_attributes_57, TMP_Substitutors_parse_attributes_58, TMP_Substitutors_expand_subs_59, TMP_Substitutors_unescape_bracketed_text_61, TMP_Substitutors_normalize_string_62, TMP_Substitutors_unescape_brackets_63, TMP_Substitutors_split_simple_csv_64, TMP_Substitutors_resolve_subs_67, TMP_Substitutors_resolve_block_subs_69, TMP_Substitutors_resolve_pass_subs_70, TMP_Substitutors_highlight_source_71, TMP_Substitutors_resolve_lines_to_highlight_76, TMP_Substitutors_sub_source_78, TMP_Substitutors_lock_in_subs_79;

      
      Opal.const_set($nesting[0], 'SpecialCharsRx', /[<&>]/);
      Opal.const_set($nesting[0], 'SpecialCharsTr', $hash2([">", "<", "&"], {">": "&gt;", "<": "&lt;", "&": "&amp;"}));
      Opal.const_set($nesting[0], 'QuotedTextSniffRx', $hash(false, /[*_`#^~]/, true, /[*'_+#^~]/));
      Opal.const_set($nesting[0], 'BASIC_SUBS', ["specialcharacters"]).$freeze();
      Opal.const_set($nesting[0], 'HEADER_SUBS', ["specialcharacters", "attributes"]).$freeze();
      Opal.const_set($nesting[0], 'NORMAL_SUBS', ["specialcharacters", "quotes", "attributes", "replacements", "macros", "post_replacements"]).$freeze();
      Opal.const_set($nesting[0], 'NONE_SUBS', []).$freeze();
      Opal.const_set($nesting[0], 'TITLE_SUBS', ["specialcharacters", "quotes", "replacements", "macros", "attributes", "post_replacements"]).$freeze();
      Opal.const_set($nesting[0], 'REFTEXT_SUBS', ["specialcharacters", "quotes", "replacements"]).$freeze();
      Opal.const_set($nesting[0], 'VERBATIM_SUBS', ["specialcharacters", "callouts"]).$freeze();
      Opal.const_set($nesting[0], 'SUB_GROUPS', $hash2(["none", "normal", "verbatim", "specialchars"], {"none": $$($nesting, 'NONE_SUBS'), "normal": $$($nesting, 'NORMAL_SUBS'), "verbatim": $$($nesting, 'VERBATIM_SUBS'), "specialchars": $$($nesting, 'BASIC_SUBS')}));
      Opal.const_set($nesting[0], 'SUB_HINTS', $hash2(["a", "m", "n", "p", "q", "r", "c", "v"], {"a": "attributes", "m": "macros", "n": "normal", "p": "post_replacements", "q": "quotes", "r": "replacements", "c": "specialcharacters", "v": "verbatim"}));
      Opal.const_set($nesting[0], 'SUB_OPTIONS', $hash2(["block", "inline"], {"block": $rb_plus($rb_plus($$($nesting, 'SUB_GROUPS').$keys(), $$($nesting, 'NORMAL_SUBS')), ["callouts"]), "inline": $rb_plus($$($nesting, 'SUB_GROUPS').$keys(), $$($nesting, 'NORMAL_SUBS'))}));
      Opal.const_set($nesting[0], 'SUB_HIGHLIGHT', ["coderay", "pygments"]);
      if ($truthy($$$('::', 'RUBY_MIN_VERSION_1_9'))) {
        
        Opal.const_set($nesting[0], 'CAN', "\u0018");
        Opal.const_set($nesting[0], 'DEL', "\u007F");
        Opal.const_set($nesting[0], 'PASS_START', "\u0096");
        Opal.const_set($nesting[0], 'PASS_END', "\u0097");
      } else {
        
        Opal.const_set($nesting[0], 'CAN', (24).$chr());
        Opal.const_set($nesting[0], 'DEL', (127).$chr());
        Opal.const_set($nesting[0], 'PASS_START', (150).$chr());
        Opal.const_set($nesting[0], 'PASS_END', (151).$chr());
      };
      Opal.const_set($nesting[0], 'PassSlotRx', new RegExp("" + ($$($nesting, 'PASS_START')) + "(\\d+)" + ($$($nesting, 'PASS_END'))));
      Opal.const_set($nesting[0], 'HighlightedPassSlotRx', new RegExp("" + "<span\\b[^>]*>" + ($$($nesting, 'PASS_START')) + "</span>[^\\d]*(\\d+)[^\\d]*<span\\b[^>]*>" + ($$($nesting, 'PASS_END')) + "</span>"));
      Opal.const_set($nesting[0], 'RS', "\\");
      Opal.const_set($nesting[0], 'R_SB', "]");
      Opal.const_set($nesting[0], 'ESC_R_SB', "\\]");
      Opal.const_set($nesting[0], 'PLUS', "+");
      Opal.const_set($nesting[0], 'PygmentsWrapperDivRx', /<div class="pyhl">(.*)<\/div>/m);
      Opal.const_set($nesting[0], 'PygmentsWrapperPreRx', /<pre\b[^>]*?>(.*?)<\/pre>\s*/m);
      self.$attr_reader("passthroughs");
      
      Opal.def(self, '$apply_subs', TMP_Substitutors_apply_subs_1 = function $$apply_subs(text, subs) {
        var $a, TMP_2, self = this, multiline = nil, has_passthroughs = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        
        if (subs == null) {
          subs = $$($nesting, 'NORMAL_SUBS');
        };
        if ($truthy(($truthy($a = text['$empty?']()) ? $a : subs['$!']()))) {
          return text};
        if ($truthy((multiline = $$$('::', 'Array')['$==='](text)))) {
          text = (function() {if ($truthy(text['$[]'](1))) {
            
            return text.$join($$($nesting, 'LF'));
          } else {
            return text['$[]'](0)
          }; return nil; })()};
        if ($truthy((has_passthroughs = subs['$include?']("macros")))) {
          
          text = self.$extract_passthroughs(text);
          if ($truthy(self.passthroughs['$empty?']())) {
            has_passthroughs = false};};
        $send(subs, 'each', [], (TMP_2 = function(type){var self = TMP_2.$$s || this, $case = nil;

        
          
          if (type == null) {
            type = nil;
          };
          return (function() {$case = type;
          if ("specialcharacters"['$===']($case)) {return (text = self.$sub_specialchars(text))}
          else if ("quotes"['$===']($case)) {return (text = self.$sub_quotes(text))}
          else if ("attributes"['$===']($case)) {if ($truthy(text['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
            return (text = self.$sub_attributes(text))
          } else {
            return nil
          }}
          else if ("replacements"['$===']($case)) {return (text = self.$sub_replacements(text))}
          else if ("macros"['$===']($case)) {return (text = self.$sub_macros(text))}
          else if ("highlight"['$===']($case)) {return (text = self.$highlight_source(text, subs['$include?']("callouts")))}
          else if ("callouts"['$===']($case)) {if ($truthy(subs['$include?']("highlight"))) {
            return nil
          } else {
            return (text = self.$sub_callouts(text))
          }}
          else if ("post_replacements"['$===']($case)) {return (text = self.$sub_post_replacements(text))}
          else {return self.$logger().$warn("" + "unknown substitution type " + (type))}})();}, TMP_2.$$s = self, TMP_2.$$arity = 1, TMP_2));
        if ($truthy(has_passthroughs)) {
          text = self.$restore_passthroughs(text)};
        if ($truthy(multiline)) {
          
          return text.$split($$($nesting, 'LF'), -1);
        } else {
          return text
        };
      }, TMP_Substitutors_apply_subs_1.$$arity = -2);
      
      Opal.def(self, '$apply_normal_subs', TMP_Substitutors_apply_normal_subs_3 = function $$apply_normal_subs(text) {
        var self = this;

        return self.$apply_subs(text)
      }, TMP_Substitutors_apply_normal_subs_3.$$arity = 1);
      
      Opal.def(self, '$apply_title_subs', TMP_Substitutors_apply_title_subs_4 = function $$apply_title_subs(title) {
        var self = this;

        return self.$apply_subs(title, $$($nesting, 'TITLE_SUBS'))
      }, TMP_Substitutors_apply_title_subs_4.$$arity = 1);
      
      Opal.def(self, '$apply_reftext_subs', TMP_Substitutors_apply_reftext_subs_5 = function $$apply_reftext_subs(text) {
        var self = this;

        return self.$apply_subs(text, $$($nesting, 'REFTEXT_SUBS'))
      }, TMP_Substitutors_apply_reftext_subs_5.$$arity = 1);
      
      Opal.def(self, '$apply_header_subs', TMP_Substitutors_apply_header_subs_6 = function $$apply_header_subs(text) {
        var self = this;

        return self.$apply_subs(text, $$($nesting, 'HEADER_SUBS'))
      }, TMP_Substitutors_apply_header_subs_6.$$arity = 1);
      
      Opal.def(self, '$extract_passthroughs', TMP_Substitutors_extract_passthroughs_7 = function $$extract_passthroughs(text) {
        var $a, $b, TMP_8, TMP_9, TMP_10, self = this, compat_mode = nil, passes = nil, pass_inline_char1 = nil, pass_inline_char2 = nil, pass_inline_rx = nil;
        if (self.document == null) self.document = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        compat_mode = self.document.$compat_mode();
        passes = self.passthroughs;
        if ($truthy(($truthy($a = ($truthy($b = text['$include?']("++")) ? $b : text['$include?']("$$"))) ? $a : text['$include?']("ss:")))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlinePassMacroRx')], (TMP_8 = function(){var self = TMP_8.$$s || this, $c, m = nil, preceding = nil, boundary = nil, attributes = nil, escape_count = nil, content = nil, old_behavior = nil, subs = nil, pass_key = nil, $writer = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            preceding = nil;
            if ($truthy((boundary = m['$[]'](4)))) {
              
              if ($truthy(($truthy($c = compat_mode) ? boundary['$==']("++") : $c))) {
                return (function() {if ($truthy(m['$[]'](2))) {
                  return "" + (m['$[]'](1)) + "[" + (m['$[]'](2)) + "]" + (m['$[]'](3)) + "++" + (self.$extract_passthroughs(m['$[]'](5))) + "++"
                } else {
                  return "" + (m['$[]'](1)) + (m['$[]'](3)) + "++" + (self.$extract_passthroughs(m['$[]'](5))) + "++"
                }; return nil; })();};
              attributes = m['$[]'](2);
              escape_count = m['$[]'](3).$length();
              content = m['$[]'](5);
              old_behavior = false;
              if ($truthy(attributes)) {
                if ($truthy($rb_gt(escape_count, 0))) {
                  return "" + (m['$[]'](1)) + "[" + (attributes) + "]" + ($rb_times($$($nesting, 'RS'), $rb_minus(escape_count, 1))) + (boundary) + (m['$[]'](5)) + (boundary);
                } else if (m['$[]'](1)['$==']($$($nesting, 'RS'))) {
                  
                  preceding = "" + "[" + (attributes) + "]";
                  attributes = nil;
                } else {
                  
                  if ($truthy((($c = boundary['$==']("++")) ? attributes['$end_with?']("x-") : boundary['$==']("++")))) {
                    
                    old_behavior = true;
                    attributes = attributes.$slice(0, $rb_minus(attributes.$length(), 2));};
                  attributes = self.$parse_quoted_text_attributes(attributes);
                }
              } else if ($truthy($rb_gt(escape_count, 0))) {
                return "" + ($rb_times($$($nesting, 'RS'), $rb_minus(escape_count, 1))) + (boundary) + (m['$[]'](5)) + (boundary);};
              subs = (function() {if (boundary['$==']("+++")) {
                return []
              } else {
                return $$($nesting, 'BASIC_SUBS')
              }; return nil; })();
              pass_key = passes.$size();
              if ($truthy(attributes)) {
                if ($truthy(old_behavior)) {
                  
                  $writer = [pass_key, $hash2(["text", "subs", "type", "attributes"], {"text": content, "subs": $$($nesting, 'NORMAL_SUBS'), "type": "monospaced", "attributes": attributes})];
                  $send(passes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                } else {
                  
                  $writer = [pass_key, $hash2(["text", "subs", "type", "attributes"], {"text": content, "subs": subs, "type": "unquoted", "attributes": attributes})];
                  $send(passes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                }
              } else {
                
                $writer = [pass_key, $hash2(["text", "subs"], {"text": content, "subs": subs})];
                $send(passes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
            } else {
              
              if (m['$[]'](6)['$==']($$($nesting, 'RS'))) {
                return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
              
              $writer = [(pass_key = passes.$size()), $hash2(["text", "subs"], {"text": self.$unescape_brackets(m['$[]'](8)), "subs": (function() {if ($truthy(m['$[]'](7))) {
                
                return self.$resolve_pass_subs(m['$[]'](7));
              } else {
                return nil
              }; return nil; })()})];
              $send(passes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
            };
            return "" + (preceding) + ($$($nesting, 'PASS_START')) + (pass_key) + ($$($nesting, 'PASS_END'));}, TMP_8.$$s = self, TMP_8.$$arity = 0, TMP_8))};
        $b = $$($nesting, 'InlinePassRx')['$[]'](compat_mode), $a = Opal.to_ary($b), (pass_inline_char1 = ($a[0] == null ? nil : $a[0])), (pass_inline_char2 = ($a[1] == null ? nil : $a[1])), (pass_inline_rx = ($a[2] == null ? nil : $a[2])), $b;
        if ($truthy(($truthy($a = text['$include?'](pass_inline_char1)) ? $a : ($truthy($b = pass_inline_char2) ? text['$include?'](pass_inline_char2) : $b)))) {
          text = $send(text, 'gsub', [pass_inline_rx], (TMP_9 = function(){var self = TMP_9.$$s || this, $c, m = nil, preceding = nil, attributes = nil, quoted_text = nil, escape_mark = nil, format_mark = nil, content = nil, old_behavior = nil, pass_key = nil, $writer = nil, subs = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            preceding = m['$[]'](1);
            attributes = m['$[]'](2);
            if ($truthy((quoted_text = m['$[]'](3))['$start_with?']($$($nesting, 'RS')))) {
              escape_mark = $$($nesting, 'RS')};
            format_mark = m['$[]'](4);
            content = m['$[]'](5);
            if ($truthy(compat_mode)) {
              old_behavior = true
            } else if ($truthy((old_behavior = ($truthy($c = attributes) ? attributes['$end_with?']("x-") : $c)))) {
              attributes = attributes.$slice(0, $rb_minus(attributes.$length(), 2))};
            if ($truthy(attributes)) {
              
              if ($truthy((($c = format_mark['$==']("`")) ? old_behavior['$!']() : format_mark['$==']("`")))) {
                return self.$extract_inner_passthrough(content, "" + (preceding) + "[" + (attributes) + "]" + (escape_mark), attributes);};
              if ($truthy(escape_mark)) {
                return "" + (preceding) + "[" + (attributes) + "]" + (quoted_text.$slice(1, quoted_text.$length()));
              } else if (preceding['$==']($$($nesting, 'RS'))) {
                
                preceding = "" + "[" + (attributes) + "]";
                attributes = nil;
              } else {
                attributes = self.$parse_quoted_text_attributes(attributes)
              };
            } else if ($truthy((($c = format_mark['$==']("`")) ? old_behavior['$!']() : format_mark['$==']("`")))) {
              return self.$extract_inner_passthrough(content, "" + (preceding) + (escape_mark));
            } else if ($truthy(escape_mark)) {
              return "" + (preceding) + (quoted_text.$slice(1, quoted_text.$length()));};
            pass_key = passes.$size();
            if ($truthy(compat_mode)) {
              
              $writer = [pass_key, $hash2(["text", "subs", "attributes", "type"], {"text": content, "subs": $$($nesting, 'BASIC_SUBS'), "attributes": attributes, "type": "monospaced"})];
              $send(passes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else if ($truthy(attributes)) {
              if ($truthy(old_behavior)) {
                
                subs = (function() {if (format_mark['$==']("`")) {
                  return $$($nesting, 'BASIC_SUBS')
                } else {
                  return $$($nesting, 'NORMAL_SUBS')
                }; return nil; })();
                
                $writer = [pass_key, $hash2(["text", "subs", "attributes", "type"], {"text": content, "subs": subs, "attributes": attributes, "type": "monospaced"})];
                $send(passes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
              } else {
                
                $writer = [pass_key, $hash2(["text", "subs", "attributes", "type"], {"text": content, "subs": $$($nesting, 'BASIC_SUBS'), "attributes": attributes, "type": "unquoted"})];
                $send(passes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              }
            } else {
              
              $writer = [pass_key, $hash2(["text", "subs"], {"text": content, "subs": $$($nesting, 'BASIC_SUBS')})];
              $send(passes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            return "" + (preceding) + ($$($nesting, 'PASS_START')) + (pass_key) + ($$($nesting, 'PASS_END'));}, TMP_9.$$s = self, TMP_9.$$arity = 0, TMP_9))};
        if ($truthy(($truthy($a = text['$include?'](":")) ? ($truthy($b = text['$include?']("stem:")) ? $b : text['$include?']("math:")) : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineStemMacroRx')], (TMP_10 = function(){var self = TMP_10.$$s || this, $c, m = nil, type = nil, content = nil, subs = nil, $writer = nil, pass_key = nil;
            if (self.document == null) self.document = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
            if ((type = m['$[]'](1).$to_sym())['$==']("stem")) {
              type = $$($nesting, 'STEM_TYPE_ALIASES')['$[]'](self.document.$attributes()['$[]']("stem")).$to_sym()};
            content = self.$unescape_brackets(m['$[]'](3));
            subs = (function() {if ($truthy(m['$[]'](2))) {
              
              return self.$resolve_pass_subs(m['$[]'](2));
            } else {
              
              if ($truthy(self.document['$basebackend?']("html"))) {
                return $$($nesting, 'BASIC_SUBS')
              } else {
                return nil
              };
            }; return nil; })();
            
            $writer = [(pass_key = passes.$size()), $hash2(["text", "subs", "type"], {"text": content, "subs": subs, "type": type})];
            $send(passes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return "" + ($$($nesting, 'PASS_START')) + (pass_key) + ($$($nesting, 'PASS_END'));}, TMP_10.$$s = self, TMP_10.$$arity = 0, TMP_10))};
        return text;
      }, TMP_Substitutors_extract_passthroughs_7.$$arity = 1);
      
      Opal.def(self, '$extract_inner_passthrough', TMP_Substitutors_extract_inner_passthrough_11 = function $$extract_inner_passthrough(text, pre, attributes) {
        var $a, $b, self = this, $writer = nil, pass_key = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        
        if (attributes == null) {
          attributes = nil;
        };
        if ($truthy(($truthy($a = ($truthy($b = text['$end_with?']("+")) ? text['$start_with?']("+", "\\+") : $b)) ? $$($nesting, 'SinglePlusInlinePassRx')['$=~'](text) : $a))) {
          if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))) {
            return "" + (pre) + "`+" + ((($a = $gvars['~']) === nil ? nil : $a['$[]'](2))) + "+`"
          } else {
            
            
            $writer = [(pass_key = self.passthroughs.$size()), (function() {if ($truthy(attributes)) {
              return $hash2(["text", "subs", "attributes", "type"], {"text": (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), "subs": $$($nesting, 'BASIC_SUBS'), "attributes": attributes, "type": "unquoted"})
            } else {
              return $hash2(["text", "subs"], {"text": (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), "subs": $$($nesting, 'BASIC_SUBS')})
            }; return nil; })()];
            $send(self.passthroughs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return "" + (pre) + "`" + ($$($nesting, 'PASS_START')) + (pass_key) + ($$($nesting, 'PASS_END')) + "`";
          }
        } else {
          return "" + (pre) + "`" + (text) + "`"
        };
      }, TMP_Substitutors_extract_inner_passthrough_11.$$arity = -3);
      
      Opal.def(self, '$restore_passthroughs', TMP_Substitutors_restore_passthroughs_12 = function $$restore_passthroughs(text, outer) {
        var TMP_13, self = this, passes = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        
        if (outer == null) {
          outer = true;
        };
        return (function() { try {
        
        passes = self.passthroughs;
        return $send(text, 'gsub', [$$($nesting, 'PassSlotRx')], (TMP_13 = function(){var self = TMP_13.$$s || this, $a, pass = nil, subbed_text = nil, type = nil;

        
          pass = passes['$[]']((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)).$to_i());
          subbed_text = self.$apply_subs(pass['$[]']("text"), pass['$[]']("subs"));
          if ($truthy((type = pass['$[]']("type")))) {
            subbed_text = $$($nesting, 'Inline').$new(self, "quoted", subbed_text, $hash2(["type", "attributes"], {"type": type, "attributes": pass['$[]']("attributes")})).$convert()};
          if ($truthy(subbed_text['$include?']($$($nesting, 'PASS_START')))) {
            return self.$restore_passthroughs(subbed_text, false)
          } else {
            return subbed_text
          };}, TMP_13.$$s = self, TMP_13.$$arity = 0, TMP_13));
        } finally {
          (function() {if ($truthy(outer)) {
            return passes.$clear()
          } else {
            return nil
          }; return nil; })()
        }; })();
      }, TMP_Substitutors_restore_passthroughs_12.$$arity = -2);
      if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
        
        
        Opal.def(self, '$sub_quotes', TMP_Substitutors_sub_quotes_14 = function $$sub_quotes(text) {
          var TMP_15, self = this, compat = nil;
          if (self.document == null) self.document = nil;

          
          if ($truthy($$($nesting, 'QuotedTextSniffRx')['$[]']((compat = self.document.$compat_mode()))['$match?'](text))) {
            $send($$($nesting, 'QUOTE_SUBS')['$[]'](compat), 'each', [], (TMP_15 = function(type, scope, pattern){var self = TMP_15.$$s || this, TMP_16;

            
              
              if (type == null) {
                type = nil;
              };
              
              if (scope == null) {
                scope = nil;
              };
              
              if (pattern == null) {
                pattern = nil;
              };
              return (text = $send(text, 'gsub', [pattern], (TMP_16 = function(){var self = TMP_16.$$s || this;
                if ($gvars["~"] == null) $gvars["~"] = nil;

              return self.$convert_quoted_text($gvars["~"], type, scope)}, TMP_16.$$s = self, TMP_16.$$arity = 0, TMP_16)));}, TMP_15.$$s = self, TMP_15.$$arity = 3, TMP_15))};
          return text;
        }, TMP_Substitutors_sub_quotes_14.$$arity = 1);
        
        Opal.def(self, '$sub_replacements', TMP_Substitutors_sub_replacements_17 = function $$sub_replacements(text) {
          var TMP_18, self = this;

          
          if ($truthy($$($nesting, 'ReplaceableTextRx')['$match?'](text))) {
            $send($$($nesting, 'REPLACEMENTS'), 'each', [], (TMP_18 = function(pattern, replacement, restore){var self = TMP_18.$$s || this, TMP_19;

            
              
              if (pattern == null) {
                pattern = nil;
              };
              
              if (replacement == null) {
                replacement = nil;
              };
              
              if (restore == null) {
                restore = nil;
              };
              return (text = $send(text, 'gsub', [pattern], (TMP_19 = function(){var self = TMP_19.$$s || this;
                if ($gvars["~"] == null) $gvars["~"] = nil;

              return self.$do_replacement($gvars["~"], replacement, restore)}, TMP_19.$$s = self, TMP_19.$$arity = 0, TMP_19)));}, TMP_18.$$s = self, TMP_18.$$arity = 3, TMP_18))};
          return text;
        }, TMP_Substitutors_sub_replacements_17.$$arity = 1);
      } else {
        nil
      };
      if ($truthy($$$('::', 'RUBY_MIN_VERSION_1_9'))) {
        
        Opal.def(self, '$sub_specialchars', TMP_Substitutors_sub_specialchars_20 = function $$sub_specialchars(text) {
          var $a, $b, self = this;

          if ($truthy(($truthy($a = ($truthy($b = text['$include?']("<")) ? $b : text['$include?']("&"))) ? $a : text['$include?'](">")))) {
            
            return text.$gsub($$($nesting, 'SpecialCharsRx'), $$($nesting, 'SpecialCharsTr'));
          } else {
            return text
          }
        }, TMP_Substitutors_sub_specialchars_20.$$arity = 1)
      } else {
        
        Opal.def(self, '$sub_specialchars', TMP_Substitutors_sub_specialchars_21 = function $$sub_specialchars(text) {
          var $a, $b, TMP_22, self = this;

          if ($truthy(($truthy($a = ($truthy($b = text['$include?']("<")) ? $b : text['$include?']("&"))) ? $a : text['$include?'](">")))) {
            
            return $send(text, 'gsub', [$$($nesting, 'SpecialCharsRx')], (TMP_22 = function(){var self = TMP_22.$$s || this, $c;

            return $$($nesting, 'SpecialCharsTr')['$[]']((($c = $gvars['~']) === nil ? nil : $c['$[]'](0)))}, TMP_22.$$s = self, TMP_22.$$arity = 0, TMP_22));
          } else {
            return text
          }
        }, TMP_Substitutors_sub_specialchars_21.$$arity = 1)
      };
      Opal.alias(self, "sub_specialcharacters", "sub_specialchars");
      
      Opal.def(self, '$do_replacement', TMP_Substitutors_do_replacement_23 = function $$do_replacement(m, replacement, restore) {
        var self = this, captured = nil, $case = nil;

        if ($truthy((captured = m['$[]'](0))['$include?']($$($nesting, 'RS')))) {
          return captured.$sub($$($nesting, 'RS'), "")
        } else {
          return (function() {$case = restore;
          if ("none"['$===']($case)) {return replacement}
          else if ("bounding"['$===']($case)) {return "" + (m['$[]'](1)) + (replacement) + (m['$[]'](2))}
          else {return "" + (m['$[]'](1)) + (replacement)}})()
        }
      }, TMP_Substitutors_do_replacement_23.$$arity = 3);
      
      Opal.def(self, '$sub_attributes', TMP_Substitutors_sub_attributes_24 = function $$sub_attributes(text, opts) {
        var TMP_25, TMP_26, TMP_27, TMP_28, self = this, doc_attrs = nil, drop = nil, drop_line = nil, drop_empty_line = nil, attribute_undefined = nil, attribute_missing = nil, lines = nil;
        if (self.document == null) self.document = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        doc_attrs = self.document.$attributes();
        drop = (drop_line = (drop_empty_line = (attribute_undefined = (attribute_missing = nil))));
        text = $send(text, 'gsub', [$$($nesting, 'AttributeReferenceRx')], (TMP_25 = function(){var self = TMP_25.$$s || this, $a, $b, $c, $case = nil, args = nil, _ = nil, value = nil, key = nil;
          if (self.document == null) self.document = nil;

        if ($truthy(($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))['$==']($$($nesting, 'RS'))) ? $a : (($b = $gvars['~']) === nil ? nil : $b['$[]'](4))['$==']($$($nesting, 'RS'))))) {
            return "" + "{" + ((($a = $gvars['~']) === nil ? nil : $a['$[]'](2))) + "}"
          } else if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](3)))) {
            return (function() {$case = (args = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)).$split(":", 3)).$shift();
            if ("set"['$===']($case)) {
            $b = $$($nesting, 'Parser').$store_attribute(args['$[]'](0), ($truthy($c = args['$[]'](1)) ? $c : ""), self.document), $a = Opal.to_ary($b), (_ = ($a[0] == null ? nil : $a[0])), (value = ($a[1] == null ? nil : $a[1])), $b;
            if ($truthy(($truthy($a = value) ? $a : (attribute_undefined = ($truthy($b = attribute_undefined) ? $b : ($truthy($c = doc_attrs['$[]']("attribute-undefined")) ? $c : $$($nesting, 'Compliance').$attribute_undefined())))['$!=']("drop-line")))) {
              return (drop = (drop_empty_line = $$($nesting, 'DEL')))
            } else {
              return (drop = (drop_line = $$($nesting, 'CAN')))
            };}
            else if ("counter2"['$===']($case)) {
            $send(self.document, 'counter', Opal.to_a(args));
            return (drop = (drop_empty_line = $$($nesting, 'DEL')));}
            else {return $send(self.document, 'counter', Opal.to_a(args))}})()
          } else if ($truthy(doc_attrs['$key?']((key = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)).$downcase())))) {
            return doc_attrs['$[]'](key)
          } else if ($truthy((value = $$($nesting, 'INTRINSIC_ATTRIBUTES')['$[]'](key)))) {
            return value
          } else {
            return (function() {$case = (attribute_missing = ($truthy($a = attribute_missing) ? $a : ($truthy($b = ($truthy($c = opts['$[]']("attribute_missing")) ? $c : doc_attrs['$[]']("attribute-missing"))) ? $b : $$($nesting, 'Compliance').$attribute_missing())));
            if ("drop"['$===']($case)) {return (drop = (drop_empty_line = $$($nesting, 'DEL')))}
            else if ("drop-line"['$===']($case)) {
            self.$logger().$warn("" + "dropping line containing reference to missing attribute: " + (key));
            return (drop = (drop_line = $$($nesting, 'CAN')));}
            else if ("warn"['$===']($case)) {
            self.$logger().$warn("" + "skipping reference to missing attribute: " + (key));
            return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0));}
            else {return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0))}})()
          }}, TMP_25.$$s = self, TMP_25.$$arity = 0, TMP_25));
        if ($truthy(drop)) {
          if ($truthy(drop_empty_line)) {
            
            lines = text.$tr_s($$($nesting, 'DEL'), $$($nesting, 'DEL')).$split($$($nesting, 'LF'), -1);
            if ($truthy(drop_line)) {
              return $send(lines, 'reject', [], (TMP_26 = function(line){var self = TMP_26.$$s || this, $a, $b, $c;

              
                
                if (line == null) {
                  line = nil;
                };
                return ($truthy($a = ($truthy($b = ($truthy($c = line['$==']($$($nesting, 'DEL'))) ? $c : line['$==']($$($nesting, 'CAN')))) ? $b : line['$start_with?']($$($nesting, 'CAN')))) ? $a : line['$include?']($$($nesting, 'CAN')));}, TMP_26.$$s = self, TMP_26.$$arity = 1, TMP_26)).$join($$($nesting, 'LF')).$delete($$($nesting, 'DEL'))
            } else {
              return $send(lines, 'reject', [], (TMP_27 = function(line){var self = TMP_27.$$s || this;

              
                
                if (line == null) {
                  line = nil;
                };
                return line['$==']($$($nesting, 'DEL'));}, TMP_27.$$s = self, TMP_27.$$arity = 1, TMP_27)).$join($$($nesting, 'LF')).$delete($$($nesting, 'DEL'))
            };
          } else if ($truthy(text['$include?']($$($nesting, 'LF')))) {
            return $send(text.$split($$($nesting, 'LF'), -1), 'reject', [], (TMP_28 = function(line){var self = TMP_28.$$s || this, $a, $b;

            
              
              if (line == null) {
                line = nil;
              };
              return ($truthy($a = ($truthy($b = line['$==']($$($nesting, 'CAN'))) ? $b : line['$start_with?']($$($nesting, 'CAN')))) ? $a : line['$include?']($$($nesting, 'CAN')));}, TMP_28.$$s = self, TMP_28.$$arity = 1, TMP_28)).$join($$($nesting, 'LF'))
          } else {
            return ""
          }
        } else {
          return text
        };
      }, TMP_Substitutors_sub_attributes_24.$$arity = -2);
      
      Opal.def(self, '$sub_macros', TMP_Substitutors_sub_macros_29 = function $$sub_macros(text) {try {

        var $a, $b, TMP_30, TMP_33, TMP_35, TMP_37, TMP_39, TMP_40, TMP_41, TMP_42, TMP_43, TMP_44, self = this, found = nil, found_square_bracket = nil, $writer = nil, found_colon = nil, found_macroish = nil, found_macroish_short = nil, doc_attrs = nil, doc = nil, extensions = nil;
        if (self.document == null) self.document = nil;

        
        found = $hash2([], {});
        found_square_bracket = (($writer = ["square_bracket", text['$include?']("[")]), $send(found, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
        found_colon = text['$include?'](":");
        found_macroish = (($writer = ["macroish", ($truthy($a = found_square_bracket) ? found_colon : $a)]), $send(found, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
        found_macroish_short = ($truthy($a = found_macroish) ? text['$include?'](":[") : $a);
        doc_attrs = (doc = self.document).$attributes();
        if ($truthy(doc_attrs['$key?']("experimental"))) {
          
          if ($truthy(($truthy($a = found_macroish_short) ? ($truthy($b = text['$include?']("kbd:")) ? $b : text['$include?']("btn:")) : $a))) {
            text = $send(text, 'gsub', [$$($nesting, 'InlineKbdBtnMacroRx')], (TMP_30 = function(){var self = TMP_30.$$s || this, $c, TMP_31, TMP_32, keys = nil, delim_idx = nil, delim = nil;

            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](1)))) {
                return (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$slice(1, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$length())
              } else if ((($c = $gvars['~']) === nil ? nil : $c['$[]'](2))['$==']("kbd")) {
                
                if ($truthy((keys = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3)).$strip())['$include?']($$($nesting, 'R_SB')))) {
                  keys = keys.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
                if ($truthy(($truthy($c = $rb_gt(keys.$length(), 1)) ? (delim_idx = (function() {if ($truthy((delim_idx = keys.$index(",", 1)))) {
                  return [delim_idx, keys.$index("+", 1)].$compact().$min()
                } else {
                  
                  return keys.$index("+", 1);
                }; return nil; })()) : $c))) {
                  
                  delim = keys.$slice(delim_idx, 1);
                  if ($truthy(keys['$end_with?'](delim))) {
                    
                    keys = $send(keys.$chop().$split(delim, -1), 'map', [], (TMP_31 = function(key){var self = TMP_31.$$s || this;

                    
                      
                      if (key == null) {
                        key = nil;
                      };
                      return key.$strip();}, TMP_31.$$s = self, TMP_31.$$arity = 1, TMP_31));
                    
                    $writer = [-1, "" + (keys['$[]'](-1)) + (delim)];
                    $send(keys, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                  } else {
                    keys = $send(keys.$split(delim), 'map', [], (TMP_32 = function(key){var self = TMP_32.$$s || this;

                    
                      
                      if (key == null) {
                        key = nil;
                      };
                      return key.$strip();}, TMP_32.$$s = self, TMP_32.$$arity = 1, TMP_32))
                  };
                } else {
                  keys = [keys]
                };
                return $$($nesting, 'Inline').$new(self, "kbd", nil, $hash2(["attributes"], {"attributes": $hash2(["keys"], {"keys": keys})})).$convert();
              } else {
                return $$($nesting, 'Inline').$new(self, "button", self.$unescape_bracketed_text((($c = $gvars['~']) === nil ? nil : $c['$[]'](3)))).$convert()
              }}, TMP_30.$$s = self, TMP_30.$$arity = 0, TMP_30))};
          if ($truthy(($truthy($a = found_macroish) ? text['$include?']("menu:") : $a))) {
            text = $send(text, 'gsub', [$$($nesting, 'InlineMenuMacroRx')], (TMP_33 = function(){var self = TMP_33.$$s || this, $c, TMP_34, m = nil, menu = nil, items = nil, delim = nil, submenus = nil, menuitem = nil;
              if ($gvars["~"] == null) $gvars["~"] = nil;

            
              m = $gvars["~"];
              if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
                return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
              $c = [m['$[]'](1), m['$[]'](2)], (menu = $c[0]), (items = $c[1]), $c;
              if ($truthy(items)) {
                
                if ($truthy(items['$include?']($$($nesting, 'R_SB')))) {
                  items = items.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
                if ($truthy((delim = (function() {if ($truthy(items['$include?']("&gt;"))) {
                  return "&gt;"
                } else {
                  
                  if ($truthy(items['$include?'](","))) {
                    return ","
                  } else {
                    return nil
                  };
                }; return nil; })()))) {
                  
                  submenus = $send(items.$split(delim), 'map', [], (TMP_34 = function(it){var self = TMP_34.$$s || this;

                  
                    
                    if (it == null) {
                      it = nil;
                    };
                    return it.$strip();}, TMP_34.$$s = self, TMP_34.$$arity = 1, TMP_34));
                  menuitem = submenus.$pop();
                } else {
                  $c = [[], items.$rstrip()], (submenus = $c[0]), (menuitem = $c[1]), $c
                };
              } else {
                $c = [[], nil], (submenus = $c[0]), (menuitem = $c[1]), $c
              };
              return $$($nesting, 'Inline').$new(self, "menu", nil, $hash2(["attributes"], {"attributes": $hash2(["menu", "submenus", "menuitem"], {"menu": menu, "submenus": submenus, "menuitem": menuitem})})).$convert();}, TMP_33.$$s = self, TMP_33.$$arity = 0, TMP_33))};
          if ($truthy(($truthy($a = text['$include?']("\"")) ? text['$include?']("&gt;") : $a))) {
            text = $send(text, 'gsub', [$$($nesting, 'InlineMenuRx')], (TMP_35 = function(){var self = TMP_35.$$s || this, $c, $d, TMP_36, m = nil, input = nil, menu = nil, submenus = nil, menuitem = nil;
              if ($gvars["~"] == null) $gvars["~"] = nil;

            
              m = $gvars["~"];
              if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
                return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
              input = m['$[]'](1);
              $d = $send(input.$split("&gt;"), 'map', [], (TMP_36 = function(it){var self = TMP_36.$$s || this;

              
                
                if (it == null) {
                  it = nil;
                };
                return it.$strip();}, TMP_36.$$s = self, TMP_36.$$arity = 1, TMP_36)), $c = Opal.to_ary($d), (menu = ($c[0] == null ? nil : $c[0])), (submenus = $slice.call($c, 1)), $d;
              menuitem = submenus.$pop();
              return $$($nesting, 'Inline').$new(self, "menu", nil, $hash2(["attributes"], {"attributes": $hash2(["menu", "submenus", "menuitem"], {"menu": menu, "submenus": submenus, "menuitem": menuitem})})).$convert();}, TMP_35.$$s = self, TMP_35.$$arity = 0, TMP_35))};};
        if ($truthy(($truthy($a = (extensions = doc.$extensions())) ? extensions['$inline_macros?']() : $a))) {
          $send(extensions.$inline_macros(), 'each', [], (TMP_37 = function(extension){var self = TMP_37.$$s || this, TMP_38;

          
            
            if (extension == null) {
              extension = nil;
            };
            return (text = $send(text, 'gsub', [extension.$instance().$regexp()], (TMP_38 = function(){var self = TMP_38.$$s || this, $c, m = nil, target = nil, content = nil, extconf = nil, attributes = nil, replacement = nil;
              if ($gvars["~"] == null) $gvars["~"] = nil;

            
              m = $gvars["~"];
              if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
                return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
              if ($truthy((function() { try {
                return m.$names()
              } catch ($err) {
                if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                  try {
                    return []
                  } finally { Opal.pop_exception() }
                } else { throw $err; }
              }})()['$empty?']())) {
                $c = [m['$[]'](1), m['$[]'](2), extension.$config()], (target = $c[0]), (content = $c[1]), (extconf = $c[2]), $c
              } else {
                $c = [(function() { try {
                  return m['$[]']("target")
                } catch ($err) {
                  if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                    try {
                      return nil
                    } finally { Opal.pop_exception() }
                  } else { throw $err; }
                }})(), (function() { try {
                  return m['$[]']("content")
                } catch ($err) {
                  if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                    try {
                      return nil
                    } finally { Opal.pop_exception() }
                  } else { throw $err; }
                }})(), extension.$config()], (target = $c[0]), (content = $c[1]), (extconf = $c[2]), $c
              };
              attributes = (function() {if ($truthy((attributes = extconf['$[]']("default_attrs")))) {
                return attributes.$dup()
              } else {
                return $hash2([], {})
              }; return nil; })();
              if ($truthy(content['$nil_or_empty?']())) {
                if ($truthy(($truthy($c = content) ? extconf['$[]']("content_model")['$!=']("attributes") : $c))) {
                  
                  $writer = ["text", content];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];}
              } else {
                
                content = self.$unescape_bracketed_text(content);
                if (extconf['$[]']("content_model")['$==']("attributes")) {
                  self.$parse_attributes(content, ($truthy($c = extconf['$[]']("pos_attrs")) ? $c : []), $hash2(["into"], {"into": attributes}))
                } else {
                  
                  $writer = ["text", content];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                };
              };
              replacement = extension.$process_method()['$[]'](self, ($truthy($c = target) ? $c : content), attributes);
              if ($truthy($$($nesting, 'Inline')['$==='](replacement))) {
                return replacement.$convert()
              } else {
                return replacement
              };}, TMP_38.$$s = self, TMP_38.$$arity = 0, TMP_38)));}, TMP_37.$$s = self, TMP_37.$$arity = 1, TMP_37))};
        if ($truthy(($truthy($a = found_macroish) ? ($truthy($b = text['$include?']("image:")) ? $b : text['$include?']("icon:")) : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineImageMacroRx')], (TMP_39 = function(){var self = TMP_39.$$s || this, $c, m = nil, captured = nil, type = nil, posattrs = nil, target = nil, attrs = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            if ($truthy((captured = (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)))['$start_with?']($$($nesting, 'RS')))) {
              return captured.$slice(1, captured.$length());
            } else if ($truthy(captured['$start_with?']("icon:"))) {
              $c = ["icon", ["size"]], (type = $c[0]), (posattrs = $c[1]), $c
            } else {
              $c = ["image", ["alt", "width", "height"]], (type = $c[0]), (posattrs = $c[1]), $c
            };
            if ($truthy((target = m['$[]'](1))['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
              target = self.$sub_attributes(target)};
            attrs = self.$parse_attributes(m['$[]'](2), posattrs, $hash2(["unescape_input"], {"unescape_input": true}));
            if (type['$==']("icon")) {
            } else {
              doc.$register("images", [target, (($writer = ["imagesdir", doc_attrs['$[]']("imagesdir")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])])
            };
            ($truthy($c = attrs['$[]']("alt")) ? $c : (($writer = ["alt", (($writer = ["default-alt", $$($nesting, 'Helpers').$basename(target, true).$tr("_-", " ")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            return $$($nesting, 'Inline').$new(self, "image", nil, $hash2(["type", "target", "attributes"], {"type": type, "target": target, "attributes": attrs})).$convert();}, TMP_39.$$s = self, TMP_39.$$arity = 0, TMP_39))};
        if ($truthy(($truthy($a = ($truthy($b = text['$include?']("((")) ? text['$include?']("))") : $b)) ? $a : ($truthy($b = found_macroish_short) ? text['$include?']("dexterm") : $b)))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineIndextermMacroRx')], (TMP_40 = function(){var self = TMP_40.$$s || this, $c, captured = nil, $case = nil, terms = nil, term = nil, visible = nil, before = nil, after = nil, subbed_term = nil;

          
            captured = (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));
            return (function() {$case = (($c = $gvars['~']) === nil ? nil : $c['$[]'](1));
            if ("indexterm"['$===']($case)) {
            text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2));
            if ($truthy(captured['$start_with?']($$($nesting, 'RS')))) {
              return captured.$slice(1, captured.$length());};
            terms = self.$split_simple_csv(self.$normalize_string(text, true));
            doc.$register("indexterms", terms);
            return $$($nesting, 'Inline').$new(self, "indexterm", nil, $hash2(["attributes"], {"attributes": $hash2(["terms"], {"terms": terms})})).$convert();}
            else if ("indexterm2"['$===']($case)) {
            text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2));
            if ($truthy(captured['$start_with?']($$($nesting, 'RS')))) {
              return captured.$slice(1, captured.$length());};
            term = self.$normalize_string(text, true);
            doc.$register("indexterms", [term]);
            return $$($nesting, 'Inline').$new(self, "indexterm", term, $hash2(["type"], {"type": "visible"})).$convert();}
            else {
            text = (($c = $gvars['~']) === nil ? nil : $c['$[]'](3));
            if ($truthy(captured['$start_with?']($$($nesting, 'RS')))) {
              if ($truthy(($truthy($c = text['$start_with?']("(")) ? text['$end_with?'](")") : $c))) {
                
                text = text.$slice(1, $rb_minus(text.$length(), 2));
                $c = [true, "(", ")"], (visible = $c[0]), (before = $c[1]), (after = $c[2]), $c;
              } else {
                return captured.$slice(1, captured.$length());
              }
            } else {
              
              visible = true;
              if ($truthy(text['$start_with?']("("))) {
                if ($truthy(text['$end_with?'](")"))) {
                  $c = [text.$slice(1, $rb_minus(text.$length(), 2)), false], (text = $c[0]), (visible = $c[1]), $c
                } else {
                  $c = [text.$slice(1, text.$length()), "(", ""], (text = $c[0]), (before = $c[1]), (after = $c[2]), $c
                }
              } else if ($truthy(text['$end_with?'](")"))) {
                $c = [text.$slice(0, $rb_minus(text.$length(), 1)), "", ")"], (text = $c[0]), (before = $c[1]), (after = $c[2]), $c};
            };
            if ($truthy(visible)) {
              
              term = self.$normalize_string(text);
              doc.$register("indexterms", [term]);
              subbed_term = $$($nesting, 'Inline').$new(self, "indexterm", term, $hash2(["type"], {"type": "visible"})).$convert();
            } else {
              
              terms = self.$split_simple_csv(self.$normalize_string(text));
              doc.$register("indexterms", terms);
              subbed_term = $$($nesting, 'Inline').$new(self, "indexterm", nil, $hash2(["attributes"], {"attributes": $hash2(["terms"], {"terms": terms})})).$convert();
            };
            if ($truthy(before)) {
              return "" + (before) + (subbed_term) + (after)
            } else {
              return subbed_term
            };}})();}, TMP_40.$$s = self, TMP_40.$$arity = 0, TMP_40))};
        if ($truthy(($truthy($a = found_colon) ? text['$include?']("://") : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineLinkRx')], (TMP_41 = function(){var self = TMP_41.$$s || this, $c, $d, m = nil, target = nil, macro = nil, prefix = nil, suffix = nil, $case = nil, attrs = nil, link_opts = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            if ($truthy((target = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2)))['$start_with?']($$($nesting, 'RS')))) {
              return "" + (m['$[]'](1)) + (target.$slice(1, target.$length())) + (m['$[]'](3));};
            $c = [m['$[]'](1), ($truthy($d = (macro = m['$[]'](3))) ? $d : ""), ""], (prefix = $c[0]), (text = $c[1]), (suffix = $c[2]), $c;
            if (prefix['$==']("link:")) {
              if ($truthy(macro)) {
                prefix = ""
              } else {
                return m['$[]'](0);
              }};
            if ($truthy(($truthy($c = macro) ? $c : $$($nesting, 'UriTerminatorRx')['$!~'](target)))) {
            } else {
              
              $case = (($c = $gvars['~']) === nil ? nil : $c['$[]'](0));
              if (")"['$===']($case)) {
              target = target.$chop();
              suffix = ")";}
              else if (";"['$===']($case)) {if ($truthy(($truthy($c = prefix['$start_with?']("&lt;")) ? target['$end_with?']("&gt;") : $c))) {
                
                prefix = prefix.$slice(4, prefix.$length());
                target = target.$slice(0, $rb_minus(target.$length(), 4));
              } else if ($truthy((target = target.$chop())['$end_with?'](")"))) {
                
                target = target.$chop();
                suffix = ");";
              } else {
                suffix = ";"
              }}
              else if (":"['$===']($case)) {if ($truthy((target = target.$chop())['$end_with?'](")"))) {
                
                target = target.$chop();
                suffix = "):";
              } else {
                suffix = ":"
              }};
              if ($truthy(target['$end_with?']("://"))) {
                Opal.ret(m['$[]'](0))};
            };
            $c = [nil, $hash2(["type"], {"type": "link"})], (attrs = $c[0]), (link_opts = $c[1]), $c;
            if ($truthy(text['$empty?']())) {
            } else {
              
              if ($truthy(text['$include?']($$($nesting, 'R_SB')))) {
                text = text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
              if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? text['$include?']("=") : $c))) {
                
                text = ($truthy($c = (attrs = $$($nesting, 'AttributeList').$new(text, self).$parse())['$[]'](1)) ? $c : "");
                if ($truthy(attrs['$key?']("id"))) {
                  
                  $writer = ["id", attrs.$delete("id")];
                  $send(link_opts, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};};
              if ($truthy(text['$end_with?']("^"))) {
                
                text = text.$chop();
                if ($truthy(attrs)) {
                  ($truthy($c = attrs['$[]']("window")) ? $c : (($writer = ["window", "_blank"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
                } else {
                  attrs = $hash2(["window"], {"window": "_blank"})
                };};
            };
            if ($truthy(text['$empty?']())) {
              
              text = (function() {if ($truthy(doc_attrs['$key?']("hide-uri-scheme"))) {
                
                return target.$sub($$($nesting, 'UriSniffRx'), "");
              } else {
                return target
              }; return nil; })();
              if ($truthy(attrs)) {
                
                $writer = ["role", (function() {if ($truthy(attrs['$key?']("role"))) {
                  return "" + "bare " + (attrs['$[]']("role"))
                } else {
                  return "bare"
                }; return nil; })()];
                $send(attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              } else {
                attrs = $hash2(["role"], {"role": "bare"})
              };};
            doc.$register("links", (($writer = ["target", target]), $send(link_opts, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            if ($truthy(attrs)) {
              
              $writer = ["attributes", attrs];
              $send(link_opts, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            return "" + (prefix) + ($$($nesting, 'Inline').$new(self, "anchor", text, link_opts).$convert()) + (suffix);}, TMP_41.$$s = self, TMP_41.$$arity = 0, TMP_41))};
        if ($truthy(($truthy($a = found_macroish) ? ($truthy($b = text['$include?']("link:")) ? $b : text['$include?']("mailto:")) : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineLinkMacroRx')], (TMP_42 = function(){var self = TMP_42.$$s || this, $c, m = nil, target = nil, mailto = nil, attrs = nil, link_opts = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
            target = (function() {if ($truthy((mailto = m['$[]'](1)))) {
              return "" + "mailto:" + (m['$[]'](2))
            } else {
              return m['$[]'](2)
            }; return nil; })();
            $c = [nil, $hash2(["type"], {"type": "link"})], (attrs = $c[0]), (link_opts = $c[1]), $c;
            if ($truthy((text = m['$[]'](3))['$empty?']())) {
            } else {
              
              if ($truthy(text['$include?']($$($nesting, 'R_SB')))) {
                text = text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
              if ($truthy(mailto)) {
                if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? text['$include?'](",") : $c))) {
                  
                  text = ($truthy($c = (attrs = $$($nesting, 'AttributeList').$new(text, self).$parse())['$[]'](1)) ? $c : "");
                  if ($truthy(attrs['$key?']("id"))) {
                    
                    $writer = ["id", attrs.$delete("id")];
                    $send(link_opts, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];};
                  if ($truthy(attrs['$key?'](2))) {
                    if ($truthy(attrs['$key?'](3))) {
                      target = "" + (target) + "?subject=" + ($$($nesting, 'Helpers').$uri_encode(attrs['$[]'](2))) + "&amp;body=" + ($$($nesting, 'Helpers').$uri_encode(attrs['$[]'](3)))
                    } else {
                      target = "" + (target) + "?subject=" + ($$($nesting, 'Helpers').$uri_encode(attrs['$[]'](2)))
                    }};}
              } else if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? text['$include?']("=") : $c))) {
                
                text = ($truthy($c = (attrs = $$($nesting, 'AttributeList').$new(text, self).$parse())['$[]'](1)) ? $c : "");
                if ($truthy(attrs['$key?']("id"))) {
                  
                  $writer = ["id", attrs.$delete("id")];
                  $send(link_opts, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};};
              if ($truthy(text['$end_with?']("^"))) {
                
                text = text.$chop();
                if ($truthy(attrs)) {
                  ($truthy($c = attrs['$[]']("window")) ? $c : (($writer = ["window", "_blank"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
                } else {
                  attrs = $hash2(["window"], {"window": "_blank"})
                };};
            };
            if ($truthy(text['$empty?']())) {
              if ($truthy(mailto)) {
                text = m['$[]'](2)
              } else {
                
                if ($truthy(doc_attrs['$key?']("hide-uri-scheme"))) {
                  if ($truthy((text = target.$sub($$($nesting, 'UriSniffRx'), ""))['$empty?']())) {
                    text = target}
                } else {
                  text = target
                };
                if ($truthy(attrs)) {
                  
                  $writer = ["role", (function() {if ($truthy(attrs['$key?']("role"))) {
                    return "" + "bare " + (attrs['$[]']("role"))
                  } else {
                    return "bare"
                  }; return nil; })()];
                  $send(attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                } else {
                  attrs = $hash2(["role"], {"role": "bare"})
                };
              }};
            doc.$register("links", (($writer = ["target", target]), $send(link_opts, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            if ($truthy(attrs)) {
              
              $writer = ["attributes", attrs];
              $send(link_opts, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            return $$($nesting, 'Inline').$new(self, "anchor", text, link_opts).$convert();}, TMP_42.$$s = self, TMP_42.$$arity = 0, TMP_42))};
        if ($truthy(text['$include?']("@"))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineEmailRx')], (TMP_43 = function(){var self = TMP_43.$$s || this, $c, $d, address = nil, tip = nil, target = nil;

          
            $c = [(($d = $gvars['~']) === nil ? nil : $d['$[]'](0)), (($d = $gvars['~']) === nil ? nil : $d['$[]'](1))], (address = $c[0]), (tip = $c[1]), $c;
            if ($truthy(tip)) {
              return (function() {if (tip['$==']($$($nesting, 'RS'))) {
                
                return address.$slice(1, address.$length());
              } else {
                return address
              }; return nil; })();};
            target = "" + "mailto:" + (address);
            doc.$register("links", target);
            return $$($nesting, 'Inline').$new(self, "anchor", address, $hash2(["type", "target"], {"type": "link", "target": target})).$convert();}, TMP_43.$$s = self, TMP_43.$$arity = 0, TMP_43))};
        if ($truthy(($truthy($a = found_macroish) ? text['$include?']("tnote") : $a))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineFootnoteMacroRx')], (TMP_44 = function(){var self = TMP_44.$$s || this, $c, $d, $e, TMP_45, m = nil, id = nil, index = nil, type = nil, target = nil, footnote = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
            if ($truthy(m['$[]'](1))) {
              $d = ($truthy($e = m['$[]'](3)) ? $e : "").$split(",", 2), $c = Opal.to_ary($d), (id = ($c[0] == null ? nil : $c[0])), (text = ($c[1] == null ? nil : $c[1])), $d
            } else {
              $c = [m['$[]'](2), m['$[]'](3)], (id = $c[0]), (text = $c[1]), $c
            };
            if ($truthy(id)) {
              if ($truthy(text)) {
                
                text = self.$restore_passthroughs(self.$sub_inline_xrefs(self.$sub_inline_anchors(self.$normalize_string(text, true))), false);
                index = doc.$counter("footnote-number");
                doc.$register("footnotes", $$$($$($nesting, 'Document'), 'Footnote').$new(index, id, text));
                $c = ["ref", nil], (type = $c[0]), (target = $c[1]), $c;
              } else {
                
                if ($truthy((footnote = $send(doc.$footnotes(), 'find', [], (TMP_45 = function(candidate){var self = TMP_45.$$s || this;

                
                  
                  if (candidate == null) {
                    candidate = nil;
                  };
                  return candidate.$id()['$=='](id);}, TMP_45.$$s = self, TMP_45.$$arity = 1, TMP_45))))) {
                  $c = [footnote.$index(), footnote.$text()], (index = $c[0]), (text = $c[1]), $c
                } else {
                  
                  self.$logger().$warn("" + "invalid footnote reference: " + (id));
                  $c = [nil, id], (index = $c[0]), (text = $c[1]), $c;
                };
                $c = ["xref", id, nil], (type = $c[0]), (target = $c[1]), (id = $c[2]), $c;
              }
            } else if ($truthy(text)) {
              
              text = self.$restore_passthroughs(self.$sub_inline_xrefs(self.$sub_inline_anchors(self.$normalize_string(text, true))), false);
              index = doc.$counter("footnote-number");
              doc.$register("footnotes", $$$($$($nesting, 'Document'), 'Footnote').$new(index, id, text));
              type = (target = nil);
            } else {
              return m['$[]'](0);
            };
            return $$($nesting, 'Inline').$new(self, "footnote", text, $hash2(["attributes", "id", "target", "type"], {"attributes": $hash2(["index"], {"index": index}), "id": id, "target": target, "type": type})).$convert();}, TMP_44.$$s = self, TMP_44.$$arity = 0, TMP_44))};
        return self.$sub_inline_xrefs(self.$sub_inline_anchors(text, found), found);
        } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
      }, TMP_Substitutors_sub_macros_29.$$arity = 1);
      
      Opal.def(self, '$sub_inline_anchors', TMP_Substitutors_sub_inline_anchors_46 = function $$sub_inline_anchors(text, found) {
        var $a, TMP_47, $b, $c, TMP_48, self = this;
        if (self.context == null) self.context = nil;
        if (self.parent == null) self.parent = nil;

        
        
        if (found == null) {
          found = nil;
        };
        if ($truthy((($a = self.context['$==']("list_item")) ? self.parent.$style()['$==']("bibliography") : self.context['$==']("list_item")))) {
          text = $send(text, 'sub', [$$($nesting, 'InlineBiblioAnchorRx')], (TMP_47 = function(){var self = TMP_47.$$s || this, $b, $c;

          return $$($nesting, 'Inline').$new(self, "anchor", "" + "[" + (($truthy($b = (($c = $gvars['~']) === nil ? nil : $c['$[]'](2))) ? $b : (($c = $gvars['~']) === nil ? nil : $c['$[]'](1)))) + "]", $hash2(["type", "id", "target"], {"type": "bibref", "id": (($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), "target": (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))})).$convert()}, TMP_47.$$s = self, TMP_47.$$arity = 0, TMP_47))};
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = found['$!']()) ? $c : found['$[]']("square_bracket"))) ? text['$include?']("[[") : $b)) ? $a : ($truthy($b = ($truthy($c = found['$!']()) ? $c : found['$[]']("macroish"))) ? text['$include?']("or:") : $b)))) {
          text = $send(text, 'gsub', [$$($nesting, 'InlineAnchorRx')], (TMP_48 = function(){var self = TMP_48.$$s || this, $d, $e, id = nil, reftext = nil;

          
            if ($truthy((($d = $gvars['~']) === nil ? nil : $d['$[]'](1)))) {
              return (($d = $gvars['~']) === nil ? nil : $d['$[]'](0)).$slice(1, (($d = $gvars['~']) === nil ? nil : $d['$[]'](0)).$length());};
            if ($truthy((id = (($d = $gvars['~']) === nil ? nil : $d['$[]'](2))))) {
              reftext = (($d = $gvars['~']) === nil ? nil : $d['$[]'](3))
            } else {
              
              id = (($d = $gvars['~']) === nil ? nil : $d['$[]'](4));
              if ($truthy(($truthy($d = (reftext = (($e = $gvars['~']) === nil ? nil : $e['$[]'](5)))) ? reftext['$include?']($$($nesting, 'R_SB')) : $d))) {
                reftext = reftext.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
            };
            return $$($nesting, 'Inline').$new(self, "anchor", reftext, $hash2(["type", "id", "target"], {"type": "ref", "id": id, "target": id})).$convert();}, TMP_48.$$s = self, TMP_48.$$arity = 0, TMP_48))};
        return text;
      }, TMP_Substitutors_sub_inline_anchors_46.$$arity = -2);
      
      Opal.def(self, '$sub_inline_xrefs', TMP_Substitutors_sub_inline_xrefs_49 = function $$sub_inline_xrefs(content, found) {
        var $a, $b, TMP_50, self = this;

        
        
        if (found == null) {
          found = nil;
        };
        if ($truthy(($truthy($a = ($truthy($b = (function() {if ($truthy(found)) {
          return found['$[]']("macroish")
        } else {
          
          return content['$include?']("[");
        }; return nil; })()) ? content['$include?']("xref:") : $b)) ? $a : ($truthy($b = content['$include?']("&")) ? content['$include?']("lt;&") : $b)))) {
          content = $send(content, 'gsub', [$$($nesting, 'InlineXrefMacroRx')], (TMP_50 = function(){var self = TMP_50.$$s || this, $c, $d, m = nil, attrs = nil, doc = nil, refid = nil, text = nil, macro = nil, fragment = nil, hash_idx = nil, fragment_len = nil, path = nil, ext = nil, src2src = nil, target = nil;
            if (self.document == null) self.document = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;
            if ($gvars.VERBOSE == null) $gvars.VERBOSE = nil;

          
            m = $gvars["~"];
            if ($truthy((($c = $gvars['~']) === nil ? nil : $c['$[]'](0))['$start_with?']($$($nesting, 'RS')))) {
              return m['$[]'](0).$slice(1, m['$[]'](0).$length());};
            $c = [$hash2([], {}), self.document], (attrs = $c[0]), (doc = $c[1]), $c;
            if ($truthy((refid = m['$[]'](1)))) {
              
              $d = refid.$split(",", 2), $c = Opal.to_ary($d), (refid = ($c[0] == null ? nil : $c[0])), (text = ($c[1] == null ? nil : $c[1])), $d;
              if ($truthy(text)) {
                text = text.$lstrip()};
            } else {
              
              macro = true;
              refid = m['$[]'](2);
              if ($truthy((text = m['$[]'](3)))) {
                
                if ($truthy(text['$include?']($$($nesting, 'R_SB')))) {
                  text = text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
                if ($truthy(($truthy($c = doc.$compat_mode()['$!']()) ? text['$include?']("=") : $c))) {
                  text = $$($nesting, 'AttributeList').$new(text, self).$parse_into(attrs)['$[]'](1)};};
            };
            if ($truthy(doc.$compat_mode())) {
              fragment = refid
            } else if ($truthy((hash_idx = refid.$index("#")))) {
              if ($truthy($rb_gt(hash_idx, 0))) {
                
                if ($truthy($rb_gt((fragment_len = $rb_minus($rb_minus(refid.$length(), hash_idx), 1)), 0))) {
                  $c = [refid.$slice(0, hash_idx), refid.$slice($rb_plus(hash_idx, 1), fragment_len)], (path = $c[0]), (fragment = $c[1]), $c
                } else {
                  path = refid.$slice(0, hash_idx)
                };
                if ($truthy((ext = $$$('::', 'File').$extname(path))['$empty?']())) {
                  src2src = path
                } else if ($truthy($$($nesting, 'ASCIIDOC_EXTENSIONS')['$[]'](ext))) {
                  src2src = (path = path.$slice(0, $rb_minus(path.$length(), ext.$length())))};
              } else {
                $c = [refid, refid.$slice(1, refid.$length())], (target = $c[0]), (fragment = $c[1]), $c
              }
            } else if ($truthy(($truthy($c = macro) ? refid['$end_with?'](".adoc") : $c))) {
              src2src = (path = refid.$slice(0, $rb_minus(refid.$length(), 5)))
            } else {
              fragment = refid
            };
            if ($truthy(target)) {
              
              refid = fragment;
              if ($truthy(($truthy($c = $gvars.VERBOSE) ? doc.$catalog()['$[]']("ids")['$key?'](refid)['$!']() : $c))) {
                self.$logger().$warn("" + "invalid reference: " + (refid))};
            } else if ($truthy(path)) {
              if ($truthy(($truthy($c = src2src) ? ($truthy($d = doc.$attributes()['$[]']("docname")['$=='](path)) ? $d : doc.$catalog()['$[]']("includes")['$[]'](path)) : $c))) {
                if ($truthy(fragment)) {
                  
                  $c = [fragment, nil, "" + "#" + (fragment)], (refid = $c[0]), (path = $c[1]), (target = $c[2]), $c;
                  if ($truthy(($truthy($c = $gvars.VERBOSE) ? doc.$catalog()['$[]']("ids")['$key?'](refid)['$!']() : $c))) {
                    self.$logger().$warn("" + "invalid reference: " + (refid))};
                } else {
                  $c = [nil, nil, "#"], (refid = $c[0]), (path = $c[1]), (target = $c[2]), $c
                }
              } else {
                
                $c = [path, "" + (doc.$attributes()['$[]']("relfileprefix")) + (path) + ((function() {if ($truthy(src2src)) {
                  
                  return doc.$attributes().$fetch("relfilesuffix", doc.$outfilesuffix());
                } else {
                  return ""
                }; return nil; })())], (refid = $c[0]), (path = $c[1]), $c;
                if ($truthy(fragment)) {
                  $c = ["" + (refid) + "#" + (fragment), "" + (path) + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c
                } else {
                  target = path
                };
              }
            } else if ($truthy(($truthy($c = doc.$compat_mode()) ? $c : $$($nesting, 'Compliance').$natural_xrefs()['$!']()))) {
              
              $c = [fragment, "" + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c;
              if ($truthy(($truthy($c = $gvars.VERBOSE) ? doc.$catalog()['$[]']("ids")['$key?'](refid)['$!']() : $c))) {
                self.$logger().$warn("" + "invalid reference: " + (refid))};
            } else if ($truthy(doc.$catalog()['$[]']("ids")['$key?'](fragment))) {
              $c = [fragment, "" + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c
            } else if ($truthy(($truthy($c = (refid = doc.$catalog()['$[]']("ids").$key(fragment))) ? ($truthy($d = fragment['$include?'](" ")) ? $d : fragment.$downcase()['$!='](fragment)) : $c))) {
              $c = [refid, "" + "#" + (refid)], (fragment = $c[0]), (target = $c[1]), $c
            } else {
              
              $c = [fragment, "" + "#" + (fragment)], (refid = $c[0]), (target = $c[1]), $c;
              if ($truthy($gvars.VERBOSE)) {
                self.$logger().$warn("" + "invalid reference: " + (refid))};
            };
            $c = [path, fragment, refid], attrs['$[]=']("path", $c[0]), attrs['$[]=']("fragment", $c[1]), attrs['$[]=']("refid", $c[2]), $c;
            return $$($nesting, 'Inline').$new(self, "anchor", text, $hash2(["type", "target", "attributes"], {"type": "xref", "target": target, "attributes": attrs})).$convert();}, TMP_50.$$s = self, TMP_50.$$arity = 0, TMP_50))};
        return content;
      }, TMP_Substitutors_sub_inline_xrefs_49.$$arity = -2);
      
      Opal.def(self, '$sub_callouts', TMP_Substitutors_sub_callouts_51 = function $$sub_callouts(text) {
        var TMP_52, self = this, callout_rx = nil, autonum = nil;

        
        callout_rx = (function() {if ($truthy(self['$attr?']("line-comment"))) {
          return $$($nesting, 'CalloutSourceRxMap')['$[]'](self.$attr("line-comment"))
        } else {
          return $$($nesting, 'CalloutSourceRx')
        }; return nil; })();
        autonum = 0;
        return $send(text, 'gsub', [callout_rx], (TMP_52 = function(){var self = TMP_52.$$s || this, $a;
          if (self.document == null) self.document = nil;

        if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)))) {
            return (($a = $gvars['~']) === nil ? nil : $a['$[]'](0)).$sub($$($nesting, 'RS'), "")
          } else {
            return $$($nesting, 'Inline').$new(self, "callout", (function() {if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](4))['$=='](".")) {
              return (autonum = $rb_plus(autonum, 1)).$to_s()
            } else {
              return (($a = $gvars['~']) === nil ? nil : $a['$[]'](4))
            }; return nil; })(), $hash2(["id", "attributes"], {"id": self.document.$callouts().$read_next_id(), "attributes": $hash2(["guard"], {"guard": (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))})})).$convert()
          }}, TMP_52.$$s = self, TMP_52.$$arity = 0, TMP_52));
      }, TMP_Substitutors_sub_callouts_51.$$arity = 1);
      
      Opal.def(self, '$sub_post_replacements', TMP_Substitutors_sub_post_replacements_53 = function $$sub_post_replacements(text) {
        var $a, TMP_54, TMP_55, self = this, lines = nil, last = nil;
        if (self.document == null) self.document = nil;
        if (self.attributes == null) self.attributes = nil;

        if ($truthy(($truthy($a = self.document.$attributes()['$key?']("hardbreaks")) ? $a : self.attributes['$key?']("hardbreaks-option")))) {
          
          lines = text.$split($$($nesting, 'LF'), -1);
          if ($truthy($rb_lt(lines.$size(), 2))) {
            return text};
          last = lines.$pop();
          return $send(lines, 'map', [], (TMP_54 = function(line){var self = TMP_54.$$s || this;

          
            
            if (line == null) {
              line = nil;
            };
            return $$($nesting, 'Inline').$new(self, "break", (function() {if ($truthy(line['$end_with?']($$($nesting, 'HARD_LINE_BREAK')))) {
              
              return line.$slice(0, $rb_minus(line.$length(), 2));
            } else {
              return line
            }; return nil; })(), $hash2(["type"], {"type": "line"})).$convert();}, TMP_54.$$s = self, TMP_54.$$arity = 1, TMP_54))['$<<'](last).$join($$($nesting, 'LF'));
        } else if ($truthy(($truthy($a = text['$include?']($$($nesting, 'PLUS'))) ? text['$include?']($$($nesting, 'HARD_LINE_BREAK')) : $a))) {
          return $send(text, 'gsub', [$$($nesting, 'HardLineBreakRx')], (TMP_55 = function(){var self = TMP_55.$$s || this, $b;

          return $$($nesting, 'Inline').$new(self, "break", (($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), $hash2(["type"], {"type": "line"})).$convert()}, TMP_55.$$s = self, TMP_55.$$arity = 0, TMP_55))
        } else {
          return text
        }
      }, TMP_Substitutors_sub_post_replacements_53.$$arity = 1);
      
      Opal.def(self, '$convert_quoted_text', TMP_Substitutors_convert_quoted_text_56 = function $$convert_quoted_text(match, type, scope) {
        var $a, self = this, attrs = nil, unescaped_attrs = nil, attrlist = nil, id = nil, attributes = nil;

        
        if ($truthy(match['$[]'](0)['$start_with?']($$($nesting, 'RS')))) {
          if ($truthy((($a = scope['$==']("constrained")) ? (attrs = match['$[]'](2)) : scope['$==']("constrained")))) {
            unescaped_attrs = "" + "[" + (attrs) + "]"
          } else {
            return match['$[]'](0).$slice(1, match['$[]'](0).$length())
          }};
        if (scope['$==']("constrained")) {
          if ($truthy(unescaped_attrs)) {
            return "" + (unescaped_attrs) + ($$($nesting, 'Inline').$new(self, "quoted", match['$[]'](3), $hash2(["type"], {"type": type})).$convert())
          } else {
            
            if ($truthy((attrlist = match['$[]'](2)))) {
              
              id = (attributes = self.$parse_quoted_text_attributes(attrlist)).$delete("id");
              if (type['$==']("mark")) {
                type = "unquoted"};};
            return "" + (match['$[]'](1)) + ($$($nesting, 'Inline').$new(self, "quoted", match['$[]'](3), $hash2(["type", "id", "attributes"], {"type": type, "id": id, "attributes": attributes})).$convert());
          }
        } else {
          
          if ($truthy((attrlist = match['$[]'](1)))) {
            
            id = (attributes = self.$parse_quoted_text_attributes(attrlist)).$delete("id");
            if (type['$==']("mark")) {
              type = "unquoted"};};
          return $$($nesting, 'Inline').$new(self, "quoted", match['$[]'](2), $hash2(["type", "id", "attributes"], {"type": type, "id": id, "attributes": attributes})).$convert();
        };
      }, TMP_Substitutors_convert_quoted_text_56.$$arity = 3);
      
      Opal.def(self, '$parse_quoted_text_attributes', TMP_Substitutors_parse_quoted_text_attributes_57 = function $$parse_quoted_text_attributes(str) {
        var $a, $b, self = this, segments = nil, id = nil, more_roles = nil, roles = nil, attrs = nil, $writer = nil;

        
        if ($truthy(str['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
          str = self.$sub_attributes(str)};
        if ($truthy(str['$include?'](","))) {
          str = str.$slice(0, str.$index(","))};
        if ($truthy((str = str.$strip())['$empty?']())) {
          return $hash2([], {})
        } else if ($truthy(($truthy($a = str['$start_with?'](".", "#")) ? $$($nesting, 'Compliance').$shorthand_property_syntax() : $a))) {
          
          segments = str.$split("#", 2);
          if ($truthy($rb_gt(segments.$size(), 1))) {
            $b = segments['$[]'](1).$split("."), $a = Opal.to_ary($b), (id = ($a[0] == null ? nil : $a[0])), (more_roles = $slice.call($a, 1)), $b
          } else {
            
            id = nil;
            more_roles = [];
          };
          roles = (function() {if ($truthy(segments['$[]'](0)['$empty?']())) {
            return []
          } else {
            return segments['$[]'](0).$split(".")
          }; return nil; })();
          if ($truthy($rb_gt(roles.$size(), 1))) {
            roles.$shift()};
          if ($truthy($rb_gt(more_roles.$size(), 0))) {
            roles.$concat(more_roles)};
          attrs = $hash2([], {});
          if ($truthy(id)) {
            
            $writer = ["id", id];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(roles['$empty?']())) {
          } else {
            
            $writer = ["role", roles.$join(" ")];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          return attrs;
        } else {
          return $hash2(["role"], {"role": str})
        };
      }, TMP_Substitutors_parse_quoted_text_attributes_57.$$arity = 1);
      
      Opal.def(self, '$parse_attributes', TMP_Substitutors_parse_attributes_58 = function $$parse_attributes(attrlist, posattrs, opts) {
        var $a, self = this, block = nil, into = nil;
        if (self.document == null) self.document = nil;

        
        
        if (posattrs == null) {
          posattrs = [];
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(($truthy($a = attrlist) ? attrlist['$empty?']()['$!']() : $a))) {
        } else {
          return $hash2([], {})
        };
        if ($truthy(($truthy($a = opts['$[]']("sub_input")) ? attrlist['$include?']($$($nesting, 'ATTR_REF_HEAD')) : $a))) {
          attrlist = self.document.$sub_attributes(attrlist)};
        if ($truthy(opts['$[]']("unescape_input"))) {
          attrlist = self.$unescape_bracketed_text(attrlist)};
        if ($truthy(opts['$[]']("sub_result"))) {
          block = self};
        if ($truthy((into = opts['$[]']("into")))) {
          return $$($nesting, 'AttributeList').$new(attrlist, block).$parse_into(into, posattrs)
        } else {
          return $$($nesting, 'AttributeList').$new(attrlist, block).$parse(posattrs)
        };
      }, TMP_Substitutors_parse_attributes_58.$$arity = -2);
      
      Opal.def(self, '$expand_subs', TMP_Substitutors_expand_subs_59 = function $$expand_subs(subs) {
        var $a, TMP_60, self = this, expanded_subs = nil;

        if ($truthy($$$('::', 'Symbol')['$==='](subs))) {
          if (subs['$==']("none")) {
            return nil
          } else {
            return ($truthy($a = $$($nesting, 'SUB_GROUPS')['$[]'](subs)) ? $a : [subs])
          }
        } else {
          
          expanded_subs = [];
          $send(subs, 'each', [], (TMP_60 = function(key){var self = TMP_60.$$s || this, sub_group = nil;

          
            
            if (key == null) {
              key = nil;
            };
            if (key['$==']("none")) {
              return nil
            } else if ($truthy((sub_group = $$($nesting, 'SUB_GROUPS')['$[]'](key)))) {
              return (expanded_subs = $rb_plus(expanded_subs, sub_group))
            } else {
              return expanded_subs['$<<'](key)
            };}, TMP_60.$$s = self, TMP_60.$$arity = 1, TMP_60));
          if ($truthy(expanded_subs['$empty?']())) {
            return nil
          } else {
            return expanded_subs
          };
        }
      }, TMP_Substitutors_expand_subs_59.$$arity = 1);
      
      Opal.def(self, '$unescape_bracketed_text', TMP_Substitutors_unescape_bracketed_text_61 = function $$unescape_bracketed_text(text) {
        var self = this;

        
        if ($truthy(text['$empty?']())) {
        } else if ($truthy((text = text.$strip().$tr($$($nesting, 'LF'), " "))['$include?']($$($nesting, 'R_SB')))) {
          text = text.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
        return text;
      }, TMP_Substitutors_unescape_bracketed_text_61.$$arity = 1);
      
      Opal.def(self, '$normalize_string', TMP_Substitutors_normalize_string_62 = function $$normalize_string(str, unescape_brackets) {
        var $a, self = this;

        
        
        if (unescape_brackets == null) {
          unescape_brackets = false;
        };
        if ($truthy(str['$empty?']())) {
        } else {
          
          str = str.$strip().$tr($$($nesting, 'LF'), " ");
          if ($truthy(($truthy($a = unescape_brackets) ? str['$include?']($$($nesting, 'R_SB')) : $a))) {
            str = str.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
        };
        return str;
      }, TMP_Substitutors_normalize_string_62.$$arity = -2);
      
      Opal.def(self, '$unescape_brackets', TMP_Substitutors_unescape_brackets_63 = function $$unescape_brackets(str) {
        var self = this;

        
        if ($truthy(str['$empty?']())) {
        } else if ($truthy(str['$include?']($$($nesting, 'RS')))) {
          str = str.$gsub($$($nesting, 'ESC_R_SB'), $$($nesting, 'R_SB'))};
        return str;
      }, TMP_Substitutors_unescape_brackets_63.$$arity = 1);
      
      Opal.def(self, '$split_simple_csv', TMP_Substitutors_split_simple_csv_64 = function $$split_simple_csv(str) {
        var TMP_65, TMP_66, self = this, values = nil, current = nil, quote_open = nil;

        
        if ($truthy(str['$empty?']())) {
          values = []
        } else if ($truthy(str['$include?']("\""))) {
          
          values = [];
          current = [];
          quote_open = false;
          $send(str, 'each_char', [], (TMP_65 = function(c){var self = TMP_65.$$s || this, $case = nil;

          
            
            if (c == null) {
              c = nil;
            };
            return (function() {$case = c;
            if (","['$===']($case)) {if ($truthy(quote_open)) {
              return current['$<<'](c)
            } else {
              
              values['$<<'](current.$join().$strip());
              return (current = []);
            }}
            else if ("\""['$===']($case)) {return (quote_open = quote_open['$!']())}
            else {return current['$<<'](c)}})();}, TMP_65.$$s = self, TMP_65.$$arity = 1, TMP_65));
          values['$<<'](current.$join().$strip());
        } else {
          values = $send(str.$split(","), 'map', [], (TMP_66 = function(it){var self = TMP_66.$$s || this;

          
            
            if (it == null) {
              it = nil;
            };
            return it.$strip();}, TMP_66.$$s = self, TMP_66.$$arity = 1, TMP_66))
        };
        return values;
      }, TMP_Substitutors_split_simple_csv_64.$$arity = 1);
      
      Opal.def(self, '$resolve_subs', TMP_Substitutors_resolve_subs_67 = function $$resolve_subs(subs, type, defaults, subject) {
        var TMP_68, self = this, candidates = nil, modifiers_present = nil, resolved = nil, invalid = nil;

        
        
        if (type == null) {
          type = "block";
        };
        
        if (defaults == null) {
          defaults = nil;
        };
        
        if (subject == null) {
          subject = nil;
        };
        if ($truthy(subs['$nil_or_empty?']())) {
          return nil};
        candidates = nil;
        if ($truthy(subs['$include?'](" "))) {
          subs = subs.$delete(" ")};
        modifiers_present = $$($nesting, 'SubModifierSniffRx')['$match?'](subs);
        $send(subs.$split(","), 'each', [], (TMP_68 = function(key){var self = TMP_68.$$s || this, $a, $b, modifier_operation = nil, first = nil, resolved_keys = nil, resolved_key = nil, candidate = nil, $case = nil;

        
          
          if (key == null) {
            key = nil;
          };
          modifier_operation = nil;
          if ($truthy(modifiers_present)) {
            if ((first = key.$chr())['$==']("+")) {
              
              modifier_operation = "append";
              key = key.$slice(1, key.$length());
            } else if (first['$==']("-")) {
              
              modifier_operation = "remove";
              key = key.$slice(1, key.$length());
            } else if ($truthy(key['$end_with?']("+"))) {
              
              modifier_operation = "prepend";
              key = key.$chop();}};
          key = key.$to_sym();
          if ($truthy((($a = type['$==']("inline")) ? ($truthy($b = key['$==']("verbatim")) ? $b : key['$==']("v")) : type['$==']("inline")))) {
            resolved_keys = $$($nesting, 'BASIC_SUBS')
          } else if ($truthy($$($nesting, 'SUB_GROUPS')['$key?'](key))) {
            resolved_keys = $$($nesting, 'SUB_GROUPS')['$[]'](key)
          } else if ($truthy(($truthy($a = (($b = type['$==']("inline")) ? key.$length()['$=='](1) : type['$==']("inline"))) ? $$($nesting, 'SUB_HINTS')['$key?'](key) : $a))) {
            
            resolved_key = $$($nesting, 'SUB_HINTS')['$[]'](key);
            if ($truthy((candidate = $$($nesting, 'SUB_GROUPS')['$[]'](resolved_key)))) {
              resolved_keys = candidate
            } else {
              resolved_keys = [resolved_key]
            };
          } else {
            resolved_keys = [key]
          };
          if ($truthy(modifier_operation)) {
            
            candidates = ($truthy($a = candidates) ? $a : (function() {if ($truthy(defaults)) {
              
              return defaults.$drop(0);
            } else {
              return []
            }; return nil; })());
            return (function() {$case = modifier_operation;
            if ("append"['$===']($case)) {return (candidates = $rb_plus(candidates, resolved_keys))}
            else if ("prepend"['$===']($case)) {return (candidates = $rb_plus(resolved_keys, candidates))}
            else if ("remove"['$===']($case)) {return (candidates = $rb_minus(candidates, resolved_keys))}
            else { return nil }})();
          } else {
            
            candidates = ($truthy($a = candidates) ? $a : []);
            return (candidates = $rb_plus(candidates, resolved_keys));
          };}, TMP_68.$$s = self, TMP_68.$$arity = 1, TMP_68));
        if ($truthy(candidates)) {
        } else {
          return nil
        };
        resolved = candidates['$&']($$($nesting, 'SUB_OPTIONS')['$[]'](type));
        if ($truthy($rb_minus(candidates, resolved)['$empty?']())) {
        } else {
          
          invalid = $rb_minus(candidates, resolved);
          self.$logger().$warn("" + "invalid substitution type" + ((function() {if ($truthy($rb_gt(invalid.$size(), 1))) {
            return "s"
          } else {
            return ""
          }; return nil; })()) + ((function() {if ($truthy(subject)) {
            return " for "
          } else {
            return ""
          }; return nil; })()) + (subject) + ": " + (invalid.$join(", ")));
        };
        return resolved;
      }, TMP_Substitutors_resolve_subs_67.$$arity = -2);
      
      Opal.def(self, '$resolve_block_subs', TMP_Substitutors_resolve_block_subs_69 = function $$resolve_block_subs(subs, defaults, subject) {
        var self = this;

        return self.$resolve_subs(subs, "block", defaults, subject)
      }, TMP_Substitutors_resolve_block_subs_69.$$arity = 3);
      
      Opal.def(self, '$resolve_pass_subs', TMP_Substitutors_resolve_pass_subs_70 = function $$resolve_pass_subs(subs) {
        var self = this;

        return self.$resolve_subs(subs, "inline", nil, "passthrough macro")
      }, TMP_Substitutors_resolve_pass_subs_70.$$arity = 1);
      
      Opal.def(self, '$highlight_source', TMP_Substitutors_highlight_source_71 = function $$highlight_source(source, process_callouts, highlighter) {
        var $a, $b, $c, $d, $e, $f, TMP_72, TMP_74, self = this, $case = nil, highlighter_loaded = nil, lineno = nil, callout_on_last = nil, callout_marks = nil, last = nil, callout_rx = nil, linenums_mode = nil, highlight_lines = nil, start = nil, result = nil, lexer = nil, opts = nil, $writer = nil, autonum = nil, reached_code = nil;
        if (self.document == null) self.document = nil;
        if (self.passthroughs == null) self.passthroughs = nil;

        
        
        if (highlighter == null) {
          highlighter = nil;
        };
        $case = (highlighter = ($truthy($a = highlighter) ? $a : self.document.$attributes()['$[]']("source-highlighter")));
        if ("coderay"['$===']($case)) {if ($truthy(($truthy($a = ($truthy($b = (highlighter_loaded = (($c = $$$('::', 'CodeRay', 'skip_raise')) ? 'constant' : nil))) ? $b : (($d = $Substitutors.$$cvars['@@coderay_unavailable'], $d != null) ? 'class variable' : nil))) ? $a : self.document.$attributes()['$[]']("coderay-unavailable")))) {
        } else if ($truthy($$($nesting, 'Helpers').$require_library("coderay", true, "warn")['$nil?']())) {
          (Opal.class_variable_set($Substitutors, '@@coderay_unavailable', true))
        } else {
          highlighter_loaded = true
        }}
        else if ("pygments"['$===']($case)) {if ($truthy(($truthy($a = ($truthy($b = (highlighter_loaded = (($e = $$$('::', 'Pygments', 'skip_raise')) ? 'constant' : nil))) ? $b : (($f = $Substitutors.$$cvars['@@pygments_unavailable'], $f != null) ? 'class variable' : nil))) ? $a : self.document.$attributes()['$[]']("pygments-unavailable")))) {
        } else if ($truthy($$($nesting, 'Helpers').$require_library("pygments", "pygments.rb", "warn")['$nil?']())) {
          (Opal.class_variable_set($Substitutors, '@@pygments_unavailable', true))
        } else {
          highlighter_loaded = true
        }}
        else {highlighter_loaded = false};
        if ($truthy(highlighter_loaded)) {
        } else {
          return self.$sub_source(source, process_callouts)
        };
        lineno = 0;
        callout_on_last = false;
        if ($truthy(process_callouts)) {
          
          callout_marks = $hash2([], {});
          last = -1;
          callout_rx = (function() {if ($truthy(self['$attr?']("line-comment"))) {
            return $$($nesting, 'CalloutExtractRxMap')['$[]'](self.$attr("line-comment"))
          } else {
            return $$($nesting, 'CalloutExtractRx')
          }; return nil; })();
          source = $send(source.$split($$($nesting, 'LF'), -1), 'map', [], (TMP_72 = function(line){var self = TMP_72.$$s || this, TMP_73;

          
            
            if (line == null) {
              line = nil;
            };
            lineno = $rb_plus(lineno, 1);
            return $send(line, 'gsub', [callout_rx], (TMP_73 = function(){var self = TMP_73.$$s || this, $g, $writer = nil;

            if ($truthy((($g = $gvars['~']) === nil ? nil : $g['$[]'](2)))) {
                return (($g = $gvars['~']) === nil ? nil : $g['$[]'](0)).$sub($$($nesting, 'RS'), "")
              } else {
                
                ($truthy($g = callout_marks['$[]'](lineno)) ? $g : (($writer = [lineno, []]), $send(callout_marks, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$<<']([(($g = $gvars['~']) === nil ? nil : $g['$[]'](1)), (($g = $gvars['~']) === nil ? nil : $g['$[]'](4))]);
                last = lineno;
                return nil;
              }}, TMP_73.$$s = self, TMP_73.$$arity = 0, TMP_73));}, TMP_72.$$s = self, TMP_72.$$arity = 1, TMP_72)).$join($$($nesting, 'LF'));
          callout_on_last = last['$=='](lineno);
          if ($truthy(callout_marks['$empty?']())) {
            callout_marks = nil};
        } else {
          callout_marks = nil
        };
        linenums_mode = nil;
        highlight_lines = nil;
        $case = highlighter;
        if ("coderay"['$===']($case)) {
        if ($truthy((linenums_mode = (function() {if ($truthy(self['$attr?']("linenums", nil, false))) {
          return ($truthy($a = self.document.$attributes()['$[]']("coderay-linenums-mode")) ? $a : "table").$to_sym()
        } else {
          return nil
        }; return nil; })()))) {
          
          if ($truthy($rb_lt((start = self.$attr("start", nil, 1).$to_i()), 1))) {
            start = 1};
          if ($truthy(self['$attr?']("highlight", nil, false))) {
            highlight_lines = self.$resolve_lines_to_highlight(source, self.$attr("highlight", nil, false))};};
        result = $$$($$$('::', 'CodeRay'), 'Duo')['$[]'](self.$attr("language", "text", false).$to_sym(), "html", $hash2(["css", "line_numbers", "line_number_start", "line_number_anchors", "highlight_lines", "bold_every"], {"css": ($truthy($a = self.document.$attributes()['$[]']("coderay-css")) ? $a : "class").$to_sym(), "line_numbers": linenums_mode, "line_number_start": start, "line_number_anchors": false, "highlight_lines": highlight_lines, "bold_every": false})).$highlight(source);}
        else if ("pygments"['$===']($case)) {
        lexer = ($truthy($a = $$$($$$('::', 'Pygments'), 'Lexer').$find_by_alias(self.$attr("language", "text", false))) ? $a : $$$($$$('::', 'Pygments'), 'Lexer').$find_by_mimetype("text/plain"));
        opts = $hash2(["cssclass", "classprefix", "nobackground", "stripnl"], {"cssclass": "pyhl", "classprefix": "tok-", "nobackground": true, "stripnl": false});
        if (lexer.$name()['$==']("PHP")) {
          
          $writer = ["startinline", self['$option?']("mixed")['$!']()];
          $send(opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if (($truthy($a = self.document.$attributes()['$[]']("pygments-css")) ? $a : "class")['$==']("class")) {
        } else {
          
          
          $writer = ["noclasses", true];
          $send(opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["style", ($truthy($a = self.document.$attributes()['$[]']("pygments-style")) ? $a : $$$($$($nesting, 'Stylesheets'), 'DEFAULT_PYGMENTS_STYLE'))];
          $send(opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        };
        if ($truthy(self['$attr?']("highlight", nil, false))) {
          if ($truthy((highlight_lines = self.$resolve_lines_to_highlight(source, self.$attr("highlight", nil, false)))['$empty?']())) {
          } else {
            
            $writer = ["hl_lines", highlight_lines.$join(" ")];
            $send(opts, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          }};
        if ($truthy(($truthy($a = ($truthy($b = self['$attr?']("linenums", nil, false)) ? (($writer = ["linenostart", (function() {if ($truthy($rb_lt((start = self.$attr("start", 1, false)).$to_i(), 1))) {
          return 1
        } else {
          return start
        }; return nil; })()]), $send(opts, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]) : $b)) ? (($writer = ["linenos", ($truthy($b = self.document.$attributes()['$[]']("pygments-linenums-mode")) ? $b : "table")]), $send(opts, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])['$==']("table") : $a))) {
          
          linenums_mode = "table";
          if ($truthy((result = lexer.$highlight(source, $hash2(["options"], {"options": opts}))))) {
            result = result.$sub($$($nesting, 'PygmentsWrapperDivRx'), "\\1").$gsub($$($nesting, 'PygmentsWrapperPreRx'), "\\1")
          } else {
            result = self.$sub_specialchars(source)
          };
        } else if ($truthy((result = lexer.$highlight(source, $hash2(["options"], {"options": opts}))))) {
          if ($truthy($$($nesting, 'PygmentsWrapperPreRx')['$=~'](result))) {
            result = (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))}
        } else {
          result = self.$sub_specialchars(source)
        };};
        if ($truthy(self.passthroughs['$empty?']())) {
        } else {
          result = result.$gsub($$($nesting, 'HighlightedPassSlotRx'), "" + ($$($nesting, 'PASS_START')) + "\\1" + ($$($nesting, 'PASS_END')))
        };
        if ($truthy(($truthy($a = process_callouts) ? callout_marks : $a))) {
          
          lineno = 0;
          autonum = 0;
          reached_code = linenums_mode['$!=']("table");
          return $send(result.$split($$($nesting, 'LF'), -1), 'map', [], (TMP_74 = function(line){var self = TMP_74.$$s || this, $g, $h, TMP_75, conums = nil, tail = nil, pos = nil, guard = nil, conum = nil, conums_markup = nil;
            if (self.document == null) self.document = nil;

          
            
            if (line == null) {
              line = nil;
            };
            if ($truthy(reached_code)) {
            } else {
              
              if ($truthy(line['$include?']("<td class=\"code\">"))) {
              } else {
                return line;
              };
              reached_code = true;
            };
            lineno = $rb_plus(lineno, 1);
            if ($truthy((conums = callout_marks.$delete(lineno)))) {
              
              tail = nil;
              if ($truthy(($truthy($g = ($truthy($h = callout_on_last) ? callout_marks['$empty?']() : $h)) ? linenums_mode['$==']("table") : $g))) {
                if ($truthy((($g = highlighter['$==']("coderay")) ? (pos = line.$index("</pre>")) : highlighter['$==']("coderay")))) {
                  $g = [line.$slice(0, pos), line.$slice(pos, line.$length())], (line = $g[0]), (tail = $g[1]), $g
                } else if ($truthy((($g = highlighter['$==']("pygments")) ? (pos = line['$start_with?']("</td>")) : highlighter['$==']("pygments")))) {
                  $g = ["", line], (line = $g[0]), (tail = $g[1]), $g}};
              if (conums.$size()['$=='](1)) {
                
                $h = conums['$[]'](0), $g = Opal.to_ary($h), (guard = ($g[0] == null ? nil : $g[0])), (conum = ($g[1] == null ? nil : $g[1])), $h;
                return "" + (line) + ($$($nesting, 'Inline').$new(self, "callout", (function() {if (conum['$=='](".")) {
                  return (autonum = $rb_plus(autonum, 1)).$to_s()
                } else {
                  return conum
                }; return nil; })(), $hash2(["id", "attributes"], {"id": self.document.$callouts().$read_next_id(), "attributes": $hash2(["guard"], {"guard": guard})})).$convert()) + (tail);
              } else {
                
                conums_markup = $send(conums, 'map', [], (TMP_75 = function(guard_it, conum_it){var self = TMP_75.$$s || this;
                  if (self.document == null) self.document = nil;

                
                  
                  if (guard_it == null) {
                    guard_it = nil;
                  };
                  
                  if (conum_it == null) {
                    conum_it = nil;
                  };
                  return $$($nesting, 'Inline').$new(self, "callout", (function() {if (conum_it['$=='](".")) {
                    return (autonum = $rb_plus(autonum, 1)).$to_s()
                  } else {
                    return conum_it
                  }; return nil; })(), $hash2(["id", "attributes"], {"id": self.document.$callouts().$read_next_id(), "attributes": $hash2(["guard"], {"guard": guard_it})})).$convert();}, TMP_75.$$s = self, TMP_75.$$arity = 2, TMP_75)).$join(" ");
                return "" + (line) + (conums_markup) + (tail);
              };
            } else {
              return line
            };}, TMP_74.$$s = self, TMP_74.$$arity = 1, TMP_74)).$join($$($nesting, 'LF'));
        } else {
          return result
        };
      }, TMP_Substitutors_highlight_source_71.$$arity = -3);
      
      Opal.def(self, '$resolve_lines_to_highlight', TMP_Substitutors_resolve_lines_to_highlight_76 = function $$resolve_lines_to_highlight(source, spec) {
        var TMP_77, self = this, lines = nil;

        
        lines = [];
        if ($truthy(spec['$include?'](" "))) {
          spec = spec.$delete(" ")};
        $send((function() {if ($truthy(spec['$include?'](","))) {
          
          return spec.$split(",");
        } else {
          
          return spec.$split(";");
        }; return nil; })(), 'map', [], (TMP_77 = function(entry){var self = TMP_77.$$s || this, $a, $b, negate = nil, delim = nil, from = nil, to = nil, line_nums = nil;

        
          
          if (entry == null) {
            entry = nil;
          };
          negate = false;
          if ($truthy(entry['$start_with?']("!"))) {
            
            entry = entry.$slice(1, entry.$length());
            negate = true;};
          if ($truthy((delim = (function() {if ($truthy(entry['$include?'](".."))) {
            return ".."
          } else {
            
            if ($truthy(entry['$include?']("-"))) {
              return "-"
            } else {
              return nil
            };
          }; return nil; })()))) {
            
            $b = entry.$split(delim, 2), $a = Opal.to_ary($b), (from = ($a[0] == null ? nil : $a[0])), (to = ($a[1] == null ? nil : $a[1])), $b;
            if ($truthy(($truthy($a = to['$empty?']()) ? $a : $rb_lt((to = to.$to_i()), 0)))) {
              to = $rb_plus(source.$count($$($nesting, 'LF')), 1)};
            line_nums = $$$('::', 'Range').$new(from.$to_i(), to).$to_a();
            if ($truthy(negate)) {
              return (lines = $rb_minus(lines, line_nums))
            } else {
              return lines.$concat(line_nums)
            };
          } else if ($truthy(negate)) {
            return lines.$delete(entry.$to_i())
          } else {
            return lines['$<<'](entry.$to_i())
          };}, TMP_77.$$s = self, TMP_77.$$arity = 1, TMP_77));
        return lines.$sort().$uniq();
      }, TMP_Substitutors_resolve_lines_to_highlight_76.$$arity = 2);
      
      Opal.def(self, '$sub_source', TMP_Substitutors_sub_source_78 = function $$sub_source(source, process_callouts) {
        var self = this;

        if ($truthy(process_callouts)) {
          return self.$sub_callouts(self.$sub_specialchars(source))
        } else {
          
          return self.$sub_specialchars(source);
        }
      }, TMP_Substitutors_sub_source_78.$$arity = 2);
      
      Opal.def(self, '$lock_in_subs', TMP_Substitutors_lock_in_subs_79 = function $$lock_in_subs() {
        var $a, $b, $c, $d, $e, self = this, default_subs = nil, $case = nil, custom_subs = nil, idx = nil, $writer = nil;
        if (self.default_subs == null) self.default_subs = nil;
        if (self.content_model == null) self.content_model = nil;
        if (self.context == null) self.context = nil;
        if (self.subs == null) self.subs = nil;
        if (self.attributes == null) self.attributes = nil;
        if (self.style == null) self.style = nil;
        if (self.document == null) self.document = nil;

        
        if ($truthy((default_subs = self.default_subs))) {
        } else {
          $case = self.content_model;
          if ("simple"['$===']($case)) {default_subs = $$($nesting, 'NORMAL_SUBS')}
          else if ("verbatim"['$===']($case)) {if ($truthy(($truthy($a = self.context['$==']("listing")) ? $a : (($b = self.context['$==']("literal")) ? self['$option?']("listparagraph")['$!']() : self.context['$==']("literal"))))) {
            default_subs = $$($nesting, 'VERBATIM_SUBS')
          } else if (self.context['$==']("verse")) {
            default_subs = $$($nesting, 'NORMAL_SUBS')
          } else {
            default_subs = $$($nesting, 'BASIC_SUBS')
          }}
          else if ("raw"['$===']($case)) {default_subs = (function() {if (self.context['$==']("stem")) {
            return $$($nesting, 'BASIC_SUBS')
          } else {
            return $$($nesting, 'NONE_SUBS')
          }; return nil; })()}
          else {return self.subs}
        };
        if ($truthy((custom_subs = self.attributes['$[]']("subs")))) {
          self.subs = ($truthy($a = self.$resolve_block_subs(custom_subs, default_subs, self.context)) ? $a : [])
        } else {
          self.subs = default_subs.$drop(0)
        };
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = ($truthy($d = (($e = self.context['$==']("listing")) ? self.style['$==']("source") : self.context['$==']("listing"))) ? self.attributes['$key?']("language") : $d)) ? self.document['$basebackend?']("html") : $c)) ? $$($nesting, 'SUB_HIGHLIGHT')['$include?'](self.document.$attributes()['$[]']("source-highlighter")) : $b)) ? (idx = self.subs.$index("specialcharacters")) : $a))) {
          
          $writer = [idx, "highlight"];
          $send(self.subs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        return self.subs;
      }, TMP_Substitutors_lock_in_subs_79.$$arity = 0);
    })($nesting[0], $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/abstract_node"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$include', '$attr_reader', '$attr_accessor', '$==', '$document', '$to_s', '$key?', '$dup', '$[]', '$raise', '$converter', '$attributes', '$nil?', '$[]=', '$-', '$delete', '$+', '$update', '$nil_or_empty?', '$split', '$include?', '$empty?', '$join', '$apply_reftext_subs', '$attr?', '$extname', '$attr', '$image_uri', '$<', '$safe', '$uriish?', '$uri_encode_spaces', '$normalize_web_path', '$generate_data_uri_from_uri', '$generate_data_uri', '$slice', '$length', '$normalize_system_path', '$readable?', '$strict_encode64', '$binread', '$warn', '$logger', '$require_library', '$!', '$open', '$content_type', '$read', '$base_dir', '$root?', '$path_resolver', '$system_path', '$web_path', '$===', '$!=', '$normalize_lines_array', '$to_a', '$each_line', '$open_uri', '$fetch', '$read_asset', '$gsub']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $AbstractNode(){};
      var self = $AbstractNode = $klass($base, $super, 'AbstractNode', $AbstractNode);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_AbstractNode_initialize_1, TMP_AbstractNode_block$q_2, TMP_AbstractNode_inline$q_3, TMP_AbstractNode_converter_4, TMP_AbstractNode_parent$eq_5, TMP_AbstractNode_attr_6, TMP_AbstractNode_attr$q_7, TMP_AbstractNode_set_attr_8, TMP_AbstractNode_remove_attr_9, TMP_AbstractNode_option$q_10, TMP_AbstractNode_set_option_11, TMP_AbstractNode_update_attributes_12, TMP_AbstractNode_role_13, TMP_AbstractNode_roles_14, TMP_AbstractNode_role$q_15, TMP_AbstractNode_has_role$q_16, TMP_AbstractNode_add_role_17, TMP_AbstractNode_remove_role_18, TMP_AbstractNode_reftext_19, TMP_AbstractNode_reftext$q_20, TMP_AbstractNode_icon_uri_21, TMP_AbstractNode_image_uri_22, TMP_AbstractNode_media_uri_23, TMP_AbstractNode_generate_data_uri_24, TMP_AbstractNode_generate_data_uri_from_uri_25, TMP_AbstractNode_normalize_asset_path_27, TMP_AbstractNode_normalize_system_path_28, TMP_AbstractNode_normalize_web_path_29, TMP_AbstractNode_read_asset_30, TMP_AbstractNode_read_contents_32, TMP_AbstractNode_uri_encode_spaces_35, TMP_AbstractNode_is_uri$q_36;

      def.document = def.attributes = def.parent = nil;
      
      self.$include($$($nesting, 'Logging'));
      self.$include($$($nesting, 'Substitutors'));
      self.$attr_reader("attributes");
      self.$attr_reader("context");
      self.$attr_reader("document");
      self.$attr_accessor("id");
      self.$attr_reader("node_name");
      self.$attr_reader("parent");
      
      Opal.def(self, '$initialize', TMP_AbstractNode_initialize_1 = function $$initialize(parent, context, opts) {
        var $a, self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if (context['$==']("document")) {
          $a = [self, nil], (self.document = $a[0]), (self.parent = $a[1]), $a
        } else if ($truthy(parent)) {
          $a = [parent.$document(), parent], (self.document = $a[0]), (self.parent = $a[1]), $a
        } else {
          self.document = (self.parent = nil)
        };
        self.node_name = (self.context = context).$to_s();
        self.attributes = (function() {if ($truthy(opts['$key?']("attributes"))) {
          return opts['$[]']("attributes").$dup()
        } else {
          return $hash2([], {})
        }; return nil; })();
        return (self.passthroughs = $hash2([], {}));
      }, TMP_AbstractNode_initialize_1.$$arity = -3);
      
      Opal.def(self, '$block?', TMP_AbstractNode_block$q_2 = function() {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'))
      }, TMP_AbstractNode_block$q_2.$$arity = 0);
      
      Opal.def(self, '$inline?', TMP_AbstractNode_inline$q_3 = function() {
        var self = this;

        return self.$raise($$$('::', 'NotImplementedError'))
      }, TMP_AbstractNode_inline$q_3.$$arity = 0);
      
      Opal.def(self, '$converter', TMP_AbstractNode_converter_4 = function $$converter() {
        var self = this;

        return self.document.$converter()
      }, TMP_AbstractNode_converter_4.$$arity = 0);
      
      Opal.def(self, '$parent=', TMP_AbstractNode_parent$eq_5 = function(parent) {
        var $a, self = this;

        return $a = [parent, parent.$document()], (self.parent = $a[0]), (self.document = $a[1]), $a
      }, TMP_AbstractNode_parent$eq_5.$$arity = 1);
      
      Opal.def(self, '$attr', TMP_AbstractNode_attr_6 = function $$attr(name, default_val, inherit) {
        var $a, $b, self = this;

        
        
        if (default_val == null) {
          default_val = nil;
        };
        
        if (inherit == null) {
          inherit = true;
        };
        name = name.$to_s();
        return ($truthy($a = self.attributes['$[]'](name)) ? $a : (function() {if ($truthy(($truthy($b = inherit) ? self.parent : $b))) {
          return ($truthy($b = self.document.$attributes()['$[]'](name)) ? $b : default_val)
        } else {
          return default_val
        }; return nil; })());
      }, TMP_AbstractNode_attr_6.$$arity = -2);
      
      Opal.def(self, '$attr?', TMP_AbstractNode_attr$q_7 = function(name, expect_val, inherit) {
        var $a, $b, $c, self = this;

        
        
        if (expect_val == null) {
          expect_val = nil;
        };
        
        if (inherit == null) {
          inherit = true;
        };
        name = name.$to_s();
        if ($truthy(expect_val['$nil?']())) {
          return ($truthy($a = self.attributes['$key?'](name)) ? $a : ($truthy($b = ($truthy($c = inherit) ? self.parent : $c)) ? self.document.$attributes()['$key?'](name) : $b))
        } else {
          return expect_val['$=='](($truthy($a = self.attributes['$[]'](name)) ? $a : (function() {if ($truthy(($truthy($b = inherit) ? self.parent : $b))) {
            return self.document.$attributes()['$[]'](name)
          } else {
            return nil
          }; return nil; })()))
        };
      }, TMP_AbstractNode_attr$q_7.$$arity = -2);
      
      Opal.def(self, '$set_attr', TMP_AbstractNode_set_attr_8 = function $$set_attr(name, value, overwrite) {
        var $a, self = this, $writer = nil;

        
        
        if (value == null) {
          value = "";
        };
        
        if (overwrite == null) {
          overwrite = true;
        };
        if ($truthy((($a = overwrite['$=='](false)) ? self.attributes['$key?'](name) : overwrite['$=='](false)))) {
          return false
        } else {
          
          
          $writer = [name, value];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return true;
        };
      }, TMP_AbstractNode_set_attr_8.$$arity = -2);
      
      Opal.def(self, '$remove_attr', TMP_AbstractNode_remove_attr_9 = function $$remove_attr(name) {
        var self = this;

        return self.attributes.$delete(name)
      }, TMP_AbstractNode_remove_attr_9.$$arity = 1);
      
      Opal.def(self, '$option?', TMP_AbstractNode_option$q_10 = function(name) {
        var self = this;

        return self.attributes['$key?']("" + (name) + "-option")
      }, TMP_AbstractNode_option$q_10.$$arity = 1);
      
      Opal.def(self, '$set_option', TMP_AbstractNode_set_option_11 = function $$set_option(name) {
        var self = this, attrs = nil, key = nil, $writer = nil;

        if ($truthy((attrs = self.attributes)['$[]']("options"))) {
          if ($truthy(attrs['$[]']((key = "" + (name) + "-option")))) {
            return nil
          } else {
            
            
            $writer = ["options", $rb_plus(attrs['$[]']("options"), "" + "," + (name))];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = [key, ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          }
        } else {
          
          
          $writer = ["options", name];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["" + (name) + "-option", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];;
        }
      }, TMP_AbstractNode_set_option_11.$$arity = 1);
      
      Opal.def(self, '$update_attributes', TMP_AbstractNode_update_attributes_12 = function $$update_attributes(attributes) {
        var self = this;

        
        self.attributes.$update(attributes);
        return nil;
      }, TMP_AbstractNode_update_attributes_12.$$arity = 1);
      
      Opal.def(self, '$role', TMP_AbstractNode_role_13 = function $$role() {
        var $a, self = this;

        return ($truthy($a = self.attributes['$[]']("role")) ? $a : self.document.$attributes()['$[]']("role"))
      }, TMP_AbstractNode_role_13.$$arity = 0);
      
      Opal.def(self, '$roles', TMP_AbstractNode_roles_14 = function $$roles() {
        var $a, self = this, val = nil;

        if ($truthy((val = ($truthy($a = self.attributes['$[]']("role")) ? $a : self.document.$attributes()['$[]']("role")))['$nil_or_empty?']())) {
          return []
        } else {
          return val.$split()
        }
      }, TMP_AbstractNode_roles_14.$$arity = 0);
      
      Opal.def(self, '$role?', TMP_AbstractNode_role$q_15 = function(expect_val) {
        var $a, self = this;

        
        
        if (expect_val == null) {
          expect_val = nil;
        };
        if ($truthy(expect_val)) {
          return expect_val['$=='](($truthy($a = self.attributes['$[]']("role")) ? $a : self.document.$attributes()['$[]']("role")))
        } else {
          return ($truthy($a = self.attributes['$key?']("role")) ? $a : self.document.$attributes()['$key?']("role"))
        };
      }, TMP_AbstractNode_role$q_15.$$arity = -1);
      
      Opal.def(self, '$has_role?', TMP_AbstractNode_has_role$q_16 = function(name) {
        var $a, self = this, val = nil;

        if ($truthy((val = ($truthy($a = self.attributes['$[]']("role")) ? $a : self.document.$attributes()['$[]']("role"))))) {
          return ((("" + " ") + (val)) + " ")['$include?']("" + " " + (name) + " ")
        } else {
          return false
        }
      }, TMP_AbstractNode_has_role$q_16.$$arity = 1);
      
      Opal.def(self, '$add_role', TMP_AbstractNode_add_role_17 = function $$add_role(name) {
        var self = this, val = nil, $writer = nil;

        if ($truthy((val = self.attributes['$[]']("role"))['$nil_or_empty?']())) {
          
          
          $writer = ["role", name];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return true;
        } else if ($truthy(((("" + " ") + (val)) + " ")['$include?']("" + " " + (name) + " "))) {
          return false
        } else {
          
          
          $writer = ["role", "" + (val) + " " + (name)];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return true;
        }
      }, TMP_AbstractNode_add_role_17.$$arity = 1);
      
      Opal.def(self, '$remove_role', TMP_AbstractNode_remove_role_18 = function $$remove_role(name) {
        var self = this, val = nil, $writer = nil;

        if ($truthy((val = self.attributes['$[]']("role"))['$nil_or_empty?']())) {
          return false
        } else if ($truthy((val = val.$split()).$delete(name))) {
          
          if ($truthy(val['$empty?']())) {
            self.attributes.$delete("role")
          } else {
            
            $writer = ["role", val.$join(" ")];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          return true;
        } else {
          return false
        }
      }, TMP_AbstractNode_remove_role_18.$$arity = 1);
      
      Opal.def(self, '$reftext', TMP_AbstractNode_reftext_19 = function $$reftext() {
        var self = this, val = nil;

        if ($truthy((val = self.attributes['$[]']("reftext")))) {
          
          return self.$apply_reftext_subs(val);
        } else {
          return nil
        }
      }, TMP_AbstractNode_reftext_19.$$arity = 0);
      
      Opal.def(self, '$reftext?', TMP_AbstractNode_reftext$q_20 = function() {
        var self = this;

        return self.attributes['$key?']("reftext")
      }, TMP_AbstractNode_reftext$q_20.$$arity = 0);
      
      Opal.def(self, '$icon_uri', TMP_AbstractNode_icon_uri_21 = function $$icon_uri(name) {
        var self = this, icon = nil;

        
        if ($truthy(self['$attr?']("icon"))) {
          if ($truthy($$$('::', 'File').$extname((icon = self.$attr("icon")))['$empty?']())) {
            icon = "" + (icon) + "." + (self.document.$attr("icontype", "png"))}
        } else {
          icon = "" + (name) + "." + (self.document.$attr("icontype", "png"))
        };
        return self.$image_uri(icon, "iconsdir");
      }, TMP_AbstractNode_icon_uri_21.$$arity = 1);
      
      Opal.def(self, '$image_uri', TMP_AbstractNode_image_uri_22 = function $$image_uri(target_image, asset_dir_key) {
        var $a, $b, $c, $d, self = this, doc = nil, images_base = nil;

        
        
        if (asset_dir_key == null) {
          asset_dir_key = "imagesdir";
        };
        if ($truthy(($truthy($a = $rb_lt((doc = self.document).$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE'))) ? doc['$attr?']("data-uri") : $a))) {
          if ($truthy(($truthy($a = ($truthy($b = $$($nesting, 'Helpers')['$uriish?'](target_image)) ? (target_image = self.$uri_encode_spaces(target_image)) : $b)) ? $a : ($truthy($b = ($truthy($c = ($truthy($d = asset_dir_key) ? (images_base = doc.$attr(asset_dir_key)) : $d)) ? $$($nesting, 'Helpers')['$uriish?'](images_base) : $c)) ? (target_image = self.$normalize_web_path(target_image, images_base, false)) : $b)))) {
            if ($truthy(doc['$attr?']("allow-uri-read"))) {
              return self.$generate_data_uri_from_uri(target_image, doc['$attr?']("cache-uri"))
            } else {
              return target_image
            }
          } else {
            return self.$generate_data_uri(target_image, asset_dir_key)
          }
        } else {
          return self.$normalize_web_path(target_image, (function() {if ($truthy(asset_dir_key)) {
            
            return doc.$attr(asset_dir_key);
          } else {
            return nil
          }; return nil; })())
        };
      }, TMP_AbstractNode_image_uri_22.$$arity = -2);
      
      Opal.def(self, '$media_uri', TMP_AbstractNode_media_uri_23 = function $$media_uri(target, asset_dir_key) {
        var self = this;

        
        
        if (asset_dir_key == null) {
          asset_dir_key = "imagesdir";
        };
        return self.$normalize_web_path(target, (function() {if ($truthy(asset_dir_key)) {
          return self.document.$attr(asset_dir_key)
        } else {
          return nil
        }; return nil; })());
      }, TMP_AbstractNode_media_uri_23.$$arity = -2);
      
      Opal.def(self, '$generate_data_uri', TMP_AbstractNode_generate_data_uri_24 = function $$generate_data_uri(target_image, asset_dir_key) {
        var self = this, ext = nil, mimetype = nil, image_path = nil;

        
        
        if (asset_dir_key == null) {
          asset_dir_key = nil;
        };
        ext = $$$('::', 'File').$extname(target_image);
        mimetype = (function() {if (ext['$=='](".svg")) {
          return "image/svg+xml"
        } else {
          return "" + "image/" + (ext.$slice(1, ext.$length()))
        }; return nil; })();
        if ($truthy(asset_dir_key)) {
          image_path = self.$normalize_system_path(target_image, self.document.$attr(asset_dir_key), nil, $hash2(["target_name"], {"target_name": "image"}))
        } else {
          image_path = self.$normalize_system_path(target_image)
        };
        if ($truthy($$$('::', 'File')['$readable?'](image_path))) {
          return "" + "data:" + (mimetype) + ";base64," + ($$$('::', 'Base64').$strict_encode64($$$('::', 'IO').$binread(image_path)))
        } else {
          
          self.$logger().$warn("" + "image to embed not found or not readable: " + (image_path));
          return "" + "data:" + (mimetype) + ";base64,";
        };
      }, TMP_AbstractNode_generate_data_uri_24.$$arity = -2);
      
      Opal.def(self, '$generate_data_uri_from_uri', TMP_AbstractNode_generate_data_uri_from_uri_25 = function $$generate_data_uri_from_uri(image_uri, cache_uri) {
        var TMP_26, self = this, mimetype = nil, bindata = nil;

        
        
        if (cache_uri == null) {
          cache_uri = false;
        };
        if ($truthy(cache_uri)) {
          $$($nesting, 'Helpers').$require_library("open-uri/cached", "open-uri-cached")
        } else if ($truthy($$$('::', 'RUBY_ENGINE_OPAL')['$!']())) {
          $$$('::', 'OpenURI')};
        
        try {
          
          mimetype = nil;
          bindata = $send(self, 'open', [image_uri, "rb"], (TMP_26 = function(f){var self = TMP_26.$$s || this;

          
            
            if (f == null) {
              f = nil;
            };
            mimetype = f.$content_type();
            return f.$read();}, TMP_26.$$s = self, TMP_26.$$arity = 1, TMP_26));
          return "" + "data:" + (mimetype) + ";base64," + ($$$('::', 'Base64').$strict_encode64(bindata));
        } catch ($err) {
          if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
            try {
              
              self.$logger().$warn("" + "could not retrieve image data from URI: " + (image_uri));
              return image_uri;
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };;
      }, TMP_AbstractNode_generate_data_uri_from_uri_25.$$arity = -2);
      
      Opal.def(self, '$normalize_asset_path', TMP_AbstractNode_normalize_asset_path_27 = function $$normalize_asset_path(asset_ref, asset_name, autocorrect) {
        var self = this;

        
        
        if (asset_name == null) {
          asset_name = "path";
        };
        
        if (autocorrect == null) {
          autocorrect = true;
        };
        return self.$normalize_system_path(asset_ref, self.document.$base_dir(), nil, $hash2(["target_name", "recover"], {"target_name": asset_name, "recover": autocorrect}));
      }, TMP_AbstractNode_normalize_asset_path_27.$$arity = -2);
      
      Opal.def(self, '$normalize_system_path', TMP_AbstractNode_normalize_system_path_28 = function $$normalize_system_path(target, start, jail, opts) {
        var self = this, doc = nil;

        
        
        if (start == null) {
          start = nil;
        };
        
        if (jail == null) {
          jail = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy($rb_lt((doc = self.document).$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
          if ($truthy(start)) {
            if ($truthy(doc.$path_resolver()['$root?'](start))) {
            } else {
              start = $$$('::', 'File').$join(doc.$base_dir(), start)
            }
          } else {
            start = doc.$base_dir()
          }
        } else {
          
          if ($truthy(start)) {
          } else {
            start = doc.$base_dir()
          };
          if ($truthy(jail)) {
          } else {
            jail = doc.$base_dir()
          };
        };
        return doc.$path_resolver().$system_path(target, start, jail, opts);
      }, TMP_AbstractNode_normalize_system_path_28.$$arity = -2);
      
      Opal.def(self, '$normalize_web_path', TMP_AbstractNode_normalize_web_path_29 = function $$normalize_web_path(target, start, preserve_uri_target) {
        var $a, self = this;

        
        
        if (start == null) {
          start = nil;
        };
        
        if (preserve_uri_target == null) {
          preserve_uri_target = true;
        };
        if ($truthy(($truthy($a = preserve_uri_target) ? $$($nesting, 'Helpers')['$uriish?'](target) : $a))) {
          return self.$uri_encode_spaces(target)
        } else {
          return self.document.$path_resolver().$web_path(target, start)
        };
      }, TMP_AbstractNode_normalize_web_path_29.$$arity = -2);
      
      Opal.def(self, '$read_asset', TMP_AbstractNode_read_asset_30 = function $$read_asset(path, opts) {
        var TMP_31, $a, self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy($$$('::', 'Hash')['$==='](opts))) {
        } else {
          opts = $hash2(["warn_on_failure"], {"warn_on_failure": opts['$!='](false)})
        };
        if ($truthy($$$('::', 'File')['$readable?'](path))) {
          if ($truthy(opts['$[]']("normalize"))) {
            return $$($nesting, 'Helpers').$normalize_lines_array($send($$$('::', 'File'), 'open', [path, "rb"], (TMP_31 = function(f){var self = TMP_31.$$s || this;

            
              
              if (f == null) {
                f = nil;
              };
              return f.$each_line().$to_a();}, TMP_31.$$s = self, TMP_31.$$arity = 1, TMP_31))).$join($$($nesting, 'LF'))
          } else {
            return $$$('::', 'IO').$read(path)
          }
        } else if ($truthy(opts['$[]']("warn_on_failure"))) {
          
          self.$logger().$warn("" + (($truthy($a = self.$attr("docfile")) ? $a : "<stdin>")) + ": " + (($truthy($a = opts['$[]']("label")) ? $a : "file")) + " does not exist or cannot be read: " + (path));
          return nil;
        } else {
          return nil
        };
      }, TMP_AbstractNode_read_asset_30.$$arity = -2);
      
      Opal.def(self, '$read_contents', TMP_AbstractNode_read_contents_32 = function $$read_contents(target, opts) {
        var $a, $b, $c, TMP_33, TMP_34, self = this, doc = nil, start = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        doc = self.document;
        if ($truthy(($truthy($a = $$($nesting, 'Helpers')['$uriish?'](target)) ? $a : ($truthy($b = ($truthy($c = (start = opts['$[]']("start"))) ? $$($nesting, 'Helpers')['$uriish?'](start) : $c)) ? (target = doc.$path_resolver().$web_path(target, start)) : $b)))) {
          if ($truthy(doc['$attr?']("allow-uri-read"))) {
            
            if ($truthy(doc['$attr?']("cache-uri"))) {
              $$($nesting, 'Helpers').$require_library("open-uri/cached", "open-uri-cached")};
            
            try {
              if ($truthy(opts['$[]']("normalize"))) {
                return $$($nesting, 'Helpers').$normalize_lines_array($send($$$('::', 'OpenURI'), 'open_uri', [target], (TMP_33 = function(f){var self = TMP_33.$$s || this;

                
                  
                  if (f == null) {
                    f = nil;
                  };
                  return f.$each_line().$to_a();}, TMP_33.$$s = self, TMP_33.$$arity = 1, TMP_33))).$join($$($nesting, 'LF'))
              } else {
                return $send($$$('::', 'OpenURI'), 'open_uri', [target], (TMP_34 = function(f){var self = TMP_34.$$s || this;

                
                  
                  if (f == null) {
                    f = nil;
                  };
                  return f.$read();}, TMP_34.$$s = self, TMP_34.$$arity = 1, TMP_34))
              }
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  
                  if ($truthy(opts.$fetch("warn_on_failure", true))) {
                    self.$logger().$warn("" + "could not retrieve contents of " + (($truthy($a = opts['$[]']("label")) ? $a : "asset")) + " at URI: " + (target))};
                  return nil;
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };;
          } else {
            
            if ($truthy(opts.$fetch("warn_on_failure", true))) {
              self.$logger().$warn("" + "cannot retrieve contents of " + (($truthy($a = opts['$[]']("label")) ? $a : "asset")) + " at URI: " + (target) + " (allow-uri-read attribute not enabled)")};
            return nil;
          }
        } else {
          
          target = self.$normalize_system_path(target, opts['$[]']("start"), nil, $hash2(["target_name"], {"target_name": ($truthy($a = opts['$[]']("label")) ? $a : "asset")}));
          return self.$read_asset(target, $hash2(["normalize", "warn_on_failure", "label"], {"normalize": opts['$[]']("normalize"), "warn_on_failure": opts.$fetch("warn_on_failure", true), "label": opts['$[]']("label")}));
        };
      }, TMP_AbstractNode_read_contents_32.$$arity = -2);
      
      Opal.def(self, '$uri_encode_spaces', TMP_AbstractNode_uri_encode_spaces_35 = function $$uri_encode_spaces(str) {
        var self = this;

        if ($truthy(str['$include?'](" "))) {
          
          return str.$gsub(" ", "%20");
        } else {
          return str
        }
      }, TMP_AbstractNode_uri_encode_spaces_35.$$arity = 1);
      return (Opal.def(self, '$is_uri?', TMP_AbstractNode_is_uri$q_36 = function(str) {
        var self = this;

        return $$($nesting, 'Helpers')['$uriish?'](str)
      }, TMP_AbstractNode_is_uri$q_36.$$arity = 1), nil) && 'is_uri?';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/abstract_block"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$attr_reader', '$attr_writer', '$attr_accessor', '$==', '$!=', '$level', '$file', '$lineno', '$playback_attributes', '$convert', '$converter', '$join', '$map', '$to_s', '$parent', '$parent=', '$-', '$<<', '$!', '$empty?', '$>', '$find_by_internal', '$to_proc', '$[]', '$has_role?', '$replace', '$raise', '$===', '$header?', '$each', '$flatten', '$context', '$blocks', '$+', '$find_index', '$next_adjacent_block', '$select', '$sub_specialchars', '$match?', '$sub_replacements', '$title', '$apply_title_subs', '$include?', '$delete', '$reftext', '$sprintf', '$sub_quotes', '$compat_mode', '$attributes', '$chomp', '$increment_and_store_counter', '$index=', '$numbered', '$sectname', '$counter', '$numeral=', '$numeral', '$caption=', '$assign_numeral', '$reindex_sections']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $AbstractBlock(){};
      var self = $AbstractBlock = $klass($base, $super, 'AbstractBlock', $AbstractBlock);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_AbstractBlock_initialize_1, TMP_AbstractBlock_block$q_2, TMP_AbstractBlock_inline$q_3, TMP_AbstractBlock_file_4, TMP_AbstractBlock_lineno_5, TMP_AbstractBlock_convert_6, TMP_AbstractBlock_content_7, TMP_AbstractBlock_context$eq_9, TMP_AbstractBlock_$lt$lt_10, TMP_AbstractBlock_blocks$q_11, TMP_AbstractBlock_sections$q_12, TMP_AbstractBlock_find_by_13, TMP_AbstractBlock_find_by_internal_14, TMP_AbstractBlock_next_adjacent_block_17, TMP_AbstractBlock_sections_18, TMP_AbstractBlock_alt_20, TMP_AbstractBlock_caption_21, TMP_AbstractBlock_captioned_title_22, TMP_AbstractBlock_list_marker_keyword_23, TMP_AbstractBlock_title_24, TMP_AbstractBlock_title$q_25, TMP_AbstractBlock_title$eq_26, TMP_AbstractBlock_sub$q_27, TMP_AbstractBlock_remove_sub_28, TMP_AbstractBlock_xreftext_29, TMP_AbstractBlock_assign_caption_30, TMP_AbstractBlock_assign_numeral_31, TMP_AbstractBlock_reindex_sections_32;

      def.source_location = def.document = def.attributes = def.blocks = def.next_section_index = def.context = def.style = def.id = def.header = def.caption = def.title_converted = def.converted_title = def.title = def.subs = def.numeral = def.next_section_ordinal = nil;
      
      self.$attr_reader("blocks");
      self.$attr_writer("caption");
      self.$attr_accessor("content_model");
      self.$attr_accessor("level");
      self.$attr_accessor("numeral");
      Opal.alias(self, "number", "numeral");
      Opal.alias(self, "number=", "numeral=");
      self.$attr_accessor("source_location");
      self.$attr_accessor("style");
      self.$attr_reader("subs");
      
      Opal.def(self, '$initialize', TMP_AbstractBlock_initialize_1 = function $$initialize(parent, context, opts) {
        var $a, $iter = TMP_AbstractBlock_initialize_1.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_AbstractBlock_initialize_1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_AbstractBlock_initialize_1, false), $zuper, $iter);
        self.content_model = "compound";
        self.blocks = [];
        self.subs = [];
        self.id = (self.title = (self.title_converted = (self.caption = (self.numeral = (self.style = (self.default_subs = (self.source_location = nil)))))));
        if (context['$==']("document")) {
          self.level = 0
        } else if ($truthy(($truthy($a = parent) ? context['$!=']("section") : $a))) {
          self.level = parent.$level()
        } else {
          self.level = nil
        };
        self.next_section_index = 0;
        return (self.next_section_ordinal = 1);
      }, TMP_AbstractBlock_initialize_1.$$arity = -3);
      
      Opal.def(self, '$block?', TMP_AbstractBlock_block$q_2 = function() {
        var self = this;

        return true
      }, TMP_AbstractBlock_block$q_2.$$arity = 0);
      
      Opal.def(self, '$inline?', TMP_AbstractBlock_inline$q_3 = function() {
        var self = this;

        return false
      }, TMP_AbstractBlock_inline$q_3.$$arity = 0);
      
      Opal.def(self, '$file', TMP_AbstractBlock_file_4 = function $$file() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$file() : $a)
      }, TMP_AbstractBlock_file_4.$$arity = 0);
      
      Opal.def(self, '$lineno', TMP_AbstractBlock_lineno_5 = function $$lineno() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$lineno() : $a)
      }, TMP_AbstractBlock_lineno_5.$$arity = 0);
      
      Opal.def(self, '$convert', TMP_AbstractBlock_convert_6 = function $$convert() {
        var self = this;

        
        self.document.$playback_attributes(self.attributes);
        return self.$converter().$convert(self);
      }, TMP_AbstractBlock_convert_6.$$arity = 0);
      Opal.alias(self, "render", "convert");
      
      Opal.def(self, '$content', TMP_AbstractBlock_content_7 = function $$content() {
        var TMP_8, self = this;

        return $send(self.blocks, 'map', [], (TMP_8 = function(b){var self = TMP_8.$$s || this;

        
          
          if (b == null) {
            b = nil;
          };
          return b.$convert();}, TMP_8.$$s = self, TMP_8.$$arity = 1, TMP_8)).$join($$($nesting, 'LF'))
      }, TMP_AbstractBlock_content_7.$$arity = 0);
      
      Opal.def(self, '$context=', TMP_AbstractBlock_context$eq_9 = function(context) {
        var self = this;

        return (self.node_name = (self.context = context).$to_s())
      }, TMP_AbstractBlock_context$eq_9.$$arity = 1);
      
      Opal.def(self, '$<<', TMP_AbstractBlock_$lt$lt_10 = function(block) {
        var self = this, $writer = nil;

        
        if (block.$parent()['$=='](self)) {
        } else {
          
          $writer = [self];
          $send(block, 'parent=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        self.blocks['$<<'](block);
        return self;
      }, TMP_AbstractBlock_$lt$lt_10.$$arity = 1);
      Opal.alias(self, "append", "<<");
      
      Opal.def(self, '$blocks?', TMP_AbstractBlock_blocks$q_11 = function() {
        var self = this;

        return self.blocks['$empty?']()['$!']()
      }, TMP_AbstractBlock_blocks$q_11.$$arity = 0);
      
      Opal.def(self, '$sections?', TMP_AbstractBlock_sections$q_12 = function() {
        var self = this;

        return $rb_gt(self.next_section_index, 0)
      }, TMP_AbstractBlock_sections$q_12.$$arity = 0);
      
      Opal.def(self, '$find_by', TMP_AbstractBlock_find_by_13 = function $$find_by(selector) {
        var $iter = TMP_AbstractBlock_find_by_13.$$p, block = $iter || nil, self = this, result = nil;

        if ($iter) TMP_AbstractBlock_find_by_13.$$p = null;
        
        
        if ($iter) TMP_AbstractBlock_find_by_13.$$p = null;;
        
        if (selector == null) {
          selector = $hash2([], {});
        };
        try {
          return $send(self, 'find_by_internal', [selector, (result = [])], block.$to_proc())
        } catch ($err) {
          if (Opal.rescue($err, [$$$('::', 'StopIteration')])) {
            try {
              return result
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };
      }, TMP_AbstractBlock_find_by_13.$$arity = -1);
      Opal.alias(self, "query", "find_by");
      
      Opal.def(self, '$find_by_internal', TMP_AbstractBlock_find_by_internal_14 = function $$find_by_internal(selector, result) {
        var $iter = TMP_AbstractBlock_find_by_internal_14.$$p, block = $iter || nil, $a, $b, $c, $d, TMP_15, TMP_16, self = this, any_context = nil, context_selector = nil, style_selector = nil, role_selector = nil, id_selector = nil, verdict = nil, $case = nil;

        if ($iter) TMP_AbstractBlock_find_by_internal_14.$$p = null;
        
        
        if ($iter) TMP_AbstractBlock_find_by_internal_14.$$p = null;;
        
        if (selector == null) {
          selector = $hash2([], {});
        };
        
        if (result == null) {
          result = [];
        };
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = ($truthy($d = (any_context = (context_selector = selector['$[]']("context"))['$!']())) ? $d : context_selector['$=='](self.context))) ? ($truthy($d = (style_selector = selector['$[]']("style"))['$!']()) ? $d : style_selector['$=='](self.style)) : $c)) ? ($truthy($c = (role_selector = selector['$[]']("role"))['$!']()) ? $c : self['$has_role?'](role_selector)) : $b)) ? ($truthy($b = (id_selector = selector['$[]']("id"))['$!']()) ? $b : id_selector['$=='](self.id)) : $a))) {
          if ($truthy(id_selector)) {
            
            result.$replace((function() {if ((block !== nil)) {
              
              if ($truthy(Opal.yield1(block, self))) {
                return [self]
              } else {
                return []
              };
            } else {
              return [self]
            }; return nil; })());
            self.$raise($$$('::', 'StopIteration'));
          } else if ((block !== nil)) {
            if ($truthy((verdict = Opal.yield1(block, self)))) {
              $case = verdict;
              if ("skip_children"['$===']($case)) {
              result['$<<'](self);
              return result;}
              else if ("skip"['$===']($case)) {return result}
              else {result['$<<'](self)}}
          } else {
            result['$<<'](self)
          }};
        if ($truthy(($truthy($a = (($b = self.context['$==']("document")) ? ($truthy($c = any_context) ? $c : context_selector['$==']("section")) : self.context['$==']("document"))) ? self['$header?']() : $a))) {
          $send(self.header, 'find_by_internal', [selector, result], block.$to_proc())};
        if (context_selector['$==']("document")) {
        } else if (self.context['$==']("dlist")) {
          if ($truthy(($truthy($a = any_context) ? $a : context_selector['$!=']("section")))) {
            $send(self.blocks.$flatten(), 'each', [], (TMP_15 = function(li){var self = TMP_15.$$s || this;

            
              
              if (li == null) {
                li = nil;
              };
              if ($truthy(li)) {
                return $send(li, 'find_by_internal', [selector, result], block.$to_proc())
              } else {
                return nil
              };}, TMP_15.$$s = self, TMP_15.$$arity = 1, TMP_15))}
        } else if ($truthy($send(self.blocks, 'each', [], (TMP_16 = function(b){var self = TMP_16.$$s || this, $e;

        
          
          if (b == null) {
            b = nil;
          };
          if ($truthy((($e = context_selector['$==']("section")) ? b.$context()['$!=']("section") : context_selector['$==']("section")))) {
            return nil;};
          return $send(b, 'find_by_internal', [selector, result], block.$to_proc());}, TMP_16.$$s = self, TMP_16.$$arity = 1, TMP_16)))) {};
        return result;
      }, TMP_AbstractBlock_find_by_internal_14.$$arity = -1);
      
      Opal.def(self, '$next_adjacent_block', TMP_AbstractBlock_next_adjacent_block_17 = function $$next_adjacent_block() {
        var self = this, sib = nil, p = nil;

        if (self.context['$==']("document")) {
          return nil
        } else if ($truthy((sib = (p = self.$parent()).$blocks()['$[]']($rb_plus(p.$blocks().$find_index(self), 1))))) {
          return sib
        } else {
          return p.$next_adjacent_block()
        }
      }, TMP_AbstractBlock_next_adjacent_block_17.$$arity = 0);
      
      Opal.def(self, '$sections', TMP_AbstractBlock_sections_18 = function $$sections() {
        var TMP_19, self = this;

        return $send(self.blocks, 'select', [], (TMP_19 = function(block){var self = TMP_19.$$s || this;

        
          
          if (block == null) {
            block = nil;
          };
          return block.$context()['$==']("section");}, TMP_19.$$s = self, TMP_19.$$arity = 1, TMP_19))
      }, TMP_AbstractBlock_sections_18.$$arity = 0);
      
      Opal.def(self, '$alt', TMP_AbstractBlock_alt_20 = function $$alt() {
        var self = this, text = nil;

        if ($truthy((text = self.attributes['$[]']("alt")))) {
          if (text['$=='](self.attributes['$[]']("default-alt"))) {
            return self.$sub_specialchars(text)
          } else {
            
            text = self.$sub_specialchars(text);
            if ($truthy($$($nesting, 'ReplaceableTextRx')['$match?'](text))) {
              
              return self.$sub_replacements(text);
            } else {
              return text
            };
          }
        } else {
          return nil
        }
      }, TMP_AbstractBlock_alt_20.$$arity = 0);
      
      Opal.def(self, '$caption', TMP_AbstractBlock_caption_21 = function $$caption() {
        var self = this;

        if (self.context['$==']("admonition")) {
          return self.attributes['$[]']("textlabel")
        } else {
          return self.caption
        }
      }, TMP_AbstractBlock_caption_21.$$arity = 0);
      
      Opal.def(self, '$captioned_title', TMP_AbstractBlock_captioned_title_22 = function $$captioned_title() {
        var self = this;

        return "" + (self.caption) + (self.$title())
      }, TMP_AbstractBlock_captioned_title_22.$$arity = 0);
      
      Opal.def(self, '$list_marker_keyword', TMP_AbstractBlock_list_marker_keyword_23 = function $$list_marker_keyword(list_type) {
        var $a, self = this;

        
        
        if (list_type == null) {
          list_type = nil;
        };
        return $$($nesting, 'ORDERED_LIST_KEYWORDS')['$[]'](($truthy($a = list_type) ? $a : self.style));
      }, TMP_AbstractBlock_list_marker_keyword_23.$$arity = -1);
      
      Opal.def(self, '$title', TMP_AbstractBlock_title_24 = function $$title() {
        var $a, $b, self = this;

        if ($truthy(self.title_converted)) {
          return self.converted_title
        } else {
          
          return (self.converted_title = ($truthy($a = ($truthy($b = (self.title_converted = true)) ? self.title : $b)) ? self.$apply_title_subs(self.title) : $a));
        }
      }, TMP_AbstractBlock_title_24.$$arity = 0);
      
      Opal.def(self, '$title?', TMP_AbstractBlock_title$q_25 = function() {
        var self = this;

        if ($truthy(self.title)) {
          return true
        } else {
          return false
        }
      }, TMP_AbstractBlock_title$q_25.$$arity = 0);
      
      Opal.def(self, '$title=', TMP_AbstractBlock_title$eq_26 = function(val) {
        var $a, self = this;

        return $a = [val, nil], (self.title = $a[0]), (self.title_converted = $a[1]), $a
      }, TMP_AbstractBlock_title$eq_26.$$arity = 1);
      
      Opal.def(self, '$sub?', TMP_AbstractBlock_sub$q_27 = function(name) {
        var self = this;

        return self.subs['$include?'](name)
      }, TMP_AbstractBlock_sub$q_27.$$arity = 1);
      
      Opal.def(self, '$remove_sub', TMP_AbstractBlock_remove_sub_28 = function $$remove_sub(sub) {
        var self = this;

        
        self.subs.$delete(sub);
        return nil;
      }, TMP_AbstractBlock_remove_sub_28.$$arity = 1);
      
      Opal.def(self, '$xreftext', TMP_AbstractBlock_xreftext_29 = function $$xreftext(xrefstyle) {
        var $a, $b, self = this, val = nil, $case = nil, quoted_title = nil, prefix = nil;

        
        
        if (xrefstyle == null) {
          xrefstyle = nil;
        };
        if ($truthy(($truthy($a = (val = self.$reftext())) ? val['$empty?']()['$!']() : $a))) {
          return val
        } else if ($truthy(($truthy($a = ($truthy($b = xrefstyle) ? self.title : $b)) ? self.caption : $a))) {
          return (function() {$case = xrefstyle;
          if ("full"['$===']($case)) {
          quoted_title = self.$sprintf(self.$sub_quotes((function() {if ($truthy(self.document.$compat_mode())) {
            return "``%s''"
          } else {
            return "\"`%s`\""
          }; return nil; })()), self.$title());
          if ($truthy(($truthy($a = self.numeral) ? (prefix = self.document.$attributes()['$[]']((function() {if (self.context['$==']("image")) {
            return "figure-caption"
          } else {
            return "" + (self.context) + "-caption"
          }; return nil; })())) : $a))) {
            return "" + (prefix) + " " + (self.numeral) + ", " + (quoted_title)
          } else {
            return "" + (self.caption.$chomp(". ")) + ", " + (quoted_title)
          };}
          else if ("short"['$===']($case)) {if ($truthy(($truthy($a = self.numeral) ? (prefix = self.document.$attributes()['$[]']((function() {if (self.context['$==']("image")) {
            return "figure-caption"
          } else {
            return "" + (self.context) + "-caption"
          }; return nil; })())) : $a))) {
            return "" + (prefix) + " " + (self.numeral)
          } else {
            return self.caption.$chomp(". ")
          }}
          else {return self.$title()}})()
        } else {
          return self.$title()
        };
      }, TMP_AbstractBlock_xreftext_29.$$arity = -1);
      
      Opal.def(self, '$assign_caption', TMP_AbstractBlock_assign_caption_30 = function $$assign_caption(value, key) {
        var $a, $b, self = this, prefix = nil;

        
        
        if (value == null) {
          value = nil;
        };
        
        if (key == null) {
          key = nil;
        };
        if ($truthy(($truthy($a = ($truthy($b = self.caption) ? $b : self.title['$!']())) ? $a : (self.caption = ($truthy($b = value) ? $b : self.document.$attributes()['$[]']("caption")))))) {
          return nil
        } else if ($truthy((prefix = self.document.$attributes()['$[]']("" + ((key = ($truthy($a = key) ? $a : self.context))) + "-caption")))) {
          
          self.caption = "" + (prefix) + " " + ((self.numeral = self.document.$increment_and_store_counter("" + (key) + "-number", self))) + ". ";
          return nil;
        } else {
          return nil
        };
      }, TMP_AbstractBlock_assign_caption_30.$$arity = -1);
      
      Opal.def(self, '$assign_numeral', TMP_AbstractBlock_assign_numeral_31 = function $$assign_numeral(section) {
        var $a, self = this, $writer = nil, like = nil, sectname = nil, caption = nil;

        
        self.next_section_index = $rb_plus((($writer = [self.next_section_index]), $send(section, 'index=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]), 1);
        if ($truthy((like = section.$numbered()))) {
          if ((sectname = section.$sectname())['$==']("appendix")) {
            
            
            $writer = [self.document.$counter("appendix-number", "A")];
            $send(section, 'numeral=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy((caption = self.document.$attributes()['$[]']("appendix-caption")))) {
              
              $writer = ["" + (caption) + " " + (section.$numeral()) + ": "];
              $send(section, 'caption=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              
              $writer = ["" + (section.$numeral()) + ". "];
              $send(section, 'caption=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          } else if ($truthy(($truthy($a = sectname['$==']("chapter")) ? $a : like['$==']("chapter")))) {
            
            $writer = [self.document.$counter("chapter-number", 1)];
            $send(section, 'numeral=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            
            
            $writer = [self.next_section_ordinal];
            $send(section, 'numeral=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            self.next_section_ordinal = $rb_plus(self.next_section_ordinal, 1);
          }};
        return nil;
      }, TMP_AbstractBlock_assign_numeral_31.$$arity = 1);
      return (Opal.def(self, '$reindex_sections', TMP_AbstractBlock_reindex_sections_32 = function $$reindex_sections() {
        var TMP_33, self = this;

        
        self.next_section_index = 0;
        self.next_section_ordinal = 1;
        return $send(self.blocks, 'each', [], (TMP_33 = function(block){var self = TMP_33.$$s || this;

        
          
          if (block == null) {
            block = nil;
          };
          if (block.$context()['$==']("section")) {
            
            self.$assign_numeral(block);
            return block.$reindex_sections();
          } else {
            return nil
          };}, TMP_33.$$s = self, TMP_33.$$arity = 1, TMP_33));
      }, TMP_AbstractBlock_reindex_sections_32.$$arity = 0), nil) && 'reindex_sections';
    })($nesting[0], $$($nesting, 'AbstractNode'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/attribute_list"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash = Opal.hash, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$new', '$[]', '$update', '$parse', '$parse_attribute', '$eos?', '$skip_delimiter', '$+', '$rekey', '$each_with_index', '$[]=', '$-', '$skip_blank', '$==', '$peek', '$parse_attribute_value', '$get_byte', '$start_with?', '$scan_name', '$!', '$!=', '$*', '$scan_to_delimiter', '$===', '$include?', '$delete', '$each', '$split', '$empty?', '$strip', '$apply_subs', '$scan_to_quote', '$gsub', '$skip', '$scan']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $AttributeList(){};
      var self = $AttributeList = $klass($base, $super, 'AttributeList', $AttributeList);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_AttributeList_initialize_1, TMP_AttributeList_parse_into_2, TMP_AttributeList_parse_3, TMP_AttributeList_rekey_4, TMP_AttributeList_rekey_5, TMP_AttributeList_parse_attribute_7, TMP_AttributeList_parse_attribute_value_9, TMP_AttributeList_skip_blank_10, TMP_AttributeList_skip_delimiter_11, TMP_AttributeList_scan_name_12, TMP_AttributeList_scan_to_delimiter_13, TMP_AttributeList_scan_to_quote_14;

      def.attributes = def.scanner = def.delimiter = def.block = def.delimiter_skip_pattern = def.delimiter_boundary_pattern = nil;
      
      Opal.const_set($nesting[0], 'BACKSLASH', "\\");
      Opal.const_set($nesting[0], 'APOS', "'");
      Opal.const_set($nesting[0], 'BoundaryRxs', $hash("\"", /.*?[^\\](?=")/, $$($nesting, 'APOS'), /.*?[^\\](?=')/, ",", /.*?(?=[ \t]*(,|$))/));
      Opal.const_set($nesting[0], 'EscapedQuotes', $hash("\"", "\\\"", $$($nesting, 'APOS'), "\\'"));
      Opal.const_set($nesting[0], 'NameRx', new RegExp("" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-.]*"));
      Opal.const_set($nesting[0], 'BlankRx', /[ \t]+/);
      Opal.const_set($nesting[0], 'SkipRxs', $hash2(["blank", ","], {"blank": $$($nesting, 'BlankRx'), ",": /[ \t]*(,|$)/}));
      
      Opal.def(self, '$initialize', TMP_AttributeList_initialize_1 = function $$initialize(source, block, delimiter) {
        var self = this;

        
        
        if (block == null) {
          block = nil;
        };
        
        if (delimiter == null) {
          delimiter = ",";
        };
        self.scanner = $$$('::', 'StringScanner').$new(source);
        self.block = block;
        self.delimiter = delimiter;
        self.delimiter_skip_pattern = $$($nesting, 'SkipRxs')['$[]'](delimiter);
        self.delimiter_boundary_pattern = $$($nesting, 'BoundaryRxs')['$[]'](delimiter);
        return (self.attributes = nil);
      }, TMP_AttributeList_initialize_1.$$arity = -2);
      
      Opal.def(self, '$parse_into', TMP_AttributeList_parse_into_2 = function $$parse_into(attributes, posattrs) {
        var self = this;

        
        
        if (posattrs == null) {
          posattrs = [];
        };
        return attributes.$update(self.$parse(posattrs));
      }, TMP_AttributeList_parse_into_2.$$arity = -2);
      
      Opal.def(self, '$parse', TMP_AttributeList_parse_3 = function $$parse(posattrs) {
        var $a, self = this, index = nil;

        
        
        if (posattrs == null) {
          posattrs = [];
        };
        if ($truthy(self.attributes)) {
          return self.attributes};
        self.attributes = $hash2([], {});
        index = 0;
        while ($truthy(self.$parse_attribute(index, posattrs))) {
          
          if ($truthy(self.scanner['$eos?']())) {
            break;};
          self.$skip_delimiter();
          index = $rb_plus(index, 1);
        };
        return self.attributes;
      }, TMP_AttributeList_parse_3.$$arity = -1);
      
      Opal.def(self, '$rekey', TMP_AttributeList_rekey_4 = function $$rekey(posattrs) {
        var self = this;

        return $$($nesting, 'AttributeList').$rekey(self.attributes, posattrs)
      }, TMP_AttributeList_rekey_4.$$arity = 1);
      Opal.defs(self, '$rekey', TMP_AttributeList_rekey_5 = function $$rekey(attributes, pos_attrs) {
        var TMP_6, self = this;

        
        $send(pos_attrs, 'each_with_index', [], (TMP_6 = function(key, index){var self = TMP_6.$$s || this, pos = nil, val = nil, $writer = nil;

        
          
          if (key == null) {
            key = nil;
          };
          
          if (index == null) {
            index = nil;
          };
          if ($truthy(key)) {
          } else {
            return nil;
          };
          pos = $rb_plus(index, 1);
          if ($truthy((val = attributes['$[]'](pos)))) {
            
            $writer = [key, val];
            $send(attributes, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            return nil
          };}, TMP_6.$$s = self, TMP_6.$$arity = 2, TMP_6));
        return attributes;
      }, TMP_AttributeList_rekey_5.$$arity = 2);
      
      Opal.def(self, '$parse_attribute', TMP_AttributeList_parse_attribute_7 = function $$parse_attribute(index, pos_attrs) {
        var $a, TMP_8, self = this, single_quoted_value = nil, first = nil, name = nil, value = nil, skipped = nil, c = nil, $case = nil, $writer = nil, resolved_name = nil, pos_name = nil;

        
        
        if (index == null) {
          index = 0;
        };
        
        if (pos_attrs == null) {
          pos_attrs = [];
        };
        single_quoted_value = false;
        self.$skip_blank();
        if ((first = self.scanner.$peek(1))['$==']("\"")) {
          
          name = self.$parse_attribute_value(self.scanner.$get_byte());
          value = nil;
        } else if (first['$==']($$($nesting, 'APOS'))) {
          
          name = self.$parse_attribute_value(self.scanner.$get_byte());
          value = nil;
          if ($truthy(name['$start_with?']($$($nesting, 'APOS')))) {
          } else {
            single_quoted_value = true
          };
        } else {
          
          name = self.$scan_name();
          skipped = 0;
          c = nil;
          if ($truthy(self.scanner['$eos?']())) {
            if ($truthy(name)) {
            } else {
              return false
            }
          } else {
            
            skipped = ($truthy($a = self.$skip_blank()) ? $a : 0);
            c = self.scanner.$get_byte();
          };
          if ($truthy(($truthy($a = c['$!']()) ? $a : c['$=='](self.delimiter)))) {
            value = nil
          } else if ($truthy(($truthy($a = c['$!=']("=")) ? $a : name['$!']()))) {
            
            name = "" + (name) + ($rb_times(" ", skipped)) + (c) + (self.$scan_to_delimiter());
            value = nil;
          } else {
            
            self.$skip_blank();
            if ($truthy(self.scanner.$peek(1))) {
              if ((c = self.scanner.$get_byte())['$==']("\"")) {
                value = self.$parse_attribute_value(c)
              } else if (c['$==']($$($nesting, 'APOS'))) {
                
                value = self.$parse_attribute_value(c);
                if ($truthy(value['$start_with?']($$($nesting, 'APOS')))) {
                } else {
                  single_quoted_value = true
                };
              } else if (c['$=='](self.delimiter)) {
                value = ""
              } else {
                
                value = "" + (c) + (self.$scan_to_delimiter());
                if (value['$==']("None")) {
                  return true};
              }};
          };
        };
        if ($truthy(value)) {
          $case = name;
          if ("options"['$===']($case) || "opts"['$===']($case)) {
          if ($truthy(value['$include?'](","))) {
            
            if ($truthy(value['$include?'](" "))) {
              value = value.$delete(" ")};
            $send(value.$split(","), 'each', [], (TMP_8 = function(opt){var self = TMP_8.$$s || this, $writer = nil;
              if (self.attributes == null) self.attributes = nil;

            
              
              if (opt == null) {
                opt = nil;
              };
              if ($truthy(opt['$empty?']())) {
                return nil
              } else {
                
                $writer = ["" + (opt) + "-option", ""];
                $send(self.attributes, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];
              };}, TMP_8.$$s = self, TMP_8.$$arity = 1, TMP_8));
          } else {
            
            $writer = ["" + ((value = value.$strip())) + "-option", ""];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          
          $writer = ["options", value];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;}
          else {if ($truthy(($truthy($a = single_quoted_value) ? self.block : $a))) {
            $case = name;
            if ("title"['$===']($case) || "reftext"['$===']($case)) {
            $writer = [name, value];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
            else {
            $writer = [name, self.block.$apply_subs(value)];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}
          } else {
            
            $writer = [name, value];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          }}
        } else {
          
          resolved_name = (function() {if ($truthy(($truthy($a = single_quoted_value) ? self.block : $a))) {
            
            return self.block.$apply_subs(name);
          } else {
            return name
          }; return nil; })();
          if ($truthy((pos_name = pos_attrs['$[]'](index)))) {
            
            $writer = [pos_name, resolved_name];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          
          $writer = [$rb_plus(index, 1), resolved_name];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        };
        return true;
      }, TMP_AttributeList_parse_attribute_7.$$arity = -1);
      
      Opal.def(self, '$parse_attribute_value', TMP_AttributeList_parse_attribute_value_9 = function $$parse_attribute_value(quote) {
        var self = this, value = nil;

        
        if (self.scanner.$peek(1)['$=='](quote)) {
          
          self.scanner.$get_byte();
          return "";};
        if ($truthy((value = self.$scan_to_quote(quote)))) {
          
          self.scanner.$get_byte();
          if ($truthy(value['$include?']($$($nesting, 'BACKSLASH')))) {
            return value.$gsub($$($nesting, 'EscapedQuotes')['$[]'](quote), quote)
          } else {
            return value
          };
        } else {
          return "" + (quote) + (self.$scan_to_delimiter())
        };
      }, TMP_AttributeList_parse_attribute_value_9.$$arity = 1);
      
      Opal.def(self, '$skip_blank', TMP_AttributeList_skip_blank_10 = function $$skip_blank() {
        var self = this;

        return self.scanner.$skip($$($nesting, 'BlankRx'))
      }, TMP_AttributeList_skip_blank_10.$$arity = 0);
      
      Opal.def(self, '$skip_delimiter', TMP_AttributeList_skip_delimiter_11 = function $$skip_delimiter() {
        var self = this;

        return self.scanner.$skip(self.delimiter_skip_pattern)
      }, TMP_AttributeList_skip_delimiter_11.$$arity = 0);
      
      Opal.def(self, '$scan_name', TMP_AttributeList_scan_name_12 = function $$scan_name() {
        var self = this;

        return self.scanner.$scan($$($nesting, 'NameRx'))
      }, TMP_AttributeList_scan_name_12.$$arity = 0);
      
      Opal.def(self, '$scan_to_delimiter', TMP_AttributeList_scan_to_delimiter_13 = function $$scan_to_delimiter() {
        var self = this;

        return self.scanner.$scan(self.delimiter_boundary_pattern)
      }, TMP_AttributeList_scan_to_delimiter_13.$$arity = 0);
      return (Opal.def(self, '$scan_to_quote', TMP_AttributeList_scan_to_quote_14 = function $$scan_to_quote(quote) {
        var self = this;

        return self.scanner.$scan($$($nesting, 'BoundaryRxs')['$[]'](quote))
      }, TMP_AttributeList_scan_to_quote_14.$$arity = 1), nil) && 'scan_to_quote';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/block"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $hash2 = Opal.hash2, $truthy = Opal.truthy;

  Opal.add_stubs(['$default=', '$-', '$attr_accessor', '$[]', '$key?', '$==', '$===', '$drop', '$delete', '$[]=', '$lock_in_subs', '$nil_or_empty?', '$normalize_lines_from_string', '$apply_subs', '$join', '$<', '$size', '$empty?', '$rstrip', '$shift', '$pop', '$warn', '$logger', '$to_s', '$class', '$object_id', '$inspect']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Block(){};
      var self = $Block = $klass($base, $super, 'Block', $Block);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Block_initialize_1, TMP_Block_content_2, TMP_Block_source_3, TMP_Block_to_s_4, $writer = nil;

      def.attributes = def.content_model = def.lines = def.subs = def.blocks = def.context = def.style = nil;
      
      
      $writer = ["simple"];
      $send(Opal.const_set($nesting[0], 'DEFAULT_CONTENT_MODEL', $hash2(["audio", "image", "listing", "literal", "stem", "open", "page_break", "pass", "thematic_break", "video"], {"audio": "empty", "image": "empty", "listing": "verbatim", "literal": "verbatim", "stem": "raw", "open": "compound", "page_break": "empty", "pass": "raw", "thematic_break": "empty", "video": "empty"})), 'default=', Opal.to_a($writer));
      $writer[$rb_minus($writer["length"], 1)];;
      Opal.alias(self, "blockname", "context");
      self.$attr_accessor("lines");
      
      Opal.def(self, '$initialize', TMP_Block_initialize_1 = function $$initialize(parent, context, opts) {
        var $a, $iter = TMP_Block_initialize_1.$$p, $yield = $iter || nil, self = this, subs = nil, $writer = nil, raw_source = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Block_initialize_1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Block_initialize_1, false), $zuper, $iter);
        self.content_model = ($truthy($a = opts['$[]']("content_model")) ? $a : $$($nesting, 'DEFAULT_CONTENT_MODEL')['$[]'](context));
        if ($truthy(opts['$key?']("subs"))) {
          if ($truthy((subs = opts['$[]']("subs")))) {
            
            if (subs['$==']("default")) {
              self.default_subs = opts['$[]']("default_subs")
            } else if ($truthy($$$('::', 'Array')['$==='](subs))) {
              
              self.default_subs = subs.$drop(0);
              self.attributes.$delete("subs");
            } else {
              
              self.default_subs = nil;
              
              $writer = ["subs", "" + (subs)];
              $send(self.attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
            };
            self.$lock_in_subs();
          } else {
            
            self.default_subs = [];
            self.attributes.$delete("subs");
          }
        } else {
          self.default_subs = nil
        };
        if ($truthy((raw_source = opts['$[]']("source"))['$nil_or_empty?']())) {
          return (self.lines = [])
        } else if ($truthy($$$('::', 'String')['$==='](raw_source))) {
          return (self.lines = $$($nesting, 'Helpers').$normalize_lines_from_string(raw_source))
        } else {
          return (self.lines = raw_source.$drop(0))
        };
      }, TMP_Block_initialize_1.$$arity = -3);
      
      Opal.def(self, '$content', TMP_Block_content_2 = function $$content() {
        var $a, $b, $iter = TMP_Block_content_2.$$p, $yield = $iter || nil, self = this, $case = nil, result = nil, first = nil, last = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Block_content_2.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        return (function() {$case = self.content_model;
        if ("compound"['$===']($case)) {return $send(self, Opal.find_super_dispatcher(self, 'content', TMP_Block_content_2, false), $zuper, $iter)}
        else if ("simple"['$===']($case)) {return self.$apply_subs(self.lines.$join($$($nesting, 'LF')), self.subs)}
        else if ("verbatim"['$===']($case) || "raw"['$===']($case)) {
        result = self.$apply_subs(self.lines, self.subs);
        if ($truthy($rb_lt(result.$size(), 2))) {
          return result['$[]'](0)
        } else {
          
          while ($truthy(($truthy($b = (first = result['$[]'](0))) ? first.$rstrip()['$empty?']() : $b))) {
            result.$shift()
          };
          while ($truthy(($truthy($b = (last = result['$[]'](-1))) ? last.$rstrip()['$empty?']() : $b))) {
            result.$pop()
          };
          return result.$join($$($nesting, 'LF'));
        };}
        else {
        if (self.content_model['$==']("empty")) {
        } else {
          self.$logger().$warn("" + "Unknown content model '" + (self.content_model) + "' for block: " + (self.$to_s()))
        };
        return nil;}})()
      }, TMP_Block_content_2.$$arity = 0);
      
      Opal.def(self, '$source', TMP_Block_source_3 = function $$source() {
        var self = this;

        return self.lines.$join($$($nesting, 'LF'))
      }, TMP_Block_source_3.$$arity = 0);
      return (Opal.def(self, '$to_s', TMP_Block_to_s_4 = function $$to_s() {
        var self = this, content_summary = nil;

        
        content_summary = (function() {if (self.content_model['$==']("compound")) {
          return "" + "blocks: " + (self.blocks.$size())
        } else {
          return "" + "lines: " + (self.lines.$size())
        }; return nil; })();
        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {context: " + (self.context.$inspect()) + ", content_model: " + (self.content_model.$inspect()) + ", style: " + (self.style.$inspect()) + ", " + (content_summary) + "}>";
      }, TMP_Block_to_s_4.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/callouts"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send;

  Opal.add_stubs(['$next_list', '$<<', '$current_list', '$to_i', '$generate_next_callout_id', '$+', '$<=', '$size', '$[]', '$-', '$chop', '$join', '$map', '$==', '$<', '$generate_callout_id']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Callouts(){};
      var self = $Callouts = $klass($base, $super, 'Callouts', $Callouts);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Callouts_initialize_1, TMP_Callouts_register_2, TMP_Callouts_read_next_id_3, TMP_Callouts_callout_ids_4, TMP_Callouts_current_list_6, TMP_Callouts_next_list_7, TMP_Callouts_rewind_8, TMP_Callouts_generate_next_callout_id_9, TMP_Callouts_generate_callout_id_10;

      def.co_index = def.lists = def.list_index = nil;
      
      
      Opal.def(self, '$initialize', TMP_Callouts_initialize_1 = function $$initialize() {
        var self = this;

        
        self.lists = [];
        self.list_index = 0;
        return self.$next_list();
      }, TMP_Callouts_initialize_1.$$arity = 0);
      
      Opal.def(self, '$register', TMP_Callouts_register_2 = function $$register(li_ordinal) {
        var self = this, id = nil;

        
        self.$current_list()['$<<']($hash2(["ordinal", "id"], {"ordinal": li_ordinal.$to_i(), "id": (id = self.$generate_next_callout_id())}));
        self.co_index = $rb_plus(self.co_index, 1);
        return id;
      }, TMP_Callouts_register_2.$$arity = 1);
      
      Opal.def(self, '$read_next_id', TMP_Callouts_read_next_id_3 = function $$read_next_id() {
        var self = this, id = nil, list = nil;

        
        id = nil;
        list = self.$current_list();
        if ($truthy($rb_le(self.co_index, list.$size()))) {
          id = list['$[]']($rb_minus(self.co_index, 1))['$[]']("id")};
        self.co_index = $rb_plus(self.co_index, 1);
        return id;
      }, TMP_Callouts_read_next_id_3.$$arity = 0);
      
      Opal.def(self, '$callout_ids', TMP_Callouts_callout_ids_4 = function $$callout_ids(li_ordinal) {
        var TMP_5, self = this;

        return $send(self.$current_list(), 'map', [], (TMP_5 = function(it){var self = TMP_5.$$s || this;

        
          
          if (it == null) {
            it = nil;
          };
          if (it['$[]']("ordinal")['$=='](li_ordinal)) {
            return "" + (it['$[]']("id")) + " "
          } else {
            return ""
          };}, TMP_5.$$s = self, TMP_5.$$arity = 1, TMP_5)).$join().$chop()
      }, TMP_Callouts_callout_ids_4.$$arity = 1);
      
      Opal.def(self, '$current_list', TMP_Callouts_current_list_6 = function $$current_list() {
        var self = this;

        return self.lists['$[]']($rb_minus(self.list_index, 1))
      }, TMP_Callouts_current_list_6.$$arity = 0);
      
      Opal.def(self, '$next_list', TMP_Callouts_next_list_7 = function $$next_list() {
        var self = this;

        
        self.list_index = $rb_plus(self.list_index, 1);
        if ($truthy($rb_lt(self.lists.$size(), self.list_index))) {
          self.lists['$<<']([])};
        self.co_index = 1;
        return nil;
      }, TMP_Callouts_next_list_7.$$arity = 0);
      
      Opal.def(self, '$rewind', TMP_Callouts_rewind_8 = function $$rewind() {
        var self = this;

        
        self.list_index = 1;
        self.co_index = 1;
        return nil;
      }, TMP_Callouts_rewind_8.$$arity = 0);
      
      Opal.def(self, '$generate_next_callout_id', TMP_Callouts_generate_next_callout_id_9 = function $$generate_next_callout_id() {
        var self = this;

        return self.$generate_callout_id(self.list_index, self.co_index)
      }, TMP_Callouts_generate_next_callout_id_9.$$arity = 0);
      return (Opal.def(self, '$generate_callout_id', TMP_Callouts_generate_callout_id_10 = function $$generate_callout_id(list_index, co_index) {
        var self = this;

        return "" + "CO" + (list_index) + "-" + (co_index)
      }, TMP_Callouts_generate_callout_id_10.$$arity = 2), nil) && 'generate_callout_id';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter/base"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy;

  Opal.add_stubs(['$include', '$node_name', '$empty?', '$send', '$content']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    
    (function($base, $parent_nesting) {
      function $Converter() {};
      var self = $Converter = $module($base, 'Converter', $Converter);

      var def = self.prototype, $nesting = [self].concat($parent_nesting);

      nil
    })($nesting[0], $nesting);
    (function($base, $super, $parent_nesting) {
      function $Base(){};
      var self = $Base = $klass($base, $super, 'Base', $Base);

      var def = self.prototype, $nesting = [self].concat($parent_nesting);

      
      self.$include($$($nesting, 'Logging'));
      return self.$include($$($nesting, 'Converter'));
    })($$($nesting, 'Converter'), null, $nesting);
    (function($base, $super, $parent_nesting) {
      function $BuiltIn(){};
      var self = $BuiltIn = $klass($base, $super, 'BuiltIn', $BuiltIn);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_BuiltIn_initialize_1, TMP_BuiltIn_convert_2, TMP_BuiltIn_content_3, TMP_BuiltIn_skip_4;

      
      self.$include($$($nesting, 'Logging'));
      
      Opal.def(self, '$initialize', TMP_BuiltIn_initialize_1 = function $$initialize(backend, opts) {
        var self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        return nil;
      }, TMP_BuiltIn_initialize_1.$$arity = -2);
      
      Opal.def(self, '$convert', TMP_BuiltIn_convert_2 = function $$convert(node, transform, opts) {
        var $a, self = this;

        
        
        if (transform == null) {
          transform = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        transform = ($truthy($a = transform) ? $a : node.$node_name());
        if ($truthy(opts['$empty?']())) {
          
          return self.$send(transform, node);
        } else {
          
          return self.$send(transform, node, opts);
        };
      }, TMP_BuiltIn_convert_2.$$arity = -2);
      Opal.alias(self, "handles?", "respond_to?");
      
      Opal.def(self, '$content', TMP_BuiltIn_content_3 = function $$content(node) {
        var self = this;

        return node.$content()
      }, TMP_BuiltIn_content_3.$$arity = 1);
      Opal.alias(self, "pass", "content");
      return (Opal.def(self, '$skip', TMP_BuiltIn_skip_4 = function $$skip(node) {
        var self = this;

        return nil
      }, TMP_BuiltIn_skip_4.$$arity = 1), nil) && 'skip';
    })($$($nesting, 'Converter'), null, $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter/factory"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy, $hash2 = Opal.hash2, $send = Opal.send;

  Opal.add_stubs(['$new', '$require', '$include?', '$include', '$warn', '$logger', '$register', '$default', '$resolve', '$create', '$converters', '$unregister_all', '$attr_reader', '$each', '$[]=', '$-', '$==', '$[]', '$clear', '$===', '$supports_templates?', '$to_s', '$key?']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      function $Converter() {};
      var self = $Converter = $module($base, 'Converter', $Converter);

      var def = self.prototype, $nesting = [self].concat($parent_nesting);

      (function($base, $super, $parent_nesting) {
        function $Factory(){};
        var self = $Factory = $klass($base, $super, 'Factory', $Factory);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Factory_initialize_7, TMP_Factory_register_8, TMP_Factory_resolve_10, TMP_Factory_unregister_all_11, TMP_Factory_create_12;

        def.converters = def.star_converter = nil;
        
        self.__default__ = nil;
        (function(self, $parent_nesting) {
          var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_default_1, TMP_register_2, TMP_resolve_3, TMP_create_4, TMP_converters_5, TMP_unregister_all_6;

          
          
          Opal.def(self, '$default', TMP_default_1 = function(initialize_singleton) {
            var $a, $b, $c, self = this;
            if (self.__default__ == null) self.__default__ = nil;

            
            
            if (initialize_singleton == null) {
              initialize_singleton = true;
            };
            if ($truthy(initialize_singleton)) {
            } else {
              return ($truthy($a = self.__default__) ? $a : self.$new())
            };
            return (self.__default__ = ($truthy($a = self.__default__) ? $a : (function() { try {
              
              if ($truthy((($c = $$$('::', 'Concurrent', 'skip_raise')) && ($b = $$$($c, 'Hash', 'skip_raise')) ? 'constant' : nil))) {
              } else {
                self.$require((function() {if ($truthy($$$('::', 'RUBY_MIN_VERSION_1_9'))) {
                  return "concurrent/hash"
                } else {
                  return "asciidoctor/core_ext/1.8.7/concurrent/hash"
                }; return nil; })())
              };
              return self.$new($$$($$$('::', 'Concurrent'), 'Hash').$new());
            } catch ($err) {
              if (Opal.rescue($err, [$$$('::', 'LoadError')])) {
                try {
                  
                  if ($truthy(self['$include?']($$($nesting, 'Logging')))) {
                  } else {
                    self.$include($$($nesting, 'Logging'))
                  };
                  self.$logger().$warn("gem 'concurrent-ruby' is not installed. This gem is recommended when registering custom converters.");
                  return self.$new();
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            }})()));
          }, TMP_default_1.$$arity = -1);
          
          Opal.def(self, '$register', TMP_register_2 = function $$register(converter, backends) {
            var self = this;

            
            
            if (backends == null) {
              backends = ["*"];
            };
            return self.$default().$register(converter, backends);
          }, TMP_register_2.$$arity = -2);
          
          Opal.def(self, '$resolve', TMP_resolve_3 = function $$resolve(backend) {
            var self = this;

            return self.$default().$resolve(backend)
          }, TMP_resolve_3.$$arity = 1);
          
          Opal.def(self, '$create', TMP_create_4 = function $$create(backend, opts) {
            var self = this;

            
            
            if (opts == null) {
              opts = $hash2([], {});
            };
            return self.$default().$create(backend, opts);
          }, TMP_create_4.$$arity = -2);
          
          Opal.def(self, '$converters', TMP_converters_5 = function $$converters() {
            var self = this;

            return self.$default().$converters()
          }, TMP_converters_5.$$arity = 0);
          return (Opal.def(self, '$unregister_all', TMP_unregister_all_6 = function $$unregister_all() {
            var self = this;

            return self.$default().$unregister_all()
          }, TMP_unregister_all_6.$$arity = 0), nil) && 'unregister_all';
        })(Opal.get_singleton_class(self), $nesting);
        self.$attr_reader("converters");
        
        Opal.def(self, '$initialize', TMP_Factory_initialize_7 = function $$initialize(converters) {
          var $a, self = this;

          
          
          if (converters == null) {
            converters = nil;
          };
          self.converters = ($truthy($a = converters) ? $a : $hash2([], {}));
          return (self.star_converter = nil);
        }, TMP_Factory_initialize_7.$$arity = -1);
        
        Opal.def(self, '$register', TMP_Factory_register_8 = function $$register(converter, backends) {
          var TMP_9, self = this;

          
          
          if (backends == null) {
            backends = ["*"];
          };
          $send(backends, 'each', [], (TMP_9 = function(backend){var self = TMP_9.$$s || this, $writer = nil;
            if (self.converters == null) self.converters = nil;

          
            
            if (backend == null) {
              backend = nil;
            };
            
            $writer = [backend, converter];
            $send(self.converters, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if (backend['$==']("*")) {
              return (self.star_converter = converter)
            } else {
              return nil
            };}, TMP_9.$$s = self, TMP_9.$$arity = 1, TMP_9));
          return nil;
        }, TMP_Factory_register_8.$$arity = -2);
        
        Opal.def(self, '$resolve', TMP_Factory_resolve_10 = function $$resolve(backend) {
          var $a, $b, self = this;

          return ($truthy($a = self.converters) ? ($truthy($b = self.converters['$[]'](backend)) ? $b : self.star_converter) : $a)
        }, TMP_Factory_resolve_10.$$arity = 1);
        
        Opal.def(self, '$unregister_all', TMP_Factory_unregister_all_11 = function $$unregister_all() {
          var self = this;

          
          self.converters.$clear();
          return (self.star_converter = nil);
        }, TMP_Factory_unregister_all_11.$$arity = 0);
        return (Opal.def(self, '$create', TMP_Factory_create_12 = function $$create(backend, opts) {
          var $a, $b, $c, $d, $e, $f, $g, $h, $i, $j, $k, $l, $m, $n, $o, $p, $q, $r, self = this, converter = nil, base_converter = nil, $case = nil, template_converter = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy((converter = self.$resolve(backend)))) {
            
            base_converter = (function() {if ($truthy($$$('::', 'Class')['$==='](converter))) {
              
              return converter.$new(backend, opts);
            } else {
              return converter
            }; return nil; })();
            if ($truthy(($truthy($a = $$$($$($nesting, 'Converter'), 'BackendInfo')['$==='](base_converter)) ? base_converter['$supports_templates?']() : $a))) {
            } else {
              return base_converter
            };
          } else {
            $case = backend;
            if ("html5"['$===']($case)) {
            if ($truthy((($c = $$$('::', 'Asciidoctor', 'skip_raise')) && ($b = $$$($c, 'Converter', 'skip_raise')) && ($a = $$$($b, 'Html5Converter', 'skip_raise')) ? 'constant' : nil))) {
            } else {
              self.$require("asciidoctor/converter/html5".$to_s())
            };
            base_converter = $$($nesting, 'Html5Converter').$new(backend, opts);}
            else if ("docbook5"['$===']($case)) {
            if ($truthy((($f = $$$('::', 'Asciidoctor', 'skip_raise')) && ($e = $$$($f, 'Converter', 'skip_raise')) && ($d = $$$($e, 'DocBook5Converter', 'skip_raise')) ? 'constant' : nil))) {
            } else {
              self.$require("asciidoctor/converter/docbook5".$to_s())
            };
            base_converter = $$($nesting, 'DocBook5Converter').$new(backend, opts);}
            else if ("docbook45"['$===']($case)) {
            if ($truthy((($i = $$$('::', 'Asciidoctor', 'skip_raise')) && ($h = $$$($i, 'Converter', 'skip_raise')) && ($g = $$$($h, 'DocBook45Converter', 'skip_raise')) ? 'constant' : nil))) {
            } else {
              self.$require("asciidoctor/converter/docbook45".$to_s())
            };
            base_converter = $$($nesting, 'DocBook45Converter').$new(backend, opts);}
            else if ("manpage"['$===']($case)) {
            if ($truthy((($l = $$$('::', 'Asciidoctor', 'skip_raise')) && ($k = $$$($l, 'Converter', 'skip_raise')) && ($j = $$$($k, 'ManPageConverter', 'skip_raise')) ? 'constant' : nil))) {
            } else {
              self.$require("asciidoctor/converter/manpage".$to_s())
            };
            base_converter = $$($nesting, 'ManPageConverter').$new(backend, opts);}
          };
          if ($truthy(opts['$key?']("template_dirs"))) {
          } else {
            return base_converter
          };
          if ($truthy((($o = $$$('::', 'Asciidoctor', 'skip_raise')) && ($n = $$$($o, 'Converter', 'skip_raise')) && ($m = $$$($n, 'TemplateConverter', 'skip_raise')) ? 'constant' : nil))) {
          } else {
            self.$require("asciidoctor/converter/template".$to_s())
          };
          template_converter = $$($nesting, 'TemplateConverter').$new(backend, opts['$[]']("template_dirs"), opts);
          if ($truthy((($r = $$$('::', 'Asciidoctor', 'skip_raise')) && ($q = $$$($r, 'Converter', 'skip_raise')) && ($p = $$$($q, 'CompositeConverter', 'skip_raise')) ? 'constant' : nil))) {
          } else {
            self.$require("asciidoctor/converter/composite".$to_s())
          };
          return $$($nesting, 'CompositeConverter').$new(backend, template_converter, base_converter);
        }, TMP_Factory_create_12.$$arity = -2), nil) && 'create';
      })($nesting[0], null, $nesting)
    })($nesting[0], $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2;

  Opal.add_stubs(['$register', '$==', '$send', '$include?', '$setup_backend_info', '$raise', '$class', '$sub', '$[]', '$slice', '$length', '$[]=', '$backend_info', '$-', '$extend', '$include', '$respond_to?', '$write', '$chomp', '$require']);
  
  (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    
    (function($base, $parent_nesting) {
      function $Converter() {};
      var self = $Converter = $module($base, 'Converter', $Converter);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Converter_initialize_13, TMP_Converter_convert_14;

      
      (function($base, $parent_nesting) {
        function $Config() {};
        var self = $Config = $module($base, 'Config', $Config);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Config_register_for_1;

        
        Opal.def(self, '$register_for', TMP_Config_register_for_1 = function $$register_for($a) {
          var $post_args, backends, TMP_2, TMP_3, self = this, metaclass = nil;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          backends = $post_args;;
          $$($nesting, 'Factory').$register(self, backends);
          metaclass = (function(self, $parent_nesting) {
            var def = self.prototype, $nesting = [self].concat($parent_nesting);

            return self
          })(Opal.get_singleton_class(self), $nesting);
          if (backends['$=='](["*"])) {
            $send(metaclass, 'send', ["define_method", "converts?"], (TMP_2 = function(name){var self = TMP_2.$$s || this;

            
              
              if (name == null) {
                name = nil;
              };
              return true;}, TMP_2.$$s = self, TMP_2.$$arity = 1, TMP_2))
          } else {
            $send(metaclass, 'send', ["define_method", "converts?"], (TMP_3 = function(name){var self = TMP_3.$$s || this;

            
              
              if (name == null) {
                name = nil;
              };
              return backends['$include?'](name);}, TMP_3.$$s = self, TMP_3.$$arity = 1, TMP_3))
          };
          return nil;
        }, TMP_Config_register_for_1.$$arity = -1)
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        function $BackendInfo() {};
        var self = $BackendInfo = $module($base, 'BackendInfo', $BackendInfo);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_BackendInfo_backend_info_4, TMP_BackendInfo_setup_backend_info_5, TMP_BackendInfo_filetype_6, TMP_BackendInfo_basebackend_7, TMP_BackendInfo_outfilesuffix_8, TMP_BackendInfo_htmlsyntax_9, TMP_BackendInfo_supports_templates_10, TMP_BackendInfo_supports_templates$q_11;

        
        
        Opal.def(self, '$backend_info', TMP_BackendInfo_backend_info_4 = function $$backend_info() {
          var $a, self = this;
          if (self.backend_info == null) self.backend_info = nil;

          return (self.backend_info = ($truthy($a = self.backend_info) ? $a : self.$setup_backend_info()))
        }, TMP_BackendInfo_backend_info_4.$$arity = 0);
        
        Opal.def(self, '$setup_backend_info', TMP_BackendInfo_setup_backend_info_5 = function $$setup_backend_info() {
          var self = this, base = nil, ext = nil, type = nil, syntax = nil;
          if (self.backend == null) self.backend = nil;

          
          if ($truthy(self.backend)) {
          } else {
            self.$raise($$$('::', 'ArgumentError'), "" + "Cannot determine backend for converter: " + (self.$class()))
          };
          base = self.backend.$sub($$($nesting, 'TrailingDigitsRx'), "");
          if ($truthy((ext = $$($nesting, 'DEFAULT_EXTENSIONS')['$[]'](base)))) {
            type = ext.$slice(1, ext.$length())
          } else {
            
            base = "html";
            ext = ".html";
            type = "html";
            syntax = "html";
          };
          return $hash2(["basebackend", "outfilesuffix", "filetype", "htmlsyntax"], {"basebackend": base, "outfilesuffix": ext, "filetype": type, "htmlsyntax": syntax});
        }, TMP_BackendInfo_setup_backend_info_5.$$arity = 0);
        
        Opal.def(self, '$filetype', TMP_BackendInfo_filetype_6 = function $$filetype(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            $writer = ["filetype", value];
            $send(self.$backend_info(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            return self.$backend_info()['$[]']("filetype")
          };
        }, TMP_BackendInfo_filetype_6.$$arity = -1);
        
        Opal.def(self, '$basebackend', TMP_BackendInfo_basebackend_7 = function $$basebackend(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            $writer = ["basebackend", value];
            $send(self.$backend_info(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            return self.$backend_info()['$[]']("basebackend")
          };
        }, TMP_BackendInfo_basebackend_7.$$arity = -1);
        
        Opal.def(self, '$outfilesuffix', TMP_BackendInfo_outfilesuffix_8 = function $$outfilesuffix(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            $writer = ["outfilesuffix", value];
            $send(self.$backend_info(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            return self.$backend_info()['$[]']("outfilesuffix")
          };
        }, TMP_BackendInfo_outfilesuffix_8.$$arity = -1);
        
        Opal.def(self, '$htmlsyntax', TMP_BackendInfo_htmlsyntax_9 = function $$htmlsyntax(value) {
          var self = this, $writer = nil;

          
          
          if (value == null) {
            value = nil;
          };
          if ($truthy(value)) {
            
            $writer = ["htmlsyntax", value];
            $send(self.$backend_info(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            return self.$backend_info()['$[]']("htmlsyntax")
          };
        }, TMP_BackendInfo_htmlsyntax_9.$$arity = -1);
        
        Opal.def(self, '$supports_templates', TMP_BackendInfo_supports_templates_10 = function $$supports_templates() {
          var self = this, $writer = nil;

          
          $writer = ["supports_templates", true];
          $send(self.$backend_info(), '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        }, TMP_BackendInfo_supports_templates_10.$$arity = 0);
        
        Opal.def(self, '$supports_templates?', TMP_BackendInfo_supports_templates$q_11 = function() {
          var self = this;

          return self.$backend_info()['$[]']("supports_templates")
        }, TMP_BackendInfo_supports_templates$q_11.$$arity = 0);
      })($nesting[0], $nesting);
      (function(self, $parent_nesting) {
        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_included_12;

        return (Opal.def(self, '$included', TMP_included_12 = function $$included(converter) {
          var self = this;

          return converter.$extend($$($nesting, 'Config'))
        }, TMP_included_12.$$arity = 1), nil) && 'included'
      })(Opal.get_singleton_class(self), $nesting);
      self.$include($$($nesting, 'Config'));
      self.$include($$($nesting, 'BackendInfo'));
      
      Opal.def(self, '$initialize', TMP_Converter_initialize_13 = function $$initialize(backend, opts) {
        var self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        self.backend = backend;
        return self.$setup_backend_info();
      }, TMP_Converter_initialize_13.$$arity = -2);
      
      Opal.def(self, '$convert', TMP_Converter_convert_14 = function $$convert(node, transform, opts) {
        var self = this;

        
        
        if (transform == null) {
          transform = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        return self.$raise($$$('::', 'NotImplementedError'));
      }, TMP_Converter_convert_14.$$arity = -2);
      Opal.alias(self, "handles?", "respond_to?");
      Opal.alias(self, "convert_with_options", "convert");
    })($nesting[0], $nesting);
    (function($base, $parent_nesting) {
      function $Writer() {};
      var self = $Writer = $module($base, 'Writer', $Writer);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Writer_write_15;

      
      Opal.def(self, '$write', TMP_Writer_write_15 = function $$write(output, target) {
        var self = this;

        
        if ($truthy(target['$respond_to?']("write"))) {
          
          target.$write(output.$chomp());
          target.$write($$($nesting, 'LF'));
        } else {
          $$$('::', 'IO').$write(target, output)
        };
        return nil;
      }, TMP_Writer_write_15.$$arity = 2)
    })($nesting[0], $nesting);
    (function($base, $parent_nesting) {
      function $VoidWriter() {};
      var self = $VoidWriter = $module($base, 'VoidWriter', $VoidWriter);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_VoidWriter_write_16;

      
      self.$include($$($nesting, 'Writer'));
      
      Opal.def(self, '$write', TMP_VoidWriter_write_16 = function $$write(output, target) {
        var self = this;

        return nil
      }, TMP_VoidWriter_write_16.$$arity = 2);
    })($nesting[0], $nesting);
  })($nesting[0], $nesting);
  self.$require("asciidoctor/converter/base");
  return self.$require("asciidoctor/converter/factory");
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/document"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_ge(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs >= rhs : lhs['$>='](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2, $gvars = Opal.gvars;

  Opal.add_stubs(['$new', '$attr_reader', '$nil?', '$<<', '$[]', '$[]=', '$-', '$include?', '$strip', '$squeeze', '$gsub', '$empty?', '$!', '$rpartition', '$attr_accessor', '$delete', '$base_dir', '$options', '$inject', '$catalog', '$==', '$dup', '$attributes', '$safe', '$compat_mode', '$sourcemap', '$path_resolver', '$converter', '$extensions', '$each', '$end_with?', '$start_with?', '$slice', '$length', '$chop', '$downcase', '$extname', '$===', '$value_for_name', '$to_s', '$key?', '$freeze', '$attribute_undefined', '$attribute_missing', '$name_for_value', '$expand_path', '$pwd', '$>=', '$+', '$abs', '$to_i', '$delete_if', '$update_doctype_attributes', '$cursor', '$parse', '$restore_attributes', '$update_backend_attributes', '$utc', '$at', '$Integer', '$now', '$index', '$strftime', '$year', '$utc_offset', '$fetch', '$activate', '$create', '$to_proc', '$groups', '$preprocessors?', '$preprocessors', '$process_method', '$tree_processors?', '$tree_processors', '$!=', '$counter', '$nil_or_empty?', '$nextval', '$value', '$save_to', '$chr', '$ord', '$source', '$source_lines', '$doctitle', '$sectname=', '$title=', '$first_section', '$title', '$merge', '$>', '$<', '$find', '$context', '$assign_numeral', '$clear_playback_attributes', '$save_attributes', '$attribute_locked?', '$rewind', '$replace', '$name', '$negate', '$limit_bytesize', '$apply_attribute_value_subs', '$delete?', '$=~', '$apply_subs', '$resolve_pass_subs', '$apply_header_subs', '$create_converter', '$basebackend', '$outfilesuffix', '$filetype', '$sub', '$raise', '$Array', '$backend', '$default', '$start', '$doctype', '$content_model', '$warn', '$logger', '$content', '$convert', '$postprocessors?', '$postprocessors', '$record', '$write', '$respond_to?', '$chomp', '$write_alternate_pages', '$map', '$split', '$resolve_docinfo_subs', '$&', '$normalize_system_path', '$read_asset', '$docinfo_processors?', '$compact', '$join', '$resolve_subs', '$docinfo_processors', '$class', '$object_id', '$inspect', '$size']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Document(){};
      var self = $Document = $klass($base, $super, 'Document', $Document);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Document_1, TMP_Document_initialize_8, TMP_Document_parse_12, TMP_Document_counter_15, TMP_Document_increment_and_store_counter_16, TMP_Document_nextval_17, TMP_Document_register_18, TMP_Document_footnotes$q_19, TMP_Document_footnotes_20, TMP_Document_callouts_21, TMP_Document_nested$q_22, TMP_Document_embedded$q_23, TMP_Document_extensions$q_24, TMP_Document_source_25, TMP_Document_source_lines_26, TMP_Document_basebackend$q_27, TMP_Document_title_28, TMP_Document_title$eq_29, TMP_Document_doctitle_30, TMP_Document_author_31, TMP_Document_authors_32, TMP_Document_revdate_33, TMP_Document_notitle_34, TMP_Document_noheader_35, TMP_Document_nofooter_36, TMP_Document_first_section_37, TMP_Document_has_header$q_39, TMP_Document_$lt$lt_40, TMP_Document_finalize_header_41, TMP_Document_save_attributes_42, TMP_Document_restore_attributes_44, TMP_Document_clear_playback_attributes_45, TMP_Document_playback_attributes_46, TMP_Document_set_attribute_48, TMP_Document_delete_attribute_49, TMP_Document_attribute_locked$q_50, TMP_Document_set_header_attribute_51, TMP_Document_apply_attribute_value_subs_52, TMP_Document_update_backend_attributes_53, TMP_Document_update_doctype_attributes_54, TMP_Document_create_converter_55, TMP_Document_convert_56, TMP_Document_write_58, TMP_Document_content_59, TMP_Document_docinfo_60, TMP_Document_resolve_docinfo_subs_63, TMP_Document_docinfo_processors$q_64, TMP_Document_to_s_65;

      def.attributes = def.safe = def.sourcemap = def.reader = def.base_dir = def.parsed = def.parent_document = def.extensions = def.options = def.counters = def.catalog = def.header = def.blocks = def.attributes_modified = def.id = def.header_attributes = def.max_attribute_value_size = def.attribute_overrides = def.backend = def.doctype = def.converter = def.timings = def.outfilesuffix = def.docinfo_processor_extensions = def.document = nil;
      
      Opal.const_set($nesting[0], 'ImageReference', $send($$$('::', 'Struct'), 'new', ["target", "imagesdir"], (TMP_Document_1 = function(){var self = TMP_Document_1.$$s || this;

      return Opal.alias(self, "to_s", "target")}, TMP_Document_1.$$s = self, TMP_Document_1.$$arity = 0, TMP_Document_1)));
      Opal.const_set($nesting[0], 'Footnote', $$$('::', 'Struct').$new("index", "id", "text"));
      (function($base, $super, $parent_nesting) {
        function $AttributeEntry(){};
        var self = $AttributeEntry = $klass($base, $super, 'AttributeEntry', $AttributeEntry);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_AttributeEntry_initialize_2, TMP_AttributeEntry_save_to_3;

        
        self.$attr_reader("name", "value", "negate");
        
        Opal.def(self, '$initialize', TMP_AttributeEntry_initialize_2 = function $$initialize(name, value, negate) {
          var self = this;

          
          
          if (negate == null) {
            negate = nil;
          };
          self.name = name;
          self.value = value;
          return (self.negate = (function() {if ($truthy(negate['$nil?']())) {
            return value['$nil?']()
          } else {
            return negate
          }; return nil; })());
        }, TMP_AttributeEntry_initialize_2.$$arity = -3);
        return (Opal.def(self, '$save_to', TMP_AttributeEntry_save_to_3 = function $$save_to(block_attributes) {
          var $a, self = this, $writer = nil;

          
          ($truthy($a = block_attributes['$[]']("attribute_entries")) ? $a : (($writer = ["attribute_entries", []]), $send(block_attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$<<'](self);
          return self;
        }, TMP_AttributeEntry_save_to_3.$$arity = 1), nil) && 'save_to';
      })($nesting[0], null, $nesting);
      (function($base, $super, $parent_nesting) {
        function $Title(){};
        var self = $Title = $klass($base, $super, 'Title', $Title);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Title_initialize_4, TMP_Title_sanitized$q_5, TMP_Title_subtitle$q_6, TMP_Title_to_s_7;

        def.sanitized = def.subtitle = def.combined = nil;
        
        self.$attr_reader("main");
        Opal.alias(self, "title", "main");
        self.$attr_reader("subtitle");
        self.$attr_reader("combined");
        
        Opal.def(self, '$initialize', TMP_Title_initialize_4 = function $$initialize(val, opts) {
          var $a, $b, self = this, sep = nil, _ = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy(($truthy($a = (self.sanitized = opts['$[]']("sanitize"))) ? val['$include?']("<") : $a))) {
            val = val.$gsub($$($nesting, 'XmlSanitizeRx'), "").$squeeze(" ").$strip()};
          if ($truthy(($truthy($a = (sep = ($truthy($b = opts['$[]']("separator")) ? $b : ":"))['$empty?']()) ? $a : val['$include?']((sep = "" + (sep) + " "))['$!']()))) {
            
            self.main = val;
            self.subtitle = nil;
          } else {
            $b = val.$rpartition(sep), $a = Opal.to_ary($b), (self.main = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (self.subtitle = ($a[2] == null ? nil : $a[2])), $b
          };
          return (self.combined = val);
        }, TMP_Title_initialize_4.$$arity = -2);
        
        Opal.def(self, '$sanitized?', TMP_Title_sanitized$q_5 = function() {
          var self = this;

          return self.sanitized
        }, TMP_Title_sanitized$q_5.$$arity = 0);
        
        Opal.def(self, '$subtitle?', TMP_Title_subtitle$q_6 = function() {
          var self = this;

          if ($truthy(self.subtitle)) {
            return true
          } else {
            return false
          }
        }, TMP_Title_subtitle$q_6.$$arity = 0);
        return (Opal.def(self, '$to_s', TMP_Title_to_s_7 = function $$to_s() {
          var self = this;

          return self.combined
        }, TMP_Title_to_s_7.$$arity = 0), nil) && 'to_s';
      })($nesting[0], null, $nesting);
      Opal.const_set($nesting[0], 'Author', $$$('::', 'Struct').$new("name", "firstname", "middlename", "lastname", "initials", "email"));
      self.$attr_reader("safe");
      self.$attr_reader("compat_mode");
      self.$attr_reader("backend");
      self.$attr_reader("doctype");
      self.$attr_accessor("sourcemap");
      self.$attr_reader("catalog");
      Opal.alias(self, "references", "catalog");
      self.$attr_reader("counters");
      self.$attr_reader("header");
      self.$attr_reader("base_dir");
      self.$attr_reader("options");
      self.$attr_reader("outfilesuffix");
      self.$attr_reader("parent_document");
      self.$attr_reader("reader");
      self.$attr_reader("path_resolver");
      self.$attr_reader("converter");
      self.$attr_reader("extensions");
      
      Opal.def(self, '$initialize', TMP_Document_initialize_8 = function $$initialize(data, options) {
        var $a, TMP_9, TMP_10, $b, $c, TMP_11, $d, $iter = TMP_Document_initialize_8.$$p, $yield = $iter || nil, self = this, parent_doc = nil, $writer = nil, attr_overrides = nil, parent_doctype = nil, initialize_extensions = nil, to_file = nil, safe_mode = nil, header_footer = nil, attrs = nil, safe_mode_name = nil, base_dir_val = nil, backend_val = nil, doctype_val = nil, size = nil, now = nil, localdate = nil, localyear = nil, localtime = nil, ext_registry = nil, ext_block = nil;

        if ($iter) TMP_Document_initialize_8.$$p = null;
        
        
        if (data == null) {
          data = nil;
        };
        
        if (options == null) {
          options = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Document_initialize_8, false), [self, "document"], null);
        if ($truthy((parent_doc = options.$delete("parent")))) {
          
          self.parent_document = parent_doc;
          ($truthy($a = options['$[]']("base_dir")) ? $a : (($writer = ["base_dir", parent_doc.$base_dir()]), $send(options, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          if ($truthy(parent_doc.$options()['$[]']("catalog_assets"))) {
            
            $writer = ["catalog_assets", true];
            $send(options, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          self.catalog = $send(parent_doc.$catalog(), 'inject', [$hash2([], {})], (TMP_9 = function(accum, $mlhs_tmp1){var self = TMP_9.$$s || this, $b, $c, key = nil, table = nil;

          
            
            if (accum == null) {
              accum = nil;
            };
            
            if ($mlhs_tmp1 == null) {
              $mlhs_tmp1 = nil;
            };
            $c = $mlhs_tmp1, $b = Opal.to_ary($c), (key = ($b[0] == null ? nil : $b[0])), (table = ($b[1] == null ? nil : $b[1])), $c;
            
            $writer = [key, (function() {if (key['$==']("footnotes")) {
              return []
            } else {
              return table
            }; return nil; })()];
            $send(accum, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            return accum;}, TMP_9.$$s = self, TMP_9.$$arity = 2, TMP_9.$$has_top_level_mlhs_arg = true, TMP_9));
          self.attribute_overrides = (attr_overrides = parent_doc.$attributes().$dup());
          parent_doctype = attr_overrides.$delete("doctype");
          attr_overrides.$delete("compat-mode");
          attr_overrides.$delete("toc");
          attr_overrides.$delete("toc-placement");
          attr_overrides.$delete("toc-position");
          self.safe = parent_doc.$safe();
          if ($truthy((self.compat_mode = parent_doc.$compat_mode()))) {
            
            $writer = ["compat-mode", ""];
            $send(self.attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          self.sourcemap = parent_doc.$sourcemap();
          self.timings = nil;
          self.path_resolver = parent_doc.$path_resolver();
          self.converter = parent_doc.$converter();
          initialize_extensions = false;
          self.extensions = parent_doc.$extensions();
        } else {
          
          self.parent_document = nil;
          self.catalog = $hash2(["ids", "refs", "footnotes", "links", "images", "indexterms", "callouts", "includes"], {"ids": $hash2([], {}), "refs": $hash2([], {}), "footnotes": [], "links": [], "images": [], "indexterms": [], "callouts": $$($nesting, 'Callouts').$new(), "includes": $hash2([], {})});
          self.attribute_overrides = (attr_overrides = $hash2([], {}));
          $send(($truthy($a = options['$[]']("attributes")) ? $a : $hash2([], {})), 'each', [], (TMP_10 = function(key, val){var self = TMP_10.$$s || this, $b;

          
            
            if (key == null) {
              key = nil;
            };
            
            if (val == null) {
              val = nil;
            };
            if ($truthy(key['$end_with?']("@"))) {
              if ($truthy(key['$start_with?']("!"))) {
                $b = [key.$slice(1, $rb_minus(key.$length(), 2)), false], (key = $b[0]), (val = $b[1]), $b
              } else if ($truthy(key['$end_with?']("!@"))) {
                $b = [key.$slice(0, $rb_minus(key.$length(), 2)), false], (key = $b[0]), (val = $b[1]), $b
              } else {
                $b = [key.$chop(), "" + (val) + "@"], (key = $b[0]), (val = $b[1]), $b
              }
            } else if ($truthy(key['$start_with?']("!"))) {
              $b = [key.$slice(1, key.$length()), (function() {if (val['$==']("@")) {
                return false
              } else {
                return nil
              }; return nil; })()], (key = $b[0]), (val = $b[1]), $b
            } else if ($truthy(key['$end_with?']("!"))) {
              $b = [key.$chop(), (function() {if (val['$==']("@")) {
                return false
              } else {
                return nil
              }; return nil; })()], (key = $b[0]), (val = $b[1]), $b};
            
            $writer = [key.$downcase(), val];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;}, TMP_10.$$s = self, TMP_10.$$arity = 2, TMP_10));
          if ($truthy((to_file = options['$[]']("to_file")))) {
            
            $writer = ["outfilesuffix", $$$('::', 'File').$extname(to_file)];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy((safe_mode = options['$[]']("safe"))['$!']())) {
            self.safe = $$$($$($nesting, 'SafeMode'), 'SECURE')
          } else if ($truthy($$$('::', 'Integer')['$==='](safe_mode))) {
            self.safe = safe_mode
          } else {
            
            try {
              self.safe = $$($nesting, 'SafeMode').$value_for_name(safe_mode.$to_s())
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  self.safe = $$$($$($nesting, 'SafeMode'), 'SECURE')
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };
          };
          self.compat_mode = attr_overrides['$key?']("compat-mode");
          self.sourcemap = options['$[]']("sourcemap");
          self.timings = options.$delete("timings");
          self.path_resolver = $$($nesting, 'PathResolver').$new();
          self.converter = nil;
          initialize_extensions = (($b = $$$('::', 'Asciidoctor', 'skip_raise')) && ($a = $$$($b, 'Extensions', 'skip_raise')) ? 'constant' : nil);
          self.extensions = nil;
        };
        self.parsed = false;
        self.header = (self.header_attributes = nil);
        self.counters = $hash2([], {});
        self.attributes_modified = $$$('::', 'Set').$new();
        self.docinfo_processor_extensions = $hash2([], {});
        header_footer = ($truthy($c = options['$[]']("header_footer")) ? $c : (($writer = ["header_footer", false]), $send(options, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        (self.options = options).$freeze();
        attrs = self.attributes;
        
        $writer = ["sectids", ""];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["toc-placement", "auto"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy(header_footer)) {
          
          
          $writer = ["copycss", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["embedded", nil];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        } else {
          
          
          $writer = ["notitle", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["embedded", ""];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        };
        
        $writer = ["stylesheet", ""];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["webfonts", ""];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["prewrap", ""];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["attribute-undefined", $$($nesting, 'Compliance').$attribute_undefined()];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["attribute-missing", $$($nesting, 'Compliance').$attribute_missing()];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["iconfont-remote", ""];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["caution-caption", "Caution"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["important-caption", "Important"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["note-caption", "Note"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["tip-caption", "Tip"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["warning-caption", "Warning"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["example-caption", "Example"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["figure-caption", "Figure"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["table-caption", "Table"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["toc-title", "Table of Contents"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["section-refsig", "Section"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["part-refsig", "Part"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["chapter-refsig", "Chapter"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["appendix-caption", (($writer = ["appendix-refsig", "Appendix"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["untitled-label", "Untitled"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["version-label", "Version"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["last-update-label", "Last updated"];
        $send(attrs, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["asciidoctor", ""];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["asciidoctor-version", $$($nesting, 'VERSION')];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["safe-mode-name", (safe_mode_name = $$($nesting, 'SafeMode').$name_for_value(self.safe))];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["" + "safe-mode-" + (safe_mode_name), ""];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["safe-mode-level", self.safe];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        ($truthy($c = attr_overrides['$[]']("max-include-depth")) ? $c : (($writer = ["max-include-depth", 64]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($c = attr_overrides['$[]']("allow-uri-read")) ? $c : (($writer = ["allow-uri-read", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        
        $writer = ["user-home", $$($nesting, 'USER_HOME')];
        $send(attr_overrides, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy(attr_overrides['$key?']("numbered"))) {
          
          $writer = ["sectnums", attr_overrides.$delete("numbered")];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy((base_dir_val = options['$[]']("base_dir")))) {
          self.base_dir = (($writer = ["docdir", $$$('::', 'File').$expand_path(base_dir_val)]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
        } else if ($truthy(attr_overrides['$[]']("docdir"))) {
          self.base_dir = attr_overrides['$[]']("docdir")
        } else {
          self.base_dir = (($writer = ["docdir", $$$('::', 'Dir').$pwd()]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
        };
        if ($truthy((backend_val = options['$[]']("backend")))) {
          
          $writer = ["backend", "" + (backend_val)];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy((doctype_val = options['$[]']("doctype")))) {
          
          $writer = ["doctype", "" + (doctype_val)];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy($rb_ge(self.safe, $$$($$($nesting, 'SafeMode'), 'SERVER')))) {
          
          ($truthy($c = attr_overrides['$[]']("copycss")) ? $c : (($writer = ["copycss", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attr_overrides['$[]']("source-highlighter")) ? $c : (($writer = ["source-highlighter", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attr_overrides['$[]']("backend")) ? $c : (($writer = ["backend", $$($nesting, 'DEFAULT_BACKEND')]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          if ($truthy(($truthy($c = parent_doc['$!']()) ? attr_overrides['$key?']("docfile") : $c))) {
            
            $writer = ["docfile", attr_overrides['$[]']("docfile")['$[]'](Opal.Range.$new($rb_plus(attr_overrides['$[]']("docdir").$length(), 1), -1, false))];
            $send(attr_overrides, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          
          $writer = ["docdir", ""];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["user-home", "."];
          $send(attr_overrides, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy($rb_ge(self.safe, $$$($$($nesting, 'SafeMode'), 'SECURE')))) {
            
            if ($truthy(attr_overrides['$key?']("max-attribute-value-size"))) {
            } else {
              
              $writer = ["max-attribute-value-size", 4096];
              $send(attr_overrides, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            if ($truthy(attr_overrides['$key?']("linkcss"))) {
            } else {
              
              $writer = ["linkcss", ""];
              $send(attr_overrides, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            ($truthy($c = attr_overrides['$[]']("icons")) ? $c : (($writer = ["icons", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));};};
        self.max_attribute_value_size = (function() {if ($truthy((size = ($truthy($c = attr_overrides['$[]']("max-attribute-value-size")) ? $c : (($writer = ["max-attribute-value-size", nil]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))))) {
          return size.$to_i().$abs()
        } else {
          return nil
        }; return nil; })();
        $send(attr_overrides, 'delete_if', [], (TMP_11 = function(key, val){var self = TMP_11.$$s || this, $d, verdict = nil;

        
          
          if (key == null) {
            key = nil;
          };
          
          if (val == null) {
            val = nil;
          };
          if ($truthy(val)) {
            
            if ($truthy(($truthy($d = $$$('::', 'String')['$==='](val)) ? val['$end_with?']("@") : $d))) {
              $d = [val.$chop(), true], (val = $d[0]), (verdict = $d[1]), $d};
            
            $writer = [key, val];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else {
            
            attrs.$delete(key);
            verdict = val['$=='](false);
          };
          return verdict;}, TMP_11.$$s = self, TMP_11.$$arity = 2, TMP_11));
        if ($truthy(parent_doc)) {
          
          self.backend = attrs['$[]']("backend");
          if ((self.doctype = (($writer = ["doctype", parent_doctype]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$==']($$($nesting, 'DEFAULT_DOCTYPE'))) {
          } else {
            self.$update_doctype_attributes($$($nesting, 'DEFAULT_DOCTYPE'))
          };
          self.reader = $$($nesting, 'Reader').$new(data, options['$[]']("cursor"));
          if ($truthy(self.sourcemap)) {
            self.source_location = self.reader.$cursor()};
          $$($nesting, 'Parser').$parse(self.reader, self);
          self.$restore_attributes();
          return (self.parsed = true);
        } else {
          
          self.backend = nil;
          if (($truthy($c = attrs['$[]']("backend")) ? $c : (($writer = ["backend", $$($nesting, 'DEFAULT_BACKEND')]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$==']("manpage")) {
            self.doctype = (($writer = ["doctype", (($writer = ["doctype", "manpage"]), $send(attr_overrides, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
          } else {
            self.doctype = ($truthy($c = attrs['$[]']("doctype")) ? $c : (($writer = ["doctype", $$($nesting, 'DEFAULT_DOCTYPE')]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
          };
          self.$update_backend_attributes(attrs['$[]']("backend"), true);
          now = (function() {if ($truthy($$$('::', 'ENV')['$[]']("SOURCE_DATE_EPOCH"))) {
            return $$$('::', 'Time').$at(self.$Integer($$$('::', 'ENV')['$[]']("SOURCE_DATE_EPOCH"))).$utc()
          } else {
            return $$$('::', 'Time').$now()
          }; return nil; })();
          if ($truthy((localdate = attrs['$[]']("localdate")))) {
            localyear = ($truthy($c = attrs['$[]']("localyear")) ? $c : (($writer = ["localyear", (function() {if (localdate.$index("-")['$=='](4)) {
              
              return localdate.$slice(0, 4);
            } else {
              return nil
            }; return nil; })()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
          } else {
            
            localdate = (($writer = ["localdate", now.$strftime("%F")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
            localyear = ($truthy($c = attrs['$[]']("localyear")) ? $c : (($writer = ["localyear", now.$year().$to_s()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          };
          localtime = ($truthy($c = attrs['$[]']("localtime")) ? $c : (($writer = ["localtime", now.$strftime("" + "%T " + ((function() {if (now.$utc_offset()['$=='](0)) {
            return "UTC"
          } else {
            return "%z"
          }; return nil; })()))]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attrs['$[]']("localdatetime")) ? $c : (($writer = ["localdatetime", "" + (localdate) + " " + (localtime)]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attrs['$[]']("docdate")) ? $c : (($writer = ["docdate", localdate]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attrs['$[]']("docyear")) ? $c : (($writer = ["docyear", localyear]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attrs['$[]']("doctime")) ? $c : (($writer = ["doctime", localtime]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attrs['$[]']("docdatetime")) ? $c : (($writer = ["docdatetime", "" + (localdate) + " " + (localtime)]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attrs['$[]']("stylesdir")) ? $c : (($writer = ["stylesdir", "."]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          ($truthy($c = attrs['$[]']("iconsdir")) ? $c : (($writer = ["iconsdir", "" + (attrs.$fetch("imagesdir", "./images")) + "/icons"]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          if ($truthy(initialize_extensions)) {
            if ($truthy((ext_registry = options['$[]']("extension_registry")))) {
              if ($truthy(($truthy($c = $$$($$($nesting, 'Extensions'), 'Registry')['$==='](ext_registry)) ? $c : ($truthy($d = $$$('::', 'RUBY_ENGINE_JRUBY')) ? $$$($$$($$$('::', 'AsciidoctorJ'), 'Extensions'), 'ExtensionRegistry')['$==='](ext_registry) : $d)))) {
                self.extensions = ext_registry.$activate(self)}
            } else if ($truthy($$$('::', 'Proc')['$===']((ext_block = options['$[]']("extensions"))))) {
              self.extensions = $send($$($nesting, 'Extensions'), 'create', [], ext_block.$to_proc()).$activate(self)
            } else if ($truthy($$($nesting, 'Extensions').$groups()['$empty?']()['$!']())) {
              self.extensions = $$$($$($nesting, 'Extensions'), 'Registry').$new().$activate(self)}};
          self.reader = $$($nesting, 'PreprocessorReader').$new(self, data, $$$($$($nesting, 'Reader'), 'Cursor').$new(attrs['$[]']("docfile"), self.base_dir), $hash2(["normalize"], {"normalize": true}));
          if ($truthy(self.sourcemap)) {
            return (self.source_location = self.reader.$cursor())
          } else {
            return nil
          };
        };
      }, TMP_Document_initialize_8.$$arity = -1);
      
      Opal.def(self, '$parse', TMP_Document_parse_12 = function $$parse(data) {
        var $a, TMP_13, TMP_14, self = this, doc = nil, exts = nil;

        
        
        if (data == null) {
          data = nil;
        };
        if ($truthy(self.parsed)) {
          return self
        } else {
          
          doc = self;
          if ($truthy(data)) {
            
            self.reader = $$($nesting, 'PreprocessorReader').$new(doc, data, $$$($$($nesting, 'Reader'), 'Cursor').$new(self.attributes['$[]']("docfile"), self.base_dir), $hash2(["normalize"], {"normalize": true}));
            if ($truthy(self.sourcemap)) {
              self.source_location = self.reader.$cursor()};};
          if ($truthy(($truthy($a = (exts = (function() {if ($truthy(self.parent_document)) {
            return nil
          } else {
            return self.extensions
          }; return nil; })())) ? exts['$preprocessors?']() : $a))) {
            $send(exts.$preprocessors(), 'each', [], (TMP_13 = function(ext){var self = TMP_13.$$s || this, $b;
              if (self.reader == null) self.reader = nil;

            
              
              if (ext == null) {
                ext = nil;
              };
              return (self.reader = ($truthy($b = ext.$process_method()['$[]'](doc, self.reader)) ? $b : self.reader));}, TMP_13.$$s = self, TMP_13.$$arity = 1, TMP_13))};
          $$($nesting, 'Parser').$parse(self.reader, doc, $hash2(["header_only"], {"header_only": self.options['$[]']("parse_header_only")}));
          self.$restore_attributes();
          if ($truthy(($truthy($a = exts) ? exts['$tree_processors?']() : $a))) {
            $send(exts.$tree_processors(), 'each', [], (TMP_14 = function(ext){var self = TMP_14.$$s || this, $b, $c, result = nil;

            
              
              if (ext == null) {
                ext = nil;
              };
              if ($truthy(($truthy($b = ($truthy($c = (result = ext.$process_method()['$[]'](doc))) ? $$($nesting, 'Document')['$==='](result) : $c)) ? result['$!='](doc) : $b))) {
                return (doc = result)
              } else {
                return nil
              };}, TMP_14.$$s = self, TMP_14.$$arity = 1, TMP_14))};
          self.parsed = true;
          return doc;
        };
      }, TMP_Document_parse_12.$$arity = -1);
      
      Opal.def(self, '$counter', TMP_Document_counter_15 = function $$counter(name, seed) {
        var $a, self = this, attr_seed = nil, attr_val = nil, $writer = nil;

        
        
        if (seed == null) {
          seed = nil;
        };
        if ($truthy(self.parent_document)) {
          return self.parent_document.$counter(name, seed)};
        if ($truthy(($truthy($a = (attr_seed = (attr_val = self.attributes['$[]'](name))['$nil_or_empty?']()['$!']())) ? self.counters['$key?'](name) : $a))) {
          
          $writer = [name, (($writer = [name, self.$nextval(attr_val)]), $send(self.counters, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        } else if ($truthy(seed)) {
          
          $writer = [name, (($writer = [name, (function() {if (seed['$=='](seed.$to_i().$to_s())) {
            return seed.$to_i()
          } else {
            return seed
          }; return nil; })()]), $send(self.counters, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        } else {
          
          $writer = [name, (($writer = [name, self.$nextval((function() {if ($truthy(attr_seed)) {
            return attr_val
          } else {
            return 0
          }; return nil; })())]), $send(self.counters, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        };
      }, TMP_Document_counter_15.$$arity = -2);
      
      Opal.def(self, '$increment_and_store_counter', TMP_Document_increment_and_store_counter_16 = function $$increment_and_store_counter(counter_name, block) {
        var self = this;

        return $$($nesting, 'AttributeEntry').$new(counter_name, self.$counter(counter_name)).$save_to(block.$attributes()).$value()
      }, TMP_Document_increment_and_store_counter_16.$$arity = 2);
      Opal.alias(self, "counter_increment", "increment_and_store_counter");
      
      Opal.def(self, '$nextval', TMP_Document_nextval_17 = function $$nextval(current) {
        var self = this, intval = nil;

        if ($truthy($$$('::', 'Integer')['$==='](current))) {
          return $rb_plus(current, 1)
        } else {
          
          intval = current.$to_i();
          if ($truthy(intval.$to_s()['$!='](current.$to_s()))) {
            return $rb_plus(current['$[]'](0).$ord(), 1).$chr()
          } else {
            return $rb_plus(intval, 1)
          };
        }
      }, TMP_Document_nextval_17.$$arity = 1);
      
      Opal.def(self, '$register', TMP_Document_register_18 = function $$register(type, value) {
        var $a, $b, self = this, $case = nil, id = nil, reftext = nil, $logical_op_recvr_tmp_1 = nil, $writer = nil, ref = nil, refs = nil;

        return (function() {$case = type;
        if ("ids"['$===']($case)) {
        $b = value, $a = Opal.to_ary($b), (id = ($a[0] == null ? nil : $a[0])), (reftext = ($a[1] == null ? nil : $a[1])), $b;
        
        $logical_op_recvr_tmp_1 = self.catalog['$[]']("ids");
        return ($truthy($a = $logical_op_recvr_tmp_1['$[]'](id)) ? $a : (($writer = [id, ($truthy($b = reftext) ? $b : $rb_plus($rb_plus("[", id), "]"))]), $send($logical_op_recvr_tmp_1, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));;}
        else if ("refs"['$===']($case)) {
        $b = value, $a = Opal.to_ary($b), (id = ($a[0] == null ? nil : $a[0])), (ref = ($a[1] == null ? nil : $a[1])), (reftext = ($a[2] == null ? nil : $a[2])), $b;
        if ($truthy((refs = self.catalog['$[]']("refs"))['$key?'](id))) {
          return nil
        } else {
          
          
          $writer = [id, ($truthy($a = reftext) ? $a : $rb_plus($rb_plus("[", id), "]"))];
          $send(self.catalog['$[]']("ids"), '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = [id, ref];
          $send(refs, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];;
        };}
        else if ("footnotes"['$===']($case) || "indexterms"['$===']($case)) {return self.catalog['$[]'](type)['$<<'](value)}
        else {if ($truthy(self.options['$[]']("catalog_assets"))) {
          return self.catalog['$[]'](type)['$<<']((function() {if (type['$==']("images")) {
            
            return $$($nesting, 'ImageReference').$new(value['$[]'](0), value['$[]'](1));
          } else {
            return value
          }; return nil; })())
        } else {
          return nil
        }}})()
      }, TMP_Document_register_18.$$arity = 2);
      
      Opal.def(self, '$footnotes?', TMP_Document_footnotes$q_19 = function() {
        var self = this;

        if ($truthy(self.catalog['$[]']("footnotes")['$empty?']())) {
          return false
        } else {
          return true
        }
      }, TMP_Document_footnotes$q_19.$$arity = 0);
      
      Opal.def(self, '$footnotes', TMP_Document_footnotes_20 = function $$footnotes() {
        var self = this;

        return self.catalog['$[]']("footnotes")
      }, TMP_Document_footnotes_20.$$arity = 0);
      
      Opal.def(self, '$callouts', TMP_Document_callouts_21 = function $$callouts() {
        var self = this;

        return self.catalog['$[]']("callouts")
      }, TMP_Document_callouts_21.$$arity = 0);
      
      Opal.def(self, '$nested?', TMP_Document_nested$q_22 = function() {
        var self = this;

        if ($truthy(self.parent_document)) {
          return true
        } else {
          return false
        }
      }, TMP_Document_nested$q_22.$$arity = 0);
      
      Opal.def(self, '$embedded?', TMP_Document_embedded$q_23 = function() {
        var self = this;

        return self.attributes['$key?']("embedded")
      }, TMP_Document_embedded$q_23.$$arity = 0);
      
      Opal.def(self, '$extensions?', TMP_Document_extensions$q_24 = function() {
        var self = this;

        if ($truthy(self.extensions)) {
          return true
        } else {
          return false
        }
      }, TMP_Document_extensions$q_24.$$arity = 0);
      
      Opal.def(self, '$source', TMP_Document_source_25 = function $$source() {
        var self = this;

        if ($truthy(self.reader)) {
          return self.reader.$source()
        } else {
          return nil
        }
      }, TMP_Document_source_25.$$arity = 0);
      
      Opal.def(self, '$source_lines', TMP_Document_source_lines_26 = function $$source_lines() {
        var self = this;

        if ($truthy(self.reader)) {
          return self.reader.$source_lines()
        } else {
          return nil
        }
      }, TMP_Document_source_lines_26.$$arity = 0);
      
      Opal.def(self, '$basebackend?', TMP_Document_basebackend$q_27 = function(base) {
        var self = this;

        return self.attributes['$[]']("basebackend")['$=='](base)
      }, TMP_Document_basebackend$q_27.$$arity = 1);
      
      Opal.def(self, '$title', TMP_Document_title_28 = function $$title() {
        var self = this;

        return self.$doctitle()
      }, TMP_Document_title_28.$$arity = 0);
      
      Opal.def(self, '$title=', TMP_Document_title$eq_29 = function(title) {
        var self = this, sect = nil, $writer = nil;

        
        if ($truthy((sect = self.header))) {
        } else {
          
          $writer = ["header"];
          $send((sect = (self.header = $$($nesting, 'Section').$new(self, 0))), 'sectname=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        
        $writer = [title];
        $send(sect, 'title=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];;
      }, TMP_Document_title$eq_29.$$arity = 1);
      
      Opal.def(self, '$doctitle', TMP_Document_doctitle_30 = function $$doctitle(opts) {
        var $a, self = this, val = nil, sect = nil, separator = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy((val = self.attributes['$[]']("title")))) {
        } else if ($truthy((sect = self.$first_section()))) {
          val = sect.$title()
        } else if ($truthy(($truthy($a = opts['$[]']("use_fallback")) ? (val = self.attributes['$[]']("untitled-label")) : $a)['$!']())) {
          return nil};
        if ($truthy((separator = opts['$[]']("partition")))) {
          return $$($nesting, 'Title').$new(val, opts.$merge($hash2(["separator"], {"separator": (function() {if (separator['$=='](true)) {
            return self.attributes['$[]']("title-separator")
          } else {
            return separator
          }; return nil; })()})))
        } else if ($truthy(($truthy($a = opts['$[]']("sanitize")) ? val['$include?']("<") : $a))) {
          return val.$gsub($$($nesting, 'XmlSanitizeRx'), "").$squeeze(" ").$strip()
        } else {
          return val
        };
      }, TMP_Document_doctitle_30.$$arity = -1);
      Opal.alias(self, "name", "doctitle");
      
      Opal.def(self, '$author', TMP_Document_author_31 = function $$author() {
        var self = this;

        return self.attributes['$[]']("author")
      }, TMP_Document_author_31.$$arity = 0);
      
      Opal.def(self, '$authors', TMP_Document_authors_32 = function $$authors() {
        var $a, self = this, attrs = nil, authors = nil, num_authors = nil, idx = nil;

        if ($truthy((attrs = self.attributes)['$key?']("author"))) {
          
          authors = [$$($nesting, 'Author').$new(attrs['$[]']("author"), attrs['$[]']("firstname"), attrs['$[]']("middlename"), attrs['$[]']("lastname"), attrs['$[]']("authorinitials"), attrs['$[]']("email"))];
          if ($truthy($rb_gt((num_authors = ($truthy($a = attrs['$[]']("authorcount")) ? $a : 0)), 1))) {
            
            idx = 1;
            while ($truthy($rb_lt(idx, num_authors))) {
              
              idx = $rb_plus(idx, 1);
              authors['$<<']($$($nesting, 'Author').$new(attrs['$[]']("" + "author_" + (idx)), attrs['$[]']("" + "firstname_" + (idx)), attrs['$[]']("" + "middlename_" + (idx)), attrs['$[]']("" + "lastname_" + (idx)), attrs['$[]']("" + "authorinitials_" + (idx)), attrs['$[]']("" + "email_" + (idx))));
            };};
          return authors;
        } else {
          return []
        }
      }, TMP_Document_authors_32.$$arity = 0);
      
      Opal.def(self, '$revdate', TMP_Document_revdate_33 = function $$revdate() {
        var self = this;

        return self.attributes['$[]']("revdate")
      }, TMP_Document_revdate_33.$$arity = 0);
      
      Opal.def(self, '$notitle', TMP_Document_notitle_34 = function $$notitle() {
        var $a, self = this;

        return ($truthy($a = self.attributes['$key?']("showtitle")['$!']()) ? self.attributes['$key?']("notitle") : $a)
      }, TMP_Document_notitle_34.$$arity = 0);
      
      Opal.def(self, '$noheader', TMP_Document_noheader_35 = function $$noheader() {
        var self = this;

        return self.attributes['$key?']("noheader")
      }, TMP_Document_noheader_35.$$arity = 0);
      
      Opal.def(self, '$nofooter', TMP_Document_nofooter_36 = function $$nofooter() {
        var self = this;

        return self.attributes['$key?']("nofooter")
      }, TMP_Document_nofooter_36.$$arity = 0);
      
      Opal.def(self, '$first_section', TMP_Document_first_section_37 = function $$first_section() {
        var $a, TMP_38, self = this;

        return ($truthy($a = self.header) ? $a : $send(self.blocks, 'find', [], (TMP_38 = function(e){var self = TMP_38.$$s || this;

        
          
          if (e == null) {
            e = nil;
          };
          return e.$context()['$==']("section");}, TMP_38.$$s = self, TMP_38.$$arity = 1, TMP_38)))
      }, TMP_Document_first_section_37.$$arity = 0);
      
      Opal.def(self, '$has_header?', TMP_Document_has_header$q_39 = function() {
        var self = this;

        if ($truthy(self.header)) {
          return true
        } else {
          return false
        }
      }, TMP_Document_has_header$q_39.$$arity = 0);
      Opal.alias(self, "header?", "has_header?");
      
      Opal.def(self, '$<<', TMP_Document_$lt$lt_40 = function(block) {
        var $iter = TMP_Document_$lt$lt_40.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Document_$lt$lt_40.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        if (block.$context()['$==']("section")) {
          self.$assign_numeral(block)};
        return $send(self, Opal.find_super_dispatcher(self, '<<', TMP_Document_$lt$lt_40, false), $zuper, $iter);
      }, TMP_Document_$lt$lt_40.$$arity = 1);
      
      Opal.def(self, '$finalize_header', TMP_Document_finalize_header_41 = function $$finalize_header(unrooted_attributes, header_valid) {
        var self = this, $writer = nil;

        
        
        if (header_valid == null) {
          header_valid = true;
        };
        self.$clear_playback_attributes(unrooted_attributes);
        self.$save_attributes();
        if ($truthy(header_valid)) {
        } else {
          
          $writer = ["invalid-header", true];
          $send(unrooted_attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        return unrooted_attributes;
      }, TMP_Document_finalize_header_41.$$arity = -2);
      
      Opal.def(self, '$save_attributes', TMP_Document_save_attributes_42 = function $$save_attributes() {
        var $a, $b, TMP_43, self = this, attrs = nil, $writer = nil, val = nil, toc_position_val = nil, toc_val = nil, toc_placement = nil, default_toc_position = nil, default_toc_class = nil, position = nil, $case = nil;

        
        if ((attrs = self.attributes)['$[]']("basebackend")['$==']("docbook")) {
          
          if ($truthy(($truthy($a = self['$attribute_locked?']("toc")) ? $a : self.attributes_modified['$include?']("toc")))) {
          } else {
            
            $writer = ["toc", ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          if ($truthy(($truthy($a = self['$attribute_locked?']("sectnums")) ? $a : self.attributes_modified['$include?']("sectnums")))) {
          } else {
            
            $writer = ["sectnums", ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };};
        if ($truthy(($truthy($a = attrs['$key?']("doctitle")) ? $a : (val = self.$doctitle())['$!']()))) {
        } else {
          
          $writer = ["doctitle", val];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        if ($truthy(self.id)) {
        } else {
          self.id = attrs['$[]']("css-signature")
        };
        toc_position_val = (function() {if ($truthy((toc_val = (function() {if ($truthy(attrs.$delete("toc2"))) {
          return "left"
        } else {
          return attrs['$[]']("toc")
        }; return nil; })()))) {
          if ($truthy(($truthy($a = (toc_placement = attrs.$fetch("toc-placement", "macro"))) ? toc_placement['$!=']("auto") : $a))) {
            return toc_placement
          } else {
            return attrs['$[]']("toc-position")
          }
        } else {
          return nil
        }; return nil; })();
        if ($truthy(($truthy($a = toc_val) ? ($truthy($b = toc_val['$empty?']()['$!']()) ? $b : toc_position_val['$nil_or_empty?']()['$!']()) : $a))) {
          
          default_toc_position = "left";
          default_toc_class = "toc2";
          if ($truthy(toc_position_val['$nil_or_empty?']()['$!']())) {
            position = toc_position_val
          } else if ($truthy(toc_val['$empty?']()['$!']())) {
            position = toc_val
          } else {
            position = default_toc_position
          };
          
          $writer = ["toc", ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["toc-placement", "auto"];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          $case = position;
          if ("left"['$===']($case) || "<"['$===']($case) || "&lt;"['$===']($case)) {
          $writer = ["toc-position", "left"];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];}
          else if ("right"['$===']($case) || ">"['$===']($case) || "&gt;"['$===']($case)) {
          $writer = ["toc-position", "right"];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];}
          else if ("top"['$===']($case) || "^"['$===']($case)) {
          $writer = ["toc-position", "top"];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];}
          else if ("bottom"['$===']($case) || "v"['$===']($case)) {
          $writer = ["toc-position", "bottom"];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];}
          else if ("preamble"['$===']($case) || "macro"['$===']($case)) {
          
          $writer = ["toc-position", "content"];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["toc-placement", position];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          default_toc_class = nil;}
          else {
          attrs.$delete("toc-position");
          default_toc_class = nil;};
          if ($truthy(default_toc_class)) {
            ($truthy($a = attrs['$[]']("toc-class")) ? $a : (($writer = ["toc-class", default_toc_class]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))};};
        if ($truthy((self.compat_mode = attrs['$key?']("compat-mode")))) {
          if ($truthy(attrs['$key?']("language"))) {
            
            $writer = ["source-language", attrs['$[]']("language")];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}};
        self.outfilesuffix = attrs['$[]']("outfilesuffix");
        self.header_attributes = attrs.$dup();
        if ($truthy(self.parent_document)) {
          return nil
        } else {
          return $send($$($nesting, 'FLEXIBLE_ATTRIBUTES'), 'each', [], (TMP_43 = function(name){var self = TMP_43.$$s || this, $c;
            if (self.attribute_overrides == null) self.attribute_overrides = nil;

          
            
            if (name == null) {
              name = nil;
            };
            if ($truthy(($truthy($c = self.attribute_overrides['$key?'](name)) ? self.attribute_overrides['$[]'](name) : $c))) {
              return self.attribute_overrides.$delete(name)
            } else {
              return nil
            };}, TMP_43.$$s = self, TMP_43.$$arity = 1, TMP_43))
        };
      }, TMP_Document_save_attributes_42.$$arity = 0);
      
      Opal.def(self, '$restore_attributes', TMP_Document_restore_attributes_44 = function $$restore_attributes() {
        var self = this;

        
        if ($truthy(self.parent_document)) {
        } else {
          self.catalog['$[]']("callouts").$rewind()
        };
        return self.attributes.$replace(self.header_attributes);
      }, TMP_Document_restore_attributes_44.$$arity = 0);
      
      Opal.def(self, '$clear_playback_attributes', TMP_Document_clear_playback_attributes_45 = function $$clear_playback_attributes(attributes) {
        var self = this;

        return attributes.$delete("attribute_entries")
      }, TMP_Document_clear_playback_attributes_45.$$arity = 1);
      
      Opal.def(self, '$playback_attributes', TMP_Document_playback_attributes_46 = function $$playback_attributes(block_attributes) {
        var TMP_47, self = this;

        if ($truthy(block_attributes['$key?']("attribute_entries"))) {
          return $send(block_attributes['$[]']("attribute_entries"), 'each', [], (TMP_47 = function(entry){var self = TMP_47.$$s || this, name = nil, $writer = nil;
            if (self.attributes == null) self.attributes = nil;

          
            
            if (entry == null) {
              entry = nil;
            };
            name = entry.$name();
            if ($truthy(entry.$negate())) {
              
              self.attributes.$delete(name);
              if (name['$==']("compat-mode")) {
                return (self.compat_mode = false)
              } else {
                return nil
              };
            } else {
              
              
              $writer = [name, entry.$value()];
              $send(self.attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              if (name['$==']("compat-mode")) {
                return (self.compat_mode = true)
              } else {
                return nil
              };
            };}, TMP_47.$$s = self, TMP_47.$$arity = 1, TMP_47))
        } else {
          return nil
        }
      }, TMP_Document_playback_attributes_46.$$arity = 1);
      
      Opal.def(self, '$set_attribute', TMP_Document_set_attribute_48 = function $$set_attribute(name, value) {
        var self = this, resolved_value = nil, $case = nil, $writer = nil;

        
        
        if (value == null) {
          value = "";
        };
        if ($truthy(self['$attribute_locked?'](name))) {
          return false
        } else {
          
          if ($truthy(self.max_attribute_value_size)) {
            resolved_value = self.$apply_attribute_value_subs(value).$limit_bytesize(self.max_attribute_value_size)
          } else {
            resolved_value = self.$apply_attribute_value_subs(value)
          };
          $case = name;
          if ("backend"['$===']($case)) {self.$update_backend_attributes(resolved_value, self.attributes_modified['$delete?']("htmlsyntax"))}
          else if ("doctype"['$===']($case)) {self.$update_doctype_attributes(resolved_value)}
          else {
          $writer = [name, resolved_value];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
          self.attributes_modified['$<<'](name);
          return resolved_value;
        };
      }, TMP_Document_set_attribute_48.$$arity = -2);
      
      Opal.def(self, '$delete_attribute', TMP_Document_delete_attribute_49 = function $$delete_attribute(name) {
        var self = this;

        if ($truthy(self['$attribute_locked?'](name))) {
          return false
        } else {
          
          self.attributes.$delete(name);
          self.attributes_modified['$<<'](name);
          return true;
        }
      }, TMP_Document_delete_attribute_49.$$arity = 1);
      
      Opal.def(self, '$attribute_locked?', TMP_Document_attribute_locked$q_50 = function(name) {
        var self = this;

        return self.attribute_overrides['$key?'](name)
      }, TMP_Document_attribute_locked$q_50.$$arity = 1);
      
      Opal.def(self, '$set_header_attribute', TMP_Document_set_header_attribute_51 = function $$set_header_attribute(name, value, overwrite) {
        var $a, self = this, attrs = nil, $writer = nil;

        
        
        if (value == null) {
          value = "";
        };
        
        if (overwrite == null) {
          overwrite = true;
        };
        attrs = ($truthy($a = self.header_attributes) ? $a : self.attributes);
        if ($truthy((($a = overwrite['$=='](false)) ? attrs['$key?'](name) : overwrite['$=='](false)))) {
          return false
        } else {
          
          
          $writer = [name, value];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return true;
        };
      }, TMP_Document_set_header_attribute_51.$$arity = -2);
      
      Opal.def(self, '$apply_attribute_value_subs', TMP_Document_apply_attribute_value_subs_52 = function $$apply_attribute_value_subs(value) {
        var $a, self = this;

        if ($truthy($$($nesting, 'AttributeEntryPassMacroRx')['$=~'](value))) {
          if ($truthy((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))) {
            
            return self.$apply_subs((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), self.$resolve_pass_subs((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))));
          } else {
            return (($a = $gvars['~']) === nil ? nil : $a['$[]'](2))
          }
        } else {
          return self.$apply_header_subs(value)
        }
      }, TMP_Document_apply_attribute_value_subs_52.$$arity = 1);
      
      Opal.def(self, '$update_backend_attributes', TMP_Document_update_backend_attributes_53 = function $$update_backend_attributes(new_backend, force) {
        var $a, $b, self = this, attrs = nil, current_backend = nil, current_basebackend = nil, current_doctype = nil, $writer = nil, resolved_backend = nil, new_basebackend = nil, new_filetype = nil, new_outfilesuffix = nil, current_filetype = nil, page_width = nil;

        
        
        if (force == null) {
          force = nil;
        };
        if ($truthy(($truthy($a = force) ? $a : ($truthy($b = new_backend) ? new_backend['$!='](self.backend) : $b)))) {
          
          $a = [self.backend, (attrs = self.attributes)['$[]']("basebackend"), self.doctype], (current_backend = $a[0]), (current_basebackend = $a[1]), (current_doctype = $a[2]), $a;
          if ($truthy(new_backend['$start_with?']("xhtml"))) {
            
            
            $writer = ["htmlsyntax", "xml"];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            new_backend = new_backend.$slice(1, new_backend.$length());
          } else if ($truthy(new_backend['$start_with?']("html"))) {
            if (attrs['$[]']("htmlsyntax")['$==']("xml")) {
            } else {
              
              $writer = ["htmlsyntax", "html"];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }};
          if ($truthy((resolved_backend = $$($nesting, 'BACKEND_ALIASES')['$[]'](new_backend)))) {
            new_backend = resolved_backend};
          if ($truthy(current_doctype)) {
            
            if ($truthy(current_backend)) {
              
              attrs.$delete("" + "backend-" + (current_backend));
              attrs.$delete("" + "backend-" + (current_backend) + "-doctype-" + (current_doctype));};
            
            $writer = ["" + "backend-" + (new_backend) + "-doctype-" + (current_doctype), ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["" + "doctype-" + (current_doctype), ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else if ($truthy(current_backend)) {
            attrs.$delete("" + "backend-" + (current_backend))};
          
          $writer = ["" + "backend-" + (new_backend), ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          self.backend = (($writer = ["backend", new_backend]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
          if ($truthy($$$($$($nesting, 'Converter'), 'BackendInfo')['$===']((self.converter = self.$create_converter())))) {
            
            new_basebackend = self.converter.$basebackend();
            if ($truthy(self['$attribute_locked?']("outfilesuffix"))) {
            } else {
              
              $writer = ["outfilesuffix", self.converter.$outfilesuffix()];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            new_filetype = self.converter.$filetype();
          } else if ($truthy(self.converter)) {
            
            new_basebackend = new_backend.$sub($$($nesting, 'TrailingDigitsRx'), "");
            if ($truthy((new_outfilesuffix = $$($nesting, 'DEFAULT_EXTENSIONS')['$[]'](new_basebackend)))) {
              new_filetype = new_outfilesuffix.$slice(1, new_outfilesuffix.$length())
            } else {
              $a = [".html", "html", "html"], (new_outfilesuffix = $a[0]), (new_basebackend = $a[1]), (new_filetype = $a[2]), $a
            };
            if ($truthy(self['$attribute_locked?']("outfilesuffix"))) {
            } else {
              
              $writer = ["outfilesuffix", new_outfilesuffix];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          } else {
            self.$raise($$$('::', 'NotImplementedError'), "" + "asciidoctor: FAILED: missing converter for backend '" + (new_backend) + "'. Processing aborted.")
          };
          if ($truthy((current_filetype = attrs['$[]']("filetype")))) {
            attrs.$delete("" + "filetype-" + (current_filetype))};
          
          $writer = ["filetype", new_filetype];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["" + "filetype-" + (new_filetype), ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy((page_width = $$($nesting, 'DEFAULT_PAGE_WIDTHS')['$[]'](new_basebackend)))) {
            
            $writer = ["pagewidth", page_width];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            attrs.$delete("pagewidth")
          };
          if ($truthy(new_basebackend['$!='](current_basebackend))) {
            
            if ($truthy(current_doctype)) {
              
              if ($truthy(current_basebackend)) {
                
                attrs.$delete("" + "basebackend-" + (current_basebackend));
                attrs.$delete("" + "basebackend-" + (current_basebackend) + "-doctype-" + (current_doctype));};
              
              $writer = ["" + "basebackend-" + (new_basebackend) + "-doctype-" + (current_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
            } else if ($truthy(current_basebackend)) {
              attrs.$delete("" + "basebackend-" + (current_basebackend))};
            
            $writer = ["" + "basebackend-" + (new_basebackend), ""];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["basebackend", new_basebackend];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;};
          return new_backend;
        } else {
          return nil
        };
      }, TMP_Document_update_backend_attributes_53.$$arity = -2);
      
      Opal.def(self, '$update_doctype_attributes', TMP_Document_update_doctype_attributes_54 = function $$update_doctype_attributes(new_doctype) {
        var $a, self = this, attrs = nil, current_backend = nil, current_basebackend = nil, current_doctype = nil, $writer = nil;

        if ($truthy(($truthy($a = new_doctype) ? new_doctype['$!='](self.doctype) : $a))) {
          
          $a = [self.backend, (attrs = self.attributes)['$[]']("basebackend"), self.doctype], (current_backend = $a[0]), (current_basebackend = $a[1]), (current_doctype = $a[2]), $a;
          if ($truthy(current_doctype)) {
            
            attrs.$delete("" + "doctype-" + (current_doctype));
            if ($truthy(current_backend)) {
              
              attrs.$delete("" + "backend-" + (current_backend) + "-doctype-" + (current_doctype));
              
              $writer = ["" + "backend-" + (current_backend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
            if ($truthy(current_basebackend)) {
              
              attrs.$delete("" + "basebackend-" + (current_basebackend) + "-doctype-" + (current_doctype));
              
              $writer = ["" + "basebackend-" + (current_basebackend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
          } else {
            
            if ($truthy(current_backend)) {
              
              $writer = ["" + "backend-" + (current_backend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(current_basebackend)) {
              
              $writer = ["" + "basebackend-" + (current_basebackend) + "-doctype-" + (new_doctype), ""];
              $send(attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
          };
          
          $writer = ["" + "doctype-" + (new_doctype), ""];
          $send(attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          return (self.doctype = (($writer = ["doctype", new_doctype]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        } else {
          return nil
        }
      }, TMP_Document_update_doctype_attributes_54.$$arity = 1);
      
      Opal.def(self, '$create_converter', TMP_Document_create_converter_55 = function $$create_converter() {
        var self = this, converter_opts = nil, $writer = nil, template_dir = nil, template_dirs = nil, converter = nil, converter_factory = nil;

        
        converter_opts = $hash2([], {});
        
        $writer = ["htmlsyntax", self.attributes['$[]']("htmlsyntax")];
        $send(converter_opts, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy((template_dir = self.options['$[]']("template_dir")))) {
          template_dirs = [template_dir]
        } else if ($truthy((template_dirs = self.options['$[]']("template_dirs")))) {
          template_dirs = self.$Array(template_dirs)};
        if ($truthy(template_dirs)) {
          
          
          $writer = ["template_dirs", template_dirs];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["template_cache", self.options.$fetch("template_cache", true)];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["template_engine", self.options['$[]']("template_engine")];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["template_engine_options", self.options['$[]']("template_engine_options")];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["eruby", self.options['$[]']("eruby")];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["safe", self.safe];
          $send(converter_opts, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;};
        if ($truthy((converter = self.options['$[]']("converter")))) {
          converter_factory = $$$($$($nesting, 'Converter'), 'Factory').$new($$$('::', 'Hash')['$[]'](self.$backend(), converter))
        } else {
          converter_factory = $$$($$($nesting, 'Converter'), 'Factory').$default(false)
        };
        return converter_factory.$create(self.$backend(), converter_opts);
      }, TMP_Document_create_converter_55.$$arity = 0);
      
      Opal.def(self, '$convert', TMP_Document_convert_56 = function $$convert(opts) {
        var $a, TMP_57, self = this, $writer = nil, block = nil, output = nil, transform = nil, exts = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(self.timings)) {
          self.timings.$start("convert")};
        if ($truthy(self.parsed)) {
        } else {
          self.$parse()
        };
        if ($truthy(($truthy($a = $rb_ge(self.safe, $$$($$($nesting, 'SafeMode'), 'SERVER'))) ? $a : opts['$empty?']()))) {
        } else {
          
          if ($truthy((($writer = ["outfile", opts['$[]']("outfile")]), $send(self.attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))) {
          } else {
            self.attributes.$delete("outfile")
          };
          if ($truthy((($writer = ["outdir", opts['$[]']("outdir")]), $send(self.attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))) {
          } else {
            self.attributes.$delete("outdir")
          };
        };
        if (self.$doctype()['$==']("inline")) {
          if ($truthy((block = ($truthy($a = self.blocks['$[]'](0)) ? $a : self.header)))) {
            if ($truthy(($truthy($a = block.$content_model()['$==']("compound")) ? $a : block.$content_model()['$==']("empty")))) {
              self.$logger().$warn("no inline candidate; use the inline doctype to convert a single paragragh, verbatim, or raw block")
            } else {
              output = block.$content()
            }}
        } else {
          
          transform = (function() {if ($truthy((function() {if ($truthy(opts['$key?']("header_footer"))) {
            return opts['$[]']("header_footer")
          } else {
            return self.options['$[]']("header_footer")
          }; return nil; })())) {
            return "document"
          } else {
            return "embedded"
          }; return nil; })();
          output = self.converter.$convert(self, transform);
        };
        if ($truthy(self.parent_document)) {
        } else if ($truthy(($truthy($a = (exts = self.extensions)) ? exts['$postprocessors?']() : $a))) {
          $send(exts.$postprocessors(), 'each', [], (TMP_57 = function(ext){var self = TMP_57.$$s || this;

          
            
            if (ext == null) {
              ext = nil;
            };
            return (output = ext.$process_method()['$[]'](self, output));}, TMP_57.$$s = self, TMP_57.$$arity = 1, TMP_57))};
        if ($truthy(self.timings)) {
          self.timings.$record("convert")};
        return output;
      }, TMP_Document_convert_56.$$arity = -1);
      Opal.alias(self, "render", "convert");
      
      Opal.def(self, '$write', TMP_Document_write_58 = function $$write(output, target) {
        var $a, $b, self = this;

        
        if ($truthy(self.timings)) {
          self.timings.$start("write")};
        if ($truthy($$($nesting, 'Writer')['$==='](self.converter))) {
          self.converter.$write(output, target)
        } else {
          
          if ($truthy(target['$respond_to?']("write"))) {
            if ($truthy(output['$nil_or_empty?']())) {
            } else {
              
              target.$write(output.$chomp());
              target.$write($$($nesting, 'LF'));
            }
          } else if ($truthy($$($nesting, 'COERCE_ENCODING'))) {
            $$$('::', 'IO').$write(target, output, $hash2(["encoding"], {"encoding": $$$($$$('::', 'Encoding'), 'UTF_8')}))
          } else {
            $$$('::', 'IO').$write(target, output)
          };
          if ($truthy(($truthy($a = (($b = self.backend['$==']("manpage")) ? $$$('::', 'String')['$==='](target) : self.backend['$==']("manpage"))) ? self.converter['$respond_to?']("write_alternate_pages") : $a))) {
            self.converter.$write_alternate_pages(self.attributes['$[]']("mannames"), self.attributes['$[]']("manvolnum"), target)};
        };
        if ($truthy(self.timings)) {
          self.timings.$record("write")};
        return nil;
      }, TMP_Document_write_58.$$arity = 2);
      
      Opal.def(self, '$content', TMP_Document_content_59 = function $$content() {
        var $iter = TMP_Document_content_59.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Document_content_59.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        self.attributes.$delete("title");
        return $send(self, Opal.find_super_dispatcher(self, 'content', TMP_Document_content_59, false), $zuper, $iter);
      }, TMP_Document_content_59.$$arity = 0);
      
      Opal.def(self, '$docinfo', TMP_Document_docinfo_60 = function $$docinfo(location, suffix) {
        var TMP_61, $a, TMP_62, self = this, content = nil, qualifier = nil, docinfo = nil, docinfo_file = nil, docinfo_dir = nil, docinfo_subs = nil, docinfo_path = nil, shd_content = nil, pvt_content = nil;

        
        
        if (location == null) {
          location = "head";
        };
        
        if (suffix == null) {
          suffix = nil;
        };
        if ($truthy($rb_ge(self.$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')))) {
          return ""
        } else {
          
          content = [];
          if (location['$==']("head")) {
          } else {
            qualifier = "" + "-" + (location)
          };
          if ($truthy(suffix)) {
          } else {
            suffix = self.outfilesuffix
          };
          if ($truthy((docinfo = self.attributes['$[]']("docinfo"))['$nil_or_empty?']())) {
            if ($truthy(self.attributes['$key?']("docinfo2"))) {
              docinfo = ["private", "shared"]
            } else if ($truthy(self.attributes['$key?']("docinfo1"))) {
              docinfo = ["shared"]
            } else {
              docinfo = (function() {if ($truthy(docinfo)) {
                return ["private"]
              } else {
                return nil
              }; return nil; })()
            }
          } else {
            docinfo = $send(docinfo.$split(","), 'map', [], (TMP_61 = function(it){var self = TMP_61.$$s || this;

            
              
              if (it == null) {
                it = nil;
              };
              return it.$strip();}, TMP_61.$$s = self, TMP_61.$$arity = 1, TMP_61))
          };
          if ($truthy(docinfo)) {
            
            $a = ["" + "docinfo" + (qualifier) + (suffix), self.attributes['$[]']("docinfodir"), self.$resolve_docinfo_subs()], (docinfo_file = $a[0]), (docinfo_dir = $a[1]), (docinfo_subs = $a[2]), $a;
            if ($truthy(docinfo['$&'](["shared", "" + "shared-" + (location)])['$empty?']())) {
            } else {
              
              docinfo_path = self.$normalize_system_path(docinfo_file, docinfo_dir);
              if ($truthy((shd_content = self.$read_asset(docinfo_path, $hash2(["normalize"], {"normalize": true}))))) {
                content['$<<'](self.$apply_subs(shd_content, docinfo_subs))};
            };
            if ($truthy(($truthy($a = self.attributes['$[]']("docname")['$nil_or_empty?']()) ? $a : docinfo['$&'](["private", "" + "private-" + (location)])['$empty?']()))) {
            } else {
              
              docinfo_path = self.$normalize_system_path("" + (self.attributes['$[]']("docname")) + "-" + (docinfo_file), docinfo_dir);
              if ($truthy((pvt_content = self.$read_asset(docinfo_path, $hash2(["normalize"], {"normalize": true}))))) {
                content['$<<'](self.$apply_subs(pvt_content, docinfo_subs))};
            };};
          if ($truthy(($truthy($a = self.extensions) ? self['$docinfo_processors?'](location) : $a))) {
            content = $rb_plus(content, $send(self.docinfo_processor_extensions['$[]'](location), 'map', [], (TMP_62 = function(ext){var self = TMP_62.$$s || this;

            
              
              if (ext == null) {
                ext = nil;
              };
              return ext.$process_method()['$[]'](self);}, TMP_62.$$s = self, TMP_62.$$arity = 1, TMP_62)).$compact())};
          return content.$join($$($nesting, 'LF'));
        };
      }, TMP_Document_docinfo_60.$$arity = -1);
      
      Opal.def(self, '$resolve_docinfo_subs', TMP_Document_resolve_docinfo_subs_63 = function $$resolve_docinfo_subs() {
        var self = this;

        if ($truthy(self.attributes['$key?']("docinfosubs"))) {
          
          return self.$resolve_subs(self.attributes['$[]']("docinfosubs"), "block", nil, "docinfo");
        } else {
          return ["attributes"]
        }
      }, TMP_Document_resolve_docinfo_subs_63.$$arity = 0);
      
      Opal.def(self, '$docinfo_processors?', TMP_Document_docinfo_processors$q_64 = function(location) {
        var $a, self = this, $writer = nil;

        
        
        if (location == null) {
          location = "head";
        };
        if ($truthy(self.docinfo_processor_extensions['$key?'](location))) {
          return self.docinfo_processor_extensions['$[]'](location)['$!='](false)
        } else if ($truthy(($truthy($a = self.extensions) ? self.document.$extensions()['$docinfo_processors?'](location) : $a))) {
          return (($writer = [location, self.document.$extensions().$docinfo_processors(location)]), $send(self.docinfo_processor_extensions, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])['$!']()['$!']()
        } else {
          
          $writer = [location, false];
          $send(self.docinfo_processor_extensions, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        };
      }, TMP_Document_docinfo_processors$q_64.$$arity = -1);
      return (Opal.def(self, '$to_s', TMP_Document_to_s_65 = function $$to_s() {
        var self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {doctype: " + (self.$doctype().$inspect()) + ", doctitle: " + ((function() {if ($truthy(self.header['$!='](nil))) {
          return self.header.$title()
        } else {
          return nil
        }; return nil; })().$inspect()) + ", blocks: " + (self.blocks.$size()) + "}>"
      }, TMP_Document_to_s_65.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/inline"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$attr_reader', '$attr_accessor', '$[]', '$dup', '$convert', '$converter', '$attr', '$==', '$apply_reftext_subs', '$reftext']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Inline(){};
      var self = $Inline = $klass($base, $super, 'Inline', $Inline);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Inline_initialize_1, TMP_Inline_block$q_2, TMP_Inline_inline$q_3, TMP_Inline_convert_4, TMP_Inline_alt_5, TMP_Inline_reftext$q_6, TMP_Inline_reftext_7, TMP_Inline_xreftext_8;

      def.text = def.type = nil;
      
      self.$attr_reader("text");
      self.$attr_reader("type");
      self.$attr_accessor("target");
      
      Opal.def(self, '$initialize', TMP_Inline_initialize_1 = function $$initialize(parent, context, text, opts) {
        var $iter = TMP_Inline_initialize_1.$$p, $yield = $iter || nil, self = this, attrs = nil;

        if ($iter) TMP_Inline_initialize_1.$$p = null;
        
        
        if (text == null) {
          text = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Inline_initialize_1, false), [parent, context], null);
        self.node_name = "" + "inline_" + (context);
        self.text = text;
        self.id = opts['$[]']("id");
        self.type = opts['$[]']("type");
        self.target = opts['$[]']("target");
        if ($truthy((attrs = opts['$[]']("attributes")))) {
          return (self.attributes = attrs.$dup())
        } else {
          return nil
        };
      }, TMP_Inline_initialize_1.$$arity = -3);
      
      Opal.def(self, '$block?', TMP_Inline_block$q_2 = function() {
        var self = this;

        return false
      }, TMP_Inline_block$q_2.$$arity = 0);
      
      Opal.def(self, '$inline?', TMP_Inline_inline$q_3 = function() {
        var self = this;

        return true
      }, TMP_Inline_inline$q_3.$$arity = 0);
      
      Opal.def(self, '$convert', TMP_Inline_convert_4 = function $$convert() {
        var self = this;

        return self.$converter().$convert(self)
      }, TMP_Inline_convert_4.$$arity = 0);
      Opal.alias(self, "render", "convert");
      
      Opal.def(self, '$alt', TMP_Inline_alt_5 = function $$alt() {
        var self = this;

        return self.$attr("alt")
      }, TMP_Inline_alt_5.$$arity = 0);
      
      Opal.def(self, '$reftext?', TMP_Inline_reftext$q_6 = function() {
        var $a, $b, self = this;

        return ($truthy($a = self.text) ? ($truthy($b = self.type['$==']("ref")) ? $b : self.type['$==']("bibref")) : $a)
      }, TMP_Inline_reftext$q_6.$$arity = 0);
      
      Opal.def(self, '$reftext', TMP_Inline_reftext_7 = function $$reftext() {
        var self = this, val = nil;

        if ($truthy((val = self.text))) {
          
          return self.$apply_reftext_subs(val);
        } else {
          return nil
        }
      }, TMP_Inline_reftext_7.$$arity = 0);
      return (Opal.def(self, '$xreftext', TMP_Inline_xreftext_8 = function $$xreftext(xrefstyle) {
        var self = this;

        
        
        if (xrefstyle == null) {
          xrefstyle = nil;
        };
        return self.$reftext();
      }, TMP_Inline_xreftext_8.$$arity = -1), nil) && 'xreftext';
    })($nesting[0], $$($nesting, 'AbstractNode'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/list"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$==', '$next_list', '$callouts', '$class', '$object_id', '$inspect', '$size', '$items', '$attr_accessor', '$level', '$drop', '$!', '$nil_or_empty?', '$apply_subs', '$empty?', '$===', '$[]', '$outline?', '$simple?', '$context', '$option?', '$shift', '$blocks', '$unshift', '$lines', '$source', '$parent']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      function $List(){};
      var self = $List = $klass($base, $super, 'List', $List);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_List_initialize_1, TMP_List_outline$q_2, TMP_List_convert_3, TMP_List_to_s_4;

      def.context = def.document = def.style = nil;
      
      Opal.alias(self, "items", "blocks");
      Opal.alias(self, "content", "blocks");
      Opal.alias(self, "items?", "blocks?");
      
      Opal.def(self, '$initialize', TMP_List_initialize_1 = function $$initialize(parent, context, opts) {
        var $iter = TMP_List_initialize_1.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_List_initialize_1.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        return $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_List_initialize_1, false), $zuper, $iter);
      }, TMP_List_initialize_1.$$arity = -3);
      
      Opal.def(self, '$outline?', TMP_List_outline$q_2 = function() {
        var $a, self = this;

        return ($truthy($a = self.context['$==']("ulist")) ? $a : self.context['$==']("olist"))
      }, TMP_List_outline$q_2.$$arity = 0);
      
      Opal.def(self, '$convert', TMP_List_convert_3 = function $$convert() {
        var $iter = TMP_List_convert_3.$$p, $yield = $iter || nil, self = this, result = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_List_convert_3.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        if (self.context['$==']("colist")) {
          
          result = $send(self, Opal.find_super_dispatcher(self, 'convert', TMP_List_convert_3, false), $zuper, $iter);
          self.document.$callouts().$next_list();
          return result;
        } else {
          return $send(self, Opal.find_super_dispatcher(self, 'convert', TMP_List_convert_3, false), $zuper, $iter)
        }
      }, TMP_List_convert_3.$$arity = 0);
      Opal.alias(self, "render", "convert");
      return (Opal.def(self, '$to_s', TMP_List_to_s_4 = function $$to_s() {
        var self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {context: " + (self.context.$inspect()) + ", style: " + (self.style.$inspect()) + ", items: " + (self.$items().$size()) + "}>"
      }, TMP_List_to_s_4.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting);
    (function($base, $super, $parent_nesting) {
      function $ListItem(){};
      var self = $ListItem = $klass($base, $super, 'ListItem', $ListItem);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_ListItem_initialize_5, TMP_ListItem_text$q_6, TMP_ListItem_text_7, TMP_ListItem_text$eq_8, TMP_ListItem_simple$q_9, TMP_ListItem_compound$q_10, TMP_ListItem_fold_first_11, TMP_ListItem_to_s_12;

      def.text = def.subs = def.blocks = nil;
      
      Opal.alias(self, "list", "parent");
      self.$attr_accessor("marker");
      
      Opal.def(self, '$initialize', TMP_ListItem_initialize_5 = function $$initialize(parent, text) {
        var $iter = TMP_ListItem_initialize_5.$$p, $yield = $iter || nil, self = this;

        if ($iter) TMP_ListItem_initialize_5.$$p = null;
        
        
        if (text == null) {
          text = nil;
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_ListItem_initialize_5, false), [parent, "list_item"], null);
        self.text = text;
        self.level = parent.$level();
        return (self.subs = $$($nesting, 'NORMAL_SUBS').$drop(0));
      }, TMP_ListItem_initialize_5.$$arity = -2);
      
      Opal.def(self, '$text?', TMP_ListItem_text$q_6 = function() {
        var self = this;

        return self.text['$nil_or_empty?']()['$!']()
      }, TMP_ListItem_text$q_6.$$arity = 0);
      
      Opal.def(self, '$text', TMP_ListItem_text_7 = function $$text() {
        var $a, self = this;

        return ($truthy($a = self.text) ? self.$apply_subs(self.text, self.subs) : $a)
      }, TMP_ListItem_text_7.$$arity = 0);
      
      Opal.def(self, '$text=', TMP_ListItem_text$eq_8 = function(val) {
        var self = this;

        return (self.text = val)
      }, TMP_ListItem_text$eq_8.$$arity = 1);
      
      Opal.def(self, '$simple?', TMP_ListItem_simple$q_9 = function() {
        var $a, $b, $c, self = this, blk = nil;

        return ($truthy($a = self.blocks['$empty?']()) ? $a : ($truthy($b = (($c = self.blocks.$size()['$=='](1)) ? $$($nesting, 'List')['$===']((blk = self.blocks['$[]'](0))) : self.blocks.$size()['$=='](1))) ? blk['$outline?']() : $b))
      }, TMP_ListItem_simple$q_9.$$arity = 0);
      
      Opal.def(self, '$compound?', TMP_ListItem_compound$q_10 = function() {
        var self = this;

        return self['$simple?']()['$!']()
      }, TMP_ListItem_compound$q_10.$$arity = 0);
      
      Opal.def(self, '$fold_first', TMP_ListItem_fold_first_11 = function $$fold_first(continuation_connects_first_block, content_adjacent) {
        var $a, $b, $c, $d, $e, self = this, first_block = nil, block = nil;

        
        
        if (continuation_connects_first_block == null) {
          continuation_connects_first_block = false;
        };
        
        if (content_adjacent == null) {
          content_adjacent = false;
        };
        if ($truthy(($truthy($a = ($truthy($b = (first_block = self.blocks['$[]'](0))) ? $$($nesting, 'Block')['$==='](first_block) : $b)) ? ($truthy($b = (($c = first_block.$context()['$==']("paragraph")) ? continuation_connects_first_block['$!']() : first_block.$context()['$==']("paragraph"))) ? $b : ($truthy($c = ($truthy($d = ($truthy($e = content_adjacent) ? $e : continuation_connects_first_block['$!']())) ? first_block.$context()['$==']("literal") : $d)) ? first_block['$option?']("listparagraph") : $c)) : $a))) {
          
          block = self.$blocks().$shift();
          if ($truthy(self.text['$nil_or_empty?']())) {
          } else {
            block.$lines().$unshift(self.text)
          };
          self.text = block.$source();};
        return nil;
      }, TMP_ListItem_fold_first_11.$$arity = -1);
      return (Opal.def(self, '$to_s', TMP_ListItem_to_s_12 = function $$to_s() {
        var $a, self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {list_context: " + (self.$parent().$context().$inspect()) + ", text: " + (self.text.$inspect()) + ", blocks: " + (($truthy($a = self.blocks) ? $a : []).$size()) + "}>"
      }, TMP_ListItem_to_s_12.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/parser"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2, $gvars = Opal.gvars;

  Opal.add_stubs(['$include', '$new', '$lambda', '$start_with?', '$match?', '$is_delimited_block?', '$raise', '$parse_document_header', '$[]', '$has_more_lines?', '$next_section', '$assign_numeral', '$<<', '$blocks', '$parse_block_metadata_lines', '$attributes', '$is_next_line_doctitle?', '$finalize_header', '$nil_or_empty?', '$title=', '$-', '$sourcemap', '$cursor', '$parse_section_title', '$id=', '$source_location=', '$header', '$attribute_locked?', '$[]=', '$id', '$parse_header_metadata', '$register', '$==', '$doctype', '$parse_manpage_header', '$=~', '$downcase', '$include?', '$sub_attributes', '$error', '$logger', '$message_with_context', '$cursor_at_line', '$backend', '$skip_blank_lines', '$save', '$update', '$is_next_line_section?', '$initialize_section', '$join', '$map', '$read_lines_until', '$to_proc', '$title', '$split', '$lstrip', '$restore_save', '$discard_save', '$context', '$empty?', '$has_header?', '$delete', '$!', '$!=', '$attr?', '$attr', '$key?', '$document', '$+', '$level', '$special', '$sectname', '$to_i', '$>', '$<', '$warn', '$next_block', '$blocks?', '$style', '$context=', '$style=', '$parent=', '$size', '$content_model', '$shift', '$unwrap_standalone_preamble', '$dup', '$fetch', '$parse_block_metadata_line', '$extensions', '$block_macros?', '$mark', '$read_line', '$terminator', '$to_s', '$masq', '$to_sym', '$registered_for_block?', '$cursor_at_mark', '$strict_verbatim_paragraphs', '$unshift_line', '$markdown_syntax', '$keys', '$chr', '$*', '$length', '$end_with?', '$===', '$parse_attributes', '$attribute_missing', '$clear', '$tr', '$basename', '$assign_caption', '$registered_for_block_macro?', '$config', '$process_method', '$replace', '$parse_callout_list', '$callouts', '$parse_list', '$match', '$parse_description_list', '$underline_style_section_titles', '$is_section_title?', '$peek_line', '$atx_section_title?', '$generate_id', '$level=', '$read_paragraph_lines', '$adjust_indentation!', '$set_option', '$map!', '$slice', '$pop', '$build_block', '$apply_subs', '$chop', '$catalog_inline_anchors', '$rekey', '$index', '$strip', '$parse_table', '$concat', '$each', '$title?', '$lock_in_subs', '$sub?', '$catalog_callouts', '$source', '$remove_sub', '$block_terminates_paragraph', '$<=', '$nil?', '$lines', '$parse_blocks', '$parse_list_item', '$items', '$scan', '$gsub', '$count', '$pre_match', '$advance', '$callout_ids', '$next_list', '$catalog_inline_anchor', '$source_location', '$marker=', '$catalog_inline_biblio_anchor', '$text=', '$resolve_ordered_list_marker', '$read_lines_for_list_item', '$skip_line_comments', '$unshift_lines', '$fold_first', '$text?', '$is_sibling_list_item?', '$find', '$delete_at', '$casecmp', '$sectname=', '$special=', '$numbered=', '$numbered', '$lineno', '$update_attributes', '$peek_lines', '$setext_section_title?', '$abs', '$line_length', '$cursor_at_prev_line', '$process_attribute_entries', '$next_line_empty?', '$process_authors', '$apply_header_subs', '$rstrip', '$each_with_index', '$compact', '$Array', '$squeeze', '$to_a', '$parse_style_attribute', '$process_attribute_entry', '$skip_comment_lines', '$store_attribute', '$sanitize_attribute_name', '$set_attribute', '$save_to', '$delete_attribute', '$ord', '$int_to_roman', '$resolve_list_marker', '$parse_colspecs', '$create_columns', '$format', '$starts_with_delimiter?', '$close_open_cell', '$parse_cellspec', '$delimiter', '$match_delimiter', '$post_match', '$buffer_has_unclosed_quotes?', '$skip_past_delimiter', '$buffer', '$buffer=', '$skip_past_escaped_delimiter', '$keep_cell_open', '$push_cellspec', '$close_cell', '$cell_open?', '$columns', '$assign_column_widths', '$has_header_option=', '$partition_header_footer', '$upto', '$shorthand_property_syntax', '$each_char', '$call', '$sub!', '$gsub!', '$%', '$begin']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Parser(){};
      var self = $Parser = $klass($base, $super, 'Parser', $Parser);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Parser_1, TMP_Parser_2, TMP_Parser_3, TMP_Parser_initialize_4, TMP_Parser_parse_5, TMP_Parser_parse_document_header_6, TMP_Parser_parse_manpage_header_7, TMP_Parser_next_section_9, TMP_Parser_next_block_10, TMP_Parser_read_paragraph_lines_14, TMP_Parser_is_delimited_block$q_15, TMP_Parser_build_block_16, TMP_Parser_parse_blocks_17, TMP_Parser_parse_list_18, TMP_Parser_catalog_callouts_19, TMP_Parser_catalog_inline_anchor_21, TMP_Parser_catalog_inline_anchors_22, TMP_Parser_catalog_inline_biblio_anchor_24, TMP_Parser_parse_description_list_25, TMP_Parser_parse_callout_list_26, TMP_Parser_parse_list_item_27, TMP_Parser_read_lines_for_list_item_28, TMP_Parser_initialize_section_34, TMP_Parser_is_next_line_section$q_35, TMP_Parser_is_next_line_doctitle$q_36, TMP_Parser_is_section_title$q_37, TMP_Parser_atx_section_title$q_38, TMP_Parser_setext_section_title$q_39, TMP_Parser_parse_section_title_40, TMP_Parser_line_length_41, TMP_Parser_line_length_42, TMP_Parser_parse_header_metadata_43, TMP_Parser_process_authors_48, TMP_Parser_parse_block_metadata_lines_54, TMP_Parser_parse_block_metadata_line_55, TMP_Parser_process_attribute_entries_56, TMP_Parser_process_attribute_entry_57, TMP_Parser_store_attribute_58, TMP_Parser_resolve_list_marker_59, TMP_Parser_resolve_ordered_list_marker_60, TMP_Parser_is_sibling_list_item$q_62, TMP_Parser_parse_table_63, TMP_Parser_parse_colspecs_64, TMP_Parser_parse_cellspec_68, TMP_Parser_parse_style_attribute_69, TMP_Parser_adjust_indentation$B_73, TMP_Parser_sanitize_attribute_name_81;

      
      self.$include($$($nesting, 'Logging'));
      Opal.const_set($nesting[0], 'BlockMatchData', $$($nesting, 'Struct').$new("context", "masq", "tip", "terminator"));
      Opal.const_set($nesting[0], 'TabRx', /\t/);
      Opal.const_set($nesting[0], 'TabIndentRx', /^\t+/);
      Opal.const_set($nesting[0], 'StartOfBlockProc', $send(self, 'lambda', [], (TMP_Parser_1 = function(l){var self = TMP_Parser_1.$$s || this, $a, $b;

      
        
        if (l == null) {
          l = nil;
        };
        return ($truthy($a = ($truthy($b = l['$start_with?']("[")) ? $$($nesting, 'BlockAttributeLineRx')['$match?'](l) : $b)) ? $a : self['$is_delimited_block?'](l));}, TMP_Parser_1.$$s = self, TMP_Parser_1.$$arity = 1, TMP_Parser_1)));
      Opal.const_set($nesting[0], 'StartOfListProc', $send(self, 'lambda', [], (TMP_Parser_2 = function(l){var self = TMP_Parser_2.$$s || this;

      
        
        if (l == null) {
          l = nil;
        };
        return $$($nesting, 'AnyListRx')['$match?'](l);}, TMP_Parser_2.$$s = self, TMP_Parser_2.$$arity = 1, TMP_Parser_2)));
      Opal.const_set($nesting[0], 'StartOfBlockOrListProc', $send(self, 'lambda', [], (TMP_Parser_3 = function(l){var self = TMP_Parser_3.$$s || this, $a, $b, $c;

      
        
        if (l == null) {
          l = nil;
        };
        return ($truthy($a = ($truthy($b = self['$is_delimited_block?'](l)) ? $b : ($truthy($c = l['$start_with?']("[")) ? $$($nesting, 'BlockAttributeLineRx')['$match?'](l) : $c))) ? $a : $$($nesting, 'AnyListRx')['$match?'](l));}, TMP_Parser_3.$$s = self, TMP_Parser_3.$$arity = 1, TMP_Parser_3)));
      Opal.const_set($nesting[0], 'NoOp', nil);
      Opal.const_set($nesting[0], 'TableCellHorzAlignments', $hash2(["<", ">", "^"], {"<": "left", ">": "right", "^": "center"}));
      Opal.const_set($nesting[0], 'TableCellVertAlignments', $hash2(["<", ">", "^"], {"<": "top", ">": "bottom", "^": "middle"}));
      Opal.const_set($nesting[0], 'TableCellStyles', $hash2(["d", "s", "e", "m", "h", "l", "v", "a"], {"d": "none", "s": "strong", "e": "emphasis", "m": "monospaced", "h": "header", "l": "literal", "v": "verse", "a": "asciidoc"}));
      
      Opal.def(self, '$initialize', TMP_Parser_initialize_4 = function $$initialize() {
        var self = this;

        return self.$raise("Au contraire, mon frere. No parser instances will be running around.")
      }, TMP_Parser_initialize_4.$$arity = 0);
      Opal.defs(self, '$parse', TMP_Parser_parse_5 = function $$parse(reader, document, options) {
        var $a, $b, $c, self = this, block_attributes = nil, new_section = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        block_attributes = self.$parse_document_header(reader, document);
        if ($truthy(options['$[]']("header_only"))) {
        } else {
          while ($truthy(reader['$has_more_lines?']())) {
            
            $c = self.$next_section(reader, document, block_attributes), $b = Opal.to_ary($c), (new_section = ($b[0] == null ? nil : $b[0])), (block_attributes = ($b[1] == null ? nil : $b[1])), $c;
            if ($truthy(new_section)) {
              
              document.$assign_numeral(new_section);
              document.$blocks()['$<<'](new_section);};
          }
        };
        return document;
      }, TMP_Parser_parse_5.$$arity = -3);
      Opal.defs(self, '$parse_document_header', TMP_Parser_parse_document_header_6 = function $$parse_document_header(reader, document) {
        var $a, $b, self = this, block_attrs = nil, doc_attrs = nil, implicit_doctitle = nil, assigned_doctitle = nil, val = nil, $writer = nil, source_location = nil, _ = nil, doctitle = nil, atx = nil, separator = nil, section_title = nil, doc_id = nil, doc_role = nil, doc_reftext = nil;

        
        block_attrs = self.$parse_block_metadata_lines(reader, document);
        doc_attrs = document.$attributes();
        if ($truthy(($truthy($a = (implicit_doctitle = self['$is_next_line_doctitle?'](reader, block_attrs, doc_attrs['$[]']("leveloffset")))) ? block_attrs['$[]']("title") : $a))) {
          return document.$finalize_header(block_attrs, false)};
        assigned_doctitle = nil;
        if ($truthy((val = doc_attrs['$[]']("doctitle"))['$nil_or_empty?']())) {
        } else {
          
          $writer = [(assigned_doctitle = val)];
          $send(document, 'title=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        if ($truthy(implicit_doctitle)) {
          
          if ($truthy(document.$sourcemap())) {
            source_location = reader.$cursor()};
          $b = self.$parse_section_title(reader, document), $a = Opal.to_ary($b), document['$id='](($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), (doctitle = ($a[2] == null ? nil : $a[2])), (_ = ($a[3] == null ? nil : $a[3])), (atx = ($a[4] == null ? nil : $a[4])), $b;
          if ($truthy(assigned_doctitle)) {
          } else {
            
            $writer = [(assigned_doctitle = doctitle)];
            $send(document, 'title=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          if ($truthy(source_location)) {
            
            $writer = [source_location];
            $send(document.$header(), 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(($truthy($a = atx) ? $a : document['$attribute_locked?']("compat-mode")))) {
          } else {
            
            $writer = ["compat-mode", ""];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          if ($truthy((separator = block_attrs['$[]']("separator")))) {
            if ($truthy(document['$attribute_locked?']("title-separator"))) {
            } else {
              
              $writer = ["title-separator", separator];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }};
          
          $writer = ["doctitle", (section_title = doctitle)];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy((doc_id = block_attrs['$[]']("id")))) {
            
            $writer = [doc_id];
            $send(document, 'id=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else {
            doc_id = document.$id()
          };
          if ($truthy((doc_role = block_attrs['$[]']("role")))) {
            
            $writer = ["docrole", doc_role];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy((doc_reftext = block_attrs['$[]']("reftext")))) {
            
            $writer = ["reftext", doc_reftext];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          block_attrs = $hash2([], {});
          self.$parse_header_metadata(reader, document);
          if ($truthy(doc_id)) {
            document.$register("refs", [doc_id, document])};};
        if ($truthy(($truthy($a = (val = doc_attrs['$[]']("doctitle"))['$nil_or_empty?']()) ? $a : val['$=='](section_title)))) {
        } else {
          
          $writer = [(assigned_doctitle = val)];
          $send(document, 'title=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        };
        if ($truthy(assigned_doctitle)) {
          
          $writer = ["doctitle", assigned_doctitle];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if (document.$doctype()['$==']("manpage")) {
          self.$parse_manpage_header(reader, document, block_attrs)};
        return document.$finalize_header(block_attrs);
      }, TMP_Parser_parse_document_header_6.$$arity = 2);
      Opal.defs(self, '$parse_manpage_header', TMP_Parser_parse_manpage_header_7 = function $$parse_manpage_header(reader, document, block_attributes) {
        var $a, $b, TMP_8, self = this, doc_attrs = nil, $writer = nil, manvolnum = nil, mantitle = nil, manname = nil, name_section_level = nil, name_section = nil, name_section_buffer = nil, mannames = nil, error_msg = nil;

        
        if ($truthy($$($nesting, 'ManpageTitleVolnumRx')['$=~']((doc_attrs = document.$attributes())['$[]']("doctitle")))) {
          
          
          $writer = ["manvolnum", (manvolnum = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)))];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["mantitle", (function() {if ($truthy((mantitle = (($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
            
            return document.$sub_attributes(mantitle);
          } else {
            return mantitle
          }; return nil; })().$downcase()];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        } else {
          
          self.$logger().$error(self.$message_with_context("non-conforming manpage title", $hash2(["source_location"], {"source_location": reader.$cursor_at_line(1)})));
          
          $writer = ["mantitle", ($truthy($a = ($truthy($b = doc_attrs['$[]']("doctitle")) ? $b : doc_attrs['$[]']("docname"))) ? $a : "command")];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["manvolnum", (manvolnum = "1")];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        };
        if ($truthy(($truthy($a = (manname = doc_attrs['$[]']("manname"))) ? doc_attrs['$[]']("manpurpose") : $a))) {
          
          ($truthy($a = doc_attrs['$[]']("manname-title")) ? $a : (($writer = ["manname-title", "Name"]), $send(doc_attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          
          $writer = ["mannames", [manname]];
          $send(doc_attrs, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if (document.$backend()['$==']("manpage")) {
            
            
            $writer = ["docname", manname];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["outfilesuffix", "" + "." + (manvolnum)];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;};
        } else {
          
          reader.$skip_blank_lines();
          reader.$save();
          block_attributes.$update(self.$parse_block_metadata_lines(reader, document));
          if ($truthy((name_section_level = self['$is_next_line_section?'](reader, $hash2([], {}))))) {
            if (name_section_level['$=='](1)) {
              
              name_section = self.$initialize_section(reader, document, $hash2([], {}));
              name_section_buffer = $send(reader.$read_lines_until($hash2(["break_on_blank_lines", "skip_line_comments"], {"break_on_blank_lines": true, "skip_line_comments": true})), 'map', [], "lstrip".$to_proc()).$join(" ");
              if ($truthy($$($nesting, 'ManpageNamePurposeRx')['$=~'](name_section_buffer))) {
                
                ($truthy($a = doc_attrs['$[]']("manname-title")) ? $a : (($writer = ["manname-title", name_section.$title()]), $send(doc_attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
                if ($truthy(name_section.$id())) {
                  
                  $writer = ["manname-id", name_section.$id()];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                
                $writer = ["manpurpose", (($a = $gvars['~']) === nil ? nil : $a['$[]'](2))];
                $send(doc_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                if ($truthy((manname = (($a = $gvars['~']) === nil ? nil : $a['$[]'](1)))['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                  manname = document.$sub_attributes(manname)};
                if ($truthy(manname['$include?'](","))) {
                  manname = (mannames = $send(manname.$split(","), 'map', [], (TMP_8 = function(n){var self = TMP_8.$$s || this;

                  
                    
                    if (n == null) {
                      n = nil;
                    };
                    return n.$lstrip();}, TMP_8.$$s = self, TMP_8.$$arity = 1, TMP_8)))['$[]'](0)
                } else {
                  mannames = [manname]
                };
                
                $writer = ["manname", manname];
                $send(doc_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["mannames", mannames];
                $send(doc_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                if (document.$backend()['$==']("manpage")) {
                  
                  
                  $writer = ["docname", manname];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                  
                  $writer = ["outfilesuffix", "" + "." + (manvolnum)];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;};
              } else {
                error_msg = "non-conforming name section body"
              };
            } else {
              error_msg = "name section must be at level 1"
            }
          } else {
            error_msg = "name section expected"
          };
          if ($truthy(error_msg)) {
            
            reader.$restore_save();
            self.$logger().$error(self.$message_with_context(error_msg, $hash2(["source_location"], {"source_location": reader.$cursor()})));
            
            $writer = ["manname", (manname = ($truthy($a = doc_attrs['$[]']("docname")) ? $a : "command"))];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["mannames", [manname]];
            $send(doc_attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if (document.$backend()['$==']("manpage")) {
              
              
              $writer = ["docname", manname];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              
              $writer = ["outfilesuffix", "" + "." + (manvolnum)];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
          } else {
            reader.$discard_save()
          };
        };
        return nil;
      }, TMP_Parser_parse_manpage_header_7.$$arity = 3);
      Opal.defs(self, '$next_section', TMP_Parser_next_section_9 = function $$next_section(reader, parent, attributes) {
        var $a, $b, $c, $d, self = this, preamble = nil, intro = nil, part = nil, has_header = nil, book = nil, document = nil, $writer = nil, section = nil, current_level = nil, expected_next_level = nil, expected_next_level_alt = nil, title = nil, sectname = nil, next_level = nil, expected_condition = nil, new_section = nil, block_cursor = nil, new_block = nil, first_block = nil, child_block = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        preamble = (intro = (part = false));
        if ($truthy(($truthy($a = (($b = parent.$context()['$==']("document")) ? parent.$blocks()['$empty?']() : parent.$context()['$==']("document"))) ? ($truthy($b = ($truthy($c = (has_header = parent['$has_header?']())) ? $c : attributes.$delete("invalid-header"))) ? $b : self['$is_next_line_section?'](reader, attributes)['$!']()) : $a))) {
          
          book = (document = parent).$doctype()['$==']("book");
          if ($truthy(($truthy($a = has_header) ? $a : ($truthy($b = book) ? attributes['$[]'](1)['$!=']("abstract") : $b)))) {
            
            preamble = (intro = $$($nesting, 'Block').$new(parent, "preamble", $hash2(["content_model"], {"content_model": "compound"})));
            if ($truthy(($truthy($a = book) ? parent['$attr?']("preface-title") : $a))) {
              
              $writer = [parent.$attr("preface-title")];
              $send(preamble, 'title=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            parent.$blocks()['$<<'](preamble);};
          section = parent;
          current_level = 0;
          if ($truthy(parent.$attributes()['$key?']("fragment"))) {
            expected_next_level = -1
          } else if ($truthy(book)) {
            $a = [1, 0], (expected_next_level = $a[0]), (expected_next_level_alt = $a[1]), $a
          } else {
            expected_next_level = 1
          };
        } else {
          
          book = (document = parent.$document()).$doctype()['$==']("book");
          section = self.$initialize_section(reader, parent, attributes);
          attributes = (function() {if ($truthy((title = attributes['$[]']("title")))) {
            return $hash2(["title"], {"title": title})
          } else {
            return $hash2([], {})
          }; return nil; })();
          expected_next_level = $rb_plus((current_level = section.$level()), 1);
          if (current_level['$=='](0)) {
            part = book
          } else if ($truthy((($a = current_level['$=='](1)) ? section.$special() : current_level['$=='](1)))) {
            if ($truthy(($truthy($a = ($truthy($b = (sectname = section.$sectname())['$==']("appendix")) ? $b : sectname['$==']("preface"))) ? $a : sectname['$==']("abstract")))) {
            } else {
              expected_next_level = nil
            }};
        };
        reader.$skip_blank_lines();
        while ($truthy(reader['$has_more_lines?']())) {
          
          self.$parse_block_metadata_lines(reader, document, attributes);
          if ($truthy((next_level = self['$is_next_line_section?'](reader, attributes)))) {
            
            if ($truthy(document['$attr?']("leveloffset"))) {
              next_level = $rb_plus(next_level, document.$attr("leveloffset").$to_i())};
            if ($truthy($rb_gt(next_level, current_level))) {
              
              if ($truthy(expected_next_level)) {
                if ($truthy(($truthy($b = ($truthy($c = next_level['$=='](expected_next_level)) ? $c : ($truthy($d = expected_next_level_alt) ? next_level['$=='](expected_next_level_alt) : $d))) ? $b : $rb_lt(expected_next_level, 0)))) {
                } else {
                  
                  expected_condition = (function() {if ($truthy(expected_next_level_alt)) {
                    return "" + "expected levels " + (expected_next_level_alt) + " or " + (expected_next_level)
                  } else {
                    return "" + "expected level " + (expected_next_level)
                  }; return nil; })();
                  self.$logger().$warn(self.$message_with_context("" + "section title out of sequence: " + (expected_condition) + ", got level " + (next_level), $hash2(["source_location"], {"source_location": reader.$cursor()})));
                }
              } else {
                self.$logger().$error(self.$message_with_context("" + (sectname) + " sections do not support nested sections", $hash2(["source_location"], {"source_location": reader.$cursor()})))
              };
              $c = self.$next_section(reader, section, attributes), $b = Opal.to_ary($c), (new_section = ($b[0] == null ? nil : $b[0])), (attributes = ($b[1] == null ? nil : $b[1])), $c;
              section.$assign_numeral(new_section);
              section.$blocks()['$<<'](new_section);
            } else if ($truthy((($b = next_level['$=='](0)) ? section['$=='](document) : next_level['$=='](0)))) {
              
              if ($truthy(book)) {
              } else {
                self.$logger().$error(self.$message_with_context("level 0 sections can only be used when doctype is book", $hash2(["source_location"], {"source_location": reader.$cursor()})))
              };
              $c = self.$next_section(reader, section, attributes), $b = Opal.to_ary($c), (new_section = ($b[0] == null ? nil : $b[0])), (attributes = ($b[1] == null ? nil : $b[1])), $c;
              section.$assign_numeral(new_section);
              section.$blocks()['$<<'](new_section);
            } else {
              break;
            };
          } else {
            
            block_cursor = reader.$cursor();
            if ($truthy((new_block = self.$next_block(reader, ($truthy($b = intro) ? $b : section), attributes, $hash2(["parse_metadata"], {"parse_metadata": false}))))) {
              
              if ($truthy(part)) {
                if ($truthy(section['$blocks?']()['$!']())) {
                  if ($truthy(new_block.$style()['$!=']("partintro"))) {
                    if (new_block.$context()['$==']("paragraph")) {
                      
                      
                      $writer = ["open"];
                      $send(new_block, 'context=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      
                      $writer = ["partintro"];
                      $send(new_block, 'style=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                    } else {
                      
                      
                      $writer = [(intro = $$($nesting, 'Block').$new(section, "open", $hash2(["content_model"], {"content_model": "compound"})))];
                      $send(new_block, 'parent=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      
                      $writer = ["partintro"];
                      $send(intro, 'style=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      section.$blocks()['$<<'](intro);
                    }}
                } else if (section.$blocks().$size()['$=='](1)) {
                  
                  first_block = section.$blocks()['$[]'](0);
                  if ($truthy(($truthy($b = intro['$!']()) ? first_block.$content_model()['$==']("compound") : $b))) {
                    self.$logger().$error(self.$message_with_context("illegal block content outside of partintro block", $hash2(["source_location"], {"source_location": block_cursor})))
                  } else if ($truthy(first_block.$content_model()['$!=']("compound"))) {
                    
                    
                    $writer = [(intro = $$($nesting, 'Block').$new(section, "open", $hash2(["content_model"], {"content_model": "compound"})))];
                    $send(new_block, 'parent=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                    
                    $writer = ["partintro"];
                    $send(intro, 'style=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                    section.$blocks().$shift();
                    if (first_block.$style()['$==']("partintro")) {
                      
                      
                      $writer = ["paragraph"];
                      $send(first_block, 'context=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;
                      
                      $writer = [nil];
                      $send(first_block, 'style=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];;};
                    intro['$<<'](first_block);
                    section.$blocks()['$<<'](intro);};}};
              ($truthy($b = intro) ? $b : section).$blocks()['$<<'](new_block);
              attributes = $hash2([], {});};
          };
          if ($truthy($b = reader.$skip_blank_lines())) {
            $b
          } else {
            break;
          };
        };
        if ($truthy(part)) {
          if ($truthy(($truthy($a = section['$blocks?']()) ? section.$blocks()['$[]'](-1).$context()['$==']("section") : $a))) {
          } else {
            self.$logger().$error(self.$message_with_context("invalid part, must have at least one section (e.g., chapter, appendix, etc.)", $hash2(["source_location"], {"source_location": reader.$cursor()})))
          }
        } else if ($truthy(preamble)) {
          if ($truthy(preamble['$blocks?']())) {
            if ($truthy(($truthy($a = ($truthy($b = book) ? $b : document.$blocks()['$[]'](1))) ? $a : $$($nesting, 'Compliance').$unwrap_standalone_preamble()['$!']()))) {
            } else {
              
              document.$blocks().$shift();
              while ($truthy((child_block = preamble.$blocks().$shift()))) {
                document['$<<'](child_block)
              };
            }
          } else {
            document.$blocks().$shift()
          }};
        return [(function() {if ($truthy(section['$!='](parent))) {
          return section
        } else {
          return nil
        }; return nil; })(), attributes.$dup()];
      }, TMP_Parser_next_section_9.$$arity = -3);
      Opal.defs(self, '$next_block', TMP_Parser_next_block_10 = function $$next_block(reader, parent, attributes, options) {try {

        var $a, $b, $c, TMP_11, $d, TMP_12, TMP_13, self = this, skipped = nil, text_only = nil, document = nil, extensions = nil, block_extensions = nil, block_macro_extensions = nil, this_line = nil, doc_attrs = nil, style = nil, block = nil, block_context = nil, cloaked_context = nil, terminator = nil, delimited_block = nil, $writer = nil, indented = nil, md_syntax = nil, ch0 = nil, layout_break_chars = nil, ll = nil, blk_ctx = nil, target = nil, blk_attrs = nil, $case = nil, posattrs = nil, scaledwidth = nil, extension = nil, content = nil, default_attrs = nil, match = nil, float_id = nil, float_reftext = nil, float_title = nil, float_level = nil, lines = nil, in_list = nil, admonition_name = nil, credit_line = nil, attribution = nil, citetitle = nil, language = nil, comma_idx = nil, block_cursor = nil, block_reader = nil, content_model = nil, pos_attrs = nil, block_id = nil;
        if ($gvars["~"] == null) $gvars["~"] = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        
        if (options == null) {
          options = $hash2([], {});
        };
        if ($truthy((skipped = reader.$skip_blank_lines()))) {
        } else {
          return nil
        };
        if ($truthy(($truthy($a = (text_only = options['$[]']("text"))) ? $rb_gt(skipped, 0) : $a))) {
          
          options.$delete("text");
          text_only = false;};
        document = parent.$document();
        if ($truthy(options.$fetch("parse_metadata", true))) {
          while ($truthy(self.$parse_block_metadata_line(reader, document, attributes, options))) {
            
            reader.$shift();
            ($truthy($b = reader.$skip_blank_lines()) ? $b : Opal.ret(nil));
          }};
        if ($truthy((extensions = document.$extensions()))) {
          $a = [extensions['$blocks?'](), extensions['$block_macros?']()], (block_extensions = $a[0]), (block_macro_extensions = $a[1]), $a};
        reader.$mark();
        $a = [reader.$read_line(), document.$attributes(), attributes['$[]'](1)], (this_line = $a[0]), (doc_attrs = $a[1]), (style = $a[2]), $a;
        block = (block_context = (cloaked_context = (terminator = nil)));
        if ($truthy((delimited_block = self['$is_delimited_block?'](this_line, true)))) {
          
          block_context = (cloaked_context = delimited_block.$context());
          terminator = delimited_block.$terminator();
          if ($truthy(style['$!']())) {
            style = (($writer = ["style", block_context.$to_s()]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])
          } else if ($truthy(style['$!='](block_context.$to_s()))) {
            if ($truthy(delimited_block.$masq()['$include?'](style))) {
              block_context = style.$to_sym()
            } else if ($truthy(($truthy($a = delimited_block.$masq()['$include?']("admonition")) ? $$($nesting, 'ADMONITION_STYLES')['$include?'](style) : $a))) {
              block_context = "admonition"
            } else if ($truthy(($truthy($a = block_extensions) ? extensions['$registered_for_block?'](style, block_context) : $a))) {
              block_context = style.$to_sym()
            } else {
              
              self.$logger().$warn(self.$message_with_context("" + "invalid style for " + (block_context) + " block: " + (style), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})));
              style = block_context.$to_s();
            }};};
        if ($truthy(delimited_block)) {
        } else {
          while ($truthy(true)) {
            
            if ($truthy(($truthy($b = ($truthy($c = style) ? $$($nesting, 'Compliance').$strict_verbatim_paragraphs() : $c)) ? $$($nesting, 'VERBATIM_STYLES')['$include?'](style) : $b))) {
              
              block_context = style.$to_sym();
              reader.$unshift_line(this_line);
              break;;};
            if ($truthy(text_only)) {
              indented = this_line['$start_with?'](" ", $$($nesting, 'TAB'))
            } else {
              
              md_syntax = $$($nesting, 'Compliance').$markdown_syntax();
              if ($truthy(this_line['$start_with?'](" "))) {
                
                $b = [true, " "], (indented = $b[0]), (ch0 = $b[1]), $b;
                if ($truthy(($truthy($b = ($truthy($c = md_syntax) ? $send(this_line.$lstrip(), 'start_with?', Opal.to_a($$($nesting, 'MARKDOWN_THEMATIC_BREAK_CHARS').$keys())) : $c)) ? $$($nesting, 'MarkdownThematicBreakRx')['$match?'](this_line) : $b))) {
                  
                  block = $$($nesting, 'Block').$new(parent, "thematic_break", $hash2(["content_model"], {"content_model": "empty"}));
                  break;;};
              } else if ($truthy(this_line['$start_with?']($$($nesting, 'TAB')))) {
                $b = [true, $$($nesting, 'TAB')], (indented = $b[0]), (ch0 = $b[1]), $b
              } else {
                
                $b = [false, this_line.$chr()], (indented = $b[0]), (ch0 = $b[1]), $b;
                layout_break_chars = (function() {if ($truthy(md_syntax)) {
                  return $$($nesting, 'HYBRID_LAYOUT_BREAK_CHARS')
                } else {
                  return $$($nesting, 'LAYOUT_BREAK_CHARS')
                }; return nil; })();
                if ($truthy(($truthy($b = layout_break_chars['$key?'](ch0)) ? (function() {if ($truthy(md_syntax)) {
                  
                  return $$($nesting, 'ExtLayoutBreakRx')['$match?'](this_line);
                } else {
                  
                  return (($c = this_line['$==']($rb_times(ch0, (ll = this_line.$length())))) ? $rb_gt(ll, 2) : this_line['$==']($rb_times(ch0, (ll = this_line.$length()))));
                }; return nil; })() : $b))) {
                  
                  block = $$($nesting, 'Block').$new(parent, layout_break_chars['$[]'](ch0), $hash2(["content_model"], {"content_model": "empty"}));
                  break;;
                } else if ($truthy(($truthy($b = this_line['$end_with?']("]")) ? this_line['$include?']("::") : $b))) {
                  if ($truthy(($truthy($b = ($truthy($c = ch0['$==']("i")) ? $c : this_line['$start_with?']("video:", "audio:"))) ? $$($nesting, 'BlockMediaMacroRx')['$=~'](this_line) : $b))) {
                    
                    $b = [(($c = $gvars['~']) === nil ? nil : $c['$[]'](1)).$to_sym(), (($c = $gvars['~']) === nil ? nil : $c['$[]'](2)), (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))], (blk_ctx = $b[0]), (target = $b[1]), (blk_attrs = $b[2]), $b;
                    block = $$($nesting, 'Block').$new(parent, blk_ctx, $hash2(["content_model"], {"content_model": "empty"}));
                    if ($truthy(blk_attrs)) {
                      
                      $case = blk_ctx;
                      if ("video"['$===']($case)) {posattrs = ["poster", "width", "height"]}
                      else if ("audio"['$===']($case)) {posattrs = []}
                      else {posattrs = ["alt", "width", "height"]};
                      block.$parse_attributes(blk_attrs, posattrs, $hash2(["sub_input", "into"], {"sub_input": true, "into": attributes}));};
                    if ($truthy(attributes['$key?']("style"))) {
                      attributes.$delete("style")};
                    if ($truthy(($truthy($b = target['$include?']($$($nesting, 'ATTR_REF_HEAD'))) ? (target = block.$sub_attributes(target, $hash2(["attribute_missing"], {"attribute_missing": "drop-line"})))['$empty?']() : $b))) {
                      if (($truthy($b = doc_attrs['$[]']("attribute-missing")) ? $b : $$($nesting, 'Compliance').$attribute_missing())['$==']("skip")) {
                        return $$($nesting, 'Block').$new(parent, "paragraph", $hash2(["content_model", "source"], {"content_model": "simple", "source": [this_line]}))
                      } else {
                        
                        attributes.$clear();
                        return nil;
                      }};
                    if (blk_ctx['$==']("image")) {
                      
                      document.$register("images", [target, (($writer = ["imagesdir", doc_attrs['$[]']("imagesdir")]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]);
                      ($truthy($b = attributes['$[]']("alt")) ? $b : (($writer = ["alt", ($truthy($c = style) ? $c : (($writer = ["default-alt", $$($nesting, 'Helpers').$basename(target, true).$tr("_-", " ")]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
                      if ($truthy((scaledwidth = attributes.$delete("scaledwidth"))['$nil_or_empty?']())) {
                      } else {
                        
                        $writer = ["scaledwidth", (function() {if ($truthy($$($nesting, 'TrailingDigitsRx')['$match?'](scaledwidth))) {
                          return "" + (scaledwidth) + "%"
                        } else {
                          return scaledwidth
                        }; return nil; })()];
                        $send(attributes, '[]=', Opal.to_a($writer));
                        $writer[$rb_minus($writer["length"], 1)];
                      };
                      if ($truthy(attributes['$key?']("title"))) {
                        
                        
                        $writer = [attributes.$delete("title")];
                        $send(block, 'title=', Opal.to_a($writer));
                        $writer[$rb_minus($writer["length"], 1)];;
                        block.$assign_caption(attributes.$delete("caption"), "figure");};};
                    
                    $writer = ["target", target];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];;
                    break;;
                  } else if ($truthy(($truthy($b = (($c = ch0['$==']("t")) ? this_line['$start_with?']("toc:") : ch0['$==']("t"))) ? $$($nesting, 'BlockTocMacroRx')['$=~'](this_line) : $b))) {
                    
                    block = $$($nesting, 'Block').$new(parent, "toc", $hash2(["content_model"], {"content_model": "empty"}));
                    if ($truthy((($b = $gvars['~']) === nil ? nil : $b['$[]'](1)))) {
                      block.$parse_attributes((($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), [], $hash2(["into"], {"into": attributes}))};
                    break;;
                  } else if ($truthy(($truthy($b = ($truthy($c = block_macro_extensions) ? $$($nesting, 'CustomBlockMacroRx')['$=~'](this_line) : $c)) ? (extension = extensions['$registered_for_block_macro?']((($c = $gvars['~']) === nil ? nil : $c['$[]'](1)))) : $b))) {
                    
                    $b = [(($c = $gvars['~']) === nil ? nil : $c['$[]'](2)), (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))], (target = $b[0]), (content = $b[1]), $b;
                    if ($truthy(($truthy($b = ($truthy($c = target['$include?']($$($nesting, 'ATTR_REF_HEAD'))) ? (target = parent.$sub_attributes(target))['$empty?']() : $c)) ? ($truthy($c = doc_attrs['$[]']("attribute-missing")) ? $c : $$($nesting, 'Compliance').$attribute_missing())['$==']("drop-line") : $b))) {
                      
                      attributes.$clear();
                      return nil;};
                    if (extension.$config()['$[]']("content_model")['$==']("attributes")) {
                      if ($truthy(content)) {
                        document.$parse_attributes(content, ($truthy($b = extension.$config()['$[]']("pos_attrs")) ? $b : []), $hash2(["sub_input", "into"], {"sub_input": true, "into": attributes}))}
                    } else {
                      
                      $writer = ["text", ($truthy($b = content) ? $b : "")];
                      $send(attributes, '[]=', Opal.to_a($writer));
                      $writer[$rb_minus($writer["length"], 1)];
                    };
                    if ($truthy((default_attrs = extension.$config()['$[]']("default_attrs")))) {
                      $send(attributes, 'update', [default_attrs], (TMP_11 = function(_, old_v){var self = TMP_11.$$s || this;

                      
                        
                        if (_ == null) {
                          _ = nil;
                        };
                        
                        if (old_v == null) {
                          old_v = nil;
                        };
                        return old_v;}, TMP_11.$$s = self, TMP_11.$$arity = 2, TMP_11))};
                    if ($truthy((block = extension.$process_method()['$[]'](parent, target, attributes)))) {
                      
                      attributes.$replace(block.$attributes());
                      break;;
                    } else {
                      
                      attributes.$clear();
                      return nil;
                    };}};
              };
            };
            if ($truthy(($truthy($b = ($truthy($c = indented['$!']()) ? (ch0 = ($truthy($d = ch0) ? $d : this_line.$chr()))['$==']("<") : $c)) ? $$($nesting, 'CalloutListRx')['$=~'](this_line) : $b))) {
              
              reader.$unshift_line(this_line);
              block = self.$parse_callout_list(reader, $gvars["~"], parent, document.$callouts());
              
              $writer = ["style", "arabic"];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              break;;
            } else if ($truthy($$($nesting, 'UnorderedListRx')['$match?'](this_line))) {
              
              reader.$unshift_line(this_line);
              if ($truthy(($truthy($b = ($truthy($c = style['$!']()) ? $$($nesting, 'Section')['$==='](parent) : $c)) ? parent.$sectname()['$==']("bibliography") : $b))) {
                
                $writer = ["style", (style = "bibliography")];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              block = self.$parse_list(reader, "ulist", parent, style);
              break;;
            } else if ($truthy((match = $$($nesting, 'OrderedListRx').$match(this_line)))) {
              
              reader.$unshift_line(this_line);
              block = self.$parse_list(reader, "olist", parent, style);
              if ($truthy(block.$style())) {
                
                $writer = ["style", block.$style()];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              break;;
            } else if ($truthy((match = $$($nesting, 'DescriptionListRx').$match(this_line)))) {
              
              reader.$unshift_line(this_line);
              block = self.$parse_description_list(reader, match, parent);
              break;;
            } else if ($truthy(($truthy($b = ($truthy($c = style['$==']("float")) ? $c : style['$==']("discrete"))) ? (function() {if ($truthy($$($nesting, 'Compliance').$underline_style_section_titles())) {
              
              return self['$is_section_title?'](this_line, reader.$peek_line());
            } else {
              return ($truthy($c = indented['$!']()) ? self['$atx_section_title?'](this_line) : $c)
            }; return nil; })() : $b))) {
              
              reader.$unshift_line(this_line);
              $c = self.$parse_section_title(reader, document, attributes['$[]']("id")), $b = Opal.to_ary($c), (float_id = ($b[0] == null ? nil : $b[0])), (float_reftext = ($b[1] == null ? nil : $b[1])), (float_title = ($b[2] == null ? nil : $b[2])), (float_level = ($b[3] == null ? nil : $b[3])), $c;
              if ($truthy(float_reftext)) {
                
                $writer = ["reftext", float_reftext];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              block = $$($nesting, 'Block').$new(parent, "floating_title", $hash2(["content_model"], {"content_model": "empty"}));
              
              $writer = [float_title];
              $send(block, 'title=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              attributes.$delete("title");
              
              $writer = [($truthy($b = float_id) ? $b : (function() {if ($truthy(doc_attrs['$key?']("sectids"))) {
                
                return $$($nesting, 'Section').$generate_id(block.$title(), document);
              } else {
                return nil
              }; return nil; })())];
              $send(block, 'id=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              
              $writer = [float_level];
              $send(block, 'level=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              break;;
            } else if ($truthy(($truthy($b = style) ? style['$!=']("normal") : $b))) {
              if ($truthy($$($nesting, 'PARAGRAPH_STYLES')['$include?'](style))) {
                
                block_context = style.$to_sym();
                cloaked_context = "paragraph";
                reader.$unshift_line(this_line);
                break;;
              } else if ($truthy($$($nesting, 'ADMONITION_STYLES')['$include?'](style))) {
                
                block_context = "admonition";
                cloaked_context = "paragraph";
                reader.$unshift_line(this_line);
                break;;
              } else if ($truthy(($truthy($b = block_extensions) ? extensions['$registered_for_block?'](style, "paragraph") : $b))) {
                
                block_context = style.$to_sym();
                cloaked_context = "paragraph";
                reader.$unshift_line(this_line);
                break;;
              } else {
                
                self.$logger().$warn(self.$message_with_context("" + "invalid style for paragraph: " + (style), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})));
                style = nil;
              }};
            reader.$unshift_line(this_line);
            if ($truthy(($truthy($b = indented) ? style['$!']() : $b))) {
              
              lines = self.$read_paragraph_lines(reader, ($truthy($b = (in_list = $$($nesting, 'ListItem')['$==='](parent))) ? skipped['$=='](0) : $b), $hash2(["skip_line_comments"], {"skip_line_comments": text_only}));
              self['$adjust_indentation!'](lines);
              block = $$($nesting, 'Block').$new(parent, "literal", $hash2(["content_model", "source", "attributes"], {"content_model": "verbatim", "source": lines, "attributes": attributes}));
              if ($truthy(in_list)) {
                block.$set_option("listparagraph")};
            } else {
              
              lines = self.$read_paragraph_lines(reader, (($b = skipped['$=='](0)) ? $$($nesting, 'ListItem')['$==='](parent) : skipped['$=='](0)), $hash2(["skip_line_comments"], {"skip_line_comments": true}));
              if ($truthy(text_only)) {
                
                if ($truthy(($truthy($b = indented) ? style['$==']("normal") : $b))) {
                  self['$adjust_indentation!'](lines)};
                block = $$($nesting, 'Block').$new(parent, "paragraph", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
              } else if ($truthy(($truthy($b = ($truthy($c = $$($nesting, 'ADMONITION_STYLE_HEADS')['$include?'](ch0)) ? this_line['$include?'](":") : $c)) ? $$($nesting, 'AdmonitionParagraphRx')['$=~'](this_line) : $b))) {
                
                
                $writer = [0, (($b = $gvars['~']) === nil ? nil : $b.$post_match())];
                $send(lines, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["name", (admonition_name = (($writer = ["style", (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]).$downcase())];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["textlabel", ($truthy($b = attributes.$delete("caption")) ? $b : doc_attrs['$[]']("" + (admonition_name) + "-caption"))];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                block = $$($nesting, 'Block').$new(parent, "admonition", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
              } else if ($truthy(($truthy($b = ($truthy($c = md_syntax) ? ch0['$=='](">") : $c)) ? this_line['$start_with?']("> ") : $b))) {
                
                $send(lines, 'map!', [], (TMP_12 = function(line){var self = TMP_12.$$s || this;

                
                  
                  if (line == null) {
                    line = nil;
                  };
                  if (line['$=='](">")) {
                    
                    return line.$slice(1, line.$length());
                  } else {
                    
                    if ($truthy(line['$start_with?']("> "))) {
                      
                      return line.$slice(2, line.$length());
                    } else {
                      return line
                    };
                  };}, TMP_12.$$s = self, TMP_12.$$arity = 1, TMP_12));
                if ($truthy(lines['$[]'](-1)['$start_with?']("-- "))) {
                  
                  credit_line = (credit_line = lines.$pop()).$slice(3, credit_line.$length());
                  while ($truthy(lines['$[]'](-1)['$empty?']())) {
                    lines.$pop()
                  };};
                
                $writer = ["style", "quote"];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                block = self.$build_block("quote", "compound", false, parent, $$($nesting, 'Reader').$new(lines), attributes);
                if ($truthy(credit_line)) {
                  
                  $c = block.$apply_subs(credit_line).$split(", ", 2), $b = Opal.to_ary($c), (attribution = ($b[0] == null ? nil : $b[0])), (citetitle = ($b[1] == null ? nil : $b[1])), $c;
                  if ($truthy(attribution)) {
                    
                    $writer = ["attribution", attribution];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];};
                  if ($truthy(citetitle)) {
                    
                    $writer = ["citetitle", citetitle];
                    $send(attributes, '[]=', Opal.to_a($writer));
                    $writer[$rb_minus($writer["length"], 1)];};};
              } else if ($truthy(($truthy($b = ($truthy($c = (($d = ch0['$==']("\"")) ? $rb_gt(lines.$size(), 1) : ch0['$==']("\""))) ? lines['$[]'](-1)['$start_with?']("-- ") : $c)) ? lines['$[]'](-2)['$end_with?']("\"") : $b))) {
                
                
                $writer = [0, this_line.$slice(1, this_line.$length())];
                $send(lines, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                credit_line = (credit_line = lines.$pop()).$slice(3, credit_line.$length());
                while ($truthy(lines['$[]'](-1)['$empty?']())) {
                  lines.$pop()
                };
                lines['$<<'](lines.$pop().$chop());
                
                $writer = ["style", "quote"];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                block = $$($nesting, 'Block').$new(parent, "quote", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
                $c = block.$apply_subs(credit_line).$split(", ", 2), $b = Opal.to_ary($c), (attribution = ($b[0] == null ? nil : $b[0])), (citetitle = ($b[1] == null ? nil : $b[1])), $c;
                if ($truthy(attribution)) {
                  
                  $writer = ["attribution", attribution];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                if ($truthy(citetitle)) {
                  
                  $writer = ["citetitle", citetitle];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
              } else {
                
                if ($truthy(($truthy($b = indented) ? style['$==']("normal") : $b))) {
                  self['$adjust_indentation!'](lines)};
                block = $$($nesting, 'Block').$new(parent, "paragraph", $hash2(["content_model", "source", "attributes"], {"content_model": "simple", "source": lines, "attributes": attributes}));
              };
              self.$catalog_inline_anchors(lines.$join($$($nesting, 'LF')), block, document, reader);
            };
            break;;
          }
        };
        if ($truthy(block)) {
        } else {
          
          if ($truthy(($truthy($a = block_context['$==']("abstract")) ? $a : block_context['$==']("partintro")))) {
            block_context = "open"};
          $case = block_context;
          if ("admonition"['$===']($case)) {
          
          $writer = ["name", (admonition_name = style.$downcase())];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["textlabel", ($truthy($a = attributes.$delete("caption")) ? $a : doc_attrs['$[]']("" + (admonition_name) + "-caption"))];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          block = self.$build_block(block_context, "compound", terminator, parent, reader, attributes);}
          else if ("comment"['$===']($case)) {
          self.$build_block(block_context, "skip", terminator, parent, reader, attributes);
          attributes.$clear();
          return nil;}
          else if ("example"['$===']($case)) {block = self.$build_block(block_context, "compound", terminator, parent, reader, attributes)}
          else if ("listing"['$===']($case) || "literal"['$===']($case)) {block = self.$build_block(block_context, "verbatim", terminator, parent, reader, attributes)}
          else if ("source"['$===']($case)) {
          $$($nesting, 'AttributeList').$rekey(attributes, [nil, "language", "linenums"]);
          if ($truthy(attributes['$key?']("language"))) {
          } else if ($truthy(doc_attrs['$key?']("source-language"))) {
            
            $writer = ["language", ($truthy($a = doc_attrs['$[]']("source-language")) ? $a : "text")];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(attributes['$key?']("linenums"))) {
          } else if ($truthy(($truthy($a = attributes['$key?']("linenums-option")) ? $a : doc_attrs['$key?']("source-linenums-option")))) {
            
            $writer = ["linenums", ""];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(attributes['$key?']("indent"))) {
          } else if ($truthy(doc_attrs['$key?']("source-indent"))) {
            
            $writer = ["indent", doc_attrs['$[]']("source-indent")];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          block = self.$build_block("listing", "verbatim", terminator, parent, reader, attributes);}
          else if ("fenced_code"['$===']($case)) {
          
          $writer = ["style", "source"];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ((ll = this_line.$length())['$=='](3)) {
            language = nil
          } else if ($truthy((comma_idx = (language = this_line.$slice(3, ll)).$index(",")))) {
            if ($truthy($rb_gt(comma_idx, 0))) {
              
              language = language.$slice(0, comma_idx).$strip();
              if ($truthy($rb_lt(comma_idx, $rb_minus(ll, 4)))) {
                
                $writer = ["linenums", ""];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
            } else {
              
              language = nil;
              if ($truthy($rb_gt(ll, 4))) {
                
                $writer = ["linenums", ""];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
            }
          } else {
            language = language.$lstrip()
          };
          if ($truthy(language['$nil_or_empty?']())) {
            if ($truthy(doc_attrs['$key?']("source-language"))) {
              
              $writer = ["language", ($truthy($a = doc_attrs['$[]']("source-language")) ? $a : "text")];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];}
          } else {
            
            $writer = ["language", language];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          if ($truthy(attributes['$key?']("linenums"))) {
          } else if ($truthy(($truthy($a = attributes['$key?']("linenums-option")) ? $a : doc_attrs['$key?']("source-linenums-option")))) {
            
            $writer = ["linenums", ""];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(attributes['$key?']("indent"))) {
          } else if ($truthy(doc_attrs['$key?']("source-indent"))) {
            
            $writer = ["indent", doc_attrs['$[]']("source-indent")];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          terminator = terminator.$slice(0, 3);
          block = self.$build_block("listing", "verbatim", terminator, parent, reader, attributes);}
          else if ("pass"['$===']($case)) {block = self.$build_block(block_context, "raw", terminator, parent, reader, attributes)}
          else if ("stem"['$===']($case) || "latexmath"['$===']($case) || "asciimath"['$===']($case)) {
          if (block_context['$==']("stem")) {
            
            $writer = ["style", $$($nesting, 'STEM_TYPE_ALIASES')['$[]'](($truthy($a = attributes['$[]'](2)) ? $a : doc_attrs['$[]']("stem")))];
            $send(attributes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          block = self.$build_block("stem", "raw", terminator, parent, reader, attributes);}
          else if ("open"['$===']($case) || "sidebar"['$===']($case)) {block = self.$build_block(block_context, "compound", terminator, parent, reader, attributes)}
          else if ("table"['$===']($case)) {
          block_cursor = reader.$cursor();
          block_reader = $$($nesting, 'Reader').$new(reader.$read_lines_until($hash2(["terminator", "skip_line_comments", "context", "cursor"], {"terminator": terminator, "skip_line_comments": true, "context": "table", "cursor": "at_mark"})), block_cursor);
          if ($truthy(terminator['$start_with?']("|", "!"))) {
          } else {
            ($truthy($a = attributes['$[]']("format")) ? $a : (($writer = ["format", (function() {if ($truthy(terminator['$start_with?'](","))) {
              return "csv"
            } else {
              return "dsv"
            }; return nil; })()]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
          };
          block = self.$parse_table(block_reader, parent, attributes);}
          else if ("quote"['$===']($case) || "verse"['$===']($case)) {
          $$($nesting, 'AttributeList').$rekey(attributes, [nil, "attribution", "citetitle"]);
          block = self.$build_block(block_context, (function() {if (block_context['$==']("verse")) {
            return "verbatim"
          } else {
            return "compound"
          }; return nil; })(), terminator, parent, reader, attributes);}
          else {if ($truthy(($truthy($a = block_extensions) ? (extension = extensions['$registered_for_block?'](block_context, cloaked_context)) : $a))) {
            
            if ($truthy((content_model = extension.$config()['$[]']("content_model"))['$!=']("skip"))) {
              
              if ($truthy((pos_attrs = ($truthy($a = extension.$config()['$[]']("pos_attrs")) ? $a : []))['$empty?']()['$!']())) {
                $$($nesting, 'AttributeList').$rekey(attributes, [nil].$concat(pos_attrs))};
              if ($truthy((default_attrs = extension.$config()['$[]']("default_attrs")))) {
                $send(default_attrs, 'each', [], (TMP_13 = function(k, v){var self = TMP_13.$$s || this, $e;

                
                  
                  if (k == null) {
                    k = nil;
                  };
                  
                  if (v == null) {
                    v = nil;
                  };
                  return ($truthy($e = attributes['$[]'](k)) ? $e : (($writer = [k, v]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));}, TMP_13.$$s = self, TMP_13.$$arity = 2, TMP_13))};
              
              $writer = ["cloaked-context", cloaked_context];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
            block = self.$build_block(block_context, content_model, terminator, parent, reader, attributes, $hash2(["extension"], {"extension": extension}));
            if ($truthy(block)) {
            } else {
              
              attributes.$clear();
              return nil;
            };
          } else {
            self.$raise("" + "Unsupported block type " + (block_context) + " at " + (reader.$cursor()))
          }};
        };
        if ($truthy(document.$sourcemap())) {
          
          $writer = [reader.$cursor_at_mark()];
          $send(block, 'source_location=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(attributes['$key?']("title"))) {
          
          $writer = [attributes.$delete("title")];
          $send(block, 'title=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        
        $writer = [attributes['$[]']("style")];
        $send(block, 'style=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy((block_id = ($truthy($a = block.$id()) ? $a : (($writer = [attributes['$[]']("id")]), $send(block, 'id=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))))) {
          if ($truthy(document.$register("refs", [block_id, block, ($truthy($a = attributes['$[]']("reftext")) ? $a : (function() {if ($truthy(block['$title?']())) {
            return block.$title()
          } else {
            return nil
          }; return nil; })())]))) {
          } else {
            self.$logger().$warn(self.$message_with_context("" + "id assigned to block already in use: " + (block_id), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))
          }};
        if ($truthy(attributes['$empty?']())) {
        } else {
          block.$attributes().$update(attributes)
        };
        block.$lock_in_subs();
        if ($truthy(block['$sub?']("callouts"))) {
          if ($truthy(self.$catalog_callouts(block.$source(), document))) {
          } else {
            block.$remove_sub("callouts")
          }};
        return block;
        } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
      }, TMP_Parser_next_block_10.$$arity = -3);
      Opal.defs(self, '$read_paragraph_lines', TMP_Parser_read_paragraph_lines_14 = function $$read_paragraph_lines(reader, break_at_list, opts) {
        var self = this, $writer = nil, break_condition = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        
        $writer = ["break_on_blank_lines", true];
        $send(opts, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["break_on_list_continuation", true];
        $send(opts, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        
        $writer = ["preserve_last_line", true];
        $send(opts, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        break_condition = (function() {if ($truthy(break_at_list)) {
          
          if ($truthy($$($nesting, 'Compliance').$block_terminates_paragraph())) {
            return $$($nesting, 'StartOfBlockOrListProc')
          } else {
            return $$($nesting, 'StartOfListProc')
          };
        } else {
          
          if ($truthy($$($nesting, 'Compliance').$block_terminates_paragraph())) {
            return $$($nesting, 'StartOfBlockProc')
          } else {
            return $$($nesting, 'NoOp')
          };
        }; return nil; })();
        return $send(reader, 'read_lines_until', [opts], break_condition.$to_proc());
      }, TMP_Parser_read_paragraph_lines_14.$$arity = -3);
      Opal.defs(self, '$is_delimited_block?', TMP_Parser_is_delimited_block$q_15 = function(line, return_match_data) {
        var $a, $b, self = this, line_len = nil, tip = nil, tl = nil, fenced_code = nil, tip_3 = nil, context = nil, masq = nil;

        
        
        if (return_match_data == null) {
          return_match_data = false;
        };
        if ($truthy(($truthy($a = $rb_gt((line_len = line.$length()), 1)) ? $$($nesting, 'DELIMITED_BLOCK_HEADS')['$include?'](line.$slice(0, 2)) : $a))) {
        } else {
          return nil
        };
        if (line_len['$=='](2)) {
          
          tip = line;
          tl = 2;
        } else {
          
          if ($truthy($rb_le(line_len, 4))) {
            
            tip = line;
            tl = line_len;
          } else {
            
            tip = line.$slice(0, 4);
            tl = 4;
          };
          fenced_code = false;
          if ($truthy($$($nesting, 'Compliance').$markdown_syntax())) {
            
            tip_3 = (function() {if (tl['$=='](4)) {
              return tip.$chop()
            } else {
              return tip
            }; return nil; })();
            if (tip_3['$==']("```")) {
              
              if ($truthy((($a = tl['$=='](4)) ? tip['$end_with?']("`") : tl['$=='](4)))) {
                return nil};
              tip = tip_3;
              tl = 3;
              fenced_code = true;};};
          if ($truthy((($a = tl['$=='](3)) ? fenced_code['$!']() : tl['$=='](3)))) {
            return nil};
        };
        if ($truthy($$($nesting, 'DELIMITED_BLOCKS')['$key?'](tip))) {
          if ($truthy(($truthy($a = $rb_lt(tl, 4)) ? $a : tl['$=='](line_len)))) {
            if ($truthy(return_match_data)) {
              
              $b = $$($nesting, 'DELIMITED_BLOCKS')['$[]'](tip), $a = Opal.to_ary($b), (context = ($a[0] == null ? nil : $a[0])), (masq = ($a[1] == null ? nil : $a[1])), $b;
              return $$($nesting, 'BlockMatchData').$new(context, masq, tip, tip);
            } else {
              return true
            }
          } else if ((("" + (tip)) + ($rb_times(tip.$slice(-1, 1), $rb_minus(line_len, tl))))['$=='](line)) {
            if ($truthy(return_match_data)) {
              
              $b = $$($nesting, 'DELIMITED_BLOCKS')['$[]'](tip), $a = Opal.to_ary($b), (context = ($a[0] == null ? nil : $a[0])), (masq = ($a[1] == null ? nil : $a[1])), $b;
              return $$($nesting, 'BlockMatchData').$new(context, masq, tip, line);
            } else {
              return true
            }
          } else {
            return nil
          }
        } else {
          return nil
        };
      }, TMP_Parser_is_delimited_block$q_15.$$arity = -2);
      Opal.defs(self, '$build_block', TMP_Parser_build_block_16 = function $$build_block(block_context, content_model, terminator, parent, reader, attributes, options) {
        var $a, $b, self = this, skip_processing = nil, parse_as_content_model = nil, lines = nil, block_reader = nil, block_cursor = nil, indent = nil, tab_size = nil, extension = nil, block = nil, $writer = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        if (content_model['$==']("skip")) {
          $a = [true, "simple"], (skip_processing = $a[0]), (parse_as_content_model = $a[1]), $a
        } else if (content_model['$==']("raw")) {
          $a = [false, "simple"], (skip_processing = $a[0]), (parse_as_content_model = $a[1]), $a
        } else {
          $a = [false, content_model], (skip_processing = $a[0]), (parse_as_content_model = $a[1]), $a
        };
        if ($truthy(terminator['$nil?']())) {
          
          if (parse_as_content_model['$==']("verbatim")) {
            lines = reader.$read_lines_until($hash2(["break_on_blank_lines", "break_on_list_continuation"], {"break_on_blank_lines": true, "break_on_list_continuation": true}))
          } else {
            
            if (content_model['$==']("compound")) {
              content_model = "simple"};
            lines = self.$read_paragraph_lines(reader, false, $hash2(["skip_line_comments", "skip_processing"], {"skip_line_comments": true, "skip_processing": skip_processing}));
          };
          block_reader = nil;
        } else if ($truthy(parse_as_content_model['$!=']("compound"))) {
          
          lines = reader.$read_lines_until($hash2(["terminator", "skip_processing", "context", "cursor"], {"terminator": terminator, "skip_processing": skip_processing, "context": block_context, "cursor": "at_mark"}));
          block_reader = nil;
        } else if (terminator['$=='](false)) {
          
          lines = nil;
          block_reader = reader;
        } else {
          
          lines = nil;
          block_cursor = reader.$cursor();
          block_reader = $$($nesting, 'Reader').$new(reader.$read_lines_until($hash2(["terminator", "skip_processing", "context", "cursor"], {"terminator": terminator, "skip_processing": skip_processing, "context": block_context, "cursor": "at_mark"})), block_cursor);
        };
        if (content_model['$==']("verbatim")) {
          if ($truthy((indent = attributes['$[]']("indent")))) {
            self['$adjust_indentation!'](lines, indent, ($truthy($a = attributes['$[]']("tabsize")) ? $a : parent.$document().$attributes()['$[]']("tabsize")))
          } else if ($truthy($rb_gt((tab_size = ($truthy($a = attributes['$[]']("tabsize")) ? $a : parent.$document().$attributes()['$[]']("tabsize")).$to_i()), 0))) {
            self['$adjust_indentation!'](lines, nil, tab_size)}
        } else if (content_model['$==']("skip")) {
          return nil};
        if ($truthy((extension = options['$[]']("extension")))) {
          
          attributes.$delete("style");
          if ($truthy((block = extension.$process_method()['$[]'](parent, ($truthy($a = block_reader) ? $a : $$($nesting, 'Reader').$new(lines)), attributes.$dup())))) {
            
            attributes.$replace(block.$attributes());
            if ($truthy((($a = block.$content_model()['$==']("compound")) ? (lines = block.$lines())['$nil_or_empty?']()['$!']() : block.$content_model()['$==']("compound")))) {
              
              content_model = "compound";
              block_reader = $$($nesting, 'Reader').$new(lines);};
          } else {
            return nil
          };
        } else {
          block = $$($nesting, 'Block').$new(parent, block_context, $hash2(["content_model", "source", "attributes"], {"content_model": content_model, "source": lines, "attributes": attributes}))
        };
        if ($truthy(($truthy($a = ($truthy($b = attributes['$key?']("title")) ? block.$context()['$!=']("admonition") : $b)) ? parent.$document().$attributes()['$key?']("" + (block.$context()) + "-caption") : $a))) {
          
          
          $writer = [attributes.$delete("title")];
          $send(block, 'title=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          block.$assign_caption(attributes.$delete("caption"));};
        if (content_model['$==']("compound")) {
          self.$parse_blocks(block_reader, block)};
        return block;
      }, TMP_Parser_build_block_16.$$arity = -7);
      Opal.defs(self, '$parse_blocks', TMP_Parser_parse_blocks_17 = function $$parse_blocks(reader, parent) {
        var $a, $b, $c, self = this, block = nil;

        while ($truthy(($truthy($b = ($truthy($c = (block = self.$next_block(reader, parent))) ? parent.$blocks()['$<<'](block) : $c)) ? $b : reader['$has_more_lines?']()))) {
          
        }
      }, TMP_Parser_parse_blocks_17.$$arity = 2);
      Opal.defs(self, '$parse_list', TMP_Parser_parse_list_18 = function $$parse_list(reader, list_type, parent, style) {
        var $a, $b, $c, self = this, list_block = nil, list_rx = nil, list_item = nil;
        if ($gvars["~"] == null) $gvars["~"] = nil;

        
        list_block = $$($nesting, 'List').$new(parent, list_type);
        while ($truthy(($truthy($b = reader['$has_more_lines?']()) ? (list_rx = ($truthy($c = list_rx) ? $c : $$($nesting, 'ListRxMap')['$[]'](list_type)))['$=~'](reader.$peek_line()) : $b))) {
          
          if ($truthy((list_item = self.$parse_list_item(reader, list_block, $gvars["~"], (($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), style)))) {
            list_block.$items()['$<<'](list_item)};
          if ($truthy($b = reader.$skip_blank_lines())) {
            $b
          } else {
            break;
          };
        };
        return list_block;
      }, TMP_Parser_parse_list_18.$$arity = 4);
      Opal.defs(self, '$catalog_callouts', TMP_Parser_catalog_callouts_19 = function $$catalog_callouts(text, document) {
        var TMP_20, self = this, found = nil, autonum = nil;

        
        found = false;
        autonum = 0;
        if ($truthy(text['$include?']("<"))) {
          $send(text, 'scan', [$$($nesting, 'CalloutScanRx')], (TMP_20 = function(){var self = TMP_20.$$s || this, $a, $b, captured = nil, num = nil;

          
            $a = [(($b = $gvars['~']) === nil ? nil : $b['$[]'](0)), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2))], (captured = $a[0]), (num = $a[1]), $a;
            if ($truthy(captured['$start_with?']("\\"))) {
            } else {
              document.$callouts().$register((function() {if (num['$=='](".")) {
                return (autonum = $rb_plus(autonum, 1)).$to_s()
              } else {
                return num
              }; return nil; })())
            };
            return (found = true);}, TMP_20.$$s = self, TMP_20.$$arity = 0, TMP_20))};
        return found;
      }, TMP_Parser_catalog_callouts_19.$$arity = 2);
      Opal.defs(self, '$catalog_inline_anchor', TMP_Parser_catalog_inline_anchor_21 = function $$catalog_inline_anchor(id, reftext, node, location, doc) {
        var $a, self = this;

        
        
        if (doc == null) {
          doc = nil;
        };
        doc = ($truthy($a = doc) ? $a : node.$document());
        if ($truthy(($truthy($a = reftext) ? reftext['$include?']($$($nesting, 'ATTR_REF_HEAD')) : $a))) {
          reftext = doc.$sub_attributes(reftext)};
        if ($truthy(doc.$register("refs", [id, $$($nesting, 'Inline').$new(node, "anchor", reftext, $hash2(["type", "id"], {"type": "ref", "id": id})), reftext]))) {
        } else {
          
          if ($truthy($$($nesting, 'Reader')['$==='](location))) {
            location = location.$cursor()};
          self.$logger().$warn(self.$message_with_context("" + "id assigned to anchor already in use: " + (id), $hash2(["source_location"], {"source_location": location})));
        };
        return nil;
      }, TMP_Parser_catalog_inline_anchor_21.$$arity = -5);
      Opal.defs(self, '$catalog_inline_anchors', TMP_Parser_catalog_inline_anchors_22 = function $$catalog_inline_anchors(text, block, document, reader) {
        var $a, TMP_23, self = this;

        
        if ($truthy(($truthy($a = text['$include?']("[[")) ? $a : text['$include?']("or:")))) {
          $send(text, 'scan', [$$($nesting, 'InlineAnchorScanRx')], (TMP_23 = function(){var self = TMP_23.$$s || this, $b, m = nil, id = nil, reftext = nil, location = nil, offset = nil;
            if ($gvars["~"] == null) $gvars["~"] = nil;

          
            m = $gvars["~"];
            if ($truthy((id = (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))))) {
              if ($truthy((reftext = (($b = $gvars['~']) === nil ? nil : $b['$[]'](2))))) {
                if ($truthy(($truthy($b = reftext['$include?']($$($nesting, 'ATTR_REF_HEAD'))) ? (reftext = document.$sub_attributes(reftext))['$empty?']() : $b))) {
                  return nil;}}
            } else {
              
              id = (($b = $gvars['~']) === nil ? nil : $b['$[]'](3));
              if ($truthy((reftext = (($b = $gvars['~']) === nil ? nil : $b['$[]'](4))))) {
                
                if ($truthy(reftext['$include?']("]"))) {
                  reftext = reftext.$gsub("\\]", "]")};
                if ($truthy(($truthy($b = reftext['$include?']($$($nesting, 'ATTR_REF_HEAD'))) ? (reftext = document.$sub_attributes(reftext))['$empty?']() : $b))) {
                  return nil;};};
            };
            if ($truthy(document.$register("refs", [id, $$($nesting, 'Inline').$new(block, "anchor", reftext, $hash2(["type", "id"], {"type": "ref", "id": id})), reftext]))) {
              return nil
            } else {
              
              location = reader.$cursor_at_mark();
              if ($truthy($rb_gt((offset = $rb_plus(m.$pre_match().$count($$($nesting, 'LF')), (function() {if ($truthy(m['$[]'](0)['$start_with?']($$($nesting, 'LF')))) {
                return 1
              } else {
                return 0
              }; return nil; })())), 0))) {
                (location = location.$dup()).$advance(offset)};
              return self.$logger().$warn(self.$message_with_context("" + "id assigned to anchor already in use: " + (id), $hash2(["source_location"], {"source_location": location})));
            };}, TMP_23.$$s = self, TMP_23.$$arity = 0, TMP_23))};
        return nil;
      }, TMP_Parser_catalog_inline_anchors_22.$$arity = 4);
      Opal.defs(self, '$catalog_inline_biblio_anchor', TMP_Parser_catalog_inline_biblio_anchor_24 = function $$catalog_inline_biblio_anchor(id, reftext, node, reader) {
        var $a, self = this, styled_reftext = nil;

        
        if ($truthy(node.$document().$register("refs", [id, $$($nesting, 'Inline').$new(node, "anchor", (styled_reftext = "" + "[" + (($truthy($a = reftext) ? $a : id)) + "]"), $hash2(["type", "id"], {"type": "bibref", "id": id})), styled_reftext]))) {
        } else {
          self.$logger().$warn(self.$message_with_context("" + "id assigned to bibliography anchor already in use: " + (id), $hash2(["source_location"], {"source_location": reader.$cursor()})))
        };
        return nil;
      }, TMP_Parser_catalog_inline_biblio_anchor_24.$$arity = 4);
      Opal.defs(self, '$parse_description_list', TMP_Parser_parse_description_list_25 = function $$parse_description_list(reader, match, parent) {
        var $a, $b, $c, self = this, list_block = nil, previous_pair = nil, sibling_pattern = nil, term = nil, item = nil, $writer = nil;

        
        list_block = $$($nesting, 'List').$new(parent, "dlist");
        previous_pair = nil;
        sibling_pattern = $$($nesting, 'DescriptionListSiblingRx')['$[]'](match['$[]'](2));
        while ($truthy(($truthy($b = match) ? $b : ($truthy($c = reader['$has_more_lines?']()) ? (match = sibling_pattern.$match(reader.$peek_line())) : $c)))) {
          
          $c = self.$parse_list_item(reader, list_block, match, sibling_pattern), $b = Opal.to_ary($c), (term = ($b[0] == null ? nil : $b[0])), (item = ($b[1] == null ? nil : $b[1])), $c;
          if ($truthy(($truthy($b = previous_pair) ? previous_pair['$[]'](1)['$!']() : $b))) {
            
            previous_pair['$[]'](0)['$<<'](term);
            
            $writer = [1, item];
            $send(previous_pair, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else {
            list_block.$items()['$<<']((previous_pair = [[term], item]))
          };
          match = nil;
        };
        return list_block;
      }, TMP_Parser_parse_description_list_25.$$arity = 3);
      Opal.defs(self, '$parse_callout_list', TMP_Parser_parse_callout_list_26 = function $$parse_callout_list(reader, match, parent, callouts) {
        var $a, $b, $c, self = this, list_block = nil, next_index = nil, autonum = nil, num = nil, list_item = nil, coids = nil, $writer = nil;

        
        list_block = $$($nesting, 'List').$new(parent, "colist");
        next_index = 1;
        autonum = 0;
        while ($truthy(($truthy($b = match) ? $b : ($truthy($c = (match = $$($nesting, 'CalloutListRx').$match(reader.$peek_line()))) ? reader.$mark() : $c)))) {
          
          if ((num = match['$[]'](1))['$=='](".")) {
            num = (autonum = $rb_plus(autonum, 1)).$to_s()};
          if (num['$=='](next_index.$to_s())) {
          } else {
            self.$logger().$warn(self.$message_with_context("" + "callout list item index: expected " + (next_index) + ", got " + (num), $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))
          };
          if ($truthy((list_item = self.$parse_list_item(reader, list_block, match, "<1>")))) {
            
            list_block.$items()['$<<'](list_item);
            if ($truthy((coids = callouts.$callout_ids(list_block.$items().$size()))['$empty?']())) {
              self.$logger().$warn(self.$message_with_context("" + "no callout found for <" + (list_block.$items().$size()) + ">", $hash2(["source_location"], {"source_location": reader.$cursor_at_mark()})))
            } else {
              
              $writer = ["coids", coids];
              $send(list_item.$attributes(), '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };};
          next_index = $rb_plus(next_index, 1);
          match = nil;
        };
        callouts.$next_list();
        return list_block;
      }, TMP_Parser_parse_callout_list_26.$$arity = 4);
      Opal.defs(self, '$parse_list_item', TMP_Parser_parse_list_item_27 = function $$parse_list_item(reader, list_block, match, sibling_trait, style) {
        var $a, $b, self = this, list_type = nil, dlist = nil, list_term = nil, term_text = nil, item_text = nil, has_text = nil, list_item = nil, $writer = nil, sourcemap_assignment_deferred = nil, ordinal = nil, implicit_style = nil, block_cursor = nil, list_item_reader = nil, comment_lines = nil, subsequent_line = nil, continuation_connects_first_block = nil, content_adjacent = nil, block = nil;

        
        
        if (style == null) {
          style = nil;
        };
        if ((list_type = list_block.$context())['$==']("dlist")) {
          
          dlist = true;
          list_term = $$($nesting, 'ListItem').$new(list_block, (term_text = match['$[]'](1)));
          if ($truthy(($truthy($a = term_text['$start_with?']("[[")) ? $$($nesting, 'LeadingInlineAnchorRx')['$=~'](term_text) : $a))) {
            self.$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), ($truthy($a = (($b = $gvars['~']) === nil ? nil : $b['$[]'](2))) ? $a : (($b = $gvars['~']) === nil ? nil : $b.$post_match()).$lstrip()), list_term, reader)};
          if ($truthy((item_text = match['$[]'](3)))) {
            has_text = true};
          list_item = $$($nesting, 'ListItem').$new(list_block, item_text);
          if ($truthy(list_block.$document().$sourcemap())) {
            
            
            $writer = [reader.$cursor()];
            $send(list_term, 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy(has_text)) {
              
              $writer = [list_term.$source_location()];
              $send(list_item, 'source_location=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              sourcemap_assignment_deferred = true
            };};
        } else {
          
          has_text = true;
          list_item = $$($nesting, 'ListItem').$new(list_block, (item_text = match['$[]'](2)));
          if ($truthy(list_block.$document().$sourcemap())) {
            
            $writer = [reader.$cursor()];
            $send(list_item, 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if (list_type['$==']("ulist")) {
            
            
            $writer = [sibling_trait];
            $send(list_item, 'marker=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy(item_text['$start_with?']("["))) {
              if ($truthy(($truthy($a = style) ? style['$==']("bibliography") : $a))) {
                if ($truthy($$($nesting, 'InlineBiblioAnchorRx')['$=~'](item_text))) {
                  self.$catalog_inline_biblio_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), list_item, reader)}
              } else if ($truthy(item_text['$start_with?']("[["))) {
                if ($truthy($$($nesting, 'LeadingInlineAnchorRx')['$=~'](item_text))) {
                  self.$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), list_item, reader)}
              } else if ($truthy(item_text['$start_with?']("[ ] ", "[x] ", "[*] "))) {
                
                
                $writer = ["checklist-option", ""];
                $send(list_block.$attributes(), '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = ["checkbox", ""];
                $send(list_item.$attributes(), '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                if ($truthy(item_text['$start_with?']("[ "))) {
                } else {
                  
                  $writer = ["checked", ""];
                  $send(list_item.$attributes(), '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];
                };
                
                $writer = [item_text.$slice(4, item_text.$length())];
                $send(list_item, 'text=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;}};
          } else if (list_type['$==']("olist")) {
            
            $b = self.$resolve_ordered_list_marker(sibling_trait, (ordinal = list_block.$items().$size()), true, reader), $a = Opal.to_ary($b), (sibling_trait = ($a[0] == null ? nil : $a[0])), (implicit_style = ($a[1] == null ? nil : $a[1])), $b;
            
            $writer = [sibling_trait];
            $send(list_item, 'marker=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy((($a = ordinal['$=='](0)) ? style['$!']() : ordinal['$=='](0)))) {
              
              $writer = [($truthy($a = implicit_style) ? $a : ($truthy($b = $$($nesting, 'ORDERED_LIST_STYLES')['$[]']($rb_minus(sibling_trait.$length(), 1))) ? $b : "arabic").$to_s())];
              $send(list_block, 'style=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(($truthy($a = item_text['$start_with?']("[[")) ? $$($nesting, 'LeadingInlineAnchorRx')['$=~'](item_text) : $a))) {
              self.$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), list_item, reader)};
          } else {
            
            $writer = [sibling_trait];
            $send(list_item, 'marker=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
        };
        reader.$shift();
        block_cursor = reader.$cursor();
        list_item_reader = $$($nesting, 'Reader').$new(self.$read_lines_for_list_item(reader, list_type, sibling_trait, has_text), block_cursor);
        if ($truthy(list_item_reader['$has_more_lines?']())) {
          
          if ($truthy(sourcemap_assignment_deferred)) {
            
            $writer = [block_cursor];
            $send(list_item, 'source_location=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          comment_lines = list_item_reader.$skip_line_comments();
          if ($truthy((subsequent_line = list_item_reader.$peek_line()))) {
            
            if ($truthy(comment_lines['$empty?']())) {
            } else {
              list_item_reader.$unshift_lines(comment_lines)
            };
            if ($truthy((continuation_connects_first_block = subsequent_line['$empty?']()))) {
              content_adjacent = false
            } else {
              
              content_adjacent = true;
              if ($truthy(dlist)) {
              } else {
                has_text = nil
              };
            };
          } else {
            
            continuation_connects_first_block = false;
            content_adjacent = false;
          };
          if ($truthy((block = self.$next_block(list_item_reader, list_item, $hash2([], {}), $hash2(["text"], {"text": has_text['$!']()}))))) {
            list_item.$blocks()['$<<'](block)};
          while ($truthy(list_item_reader['$has_more_lines?']())) {
            if ($truthy((block = self.$next_block(list_item_reader, list_item)))) {
              list_item.$blocks()['$<<'](block)}
          };
          list_item.$fold_first(continuation_connects_first_block, content_adjacent);};
        if ($truthy(dlist)) {
          if ($truthy(($truthy($a = list_item['$text?']()) ? $a : list_item['$blocks?']()))) {
            return [list_term, list_item]
          } else {
            return [list_term]
          }
        } else {
          return list_item
        };
      }, TMP_Parser_parse_list_item_27.$$arity = -5);
      Opal.defs(self, '$read_lines_for_list_item', TMP_Parser_read_lines_for_list_item_28 = function $$read_lines_for_list_item(reader, list_type, sibling_trait, has_text) {
        var $a, $b, $c, TMP_29, TMP_30, TMP_31, TMP_32, TMP_33, self = this, buffer = nil, continuation = nil, within_nested_list = nil, detached_continuation = nil, this_line = nil, prev_line = nil, $writer = nil, match = nil, nested_list_type = nil;

        
        
        if (sibling_trait == null) {
          sibling_trait = nil;
        };
        
        if (has_text == null) {
          has_text = true;
        };
        buffer = [];
        continuation = "inactive";
        within_nested_list = false;
        detached_continuation = nil;
        while ($truthy(reader['$has_more_lines?']())) {
          
          this_line = reader.$read_line();
          if ($truthy(self['$is_sibling_list_item?'](this_line, list_type, sibling_trait))) {
            break;};
          prev_line = (function() {if ($truthy(buffer['$empty?']())) {
            return nil
          } else {
            return buffer['$[]'](-1)
          }; return nil; })();
          if (prev_line['$==']($$($nesting, 'LIST_CONTINUATION'))) {
            
            if (continuation['$==']("inactive")) {
              
              continuation = "active";
              has_text = true;
              if ($truthy(within_nested_list)) {
              } else {
                
                $writer = [-1, ""];
                $send(buffer, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };};
            if (this_line['$==']($$($nesting, 'LIST_CONTINUATION'))) {
              
              if ($truthy(continuation['$!=']("frozen"))) {
                
                continuation = "frozen";
                buffer['$<<'](this_line);};
              this_line = nil;
              continue;;};};
          if ($truthy((match = self['$is_delimited_block?'](this_line, true)))) {
            if (continuation['$==']("active")) {
              
              buffer['$<<'](this_line);
              buffer.$concat(reader.$read_lines_until($hash2(["terminator", "read_last_line", "context"], {"terminator": match.$terminator(), "read_last_line": true, "context": nil})));
              continuation = "inactive";
            } else {
              break;
            }
          } else if ($truthy(($truthy($b = (($c = list_type['$==']("dlist")) ? continuation['$!=']("active") : list_type['$==']("dlist"))) ? $$($nesting, 'BlockAttributeLineRx')['$match?'](this_line) : $b))) {
            break;
          } else if ($truthy((($b = continuation['$==']("active")) ? this_line['$empty?']()['$!']() : continuation['$==']("active")))) {
            if ($truthy($$($nesting, 'LiteralParagraphRx')['$match?'](this_line))) {
              
              reader.$unshift_line(this_line);
              buffer.$concat($send(reader, 'read_lines_until', [$hash2(["preserve_last_line", "break_on_blank_lines", "break_on_list_continuation"], {"preserve_last_line": true, "break_on_blank_lines": true, "break_on_list_continuation": true})], (TMP_29 = function(line){var self = TMP_29.$$s || this, $d;

              
                
                if (line == null) {
                  line = nil;
                };
                return (($d = list_type['$==']("dlist")) ? self['$is_sibling_list_item?'](line, list_type, sibling_trait) : list_type['$==']("dlist"));}, TMP_29.$$s = self, TMP_29.$$arity = 1, TMP_29)));
              continuation = "inactive";
            } else if ($truthy(($truthy($b = ($truthy($c = $$($nesting, 'BlockTitleRx')['$match?'](this_line)) ? $c : $$($nesting, 'BlockAttributeLineRx')['$match?'](this_line))) ? $b : $$($nesting, 'AttributeEntryRx')['$match?'](this_line)))) {
              buffer['$<<'](this_line)
            } else {
              
              if ($truthy((nested_list_type = $send((function() {if ($truthy(within_nested_list)) {
                return ["dlist"]
              } else {
                return $$($nesting, 'NESTABLE_LIST_CONTEXTS')
              }; return nil; })(), 'find', [], (TMP_30 = function(ctx){var self = TMP_30.$$s || this;

              
                
                if (ctx == null) {
                  ctx = nil;
                };
                return $$($nesting, 'ListRxMap')['$[]'](ctx)['$match?'](this_line);}, TMP_30.$$s = self, TMP_30.$$arity = 1, TMP_30))))) {
                
                within_nested_list = true;
                if ($truthy((($b = nested_list_type['$==']("dlist")) ? (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))['$nil_or_empty?']() : nested_list_type['$==']("dlist")))) {
                  has_text = false};};
              buffer['$<<'](this_line);
              continuation = "inactive";
            }
          } else if ($truthy(($truthy($b = prev_line) ? prev_line['$empty?']() : $b))) {
            
            if ($truthy(this_line['$empty?']())) {
              
              if ($truthy((this_line = ($truthy($b = reader.$skip_blank_lines()) ? reader.$read_line() : $b)))) {
              } else {
                break;
              };
              if ($truthy(self['$is_sibling_list_item?'](this_line, list_type, sibling_trait))) {
                break;};};
            if (this_line['$==']($$($nesting, 'LIST_CONTINUATION'))) {
              
              detached_continuation = buffer.$size();
              buffer['$<<'](this_line);
            } else if ($truthy(has_text)) {
              if ($truthy(self['$is_sibling_list_item?'](this_line, list_type, sibling_trait))) {
                break;
              } else if ($truthy((nested_list_type = $send($$($nesting, 'NESTABLE_LIST_CONTEXTS'), 'find', [], (TMP_31 = function(ctx){var self = TMP_31.$$s || this;

              
                
                if (ctx == null) {
                  ctx = nil;
                };
                return $$($nesting, 'ListRxMap')['$[]'](ctx)['$=~'](this_line);}, TMP_31.$$s = self, TMP_31.$$arity = 1, TMP_31))))) {
                
                buffer['$<<'](this_line);
                within_nested_list = true;
                if ($truthy((($b = nested_list_type['$==']("dlist")) ? (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))['$nil_or_empty?']() : nested_list_type['$==']("dlist")))) {
                  has_text = false};
              } else if ($truthy($$($nesting, 'LiteralParagraphRx')['$match?'](this_line))) {
                
                reader.$unshift_line(this_line);
                buffer.$concat($send(reader, 'read_lines_until', [$hash2(["preserve_last_line", "break_on_blank_lines", "break_on_list_continuation"], {"preserve_last_line": true, "break_on_blank_lines": true, "break_on_list_continuation": true})], (TMP_32 = function(line){var self = TMP_32.$$s || this, $d;

                
                  
                  if (line == null) {
                    line = nil;
                  };
                  return (($d = list_type['$==']("dlist")) ? self['$is_sibling_list_item?'](line, list_type, sibling_trait) : list_type['$==']("dlist"));}, TMP_32.$$s = self, TMP_32.$$arity = 1, TMP_32)));
              } else {
                break;
              }
            } else {
              
              if ($truthy(within_nested_list)) {
              } else {
                buffer.$pop()
              };
              buffer['$<<'](this_line);
              has_text = true;
            };
          } else {
            
            if ($truthy(this_line['$empty?']()['$!']())) {
              has_text = true};
            if ($truthy((nested_list_type = $send((function() {if ($truthy(within_nested_list)) {
              return ["dlist"]
            } else {
              return $$($nesting, 'NESTABLE_LIST_CONTEXTS')
            }; return nil; })(), 'find', [], (TMP_33 = function(ctx){var self = TMP_33.$$s || this;

            
              
              if (ctx == null) {
                ctx = nil;
              };
              return $$($nesting, 'ListRxMap')['$[]'](ctx)['$=~'](this_line);}, TMP_33.$$s = self, TMP_33.$$arity = 1, TMP_33))))) {
              
              within_nested_list = true;
              if ($truthy((($b = nested_list_type['$==']("dlist")) ? (($c = $gvars['~']) === nil ? nil : $c['$[]'](3))['$nil_or_empty?']() : nested_list_type['$==']("dlist")))) {
                has_text = false};};
            buffer['$<<'](this_line);
          };
          this_line = nil;
        };
        if ($truthy(this_line)) {
          reader.$unshift_line(this_line)};
        if ($truthy(detached_continuation)) {
          buffer.$delete_at(detached_continuation)};
        while ($truthy(($truthy($b = buffer['$empty?']()['$!']()) ? buffer['$[]'](-1)['$empty?']() : $b))) {
          buffer.$pop()
        };
        if ($truthy(($truthy($a = buffer['$empty?']()['$!']()) ? buffer['$[]'](-1)['$==']($$($nesting, 'LIST_CONTINUATION')) : $a))) {
          buffer.$pop()};
        return buffer;
      }, TMP_Parser_read_lines_for_list_item_28.$$arity = -3);
      Opal.defs(self, '$initialize_section', TMP_Parser_initialize_section_34 = function $$initialize_section(reader, parent, attributes) {
        var $a, $b, self = this, document = nil, book = nil, doctype = nil, source_location = nil, sect_style = nil, sect_id = nil, sect_reftext = nil, sect_title = nil, sect_level = nil, sect_atx = nil, $writer = nil, sect_name = nil, sect_special = nil, sect_numbered = nil, section = nil, id = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        document = parent.$document();
        book = (doctype = document.$doctype())['$==']("book");
        if ($truthy(document.$sourcemap())) {
          source_location = reader.$cursor()};
        sect_style = attributes['$[]'](1);
        $b = self.$parse_section_title(reader, document, attributes['$[]']("id")), $a = Opal.to_ary($b), (sect_id = ($a[0] == null ? nil : $a[0])), (sect_reftext = ($a[1] == null ? nil : $a[1])), (sect_title = ($a[2] == null ? nil : $a[2])), (sect_level = ($a[3] == null ? nil : $a[3])), (sect_atx = ($a[4] == null ? nil : $a[4])), $b;
        if ($truthy(sect_reftext)) {
          
          $writer = ["reftext", sect_reftext];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        } else {
          sect_reftext = attributes['$[]']("reftext")
        };
        if ($truthy(sect_style)) {
          if ($truthy(($truthy($a = book) ? sect_style['$==']("abstract") : $a))) {
            $a = ["chapter", 1], (sect_name = $a[0]), (sect_level = $a[1]), $a
          } else {
            
            $a = [sect_style, true], (sect_name = $a[0]), (sect_special = $a[1]), $a;
            if (sect_level['$=='](0)) {
              sect_level = 1};
            sect_numbered = sect_style['$==']("appendix");
          }
        } else if ($truthy(book)) {
          sect_name = (function() {if (sect_level['$=='](0)) {
            return "part"
          } else {
            
            if ($truthy($rb_gt(sect_level, 1))) {
              return "section"
            } else {
              return "chapter"
            };
          }; return nil; })()
        } else if ($truthy((($a = doctype['$==']("manpage")) ? sect_title.$casecmp("synopsis")['$=='](0) : doctype['$==']("manpage")))) {
          $a = ["synopsis", true], (sect_name = $a[0]), (sect_special = $a[1]), $a
        } else {
          sect_name = "section"
        };
        section = $$($nesting, 'Section').$new(parent, sect_level);
        $a = [sect_id, sect_title, sect_name, source_location], section['$id=']($a[0]), section['$title=']($a[1]), section['$sectname=']($a[2]), section['$source_location=']($a[3]), $a;
        if ($truthy(sect_special)) {
          
          
          $writer = [true];
          $send(section, 'special=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(sect_numbered)) {
            
            $writer = [true];
            $send(section, 'numbered=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          } else if (document.$attributes()['$[]']("sectnums")['$==']("all")) {
            
            $writer = [(function() {if ($truthy(($truthy($a = book) ? sect_level['$=='](1) : $a))) {
              return "chapter"
            } else {
              return true
            }; return nil; })()];
            $send(section, 'numbered=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
        } else if ($truthy(($truthy($a = document.$attributes()['$[]']("sectnums")) ? $rb_gt(sect_level, 0) : $a))) {
          
          $writer = [(function() {if ($truthy(section.$special())) {
            return ($truthy($a = parent.$numbered()) ? true : $a)
          } else {
            return true
          }; return nil; })()];
          $send(section, 'numbered=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];
        } else if ($truthy(($truthy($a = ($truthy($b = book) ? sect_level['$=='](0) : $b)) ? document.$attributes()['$[]']("partnums") : $a))) {
          
          $writer = [true];
          $send(section, 'numbered=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy((id = ($truthy($a = section.$id()) ? $a : (($writer = [(function() {if ($truthy(document.$attributes()['$key?']("sectids"))) {
          
          return $$($nesting, 'Section').$generate_id(section.$title(), document);
        } else {
          return nil
        }; return nil; })()]), $send(section, 'id=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))))) {
          if ($truthy(document.$register("refs", [id, section, ($truthy($a = sect_reftext) ? $a : section.$title())]))) {
          } else {
            self.$logger().$warn(self.$message_with_context("" + "id assigned to section already in use: " + (id), $hash2(["source_location"], {"source_location": reader.$cursor_at_line($rb_minus(reader.$lineno(), (function() {if ($truthy(sect_atx)) {
              return 1
            } else {
              return 2
            }; return nil; })()))})))
          }};
        section.$update_attributes(attributes);
        reader.$skip_blank_lines();
        return section;
      }, TMP_Parser_initialize_section_34.$$arity = -3);
      Opal.defs(self, '$is_next_line_section?', TMP_Parser_is_next_line_section$q_35 = function(reader, attributes) {
        var $a, $b, self = this, style = nil, next_lines = nil;

        if ($truthy(($truthy($a = (style = attributes['$[]'](1))) ? ($truthy($b = style['$==']("discrete")) ? $b : style['$==']("float")) : $a))) {
          return nil
        } else if ($truthy($$($nesting, 'Compliance').$underline_style_section_titles())) {
          
          next_lines = reader.$peek_lines(2, ($truthy($a = style) ? style['$==']("comment") : $a));
          return self['$is_section_title?'](($truthy($a = next_lines['$[]'](0)) ? $a : ""), next_lines['$[]'](1));
        } else {
          return self['$atx_section_title?'](($truthy($a = reader.$peek_line()) ? $a : ""))
        }
      }, TMP_Parser_is_next_line_section$q_35.$$arity = 2);
      Opal.defs(self, '$is_next_line_doctitle?', TMP_Parser_is_next_line_doctitle$q_36 = function(reader, attributes, leveloffset) {
        var $a, self = this, sect_level = nil;

        if ($truthy(leveloffset)) {
          return ($truthy($a = (sect_level = self['$is_next_line_section?'](reader, attributes))) ? $rb_plus(sect_level, leveloffset.$to_i())['$=='](0) : $a)
        } else {
          return self['$is_next_line_section?'](reader, attributes)['$=='](0)
        }
      }, TMP_Parser_is_next_line_doctitle$q_36.$$arity = 3);
      Opal.defs(self, '$is_section_title?', TMP_Parser_is_section_title$q_37 = function(line1, line2) {
        var $a, self = this;

        
        
        if (line2 == null) {
          line2 = nil;
        };
        return ($truthy($a = self['$atx_section_title?'](line1)) ? $a : (function() {if ($truthy(line2['$nil_or_empty?']())) {
          return nil
        } else {
          return self['$setext_section_title?'](line1, line2)
        }; return nil; })());
      }, TMP_Parser_is_section_title$q_37.$$arity = -2);
      Opal.defs(self, '$atx_section_title?', TMP_Parser_atx_section_title$q_38 = function(line) {
        var $a, self = this;

        if ($truthy((function() {if ($truthy($$($nesting, 'Compliance').$markdown_syntax())) {
          
          return ($truthy($a = line['$start_with?']("=", "#")) ? $$($nesting, 'ExtAtxSectionTitleRx')['$=~'](line) : $a);
        } else {
          
          return ($truthy($a = line['$start_with?']("=")) ? $$($nesting, 'AtxSectionTitleRx')['$=~'](line) : $a);
        }; return nil; })())) {
          return $rb_minus((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)).$length(), 1)
        } else {
          return nil
        }
      }, TMP_Parser_atx_section_title$q_38.$$arity = 1);
      Opal.defs(self, '$setext_section_title?', TMP_Parser_setext_section_title$q_39 = function(line1, line2) {
        var $a, $b, $c, self = this, level = nil, line2_ch1 = nil, line2_len = nil;

        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = (level = $$($nesting, 'SETEXT_SECTION_LEVELS')['$[]']((line2_ch1 = line2.$chr())))) ? $rb_times(line2_ch1, (line2_len = line2.$length()))['$=='](line2) : $c)) ? $$($nesting, 'SetextSectionTitleRx')['$match?'](line1) : $b)) ? $rb_lt($rb_minus(self.$line_length(line1), line2_len).$abs(), 2) : $a))) {
          return level
        } else {
          return nil
        }
      }, TMP_Parser_setext_section_title$q_39.$$arity = 2);
      Opal.defs(self, '$parse_section_title', TMP_Parser_parse_section_title_40 = function $$parse_section_title(reader, document, sect_id) {
        var $a, $b, $c, $d, $e, self = this, sect_reftext = nil, line1 = nil, sect_level = nil, sect_title = nil, atx = nil, line2 = nil, line2_ch1 = nil, line2_len = nil;

        
        
        if (sect_id == null) {
          sect_id = nil;
        };
        sect_reftext = nil;
        line1 = reader.$read_line();
        if ($truthy((function() {if ($truthy($$($nesting, 'Compliance').$markdown_syntax())) {
          
          return ($truthy($a = line1['$start_with?']("=", "#")) ? $$($nesting, 'ExtAtxSectionTitleRx')['$=~'](line1) : $a);
        } else {
          
          return ($truthy($a = line1['$start_with?']("=")) ? $$($nesting, 'AtxSectionTitleRx')['$=~'](line1) : $a);
        }; return nil; })())) {
          
          $a = [$rb_minus((($b = $gvars['~']) === nil ? nil : $b['$[]'](1)).$length(), 1), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)), true], (sect_level = $a[0]), (sect_title = $a[1]), (atx = $a[2]), $a;
          if ($truthy(sect_id)) {
          } else if ($truthy(($truthy($a = ($truthy($b = sect_title['$end_with?']("]]")) ? $$($nesting, 'InlineSectionAnchorRx')['$=~'](sect_title) : $b)) ? (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))['$!']() : $a))) {
            $a = [sect_title.$slice(0, $rb_minus(sect_title.$length(), (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)).$length())), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)), (($b = $gvars['~']) === nil ? nil : $b['$[]'](3))], (sect_title = $a[0]), (sect_id = $a[1]), (sect_reftext = $a[2]), $a};
        } else if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = ($truthy($d = ($truthy($e = $$($nesting, 'Compliance').$underline_style_section_titles()) ? (line2 = reader.$peek_line(true)) : $e)) ? (sect_level = $$($nesting, 'SETEXT_SECTION_LEVELS')['$[]']((line2_ch1 = line2.$chr()))) : $d)) ? $rb_times(line2_ch1, (line2_len = line2.$length()))['$=='](line2) : $c)) ? (sect_title = ($truthy($c = $$($nesting, 'SetextSectionTitleRx')['$=~'](line1)) ? (($d = $gvars['~']) === nil ? nil : $d['$[]'](1)) : $c)) : $b)) ? $rb_lt($rb_minus(self.$line_length(line1), line2_len).$abs(), 2) : $a))) {
          
          atx = false;
          if ($truthy(sect_id)) {
          } else if ($truthy(($truthy($a = ($truthy($b = sect_title['$end_with?']("]]")) ? $$($nesting, 'InlineSectionAnchorRx')['$=~'](sect_title) : $b)) ? (($b = $gvars['~']) === nil ? nil : $b['$[]'](1))['$!']() : $a))) {
            $a = [sect_title.$slice(0, $rb_minus(sect_title.$length(), (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)).$length())), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)), (($b = $gvars['~']) === nil ? nil : $b['$[]'](3))], (sect_title = $a[0]), (sect_id = $a[1]), (sect_reftext = $a[2]), $a};
          reader.$shift();
        } else {
          self.$raise("" + "Unrecognized section at " + (reader.$cursor_at_prev_line()))
        };
        if ($truthy(document['$attr?']("leveloffset"))) {
          sect_level = $rb_plus(sect_level, document.$attr("leveloffset").$to_i())};
        return [sect_id, sect_reftext, sect_title, sect_level, atx];
      }, TMP_Parser_parse_section_title_40.$$arity = -3);
      if ($truthy($$($nesting, 'FORCE_UNICODE_LINE_LENGTH'))) {
        Opal.defs(self, '$line_length', TMP_Parser_line_length_41 = function $$line_length(line) {
          var self = this;

          return line.$scan($$($nesting, 'UnicodeCharScanRx')).$size()
        }, TMP_Parser_line_length_41.$$arity = 1)
      } else {
        Opal.defs(self, '$line_length', TMP_Parser_line_length_42 = function $$line_length(line) {
          var self = this;

          return line.$length()
        }, TMP_Parser_line_length_42.$$arity = 1)
      };
      Opal.defs(self, '$parse_header_metadata', TMP_Parser_parse_header_metadata_43 = function $$parse_header_metadata(reader, document) {
        var $a, TMP_44, TMP_45, TMP_46, self = this, doc_attrs = nil, implicit_authors = nil, metadata = nil, implicit_author = nil, implicit_authorinitials = nil, author_metadata = nil, rev_metadata = nil, rev_line = nil, match = nil, $writer = nil, component = nil, author_line = nil, authors = nil, author_idx = nil, author_key = nil, explicit = nil, sparse = nil, author_override = nil;

        
        
        if (document == null) {
          document = nil;
        };
        doc_attrs = ($truthy($a = document) ? document.$attributes() : $a);
        self.$process_attribute_entries(reader, document);
        $a = [(implicit_authors = $hash2([], {})), nil, nil], (metadata = $a[0]), (implicit_author = $a[1]), (implicit_authorinitials = $a[2]), $a;
        if ($truthy(($truthy($a = reader['$has_more_lines?']()) ? reader['$next_line_empty?']()['$!']() : $a))) {
          
          if ($truthy((author_metadata = self.$process_authors(reader.$read_line()))['$empty?']())) {
          } else {
            
            if ($truthy(document)) {
              
              $send(author_metadata, 'each', [], (TMP_44 = function(key, val){var self = TMP_44.$$s || this, $writer = nil;

              
                
                if (key == null) {
                  key = nil;
                };
                
                if (val == null) {
                  val = nil;
                };
                if ($truthy(doc_attrs['$key?'](key))) {
                  return nil
                } else {
                  
                  $writer = [key, (function() {if ($truthy($$$('::', 'String')['$==='](val))) {
                    
                    return document.$apply_header_subs(val);
                  } else {
                    return val
                  }; return nil; })()];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                };}, TMP_44.$$s = self, TMP_44.$$arity = 2, TMP_44));
              implicit_author = doc_attrs['$[]']("author");
              implicit_authorinitials = doc_attrs['$[]']("authorinitials");
              implicit_authors = doc_attrs['$[]']("authors");};
            metadata = author_metadata;
          };
          self.$process_attribute_entries(reader, document);
          rev_metadata = $hash2([], {});
          if ($truthy(($truthy($a = reader['$has_more_lines?']()) ? reader['$next_line_empty?']()['$!']() : $a))) {
            
            rev_line = reader.$read_line();
            if ($truthy((match = $$($nesting, 'RevisionInfoLineRx').$match(rev_line)))) {
              
              if ($truthy(match['$[]'](1))) {
                
                $writer = ["revnumber", match['$[]'](1).$rstrip()];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              if ($truthy((component = match['$[]'](2).$strip())['$empty?']())) {
              } else if ($truthy(($truthy($a = match['$[]'](1)['$!']()) ? component['$start_with?']("v") : $a))) {
                
                $writer = ["revnumber", component.$slice(1, component.$length())];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              } else {
                
                $writer = ["revdate", component];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
              if ($truthy(match['$[]'](3))) {
                
                $writer = ["revremark", match['$[]'](3).$rstrip()];
                $send(rev_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
            } else {
              reader.$unshift_line(rev_line)
            };};
          if ($truthy(rev_metadata['$empty?']())) {
          } else {
            
            if ($truthy(document)) {
              $send(rev_metadata, 'each', [], (TMP_45 = function(key, val){var self = TMP_45.$$s || this;

              
                
                if (key == null) {
                  key = nil;
                };
                
                if (val == null) {
                  val = nil;
                };
                if ($truthy(doc_attrs['$key?'](key))) {
                  return nil
                } else {
                  
                  $writer = [key, document.$apply_header_subs(val)];
                  $send(doc_attrs, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                };}, TMP_45.$$s = self, TMP_45.$$arity = 2, TMP_45))};
            metadata.$update(rev_metadata);
          };
          self.$process_attribute_entries(reader, document);
          reader.$skip_blank_lines();
        } else {
          author_metadata = $hash2([], {})
        };
        if ($truthy(document)) {
          
          if ($truthy(($truthy($a = doc_attrs['$key?']("author")) ? (author_line = doc_attrs['$[]']("author"))['$!='](implicit_author) : $a))) {
            
            author_metadata = self.$process_authors(author_line, true, false);
            if ($truthy(doc_attrs['$[]']("authorinitials")['$!='](implicit_authorinitials))) {
              author_metadata.$delete("authorinitials")};
          } else if ($truthy(($truthy($a = doc_attrs['$key?']("authors")) ? (author_line = doc_attrs['$[]']("authors"))['$!='](implicit_authors) : $a))) {
            author_metadata = self.$process_authors(author_line, true)
          } else {
            
            $a = [[], 1, "author_1", false, false], (authors = $a[0]), (author_idx = $a[1]), (author_key = $a[2]), (explicit = $a[3]), (sparse = $a[4]), $a;
            while ($truthy(doc_attrs['$key?'](author_key))) {
              
              if ((author_override = doc_attrs['$[]'](author_key))['$=='](author_metadata['$[]'](author_key))) {
                
                authors['$<<'](nil);
                sparse = true;
              } else {
                
                authors['$<<'](author_override);
                explicit = true;
              };
              author_key = "" + "author_" + ((author_idx = $rb_plus(author_idx, 1)));
            };
            if ($truthy(explicit)) {
              
              if ($truthy(sparse)) {
                $send(authors, 'each_with_index', [], (TMP_46 = function(author, idx){var self = TMP_46.$$s || this, TMP_47, name_idx = nil;

                
                  
                  if (author == null) {
                    author = nil;
                  };
                  
                  if (idx == null) {
                    idx = nil;
                  };
                  if ($truthy(author)) {
                    return nil
                  } else {
                    
                    $writer = [idx, $send([author_metadata['$[]']("" + "firstname_" + ((name_idx = $rb_plus(idx, 1)))), author_metadata['$[]']("" + "middlename_" + (name_idx)), author_metadata['$[]']("" + "lastname_" + (name_idx))].$compact(), 'map', [], (TMP_47 = function(it){var self = TMP_47.$$s || this;

                    
                      
                      if (it == null) {
                        it = nil;
                      };
                      return it.$tr(" ", "_");}, TMP_47.$$s = self, TMP_47.$$arity = 1, TMP_47)).$join(" ")];
                    $send(authors, '[]=', Opal.to_a($writer));
                    return $writer[$rb_minus($writer["length"], 1)];
                  };}, TMP_46.$$s = self, TMP_46.$$arity = 2, TMP_46))};
              author_metadata = self.$process_authors(authors, true, false);
            } else {
              author_metadata = $hash2([], {})
            };
          };
          if ($truthy(author_metadata['$empty?']())) {
            ($truthy($a = metadata['$[]']("authorcount")) ? $a : (($writer = ["authorcount", (($writer = ["authorcount", 0]), $send(doc_attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]), $send(metadata, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
          } else {
            
            doc_attrs.$update(author_metadata);
            if ($truthy(($truthy($a = doc_attrs['$key?']("email")['$!']()) ? doc_attrs['$key?']("email_1") : $a))) {
              
              $writer = ["email", doc_attrs['$[]']("email_1")];
              $send(doc_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
          };};
        return metadata;
      }, TMP_Parser_parse_header_metadata_43.$$arity = -2);
      Opal.defs(self, '$process_authors', TMP_Parser_process_authors_48 = function $$process_authors(author_line, names_only, multiple) {
        var TMP_49, TMP_50, self = this, author_metadata = nil, author_idx = nil, keys = nil, author_entries = nil, $writer = nil;

        
        
        if (names_only == null) {
          names_only = false;
        };
        
        if (multiple == null) {
          multiple = true;
        };
        author_metadata = $hash2([], {});
        author_idx = 0;
        keys = ["author", "authorinitials", "firstname", "middlename", "lastname", "email"];
        author_entries = (function() {if ($truthy(multiple)) {
          return $send(author_line.$split(";"), 'map', [], (TMP_49 = function(it){var self = TMP_49.$$s || this;

          
            
            if (it == null) {
              it = nil;
            };
            return it.$strip();}, TMP_49.$$s = self, TMP_49.$$arity = 1, TMP_49))
        } else {
          return self.$Array(author_line)
        }; return nil; })();
        $send(author_entries, 'each', [], (TMP_50 = function(author_entry){var self = TMP_50.$$s || this, TMP_51, TMP_52, $a, TMP_53, key_map = nil, $writer = nil, segments = nil, match = nil, author = nil, fname = nil, mname = nil, lname = nil;

        
          
          if (author_entry == null) {
            author_entry = nil;
          };
          if ($truthy(author_entry['$empty?']())) {
            return nil;};
          author_idx = $rb_plus(author_idx, 1);
          key_map = $hash2([], {});
          if (author_idx['$=='](1)) {
            $send(keys, 'each', [], (TMP_51 = function(key){var self = TMP_51.$$s || this, $writer = nil;

            
              
              if (key == null) {
                key = nil;
              };
              $writer = [key.$to_sym(), key];
              $send(key_map, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];}, TMP_51.$$s = self, TMP_51.$$arity = 1, TMP_51))
          } else {
            $send(keys, 'each', [], (TMP_52 = function(key){var self = TMP_52.$$s || this, $writer = nil;

            
              
              if (key == null) {
                key = nil;
              };
              $writer = [key.$to_sym(), "" + (key) + "_" + (author_idx)];
              $send(key_map, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];}, TMP_52.$$s = self, TMP_52.$$arity = 1, TMP_52))
          };
          if ($truthy(names_only)) {
            
            if ($truthy(author_entry['$include?']("<"))) {
              
              
              $writer = [key_map['$[]']("author"), author_entry.$tr("_", " ")];
              $send(author_metadata, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              author_entry = author_entry.$gsub($$($nesting, 'XmlSanitizeRx'), "");};
            if ((segments = author_entry.$split(nil, 3)).$size()['$=='](3)) {
              segments['$<<'](segments.$pop().$squeeze(" "))};
          } else if ($truthy((match = $$($nesting, 'AuthorInfoLineRx').$match(author_entry)))) {
            (segments = match.$to_a()).$shift()};
          if ($truthy(segments)) {
            
            author = (($writer = [key_map['$[]']("firstname"), (fname = segments['$[]'](0).$tr("_", " "))]), $send(author_metadata, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
            
            $writer = [key_map['$[]']("authorinitials"), fname.$chr()];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy(segments['$[]'](1))) {
              if ($truthy(segments['$[]'](2))) {
                
                
                $writer = [key_map['$[]']("middlename"), (mname = segments['$[]'](1).$tr("_", " "))];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                
                $writer = [key_map['$[]']("lastname"), (lname = segments['$[]'](2).$tr("_", " "))];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                author = $rb_plus($rb_plus($rb_plus($rb_plus(fname, " "), mname), " "), lname);
                
                $writer = [key_map['$[]']("authorinitials"), "" + (fname.$chr()) + (mname.$chr()) + (lname.$chr())];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
              } else {
                
                
                $writer = [key_map['$[]']("lastname"), (lname = segments['$[]'](1).$tr("_", " "))];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                author = $rb_plus($rb_plus(fname, " "), lname);
                
                $writer = [key_map['$[]']("authorinitials"), "" + (fname.$chr()) + (lname.$chr())];
                $send(author_metadata, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
              }};
            ($truthy($a = author_metadata['$[]'](key_map['$[]']("author"))) ? $a : (($writer = [key_map['$[]']("author"), author]), $send(author_metadata, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            if ($truthy(($truthy($a = names_only) ? $a : segments['$[]'](3)['$!']()))) {
            } else {
              
              $writer = [key_map['$[]']("email"), segments['$[]'](3)];
              $send(author_metadata, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          } else {
            
            
            $writer = [key_map['$[]']("author"), (($writer = [key_map['$[]']("firstname"), (fname = author_entry.$squeeze(" ").$strip())]), $send(author_metadata, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = [key_map['$[]']("authorinitials"), fname.$chr()];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          };
          if (author_idx['$=='](1)) {
            
            $writer = ["authors", author_metadata['$[]'](key_map['$[]']("author"))];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            
            if (author_idx['$=='](2)) {
              $send(keys, 'each', [], (TMP_53 = function(key){var self = TMP_53.$$s || this;

              
                
                if (key == null) {
                  key = nil;
                };
                if ($truthy(author_metadata['$key?'](key))) {
                  
                  $writer = ["" + (key) + "_1", author_metadata['$[]'](key)];
                  $send(author_metadata, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                } else {
                  return nil
                };}, TMP_53.$$s = self, TMP_53.$$arity = 1, TMP_53))};
            
            $writer = ["authors", "" + (author_metadata['$[]']("authors")) + ", " + (author_metadata['$[]'](key_map['$[]']("author")))];
            $send(author_metadata, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          };}, TMP_50.$$s = self, TMP_50.$$arity = 1, TMP_50));
        
        $writer = ["authorcount", author_idx];
        $send(author_metadata, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        return author_metadata;
      }, TMP_Parser_process_authors_48.$$arity = -2);
      Opal.defs(self, '$parse_block_metadata_lines', TMP_Parser_parse_block_metadata_lines_54 = function $$parse_block_metadata_lines(reader, document, attributes, options) {
        var $a, $b, self = this;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        
        if (options == null) {
          options = $hash2([], {});
        };
        while ($truthy(self.$parse_block_metadata_line(reader, document, attributes, options))) {
          
          reader.$shift();
          if ($truthy($b = reader.$skip_blank_lines())) {
            $b
          } else {
            break;
          };
        };
        return attributes;
      }, TMP_Parser_parse_block_metadata_lines_54.$$arity = -3);
      Opal.defs(self, '$parse_block_metadata_line', TMP_Parser_parse_block_metadata_line_55 = function $$parse_block_metadata_line(reader, document, attributes, options) {
        var $a, $b, self = this, next_line = nil, normal = nil, $writer = nil, reftext = nil, current_style = nil, ll = nil;
        if ($gvars["~"] == null) $gvars["~"] = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        if ($truthy(($truthy($a = (next_line = reader.$peek_line())) ? (function() {if ($truthy(options['$[]']("text"))) {
          
          return next_line['$start_with?']("[", "/");
        } else {
          
          return (normal = next_line['$start_with?']("[", ".", "/", ":"));
        }; return nil; })() : $a))) {
          if ($truthy(next_line['$start_with?']("["))) {
            if ($truthy(next_line['$start_with?']("[["))) {
              if ($truthy(($truthy($a = next_line['$end_with?']("]]")) ? $$($nesting, 'BlockAnchorRx')['$=~'](next_line) : $a))) {
                
                
                $writer = ["id", (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;
                if ($truthy((reftext = (($a = $gvars['~']) === nil ? nil : $a['$[]'](2))))) {
                  
                  $writer = ["reftext", (function() {if ($truthy(reftext['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
                    
                    return document.$sub_attributes(reftext);
                  } else {
                    return reftext
                  }; return nil; })()];
                  $send(attributes, '[]=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];};
                return true;
              } else {
                return nil
              }
            } else if ($truthy(($truthy($a = next_line['$end_with?']("]")) ? $$($nesting, 'BlockAttributeListRx')['$=~'](next_line) : $a))) {
              
              current_style = attributes['$[]'](1);
              if ($truthy(document.$parse_attributes((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), [], $hash2(["sub_input", "sub_result", "into"], {"sub_input": true, "sub_result": true, "into": attributes}))['$[]'](1))) {
                
                $writer = [1, ($truthy($a = self.$parse_style_attribute(attributes, reader)) ? $a : current_style)];
                $send(attributes, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              return true;
            } else {
              return nil
            }
          } else if ($truthy(($truthy($a = normal) ? next_line['$start_with?'](".") : $a))) {
            if ($truthy($$($nesting, 'BlockTitleRx')['$=~'](next_line))) {
              
              
              $writer = ["title", (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              return true;
            } else {
              return nil
            }
          } else if ($truthy(($truthy($a = normal['$!']()) ? $a : next_line['$start_with?']("/")))) {
            if ($truthy(next_line['$start_with?']("//"))) {
              if (next_line['$==']("//")) {
                return true
              } else if ($truthy(($truthy($a = normal) ? $rb_times("/", (ll = next_line.$length()))['$=='](next_line) : $a))) {
                if (ll['$=='](3)) {
                  return nil
                } else {
                  
                  reader.$read_lines_until($hash2(["terminator", "skip_first_line", "preserve_last_line", "skip_processing", "context"], {"terminator": next_line, "skip_first_line": true, "preserve_last_line": true, "skip_processing": true, "context": "comment"}));
                  return true;
                }
              } else if ($truthy(next_line['$start_with?']("///"))) {
                return nil
              } else {
                return true
              }
            } else {
              return nil
            }
          } else if ($truthy(($truthy($a = ($truthy($b = normal) ? next_line['$start_with?'](":") : $b)) ? $$($nesting, 'AttributeEntryRx')['$=~'](next_line) : $a))) {
            
            self.$process_attribute_entry(reader, document, attributes, $gvars["~"]);
            return true;
          } else {
            return nil
          }
        } else {
          return nil
        };
      }, TMP_Parser_parse_block_metadata_line_55.$$arity = -4);
      Opal.defs(self, '$process_attribute_entries', TMP_Parser_process_attribute_entries_56 = function $$process_attribute_entries(reader, document, attributes) {
        var $a, self = this;

        
        
        if (attributes == null) {
          attributes = nil;
        };
        reader.$skip_comment_lines();
        while ($truthy(self.$process_attribute_entry(reader, document, attributes))) {
          
          reader.$shift();
          reader.$skip_comment_lines();
        };
      }, TMP_Parser_process_attribute_entries_56.$$arity = -3);
      Opal.defs(self, '$process_attribute_entry', TMP_Parser_process_attribute_entry_57 = function $$process_attribute_entry(reader, document, attributes, match) {
        var $a, $b, $c, self = this, value = nil, con = nil, next_line = nil, keep_open = nil;

        
        
        if (attributes == null) {
          attributes = nil;
        };
        
        if (match == null) {
          match = nil;
        };
        if ($truthy((match = ($truthy($a = match) ? $a : (function() {if ($truthy(reader['$has_more_lines?']())) {
          
          return $$($nesting, 'AttributeEntryRx').$match(reader.$peek_line());
        } else {
          return nil
        }; return nil; })())))) {
          
          if ($truthy((value = match['$[]'](2))['$nil_or_empty?']())) {
            value = ""
          } else if ($truthy(value['$end_with?']($$($nesting, 'LINE_CONTINUATION'), $$($nesting, 'LINE_CONTINUATION_LEGACY')))) {
            
            $a = [value.$slice(-2, 2), value.$slice(0, $rb_minus(value.$length(), 2)).$rstrip()], (con = $a[0]), (value = $a[1]), $a;
            while ($truthy(($truthy($b = reader.$advance()) ? (next_line = ($truthy($c = reader.$peek_line()) ? $c : ""))['$empty?']()['$!']() : $b))) {
              
              next_line = next_line.$lstrip();
              if ($truthy((keep_open = next_line['$end_with?'](con)))) {
                next_line = next_line.$slice(0, $rb_minus(next_line.$length(), 2)).$rstrip()};
              value = "" + (value) + ((function() {if ($truthy(value['$end_with?']($$($nesting, 'HARD_LINE_BREAK')))) {
                return $$($nesting, 'LF')
              } else {
                return " "
              }; return nil; })()) + (next_line);
              if ($truthy(keep_open)) {
              } else {
                break;
              };
            };};
          self.$store_attribute(match['$[]'](1), value, document, attributes);
          return true;
        } else {
          return nil
        };
      }, TMP_Parser_process_attribute_entry_57.$$arity = -3);
      Opal.defs(self, '$store_attribute', TMP_Parser_store_attribute_58 = function $$store_attribute(name, value, doc, attrs) {
        var $a, self = this, resolved_value = nil;

        
        
        if (doc == null) {
          doc = nil;
        };
        
        if (attrs == null) {
          attrs = nil;
        };
        if ($truthy(name['$end_with?']("!"))) {
          $a = [name.$chop(), nil], (name = $a[0]), (value = $a[1]), $a
        } else if ($truthy(name['$start_with?']("!"))) {
          $a = [name.$slice(1, name.$length()), nil], (name = $a[0]), (value = $a[1]), $a};
        name = self.$sanitize_attribute_name(name);
        if (name['$==']("numbered")) {
          name = "sectnums"};
        if ($truthy(doc)) {
          if ($truthy(value)) {
            
            if (name['$==']("leveloffset")) {
              if ($truthy(value['$start_with?']("+"))) {
                value = $rb_plus(doc.$attr("leveloffset", 0).$to_i(), value.$slice(1, value.$length()).$to_i()).$to_s()
              } else if ($truthy(value['$start_with?']("-"))) {
                value = $rb_minus(doc.$attr("leveloffset", 0).$to_i(), value.$slice(1, value.$length()).$to_i()).$to_s()}};
            if ($truthy((resolved_value = doc.$set_attribute(name, value)))) {
              
              value = resolved_value;
              if ($truthy(attrs)) {
                $$$($$($nesting, 'Document'), 'AttributeEntry').$new(name, value).$save_to(attrs)};};
          } else if ($truthy(($truthy($a = doc.$delete_attribute(name)) ? attrs : $a))) {
            $$$($$($nesting, 'Document'), 'AttributeEntry').$new(name, value).$save_to(attrs)}
        } else if ($truthy(attrs)) {
          $$$($$($nesting, 'Document'), 'AttributeEntry').$new(name, value).$save_to(attrs)};
        return [name, value];
      }, TMP_Parser_store_attribute_58.$$arity = -3);
      Opal.defs(self, '$resolve_list_marker', TMP_Parser_resolve_list_marker_59 = function $$resolve_list_marker(list_type, marker, ordinal, validate, reader) {
        var self = this;

        
        
        if (ordinal == null) {
          ordinal = 0;
        };
        
        if (validate == null) {
          validate = false;
        };
        
        if (reader == null) {
          reader = nil;
        };
        if (list_type['$==']("ulist")) {
          return marker
        } else if (list_type['$==']("olist")) {
          return self.$resolve_ordered_list_marker(marker, ordinal, validate, reader)['$[]'](0)
        } else {
          return "<1>"
        };
      }, TMP_Parser_resolve_list_marker_59.$$arity = -3);
      Opal.defs(self, '$resolve_ordered_list_marker', TMP_Parser_resolve_ordered_list_marker_60 = function $$resolve_ordered_list_marker(marker, ordinal, validate, reader) {
        var TMP_61, $a, self = this, $case = nil, style = nil, expected = nil, actual = nil;

        
        
        if (ordinal == null) {
          ordinal = 0;
        };
        
        if (validate == null) {
          validate = false;
        };
        
        if (reader == null) {
          reader = nil;
        };
        if ($truthy(marker['$start_with?']("."))) {
          return [marker]};
        $case = (style = $send($$($nesting, 'ORDERED_LIST_STYLES'), 'find', [], (TMP_61 = function(s){var self = TMP_61.$$s || this;

        
          
          if (s == null) {
            s = nil;
          };
          return $$($nesting, 'OrderedListMarkerRxMap')['$[]'](s)['$match?'](marker);}, TMP_61.$$s = self, TMP_61.$$arity = 1, TMP_61)));
        if ("arabic"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $rb_plus(ordinal, 1);
          actual = marker.$to_i();};
        marker = "1.";}
        else if ("loweralpha"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $rb_plus("a"['$[]'](0).$ord(), ordinal).$chr();
          actual = marker.$chop();};
        marker = "a.";}
        else if ("upperalpha"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $rb_plus("A"['$[]'](0).$ord(), ordinal).$chr();
          actual = marker.$chop();};
        marker = "A.";}
        else if ("lowerroman"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $$($nesting, 'Helpers').$int_to_roman($rb_plus(ordinal, 1)).$downcase();
          actual = marker.$chop();};
        marker = "i)";}
        else if ("upperroman"['$===']($case)) {
        if ($truthy(validate)) {
          
          expected = $$($nesting, 'Helpers').$int_to_roman($rb_plus(ordinal, 1));
          actual = marker.$chop();};
        marker = "I)";};
        if ($truthy(($truthy($a = validate) ? expected['$!='](actual) : $a))) {
          self.$logger().$warn(self.$message_with_context("" + "list item index: expected " + (expected) + ", got " + (actual), $hash2(["source_location"], {"source_location": reader.$cursor()})))};
        return [marker, style];
      }, TMP_Parser_resolve_ordered_list_marker_60.$$arity = -2);
      Opal.defs(self, '$is_sibling_list_item?', TMP_Parser_is_sibling_list_item$q_62 = function(line, list_type, sibling_trait) {
        var $a, self = this, matcher = nil, expected_marker = nil;

        
        if ($truthy($$$('::', 'Regexp')['$==='](sibling_trait))) {
          matcher = sibling_trait
        } else {
          
          matcher = $$($nesting, 'ListRxMap')['$[]'](list_type);
          expected_marker = sibling_trait;
        };
        if ($truthy(matcher['$=~'](line))) {
          if ($truthy(expected_marker)) {
            return expected_marker['$=='](self.$resolve_list_marker(list_type, (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))))
          } else {
            return true
          }
        } else {
          return false
        };
      }, TMP_Parser_is_sibling_list_item$q_62.$$arity = 3);
      Opal.defs(self, '$parse_table', TMP_Parser_parse_table_63 = function $$parse_table(table_reader, parent, attributes) {
        var $a, $b, $c, $d, self = this, table = nil, $writer = nil, colspecs = nil, explicit_colspecs = nil, skipped = nil, parser_ctx = nil, format = nil, loop_idx = nil, implicit_header_boundary = nil, implicit_header = nil, line = nil, beyond_first = nil, next_cellspec = nil, m = nil, pre_match = nil, post_match = nil, $case = nil, cell_text = nil, $logical_op_recvr_tmp_2 = nil;

        
        table = $$($nesting, 'Table').$new(parent, attributes);
        if ($truthy(attributes['$key?']("title"))) {
          
          
          $writer = [attributes.$delete("title")];
          $send(table, 'title=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          table.$assign_caption(attributes.$delete("caption"));};
        if ($truthy(($truthy($a = attributes['$key?']("cols")) ? (colspecs = self.$parse_colspecs(attributes['$[]']("cols")))['$empty?']()['$!']() : $a))) {
          
          table.$create_columns(colspecs);
          explicit_colspecs = true;};
        skipped = ($truthy($a = table_reader.$skip_blank_lines()) ? $a : 0);
        parser_ctx = $$$($$($nesting, 'Table'), 'ParserContext').$new(table_reader, table, attributes);
        $a = [parser_ctx.$format(), -1, nil], (format = $a[0]), (loop_idx = $a[1]), (implicit_header_boundary = $a[2]), $a;
        if ($truthy(($truthy($a = ($truthy($b = $rb_gt(skipped, 0)) ? $b : attributes['$key?']("header-option"))) ? $a : attributes['$key?']("noheader-option")))) {
        } else {
          implicit_header = true
        };
        $a = false; while ($a || $truthy((line = table_reader.$read_line()))) {$a = false;
          
          if ($truthy(($truthy($b = (beyond_first = $rb_gt((loop_idx = $rb_plus(loop_idx, 1)), 0))) ? line['$empty?']() : $b))) {
            
            line = nil;
            if ($truthy(implicit_header_boundary)) {
              implicit_header_boundary = $rb_plus(implicit_header_boundary, 1)};
          } else if (format['$==']("psv")) {
            if ($truthy(parser_ctx['$starts_with_delimiter?'](line))) {
              
              line = line.$slice(1, line.$length());
              parser_ctx.$close_open_cell();
              if ($truthy(implicit_header_boundary)) {
                implicit_header_boundary = nil};
            } else {
              
              $c = self.$parse_cellspec(line, "start", parser_ctx.$delimiter()), $b = Opal.to_ary($c), (next_cellspec = ($b[0] == null ? nil : $b[0])), (line = ($b[1] == null ? nil : $b[1])), $c;
              if ($truthy(next_cellspec)) {
                
                parser_ctx.$close_open_cell(next_cellspec);
                if ($truthy(implicit_header_boundary)) {
                  implicit_header_boundary = nil};
              } else if ($truthy(($truthy($b = implicit_header_boundary) ? implicit_header_boundary['$=='](loop_idx) : $b))) {
                $b = [false, nil], (implicit_header = $b[0]), (implicit_header_boundary = $b[1]), $b};
            }};
          if ($truthy(beyond_first)) {
          } else {
            
            table_reader.$mark();
            if ($truthy(implicit_header)) {
              if ($truthy(($truthy($b = table_reader['$has_more_lines?']()) ? table_reader.$peek_line()['$empty?']() : $b))) {
                implicit_header_boundary = 1
              } else {
                implicit_header = false
              }};
          };
          $b = false; while ($b || $truthy(true)) {$b = false;
            if ($truthy(($truthy($c = line) ? (m = parser_ctx.$match_delimiter(line)) : $c))) {
              
              $c = [m.$pre_match(), m.$post_match()], (pre_match = $c[0]), (post_match = $c[1]), $c;
              $case = format;
              if ("csv"['$===']($case)) {
              if ($truthy(parser_ctx['$buffer_has_unclosed_quotes?'](pre_match))) {
                
                parser_ctx.$skip_past_delimiter(pre_match);
                if ($truthy((line = post_match)['$empty?']())) {
                  break;};
                $b = true; continue;;};
              
              $writer = ["" + (parser_ctx.$buffer()) + (pre_match)];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;}
              else if ("dsv"['$===']($case)) {
              if ($truthy(pre_match['$end_with?']("\\"))) {
                
                parser_ctx.$skip_past_escaped_delimiter(pre_match);
                if ($truthy((line = post_match)['$empty?']())) {
                  
                  
                  $writer = ["" + (parser_ctx.$buffer()) + ($$($nesting, 'LF'))];
                  $send(parser_ctx, 'buffer=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                  parser_ctx.$keep_cell_open();
                  break;;};
                $b = true; continue;;};
              
              $writer = ["" + (parser_ctx.$buffer()) + (pre_match)];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;}
              else {
              if ($truthy(pre_match['$end_with?']("\\"))) {
                
                parser_ctx.$skip_past_escaped_delimiter(pre_match);
                if ($truthy((line = post_match)['$empty?']())) {
                  
                  
                  $writer = ["" + (parser_ctx.$buffer()) + ($$($nesting, 'LF'))];
                  $send(parser_ctx, 'buffer=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                  parser_ctx.$keep_cell_open();
                  break;;};
                $b = true; continue;;};
              $d = self.$parse_cellspec(pre_match), $c = Opal.to_ary($d), (next_cellspec = ($c[0] == null ? nil : $c[0])), (cell_text = ($c[1] == null ? nil : $c[1])), $d;
              parser_ctx.$push_cellspec(next_cellspec);
              
              $writer = ["" + (parser_ctx.$buffer()) + (cell_text)];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
              if ($truthy((line = post_match)['$empty?']())) {
                line = nil};
              parser_ctx.$close_cell();
            } else {
              
              
              $writer = ["" + (parser_ctx.$buffer()) + (line) + ($$($nesting, 'LF'))];
              $send(parser_ctx, 'buffer=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              $case = format;
              if ("csv"['$===']($case)) {if ($truthy(parser_ctx['$buffer_has_unclosed_quotes?']())) {
                
                if ($truthy(($truthy($c = implicit_header_boundary) ? loop_idx['$=='](0) : $c))) {
                  $c = [false, nil], (implicit_header = $c[0]), (implicit_header_boundary = $c[1]), $c};
                parser_ctx.$keep_cell_open();
              } else {
                parser_ctx.$close_cell(true)
              }}
              else if ("dsv"['$===']($case)) {parser_ctx.$close_cell(true)}
              else {parser_ctx.$keep_cell_open()};
              break;;
            }
          };
          if ($truthy(parser_ctx['$cell_open?']())) {
            if ($truthy(table_reader['$has_more_lines?']())) {
            } else {
              parser_ctx.$close_cell(true)
            }
          } else {
            if ($truthy($b = table_reader.$skip_blank_lines())) {
              $b
            } else {
              break;
            }
          };
        };
        if ($truthy(($truthy($a = (($logical_op_recvr_tmp_2 = table.$attributes()), ($truthy($b = $logical_op_recvr_tmp_2['$[]']("colcount")) ? $b : (($writer = ["colcount", table.$columns().$size()]), $send($logical_op_recvr_tmp_2, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])))['$=='](0)) ? $a : explicit_colspecs))) {
        } else {
          table.$assign_column_widths()
        };
        if ($truthy(implicit_header)) {
          
          
          $writer = [true];
          $send(table, 'has_header_option=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["header-option", ""];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          
          $writer = ["options", (function() {if ($truthy(attributes['$key?']("options"))) {
            return "" + (attributes['$[]']("options")) + ",header"
          } else {
            return "header"
          }; return nil; })()];
          $send(attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;};
        table.$partition_header_footer(attributes);
        return table;
      }, TMP_Parser_parse_table_63.$$arity = 3);
      Opal.defs(self, '$parse_colspecs', TMP_Parser_parse_colspecs_64 = function $$parse_colspecs(records) {
        var TMP_65, TMP_66, self = this, specs = nil;

        
        if ($truthy(records['$include?'](" "))) {
          records = records.$delete(" ")};
        if (records['$=='](records.$to_i().$to_s())) {
          return $send($$$('::', 'Array'), 'new', [records.$to_i()], (TMP_65 = function(){var self = TMP_65.$$s || this;

          return $hash2(["width"], {"width": 1})}, TMP_65.$$s = self, TMP_65.$$arity = 0, TMP_65))};
        specs = [];
        $send((function() {if ($truthy(records['$include?'](","))) {
          
          return records.$split(",", -1);
        } else {
          
          return records.$split(";", -1);
        }; return nil; })(), 'each', [], (TMP_66 = function(record){var self = TMP_66.$$s || this, $a, $b, TMP_67, m = nil, spec = nil, colspec = nil, rowspec = nil, $writer = nil, width = nil;

        
          
          if (record == null) {
            record = nil;
          };
          if ($truthy(record['$empty?']())) {
            return specs['$<<']($hash2(["width"], {"width": 1}))
          } else if ($truthy((m = $$($nesting, 'ColumnSpecRx').$match(record)))) {
            
            spec = $hash2([], {});
            if ($truthy(m['$[]'](2))) {
              
              $b = m['$[]'](2).$split("."), $a = Opal.to_ary($b), (colspec = ($a[0] == null ? nil : $a[0])), (rowspec = ($a[1] == null ? nil : $a[1])), $b;
              if ($truthy(($truthy($a = colspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellHorzAlignments')['$key?'](colspec) : $a))) {
                
                $writer = ["halign", $$($nesting, 'TableCellHorzAlignments')['$[]'](colspec)];
                $send(spec, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};
              if ($truthy(($truthy($a = rowspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellVertAlignments')['$key?'](rowspec) : $a))) {
                
                $writer = ["valign", $$($nesting, 'TableCellVertAlignments')['$[]'](rowspec)];
                $send(spec, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];};};
            if ($truthy((width = m['$[]'](3)))) {
              
              $writer = ["width", (function() {if (width['$==']("~")) {
                return -1
              } else {
                return width.$to_i()
              }; return nil; })()];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              
              $writer = ["width", 1];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            if ($truthy(($truthy($a = m['$[]'](4)) ? $$($nesting, 'TableCellStyles')['$key?'](m['$[]'](4)) : $a))) {
              
              $writer = ["style", $$($nesting, 'TableCellStyles')['$[]'](m['$[]'](4))];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(m['$[]'](1))) {
              return $send((1), 'upto', [m['$[]'](1).$to_i()], (TMP_67 = function(){var self = TMP_67.$$s || this;

              return specs['$<<'](spec.$dup())}, TMP_67.$$s = self, TMP_67.$$arity = 0, TMP_67))
            } else {
              return specs['$<<'](spec)
            };
          } else {
            return nil
          };}, TMP_66.$$s = self, TMP_66.$$arity = 1, TMP_66));
        return specs;
      }, TMP_Parser_parse_colspecs_64.$$arity = 1);
      Opal.defs(self, '$parse_cellspec', TMP_Parser_parse_cellspec_68 = function $$parse_cellspec(line, pos, delimiter) {
        var $a, $b, self = this, m = nil, rest = nil, spec_part = nil, spec = nil, colspec = nil, rowspec = nil, $writer = nil;

        
        
        if (pos == null) {
          pos = "end";
        };
        
        if (delimiter == null) {
          delimiter = nil;
        };
        $a = [nil, ""], (m = $a[0]), (rest = $a[1]), $a;
        if (pos['$==']("start")) {
          if ($truthy(line['$include?'](delimiter))) {
            
            $b = line.$split(delimiter, 2), $a = Opal.to_ary($b), (spec_part = ($a[0] == null ? nil : $a[0])), (rest = ($a[1] == null ? nil : $a[1])), $b;
            if ($truthy((m = $$($nesting, 'CellSpecStartRx').$match(spec_part)))) {
              if ($truthy(m['$[]'](0)['$empty?']())) {
                return [$hash2([], {}), rest]}
            } else {
              return [nil, line]
            };
          } else {
            return [nil, line]
          }
        } else if ($truthy((m = $$($nesting, 'CellSpecEndRx').$match(line)))) {
          
          if ($truthy(m['$[]'](0).$lstrip()['$empty?']())) {
            return [$hash2([], {}), line.$rstrip()]};
          rest = m.$pre_match();
        } else {
          return [$hash2([], {}), line]
        };
        spec = $hash2([], {});
        if ($truthy(m['$[]'](1))) {
          
          $b = m['$[]'](1).$split("."), $a = Opal.to_ary($b), (colspec = ($a[0] == null ? nil : $a[0])), (rowspec = ($a[1] == null ? nil : $a[1])), $b;
          colspec = (function() {if ($truthy(colspec['$nil_or_empty?']())) {
            return 1
          } else {
            return colspec.$to_i()
          }; return nil; })();
          rowspec = (function() {if ($truthy(rowspec['$nil_or_empty?']())) {
            return 1
          } else {
            return rowspec.$to_i()
          }; return nil; })();
          if (m['$[]'](2)['$==']("+")) {
            
            if (colspec['$=='](1)) {
            } else {
              
              $writer = ["colspan", colspec];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
            if (rowspec['$=='](1)) {
            } else {
              
              $writer = ["rowspan", rowspec];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            };
          } else if (m['$[]'](2)['$==']("*")) {
            if (colspec['$=='](1)) {
            } else {
              
              $writer = ["repeatcol", colspec];
              $send(spec, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }};};
        if ($truthy(m['$[]'](3))) {
          
          $b = m['$[]'](3).$split("."), $a = Opal.to_ary($b), (colspec = ($a[0] == null ? nil : $a[0])), (rowspec = ($a[1] == null ? nil : $a[1])), $b;
          if ($truthy(($truthy($a = colspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellHorzAlignments')['$key?'](colspec) : $a))) {
            
            $writer = ["halign", $$($nesting, 'TableCellHorzAlignments')['$[]'](colspec)];
            $send(spec, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy(($truthy($a = rowspec['$nil_or_empty?']()['$!']()) ? $$($nesting, 'TableCellVertAlignments')['$key?'](rowspec) : $a))) {
            
            $writer = ["valign", $$($nesting, 'TableCellVertAlignments')['$[]'](rowspec)];
            $send(spec, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};};
        if ($truthy(($truthy($a = m['$[]'](4)) ? $$($nesting, 'TableCellStyles')['$key?'](m['$[]'](4)) : $a))) {
          
          $writer = ["style", $$($nesting, 'TableCellStyles')['$[]'](m['$[]'](4))];
          $send(spec, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        return [spec, rest];
      }, TMP_Parser_parse_cellspec_68.$$arity = -2);
      Opal.defs(self, '$parse_style_attribute', TMP_Parser_parse_style_attribute_69 = function $$parse_style_attribute(attributes, reader) {
        var $a, $b, TMP_70, TMP_71, TMP_72, self = this, raw_style = nil, type = nil, collector = nil, parsed = nil, save_current = nil, $writer = nil, parsed_style = nil, existing_role = nil, opts = nil, existing_opts = nil;

        
        
        if (reader == null) {
          reader = nil;
        };
        if ($truthy(($truthy($a = ($truthy($b = (raw_style = attributes['$[]'](1))) ? raw_style['$include?'](" ")['$!']() : $b)) ? $$($nesting, 'Compliance').$shorthand_property_syntax() : $a))) {
          
          $a = ["style", [], $hash2([], {})], (type = $a[0]), (collector = $a[1]), (parsed = $a[2]), $a;
          save_current = $send(self, 'lambda', [], (TMP_70 = function(){var self = TMP_70.$$s || this, $c, $case = nil, $writer = nil;

          if ($truthy(collector['$empty?']())) {
              if (type['$==']("style")) {
                return nil
              } else if ($truthy(reader)) {
                return self.$logger().$warn(self.$message_with_context("" + "invalid empty " + (type) + " detected in style attribute", $hash2(["source_location"], {"source_location": reader.$cursor_at_prev_line()})))
              } else {
                return self.$logger().$warn("" + "invalid empty " + (type) + " detected in style attribute")
              }
            } else {
              
              $case = type;
              if ("role"['$===']($case) || "option"['$===']($case)) {($truthy($c = parsed['$[]'](type)) ? $c : (($writer = [type, []]), $send(parsed, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))['$<<'](collector.$join())}
              else if ("id"['$===']($case)) {
              if ($truthy(parsed['$key?']("id"))) {
                if ($truthy(reader)) {
                  self.$logger().$warn(self.$message_with_context("multiple ids detected in style attribute", $hash2(["source_location"], {"source_location": reader.$cursor_at_prev_line()})))
                } else {
                  self.$logger().$warn("multiple ids detected in style attribute")
                }};
              
              $writer = [type, collector.$join()];
              $send(parsed, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;}
              else {
              $writer = [type, collector.$join()];
              $send(parsed, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
              return (collector = []);
            }}, TMP_70.$$s = self, TMP_70.$$arity = 0, TMP_70));
          $send(raw_style, 'each_char', [], (TMP_71 = function(c){var self = TMP_71.$$s || this, $c, $d, $case = nil;

          
            
            if (c == null) {
              c = nil;
            };
            if ($truthy(($truthy($c = ($truthy($d = c['$=='](".")) ? $d : c['$==']("#"))) ? $c : c['$==']("%")))) {
              
              save_current.$call();
              return (function() {$case = c;
              if ("."['$===']($case)) {return (type = "role")}
              else if ("#"['$===']($case)) {return (type = "id")}
              else if ("%"['$===']($case)) {return (type = "option")}
              else { return nil }})();
            } else {
              return collector['$<<'](c)
            };}, TMP_71.$$s = self, TMP_71.$$arity = 1, TMP_71));
          if (type['$==']("style")) {
            
            $writer = ["style", raw_style];
            $send(attributes, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          } else {
            
            save_current.$call();
            if ($truthy(parsed['$key?']("style"))) {
              parsed_style = (($writer = ["style", parsed['$[]']("style")]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])};
            if ($truthy(parsed['$key?']("id"))) {
              
              $writer = ["id", parsed['$[]']("id")];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(parsed['$key?']("role"))) {
              
              $writer = ["role", (function() {if ($truthy((existing_role = attributes['$[]']("role"))['$nil_or_empty?']())) {
                
                return parsed['$[]']("role").$join(" ");
              } else {
                return "" + (existing_role) + " " + (parsed['$[]']("role").$join(" "))
              }; return nil; })()];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
            if ($truthy(parsed['$key?']("option"))) {
              
              $send((opts = parsed['$[]']("option")), 'each', [], (TMP_72 = function(opt){var self = TMP_72.$$s || this;

              
                
                if (opt == null) {
                  opt = nil;
                };
                $writer = ["" + (opt) + "-option", ""];
                $send(attributes, '[]=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];}, TMP_72.$$s = self, TMP_72.$$arity = 1, TMP_72));
              
              $writer = ["options", (function() {if ($truthy((existing_opts = attributes['$[]']("options"))['$nil_or_empty?']())) {
                
                return opts.$join(",");
              } else {
                return "" + (existing_opts) + "," + (opts.$join(","))
              }; return nil; })()];
              $send(attributes, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
            return parsed_style;
          };
        } else {
          
          $writer = ["style", raw_style];
          $send(attributes, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        };
      }, TMP_Parser_parse_style_attribute_69.$$arity = -2);
      Opal.defs(self, '$adjust_indentation!', TMP_Parser_adjust_indentation$B_73 = function(lines, indent, tab_size) {
        var $a, TMP_74, TMP_77, TMP_78, TMP_79, TMP_80, self = this, full_tab_space = nil, gutter_width = nil, padding = nil;

        
        
        if (indent == null) {
          indent = 0;
        };
        
        if (tab_size == null) {
          tab_size = 0;
        };
        if ($truthy(lines['$empty?']())) {
          return nil};
        if ($truthy(($truthy($a = $rb_gt((tab_size = tab_size.$to_i()), 0)) ? lines.$join()['$include?']($$($nesting, 'TAB')) : $a))) {
          
          full_tab_space = $rb_times(" ", tab_size);
          $send(lines, 'map!', [], (TMP_74 = function(line){var self = TMP_74.$$s || this, TMP_75, TMP_76, spaces_added = nil;

          
            
            if (line == null) {
              line = nil;
            };
            if ($truthy(line['$empty?']())) {
              return line;};
            if ($truthy(line['$start_with?']($$($nesting, 'TAB')))) {
              line = $send(line, 'sub', [$$($nesting, 'TabIndentRx')], (TMP_75 = function(){var self = TMP_75.$$s || this, $b;

              return $rb_times(full_tab_space, (($b = $gvars['~']) === nil ? nil : $b['$[]'](0)).$length())}, TMP_75.$$s = self, TMP_75.$$arity = 0, TMP_75))};
            if ($truthy(line['$include?']($$($nesting, 'TAB')))) {
              
              spaces_added = 0;
              return line = $send(line, 'gsub', [$$($nesting, 'TabRx')], (TMP_76 = function(){var self = TMP_76.$$s || this, offset = nil, spaces = nil;
                if ($gvars["~"] == null) $gvars["~"] = nil;

              if ((offset = $rb_plus($gvars["~"].$begin(0), spaces_added))['$%'](tab_size)['$=='](0)) {
                  
                  spaces_added = $rb_plus(spaces_added, $rb_minus(tab_size, 1));
                  return full_tab_space;
                } else {
                  
                  if ((spaces = $rb_minus(tab_size, offset['$%'](tab_size)))['$=='](1)) {
                  } else {
                    spaces_added = $rb_plus(spaces_added, $rb_minus(spaces, 1))
                  };
                  return $rb_times(" ", spaces);
                }}, TMP_76.$$s = self, TMP_76.$$arity = 0, TMP_76));
            } else {
              return line
            };}, TMP_74.$$s = self, TMP_74.$$arity = 1, TMP_74));};
        if ($truthy(($truthy($a = indent) ? $rb_gt((indent = indent.$to_i()), -1) : $a))) {
        } else {
          return nil
        };
        gutter_width = nil;
        (function(){var $brk = Opal.new_brk(); try {return $send(lines, 'each', [], (TMP_77 = function(line){var self = TMP_77.$$s || this, $b, line_indent = nil;

        
          
          if (line == null) {
            line = nil;
          };
          if ($truthy(line['$empty?']())) {
            return nil;};
          if ((line_indent = $rb_minus(line.$length(), line.$lstrip().$length()))['$=='](0)) {
            
            gutter_width = nil;
            
            Opal.brk(nil, $brk);
          } else if ($truthy(($truthy($b = gutter_width) ? $rb_gt(line_indent, gutter_width) : $b))) {
            return nil
          } else {
            return (gutter_width = line_indent)
          };}, TMP_77.$$s = self, TMP_77.$$brk = $brk, TMP_77.$$arity = 1, TMP_77))
        } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();
        if (indent['$=='](0)) {
          if ($truthy(gutter_width)) {
            $send(lines, 'map!', [], (TMP_78 = function(line){var self = TMP_78.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              if ($truthy(line['$empty?']())) {
                return line
              } else {
                
                return line.$slice(gutter_width, line.$length());
              };}, TMP_78.$$s = self, TMP_78.$$arity = 1, TMP_78))}
        } else {
          
          padding = $rb_times(" ", indent);
          if ($truthy(gutter_width)) {
            $send(lines, 'map!', [], (TMP_79 = function(line){var self = TMP_79.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              if ($truthy(line['$empty?']())) {
                return line
              } else {
                return $rb_plus(padding, line.$slice(gutter_width, line.$length()))
              };}, TMP_79.$$s = self, TMP_79.$$arity = 1, TMP_79))
          } else {
            $send(lines, 'map!', [], (TMP_80 = function(line){var self = TMP_80.$$s || this;

            
              
              if (line == null) {
                line = nil;
              };
              if ($truthy(line['$empty?']())) {
                return line
              } else {
                return $rb_plus(padding, line)
              };}, TMP_80.$$s = self, TMP_80.$$arity = 1, TMP_80))
          };
        };
        return nil;
      }, TMP_Parser_adjust_indentation$B_73.$$arity = -2);
      return (Opal.defs(self, '$sanitize_attribute_name', TMP_Parser_sanitize_attribute_name_81 = function $$sanitize_attribute_name(name) {
        var self = this;

        return name.$gsub($$($nesting, 'InvalidAttributeNameCharsRx'), "").$downcase()
      }, TMP_Parser_sanitize_attribute_name_81.$$arity = 1), nil) && 'sanitize_attribute_name';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/path_resolver"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy, $hash2 = Opal.hash2, $send = Opal.send;

  Opal.add_stubs(['$include', '$attr_accessor', '$root?', '$posixify', '$expand_path', '$pwd', '$start_with?', '$==', '$match?', '$absolute_path?', '$+', '$length', '$descends_from?', '$slice', '$to_s', '$relative_path_from', '$new', '$include?', '$tr', '$partition_path', '$each', '$pop', '$<<', '$join_path', '$[]', '$web_root?', '$unc?', '$index', '$split', '$delete', '$[]=', '$-', '$join', '$raise', '$!', '$fetch', '$warn', '$logger', '$empty?', '$nil_or_empty?', '$chomp', '$!=', '$>', '$size', '$end_with?', '$uri_prefix', '$gsub']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $PathResolver(){};
      var self = $PathResolver = $klass($base, $super, 'PathResolver', $PathResolver);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_PathResolver_initialize_1, TMP_PathResolver_absolute_path$q_2, $a, TMP_PathResolver_root$q_3, TMP_PathResolver_unc$q_4, TMP_PathResolver_web_root$q_5, TMP_PathResolver_descends_from$q_6, TMP_PathResolver_relative_path_7, TMP_PathResolver_posixify_8, TMP_PathResolver_expand_path_9, TMP_PathResolver_partition_path_11, TMP_PathResolver_join_path_12, TMP_PathResolver_system_path_13, TMP_PathResolver_web_path_16;

      def.file_separator = def._partition_path_web = def._partition_path_sys = def.working_dir = nil;
      
      self.$include($$($nesting, 'Logging'));
      Opal.const_set($nesting[0], 'DOT', ".");
      Opal.const_set($nesting[0], 'DOT_DOT', "..");
      Opal.const_set($nesting[0], 'DOT_SLASH', "./");
      Opal.const_set($nesting[0], 'SLASH', "/");
      Opal.const_set($nesting[0], 'BACKSLASH', "\\");
      Opal.const_set($nesting[0], 'DOUBLE_SLASH', "//");
      Opal.const_set($nesting[0], 'WindowsRootRx', /^(?:[a-zA-Z]:)?[\\\/]/);
      self.$attr_accessor("file_separator");
      self.$attr_accessor("working_dir");
      
      Opal.def(self, '$initialize', TMP_PathResolver_initialize_1 = function $$initialize(file_separator, working_dir) {
        var $a, $b, self = this;

        
        
        if (file_separator == null) {
          file_separator = nil;
        };
        
        if (working_dir == null) {
          working_dir = nil;
        };
        self.file_separator = ($truthy($a = ($truthy($b = file_separator) ? $b : $$$($$$('::', 'File'), 'ALT_SEPARATOR'))) ? $a : $$$($$$('::', 'File'), 'SEPARATOR'));
        self.working_dir = (function() {if ($truthy(working_dir)) {
          
          if ($truthy(self['$root?'](working_dir))) {
            
            return self.$posixify(working_dir);
          } else {
            
            return $$$('::', 'File').$expand_path(working_dir);
          };
        } else {
          return $$$('::', 'Dir').$pwd()
        }; return nil; })();
        self._partition_path_sys = $hash2([], {});
        return (self._partition_path_web = $hash2([], {}));
      }, TMP_PathResolver_initialize_1.$$arity = -1);
      
      Opal.def(self, '$absolute_path?', TMP_PathResolver_absolute_path$q_2 = function(path) {
        var $a, $b, self = this;

        return ($truthy($a = path['$start_with?']($$($nesting, 'SLASH'))) ? $a : (($b = self.file_separator['$==']($$($nesting, 'BACKSLASH'))) ? $$($nesting, 'WindowsRootRx')['$match?'](path) : self.file_separator['$==']($$($nesting, 'BACKSLASH'))))
      }, TMP_PathResolver_absolute_path$q_2.$$arity = 1);
      if ($truthy((($a = $$($nesting, 'RUBY_ENGINE')['$==']("opal")) ? $$$('::', 'JAVASCRIPT_IO_MODULE')['$==']("xmlhttprequest") : $$($nesting, 'RUBY_ENGINE')['$==']("opal")))) {
        
        Opal.def(self, '$root?', TMP_PathResolver_root$q_3 = function(path) {
          var $a, self = this;

          return ($truthy($a = self['$absolute_path?'](path)) ? $a : path['$start_with?']("file://", "http://", "https://"))
        }, TMP_PathResolver_root$q_3.$$arity = 1)
      } else {
        Opal.alias(self, "root?", "absolute_path?")
      };
      
      Opal.def(self, '$unc?', TMP_PathResolver_unc$q_4 = function(path) {
        var self = this;

        return path['$start_with?']($$($nesting, 'DOUBLE_SLASH'))
      }, TMP_PathResolver_unc$q_4.$$arity = 1);
      
      Opal.def(self, '$web_root?', TMP_PathResolver_web_root$q_5 = function(path) {
        var self = this;

        return path['$start_with?']($$($nesting, 'SLASH'))
      }, TMP_PathResolver_web_root$q_5.$$arity = 1);
      
      Opal.def(self, '$descends_from?', TMP_PathResolver_descends_from$q_6 = function(path, base) {
        var $a, self = this;

        if (base['$=='](path)) {
          return 0
        } else if (base['$==']($$($nesting, 'SLASH'))) {
          return ($truthy($a = path['$start_with?']($$($nesting, 'SLASH'))) ? 1 : $a)
        } else {
          return ($truthy($a = path['$start_with?']($rb_plus(base, $$($nesting, 'SLASH')))) ? $rb_plus(base.$length(), 1) : $a)
        }
      }, TMP_PathResolver_descends_from$q_6.$$arity = 2);
      
      Opal.def(self, '$relative_path', TMP_PathResolver_relative_path_7 = function $$relative_path(path, base) {
        var self = this, offset = nil;

        if ($truthy(self['$root?'](path))) {
          if ($truthy((offset = self['$descends_from?'](path, base)))) {
            return path.$slice(offset, path.$length())
          } else {
            return $$($nesting, 'Pathname').$new(path).$relative_path_from($$($nesting, 'Pathname').$new(base)).$to_s()
          }
        } else {
          return path
        }
      }, TMP_PathResolver_relative_path_7.$$arity = 2);
      
      Opal.def(self, '$posixify', TMP_PathResolver_posixify_8 = function $$posixify(path) {
        var $a, self = this;

        if ($truthy(path)) {
          if ($truthy((($a = self.file_separator['$==']($$($nesting, 'BACKSLASH'))) ? path['$include?']($$($nesting, 'BACKSLASH')) : self.file_separator['$==']($$($nesting, 'BACKSLASH'))))) {
            
            return path.$tr($$($nesting, 'BACKSLASH'), $$($nesting, 'SLASH'));
          } else {
            return path
          }
        } else {
          return ""
        }
      }, TMP_PathResolver_posixify_8.$$arity = 1);
      Opal.alias(self, "posixfy", "posixify");
      
      Opal.def(self, '$expand_path', TMP_PathResolver_expand_path_9 = function $$expand_path(path) {
        var $a, $b, TMP_10, self = this, path_segments = nil, path_root = nil, resolved_segments = nil;

        
        $b = self.$partition_path(path), $a = Opal.to_ary($b), (path_segments = ($a[0] == null ? nil : $a[0])), (path_root = ($a[1] == null ? nil : $a[1])), $b;
        if ($truthy(path['$include?']($$($nesting, 'DOT_DOT')))) {
          
          resolved_segments = [];
          $send(path_segments, 'each', [], (TMP_10 = function(segment){var self = TMP_10.$$s || this;

          
            
            if (segment == null) {
              segment = nil;
            };
            if (segment['$==']($$($nesting, 'DOT_DOT'))) {
              return resolved_segments.$pop()
            } else {
              return resolved_segments['$<<'](segment)
            };}, TMP_10.$$s = self, TMP_10.$$arity = 1, TMP_10));
          return self.$join_path(resolved_segments, path_root);
        } else {
          return self.$join_path(path_segments, path_root)
        };
      }, TMP_PathResolver_expand_path_9.$$arity = 1);
      
      Opal.def(self, '$partition_path', TMP_PathResolver_partition_path_11 = function $$partition_path(path, web) {
        var self = this, result = nil, cache = nil, posix_path = nil, root = nil, path_segments = nil, $writer = nil;

        
        
        if (web == null) {
          web = nil;
        };
        if ($truthy((result = (cache = (function() {if ($truthy(web)) {
          return self._partition_path_web
        } else {
          return self._partition_path_sys
        }; return nil; })())['$[]'](path)))) {
          return result};
        posix_path = self.$posixify(path);
        if ($truthy(web)) {
          if ($truthy(self['$web_root?'](posix_path))) {
            root = $$($nesting, 'SLASH')
          } else if ($truthy(posix_path['$start_with?']($$($nesting, 'DOT_SLASH')))) {
            root = $$($nesting, 'DOT_SLASH')}
        } else if ($truthy(self['$root?'](posix_path))) {
          if ($truthy(self['$unc?'](posix_path))) {
            root = $$($nesting, 'DOUBLE_SLASH')
          } else if ($truthy(posix_path['$start_with?']($$($nesting, 'SLASH')))) {
            root = $$($nesting, 'SLASH')
          } else {
            root = posix_path.$slice(0, $rb_plus(posix_path.$index($$($nesting, 'SLASH')), 1))
          }
        } else if ($truthy(posix_path['$start_with?']($$($nesting, 'DOT_SLASH')))) {
          root = $$($nesting, 'DOT_SLASH')};
        path_segments = (function() {if ($truthy(root)) {
          
          return posix_path.$slice(root.$length(), posix_path.$length());
        } else {
          return posix_path
        }; return nil; })().$split($$($nesting, 'SLASH'));
        path_segments.$delete($$($nesting, 'DOT'));
        
        $writer = [path, [path_segments, root]];
        $send(cache, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];;
      }, TMP_PathResolver_partition_path_11.$$arity = -2);
      
      Opal.def(self, '$join_path', TMP_PathResolver_join_path_12 = function $$join_path(segments, root) {
        var self = this;

        
        
        if (root == null) {
          root = nil;
        };
        if ($truthy(root)) {
          return "" + (root) + (segments.$join($$($nesting, 'SLASH')))
        } else {
          
          return segments.$join($$($nesting, 'SLASH'));
        };
      }, TMP_PathResolver_join_path_12.$$arity = -2);
      
      Opal.def(self, '$system_path', TMP_PathResolver_system_path_13 = function $$system_path(target, start, jail, opts) {
        var $a, $b, TMP_14, TMP_15, self = this, target_path = nil, target_segments = nil, _ = nil, jail_segments = nil, jail_root = nil, recheck = nil, start_segments = nil, start_root = nil, resolved_segments = nil, unresolved_segments = nil, warned = nil;

        
        
        if (start == null) {
          start = nil;
        };
        
        if (jail == null) {
          jail = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(jail)) {
          
          if ($truthy(self['$root?'](jail))) {
          } else {
            self.$raise($$$('::', 'SecurityError'), "" + "Jail is not an absolute path: " + (jail))
          };
          jail = self.$posixify(jail);};
        if ($truthy(target)) {
          if ($truthy(self['$root?'](target))) {
            
            target_path = self.$expand_path(target);
            if ($truthy(($truthy($a = jail) ? self['$descends_from?'](target_path, jail)['$!']() : $a))) {
              if ($truthy(opts.$fetch("recover", true))) {
                
                self.$logger().$warn("" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " is outside of jail; recovering automatically");
                $b = self.$partition_path(target_path), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), $b;
                $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), (jail_root = ($a[1] == null ? nil : $a[1])), $b;
                return self.$join_path($rb_plus(jail_segments, target_segments), jail_root);
              } else {
                self.$raise($$$('::', 'SecurityError'), "" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " " + (target) + " is outside of jail: " + (jail) + " (disallowed in safe mode)")
              }};
            return target_path;
          } else {
            $b = self.$partition_path(target), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), $b
          }
        } else {
          target_segments = []
        };
        if ($truthy(target_segments['$empty?']())) {
          if ($truthy(start['$nil_or_empty?']())) {
            return ($truthy($a = jail) ? $a : self.working_dir)
          } else if ($truthy(self['$root?'](start))) {
            if ($truthy(jail)) {
              start = self.$posixify(start)
            } else {
              return self.$expand_path(start)
            }
          } else {
            
            $b = self.$partition_path(start), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), $b;
            start = ($truthy($a = jail) ? $a : self.working_dir);
          }
        } else if ($truthy(start['$nil_or_empty?']())) {
          start = ($truthy($a = jail) ? $a : self.working_dir)
        } else if ($truthy(self['$root?'](start))) {
          if ($truthy(jail)) {
            start = self.$posixify(start)}
        } else {
          start = "" + (($truthy($a = jail) ? $a : self.working_dir).$chomp("/")) + "/" + (start)
        };
        if ($truthy(($truthy($a = ($truthy($b = jail) ? (recheck = self['$descends_from?'](start, jail)['$!']()) : $b)) ? self.file_separator['$==']($$($nesting, 'BACKSLASH')) : $a))) {
          
          $b = self.$partition_path(start), $a = Opal.to_ary($b), (start_segments = ($a[0] == null ? nil : $a[0])), (start_root = ($a[1] == null ? nil : $a[1])), $b;
          $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), (jail_root = ($a[1] == null ? nil : $a[1])), $b;
          if ($truthy(start_root['$!='](jail_root))) {
            if ($truthy(opts.$fetch("recover", true))) {
              
              self.$logger().$warn("" + "start path for " + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " is outside of jail root; recovering automatically");
              start_segments = jail_segments;
              recheck = false;
            } else {
              self.$raise($$$('::', 'SecurityError'), "" + "start path for " + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " " + (start) + " refers to location outside jail root: " + (jail) + " (disallowed in safe mode)")
            }};
        } else {
          $b = self.$partition_path(start), $a = Opal.to_ary($b), (start_segments = ($a[0] == null ? nil : $a[0])), (jail_root = ($a[1] == null ? nil : $a[1])), $b
        };
        if ($truthy((resolved_segments = $rb_plus(start_segments, target_segments))['$include?']($$($nesting, 'DOT_DOT')))) {
          
          $a = [resolved_segments, []], (unresolved_segments = $a[0]), (resolved_segments = $a[1]), $a;
          if ($truthy(jail)) {
            
            if ($truthy(jail_segments)) {
            } else {
              $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), $b
            };
            warned = false;
            $send(unresolved_segments, 'each', [], (TMP_14 = function(segment){var self = TMP_14.$$s || this, $c;

            
              
              if (segment == null) {
                segment = nil;
              };
              if (segment['$==']($$($nesting, 'DOT_DOT'))) {
                if ($truthy($rb_gt(resolved_segments.$size(), jail_segments.$size()))) {
                  return resolved_segments.$pop()
                } else if ($truthy(opts.$fetch("recover", true))) {
                  if ($truthy(warned)) {
                    return nil
                  } else {
                    
                    self.$logger().$warn("" + (($truthy($c = opts['$[]']("target_name")) ? $c : "path")) + " has illegal reference to ancestor of jail; recovering automatically");
                    return (warned = true);
                  }
                } else {
                  return self.$raise($$$('::', 'SecurityError'), "" + (($truthy($c = opts['$[]']("target_name")) ? $c : "path")) + " " + (target) + " refers to location outside jail: " + (jail) + " (disallowed in safe mode)")
                }
              } else {
                return resolved_segments['$<<'](segment)
              };}, TMP_14.$$s = self, TMP_14.$$arity = 1, TMP_14));
          } else {
            $send(unresolved_segments, 'each', [], (TMP_15 = function(segment){var self = TMP_15.$$s || this;

            
              
              if (segment == null) {
                segment = nil;
              };
              if (segment['$==']($$($nesting, 'DOT_DOT'))) {
                return resolved_segments.$pop()
              } else {
                return resolved_segments['$<<'](segment)
              };}, TMP_15.$$s = self, TMP_15.$$arity = 1, TMP_15))
          };};
        if ($truthy(recheck)) {
          
          target_path = self.$join_path(resolved_segments, jail_root);
          if ($truthy(self['$descends_from?'](target_path, jail))) {
            return target_path
          } else if ($truthy(opts.$fetch("recover", true))) {
            
            self.$logger().$warn("" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " is outside of jail; recovering automatically");
            if ($truthy(jail_segments)) {
            } else {
              $b = self.$partition_path(jail), $a = Opal.to_ary($b), (jail_segments = ($a[0] == null ? nil : $a[0])), (_ = ($a[1] == null ? nil : $a[1])), $b
            };
            return self.$join_path($rb_plus(jail_segments, target_segments), jail_root);
          } else {
            return self.$raise($$$('::', 'SecurityError'), "" + (($truthy($a = opts['$[]']("target_name")) ? $a : "path")) + " " + (target) + " is outside of jail: " + (jail) + " (disallowed in safe mode)")
          };
        } else {
          return self.$join_path(resolved_segments, jail_root)
        };
      }, TMP_PathResolver_system_path_13.$$arity = -2);
      return (Opal.def(self, '$web_path', TMP_PathResolver_web_path_16 = function $$web_path(target, start) {
        var $a, $b, TMP_17, self = this, uri_prefix = nil, target_segments = nil, target_root = nil, resolved_segments = nil, resolved_path = nil;

        
        
        if (start == null) {
          start = nil;
        };
        target = self.$posixify(target);
        start = self.$posixify(start);
        uri_prefix = nil;
        if ($truthy(($truthy($a = start['$nil_or_empty?']()) ? $a : self['$web_root?'](target)))) {
        } else {
          
          target = (function() {if ($truthy(start['$end_with?']($$($nesting, 'SLASH')))) {
            return "" + (start) + (target)
          } else {
            return "" + (start) + ($$($nesting, 'SLASH')) + (target)
          }; return nil; })();
          if ($truthy((uri_prefix = $$($nesting, 'Helpers').$uri_prefix(target)))) {
            target = target['$[]'](Opal.Range.$new(uri_prefix.$length(), -1, false))};
        };
        $b = self.$partition_path(target, true), $a = Opal.to_ary($b), (target_segments = ($a[0] == null ? nil : $a[0])), (target_root = ($a[1] == null ? nil : $a[1])), $b;
        resolved_segments = [];
        $send(target_segments, 'each', [], (TMP_17 = function(segment){var self = TMP_17.$$s || this, $c;

        
          
          if (segment == null) {
            segment = nil;
          };
          if (segment['$==']($$($nesting, 'DOT_DOT'))) {
            if ($truthy(resolved_segments['$empty?']())) {
              if ($truthy(($truthy($c = target_root) ? target_root['$!=']($$($nesting, 'DOT_SLASH')) : $c))) {
                return nil
              } else {
                return resolved_segments['$<<'](segment)
              }
            } else if (resolved_segments['$[]'](-1)['$==']($$($nesting, 'DOT_DOT'))) {
              return resolved_segments['$<<'](segment)
            } else {
              return resolved_segments.$pop()
            }
          } else {
            return resolved_segments['$<<'](segment)
          };}, TMP_17.$$s = self, TMP_17.$$arity = 1, TMP_17));
        if ($truthy((resolved_path = self.$join_path(resolved_segments, target_root))['$include?'](" "))) {
          resolved_path = resolved_path.$gsub(" ", "%20")};
        if ($truthy(uri_prefix)) {
          return "" + (uri_prefix) + (resolved_path)
        } else {
          return resolved_path
        };
      }, TMP_PathResolver_web_path_16.$$arity = -2), nil) && 'web_path';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/reader"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_ge(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs >= rhs : lhs['$>='](rhs);
  }
  function $rb_divide(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs / rhs : lhs['$/'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $truthy = Opal.truthy, $send = Opal.send, $gvars = Opal.gvars, $hash = Opal.hash;

  Opal.add_stubs(['$include', '$attr_reader', '$+', '$attr_accessor', '$!', '$===', '$split', '$file', '$dir', '$dirname', '$path', '$basename', '$lineno', '$prepare_lines', '$drop', '$[]', '$normalize_lines_from_string', '$normalize_lines_array', '$empty?', '$nil_or_empty?', '$peek_line', '$>', '$slice', '$length', '$process_line', '$times', '$shift', '$read_line', '$<<', '$-', '$unshift_all', '$has_more_lines?', '$join', '$read_lines', '$unshift', '$start_with?', '$==', '$*', '$read_lines_until', '$size', '$clear', '$cursor', '$[]=', '$!=', '$fetch', '$cursor_at_mark', '$warn', '$logger', '$message_with_context', '$new', '$each', '$instance_variables', '$instance_variable_get', '$dup', '$instance_variable_set', '$to_i', '$attributes', '$<', '$catalog', '$skip_front_matter!', '$pop', '$adjust_indentation!', '$attr', '$end_with?', '$include?', '$=~', '$preprocess_conditional_directive', '$preprocess_include_directive', '$pop_include', '$downcase', '$error', '$none?', '$key?', '$any?', '$all?', '$strip', '$resolve_expr_val', '$send', '$to_sym', '$replace_next_line', '$rstrip', '$sub_attributes', '$attribute_missing', '$include_processors?', '$find', '$handles?', '$instance', '$process_method', '$parse_attributes', '$>=', '$safe', '$resolve_include_path', '$split_delimited_value', '$/', '$to_a', '$uniq', '$sort', '$open', '$each_line', '$infinite?', '$push_include', '$delete', '$value?', '$force_encoding', '$create_include_cursor', '$rindex', '$delete_at', '$nil?', '$keys', '$read', '$uriish?', '$attr?', '$require_library', '$parse', '$normalize_system_path', '$file?', '$relative_path', '$path_resolver', '$base_dir', '$to_s', '$path=', '$extname', '$rootname', '$<=', '$to_f', '$extensions?', '$extensions', '$include_processors', '$class', '$object_id', '$inspect', '$map']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      function $Reader(){};
      var self = $Reader = $klass($base, $super, 'Reader', $Reader);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Reader_initialize_4, TMP_Reader_prepare_lines_5, TMP_Reader_process_line_6, TMP_Reader_has_more_lines$q_7, TMP_Reader_empty$q_8, TMP_Reader_next_line_empty$q_9, TMP_Reader_peek_line_10, TMP_Reader_peek_lines_11, TMP_Reader_read_line_13, TMP_Reader_read_lines_14, TMP_Reader_read_15, TMP_Reader_advance_16, TMP_Reader_unshift_line_17, TMP_Reader_unshift_lines_18, TMP_Reader_replace_next_line_19, TMP_Reader_skip_blank_lines_20, TMP_Reader_skip_comment_lines_21, TMP_Reader_skip_line_comments_22, TMP_Reader_terminate_23, TMP_Reader_read_lines_until_24, TMP_Reader_shift_25, TMP_Reader_unshift_26, TMP_Reader_unshift_all_27, TMP_Reader_cursor_28, TMP_Reader_cursor_at_line_29, TMP_Reader_cursor_at_mark_30, TMP_Reader_cursor_before_mark_31, TMP_Reader_cursor_at_prev_line_32, TMP_Reader_mark_33, TMP_Reader_line_info_34, TMP_Reader_lines_35, TMP_Reader_string_36, TMP_Reader_source_37, TMP_Reader_save_38, TMP_Reader_restore_save_40, TMP_Reader_discard_save_42;

      def.file = def.lines = def.process_lines = def.look_ahead = def.unescape_next_line = def.lineno = def.dir = def.path = def.mark = def.source_lines = def.saved = nil;
      
      self.$include($$($nesting, 'Logging'));
      (function($base, $super, $parent_nesting) {
        function $Cursor(){};
        var self = $Cursor = $klass($base, $super, 'Cursor', $Cursor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Cursor_initialize_1, TMP_Cursor_advance_2, TMP_Cursor_line_info_3;

        def.lineno = def.path = nil;
        
        self.$attr_reader("file", "dir", "path", "lineno");
        
        Opal.def(self, '$initialize', TMP_Cursor_initialize_1 = function $$initialize(file, dir, path, lineno) {
          var $a, self = this;

          
          
          if (dir == null) {
            dir = nil;
          };
          
          if (path == null) {
            path = nil;
          };
          
          if (lineno == null) {
            lineno = 1;
          };
          return $a = [file, dir, path, lineno], (self.file = $a[0]), (self.dir = $a[1]), (self.path = $a[2]), (self.lineno = $a[3]), $a;
        }, TMP_Cursor_initialize_1.$$arity = -2);
        
        Opal.def(self, '$advance', TMP_Cursor_advance_2 = function $$advance(num) {
          var self = this;

          return (self.lineno = $rb_plus(self.lineno, num))
        }, TMP_Cursor_advance_2.$$arity = 1);
        
        Opal.def(self, '$line_info', TMP_Cursor_line_info_3 = function $$line_info() {
          var self = this;

          return "" + (self.path) + ": line " + (self.lineno)
        }, TMP_Cursor_line_info_3.$$arity = 0);
        return Opal.alias(self, "to_s", "line_info");
      })($nesting[0], null, $nesting);
      self.$attr_reader("file");
      self.$attr_reader("dir");
      self.$attr_reader("path");
      self.$attr_reader("lineno");
      self.$attr_reader("source_lines");
      self.$attr_accessor("process_lines");
      self.$attr_accessor("unterminated");
      
      Opal.def(self, '$initialize', TMP_Reader_initialize_4 = function $$initialize(data, cursor, opts) {
        var $a, $b, self = this;

        
        
        if (data == null) {
          data = nil;
        };
        
        if (cursor == null) {
          cursor = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(cursor['$!']())) {
          
          self.file = nil;
          self.dir = ".";
          self.path = "<stdin>";
          self.lineno = 1;
        } else if ($truthy($$$('::', 'String')['$==='](cursor))) {
          
          self.file = cursor;
          $b = $$$('::', 'File').$split(self.file), $a = Opal.to_ary($b), (self.dir = ($a[0] == null ? nil : $a[0])), (self.path = ($a[1] == null ? nil : $a[1])), $b;
          self.lineno = 1;
        } else {
          
          if ($truthy((self.file = cursor.$file()))) {
            
            self.dir = ($truthy($a = cursor.$dir()) ? $a : $$$('::', 'File').$dirname(self.file));
            self.path = ($truthy($a = cursor.$path()) ? $a : $$$('::', 'File').$basename(self.file));
          } else {
            
            self.dir = ($truthy($a = cursor.$dir()) ? $a : ".");
            self.path = ($truthy($a = cursor.$path()) ? $a : "<stdin>");
          };
          self.lineno = ($truthy($a = cursor.$lineno()) ? $a : 1);
        };
        self.lines = (function() {if ($truthy(data)) {
          
          return self.$prepare_lines(data, opts);
        } else {
          return []
        }; return nil; })();
        self.source_lines = self.lines.$drop(0);
        self.mark = nil;
        self.look_ahead = 0;
        self.process_lines = true;
        self.unescape_next_line = false;
        self.unterminated = nil;
        return (self.saved = nil);
      }, TMP_Reader_initialize_4.$$arity = -1);
      
      Opal.def(self, '$prepare_lines', TMP_Reader_prepare_lines_5 = function $$prepare_lines(data, opts) {
        var self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy($$$('::', 'String')['$==='](data))) {
          if ($truthy(opts['$[]']("normalize"))) {
            return $$($nesting, 'Helpers').$normalize_lines_from_string(data)
          } else {
            return data.$split($$($nesting, 'LF'), -1)
          }
        } else if ($truthy(opts['$[]']("normalize"))) {
          return $$($nesting, 'Helpers').$normalize_lines_array(data)
        } else {
          return data.$drop(0)
        };
      }, TMP_Reader_prepare_lines_5.$$arity = -2);
      
      Opal.def(self, '$process_line', TMP_Reader_process_line_6 = function $$process_line(line) {
        var self = this;

        
        if ($truthy(self.process_lines)) {
          self.look_ahead = $rb_plus(self.look_ahead, 1)};
        return line;
      }, TMP_Reader_process_line_6.$$arity = 1);
      
      Opal.def(self, '$has_more_lines?', TMP_Reader_has_more_lines$q_7 = function() {
        var self = this;

        if ($truthy(self.lines['$empty?']())) {
          
          self.look_ahead = 0;
          return false;
        } else {
          return true
        }
      }, TMP_Reader_has_more_lines$q_7.$$arity = 0);
      
      Opal.def(self, '$empty?', TMP_Reader_empty$q_8 = function() {
        var self = this;

        if ($truthy(self.lines['$empty?']())) {
          
          self.look_ahead = 0;
          return true;
        } else {
          return false
        }
      }, TMP_Reader_empty$q_8.$$arity = 0);
      Opal.alias(self, "eof?", "empty?");
      
      Opal.def(self, '$next_line_empty?', TMP_Reader_next_line_empty$q_9 = function() {
        var self = this;

        return self.$peek_line()['$nil_or_empty?']()
      }, TMP_Reader_next_line_empty$q_9.$$arity = 0);
      
      Opal.def(self, '$peek_line', TMP_Reader_peek_line_10 = function $$peek_line(direct) {
        var $a, self = this, line = nil;

        
        
        if (direct == null) {
          direct = false;
        };
        if ($truthy(($truthy($a = direct) ? $a : $rb_gt(self.look_ahead, 0)))) {
          if ($truthy(self.unescape_next_line)) {
            
            return (line = self.lines['$[]'](0)).$slice(1, line.$length());
          } else {
            return self.lines['$[]'](0)
          }
        } else if ($truthy(self.lines['$empty?']())) {
          
          self.look_ahead = 0;
          return nil;
        } else if ($truthy((line = self.$process_line(self.lines['$[]'](0))))) {
          return line
        } else {
          return self.$peek_line()
        };
      }, TMP_Reader_peek_line_10.$$arity = -1);
      
      Opal.def(self, '$peek_lines', TMP_Reader_peek_lines_11 = function $$peek_lines(num, direct) {
        var $a, TMP_12, self = this, old_look_ahead = nil, result = nil;

        
        
        if (num == null) {
          num = nil;
        };
        
        if (direct == null) {
          direct = false;
        };
        old_look_ahead = self.look_ahead;
        result = [];
        (function(){var $brk = Opal.new_brk(); try {return $send(($truthy($a = num) ? $a : $$($nesting, 'MAX_INT')), 'times', [], (TMP_12 = function(){var self = TMP_12.$$s || this, line = nil;
          if (self.lineno == null) self.lineno = nil;

        if ($truthy((line = (function() {if ($truthy(direct)) {
            return self.$shift()
          } else {
            return self.$read_line()
          }; return nil; })()))) {
            return result['$<<'](line)
          } else {
            
            if ($truthy(direct)) {
              self.lineno = $rb_minus(self.lineno, 1)};
            
            Opal.brk(nil, $brk);
          }}, TMP_12.$$s = self, TMP_12.$$brk = $brk, TMP_12.$$arity = 0, TMP_12))
        } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();
        if ($truthy(result['$empty?']())) {
        } else {
          
          self.$unshift_all(result);
          if ($truthy(direct)) {
            self.look_ahead = old_look_ahead};
        };
        return result;
      }, TMP_Reader_peek_lines_11.$$arity = -1);
      
      Opal.def(self, '$read_line', TMP_Reader_read_line_13 = function $$read_line() {
        var $a, self = this;

        if ($truthy(($truthy($a = $rb_gt(self.look_ahead, 0)) ? $a : self['$has_more_lines?']()))) {
          return self.$shift()
        } else {
          return nil
        }
      }, TMP_Reader_read_line_13.$$arity = 0);
      
      Opal.def(self, '$read_lines', TMP_Reader_read_lines_14 = function $$read_lines() {
        var $a, self = this, lines = nil;

        
        lines = [];
        while ($truthy(self['$has_more_lines?']())) {
          lines['$<<'](self.$shift())
        };
        return lines;
      }, TMP_Reader_read_lines_14.$$arity = 0);
      Opal.alias(self, "readlines", "read_lines");
      
      Opal.def(self, '$read', TMP_Reader_read_15 = function $$read() {
        var self = this;

        return self.$read_lines().$join($$($nesting, 'LF'))
      }, TMP_Reader_read_15.$$arity = 0);
      
      Opal.def(self, '$advance', TMP_Reader_advance_16 = function $$advance() {
        var self = this;

        if ($truthy(self.$shift())) {
          return true
        } else {
          return false
        }
      }, TMP_Reader_advance_16.$$arity = 0);
      
      Opal.def(self, '$unshift_line', TMP_Reader_unshift_line_17 = function $$unshift_line(line_to_restore) {
        var self = this;

        
        self.$unshift(line_to_restore);
        return nil;
      }, TMP_Reader_unshift_line_17.$$arity = 1);
      Opal.alias(self, "restore_line", "unshift_line");
      
      Opal.def(self, '$unshift_lines', TMP_Reader_unshift_lines_18 = function $$unshift_lines(lines_to_restore) {
        var self = this;

        
        self.$unshift_all(lines_to_restore);
        return nil;
      }, TMP_Reader_unshift_lines_18.$$arity = 1);
      Opal.alias(self, "restore_lines", "unshift_lines");
      
      Opal.def(self, '$replace_next_line', TMP_Reader_replace_next_line_19 = function $$replace_next_line(replacement) {
        var self = this;

        
        self.$shift();
        self.$unshift(replacement);
        return true;
      }, TMP_Reader_replace_next_line_19.$$arity = 1);
      Opal.alias(self, "replace_line", "replace_next_line");
      
      Opal.def(self, '$skip_blank_lines', TMP_Reader_skip_blank_lines_20 = function $$skip_blank_lines() {
        var $a, self = this, num_skipped = nil, next_line = nil;

        
        if ($truthy(self['$empty?']())) {
          return nil};
        num_skipped = 0;
        while ($truthy((next_line = self.$peek_line()))) {
          if ($truthy(next_line['$empty?']())) {
            
            self.$shift();
            num_skipped = $rb_plus(num_skipped, 1);
          } else {
            return num_skipped
          }
        };
      }, TMP_Reader_skip_blank_lines_20.$$arity = 0);
      
      Opal.def(self, '$skip_comment_lines', TMP_Reader_skip_comment_lines_21 = function $$skip_comment_lines() {
        var $a, $b, self = this, next_line = nil, ll = nil;

        
        if ($truthy(self['$empty?']())) {
          return nil};
        while ($truthy(($truthy($b = (next_line = self.$peek_line())) ? next_line['$empty?']()['$!']() : $b))) {
          if ($truthy(next_line['$start_with?']("//"))) {
            if ($truthy(next_line['$start_with?']("///"))) {
              if ($truthy(($truthy($b = $rb_gt((ll = next_line.$length()), 3)) ? next_line['$==']($rb_times("/", ll)) : $b))) {
                self.$read_lines_until($hash2(["terminator", "skip_first_line", "read_last_line", "skip_processing", "context"], {"terminator": next_line, "skip_first_line": true, "read_last_line": true, "skip_processing": true, "context": "comment"}))
              } else {
                break;
              }
            } else {
              self.$shift()
            }
          } else {
            break;
          }
        };
        return nil;
      }, TMP_Reader_skip_comment_lines_21.$$arity = 0);
      
      Opal.def(self, '$skip_line_comments', TMP_Reader_skip_line_comments_22 = function $$skip_line_comments() {
        var $a, $b, self = this, comment_lines = nil, next_line = nil;

        
        if ($truthy(self['$empty?']())) {
          return []};
        comment_lines = [];
        while ($truthy(($truthy($b = (next_line = self.$peek_line())) ? next_line['$empty?']()['$!']() : $b))) {
          if ($truthy(next_line['$start_with?']("//"))) {
            comment_lines['$<<'](self.$shift())
          } else {
            break;
          }
        };
        return comment_lines;
      }, TMP_Reader_skip_line_comments_22.$$arity = 0);
      
      Opal.def(self, '$terminate', TMP_Reader_terminate_23 = function $$terminate() {
        var self = this;

        
        self.lineno = $rb_plus(self.lineno, self.lines.$size());
        self.lines.$clear();
        self.look_ahead = 0;
        return nil;
      }, TMP_Reader_terminate_23.$$arity = 0);
      
      Opal.def(self, '$read_lines_until', TMP_Reader_read_lines_until_24 = function $$read_lines_until(options) {
        var $a, $b, $c, $d, $iter = TMP_Reader_read_lines_until_24.$$p, $yield = $iter || nil, self = this, result = nil, restore_process_lines = nil, terminator = nil, start_cursor = nil, break_on_blank_lines = nil, break_on_list_continuation = nil, skip_comments = nil, complete = nil, line_read = nil, line_restored = nil, line = nil, $writer = nil, context = nil;

        if ($iter) TMP_Reader_read_lines_until_24.$$p = null;
        
        
        if (options == null) {
          options = $hash2([], {});
        };
        result = [];
        if ($truthy(($truthy($a = self.process_lines) ? options['$[]']("skip_processing") : $a))) {
          
          self.process_lines = false;
          restore_process_lines = true;};
        if ($truthy((terminator = options['$[]']("terminator")))) {
          
          start_cursor = ($truthy($a = options['$[]']("cursor")) ? $a : self.$cursor());
          break_on_blank_lines = false;
          break_on_list_continuation = false;
        } else {
          
          break_on_blank_lines = options['$[]']("break_on_blank_lines");
          break_on_list_continuation = options['$[]']("break_on_list_continuation");
        };
        skip_comments = options['$[]']("skip_line_comments");
        complete = (line_read = (line_restored = nil));
        if ($truthy(options['$[]']("skip_first_line"))) {
          self.$shift()};
        while ($truthy(($truthy($b = complete['$!']()) ? (line = self.$read_line()) : $b))) {
          
          complete = (function() {while ($truthy(true)) {
            
            if ($truthy(($truthy($c = terminator) ? line['$=='](terminator) : $c))) {
              return true};
            if ($truthy(($truthy($c = break_on_blank_lines) ? line['$empty?']() : $c))) {
              return true};
            if ($truthy(($truthy($c = ($truthy($d = break_on_list_continuation) ? line_read : $d)) ? line['$==']($$($nesting, 'LIST_CONTINUATION')) : $c))) {
              
              
              $writer = ["preserve_last_line", true];
              $send(options, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              return true;};
            if ($truthy((($c = ($yield !== nil)) ? Opal.yield1($yield, line) : ($yield !== nil)))) {
              return true};
            return false;
          }; return nil; })();
          if ($truthy(complete)) {
            
            if ($truthy(options['$[]']("read_last_line"))) {
              
              result['$<<'](line);
              line_read = true;};
            if ($truthy(options['$[]']("preserve_last_line"))) {
              
              self.$unshift(line);
              line_restored = true;};
          } else if ($truthy(($truthy($b = ($truthy($c = skip_comments) ? line['$start_with?']("//") : $c)) ? line['$start_with?']("///")['$!']() : $b))) {
          } else {
            
            result['$<<'](line);
            line_read = true;
          };
        };
        if ($truthy(restore_process_lines)) {
          
          self.process_lines = true;
          if ($truthy(($truthy($a = line_restored) ? terminator['$!']() : $a))) {
            self.look_ahead = $rb_minus(self.look_ahead, 1)};};
        if ($truthy(($truthy($a = ($truthy($b = terminator) ? terminator['$!='](line) : $b)) ? (context = options.$fetch("context", terminator)) : $a))) {
          
          if (start_cursor['$==']("at_mark")) {
            start_cursor = self.$cursor_at_mark()};
          self.$logger().$warn(self.$message_with_context("" + "unterminated " + (context) + " block", $hash2(["source_location"], {"source_location": start_cursor})));
          self.unterminated = true;};
        return result;
      }, TMP_Reader_read_lines_until_24.$$arity = -1);
      
      Opal.def(self, '$shift', TMP_Reader_shift_25 = function $$shift() {
        var self = this;

        
        self.lineno = $rb_plus(self.lineno, 1);
        if (self.look_ahead['$=='](0)) {
        } else {
          self.look_ahead = $rb_minus(self.look_ahead, 1)
        };
        return self.lines.$shift();
      }, TMP_Reader_shift_25.$$arity = 0);
      
      Opal.def(self, '$unshift', TMP_Reader_unshift_26 = function $$unshift(line) {
        var self = this;

        
        self.lineno = $rb_minus(self.lineno, 1);
        self.look_ahead = $rb_plus(self.look_ahead, 1);
        return self.lines.$unshift(line);
      }, TMP_Reader_unshift_26.$$arity = 1);
      
      Opal.def(self, '$unshift_all', TMP_Reader_unshift_all_27 = function $$unshift_all(lines) {
        var self = this;

        
        self.lineno = $rb_minus(self.lineno, lines.$size());
        self.look_ahead = $rb_plus(self.look_ahead, lines.$size());
        return $send(self.lines, 'unshift', Opal.to_a(lines));
      }, TMP_Reader_unshift_all_27.$$arity = 1);
      
      Opal.def(self, '$cursor', TMP_Reader_cursor_28 = function $$cursor() {
        var self = this;

        return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, self.lineno)
      }, TMP_Reader_cursor_28.$$arity = 0);
      
      Opal.def(self, '$cursor_at_line', TMP_Reader_cursor_at_line_29 = function $$cursor_at_line(lineno) {
        var self = this;

        return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, lineno)
      }, TMP_Reader_cursor_at_line_29.$$arity = 1);
      
      Opal.def(self, '$cursor_at_mark', TMP_Reader_cursor_at_mark_30 = function $$cursor_at_mark() {
        var self = this;

        if ($truthy(self.mark)) {
          return $send($$($nesting, 'Cursor'), 'new', Opal.to_a(self.mark))
        } else {
          return self.$cursor()
        }
      }, TMP_Reader_cursor_at_mark_30.$$arity = 0);
      
      Opal.def(self, '$cursor_before_mark', TMP_Reader_cursor_before_mark_31 = function $$cursor_before_mark() {
        var $a, $b, self = this, m_file = nil, m_dir = nil, m_path = nil, m_lineno = nil;

        if ($truthy(self.mark)) {
          
          $b = self.mark, $a = Opal.to_ary($b), (m_file = ($a[0] == null ? nil : $a[0])), (m_dir = ($a[1] == null ? nil : $a[1])), (m_path = ($a[2] == null ? nil : $a[2])), (m_lineno = ($a[3] == null ? nil : $a[3])), $b;
          return $$($nesting, 'Cursor').$new(m_file, m_dir, m_path, $rb_minus(m_lineno, 1));
        } else {
          return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, $rb_minus(self.lineno, 1))
        }
      }, TMP_Reader_cursor_before_mark_31.$$arity = 0);
      
      Opal.def(self, '$cursor_at_prev_line', TMP_Reader_cursor_at_prev_line_32 = function $$cursor_at_prev_line() {
        var self = this;

        return $$($nesting, 'Cursor').$new(self.file, self.dir, self.path, $rb_minus(self.lineno, 1))
      }, TMP_Reader_cursor_at_prev_line_32.$$arity = 0);
      
      Opal.def(self, '$mark', TMP_Reader_mark_33 = function $$mark() {
        var self = this;

        return (self.mark = [self.file, self.dir, self.path, self.lineno])
      }, TMP_Reader_mark_33.$$arity = 0);
      
      Opal.def(self, '$line_info', TMP_Reader_line_info_34 = function $$line_info() {
        var self = this;

        return "" + (self.path) + ": line " + (self.lineno)
      }, TMP_Reader_line_info_34.$$arity = 0);
      
      Opal.def(self, '$lines', TMP_Reader_lines_35 = function $$lines() {
        var self = this;

        return self.lines.$drop(0)
      }, TMP_Reader_lines_35.$$arity = 0);
      
      Opal.def(self, '$string', TMP_Reader_string_36 = function $$string() {
        var self = this;

        return self.lines.$join($$($nesting, 'LF'))
      }, TMP_Reader_string_36.$$arity = 0);
      
      Opal.def(self, '$source', TMP_Reader_source_37 = function $$source() {
        var self = this;

        return self.source_lines.$join($$($nesting, 'LF'))
      }, TMP_Reader_source_37.$$arity = 0);
      
      Opal.def(self, '$save', TMP_Reader_save_38 = function $$save() {
        var TMP_39, self = this, accum = nil;

        
        accum = $hash2([], {});
        $send(self.$instance_variables(), 'each', [], (TMP_39 = function(name){var self = TMP_39.$$s || this, $a, $writer = nil, val = nil;

        
          
          if (name == null) {
            name = nil;
          };
          if ($truthy(($truthy($a = name['$==']("@saved")) ? $a : name['$==']("@source_lines")))) {
            return nil
          } else {
            
            $writer = [name, (function() {if ($truthy($$$('::', 'Array')['$===']((val = self.$instance_variable_get(name))))) {
              return val.$dup()
            } else {
              return val
            }; return nil; })()];
            $send(accum, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          };}, TMP_39.$$s = self, TMP_39.$$arity = 1, TMP_39));
        self.saved = accum;
        return nil;
      }, TMP_Reader_save_38.$$arity = 0);
      
      Opal.def(self, '$restore_save', TMP_Reader_restore_save_40 = function $$restore_save() {
        var TMP_41, self = this;

        if ($truthy(self.saved)) {
          
          $send(self.saved, 'each', [], (TMP_41 = function(name, val){var self = TMP_41.$$s || this;

          
            
            if (name == null) {
              name = nil;
            };
            
            if (val == null) {
              val = nil;
            };
            return self.$instance_variable_set(name, val);}, TMP_41.$$s = self, TMP_41.$$arity = 2, TMP_41));
          return (self.saved = nil);
        } else {
          return nil
        }
      }, TMP_Reader_restore_save_40.$$arity = 0);
      
      Opal.def(self, '$discard_save', TMP_Reader_discard_save_42 = function $$discard_save() {
        var self = this;

        return (self.saved = nil)
      }, TMP_Reader_discard_save_42.$$arity = 0);
      return Opal.alias(self, "to_s", "line_info");
    })($nesting[0], null, $nesting);
    (function($base, $super, $parent_nesting) {
      function $PreprocessorReader(){};
      var self = $PreprocessorReader = $klass($base, $super, 'PreprocessorReader', $PreprocessorReader);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_PreprocessorReader_initialize_43, TMP_PreprocessorReader_prepare_lines_44, TMP_PreprocessorReader_process_line_45, TMP_PreprocessorReader_has_more_lines$q_46, TMP_PreprocessorReader_empty$q_47, TMP_PreprocessorReader_peek_line_48, TMP_PreprocessorReader_preprocess_conditional_directive_49, TMP_PreprocessorReader_preprocess_include_directive_54, TMP_PreprocessorReader_resolve_include_path_66, TMP_PreprocessorReader_push_include_67, TMP_PreprocessorReader_create_include_cursor_68, TMP_PreprocessorReader_pop_include_69, TMP_PreprocessorReader_include_depth_70, TMP_PreprocessorReader_exceeded_max_depth$q_71, TMP_PreprocessorReader_shift_72, TMP_PreprocessorReader_split_delimited_value_73, TMP_PreprocessorReader_skip_front_matter$B_74, TMP_PreprocessorReader_resolve_expr_val_75, TMP_PreprocessorReader_include_processors$q_76, TMP_PreprocessorReader_to_s_77;

      def.document = def.lineno = def.process_lines = def.look_ahead = def.skipping = def.include_stack = def.conditional_stack = def.path = def.include_processor_extensions = def.maxdepth = def.dir = def.lines = def.file = def.includes = def.unescape_next_line = nil;
      
      self.$attr_reader("include_stack");
      
      Opal.def(self, '$initialize', TMP_PreprocessorReader_initialize_43 = function $$initialize(document, data, cursor, opts) {
        var $iter = TMP_PreprocessorReader_initialize_43.$$p, $yield = $iter || nil, self = this, include_depth_default = nil;

        if ($iter) TMP_PreprocessorReader_initialize_43.$$p = null;
        
        
        if (data == null) {
          data = nil;
        };
        
        if (cursor == null) {
          cursor = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        self.document = document;
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_PreprocessorReader_initialize_43, false), [data, cursor, opts], null);
        include_depth_default = document.$attributes().$fetch("max-include-depth", 64).$to_i();
        if ($truthy($rb_lt(include_depth_default, 0))) {
          include_depth_default = 0};
        self.maxdepth = $hash2(["abs", "rel"], {"abs": include_depth_default, "rel": include_depth_default});
        self.include_stack = [];
        self.includes = document.$catalog()['$[]']("includes");
        self.skipping = false;
        self.conditional_stack = [];
        return (self.include_processor_extensions = nil);
      }, TMP_PreprocessorReader_initialize_43.$$arity = -2);
      
      Opal.def(self, '$prepare_lines', TMP_PreprocessorReader_prepare_lines_44 = function $$prepare_lines(data, opts) {
        var $a, $b, $iter = TMP_PreprocessorReader_prepare_lines_44.$$p, $yield = $iter || nil, self = this, result = nil, front_matter = nil, $writer = nil, first = nil, last = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_PreprocessorReader_prepare_lines_44.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        result = $send(self, Opal.find_super_dispatcher(self, 'prepare_lines', TMP_PreprocessorReader_prepare_lines_44, false), $zuper, $iter);
        if ($truthy(($truthy($a = self.document) ? self.document.$attributes()['$[]']("skip-front-matter") : $a))) {
          if ($truthy((front_matter = self['$skip_front_matter!'](result)))) {
            
            $writer = ["front-matter", front_matter.$join($$($nesting, 'LF'))];
            $send(self.document.$attributes(), '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}};
        if ($truthy(opts.$fetch("condense", true))) {
          
          while ($truthy(($truthy($b = (first = result['$[]'](0))) ? first['$empty?']() : $b))) {
            ($truthy($b = result.$shift()) ? (self.lineno = $rb_plus(self.lineno, 1)) : $b)
          };
          while ($truthy(($truthy($b = (last = result['$[]'](-1))) ? last['$empty?']() : $b))) {
            result.$pop()
          };};
        if ($truthy(opts['$[]']("indent"))) {
          $$($nesting, 'Parser')['$adjust_indentation!'](result, opts['$[]']("indent"), self.document.$attr("tabsize"))};
        return result;
      }, TMP_PreprocessorReader_prepare_lines_44.$$arity = -2);
      
      Opal.def(self, '$process_line', TMP_PreprocessorReader_process_line_45 = function $$process_line(line) {
        var $a, $b, self = this;

        
        if ($truthy(self.process_lines)) {
        } else {
          return line
        };
        if ($truthy(line['$empty?']())) {
          
          self.look_ahead = $rb_plus(self.look_ahead, 1);
          return line;};
        if ($truthy(($truthy($a = ($truthy($b = line['$end_with?']("]")) ? line['$start_with?']("[")['$!']() : $b)) ? line['$include?']("::") : $a))) {
          if ($truthy(($truthy($a = line['$include?']("if")) ? $$($nesting, 'ConditionalDirectiveRx')['$=~'](line) : $a))) {
            if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))['$==']("\\")) {
              
              self.unescape_next_line = true;
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line.$slice(1, line.$length());
            } else if ($truthy(self.$preprocess_conditional_directive((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](3)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](4)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](5))))) {
              
              self.$shift();
              return nil;
            } else {
              
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line;
            }
          } else if ($truthy(self.skipping)) {
            
            self.$shift();
            return nil;
          } else if ($truthy(($truthy($a = line['$start_with?']("inc", "\\inc")) ? $$($nesting, 'IncludeDirectiveRx')['$=~'](line) : $a))) {
            if ((($a = $gvars['~']) === nil ? nil : $a['$[]'](1))['$==']("\\")) {
              
              self.unescape_next_line = true;
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line.$slice(1, line.$length());
            } else if ($truthy(self.$preprocess_include_directive((($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](3))))) {
              return nil
            } else {
              
              self.look_ahead = $rb_plus(self.look_ahead, 1);
              return line;
            }
          } else {
            
            self.look_ahead = $rb_plus(self.look_ahead, 1);
            return line;
          }
        } else if ($truthy(self.skipping)) {
          
          self.$shift();
          return nil;
        } else {
          
          self.look_ahead = $rb_plus(self.look_ahead, 1);
          return line;
        };
      }, TMP_PreprocessorReader_process_line_45.$$arity = 1);
      
      Opal.def(self, '$has_more_lines?', TMP_PreprocessorReader_has_more_lines$q_46 = function() {
        var self = this;

        if ($truthy(self.$peek_line())) {
          return true
        } else {
          return false
        }
      }, TMP_PreprocessorReader_has_more_lines$q_46.$$arity = 0);
      
      Opal.def(self, '$empty?', TMP_PreprocessorReader_empty$q_47 = function() {
        var self = this;

        if ($truthy(self.$peek_line())) {
          return false
        } else {
          return true
        }
      }, TMP_PreprocessorReader_empty$q_47.$$arity = 0);
      Opal.alias(self, "eof?", "empty?");
      
      Opal.def(self, '$peek_line', TMP_PreprocessorReader_peek_line_48 = function $$peek_line(direct) {
        var $iter = TMP_PreprocessorReader_peek_line_48.$$p, $yield = $iter || nil, self = this, line = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_PreprocessorReader_peek_line_48.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        
        if (direct == null) {
          direct = false;
        };
        if ($truthy((line = $send(self, Opal.find_super_dispatcher(self, 'peek_line', TMP_PreprocessorReader_peek_line_48, false), $zuper, $iter)))) {
          return line
        } else if ($truthy(self.include_stack['$empty?']())) {
          return nil
        } else {
          
          self.$pop_include();
          return self.$peek_line(direct);
        };
      }, TMP_PreprocessorReader_peek_line_48.$$arity = -1);
      
      Opal.def(self, '$preprocess_conditional_directive', TMP_PreprocessorReader_preprocess_conditional_directive_49 = function $$preprocess_conditional_directive(keyword, target, delimiter, text) {
        var $a, $b, $c, TMP_50, TMP_51, TMP_52, TMP_53, self = this, no_target = nil, pair = nil, skip = nil, $case = nil, lhs = nil, op = nil, rhs = nil;

        
        if ($truthy((no_target = target['$empty?']()))) {
        } else {
          target = target.$downcase()
        };
        if ($truthy(($truthy($a = ($truthy($b = no_target) ? ($truthy($c = keyword['$==']("ifdef")) ? $c : keyword['$==']("ifndef")) : $b)) ? $a : ($truthy($b = text) ? keyword['$==']("endif") : $b)))) {
          return false};
        if (keyword['$==']("endif")) {
          
          if ($truthy(self.conditional_stack['$empty?']())) {
            self.$logger().$error(self.$message_with_context("" + "unmatched macro: endif::" + (target) + "[]", $hash2(["source_location"], {"source_location": self.$cursor()})))
          } else if ($truthy(($truthy($a = no_target) ? $a : target['$==']((pair = self.conditional_stack['$[]'](-1))['$[]']("target"))))) {
            
            self.conditional_stack.$pop();
            self.skipping = (function() {if ($truthy(self.conditional_stack['$empty?']())) {
              return false
            } else {
              return self.conditional_stack['$[]'](-1)['$[]']("skipping")
            }; return nil; })();
          } else {
            self.$logger().$error(self.$message_with_context("" + "mismatched macro: endif::" + (target) + "[], expected endif::" + (pair['$[]']("target")) + "[]", $hash2(["source_location"], {"source_location": self.$cursor()})))
          };
          return true;};
        if ($truthy(self.skipping)) {
          skip = false
        } else {
          $case = keyword;
          if ("ifdef"['$===']($case)) {$case = delimiter;
          if (","['$===']($case)) {skip = $send(target.$split(",", -1), 'none?', [], (TMP_50 = function(name){var self = TMP_50.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name);}, TMP_50.$$s = self, TMP_50.$$arity = 1, TMP_50))}
          else if ("+"['$===']($case)) {skip = $send(target.$split("+", -1), 'any?', [], (TMP_51 = function(name){var self = TMP_51.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name)['$!']();}, TMP_51.$$s = self, TMP_51.$$arity = 1, TMP_51))}
          else {skip = self.document.$attributes()['$key?'](target)['$!']()}}
          else if ("ifndef"['$===']($case)) {$case = delimiter;
          if (","['$===']($case)) {skip = $send(target.$split(",", -1), 'any?', [], (TMP_52 = function(name){var self = TMP_52.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name);}, TMP_52.$$s = self, TMP_52.$$arity = 1, TMP_52))}
          else if ("+"['$===']($case)) {skip = $send(target.$split("+", -1), 'all?', [], (TMP_53 = function(name){var self = TMP_53.$$s || this;
            if (self.document == null) self.document = nil;

          
            
            if (name == null) {
              name = nil;
            };
            return self.document.$attributes()['$key?'](name);}, TMP_53.$$s = self, TMP_53.$$arity = 1, TMP_53))}
          else {skip = self.document.$attributes()['$key?'](target)}}
          else if ("ifeval"['$===']($case)) {
          if ($truthy(($truthy($a = no_target) ? $$($nesting, 'EvalExpressionRx')['$=~'](text.$strip()) : $a))) {
          } else {
            return false
          };
          $a = [(($b = $gvars['~']) === nil ? nil : $b['$[]'](1)), (($b = $gvars['~']) === nil ? nil : $b['$[]'](2)), (($b = $gvars['~']) === nil ? nil : $b['$[]'](3))], (lhs = $a[0]), (op = $a[1]), (rhs = $a[2]), $a;
          lhs = self.$resolve_expr_val(lhs);
          rhs = self.$resolve_expr_val(rhs);
          if (op['$==']("!=")) {
            skip = lhs.$send("==", rhs)
          } else {
            skip = lhs.$send(op.$to_sym(), rhs)['$!']()
          };}
        };
        if ($truthy(($truthy($a = keyword['$==']("ifeval")) ? $a : text['$!']()))) {
          
          if ($truthy(skip)) {
            self.skipping = true};
          self.conditional_stack['$<<']($hash2(["target", "skip", "skipping"], {"target": target, "skip": skip, "skipping": self.skipping}));
        } else if ($truthy(($truthy($a = self.skipping) ? $a : skip))) {
        } else {
          
          self.$replace_next_line(text.$rstrip());
          self.$unshift("");
          if ($truthy(text['$start_with?']("include::"))) {
            self.look_ahead = $rb_minus(self.look_ahead, 1)};
        };
        return true;
      }, TMP_PreprocessorReader_preprocess_conditional_directive_49.$$arity = 4);
      
      Opal.def(self, '$preprocess_include_directive', TMP_PreprocessorReader_preprocess_include_directive_54 = function $$preprocess_include_directive(target, attrlist) {
        var $a, TMP_55, $b, TMP_56, TMP_57, TMP_58, TMP_60, TMP_63, TMP_64, TMP_65, self = this, doc = nil, expanded_target = nil, ext = nil, abs_maxdepth = nil, parsed_attrs = nil, inc_path = nil, target_type = nil, relpath = nil, inc_linenos = nil, inc_tags = nil, tag = nil, inc_lines = nil, inc_offset = nil, inc_lineno = nil, $writer = nil, tag_stack = nil, tags_used = nil, active_tag = nil, select = nil, base_select = nil, wildcard = nil, missing_tags = nil, inc_content = nil;

        
        doc = self.document;
        if ($truthy(($truthy($a = (expanded_target = target)['$include?']($$($nesting, 'ATTR_REF_HEAD'))) ? (expanded_target = doc.$sub_attributes(target, $hash2(["attribute_missing"], {"attribute_missing": "drop-line"})))['$empty?']() : $a))) {
          
          self.$shift();
          if (($truthy($a = doc.$attributes()['$[]']("attribute-missing")) ? $a : $$($nesting, 'Compliance').$attribute_missing())['$==']("skip")) {
            self.$unshift("" + "Unresolved directive in " + (self.path) + " - include::" + (target) + "[" + (attrlist) + "]")};
          return true;
        } else if ($truthy(($truthy($a = self['$include_processors?']()) ? (ext = $send(self.include_processor_extensions, 'find', [], (TMP_55 = function(candidate){var self = TMP_55.$$s || this;

        
          
          if (candidate == null) {
            candidate = nil;
          };
          return candidate.$instance()['$handles?'](expanded_target);}, TMP_55.$$s = self, TMP_55.$$arity = 1, TMP_55))) : $a))) {
          
          self.$shift();
          ext.$process_method()['$[]'](doc, self, expanded_target, doc.$parse_attributes(attrlist, [], $hash2(["sub_input"], {"sub_input": true})));
          return true;
        } else if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')))) {
          return self.$replace_next_line("" + "link:" + (expanded_target) + "[]")
        } else if ($truthy($rb_gt((abs_maxdepth = self.maxdepth['$[]']("abs")), 0))) {
          
          if ($truthy($rb_ge(self.include_stack.$size(), abs_maxdepth))) {
            
            self.$logger().$error(self.$message_with_context("" + "maximum include depth of " + (self.maxdepth['$[]']("rel")) + " exceeded", $hash2(["source_location"], {"source_location": self.$cursor()})));
            return nil;};
          parsed_attrs = doc.$parse_attributes(attrlist, [], $hash2(["sub_input"], {"sub_input": true}));
          $b = self.$resolve_include_path(expanded_target, attrlist, parsed_attrs), $a = Opal.to_ary($b), (inc_path = ($a[0] == null ? nil : $a[0])), (target_type = ($a[1] == null ? nil : $a[1])), (relpath = ($a[2] == null ? nil : $a[2])), $b;
          if ($truthy(target_type)) {
          } else {
            return inc_path
          };
          inc_linenos = (inc_tags = nil);
          if ($truthy(attrlist)) {
            if ($truthy(parsed_attrs['$key?']("lines"))) {
              
              inc_linenos = [];
              $send(self.$split_delimited_value(parsed_attrs['$[]']("lines")), 'each', [], (TMP_56 = function(linedef){var self = TMP_56.$$s || this, $c, $d, from = nil, to = nil;

              
                
                if (linedef == null) {
                  linedef = nil;
                };
                if ($truthy(linedef['$include?'](".."))) {
                  
                  $d = linedef.$split("..", 2), $c = Opal.to_ary($d), (from = ($c[0] == null ? nil : $c[0])), (to = ($c[1] == null ? nil : $c[1])), $d;
                  return (inc_linenos = $rb_plus(inc_linenos, (function() {if ($truthy(($truthy($c = to['$empty?']()) ? $c : $rb_lt((to = to.$to_i()), 0)))) {
                    return [from.$to_i(), $rb_divide(1, 0)]
                  } else {
                    return $$$('::', 'Range').$new(from.$to_i(), to).$to_a()
                  }; return nil; })()));
                } else {
                  return inc_linenos['$<<'](linedef.$to_i())
                };}, TMP_56.$$s = self, TMP_56.$$arity = 1, TMP_56));
              inc_linenos = (function() {if ($truthy(inc_linenos['$empty?']())) {
                return nil
              } else {
                return inc_linenos.$sort().$uniq()
              }; return nil; })();
            } else if ($truthy(parsed_attrs['$key?']("tag"))) {
              if ($truthy(($truthy($a = (tag = parsed_attrs['$[]']("tag"))['$empty?']()) ? $a : tag['$==']("!")))) {
              } else {
                inc_tags = (function() {if ($truthy(tag['$start_with?']("!"))) {
                  return $hash(tag.$slice(1, tag.$length()), false)
                } else {
                  return $hash(tag, true)
                }; return nil; })()
              }
            } else if ($truthy(parsed_attrs['$key?']("tags"))) {
              
              inc_tags = $hash2([], {});
              $send(self.$split_delimited_value(parsed_attrs['$[]']("tags")), 'each', [], (TMP_57 = function(tagdef){var self = TMP_57.$$s || this, $c, $writer = nil;

              
                
                if (tagdef == null) {
                  tagdef = nil;
                };
                if ($truthy(($truthy($c = tagdef['$empty?']()) ? $c : tagdef['$==']("!")))) {
                  return nil
                } else if ($truthy(tagdef['$start_with?']("!"))) {
                  
                  $writer = [tagdef.$slice(1, tagdef.$length()), false];
                  $send(inc_tags, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                } else {
                  
                  $writer = [tagdef, true];
                  $send(inc_tags, '[]=', Opal.to_a($writer));
                  return $writer[$rb_minus($writer["length"], 1)];
                };}, TMP_57.$$s = self, TMP_57.$$arity = 1, TMP_57));
              if ($truthy(inc_tags['$empty?']())) {
                inc_tags = nil};}};
          if ($truthy(inc_linenos)) {
            
            $a = [[], nil, 0], (inc_lines = $a[0]), (inc_offset = $a[1]), (inc_lineno = $a[2]), $a;
            
            try {
              (function(){var $brk = Opal.new_brk(); try {return $send(self, 'open', [inc_path, "rb"], (TMP_58 = function(f){var self = TMP_58.$$s || this, TMP_59, select_remaining = nil;

              
                
                if (f == null) {
                  f = nil;
                };
                select_remaining = nil;
                return (function(){var $brk = Opal.new_brk(); try {return $send(f, 'each_line', [], (TMP_59 = function(l){var self = TMP_59.$$s || this, $c, $d, select = nil;

                
                  
                  if (l == null) {
                    l = nil;
                  };
                  inc_lineno = $rb_plus(inc_lineno, 1);
                  if ($truthy(($truthy($c = select_remaining) ? $c : ($truthy($d = $$$('::', 'Float')['$===']((select = inc_linenos['$[]'](0)))) ? (select_remaining = select['$infinite?']()) : $d)))) {
                    
                    inc_offset = ($truthy($c = inc_offset) ? $c : inc_lineno);
                    return inc_lines['$<<'](l);
                  } else {
                    
                    if (select['$=='](inc_lineno)) {
                      
                      inc_offset = ($truthy($c = inc_offset) ? $c : inc_lineno);
                      inc_lines['$<<'](l);
                      inc_linenos.$shift();};
                    if ($truthy(inc_linenos['$empty?']())) {
                      
                      Opal.brk(nil, $brk)
                    } else {
                      return nil
                    };
                  };}, TMP_59.$$s = self, TMP_59.$$brk = $brk, TMP_59.$$arity = 1, TMP_59))
                } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})();}, TMP_58.$$s = self, TMP_58.$$brk = $brk, TMP_58.$$arity = 1, TMP_58))
              } catch (err) { if (err === $brk) { return err.$v } else { throw err } }})()
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  
                  self.$logger().$error(self.$message_with_context("" + "include " + (target_type) + " not readable: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
                  return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (expanded_target) + "[" + (attrlist) + "]");
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };;
            self.$shift();
            if ($truthy(inc_offset)) {
              
              
              $writer = ["partial-option", true];
              $send(parsed_attrs, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;
              self.$push_include(inc_lines, inc_path, relpath, inc_offset, parsed_attrs);};
          } else if ($truthy(inc_tags)) {
            
            $a = [[], nil, 0, [], $$$('::', 'Set').$new(), nil], (inc_lines = $a[0]), (inc_offset = $a[1]), (inc_lineno = $a[2]), (tag_stack = $a[3]), (tags_used = $a[4]), (active_tag = $a[5]), $a;
            if ($truthy(inc_tags['$key?']("**"))) {
              if ($truthy(inc_tags['$key?']("*"))) {
                
                select = (base_select = inc_tags.$delete("**"));
                wildcard = inc_tags.$delete("*");
              } else {
                select = (base_select = (wildcard = inc_tags.$delete("**")))
              }
            } else {
              
              select = (base_select = inc_tags['$value?'](true)['$!']());
              wildcard = inc_tags.$delete("*");
            };
            
            try {
              $send(self, 'open', [inc_path, "rb"], (TMP_60 = function(f){var self = TMP_60.$$s || this, $c, TMP_61, dbl_co = nil, dbl_sb = nil, encoding = nil;

              
                
                if (f == null) {
                  f = nil;
                };
                $c = ["::", "[]"], (dbl_co = $c[0]), (dbl_sb = $c[1]), $c;
                if ($truthy($$($nesting, 'COERCE_ENCODING'))) {
                  encoding = $$$($$$('::', 'Encoding'), 'UTF_8')};
                return $send(f, 'each_line', [], (TMP_61 = function(l){var self = TMP_61.$$s || this, $d, $e, TMP_62, this_tag = nil, include_cursor = nil, idx = nil;

                
                  
                  if (l == null) {
                    l = nil;
                  };
                  inc_lineno = $rb_plus(inc_lineno, 1);
                  if ($truthy(encoding)) {
                    l.$force_encoding(encoding)};
                  if ($truthy(($truthy($d = ($truthy($e = l['$include?'](dbl_co)) ? l['$include?'](dbl_sb) : $e)) ? $$($nesting, 'TagDirectiveRx')['$=~'](l) : $d))) {
                    if ($truthy((($d = $gvars['~']) === nil ? nil : $d['$[]'](1)))) {
                      if ((this_tag = (($d = $gvars['~']) === nil ? nil : $d['$[]'](2)))['$=='](active_tag)) {
                        
                        tag_stack.$pop();
                        return $e = (function() {if ($truthy(tag_stack['$empty?']())) {
                          return [nil, base_select]
                        } else {
                          return tag_stack['$[]'](-1)
                        }; return nil; })(), $d = Opal.to_ary($e), (active_tag = ($d[0] == null ? nil : $d[0])), (select = ($d[1] == null ? nil : $d[1])), $e;
                      } else if ($truthy(inc_tags['$key?'](this_tag))) {
                        
                        include_cursor = self.$create_include_cursor(inc_path, expanded_target, inc_lineno);
                        if ($truthy((idx = $send(tag_stack, 'rindex', [], (TMP_62 = function(key, _){var self = TMP_62.$$s || this;

                        
                          
                          if (key == null) {
                            key = nil;
                          };
                          
                          if (_ == null) {
                            _ = nil;
                          };
                          return key['$=='](this_tag);}, TMP_62.$$s = self, TMP_62.$$arity = 2, TMP_62))))) {
                          
                          if (idx['$=='](0)) {
                            tag_stack.$shift()
                          } else {
                            
                            tag_stack.$delete_at(idx);
                          };
                          return self.$logger().$warn(self.$message_with_context("" + "mismatched end tag (expected '" + (active_tag) + "' but found '" + (this_tag) + "') at line " + (inc_lineno) + " of include " + (target_type) + ": " + (inc_path), $hash2(["source_location", "include_location"], {"source_location": self.$cursor(), "include_location": include_cursor})));
                        } else {
                          return self.$logger().$warn(self.$message_with_context("" + "unexpected end tag '" + (this_tag) + "' at line " + (inc_lineno) + " of include " + (target_type) + ": " + (inc_path), $hash2(["source_location", "include_location"], {"source_location": self.$cursor(), "include_location": include_cursor})))
                        };
                      } else {
                        return nil
                      }
                    } else if ($truthy(inc_tags['$key?']((this_tag = (($d = $gvars['~']) === nil ? nil : $d['$[]'](2)))))) {
                      
                      tags_used['$<<'](this_tag);
                      return tag_stack['$<<']([(active_tag = this_tag), (select = inc_tags['$[]'](this_tag)), inc_lineno]);
                    } else if ($truthy(wildcard['$nil?']()['$!']())) {
                      
                      select = (function() {if ($truthy(($truthy($d = active_tag) ? select['$!']() : $d))) {
                        return false
                      } else {
                        return wildcard
                      }; return nil; })();
                      return tag_stack['$<<']([(active_tag = this_tag), select, inc_lineno]);
                    } else {
                      return nil
                    }
                  } else if ($truthy(select)) {
                    
                    inc_offset = ($truthy($d = inc_offset) ? $d : inc_lineno);
                    return inc_lines['$<<'](l);
                  } else {
                    return nil
                  };}, TMP_61.$$s = self, TMP_61.$$arity = 1, TMP_61));}, TMP_60.$$s = self, TMP_60.$$arity = 1, TMP_60))
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  
                  self.$logger().$error(self.$message_with_context("" + "include " + (target_type) + " not readable: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
                  return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (expanded_target) + "[" + (attrlist) + "]");
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };;
            if ($truthy(tag_stack['$empty?']())) {
            } else {
              $send(tag_stack, 'each', [], (TMP_63 = function(tag_name, _, tag_lineno){var self = TMP_63.$$s || this;

              
                
                if (tag_name == null) {
                  tag_name = nil;
                };
                
                if (_ == null) {
                  _ = nil;
                };
                
                if (tag_lineno == null) {
                  tag_lineno = nil;
                };
                return self.$logger().$warn(self.$message_with_context("" + "detected unclosed tag '" + (tag_name) + "' starting at line " + (tag_lineno) + " of include " + (target_type) + ": " + (inc_path), $hash2(["source_location", "include_location"], {"source_location": self.$cursor(), "include_location": self.$create_include_cursor(inc_path, expanded_target, tag_lineno)})));}, TMP_63.$$s = self, TMP_63.$$arity = 3, TMP_63))
            };
            if ($truthy((missing_tags = $rb_minus(inc_tags.$keys().$to_a(), tags_used.$to_a()))['$empty?']())) {
            } else {
              self.$logger().$warn(self.$message_with_context("" + "tag" + ((function() {if ($truthy($rb_gt(missing_tags.$size(), 1))) {
                return "s"
              } else {
                return ""
              }; return nil; })()) + " '" + (missing_tags.$join(", ")) + "' not found in include " + (target_type) + ": " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})))
            };
            self.$shift();
            if ($truthy(inc_offset)) {
              
              if ($truthy(($truthy($a = ($truthy($b = base_select) ? wildcard : $b)) ? inc_tags['$empty?']() : $a))) {
              } else {
                
                $writer = ["partial-option", true];
                $send(parsed_attrs, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];
              };
              self.$push_include(inc_lines, inc_path, relpath, inc_offset, parsed_attrs);};
          } else {
            
            try {
              
              inc_content = (function() {if (false) {
                return $send($$$('::', 'File'), 'open', [inc_path, "rb"], (TMP_64 = function(f){var self = TMP_64.$$s || this;

                
                  
                  if (f == null) {
                    f = nil;
                  };
                  return f.$read();}, TMP_64.$$s = self, TMP_64.$$arity = 1, TMP_64))
              } else {
                return $send(self, 'open', [inc_path, "rb"], (TMP_65 = function(f){var self = TMP_65.$$s || this;

                
                  
                  if (f == null) {
                    f = nil;
                  };
                  return f.$read();}, TMP_65.$$s = self, TMP_65.$$arity = 1, TMP_65))
              }; return nil; })();
              self.$shift();
              self.$push_include(inc_content, inc_path, relpath, 1, parsed_attrs);
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  
                  self.$logger().$error(self.$message_with_context("" + "include " + (target_type) + " not readable: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
                  return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (expanded_target) + "[" + (attrlist) + "]");
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };
          };
          return true;
        } else {
          return nil
        };
      }, TMP_PreprocessorReader_preprocess_include_directive_54.$$arity = 2);
      
      Opal.def(self, '$resolve_include_path', TMP_PreprocessorReader_resolve_include_path_66 = function $$resolve_include_path(target, attrlist, attributes) {
        var $a, $b, self = this, doc = nil, inc_path = nil, relpath = nil;

        
        doc = self.document;
        if ($truthy(($truthy($a = $$($nesting, 'Helpers')['$uriish?'](target)) ? $a : (function() {if ($truthy($$$('::', 'String')['$==='](self.dir))) {
          return nil
        } else {
          
          return (target = "" + (self.dir) + "/" + (target));
        }; return nil; })()))) {
          
          if ($truthy(doc['$attr?']("allow-uri-read"))) {
          } else {
            return self.$replace_next_line("" + "link:" + (target) + "[" + (attrlist) + "]")
          };
          if ($truthy(doc['$attr?']("cache-uri"))) {
            if ($truthy((($b = $$$('::', 'OpenURI', 'skip_raise')) && ($a = $$$($b, 'Cache', 'skip_raise')) ? 'constant' : nil))) {
            } else {
              $$($nesting, 'Helpers').$require_library("open-uri/cached", "open-uri-cached")
            }
          } else if ($truthy($$$('::', 'RUBY_ENGINE_OPAL')['$!']())) {
            $$$('::', 'OpenURI')};
          return [$$$('::', 'URI').$parse(target), "uri", target];
        } else {
          
          inc_path = doc.$normalize_system_path(target, self.dir, nil, $hash2(["target_name"], {"target_name": "include file"}));
          if ($truthy($$$('::', 'File')['$file?'](inc_path))) {
          } else if ($truthy(attributes['$key?']("optional-option"))) {
            
            self.$shift();
            return true;
          } else {
            
            self.$logger().$error(self.$message_with_context("" + "include file not found: " + (inc_path), $hash2(["source_location"], {"source_location": self.$cursor()})));
            return self.$replace_next_line("" + "Unresolved directive in " + (self.path) + " - include::" + (target) + "[" + (attrlist) + "]");
          };
          relpath = doc.$path_resolver().$relative_path(inc_path, doc.$base_dir());
          return [inc_path, "file", relpath];
        };
      }, TMP_PreprocessorReader_resolve_include_path_66.$$arity = 3);
      
      Opal.def(self, '$push_include', TMP_PreprocessorReader_push_include_67 = function $$push_include(data, file, path, lineno, attributes) {
        var $a, self = this, $writer = nil, dir = nil, depth = nil, old_leveloffset = nil;

        
        
        if (file == null) {
          file = nil;
        };
        
        if (path == null) {
          path = nil;
        };
        
        if (lineno == null) {
          lineno = 1;
        };
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        self.include_stack['$<<']([self.lines, self.file, self.dir, self.path, self.lineno, self.maxdepth, self.process_lines]);
        if ($truthy((self.file = file))) {
          
          if ($truthy($$$('::', 'String')['$==='](file))) {
            self.dir = $$$('::', 'File').$dirname(file)
          } else if ($truthy($$$('::', 'RUBY_ENGINE_OPAL'))) {
            self.dir = $$$('::', 'URI').$parse($$$('::', 'File').$dirname((file = file.$to_s())))
          } else {
            
            
            $writer = [(function() {if ((dir = $$$('::', 'File').$dirname(file.$path()))['$==']("/")) {
              return ""
            } else {
              return dir
            }; return nil; })()];
            $send((self.dir = file.$dup()), 'path=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            file = file.$to_s();
          };
          path = ($truthy($a = path) ? $a : $$$('::', 'File').$basename(file));
          self.process_lines = $$($nesting, 'ASCIIDOC_EXTENSIONS')['$[]']($$$('::', 'File').$extname(file));
        } else {
          
          self.dir = ".";
          self.process_lines = true;
        };
        if ($truthy(path)) {
          
          self.path = path;
          if ($truthy(self.process_lines)) {
            
            $writer = [$$($nesting, 'Helpers').$rootname(path), (function() {if ($truthy(attributes['$[]']("partial-option"))) {
              return nil
            } else {
              return true
            }; return nil; })()];
            $send(self.includes, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
        } else {
          self.path = "<stdin>"
        };
        self.lineno = lineno;
        if ($truthy(attributes['$key?']("depth"))) {
          
          depth = attributes['$[]']("depth").$to_i();
          if ($truthy($rb_le(depth, 0))) {
            depth = 1};
          self.maxdepth = $hash2(["abs", "rel"], {"abs": $rb_plus($rb_minus(self.include_stack.$size(), 1), depth), "rel": depth});};
        if ($truthy((self.lines = self.$prepare_lines(data, $hash2(["normalize", "condense", "indent"], {"normalize": true, "condense": false, "indent": attributes['$[]']("indent")})))['$empty?']())) {
          self.$pop_include()
        } else {
          
          if ($truthy(attributes['$key?']("leveloffset"))) {
            
            self.lines.$unshift("");
            self.lines.$unshift("" + ":leveloffset: " + (attributes['$[]']("leveloffset")));
            self.lines['$<<']("");
            if ($truthy((old_leveloffset = self.document.$attr("leveloffset")))) {
              self.lines['$<<']("" + ":leveloffset: " + (old_leveloffset))
            } else {
              self.lines['$<<'](":leveloffset!:")
            };
            self.lineno = $rb_minus(self.lineno, 2);};
          self.look_ahead = 0;
        };
        return self;
      }, TMP_PreprocessorReader_push_include_67.$$arity = -2);
      
      Opal.def(self, '$create_include_cursor', TMP_PreprocessorReader_create_include_cursor_68 = function $$create_include_cursor(file, path, lineno) {
        var self = this, dir = nil;

        
        if ($truthy($$$('::', 'String')['$==='](file))) {
          dir = $$$('::', 'File').$dirname(file)
        } else if ($truthy($$$('::', 'RUBY_ENGINE_OPAL'))) {
          dir = $$$('::', 'File').$dirname((file = file.$to_s()))
        } else {
          
          dir = (function() {if ((dir = $$$('::', 'File').$dirname(file.$path()))['$==']("")) {
            return "/"
          } else {
            return dir
          }; return nil; })();
          file = file.$to_s();
        };
        return $$($nesting, 'Cursor').$new(file, dir, path, lineno);
      }, TMP_PreprocessorReader_create_include_cursor_68.$$arity = 3);
      
      Opal.def(self, '$pop_include', TMP_PreprocessorReader_pop_include_69 = function $$pop_include() {
        var $a, $b, self = this;

        if ($truthy($rb_gt(self.include_stack.$size(), 0))) {
          
          $b = self.include_stack.$pop(), $a = Opal.to_ary($b), (self.lines = ($a[0] == null ? nil : $a[0])), (self.file = ($a[1] == null ? nil : $a[1])), (self.dir = ($a[2] == null ? nil : $a[2])), (self.path = ($a[3] == null ? nil : $a[3])), (self.lineno = ($a[4] == null ? nil : $a[4])), (self.maxdepth = ($a[5] == null ? nil : $a[5])), (self.process_lines = ($a[6] == null ? nil : $a[6])), $b;
          self.look_ahead = 0;
          return nil;
        } else {
          return nil
        }
      }, TMP_PreprocessorReader_pop_include_69.$$arity = 0);
      
      Opal.def(self, '$include_depth', TMP_PreprocessorReader_include_depth_70 = function $$include_depth() {
        var self = this;

        return self.include_stack.$size()
      }, TMP_PreprocessorReader_include_depth_70.$$arity = 0);
      
      Opal.def(self, '$exceeded_max_depth?', TMP_PreprocessorReader_exceeded_max_depth$q_71 = function() {
        var $a, self = this, abs_maxdepth = nil;

        if ($truthy(($truthy($a = $rb_gt((abs_maxdepth = self.maxdepth['$[]']("abs")), 0)) ? $rb_ge(self.include_stack.$size(), abs_maxdepth) : $a))) {
          return self.maxdepth['$[]']("rel")
        } else {
          return false
        }
      }, TMP_PreprocessorReader_exceeded_max_depth$q_71.$$arity = 0);
      
      Opal.def(self, '$shift', TMP_PreprocessorReader_shift_72 = function $$shift() {
        var $iter = TMP_PreprocessorReader_shift_72.$$p, $yield = $iter || nil, self = this, line = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_PreprocessorReader_shift_72.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        if ($truthy(self.unescape_next_line)) {
          
          self.unescape_next_line = false;
          return (line = $send(self, Opal.find_super_dispatcher(self, 'shift', TMP_PreprocessorReader_shift_72, false), $zuper, $iter)).$slice(1, line.$length());
        } else {
          return $send(self, Opal.find_super_dispatcher(self, 'shift', TMP_PreprocessorReader_shift_72, false), $zuper, $iter)
        }
      }, TMP_PreprocessorReader_shift_72.$$arity = 0);
      
      Opal.def(self, '$split_delimited_value', TMP_PreprocessorReader_split_delimited_value_73 = function $$split_delimited_value(val) {
        var self = this;

        if ($truthy(val['$include?'](","))) {
          
          return val.$split(",");
        } else {
          
          return val.$split(";");
        }
      }, TMP_PreprocessorReader_split_delimited_value_73.$$arity = 1);
      
      Opal.def(self, '$skip_front_matter!', TMP_PreprocessorReader_skip_front_matter$B_74 = function(data, increment_linenos) {
        var $a, $b, self = this, front_matter = nil, original_data = nil;

        
        
        if (increment_linenos == null) {
          increment_linenos = true;
        };
        front_matter = nil;
        if (data['$[]'](0)['$==']("---")) {
          
          original_data = data.$drop(0);
          data.$shift();
          front_matter = [];
          if ($truthy(increment_linenos)) {
            self.lineno = $rb_plus(self.lineno, 1)};
          while ($truthy(($truthy($b = data['$empty?']()['$!']()) ? data['$[]'](0)['$!=']("---") : $b))) {
            
            front_matter['$<<'](data.$shift());
            if ($truthy(increment_linenos)) {
              self.lineno = $rb_plus(self.lineno, 1)};
          };
          if ($truthy(data['$empty?']())) {
            
            $send(data, 'unshift', Opal.to_a(original_data));
            if ($truthy(increment_linenos)) {
              self.lineno = 0};
            front_matter = nil;
          } else {
            
            data.$shift();
            if ($truthy(increment_linenos)) {
              self.lineno = $rb_plus(self.lineno, 1)};
          };};
        return front_matter;
      }, TMP_PreprocessorReader_skip_front_matter$B_74.$$arity = -2);
      
      Opal.def(self, '$resolve_expr_val', TMP_PreprocessorReader_resolve_expr_val_75 = function $$resolve_expr_val(val) {
        var $a, $b, self = this, quoted = nil;

        
        if ($truthy(($truthy($a = ($truthy($b = val['$start_with?']("\"")) ? val['$end_with?']("\"") : $b)) ? $a : ($truthy($b = val['$start_with?']("'")) ? val['$end_with?']("'") : $b)))) {
          
          quoted = true;
          val = val.$slice(1, $rb_minus(val.$length(), 1));
        } else {
          quoted = false
        };
        if ($truthy(val['$include?']($$($nesting, 'ATTR_REF_HEAD')))) {
          val = self.document.$sub_attributes(val, $hash2(["attribute_missing"], {"attribute_missing": "drop"}))};
        if ($truthy(quoted)) {
          return val
        } else if ($truthy(val['$empty?']())) {
          return nil
        } else if (val['$==']("true")) {
          return true
        } else if (val['$==']("false")) {
          return false
        } else if ($truthy(val.$rstrip()['$empty?']())) {
          return " "
        } else if ($truthy(val['$include?']("."))) {
          return val.$to_f()
        } else {
          return val.$to_i()
        };
      }, TMP_PreprocessorReader_resolve_expr_val_75.$$arity = 1);
      
      Opal.def(self, '$include_processors?', TMP_PreprocessorReader_include_processors$q_76 = function() {
        var $a, self = this;

        if ($truthy(self.include_processor_extensions['$nil?']())) {
          if ($truthy(($truthy($a = self.document['$extensions?']()) ? self.document.$extensions()['$include_processors?']() : $a))) {
            return (self.include_processor_extensions = self.document.$extensions().$include_processors())['$!']()['$!']()
          } else {
            return (self.include_processor_extensions = false)
          }
        } else {
          return self.include_processor_extensions['$!='](false)
        }
      }, TMP_PreprocessorReader_include_processors$q_76.$$arity = 0);
      return (Opal.def(self, '$to_s', TMP_PreprocessorReader_to_s_77 = function $$to_s() {
        var TMP_78, self = this;

        return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {path: " + (self.path.$inspect()) + ", line #: " + (self.lineno) + ", include depth: " + (self.include_stack.$size()) + ", include stack: [" + ($send(self.include_stack, 'map', [], (TMP_78 = function(inc){var self = TMP_78.$$s || this;

        
          
          if (inc == null) {
            inc = nil;
          };
          return inc.$to_s();}, TMP_78.$$s = self, TMP_78.$$arity = 1, TMP_78)).$join(", ")) + "]}>"
      }, TMP_PreprocessorReader_to_s_77.$$arity = 0), nil) && 'to_s';
    })($nesting[0], $$($nesting, 'Reader'), $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/section"] = function(Opal) {
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $truthy = Opal.truthy;

  Opal.add_stubs(['$attr_accessor', '$attr_reader', '$===', '$+', '$level', '$special', '$generate_id', '$title', '$==', '$>', '$sectnum', '$int_to_roman', '$to_i', '$reftext', '$!', '$empty?', '$sprintf', '$sub_quotes', '$compat_mode', '$[]', '$attributes', '$context', '$assign_numeral', '$class', '$object_id', '$inspect', '$size', '$length', '$chr', '$[]=', '$-', '$gsub', '$downcase', '$delete', '$tr_s', '$end_with?', '$chop', '$start_with?', '$slice', '$key?', '$catalog', '$unique_id_start_index']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Section(){};
      var self = $Section = $klass($base, $super, 'Section', $Section);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Section_initialize_1, TMP_Section_generate_id_2, TMP_Section_sectnum_3, TMP_Section_xreftext_4, TMP_Section_$lt$lt_5, TMP_Section_to_s_6, TMP_Section_generate_id_7;

      def.document = def.level = def.numeral = def.parent = def.numbered = def.sectname = def.title = def.blocks = nil;
      
      self.$attr_accessor("index");
      self.$attr_accessor("sectname");
      self.$attr_accessor("special");
      self.$attr_accessor("numbered");
      self.$attr_reader("caption");
      
      Opal.def(self, '$initialize', TMP_Section_initialize_1 = function $$initialize(parent, level, numbered, opts) {
        var $a, $b, $iter = TMP_Section_initialize_1.$$p, $yield = $iter || nil, self = this;

        if ($iter) TMP_Section_initialize_1.$$p = null;
        
        
        if (parent == null) {
          parent = nil;
        };
        
        if (level == null) {
          level = nil;
        };
        
        if (numbered == null) {
          numbered = false;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Section_initialize_1, false), [parent, "section", opts], null);
        if ($truthy($$($nesting, 'Section')['$==='](parent))) {
          $a = [($truthy($b = level) ? $b : $rb_plus(parent.$level(), 1)), parent.$special()], (self.level = $a[0]), (self.special = $a[1]), $a
        } else {
          $a = [($truthy($b = level) ? $b : 1), false], (self.level = $a[0]), (self.special = $a[1]), $a
        };
        self.numbered = numbered;
        return (self.index = 0);
      }, TMP_Section_initialize_1.$$arity = -1);
      Opal.alias(self, "name", "title");
      
      Opal.def(self, '$generate_id', TMP_Section_generate_id_2 = function $$generate_id() {
        var self = this;

        return $$($nesting, 'Section').$generate_id(self.$title(), self.document)
      }, TMP_Section_generate_id_2.$$arity = 0);
      
      Opal.def(self, '$sectnum', TMP_Section_sectnum_3 = function $$sectnum(delimiter, append) {
        var $a, self = this;

        
        
        if (delimiter == null) {
          delimiter = ".";
        };
        
        if (append == null) {
          append = nil;
        };
        append = ($truthy($a = append) ? $a : (function() {if (append['$=='](false)) {
          return ""
        } else {
          return delimiter
        }; return nil; })());
        if (self.level['$=='](1)) {
          return "" + (self.numeral) + (append)
        } else if ($truthy($rb_gt(self.level, 1))) {
          if ($truthy($$($nesting, 'Section')['$==='](self.parent))) {
            return "" + (self.parent.$sectnum(delimiter, delimiter)) + (self.numeral) + (append)
          } else {
            return "" + (self.numeral) + (append)
          }
        } else {
          return "" + ($$($nesting, 'Helpers').$int_to_roman(self.numeral.$to_i())) + (append)
        };
      }, TMP_Section_sectnum_3.$$arity = -1);
      
      Opal.def(self, '$xreftext', TMP_Section_xreftext_4 = function $$xreftext(xrefstyle) {
        var $a, self = this, val = nil, $case = nil, type = nil, quoted_title = nil, signifier = nil;

        
        
        if (xrefstyle == null) {
          xrefstyle = nil;
        };
        if ($truthy(($truthy($a = (val = self.$reftext())) ? val['$empty?']()['$!']() : $a))) {
          return val
        } else if ($truthy(xrefstyle)) {
          if ($truthy(self.numbered)) {
            return (function() {$case = xrefstyle;
            if ("full"['$===']($case)) {
            if ($truthy(($truthy($a = (type = self.sectname)['$==']("chapter")) ? $a : type['$==']("appendix")))) {
              quoted_title = self.$sprintf(self.$sub_quotes("_%s_"), self.$title())
            } else {
              quoted_title = self.$sprintf(self.$sub_quotes((function() {if ($truthy(self.document.$compat_mode())) {
                return "``%s''"
              } else {
                return "\"`%s`\""
              }; return nil; })()), self.$title())
            };
            if ($truthy((signifier = self.document.$attributes()['$[]']("" + (type) + "-refsig")))) {
              return "" + (signifier) + " " + (self.$sectnum(".", ",")) + " " + (quoted_title)
            } else {
              return "" + (self.$sectnum(".", ",")) + " " + (quoted_title)
            };}
            else if ("short"['$===']($case)) {if ($truthy((signifier = self.document.$attributes()['$[]']("" + (self.sectname) + "-refsig")))) {
              return "" + (signifier) + " " + (self.$sectnum(".", ""))
            } else {
              return self.$sectnum(".", "")
            }}
            else {if ($truthy(($truthy($a = (type = self.sectname)['$==']("chapter")) ? $a : type['$==']("appendix")))) {
              
              return self.$sprintf(self.$sub_quotes("_%s_"), self.$title());
            } else {
              return self.$title()
            }}})()
          } else if ($truthy(($truthy($a = (type = self.sectname)['$==']("chapter")) ? $a : type['$==']("appendix")))) {
            
            return self.$sprintf(self.$sub_quotes("_%s_"), self.$title());
          } else {
            return self.$title()
          }
        } else {
          return self.$title()
        };
      }, TMP_Section_xreftext_4.$$arity = -1);
      
      Opal.def(self, '$<<', TMP_Section_$lt$lt_5 = function(block) {
        var $iter = TMP_Section_$lt$lt_5.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Section_$lt$lt_5.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        
        if (block.$context()['$==']("section")) {
          self.$assign_numeral(block)};
        return $send(self, Opal.find_super_dispatcher(self, '<<', TMP_Section_$lt$lt_5, false), $zuper, $iter);
      }, TMP_Section_$lt$lt_5.$$arity = 1);
      
      Opal.def(self, '$to_s', TMP_Section_to_s_6 = function $$to_s() {
        var $iter = TMP_Section_to_s_6.$$p, $yield = $iter || nil, self = this, formal_title = nil, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Section_to_s_6.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        if ($truthy(self.title)) {
          
          formal_title = (function() {if ($truthy(self.numbered)) {
            return "" + (self.$sectnum()) + " " + (self.title)
          } else {
            return self.title
          }; return nil; })();
          return "" + "#<" + (self.$class()) + "@" + (self.$object_id()) + " {level: " + (self.level) + ", title: " + (formal_title.$inspect()) + ", blocks: " + (self.blocks.$size()) + "}>";
        } else {
          return $send(self, Opal.find_super_dispatcher(self, 'to_s', TMP_Section_to_s_6, false), $zuper, $iter)
        }
      }, TMP_Section_to_s_6.$$arity = 0);
      return (Opal.defs(self, '$generate_id', TMP_Section_generate_id_7 = function $$generate_id(title, document) {
        var $a, $b, self = this, attrs = nil, pre = nil, sep = nil, no_sep = nil, $writer = nil, sep_sub = nil, gen_id = nil, ids = nil, cnt = nil, candidate_id = nil;

        
        attrs = document.$attributes();
        pre = ($truthy($a = attrs['$[]']("idprefix")) ? $a : "_");
        if ($truthy((sep = attrs['$[]']("idseparator")))) {
          if ($truthy(($truthy($a = sep.$length()['$=='](1)) ? $a : ($truthy($b = (no_sep = sep['$empty?']())['$!']()) ? (sep = (($writer = ["idseparator", sep.$chr()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])) : $b)))) {
            sep_sub = (function() {if ($truthy(($truthy($a = sep['$==']("-")) ? $a : sep['$=='](".")))) {
              return " .-"
            } else {
              return "" + " " + (sep) + ".-"
            }; return nil; })()}
        } else {
          $a = ["_", " _.-"], (sep = $a[0]), (sep_sub = $a[1]), $a
        };
        gen_id = "" + (pre) + (title.$downcase().$gsub($$($nesting, 'InvalidSectionIdCharsRx'), ""));
        if ($truthy(no_sep)) {
          gen_id = gen_id.$delete(" ")
        } else {
          
          gen_id = gen_id.$tr_s(sep_sub, sep);
          if ($truthy(gen_id['$end_with?'](sep))) {
            gen_id = gen_id.$chop()};
          if ($truthy(($truthy($a = pre['$empty?']()) ? gen_id['$start_with?'](sep) : $a))) {
            gen_id = gen_id.$slice(1, gen_id.$length())};
        };
        if ($truthy(document.$catalog()['$[]']("ids")['$key?'](gen_id))) {
          
          $a = [document.$catalog()['$[]']("ids"), $$($nesting, 'Compliance').$unique_id_start_index()], (ids = $a[0]), (cnt = $a[1]), $a;
          while ($truthy(ids['$key?']((candidate_id = "" + (gen_id) + (sep) + (cnt))))) {
            cnt = $rb_plus(cnt, 1)
          };
          return candidate_id;
        } else {
          return gen_id
        };
      }, TMP_Section_generate_id_7.$$arity = 2), nil) && 'generate_id';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/stylesheets"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy, $hash2 = Opal.hash2, $gvars = Opal.gvars, $send = Opal.send;

  Opal.add_stubs(['$join', '$new', '$rstrip', '$read', '$primary_stylesheet_data', '$write', '$primary_stylesheet_name', '$coderay_stylesheet_data', '$coderay_stylesheet_name', '$load_pygments', '$=~', '$css', '$[]', '$sub', '$[]=', '$-', '$pygments_stylesheet_data', '$pygments_stylesheet_name', '$!', '$nil?', '$require_library']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Stylesheets(){};
      var self = $Stylesheets = $klass($base, $super, 'Stylesheets', $Stylesheets);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Stylesheets_instance_1, TMP_Stylesheets_primary_stylesheet_name_2, TMP_Stylesheets_primary_stylesheet_data_3, TMP_Stylesheets_embed_primary_stylesheet_4, TMP_Stylesheets_write_primary_stylesheet_5, TMP_Stylesheets_coderay_stylesheet_name_6, TMP_Stylesheets_coderay_stylesheet_data_7, TMP_Stylesheets_embed_coderay_stylesheet_8, TMP_Stylesheets_write_coderay_stylesheet_9, TMP_Stylesheets_pygments_stylesheet_name_10, TMP_Stylesheets_pygments_background_11, TMP_Stylesheets_pygments_stylesheet_data_12, TMP_Stylesheets_embed_pygments_stylesheet_13, TMP_Stylesheets_write_pygments_stylesheet_14, TMP_Stylesheets_load_pygments_15;

      def.primary_stylesheet_data = def.coderay_stylesheet_data = def.pygments_stylesheet_data = nil;
      
      Opal.const_set($nesting[0], 'DEFAULT_STYLESHEET_NAME', "asciidoctor.css");
      Opal.const_set($nesting[0], 'DEFAULT_PYGMENTS_STYLE', "default");
      Opal.const_set($nesting[0], 'STYLESHEETS_DATA_PATH', $$$('::', 'File').$join($$($nesting, 'DATA_PATH'), "stylesheets"));
      Opal.const_set($nesting[0], 'PygmentsBgColorRx', /^\.pygments +\{ *background: *([^;]+);/);
      self.__instance__ = self.$new();
      Opal.defs(self, '$instance', TMP_Stylesheets_instance_1 = function $$instance() {
        var self = this;
        if (self.__instance__ == null) self.__instance__ = nil;

        return self.__instance__
      }, TMP_Stylesheets_instance_1.$$arity = 0);
      
      Opal.def(self, '$primary_stylesheet_name', TMP_Stylesheets_primary_stylesheet_name_2 = function $$primary_stylesheet_name() {
        var self = this;

        return $$($nesting, 'DEFAULT_STYLESHEET_NAME')
      }, TMP_Stylesheets_primary_stylesheet_name_2.$$arity = 0);
      
      Opal.def(self, '$primary_stylesheet_data', TMP_Stylesheets_primary_stylesheet_data_3 = function $$primary_stylesheet_data() {

var File = Opal.const_get_relative([], "File");
var stylesheetsPath;
if (Opal.const_get_relative([], "JAVASCRIPT_PLATFORM")["$=="]("node")) {
  if (File.$basename(__dirname) === "node" && File.$basename(File.$dirname(__dirname)) === "dist") {
    stylesheetsPath = File.$join(File.$dirname(__dirname), "css");
  } else {
    stylesheetsPath = File.$join(__dirname, "css");
  }
} else if (Opal.const_get_relative([], "JAVASCRIPT_ENGINE")["$=="]("nashorn")) {
  if (File.$basename(__DIR__) === "nashorn" && File.$basename(File.$dirname(__DIR__)) === "dist") {
    stylesheetsPath = File.$join(File.$dirname(__DIR__), "css");
  } else {
    stylesheetsPath = File.$join(__DIR__, "css");
  }
} else {
  stylesheetsPath = "css";
}
return ((($a = self.primary_stylesheet_data) !== false && $a !== nil && $a != null) ? $a : self.primary_stylesheet_data = Opal.const_get_relative([], "IO").$read(File.$join(stylesheetsPath, "asciidoctor.css")).$chomp());
  
      }, TMP_Stylesheets_primary_stylesheet_data_3.$$arity = 0);
      
      Opal.def(self, '$embed_primary_stylesheet', TMP_Stylesheets_embed_primary_stylesheet_4 = function $$embed_primary_stylesheet() {
        var self = this;

        return "" + "<style>\n" + (self.$primary_stylesheet_data()) + "\n" + "</style>"
      }, TMP_Stylesheets_embed_primary_stylesheet_4.$$arity = 0);
      
      Opal.def(self, '$write_primary_stylesheet', TMP_Stylesheets_write_primary_stylesheet_5 = function $$write_primary_stylesheet(target_dir) {
        var self = this;

        
        
        if (target_dir == null) {
          target_dir = ".";
        };
        return $$$('::', 'IO').$write($$$('::', 'File').$join(target_dir, self.$primary_stylesheet_name()), self.$primary_stylesheet_data());
      }, TMP_Stylesheets_write_primary_stylesheet_5.$$arity = -1);
      
      Opal.def(self, '$coderay_stylesheet_name', TMP_Stylesheets_coderay_stylesheet_name_6 = function $$coderay_stylesheet_name() {
        var self = this;

        return "coderay-asciidoctor.css"
      }, TMP_Stylesheets_coderay_stylesheet_name_6.$$arity = 0);
      
      Opal.def(self, '$coderay_stylesheet_data', TMP_Stylesheets_coderay_stylesheet_data_7 = function $$coderay_stylesheet_data() {
        var $a, self = this;

        return (self.coderay_stylesheet_data = ($truthy($a = self.coderay_stylesheet_data) ? $a : $$$('::', 'IO').$read($$$('::', 'File').$join($$($nesting, 'STYLESHEETS_DATA_PATH'), "coderay-asciidoctor.css")).$rstrip()))
      }, TMP_Stylesheets_coderay_stylesheet_data_7.$$arity = 0);
      
      Opal.def(self, '$embed_coderay_stylesheet', TMP_Stylesheets_embed_coderay_stylesheet_8 = function $$embed_coderay_stylesheet() {
        var self = this;

        return "" + "<style>\n" + (self.$coderay_stylesheet_data()) + "\n" + "</style>"
      }, TMP_Stylesheets_embed_coderay_stylesheet_8.$$arity = 0);
      
      Opal.def(self, '$write_coderay_stylesheet', TMP_Stylesheets_write_coderay_stylesheet_9 = function $$write_coderay_stylesheet(target_dir) {
        var self = this;

        
        
        if (target_dir == null) {
          target_dir = ".";
        };
        return $$$('::', 'IO').$write($$$('::', 'File').$join(target_dir, self.$coderay_stylesheet_name()), self.$coderay_stylesheet_data());
      }, TMP_Stylesheets_write_coderay_stylesheet_9.$$arity = -1);
      
      Opal.def(self, '$pygments_stylesheet_name', TMP_Stylesheets_pygments_stylesheet_name_10 = function $$pygments_stylesheet_name(style) {
        var $a, self = this;

        
        
        if (style == null) {
          style = nil;
        };
        return "" + "pygments-" + (($truthy($a = style) ? $a : $$($nesting, 'DEFAULT_PYGMENTS_STYLE'))) + ".css";
      }, TMP_Stylesheets_pygments_stylesheet_name_10.$$arity = -1);
      
      Opal.def(self, '$pygments_background', TMP_Stylesheets_pygments_background_11 = function $$pygments_background(style) {
        var $a, $b, self = this;

        
        
        if (style == null) {
          style = nil;
        };
        if ($truthy(($truthy($a = self.$load_pygments()) ? $$($nesting, 'PygmentsBgColorRx')['$=~']($$$('::', 'Pygments').$css(".pygments", $hash2(["style"], {"style": ($truthy($b = style) ? $b : $$($nesting, 'DEFAULT_PYGMENTS_STYLE'))}))) : $a))) {
          return (($a = $gvars['~']) === nil ? nil : $a['$[]'](1))
        } else {
          return nil
        };
      }, TMP_Stylesheets_pygments_background_11.$$arity = -1);
      
      Opal.def(self, '$pygments_stylesheet_data', TMP_Stylesheets_pygments_stylesheet_data_12 = function $$pygments_stylesheet_data(style) {
        var $a, $b, self = this, $writer = nil;

        
        
        if (style == null) {
          style = nil;
        };
        if ($truthy(self.$load_pygments())) {
          
          style = ($truthy($a = style) ? $a : $$($nesting, 'DEFAULT_PYGMENTS_STYLE'));
          return ($truthy($a = (self.pygments_stylesheet_data = ($truthy($b = self.pygments_stylesheet_data) ? $b : $hash2([], {})))['$[]'](style)) ? $a : (($writer = [style, ($truthy($b = $$$('::', 'Pygments').$css(".listingblock .pygments", $hash2(["classprefix", "style"], {"classprefix": "tok-", "style": style}))) ? $b : "/* Failed to load Pygments CSS. */").$sub(".listingblock .pygments  {", ".listingblock .pygments, .listingblock .pygments code {")]), $send((self.pygments_stylesheet_data = ($truthy($b = self.pygments_stylesheet_data) ? $b : $hash2([], {}))), '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        } else {
          return "/* Pygments CSS disabled. Pygments is not available. */"
        };
      }, TMP_Stylesheets_pygments_stylesheet_data_12.$$arity = -1);
      
      Opal.def(self, '$embed_pygments_stylesheet', TMP_Stylesheets_embed_pygments_stylesheet_13 = function $$embed_pygments_stylesheet(style) {
        var self = this;

        
        
        if (style == null) {
          style = nil;
        };
        return "" + "<style>\n" + (self.$pygments_stylesheet_data(style)) + "\n" + "</style>";
      }, TMP_Stylesheets_embed_pygments_stylesheet_13.$$arity = -1);
      
      Opal.def(self, '$write_pygments_stylesheet', TMP_Stylesheets_write_pygments_stylesheet_14 = function $$write_pygments_stylesheet(target_dir, style) {
        var self = this;

        
        
        if (target_dir == null) {
          target_dir = ".";
        };
        
        if (style == null) {
          style = nil;
        };
        return $$$('::', 'IO').$write($$$('::', 'File').$join(target_dir, self.$pygments_stylesheet_name(style)), self.$pygments_stylesheet_data(style));
      }, TMP_Stylesheets_write_pygments_stylesheet_14.$$arity = -1);
      return (Opal.def(self, '$load_pygments', TMP_Stylesheets_load_pygments_15 = function $$load_pygments() {
        var $a, self = this;

        if ($truthy((($a = $$$('::', 'Pygments', 'skip_raise')) ? 'constant' : nil))) {
          return true
        } else {
          return $$($nesting, 'Helpers').$require_library("pygments", "pygments.rb", "ignore")['$nil?']()['$!']()
        }
      }, TMP_Stylesheets_load_pygments_15.$$arity = 0), nil) && 'load_pygments';
    })($nesting[0], null, $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/table"] = function(Opal) {
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  function $rb_divide(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs / rhs : lhs['$/'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2, $gvars = Opal.gvars;

  Opal.add_stubs(['$attr_accessor', '$attr_reader', '$new', '$key?', '$[]', '$>', '$to_i', '$<', '$==', '$[]=', '$-', '$attributes', '$round', '$*', '$/', '$to_f', '$empty?', '$body', '$each', '$<<', '$size', '$+', '$assign_column_widths', '$warn', '$logger', '$update_attributes', '$assign_width', '$shift', '$style=', '$head=', '$pop', '$foot=', '$parent', '$sourcemap', '$dup', '$header_row?', '$table', '$delete', '$start_with?', '$rstrip', '$slice', '$length', '$advance', '$lstrip', '$strip', '$split', '$include?', '$readlines', '$unshift', '$nil?', '$=~', '$catalog_inline_anchor', '$apply_subs', '$convert', '$map', '$text', '$!', '$file', '$lineno', '$to_s', '$include', '$to_set', '$mark', '$nested?', '$document', '$error', '$message_with_context', '$cursor_at_prev_line', '$nil_or_empty?', '$escape', '$columns', '$match', '$chop', '$end_with?', '$gsub', '$push_cellspec', '$cell_open?', '$close_cell', '$take_cellspec', '$squeeze', '$upto', '$times', '$cursor_before_mark', '$rowspan', '$activate_rowspan', '$colspan', '$end_of_row?', '$!=', '$close_row', '$rows', '$effective_column_visits']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    
    (function($base, $super, $parent_nesting) {
      function $Table(){};
      var self = $Table = $klass($base, $super, 'Table', $Table);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Table_initialize_3, TMP_Table_header_row$q_4, TMP_Table_create_columns_5, TMP_Table_assign_column_widths_7, TMP_Table_partition_header_footer_11;

      def.attributes = def.document = def.has_header_option = def.rows = def.columns = nil;
      
      Opal.const_set($nesting[0], 'DEFAULT_PRECISION_FACTOR', 10000);
      (function($base, $super, $parent_nesting) {
        function $Rows(){};
        var self = $Rows = $klass($base, $super, 'Rows', $Rows);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Rows_initialize_1, TMP_Rows_by_section_2;

        def.head = def.body = def.foot = nil;
        
        self.$attr_accessor("head", "foot", "body");
        
        Opal.def(self, '$initialize', TMP_Rows_initialize_1 = function $$initialize(head, foot, body) {
          var self = this;

          
          
          if (head == null) {
            head = [];
          };
          
          if (foot == null) {
            foot = [];
          };
          
          if (body == null) {
            body = [];
          };
          self.head = head;
          self.foot = foot;
          return (self.body = body);
        }, TMP_Rows_initialize_1.$$arity = -1);
        Opal.alias(self, "[]", "send");
        return (Opal.def(self, '$by_section', TMP_Rows_by_section_2 = function $$by_section() {
          var self = this;

          return [["head", self.head], ["body", self.body], ["foot", self.foot]]
        }, TMP_Rows_by_section_2.$$arity = 0), nil) && 'by_section';
      })($nesting[0], null, $nesting);
      self.$attr_accessor("columns");
      self.$attr_accessor("rows");
      self.$attr_accessor("has_header_option");
      self.$attr_reader("caption");
      
      Opal.def(self, '$initialize', TMP_Table_initialize_3 = function $$initialize(parent, attributes) {
        var $a, $b, $iter = TMP_Table_initialize_3.$$p, $yield = $iter || nil, self = this, pcwidth = nil, pcwidth_intval = nil, $writer = nil;

        if ($iter) TMP_Table_initialize_3.$$p = null;
        
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Table_initialize_3, false), [parent, "table"], null);
        self.rows = $$($nesting, 'Rows').$new();
        self.columns = [];
        self.has_header_option = attributes['$key?']("header-option");
        if ($truthy((pcwidth = attributes['$[]']("width")))) {
          if ($truthy(($truthy($a = $rb_gt((pcwidth_intval = pcwidth.$to_i()), 100)) ? $a : $rb_lt(pcwidth_intval, 1)))) {
            if ($truthy((($a = pcwidth_intval['$=='](0)) ? ($truthy($b = pcwidth['$==']("0")) ? $b : pcwidth['$==']("0%")) : pcwidth_intval['$=='](0)))) {
            } else {
              pcwidth_intval = 100
            }}
        } else {
          pcwidth_intval = 100
        };
        
        $writer = ["tablepcwidth", pcwidth_intval];
        $send(self.attributes, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy(self.document.$attributes()['$key?']("pagewidth"))) {
          ($truthy($a = self.attributes['$[]']("tableabswidth")) ? $a : (($writer = ["tableabswidth", $rb_times($rb_divide(self.attributes['$[]']("tablepcwidth").$to_f(), 100), self.document.$attributes()['$[]']("pagewidth")).$round()]), $send(self.attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))};
        if ($truthy(attributes['$key?']("rotate-option"))) {
          
          $writer = ["orientation", "landscape"];
          $send(attributes, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        } else {
          return nil
        };
      }, TMP_Table_initialize_3.$$arity = 2);
      
      Opal.def(self, '$header_row?', TMP_Table_header_row$q_4 = function() {
        var $a, self = this;

        return ($truthy($a = self.has_header_option) ? self.rows.$body()['$empty?']() : $a)
      }, TMP_Table_header_row$q_4.$$arity = 0);
      
      Opal.def(self, '$create_columns', TMP_Table_create_columns_5 = function $$create_columns(colspecs) {
        var TMP_6, $a, self = this, cols = nil, autowidth_cols = nil, width_base = nil, num_cols = nil, $writer = nil;

        
        cols = [];
        autowidth_cols = nil;
        width_base = 0;
        $send(colspecs, 'each', [], (TMP_6 = function(colspec){var self = TMP_6.$$s || this, $a, colwidth = nil;

        
          
          if (colspec == null) {
            colspec = nil;
          };
          colwidth = colspec['$[]']("width");
          cols['$<<']($$($nesting, 'Column').$new(self, cols.$size(), colspec));
          if ($truthy($rb_lt(colwidth, 0))) {
            return (autowidth_cols = ($truthy($a = autowidth_cols) ? $a : []))['$<<'](cols['$[]'](-1))
          } else {
            return (width_base = $rb_plus(width_base, colwidth))
          };}, TMP_6.$$s = self, TMP_6.$$arity = 1, TMP_6));
        if ($truthy($rb_gt((num_cols = (self.columns = cols).$size()), 0))) {
          
          
          $writer = ["colcount", num_cols];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          if ($truthy(($truthy($a = $rb_gt(width_base, 0)) ? $a : autowidth_cols))) {
          } else {
            width_base = nil
          };
          self.$assign_column_widths(width_base, autowidth_cols);};
        return nil;
      }, TMP_Table_create_columns_5.$$arity = 1);
      
      Opal.def(self, '$assign_column_widths', TMP_Table_assign_column_widths_7 = function $$assign_column_widths(width_base, autowidth_cols) {
        var TMP_8, TMP_9, TMP_10, self = this, pf = nil, total_width = nil, col_pcwidth = nil, autowidth = nil, autowidth_attrs = nil;

        
        
        if (width_base == null) {
          width_base = nil;
        };
        
        if (autowidth_cols == null) {
          autowidth_cols = nil;
        };
        pf = $$($nesting, 'DEFAULT_PRECISION_FACTOR');
        total_width = (col_pcwidth = 0);
        if ($truthy(width_base)) {
          
          if ($truthy(autowidth_cols)) {
            
            if ($truthy($rb_gt(width_base, 100))) {
              
              autowidth = 0;
              self.$logger().$warn("" + "total column width must not exceed 100% when using autowidth columns; got " + (width_base) + "%");
            } else {
              
              autowidth = $rb_divide($rb_times($rb_divide($rb_minus(100, width_base), autowidth_cols.$size()), pf).$to_i(), pf);
              if (autowidth.$to_i()['$=='](autowidth)) {
                autowidth = autowidth.$to_i()};
              width_base = 100;
            };
            autowidth_attrs = $hash2(["width", "autowidth-option"], {"width": autowidth, "autowidth-option": ""});
            $send(autowidth_cols, 'each', [], (TMP_8 = function(col){var self = TMP_8.$$s || this;

            
              
              if (col == null) {
                col = nil;
              };
              return col.$update_attributes(autowidth_attrs);}, TMP_8.$$s = self, TMP_8.$$arity = 1, TMP_8));};
          $send(self.columns, 'each', [], (TMP_9 = function(col){var self = TMP_9.$$s || this;

          
            
            if (col == null) {
              col = nil;
            };
            return (total_width = $rb_plus(total_width, (col_pcwidth = col.$assign_width(nil, width_base, pf))));}, TMP_9.$$s = self, TMP_9.$$arity = 1, TMP_9));
        } else {
          
          col_pcwidth = $rb_divide($rb_divide($rb_times(100, pf), self.columns.$size()).$to_i(), pf);
          if (col_pcwidth.$to_i()['$=='](col_pcwidth)) {
            col_pcwidth = col_pcwidth.$to_i()};
          $send(self.columns, 'each', [], (TMP_10 = function(col){var self = TMP_10.$$s || this;

          
            
            if (col == null) {
              col = nil;
            };
            return (total_width = $rb_plus(total_width, col.$assign_width(col_pcwidth)));}, TMP_10.$$s = self, TMP_10.$$arity = 1, TMP_10));
        };
        if (total_width['$=='](100)) {
        } else {
          self.columns['$[]'](-1).$assign_width($rb_divide($rb_times($rb_plus($rb_minus(100, total_width), col_pcwidth), pf).$round(), pf))
        };
        return nil;
      }, TMP_Table_assign_column_widths_7.$$arity = -1);
      return (Opal.def(self, '$partition_header_footer', TMP_Table_partition_header_footer_11 = function $$partition_header_footer(attrs) {
        var $a, TMP_12, self = this, $writer = nil, num_body_rows = nil, head = nil;

        
        
        $writer = ["rowcount", self.rows.$body().$size()];
        $send(self.attributes, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        num_body_rows = self.rows.$body().$size();
        if ($truthy(($truthy($a = $rb_gt(num_body_rows, 0)) ? self.has_header_option : $a))) {
          
          head = self.rows.$body().$shift();
          num_body_rows = $rb_minus(num_body_rows, 1);
          $send(head, 'each', [], (TMP_12 = function(c){var self = TMP_12.$$s || this;

          
            
            if (c == null) {
              c = nil;
            };
            $writer = [nil];
            $send(c, 'style=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];}, TMP_12.$$s = self, TMP_12.$$arity = 1, TMP_12));
          
          $writer = [[head]];
          $send(self.rows, 'head=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;};
        if ($truthy(($truthy($a = $rb_gt(num_body_rows, 0)) ? attrs['$key?']("footer-option") : $a))) {
          
          $writer = [[self.rows.$body().$pop()]];
          $send(self.rows, 'foot=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        return nil;
      }, TMP_Table_partition_header_footer_11.$$arity = 1), nil) && 'partition_header_footer';
    })($nesting[0], $$($nesting, 'AbstractBlock'), $nesting);
    (function($base, $super, $parent_nesting) {
      function $Column(){};
      var self = $Column = $klass($base, $super, 'Column', $Column);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Column_initialize_13, TMP_Column_assign_width_14;

      def.attributes = nil;
      
      self.$attr_accessor("style");
      
      Opal.def(self, '$initialize', TMP_Column_initialize_13 = function $$initialize(table, index, attributes) {
        var $a, $iter = TMP_Column_initialize_13.$$p, $yield = $iter || nil, self = this, $writer = nil;

        if ($iter) TMP_Column_initialize_13.$$p = null;
        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Column_initialize_13, false), [table, "column"], null);
        self.style = attributes['$[]']("style");
        
        $writer = ["colnumber", $rb_plus(index, 1)];
        $send(attributes, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        ($truthy($a = attributes['$[]']("width")) ? $a : (($writer = ["width", 1]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($a = attributes['$[]']("halign")) ? $a : (($writer = ["halign", "left"]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        ($truthy($a = attributes['$[]']("valign")) ? $a : (($writer = ["valign", "top"]), $send(attributes, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        return self.$update_attributes(attributes);
      }, TMP_Column_initialize_13.$$arity = -3);
      Opal.alias(self, "table", "parent");
      return (Opal.def(self, '$assign_width', TMP_Column_assign_width_14 = function $$assign_width(col_pcwidth, width_base, pf) {
        var self = this, $writer = nil;

        
        
        if (width_base == null) {
          width_base = nil;
        };
        
        if (pf == null) {
          pf = 10000;
        };
        if ($truthy(width_base)) {
          
          col_pcwidth = $rb_divide($rb_times($rb_times($rb_divide(self.attributes['$[]']("width").$to_f(), width_base), 100), pf).$to_i(), pf);
          if (col_pcwidth.$to_i()['$=='](col_pcwidth)) {
            col_pcwidth = col_pcwidth.$to_i()};};
        
        $writer = ["colpcwidth", col_pcwidth];
        $send(self.attributes, '[]=', Opal.to_a($writer));
        $writer[$rb_minus($writer["length"], 1)];;
        if ($truthy(self.$parent().$attributes()['$key?']("tableabswidth"))) {
          
          $writer = ["colabswidth", $rb_times($rb_divide(col_pcwidth, 100), self.$parent().$attributes()['$[]']("tableabswidth")).$round()];
          $send(self.attributes, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        return col_pcwidth;
      }, TMP_Column_assign_width_14.$$arity = -2), nil) && 'assign_width';
    })($$($nesting, 'Table'), $$($nesting, 'AbstractNode'), $nesting);
    (function($base, $super, $parent_nesting) {
      function $Cell(){};
      var self = $Cell = $klass($base, $super, 'Cell', $Cell);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Cell_initialize_15, TMP_Cell_text_16, TMP_Cell_text$eq_17, TMP_Cell_content_18, TMP_Cell_file_20, TMP_Cell_lineno_21, TMP_Cell_to_s_22;

      def.document = def.text = def.subs = def.style = def.inner_document = def.source_location = def.colspan = def.rowspan = def.attributes = nil;
      
      self.$attr_reader("source_location");
      self.$attr_accessor("style");
      self.$attr_accessor("subs");
      self.$attr_accessor("colspan");
      self.$attr_accessor("rowspan");
      Opal.alias(self, "column", "parent");
      self.$attr_reader("inner_document");
      
      Opal.def(self, '$initialize', TMP_Cell_initialize_15 = function $$initialize(column, cell_text, attributes, opts) {
        var $a, $b, $iter = TMP_Cell_initialize_15.$$p, $yield = $iter || nil, self = this, in_header_row = nil, cell_style = nil, asciidoc = nil, inner_document_cursor = nil, lines_advanced = nil, literal = nil, normal_psv = nil, parent_doctitle = nil, inner_document_lines = nil, unprocessed_line1 = nil, preprocessed_lines = nil, $writer = nil;

        if ($iter) TMP_Cell_initialize_15.$$p = null;
        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_Cell_initialize_15, false), [column, "cell"], null);
        if ($truthy(self.document.$sourcemap())) {
          self.source_location = opts['$[]']("cursor").$dup()};
        if ($truthy(column)) {
          
          if ($truthy((in_header_row = column.$table()['$header_row?']()))) {
          } else {
            cell_style = column.$attributes()['$[]']("style")
          };
          self.$update_attributes(column.$attributes());};
        if ($truthy(attributes)) {
          
          if ($truthy(attributes['$empty?']())) {
            self.colspan = (self.rowspan = nil)
          } else {
            
            $a = [attributes.$delete("colspan"), attributes.$delete("rowspan")], (self.colspan = $a[0]), (self.rowspan = $a[1]), $a;
            if ($truthy(in_header_row)) {
            } else {
              cell_style = ($truthy($a = attributes['$[]']("style")) ? $a : cell_style)
            };
            self.$update_attributes(attributes);
          };
          if (cell_style['$==']("asciidoc")) {
            
            asciidoc = true;
            inner_document_cursor = opts['$[]']("cursor");
            if ($truthy((cell_text = cell_text.$rstrip())['$start_with?']($$($nesting, 'LF')))) {
              
              lines_advanced = 1;
              while ($truthy((cell_text = cell_text.$slice(1, cell_text.$length()))['$start_with?']($$($nesting, 'LF')))) {
                lines_advanced = $rb_plus(lines_advanced, 1)
              };
              inner_document_cursor.$advance(lines_advanced);
            } else {
              cell_text = cell_text.$lstrip()
            };
          } else if ($truthy(($truthy($a = (literal = cell_style['$==']("literal"))) ? $a : cell_style['$==']("verse")))) {
            
            cell_text = cell_text.$rstrip();
            while ($truthy(cell_text['$start_with?']($$($nesting, 'LF')))) {
              cell_text = cell_text.$slice(1, cell_text.$length())
            };
          } else {
            
            normal_psv = true;
            cell_text = (function() {if ($truthy(cell_text)) {
              return cell_text.$strip()
            } else {
              return ""
            }; return nil; })();
          };
        } else {
          
          self.colspan = (self.rowspan = nil);
          if (cell_style['$==']("asciidoc")) {
            
            asciidoc = true;
            inner_document_cursor = opts['$[]']("cursor");};
        };
        if ($truthy(asciidoc)) {
          
          parent_doctitle = self.document.$attributes().$delete("doctitle");
          inner_document_lines = cell_text.$split($$($nesting, 'LF'), -1);
          if ($truthy(inner_document_lines['$empty?']())) {
          } else if ($truthy((unprocessed_line1 = inner_document_lines['$[]'](0))['$include?']("::"))) {
            
            preprocessed_lines = $$($nesting, 'PreprocessorReader').$new(self.document, [unprocessed_line1]).$readlines();
            if ($truthy((($a = unprocessed_line1['$=='](preprocessed_lines['$[]'](0))) ? $rb_lt(preprocessed_lines.$size(), 2) : unprocessed_line1['$=='](preprocessed_lines['$[]'](0))))) {
            } else {
              
              inner_document_lines.$shift();
              if ($truthy(preprocessed_lines['$empty?']())) {
              } else {
                $send(inner_document_lines, 'unshift', Opal.to_a(preprocessed_lines))
              };
            };};
          self.inner_document = $$($nesting, 'Document').$new(inner_document_lines, $hash2(["header_footer", "parent", "cursor"], {"header_footer": false, "parent": self.document, "cursor": inner_document_cursor}));
          if ($truthy(parent_doctitle['$nil?']())) {
          } else {
            
            $writer = ["doctitle", parent_doctitle];
            $send(self.document.$attributes(), '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          self.subs = nil;
        } else if ($truthy(literal)) {
          self.subs = $$($nesting, 'BASIC_SUBS')
        } else {
          
          if ($truthy(($truthy($a = ($truthy($b = normal_psv) ? cell_text['$start_with?']("[[") : $b)) ? $$($nesting, 'LeadingInlineAnchorRx')['$=~'](cell_text) : $a))) {
            $$($nesting, 'Parser').$catalog_inline_anchor((($a = $gvars['~']) === nil ? nil : $a['$[]'](1)), (($a = $gvars['~']) === nil ? nil : $a['$[]'](2)), self, opts['$[]']("cursor"), self.document)};
          self.subs = $$($nesting, 'NORMAL_SUBS');
        };
        self.text = cell_text;
        return (self.style = cell_style);
      }, TMP_Cell_initialize_15.$$arity = -3);
      
      Opal.def(self, '$text', TMP_Cell_text_16 = function $$text() {
        var self = this;

        return self.$apply_subs(self.text, self.subs)
      }, TMP_Cell_text_16.$$arity = 0);
      
      Opal.def(self, '$text=', TMP_Cell_text$eq_17 = function(val) {
        var self = this;

        return (self.text = val)
      }, TMP_Cell_text$eq_17.$$arity = 1);
      
      Opal.def(self, '$content', TMP_Cell_content_18 = function $$content() {
        var TMP_19, self = this;

        if (self.style['$==']("asciidoc")) {
          return self.inner_document.$convert()
        } else {
          return $send(self.$text().$split($$($nesting, 'BlankLineRx')), 'map', [], (TMP_19 = function(p){var self = TMP_19.$$s || this, $a;
            if (self.style == null) self.style = nil;

          
            
            if (p == null) {
              p = nil;
            };
            if ($truthy(($truthy($a = self.style['$!']()) ? $a : self.style['$==']("header")))) {
              return p
            } else {
              return $$($nesting, 'Inline').$new(self.$parent(), "quoted", p, $hash2(["type"], {"type": self.style})).$convert()
            };}, TMP_19.$$s = self, TMP_19.$$arity = 1, TMP_19))
        }
      }, TMP_Cell_content_18.$$arity = 0);
      
      Opal.def(self, '$file', TMP_Cell_file_20 = function $$file() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$file() : $a)
      }, TMP_Cell_file_20.$$arity = 0);
      
      Opal.def(self, '$lineno', TMP_Cell_lineno_21 = function $$lineno() {
        var $a, self = this;

        return ($truthy($a = self.source_location) ? self.source_location.$lineno() : $a)
      }, TMP_Cell_lineno_21.$$arity = 0);
      return (Opal.def(self, '$to_s', TMP_Cell_to_s_22 = function $$to_s() {
        var $a, $iter = TMP_Cell_to_s_22.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

        if ($iter) TMP_Cell_to_s_22.$$p = null;
        // Prepare super implicit arguments
        for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
          $zuper[$zuper_i] = arguments[$zuper_i];
        }
        return "" + ($send(self, Opal.find_super_dispatcher(self, 'to_s', TMP_Cell_to_s_22, false), $zuper, $iter).$to_s()) + " - [text: " + (self.text) + ", colspan: " + (($truthy($a = self.colspan) ? $a : 1)) + ", rowspan: " + (($truthy($a = self.rowspan) ? $a : 1)) + ", attributes: " + (self.attributes) + "]"
      }, TMP_Cell_to_s_22.$$arity = 0), nil) && 'to_s';
    })($$($nesting, 'Table'), $$($nesting, 'AbstractNode'), $nesting);
    (function($base, $super, $parent_nesting) {
      function $ParserContext(){};
      var self = $ParserContext = $klass($base, $super, 'ParserContext', $ParserContext);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_ParserContext_initialize_23, TMP_ParserContext_starts_with_delimiter$q_24, TMP_ParserContext_match_delimiter_25, TMP_ParserContext_skip_past_delimiter_26, TMP_ParserContext_skip_past_escaped_delimiter_27, TMP_ParserContext_buffer_has_unclosed_quotes$q_28, TMP_ParserContext_take_cellspec_29, TMP_ParserContext_push_cellspec_30, TMP_ParserContext_keep_cell_open_31, TMP_ParserContext_mark_cell_closed_32, TMP_ParserContext_cell_open$q_33, TMP_ParserContext_cell_closed$q_34, TMP_ParserContext_close_open_cell_35, TMP_ParserContext_close_cell_36, TMP_ParserContext_close_row_39, TMP_ParserContext_activate_rowspan_40, TMP_ParserContext_end_of_row$q_42, TMP_ParserContext_effective_column_visits_43, TMP_ParserContext_advance_44;

      def.delimiter = def.delimiter_re = def.buffer = def.cellspecs = def.cell_open = def.format = def.start_cursor_data = def.reader = def.table = def.current_row = def.colcount = def.column_visits = def.active_rowspans = def.linenum = nil;
      
      self.$include($$($nesting, 'Logging'));
      Opal.const_set($nesting[0], 'FORMATS', ["psv", "csv", "dsv", "tsv"].$to_set());
      Opal.const_set($nesting[0], 'DELIMITERS', $hash2(["psv", "csv", "dsv", "tsv", "!sv"], {"psv": ["|", /\|/], "csv": [",", /,/], "dsv": [":", /:/], "tsv": ["\t", /\t/], "!sv": ["!", /!/]}));
      self.$attr_accessor("table");
      self.$attr_accessor("format");
      self.$attr_reader("colcount");
      self.$attr_accessor("buffer");
      self.$attr_reader("delimiter");
      self.$attr_reader("delimiter_re");
      
      Opal.def(self, '$initialize', TMP_ParserContext_initialize_23 = function $$initialize(reader, table, attributes) {
        var $a, $b, self = this, xsv = nil, sep = nil;

        
        
        if (attributes == null) {
          attributes = $hash2([], {});
        };
        self.start_cursor_data = (self.reader = reader).$mark();
        self.table = table;
        if ($truthy(attributes['$key?']("format"))) {
          if ($truthy($$($nesting, 'FORMATS')['$include?']((xsv = attributes['$[]']("format"))))) {
            if (xsv['$==']("tsv")) {
              self.format = "csv"
            } else if ($truthy((($a = (self.format = xsv)['$==']("psv")) ? table.$document()['$nested?']() : (self.format = xsv)['$==']("psv")))) {
              xsv = "!sv"}
          } else {
            
            self.$logger().$error(self.$message_with_context("" + "illegal table format: " + (xsv), $hash2(["source_location"], {"source_location": reader.$cursor_at_prev_line()})));
            $a = ["psv", (function() {if ($truthy(table.$document()['$nested?']())) {
              return "!sv"
            } else {
              return "psv"
            }; return nil; })()], (self.format = $a[0]), (xsv = $a[1]), $a;
          }
        } else {
          $a = ["psv", (function() {if ($truthy(table.$document()['$nested?']())) {
            return "!sv"
          } else {
            return "psv"
          }; return nil; })()], (self.format = $a[0]), (xsv = $a[1]), $a
        };
        if ($truthy(attributes['$key?']("separator"))) {
          if ($truthy((sep = attributes['$[]']("separator"))['$nil_or_empty?']())) {
            $b = $$($nesting, 'DELIMITERS')['$[]'](xsv), $a = Opal.to_ary($b), (self.delimiter = ($a[0] == null ? nil : $a[0])), (self.delimiter_re = ($a[1] == null ? nil : $a[1])), $b
          } else if (sep['$==']("\\t")) {
            $b = $$($nesting, 'DELIMITERS')['$[]']("tsv"), $a = Opal.to_ary($b), (self.delimiter = ($a[0] == null ? nil : $a[0])), (self.delimiter_re = ($a[1] == null ? nil : $a[1])), $b
          } else {
            $a = [sep, new RegExp($$$('::', 'Regexp').$escape(sep))], (self.delimiter = $a[0]), (self.delimiter_re = $a[1]), $a
          }
        } else {
          $b = $$($nesting, 'DELIMITERS')['$[]'](xsv), $a = Opal.to_ary($b), (self.delimiter = ($a[0] == null ? nil : $a[0])), (self.delimiter_re = ($a[1] == null ? nil : $a[1])), $b
        };
        self.colcount = (function() {if ($truthy(table.$columns()['$empty?']())) {
          return -1
        } else {
          return table.$columns().$size()
        }; return nil; })();
        self.buffer = "";
        self.cellspecs = [];
        self.cell_open = false;
        self.active_rowspans = [0];
        self.column_visits = 0;
        self.current_row = [];
        return (self.linenum = -1);
      }, TMP_ParserContext_initialize_23.$$arity = -3);
      
      Opal.def(self, '$starts_with_delimiter?', TMP_ParserContext_starts_with_delimiter$q_24 = function(line) {
        var self = this;

        return line['$start_with?'](self.delimiter)
      }, TMP_ParserContext_starts_with_delimiter$q_24.$$arity = 1);
      
      Opal.def(self, '$match_delimiter', TMP_ParserContext_match_delimiter_25 = function $$match_delimiter(line) {
        var self = this;

        return self.delimiter_re.$match(line)
      }, TMP_ParserContext_match_delimiter_25.$$arity = 1);
      
      Opal.def(self, '$skip_past_delimiter', TMP_ParserContext_skip_past_delimiter_26 = function $$skip_past_delimiter(pre) {
        var self = this;

        
        self.buffer = "" + (self.buffer) + (pre) + (self.delimiter);
        return nil;
      }, TMP_ParserContext_skip_past_delimiter_26.$$arity = 1);
      
      Opal.def(self, '$skip_past_escaped_delimiter', TMP_ParserContext_skip_past_escaped_delimiter_27 = function $$skip_past_escaped_delimiter(pre) {
        var self = this;

        
        self.buffer = "" + (self.buffer) + (pre.$chop()) + (self.delimiter);
        return nil;
      }, TMP_ParserContext_skip_past_escaped_delimiter_27.$$arity = 1);
      
      Opal.def(self, '$buffer_has_unclosed_quotes?', TMP_ParserContext_buffer_has_unclosed_quotes$q_28 = function(append) {
        var $a, $b, self = this, record = nil, trailing_quote = nil;

        
        
        if (append == null) {
          append = nil;
        };
        if ((record = (function() {if ($truthy(append)) {
          return $rb_plus(self.buffer, append).$strip()
        } else {
          return self.buffer.$strip()
        }; return nil; })())['$==']("\"")) {
          return true
        } else if ($truthy(record['$start_with?']("\""))) {
          if ($truthy(($truthy($a = ($truthy($b = (trailing_quote = record['$end_with?']("\""))) ? record['$end_with?']("\"\"") : $b)) ? $a : record['$start_with?']("\"\"")))) {
            return ($truthy($a = (record = record.$gsub("\"\"", ""))['$start_with?']("\"")) ? record['$end_with?']("\"")['$!']() : $a)
          } else {
            return trailing_quote['$!']()
          }
        } else {
          return false
        };
      }, TMP_ParserContext_buffer_has_unclosed_quotes$q_28.$$arity = -1);
      
      Opal.def(self, '$take_cellspec', TMP_ParserContext_take_cellspec_29 = function $$take_cellspec() {
        var self = this;

        return self.cellspecs.$shift()
      }, TMP_ParserContext_take_cellspec_29.$$arity = 0);
      
      Opal.def(self, '$push_cellspec', TMP_ParserContext_push_cellspec_30 = function $$push_cellspec(cellspec) {
        var $a, self = this;

        
        
        if (cellspec == null) {
          cellspec = $hash2([], {});
        };
        self.cellspecs['$<<'](($truthy($a = cellspec) ? $a : $hash2([], {})));
        return nil;
      }, TMP_ParserContext_push_cellspec_30.$$arity = -1);
      
      Opal.def(self, '$keep_cell_open', TMP_ParserContext_keep_cell_open_31 = function $$keep_cell_open() {
        var self = this;

        
        self.cell_open = true;
        return nil;
      }, TMP_ParserContext_keep_cell_open_31.$$arity = 0);
      
      Opal.def(self, '$mark_cell_closed', TMP_ParserContext_mark_cell_closed_32 = function $$mark_cell_closed() {
        var self = this;

        
        self.cell_open = false;
        return nil;
      }, TMP_ParserContext_mark_cell_closed_32.$$arity = 0);
      
      Opal.def(self, '$cell_open?', TMP_ParserContext_cell_open$q_33 = function() {
        var self = this;

        return self.cell_open
      }, TMP_ParserContext_cell_open$q_33.$$arity = 0);
      
      Opal.def(self, '$cell_closed?', TMP_ParserContext_cell_closed$q_34 = function() {
        var self = this;

        return self.cell_open['$!']()
      }, TMP_ParserContext_cell_closed$q_34.$$arity = 0);
      
      Opal.def(self, '$close_open_cell', TMP_ParserContext_close_open_cell_35 = function $$close_open_cell(next_cellspec) {
        var self = this;

        
        
        if (next_cellspec == null) {
          next_cellspec = $hash2([], {});
        };
        self.$push_cellspec(next_cellspec);
        if ($truthy(self['$cell_open?']())) {
          self.$close_cell(true)};
        self.$advance();
        return nil;
      }, TMP_ParserContext_close_open_cell_35.$$arity = -1);
      
      Opal.def(self, '$close_cell', TMP_ParserContext_close_cell_36 = function $$close_cell(eol) {try {

        var $a, $b, TMP_37, self = this, cell_text = nil, cellspec = nil, repeat = nil;

        
        
        if (eol == null) {
          eol = false;
        };
        if (self.format['$==']("psv")) {
          
          cell_text = self.buffer;
          self.buffer = "";
          if ($truthy((cellspec = self.$take_cellspec()))) {
            repeat = ($truthy($a = cellspec.$delete("repeatcol")) ? $a : 1)
          } else {
            
            self.$logger().$error(self.$message_with_context("table missing leading separator; recovering automatically", $hash2(["source_location"], {"source_location": $send($$$($$($nesting, 'Reader'), 'Cursor'), 'new', Opal.to_a(self.start_cursor_data))})));
            cellspec = $hash2([], {});
            repeat = 1;
          };
        } else {
          
          cell_text = self.buffer.$strip();
          self.buffer = "";
          cellspec = nil;
          repeat = 1;
          if ($truthy(($truthy($a = (($b = self.format['$==']("csv")) ? cell_text['$empty?']()['$!']() : self.format['$==']("csv"))) ? cell_text['$include?']("\"") : $a))) {
            if ($truthy(($truthy($a = cell_text['$start_with?']("\"")) ? cell_text['$end_with?']("\"") : $a))) {
              if ($truthy((cell_text = cell_text.$slice(1, $rb_minus(cell_text.$length(), 2))))) {
                cell_text = cell_text.$strip().$squeeze("\"")
              } else {
                
                self.$logger().$error(self.$message_with_context("unclosed quote in CSV data; setting cell to empty", $hash2(["source_location"], {"source_location": self.reader.$cursor_at_prev_line()})));
                cell_text = "";
              }
            } else {
              cell_text = cell_text.$squeeze("\"")
            }};
        };
        $send((1), 'upto', [repeat], (TMP_37 = function(i){var self = TMP_37.$$s || this, $c, $d, TMP_38, $e, column = nil, extra_cols = nil, offset = nil, cell = nil;
          if (self.colcount == null) self.colcount = nil;
          if (self.table == null) self.table = nil;
          if (self.current_row == null) self.current_row = nil;
          if (self.reader == null) self.reader = nil;
          if (self.column_visits == null) self.column_visits = nil;
          if (self.linenum == null) self.linenum = nil;

        
          
          if (i == null) {
            i = nil;
          };
          if (self.colcount['$=='](-1)) {
            
            self.table.$columns()['$<<']((column = $$$($$($nesting, 'Table'), 'Column').$new(self.table, $rb_minus($rb_plus(self.table.$columns().$size(), i), 1))));
            if ($truthy(($truthy($c = ($truthy($d = cellspec) ? cellspec['$key?']("colspan") : $d)) ? $rb_gt((extra_cols = $rb_minus(cellspec['$[]']("colspan").$to_i(), 1)), 0) : $c))) {
              
              offset = self.table.$columns().$size();
              $send(extra_cols, 'times', [], (TMP_38 = function(j){var self = TMP_38.$$s || this;
                if (self.table == null) self.table = nil;

              
                
                if (j == null) {
                  j = nil;
                };
                return self.table.$columns()['$<<']($$$($$($nesting, 'Table'), 'Column').$new(self.table, $rb_plus(offset, j)));}, TMP_38.$$s = self, TMP_38.$$arity = 1, TMP_38));};
          } else if ($truthy((column = self.table.$columns()['$[]'](self.current_row.$size())))) {
          } else {
            
            self.$logger().$error(self.$message_with_context("dropping cell because it exceeds specified number of columns", $hash2(["source_location"], {"source_location": self.reader.$cursor_before_mark()})));
            Opal.ret(nil);
          };
          cell = $$$($$($nesting, 'Table'), 'Cell').$new(column, cell_text, cellspec, $hash2(["cursor"], {"cursor": self.reader.$cursor_before_mark()}));
          self.reader.$mark();
          if ($truthy(($truthy($c = cell.$rowspan()['$!']()) ? $c : cell.$rowspan()['$=='](1)))) {
          } else {
            self.$activate_rowspan(cell.$rowspan(), ($truthy($c = cell.$colspan()) ? $c : 1))
          };
          self.column_visits = $rb_plus(self.column_visits, ($truthy($c = cell.$colspan()) ? $c : 1));
          self.current_row['$<<'](cell);
          if ($truthy(($truthy($c = self['$end_of_row?']()) ? ($truthy($d = ($truthy($e = self.colcount['$!='](-1)) ? $e : $rb_gt(self.linenum, 0))) ? $d : ($truthy($e = eol) ? i['$=='](repeat) : $e)) : $c))) {
            return self.$close_row()
          } else {
            return nil
          };}, TMP_37.$$s = self, TMP_37.$$arity = 1, TMP_37));
        self.cell_open = false;
        return nil;
        } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
      }, TMP_ParserContext_close_cell_36.$$arity = -1);
      
      Opal.def(self, '$close_row', TMP_ParserContext_close_row_39 = function $$close_row() {
        var $a, self = this, $writer = nil;

        
        self.table.$rows().$body()['$<<'](self.current_row);
        if (self.colcount['$=='](-1)) {
          self.colcount = self.column_visits};
        self.column_visits = 0;
        self.current_row = [];
        self.active_rowspans.$shift();
        ($truthy($a = self.active_rowspans['$[]'](0)) ? $a : (($writer = [0, 0]), $send(self.active_rowspans, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        return nil;
      }, TMP_ParserContext_close_row_39.$$arity = 0);
      
      Opal.def(self, '$activate_rowspan', TMP_ParserContext_activate_rowspan_40 = function $$activate_rowspan(rowspan, colspan) {
        var TMP_41, self = this;

        
        $send((1).$upto($rb_minus(rowspan, 1)), 'each', [], (TMP_41 = function(i){var self = TMP_41.$$s || this, $a, $writer = nil;
          if (self.active_rowspans == null) self.active_rowspans = nil;

        
          
          if (i == null) {
            i = nil;
          };
          $writer = [i, $rb_plus(($truthy($a = self.active_rowspans['$[]'](i)) ? $a : 0), colspan)];
          $send(self.active_rowspans, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];}, TMP_41.$$s = self, TMP_41.$$arity = 1, TMP_41));
        return nil;
      }, TMP_ParserContext_activate_rowspan_40.$$arity = 2);
      
      Opal.def(self, '$end_of_row?', TMP_ParserContext_end_of_row$q_42 = function() {
        var $a, self = this;

        return ($truthy($a = self.colcount['$=='](-1)) ? $a : self.$effective_column_visits()['$=='](self.colcount))
      }, TMP_ParserContext_end_of_row$q_42.$$arity = 0);
      
      Opal.def(self, '$effective_column_visits', TMP_ParserContext_effective_column_visits_43 = function $$effective_column_visits() {
        var self = this;

        return $rb_plus(self.column_visits, self.active_rowspans['$[]'](0))
      }, TMP_ParserContext_effective_column_visits_43.$$arity = 0);
      return (Opal.def(self, '$advance', TMP_ParserContext_advance_44 = function $$advance() {
        var self = this;

        return (self.linenum = $rb_plus(self.linenum, 1))
      }, TMP_ParserContext_advance_44.$$arity = 0), nil) && 'advance';
    })($$($nesting, 'Table'), null, $nesting);
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter/composite"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $truthy = Opal.truthy, $hash2 = Opal.hash2;

  Opal.add_stubs(['$attr_reader', '$each', '$compact', '$flatten', '$respond_to?', '$composed', '$node_name', '$convert', '$converter_for', '$[]', '$find_converter', '$[]=', '$-', '$handles?', '$raise']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $CompositeConverter(){};
      var self = $CompositeConverter = $klass($base, $super, 'CompositeConverter', $CompositeConverter);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_CompositeConverter_initialize_1, TMP_CompositeConverter_convert_3, TMP_CompositeConverter_converter_for_4, TMP_CompositeConverter_find_converter_5;

      def.converter_map = def.converters = nil;
      
      self.$attr_reader("converters");
      
      Opal.def(self, '$initialize', TMP_CompositeConverter_initialize_1 = function $$initialize(backend, $a) {
        var $post_args, converters, TMP_2, self = this;

        
        
        $post_args = Opal.slice.call(arguments, 1, arguments.length);
        
        converters = $post_args;;
        self.backend = backend;
        $send((self.converters = converters.$flatten().$compact()), 'each', [], (TMP_2 = function(converter){var self = TMP_2.$$s || this;

        
          
          if (converter == null) {
            converter = nil;
          };
          if ($truthy(converter['$respond_to?']("composed"))) {
            return converter.$composed(self)
          } else {
            return nil
          };}, TMP_2.$$s = self, TMP_2.$$arity = 1, TMP_2));
        return (self.converter_map = $hash2([], {}));
      }, TMP_CompositeConverter_initialize_1.$$arity = -2);
      
      Opal.def(self, '$convert', TMP_CompositeConverter_convert_3 = function $$convert(node, transform, opts) {
        var $a, self = this;

        
        
        if (transform == null) {
          transform = nil;
        };
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        transform = ($truthy($a = transform) ? $a : node.$node_name());
        return self.$converter_for(transform).$convert(node, transform, opts);
      }, TMP_CompositeConverter_convert_3.$$arity = -2);
      Opal.alias(self, "convert_with_options", "convert");
      
      Opal.def(self, '$converter_for', TMP_CompositeConverter_converter_for_4 = function $$converter_for(transform) {
        var $a, self = this, $writer = nil;

        return ($truthy($a = self.converter_map['$[]'](transform)) ? $a : (($writer = [transform, self.$find_converter(transform)]), $send(self.converter_map, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
      }, TMP_CompositeConverter_converter_for_4.$$arity = 1);
      return (Opal.def(self, '$find_converter', TMP_CompositeConverter_find_converter_5 = function $$find_converter(transform) {try {

        var TMP_6, self = this;

        
        $send(self.converters, 'each', [], (TMP_6 = function(candidate){var self = TMP_6.$$s || this;

        
          
          if (candidate == null) {
            candidate = nil;
          };
          if ($truthy(candidate['$handles?'](transform))) {
            Opal.ret(candidate)
          } else {
            return nil
          };}, TMP_6.$$s = self, TMP_6.$$arity = 1, TMP_6));
        return self.$raise("" + "Could not find a converter to handle transform: " + (transform));
        } catch ($returner) { if ($returner === Opal.returner) { return $returner.$v } throw $returner; }
      }, TMP_CompositeConverter_find_converter_5.$$arity = 1), nil) && 'find_converter';
    })($$($nesting, 'Converter'), $$$($$($nesting, 'Converter'), 'Base'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/converter/html5"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_le(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs <= rhs : lhs['$<='](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  function $rb_times(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs * rhs : lhs['$*'](rhs);
  }
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $send = Opal.send, $hash2 = Opal.hash2, $truthy = Opal.truthy, $gvars = Opal.gvars;

  Opal.add_stubs(['$default=', '$-', '$==', '$[]', '$instance', '$empty?', '$attr', '$attr?', '$<<', '$include?', '$gsub', '$extname', '$slice', '$length', '$doctitle', '$normalize_web_path', '$embed_primary_stylesheet', '$read_asset', '$normalize_system_path', '$===', '$coderay_stylesheet_name', '$embed_coderay_stylesheet', '$pygments_stylesheet_name', '$embed_pygments_stylesheet', '$docinfo', '$id', '$sections?', '$doctype', '$join', '$noheader', '$outline', '$generate_manname_section', '$has_header?', '$notitle', '$title', '$header', '$each', '$authors', '$>', '$name', '$email', '$sub_macros', '$+', '$downcase', '$concat', '$content', '$footnotes?', '$!', '$footnotes', '$index', '$text', '$nofooter', '$inspect', '$!=', '$to_i', '$attributes', '$document', '$sections', '$level', '$caption', '$captioned_title', '$numbered', '$<=', '$<', '$sectname', '$sectnum', '$role', '$title?', '$icon_uri', '$compact', '$media_uri', '$option?', '$append_boolean_attribute', '$style', '$items', '$blocks?', '$text?', '$chomp', '$safe', '$read_svg_contents', '$alt', '$image_uri', '$encode_quotes', '$append_link_constraint_attrs', '$pygments_background', '$to_sym', '$*', '$count', '$start_with?', '$end_with?', '$list_marker_keyword', '$parent', '$warn', '$logger', '$context', '$error', '$new', '$size', '$columns', '$by_section', '$rows', '$colspan', '$rowspan', '$role?', '$unshift', '$shift', '$split', '$nil_or_empty?', '$type', '$catalog', '$xreftext', '$target', '$map', '$chop', '$upcase', '$read_contents', '$sub', '$match']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $Html5Converter(){};
      var self = $Html5Converter = $klass($base, $super, 'Html5Converter', $Html5Converter);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Html5Converter_initialize_1, TMP_Html5Converter_document_2, TMP_Html5Converter_embedded_5, TMP_Html5Converter_outline_7, TMP_Html5Converter_section_9, TMP_Html5Converter_admonition_10, TMP_Html5Converter_audio_11, TMP_Html5Converter_colist_12, TMP_Html5Converter_dlist_15, TMP_Html5Converter_example_22, TMP_Html5Converter_floating_title_23, TMP_Html5Converter_image_24, TMP_Html5Converter_listing_25, TMP_Html5Converter_literal_26, TMP_Html5Converter_stem_27, TMP_Html5Converter_olist_29, TMP_Html5Converter_open_31, TMP_Html5Converter_page_break_32, TMP_Html5Converter_paragraph_33, TMP_Html5Converter_preamble_34, TMP_Html5Converter_quote_35, TMP_Html5Converter_thematic_break_36, TMP_Html5Converter_sidebar_37, TMP_Html5Converter_table_38, TMP_Html5Converter_toc_43, TMP_Html5Converter_ulist_44, TMP_Html5Converter_verse_46, TMP_Html5Converter_video_47, TMP_Html5Converter_inline_anchor_48, TMP_Html5Converter_inline_break_49, TMP_Html5Converter_inline_button_50, TMP_Html5Converter_inline_callout_51, TMP_Html5Converter_inline_footnote_52, TMP_Html5Converter_inline_image_53, TMP_Html5Converter_inline_indexterm_56, TMP_Html5Converter_inline_kbd_57, TMP_Html5Converter_inline_menu_58, TMP_Html5Converter_inline_quoted_59, TMP_Html5Converter_append_boolean_attribute_60, TMP_Html5Converter_encode_quotes_61, TMP_Html5Converter_generate_manname_section_62, TMP_Html5Converter_append_link_constraint_attrs_63, TMP_Html5Converter_read_svg_contents_64, $writer = nil;

      def.xml_mode = def.void_element_slash = def.stylesheets = def.pygments_bg = def.refs = nil;
      
      
      $writer = [["", "", false]];
      $send(Opal.const_set($nesting[0], 'QUOTE_TAGS', $hash2(["monospaced", "emphasis", "strong", "double", "single", "mark", "superscript", "subscript", "asciimath", "latexmath"], {"monospaced": ["<code>", "</code>", true], "emphasis": ["<em>", "</em>", true], "strong": ["<strong>", "</strong>", true], "double": ["&#8220;", "&#8221;", false], "single": ["&#8216;", "&#8217;", false], "mark": ["<mark>", "</mark>", true], "superscript": ["<sup>", "</sup>", true], "subscript": ["<sub>", "</sub>", true], "asciimath": ["\\$", "\\$", false], "latexmath": ["\\(", "\\)", false]})), 'default=', Opal.to_a($writer));
      $writer[$rb_minus($writer["length"], 1)];;
      Opal.const_set($nesting[0], 'DropAnchorRx', /<(?:a[^>+]+|\/a)>/);
      Opal.const_set($nesting[0], 'StemBreakRx', / *\\\n(?:\\?\n)*|\n\n+/);
      Opal.const_set($nesting[0], 'SvgPreambleRx', /^.*?(?=<svg\b)/m);
      Opal.const_set($nesting[0], 'SvgStartTagRx', /^<svg[^>]*>/);
      Opal.const_set($nesting[0], 'DimensionAttributeRx', /\s(?:width|height|style)=(["']).*?\1/);
      
      Opal.def(self, '$initialize', TMP_Html5Converter_initialize_1 = function $$initialize(backend, opts) {
        var self = this;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        self.xml_mode = opts['$[]']("htmlsyntax")['$==']("xml");
        self.void_element_slash = (function() {if ($truthy(self.xml_mode)) {
          return "/"
        } else {
          return nil
        }; return nil; })();
        return (self.stylesheets = $$($nesting, 'Stylesheets').$instance());
      }, TMP_Html5Converter_initialize_1.$$arity = -2);
      
      Opal.def(self, '$document', TMP_Html5Converter_document_2 = function $$document(node) {
        var $a, $b, $c, TMP_3, TMP_4, self = this, slash = nil, br = nil, asset_uri_scheme = nil, cdn_base = nil, linkcss = nil, result = nil, lang_attribute = nil, authors = nil, icon_href = nil, icon_type = nil, icon_ext = nil, webfonts = nil, iconfont_stylesheet = nil, $case = nil, highlighter = nil, pygments_style = nil, docinfo_content = nil, body_attrs = nil, sectioned = nil, classes = nil, details = nil, idx = nil, highlightjs_path = nil, prettify_path = nil, eqnums_val = nil, eqnums_opt = nil;

        
        slash = self.void_element_slash;
        br = "" + "<br" + (slash) + ">";
        if ($truthy((asset_uri_scheme = node.$attr("asset-uri-scheme", "https"))['$empty?']())) {
        } else {
          asset_uri_scheme = "" + (asset_uri_scheme) + ":"
        };
        cdn_base = "" + (asset_uri_scheme) + "//cdnjs.cloudflare.com/ajax/libs";
        linkcss = node['$attr?']("linkcss");
        result = ["<!DOCTYPE html>"];
        lang_attribute = (function() {if ($truthy(node['$attr?']("nolang"))) {
          return ""
        } else {
          return "" + " lang=\"" + (node.$attr("lang", "en")) + "\""
        }; return nil; })();
        result['$<<']("" + "<html" + ((function() {if ($truthy(self.xml_mode)) {
          return " xmlns=\"http://www.w3.org/1999/xhtml\""
        } else {
          return ""
        }; return nil; })()) + (lang_attribute) + ">");
        result['$<<']("" + "<head>\n" + "<meta charset=\"" + (node.$attr("encoding", "UTF-8")) + "\"" + (slash) + ">\n" + "<!--[if IE]><meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"" + (slash) + "><![endif]-->\n" + "<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"" + (slash) + ">\n" + "<meta name=\"generator\" content=\"Asciidoctor " + (node.$attr("asciidoctor-version")) + "\"" + (slash) + ">");
        if ($truthy(node['$attr?']("app-name"))) {
          result['$<<']("" + "<meta name=\"application-name\" content=\"" + (node.$attr("app-name")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("description"))) {
          result['$<<']("" + "<meta name=\"description\" content=\"" + (node.$attr("description")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("keywords"))) {
          result['$<<']("" + "<meta name=\"keywords\" content=\"" + (node.$attr("keywords")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("authors"))) {
          result['$<<']("" + "<meta name=\"author\" content=\"" + ((function() {if ($truthy((authors = node.$attr("authors"))['$include?']("<"))) {
            
            return authors.$gsub($$($nesting, 'XmlSanitizeRx'), "");
          } else {
            return authors
          }; return nil; })()) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("copyright"))) {
          result['$<<']("" + "<meta name=\"copyright\" content=\"" + (node.$attr("copyright")) + "\"" + (slash) + ">")};
        if ($truthy(node['$attr?']("favicon"))) {
          
          if ($truthy((icon_href = node.$attr("favicon"))['$empty?']())) {
            $a = ["favicon.ico", "image/x-icon"], (icon_href = $a[0]), (icon_type = $a[1]), $a
          } else {
            icon_type = (function() {if ((icon_ext = $$$('::', 'File').$extname(icon_href))['$=='](".ico")) {
              return "image/x-icon"
            } else {
              return "" + "image/" + (icon_ext.$slice(1, icon_ext.$length()))
            }; return nil; })()
          };
          result['$<<']("" + "<link rel=\"icon\" type=\"" + (icon_type) + "\" href=\"" + (icon_href) + "\"" + (slash) + ">");};
        result['$<<']("" + "<title>" + (node.$doctitle($hash2(["sanitize", "use_fallback"], {"sanitize": true, "use_fallback": true}))) + "</title>");
        if ($truthy($$($nesting, 'DEFAULT_STYLESHEET_KEYS')['$include?'](node.$attr("stylesheet")))) {
          
          if ($truthy((webfonts = node.$attr("webfonts")))) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (asset_uri_scheme) + "//fonts.googleapis.com/css?family=" + ((function() {if ($truthy(webfonts['$empty?']())) {
              return "Open+Sans:300,300italic,400,400italic,600,600italic%7CNoto+Serif:400,400italic,700,700italic%7CDroid+Sans+Mono:400,700"
            } else {
              return webfonts
            }; return nil; })()) + "\"" + (slash) + ">")};
          if ($truthy(linkcss)) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path($$($nesting, 'DEFAULT_STYLESHEET_NAME'), node.$attr("stylesdir", ""), false)) + "\"" + (slash) + ">")
          } else {
            result['$<<'](self.stylesheets.$embed_primary_stylesheet())
          };
        } else if ($truthy(node['$attr?']("stylesheet"))) {
          if ($truthy(linkcss)) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path(node.$attr("stylesheet"), node.$attr("stylesdir", ""))) + "\"" + (slash) + ">")
          } else {
            result['$<<']("" + "<style>\n" + (node.$read_asset(node.$normalize_system_path(node.$attr("stylesheet"), node.$attr("stylesdir", "")), $hash2(["warn_on_failure", "label"], {"warn_on_failure": true, "label": "stylesheet"}))) + "\n" + "</style>")
          }};
        if ($truthy(node['$attr?']("icons", "font"))) {
          if ($truthy(node['$attr?']("iconfont-remote"))) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$attr("iconfont-cdn", "" + (cdn_base) + "/font-awesome/" + ($$($nesting, 'FONT_AWESOME_VERSION')) + "/css/font-awesome.min.css")) + "\"" + (slash) + ">")
          } else {
            
            iconfont_stylesheet = "" + (node.$attr("iconfont-name", "font-awesome")) + ".css";
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path(iconfont_stylesheet, node.$attr("stylesdir", ""), false)) + "\"" + (slash) + ">");
          }};
        $case = (highlighter = node.$attr("source-highlighter"));
        if ("coderay"['$===']($case)) {if (node.$attr("coderay-css", "class")['$==']("class")) {
          if ($truthy(linkcss)) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path(self.stylesheets.$coderay_stylesheet_name(), node.$attr("stylesdir", ""), false)) + "\"" + (slash) + ">")
          } else {
            result['$<<'](self.stylesheets.$embed_coderay_stylesheet())
          }}}
        else if ("pygments"['$===']($case)) {if (node.$attr("pygments-css", "class")['$==']("class")) {
          
          pygments_style = node.$attr("pygments-style");
          if ($truthy(linkcss)) {
            result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (node.$normalize_web_path(self.stylesheets.$pygments_stylesheet_name(pygments_style), node.$attr("stylesdir", ""), false)) + "\"" + (slash) + ">")
          } else {
            result['$<<'](self.stylesheets.$embed_pygments_stylesheet(pygments_style))
          };}};
        if ($truthy((docinfo_content = node.$docinfo())['$empty?']())) {
        } else {
          result['$<<'](docinfo_content)
        };
        result['$<<']("</head>");
        body_attrs = (function() {if ($truthy(node.$id())) {
          return ["" + "id=\"" + (node.$id()) + "\""]
        } else {
          return []
        }; return nil; })();
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = (sectioned = node['$sections?']())) ? node['$attr?']("toc-class") : $c)) ? node['$attr?']("toc") : $b)) ? node['$attr?']("toc-placement", "auto") : $a))) {
          classes = [node.$doctype(), node.$attr("toc-class"), "" + "toc-" + (node.$attr("toc-position", "header"))]
        } else {
          classes = [node.$doctype()]
        };
        if ($truthy(node['$attr?']("docrole"))) {
          classes['$<<'](node.$attr("docrole"))};
        body_attrs['$<<']("" + "class=\"" + (classes.$join(" ")) + "\"");
        if ($truthy(node['$attr?']("max-width"))) {
          body_attrs['$<<']("" + "style=\"max-width: " + (node.$attr("max-width")) + ";\"")};
        result['$<<']("" + "<body " + (body_attrs.$join(" ")) + ">");
        if ($truthy(node.$noheader())) {
        } else {
          
          result['$<<']("<div id=\"header\">");
          if (node.$doctype()['$==']("manpage")) {
            
            result['$<<']("" + "<h1>" + (node.$doctitle()) + " Manual Page</h1>");
            if ($truthy(($truthy($a = ($truthy($b = sectioned) ? node['$attr?']("toc") : $b)) ? node['$attr?']("toc-placement", "auto") : $a))) {
              result['$<<']("" + "<div id=\"toc\" class=\"" + (node.$attr("toc-class", "toc")) + "\">\n" + "<div id=\"toctitle\">" + (node.$attr("toc-title")) + "</div>\n" + (self.$outline(node)) + "\n" + "</div>")};
            if ($truthy(node['$attr?']("manpurpose"))) {
              result['$<<'](self.$generate_manname_section(node))};
          } else {
            
            if ($truthy(node['$has_header?']())) {
              
              if ($truthy(node.$notitle())) {
              } else {
                result['$<<']("" + "<h1>" + (node.$header().$title()) + "</h1>")
              };
              details = [];
              idx = 1;
              $send(node.$authors(), 'each', [], (TMP_3 = function(author){var self = TMP_3.$$s || this;

              
                
                if (author == null) {
                  author = nil;
                };
                details['$<<']("" + "<span id=\"author" + ((function() {if ($truthy($rb_gt(idx, 1))) {
                  return idx
                } else {
                  return ""
                }; return nil; })()) + "\" class=\"author\">" + (author.$name()) + "</span>" + (br));
                if ($truthy(author.$email())) {
                  details['$<<']("" + "<span id=\"email" + ((function() {if ($truthy($rb_gt(idx, 1))) {
                    return idx
                  } else {
                    return ""
                  }; return nil; })()) + "\" class=\"email\">" + (node.$sub_macros(author.$email())) + "</span>" + (br))};
                return (idx = $rb_plus(idx, 1));}, TMP_3.$$s = self, TMP_3.$$arity = 1, TMP_3));
              if ($truthy(node['$attr?']("revnumber"))) {
                details['$<<']("" + "<span id=\"revnumber\">" + (($truthy($a = node.$attr("version-label")) ? $a : "").$downcase()) + " " + (node.$attr("revnumber")) + ((function() {if ($truthy(node['$attr?']("revdate"))) {
                  return ","
                } else {
                  return ""
                }; return nil; })()) + "</span>")};
              if ($truthy(node['$attr?']("revdate"))) {
                details['$<<']("" + "<span id=\"revdate\">" + (node.$attr("revdate")) + "</span>")};
              if ($truthy(node['$attr?']("revremark"))) {
                details['$<<']("" + (br) + "<span id=\"revremark\">" + (node.$attr("revremark")) + "</span>")};
              if ($truthy(details['$empty?']())) {
              } else {
                
                result['$<<']("<div class=\"details\">");
                result.$concat(details);
                result['$<<']("</div>");
              };};
            if ($truthy(($truthy($a = ($truthy($b = sectioned) ? node['$attr?']("toc") : $b)) ? node['$attr?']("toc-placement", "auto") : $a))) {
              result['$<<']("" + "<div id=\"toc\" class=\"" + (node.$attr("toc-class", "toc")) + "\">\n" + "<div id=\"toctitle\">" + (node.$attr("toc-title")) + "</div>\n" + (self.$outline(node)) + "\n" + "</div>")};
          };
          result['$<<']("</div>");
        };
        result['$<<']("" + "<div id=\"content\">\n" + (node.$content()) + "\n" + "</div>");
        if ($truthy(($truthy($a = node['$footnotes?']()) ? node['$attr?']("nofootnotes")['$!']() : $a))) {
          
          result['$<<']("" + "<div id=\"footnotes\">\n" + "<hr" + (slash) + ">");
          $send(node.$footnotes(), 'each', [], (TMP_4 = function(footnote){var self = TMP_4.$$s || this;

          
            
            if (footnote == null) {
              footnote = nil;
            };
            return result['$<<']("" + "<div class=\"footnote\" id=\"_footnotedef_" + (footnote.$index()) + "\">\n" + "<a href=\"#_footnoteref_" + (footnote.$index()) + "\">" + (footnote.$index()) + "</a>. " + (footnote.$text()) + "\n" + "</div>");}, TMP_4.$$s = self, TMP_4.$$arity = 1, TMP_4));
          result['$<<']("</div>");};
        if ($truthy(node.$nofooter())) {
        } else {
          
          result['$<<']("<div id=\"footer\">");
          result['$<<']("<div id=\"footer-text\">");
          if ($truthy(node['$attr?']("revnumber"))) {
            result['$<<']("" + (node.$attr("version-label")) + " " + (node.$attr("revnumber")) + (br))};
          if ($truthy(($truthy($a = node['$attr?']("last-update-label")) ? node['$attr?']("reproducible")['$!']() : $a))) {
            result['$<<']("" + (node.$attr("last-update-label")) + " " + (node.$attr("docdatetime")))};
          result['$<<']("</div>");
          result['$<<']("</div>");
        };
        if ($truthy((docinfo_content = node.$docinfo("footer"))['$empty?']())) {
        } else {
          result['$<<'](docinfo_content)
        };
        $case = highlighter;
        if ("highlightjs"['$===']($case) || "highlight.js"['$===']($case)) {
        highlightjs_path = node.$attr("highlightjsdir", "" + (cdn_base) + "/highlight.js/9.13.1");
        result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (highlightjs_path) + "/styles/" + (node.$attr("highlightjs-theme", "github")) + ".min.css\"" + (slash) + ">");
        result['$<<']("" + "<script src=\"" + (highlightjs_path) + "/highlight.min.js\"></script>\n" + "<script>hljs.initHighlighting()</script>");}
        else if ("prettify"['$===']($case)) {
        prettify_path = node.$attr("prettifydir", "" + (cdn_base) + "/prettify/r298");
        result['$<<']("" + "<link rel=\"stylesheet\" href=\"" + (prettify_path) + "/" + (node.$attr("prettify-theme", "prettify")) + ".min.css\"" + (slash) + ">");
        result['$<<']("" + "<script src=\"" + (prettify_path) + "/prettify.min.js\"></script>\n" + "<script>prettyPrint()</script>");};
        if ($truthy(node['$attr?']("stem"))) {
          
          eqnums_val = node.$attr("eqnums", "none");
          if ($truthy(eqnums_val['$empty?']())) {
            eqnums_val = "AMS"};
          eqnums_opt = "" + " equationNumbers: { autoNumber: \"" + (eqnums_val) + "\" } ";
          result['$<<']("" + "<script type=\"text/x-mathjax-config\">\n" + "MathJax.Hub.Config({\n" + "  messageStyle: \"none\",\n" + "  tex2jax: {\n" + "    inlineMath: [" + ($$($nesting, 'INLINE_MATH_DELIMITERS')['$[]']("latexmath").$inspect()) + "],\n" + "    displayMath: [" + ($$($nesting, 'BLOCK_MATH_DELIMITERS')['$[]']("latexmath").$inspect()) + "],\n" + "    ignoreClass: \"nostem|nolatexmath\"\n" + "  },\n" + "  asciimath2jax: {\n" + "    delimiters: [" + ($$($nesting, 'BLOCK_MATH_DELIMITERS')['$[]']("asciimath").$inspect()) + "],\n" + "    ignoreClass: \"nostem|noasciimath\"\n" + "  },\n" + "  TeX: {" + (eqnums_opt) + "}\n" + "});\n" + "</script>\n" + "<script src=\"" + (cdn_base) + "/mathjax/" + ($$($nesting, 'MATHJAX_VERSION')) + "/MathJax.js?config=TeX-MML-AM_HTMLorMML\"></script>");};
        result['$<<']("</body>");
        result['$<<']("</html>");
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_document_2.$$arity = 1);
      
      Opal.def(self, '$embedded', TMP_Html5Converter_embedded_5 = function $$embedded(node) {
        var $a, $b, $c, TMP_6, self = this, result = nil, id_attr = nil, toc_p = nil;

        
        result = [];
        if (node.$doctype()['$==']("manpage")) {
          
          if ($truthy(node.$notitle())) {
          } else {
            
            id_attr = (function() {if ($truthy(node.$id())) {
              return "" + " id=\"" + (node.$id()) + "\""
            } else {
              return ""
            }; return nil; })();
            result['$<<']("" + "<h1" + (id_attr) + ">" + (node.$doctitle()) + " Manual Page</h1>");
          };
          if ($truthy(node['$attr?']("manpurpose"))) {
            result['$<<'](self.$generate_manname_section(node))};
        } else if ($truthy(($truthy($a = node['$has_header?']()) ? node.$notitle()['$!']() : $a))) {
          
          id_attr = (function() {if ($truthy(node.$id())) {
            return "" + " id=\"" + (node.$id()) + "\""
          } else {
            return ""
          }; return nil; })();
          result['$<<']("" + "<h1" + (id_attr) + ">" + (node.$header().$title()) + "</h1>");};
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = node['$sections?']()) ? node['$attr?']("toc") : $c)) ? (toc_p = node.$attr("toc-placement"))['$!=']("macro") : $b)) ? toc_p['$!=']("preamble") : $a))) {
          result['$<<']("" + "<div id=\"toc\" class=\"toc\">\n" + "<div id=\"toctitle\">" + (node.$attr("toc-title")) + "</div>\n" + (self.$outline(node)) + "\n" + "</div>")};
        result['$<<'](node.$content());
        if ($truthy(($truthy($a = node['$footnotes?']()) ? node['$attr?']("nofootnotes")['$!']() : $a))) {
          
          result['$<<']("" + "<div id=\"footnotes\">\n" + "<hr" + (self.void_element_slash) + ">");
          $send(node.$footnotes(), 'each', [], (TMP_6 = function(footnote){var self = TMP_6.$$s || this;

          
            
            if (footnote == null) {
              footnote = nil;
            };
            return result['$<<']("" + "<div class=\"footnote\" id=\"_footnotedef_" + (footnote.$index()) + "\">\n" + "<a href=\"#_footnoteref_" + (footnote.$index()) + "\">" + (footnote.$index()) + "</a>. " + (footnote.$text()) + "\n" + "</div>");}, TMP_6.$$s = self, TMP_6.$$arity = 1, TMP_6));
          result['$<<']("</div>");};
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_embedded_5.$$arity = 1);
      
      Opal.def(self, '$outline', TMP_Html5Converter_outline_7 = function $$outline(node, opts) {
        var $a, $b, TMP_8, self = this, sectnumlevels = nil, toclevels = nil, sections = nil, result = nil;

        
        
        if (opts == null) {
          opts = $hash2([], {});
        };
        if ($truthy(node['$sections?']())) {
        } else {
          return nil
        };
        sectnumlevels = ($truthy($a = opts['$[]']("sectnumlevels")) ? $a : ($truthy($b = node.$document().$attributes()['$[]']("sectnumlevels")) ? $b : 3).$to_i());
        toclevels = ($truthy($a = opts['$[]']("toclevels")) ? $a : ($truthy($b = node.$document().$attributes()['$[]']("toclevels")) ? $b : 2).$to_i());
        sections = node.$sections();
        result = ["" + "<ul class=\"sectlevel" + (sections['$[]'](0).$level()) + "\">"];
        $send(sections, 'each', [], (TMP_8 = function(section){var self = TMP_8.$$s || this, $c, slevel = nil, stitle = nil, signifier = nil, child_toc_level = nil;

        
          
          if (section == null) {
            section = nil;
          };
          slevel = section.$level();
          if ($truthy(section.$caption())) {
            stitle = section.$captioned_title()
          } else if ($truthy(($truthy($c = section.$numbered()) ? $rb_le(slevel, sectnumlevels) : $c))) {
            if ($truthy(($truthy($c = $rb_lt(slevel, 2)) ? node.$document().$doctype()['$==']("book") : $c))) {
              if (section.$sectname()['$==']("chapter")) {
                stitle = "" + ((function() {if ($truthy((signifier = node.$document().$attributes()['$[]']("chapter-signifier")))) {
                  return "" + (signifier) + " "
                } else {
                  return ""
                }; return nil; })()) + (section.$sectnum()) + " " + (section.$title())
              } else if (section.$sectname()['$==']("part")) {
                stitle = "" + ((function() {if ($truthy((signifier = node.$document().$attributes()['$[]']("part-signifier")))) {
                  return "" + (signifier) + " "
                } else {
                  return ""
                }; return nil; })()) + (section.$sectnum(nil, ":")) + " " + (section.$title())
              } else {
                stitle = "" + (section.$sectnum()) + " " + (section.$title())
              }
            } else {
              stitle = "" + (section.$sectnum()) + " " + (section.$title())
            }
          } else {
            stitle = section.$title()
          };
          if ($truthy(stitle['$include?']("<a"))) {
            stitle = stitle.$gsub($$($nesting, 'DropAnchorRx'), "")};
          if ($truthy(($truthy($c = $rb_lt(slevel, toclevels)) ? (child_toc_level = self.$outline(section, $hash2(["toclevels", "sectnumlevels"], {"toclevels": toclevels, "sectnumlevels": sectnumlevels}))) : $c))) {
            
            result['$<<']("" + "<li><a href=\"#" + (section.$id()) + "\">" + (stitle) + "</a>");
            result['$<<'](child_toc_level);
            return result['$<<']("</li>");
          } else {
            return result['$<<']("" + "<li><a href=\"#" + (section.$id()) + "\">" + (stitle) + "</a></li>")
          };}, TMP_8.$$s = self, TMP_8.$$arity = 1, TMP_8));
        result['$<<']("</ul>");
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_outline_7.$$arity = -2);
      
      Opal.def(self, '$section', TMP_Html5Converter_section_9 = function $$section(node) {
        var $a, $b, self = this, doc_attrs = nil, level = nil, title = nil, signifier = nil, id_attr = nil, id = nil, role = nil;

        
        doc_attrs = node.$document().$attributes();
        level = node.$level();
        if ($truthy(node.$caption())) {
          title = node.$captioned_title()
        } else if ($truthy(($truthy($a = node.$numbered()) ? $rb_le(level, ($truthy($b = doc_attrs['$[]']("sectnumlevels")) ? $b : 3).$to_i()) : $a))) {
          if ($truthy(($truthy($a = $rb_lt(level, 2)) ? node.$document().$doctype()['$==']("book") : $a))) {
            if (node.$sectname()['$==']("chapter")) {
              title = "" + ((function() {if ($truthy((signifier = doc_attrs['$[]']("chapter-signifier")))) {
                return "" + (signifier) + " "
              } else {
                return ""
              }; return nil; })()) + (node.$sectnum()) + " " + (node.$title())
            } else if (node.$sectname()['$==']("part")) {
              title = "" + ((function() {if ($truthy((signifier = doc_attrs['$[]']("part-signifier")))) {
                return "" + (signifier) + " "
              } else {
                return ""
              }; return nil; })()) + (node.$sectnum(nil, ":")) + " " + (node.$title())
            } else {
              title = "" + (node.$sectnum()) + " " + (node.$title())
            }
          } else {
            title = "" + (node.$sectnum()) + " " + (node.$title())
          }
        } else {
          title = node.$title()
        };
        if ($truthy(node.$id())) {
          
          id_attr = "" + " id=\"" + ((id = node.$id())) + "\"";
          if ($truthy(doc_attrs['$[]']("sectlinks"))) {
            title = "" + "<a class=\"link\" href=\"#" + (id) + "\">" + (title) + "</a>"};
          if ($truthy(doc_attrs['$[]']("sectanchors"))) {
            if (doc_attrs['$[]']("sectanchors")['$==']("after")) {
              title = "" + (title) + "<a class=\"anchor\" href=\"#" + (id) + "\"></a>"
            } else {
              title = "" + "<a class=\"anchor\" href=\"#" + (id) + "\"></a>" + (title)
            }};
        } else {
          id_attr = ""
        };
        if (level['$=='](0)) {
          return "" + "<h1" + (id_attr) + " class=\"sect0" + ((function() {if ($truthy((role = node.$role()))) {
            return "" + " " + (role)
          } else {
            return ""
          }; return nil; })()) + "\">" + (title) + "</h1>\n" + (node.$content())
        } else {
          return "" + "<div class=\"sect" + (level) + ((function() {if ($truthy((role = node.$role()))) {
            return "" + " " + (role)
          } else {
            return ""
          }; return nil; })()) + "\">\n" + "<h" + ($rb_plus(level, 1)) + (id_attr) + ">" + (title) + "</h" + ($rb_plus(level, 1)) + ">\n" + ((function() {if (level['$=='](1)) {
            return "" + "<div class=\"sectionbody\">\n" + (node.$content()) + "\n" + "</div>"
          } else {
            return node.$content()
          }; return nil; })()) + "\n" + "</div>"
        };
      }, TMP_Html5Converter_section_9.$$arity = 1);
      
      Opal.def(self, '$admonition', TMP_Html5Converter_admonition_10 = function $$admonition(node) {
        var $a, self = this, id_attr = nil, name = nil, title_element = nil, label = nil, role = nil;

        
        id_attr = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        name = node.$attr("name");
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        if ($truthy(node.$document()['$attr?']("icons"))) {
          if ($truthy(($truthy($a = node.$document()['$attr?']("icons", "font")) ? node['$attr?']("icon")['$!']() : $a))) {
            label = "" + "<i class=\"fa icon-" + (name) + "\" title=\"" + (node.$attr("textlabel")) + "\"></i>"
          } else {
            label = "" + "<img src=\"" + (node.$icon_uri(name)) + "\" alt=\"" + (node.$attr("textlabel")) + "\"" + (self.void_element_slash) + ">"
          }
        } else {
          label = "" + "<div class=\"title\">" + (node.$attr("textlabel")) + "</div>"
        };
        return "" + "<div" + (id_attr) + " class=\"admonitionblock " + (name) + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + "<table>\n" + "<tr>\n" + "<td class=\"icon\">\n" + (label) + "\n" + "</td>\n" + "<td class=\"content\">\n" + (title_element) + (node.$content()) + "\n" + "</td>\n" + "</tr>\n" + "</table>\n" + "</div>";
      }, TMP_Html5Converter_admonition_10.$$arity = 1);
      
      Opal.def(self, '$audio', TMP_Html5Converter_audio_11 = function $$audio(node) {
        var $a, self = this, xml = nil, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, start_t = nil, end_t = nil, time_anchor = nil;

        
        xml = self.xml_mode;
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["audioblock", node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        start_t = node.$attr("start", nil, false);
        end_t = node.$attr("end", nil, false);
        time_anchor = (function() {if ($truthy(($truthy($a = start_t) ? $a : end_t))) {
          return "" + "#t=" + (($truthy($a = start_t) ? $a : "")) + ((function() {if ($truthy(end_t)) {
            return "" + "," + (end_t)
          } else {
            return ""
          }; return nil; })())
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + (class_attribute) + ">\n" + (title_element) + "<div class=\"content\">\n" + "<audio src=\"" + (node.$media_uri(node.$attr("target"))) + (time_anchor) + "\"" + ((function() {if ($truthy(node['$option?']("autoplay"))) {
          
          return self.$append_boolean_attribute("autoplay", xml);
        } else {
          return ""
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("nocontrols"))) {
          return ""
        } else {
          
          return self.$append_boolean_attribute("controls", xml);
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("loop"))) {
          
          return self.$append_boolean_attribute("loop", xml);
        } else {
          return ""
        }; return nil; })()) + ">\n" + "Your browser does not support the audio tag.\n" + "</audio>\n" + "</div>\n" + "</div>";
      }, TMP_Html5Converter_audio_11.$$arity = 1);
      
      Opal.def(self, '$colist', TMP_Html5Converter_colist_12 = function $$colist(node) {
        var $a, TMP_13, TMP_14, self = this, result = nil, id_attribute = nil, classes = nil, class_attribute = nil, font_icons = nil, num = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["colist", node.$style(), node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        result['$<<']("" + "<div" + (id_attribute) + (class_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        if ($truthy(node.$document()['$attr?']("icons"))) {
          
          result['$<<']("<table>");
          $a = [node.$document()['$attr?']("icons", "font"), 0], (font_icons = $a[0]), (num = $a[1]), $a;
          $send(node.$items(), 'each', [], (TMP_13 = function(item){var self = TMP_13.$$s || this, num_label = nil;
            if (self.void_element_slash == null) self.void_element_slash = nil;

          
            
            if (item == null) {
              item = nil;
            };
            num = $rb_plus(num, 1);
            if ($truthy(font_icons)) {
              num_label = "" + "<i class=\"conum\" data-value=\"" + (num) + "\"></i><b>" + (num) + "</b>"
            } else {
              num_label = "" + "<img src=\"" + (node.$icon_uri("" + "callouts/" + (num))) + "\" alt=\"" + (num) + "\"" + (self.void_element_slash) + ">"
            };
            return result['$<<']("" + "<tr>\n" + "<td>" + (num_label) + "</td>\n" + "<td>" + (item.$text()) + ((function() {if ($truthy(item['$blocks?']())) {
              return $rb_plus($$($nesting, 'LF'), item.$content())
            } else {
              return ""
            }; return nil; })()) + "</td>\n" + "</tr>");}, TMP_13.$$s = self, TMP_13.$$arity = 1, TMP_13));
          result['$<<']("</table>");
        } else {
          
          result['$<<']("<ol>");
          $send(node.$items(), 'each', [], (TMP_14 = function(item){var self = TMP_14.$$s || this;

          
            
            if (item == null) {
              item = nil;
            };
            return result['$<<']("" + "<li>\n" + "<p>" + (item.$text()) + "</p>" + ((function() {if ($truthy(item['$blocks?']())) {
              return $rb_plus($$($nesting, 'LF'), item.$content())
            } else {
              return ""
            }; return nil; })()) + "\n" + "</li>");}, TMP_14.$$s = self, TMP_14.$$arity = 1, TMP_14));
          result['$<<']("</ol>");
        };
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_colist_12.$$arity = 1);
      
      Opal.def(self, '$dlist', TMP_Html5Converter_dlist_15 = function $$dlist(node) {
        var TMP_16, $a, TMP_18, TMP_20, self = this, result = nil, id_attribute = nil, classes = nil, $case = nil, class_attribute = nil, slash = nil, col_style_attribute = nil, dt_style_attribute = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = (function() {$case = node.$style();
        if ("qanda"['$===']($case)) {return ["qlist", "qanda", node.$role()]}
        else if ("horizontal"['$===']($case)) {return ["hdlist", node.$role()]}
        else {return ["dlist", node.$style(), node.$role()]}})().$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        result['$<<']("" + "<div" + (id_attribute) + (class_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        $case = node.$style();
        if ("qanda"['$===']($case)) {
        result['$<<']("<ol>");
        $send(node.$items(), 'each', [], (TMP_16 = function(terms, dd){var self = TMP_16.$$s || this, TMP_17;

        
          
          if (terms == null) {
            terms = nil;
          };
          
          if (dd == null) {
            dd = nil;
          };
          result['$<<']("<li>");
          $send([].concat(Opal.to_a(terms)), 'each', [], (TMP_17 = function(dt){var self = TMP_17.$$s || this;

          
            
            if (dt == null) {
              dt = nil;
            };
            return result['$<<']("" + "<p><em>" + (dt.$text()) + "</em></p>");}, TMP_17.$$s = self, TMP_17.$$arity = 1, TMP_17));
          if ($truthy(dd)) {
            
            if ($truthy(dd['$text?']())) {
              result['$<<']("" + "<p>" + (dd.$text()) + "</p>")};
            if ($truthy(dd['$blocks?']())) {
              result['$<<'](dd.$content())};};
          return result['$<<']("</li>");}, TMP_16.$$s = self, TMP_16.$$arity = 2, TMP_16));
        result['$<<']("</ol>");}
        else if ("horizontal"['$===']($case)) {
        slash = self.void_element_slash;
        result['$<<']("<table>");
        if ($truthy(($truthy($a = node['$attr?']("labelwidth")) ? $a : node['$attr?']("itemwidth")))) {
          
          result['$<<']("<colgroup>");
          col_style_attribute = (function() {if ($truthy(node['$attr?']("labelwidth"))) {
            return "" + " style=\"width: " + (node.$attr("labelwidth").$chomp("%")) + "%;\""
          } else {
            return ""
          }; return nil; })();
          result['$<<']("" + "<col" + (col_style_attribute) + (slash) + ">");
          col_style_attribute = (function() {if ($truthy(node['$attr?']("itemwidth"))) {
            return "" + " style=\"width: " + (node.$attr("itemwidth").$chomp("%")) + "%;\""
          } else {
            return ""
          }; return nil; })();
          result['$<<']("" + "<col" + (col_style_attribute) + (slash) + ">");
          result['$<<']("</colgroup>");};
        $send(node.$items(), 'each', [], (TMP_18 = function(terms, dd){var self = TMP_18.$$s || this, TMP_19, terms_array = nil, last_term = nil;

        
          
          if (terms == null) {
            terms = nil;
          };
          
          if (dd == null) {
            dd = nil;
          };
          result['$<<']("<tr>");
          result['$<<']("" + "<td class=\"hdlist1" + ((function() {if ($truthy(node['$option?']("strong"))) {
            return " strong"
          } else {
            return ""
          }; return nil; })()) + "\">");
          terms_array = [].concat(Opal.to_a(terms));
          last_term = terms_array['$[]'](-1);
          $send(terms_array, 'each', [], (TMP_19 = function(dt){var self = TMP_19.$$s || this;

          
            
            if (dt == null) {
              dt = nil;
            };
            result['$<<'](dt.$text());
            if ($truthy(dt['$!='](last_term))) {
              return result['$<<']("" + "<br" + (slash) + ">")
            } else {
              return nil
            };}, TMP_19.$$s = self, TMP_19.$$arity = 1, TMP_19));
          result['$<<']("</td>");
          result['$<<']("<td class=\"hdlist2\">");
          if ($truthy(dd)) {
            
            if ($truthy(dd['$text?']())) {
              result['$<<']("" + "<p>" + (dd.$text()) + "</p>")};
            if ($truthy(dd['$blocks?']())) {
              result['$<<'](dd.$content())};};
          result['$<<']("</td>");
          return result['$<<']("</tr>");}, TMP_18.$$s = self, TMP_18.$$arity = 2, TMP_18));
        result['$<<']("</table>");}
        else {
        result['$<<']("<dl>");
        dt_style_attribute = (function() {if ($truthy(node.$style())) {
          return ""
        } else {
          return " class=\"hdlist1\""
        }; return nil; })();
        $send(node.$items(), 'each', [], (TMP_20 = function(terms, dd){var self = TMP_20.$$s || this, TMP_21;

        
          
          if (terms == null) {
            terms = nil;
          };
          
          if (dd == null) {
            dd = nil;
          };
          $send([].concat(Opal.to_a(terms)), 'each', [], (TMP_21 = function(dt){var self = TMP_21.$$s || this;

          
            
            if (dt == null) {
              dt = nil;
            };
            return result['$<<']("" + "<dt" + (dt_style_attribute) + ">" + (dt.$text()) + "</dt>");}, TMP_21.$$s = self, TMP_21.$$arity = 1, TMP_21));
          if ($truthy(dd)) {
            
            result['$<<']("<dd>");
            if ($truthy(dd['$text?']())) {
              result['$<<']("" + "<p>" + (dd.$text()) + "</p>")};
            if ($truthy(dd['$blocks?']())) {
              result['$<<'](dd.$content())};
            return result['$<<']("</dd>");
          } else {
            return nil
          };}, TMP_20.$$s = self, TMP_20.$$arity = 2, TMP_20));
        result['$<<']("</dl>");};
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_dlist_15.$$arity = 1);
      
      Opal.def(self, '$example', TMP_Html5Converter_example_22 = function $$example(node) {
        var self = this, id_attribute = nil, title_element = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$captioned_title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + " class=\"exampleblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + (node.$content()) + "\n" + "</div>\n" + "</div>";
      }, TMP_Html5Converter_example_22.$$arity = 1);
      
      Opal.def(self, '$floating_title', TMP_Html5Converter_floating_title_23 = function $$floating_title(node) {
        var self = this, tag_name = nil, id_attribute = nil, classes = nil;

        
        tag_name = "" + "h" + ($rb_plus(node.$level(), 1));
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = [node.$style(), node.$role()].$compact();
        return "" + "<" + (tag_name) + (id_attribute) + " class=\"" + (classes.$join(" ")) + "\">" + (node.$title()) + "</" + (tag_name) + ">";
      }, TMP_Html5Converter_floating_title_23.$$arity = 1);
      
      Opal.def(self, '$image', TMP_Html5Converter_image_24 = function $$image(node) {
        var $a, $b, $c, self = this, target = nil, width_attr = nil, height_attr = nil, svg = nil, obj = nil, img = nil, fallback = nil, id_attr = nil, classes = nil, class_attr = nil, title_el = nil;

        
        target = node.$attr("target");
        width_attr = (function() {if ($truthy(node['$attr?']("width"))) {
          return "" + " width=\"" + (node.$attr("width")) + "\""
        } else {
          return ""
        }; return nil; })();
        height_attr = (function() {if ($truthy(node['$attr?']("height"))) {
          return "" + " height=\"" + (node.$attr("height")) + "\""
        } else {
          return ""
        }; return nil; })();
        if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = node['$attr?']("format", "svg", false)) ? $c : target['$include?'](".svg"))) ? $rb_lt(node.$document().$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')) : $b)) ? ($truthy($b = (svg = node['$option?']("inline"))) ? $b : (obj = node['$option?']("interactive"))) : $a))) {
          if ($truthy(svg)) {
            img = ($truthy($a = self.$read_svg_contents(node, target)) ? $a : "" + "<span class=\"alt\">" + (node.$alt()) + "</span>")
          } else if ($truthy(obj)) {
            
            fallback = (function() {if ($truthy(node['$attr?']("fallback"))) {
              return "" + "<img src=\"" + (node.$image_uri(node.$attr("fallback"))) + "\" alt=\"" + (self.$encode_quotes(node.$alt())) + "\"" + (width_attr) + (height_attr) + (self.void_element_slash) + ">"
            } else {
              return "" + "<span class=\"alt\">" + (node.$alt()) + "</span>"
            }; return nil; })();
            img = "" + "<object type=\"image/svg+xml\" data=\"" + (node.$image_uri(target)) + "\"" + (width_attr) + (height_attr) + ">" + (fallback) + "</object>";}};
        img = ($truthy($a = img) ? $a : "" + "<img src=\"" + (node.$image_uri(target)) + "\" alt=\"" + (self.$encode_quotes(node.$alt())) + "\"" + (width_attr) + (height_attr) + (self.void_element_slash) + ">");
        if ($truthy(node['$attr?']("link", nil, false))) {
          img = "" + "<a class=\"image\" href=\"" + (node.$attr("link")) + "\"" + (self.$append_link_constraint_attrs(node).$join()) + ">" + (img) + "</a>"};
        id_attr = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["imageblock"];
        if ($truthy(node['$attr?']("float"))) {
          classes['$<<'](node.$attr("float"))};
        if ($truthy(node['$attr?']("align"))) {
          classes['$<<']("" + "text-" + (node.$attr("align")))};
        if ($truthy(node.$role())) {
          classes['$<<'](node.$role())};
        class_attr = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_el = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$captioned_title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attr) + (class_attr) + ">\n" + "<div class=\"content\">\n" + (img) + "\n" + "</div>" + (title_el) + "\n" + "</div>";
      }, TMP_Html5Converter_image_24.$$arity = 1);
      
      Opal.def(self, '$listing', TMP_Html5Converter_listing_25 = function $$listing(node) {
        var $a, self = this, nowrap = nil, language = nil, code_attrs = nil, $case = nil, pre_class = nil, pre_start = nil, pre_end = nil, id_attribute = nil, title_element = nil, role = nil;

        
        nowrap = ($truthy($a = node.$document()['$attr?']("prewrap")['$!']()) ? $a : node['$option?']("nowrap"));
        if (node.$style()['$==']("source")) {
          
          if ($truthy((language = node.$attr("language", nil, false)))) {
            code_attrs = "" + " data-lang=\"" + (language) + "\""
          } else {
            code_attrs = ""
          };
          $case = node.$document().$attr("source-highlighter");
          if ("coderay"['$===']($case)) {pre_class = "" + " class=\"CodeRay highlight" + ((function() {if ($truthy(nowrap)) {
            return " nowrap"
          } else {
            return ""
          }; return nil; })()) + "\""}
          else if ("pygments"['$===']($case)) {if ($truthy(node.$document()['$attr?']("pygments-css", "inline"))) {
            
            if ($truthy((($a = self['pygments_bg'], $a != null && $a !== nil) ? 'instance-variable' : nil))) {
            } else {
              self.pygments_bg = self.stylesheets.$pygments_background(node.$document().$attr("pygments-style"))
            };
            pre_class = "" + " class=\"pygments highlight" + ((function() {if ($truthy(nowrap)) {
              return " nowrap"
            } else {
              return ""
            }; return nil; })()) + "\" style=\"background: " + (self.pygments_bg) + "\"";
          } else {
            pre_class = "" + " class=\"pygments highlight" + ((function() {if ($truthy(nowrap)) {
              return " nowrap"
            } else {
              return ""
            }; return nil; })()) + "\""
          }}
          else if ("highlightjs"['$===']($case) || "highlight.js"['$===']($case)) {
          pre_class = "" + " class=\"highlightjs highlight" + ((function() {if ($truthy(nowrap)) {
            return " nowrap"
          } else {
            return ""
          }; return nil; })()) + "\"";
          if ($truthy(language)) {
            code_attrs = "" + " class=\"language-" + (language) + " hljs\"" + (code_attrs)};}
          else if ("prettify"['$===']($case)) {
          pre_class = "" + " class=\"prettyprint highlight" + ((function() {if ($truthy(nowrap)) {
            return " nowrap"
          } else {
            return ""
          }; return nil; })()) + ((function() {if ($truthy(node['$attr?']("linenums", nil, false))) {
            return " linenums"
          } else {
            return ""
          }; return nil; })()) + "\"";
          if ($truthy(language)) {
            code_attrs = "" + " class=\"language-" + (language) + "\"" + (code_attrs)};}
          else if ("html-pipeline"['$===']($case)) {
          pre_class = (function() {if ($truthy(language)) {
            return "" + " lang=\"" + (language) + "\""
          } else {
            return ""
          }; return nil; })();
          code_attrs = "";}
          else {
          pre_class = "" + " class=\"highlight" + ((function() {if ($truthy(nowrap)) {
            return " nowrap"
          } else {
            return ""
          }; return nil; })()) + "\"";
          if ($truthy(language)) {
            code_attrs = "" + " class=\"language-" + (language) + "\"" + (code_attrs)};};
          pre_start = "" + "<pre" + (pre_class) + "><code" + (code_attrs) + ">";
          pre_end = "</code></pre>";
        } else {
          
          pre_start = "" + "<pre" + ((function() {if ($truthy(nowrap)) {
            return " class=\"nowrap\""
          } else {
            return ""
          }; return nil; })()) + ">";
          pre_end = "</pre>";
        };
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$captioned_title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + " class=\"listingblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + (pre_start) + (node.$content()) + (pre_end) + "\n" + "</div>\n" + "</div>";
      }, TMP_Html5Converter_listing_25.$$arity = 1);
      
      Opal.def(self, '$literal', TMP_Html5Converter_literal_26 = function $$literal(node) {
        var $a, self = this, id_attribute = nil, title_element = nil, nowrap = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        nowrap = ($truthy($a = node.$document()['$attr?']("prewrap")['$!']()) ? $a : node['$option?']("nowrap"));
        return "" + "<div" + (id_attribute) + " class=\"literalblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + "<pre" + ((function() {if ($truthy(nowrap)) {
          return " class=\"nowrap\""
        } else {
          return ""
        }; return nil; })()) + ">" + (node.$content()) + "</pre>\n" + "</div>\n" + "</div>";
      }, TMP_Html5Converter_literal_26.$$arity = 1);
      
      Opal.def(self, '$stem', TMP_Html5Converter_stem_27 = function $$stem(node) {
        var $a, $b, TMP_28, self = this, id_attribute = nil, title_element = nil, style = nil, open = nil, close = nil, equation = nil, br = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        $b = $$($nesting, 'BLOCK_MATH_DELIMITERS')['$[]']((style = node.$style().$to_sym())), $a = Opal.to_ary($b), (open = ($a[0] == null ? nil : $a[0])), (close = ($a[1] == null ? nil : $a[1])), $b;
        equation = node.$content();
        if ($truthy((($a = style['$==']("asciimath")) ? equation['$include?']($$($nesting, 'LF')) : style['$==']("asciimath")))) {
          
          br = "" + "<br" + (self.void_element_slash) + ">" + ($$($nesting, 'LF'));
          equation = $send(equation, 'gsub', [$$($nesting, 'StemBreakRx')], (TMP_28 = function(){var self = TMP_28.$$s || this, $c;

          return "" + (close) + ($rb_times(br, (($c = $gvars['~']) === nil ? nil : $c['$[]'](0)).$count($$($nesting, 'LF')))) + (open)}, TMP_28.$$s = self, TMP_28.$$arity = 0, TMP_28));};
        if ($truthy(($truthy($a = equation['$start_with?'](open)) ? equation['$end_with?'](close) : $a))) {
        } else {
          equation = "" + (open) + (equation) + (close)
        };
        return "" + "<div" + (id_attribute) + " class=\"stemblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + (title_element) + "<div class=\"content\">\n" + (equation) + "\n" + "</div>\n" + "</div>";
      }, TMP_Html5Converter_stem_27.$$arity = 1);
      
      Opal.def(self, '$olist', TMP_Html5Converter_olist_29 = function $$olist(node) {
        var TMP_30, self = this, result = nil, id_attribute = nil, classes = nil, class_attribute = nil, type_attribute = nil, keyword = nil, start_attribute = nil, reversed_attribute = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["olist", node.$style(), node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        result['$<<']("" + "<div" + (id_attribute) + (class_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        type_attribute = (function() {if ($truthy((keyword = node.$list_marker_keyword()))) {
          return "" + " type=\"" + (keyword) + "\""
        } else {
          return ""
        }; return nil; })();
        start_attribute = (function() {if ($truthy(node['$attr?']("start"))) {
          return "" + " start=\"" + (node.$attr("start")) + "\""
        } else {
          return ""
        }; return nil; })();
        reversed_attribute = (function() {if ($truthy(node['$option?']("reversed"))) {
          
          return self.$append_boolean_attribute("reversed", self.xml_mode);
        } else {
          return ""
        }; return nil; })();
        result['$<<']("" + "<ol class=\"" + (node.$style()) + "\"" + (type_attribute) + (start_attribute) + (reversed_attribute) + ">");
        $send(node.$items(), 'each', [], (TMP_30 = function(item){var self = TMP_30.$$s || this;

        
          
          if (item == null) {
            item = nil;
          };
          result['$<<']("<li>");
          result['$<<']("" + "<p>" + (item.$text()) + "</p>");
          if ($truthy(item['$blocks?']())) {
            result['$<<'](item.$content())};
          return result['$<<']("</li>");}, TMP_30.$$s = self, TMP_30.$$arity = 1, TMP_30));
        result['$<<']("</ol>");
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_olist_29.$$arity = 1);
      
      Opal.def(self, '$open', TMP_Html5Converter_open_31 = function $$open(node) {
        var $a, $b, $c, self = this, style = nil, id_attr = nil, title_el = nil, role = nil;

        if ((style = node.$style())['$==']("abstract")) {
          if ($truthy((($a = node.$parent()['$=='](node.$document())) ? node.$document().$doctype()['$==']("book") : node.$parent()['$=='](node.$document())))) {
            
            self.$logger().$warn("abstract block cannot be used in a document without a title when doctype is book. Excluding block content.");
            return "";
          } else {
            
            id_attr = (function() {if ($truthy(node.$id())) {
              return "" + " id=\"" + (node.$id()) + "\""
            } else {
              return ""
            }; return nil; })();
            title_el = (function() {if ($truthy(node['$title?']())) {
              return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
            } else {
              return ""
            }; return nil; })();
            return "" + "<div" + (id_attr) + " class=\"quoteblock abstract" + ((function() {if ($truthy((role = node.$role()))) {
              return "" + " " + (role)
            } else {
              return ""
            }; return nil; })()) + "\">\n" + (title_el) + "<blockquote>\n" + (node.$content()) + "\n" + "</blockquote>\n" + "</div>";
          }
        } else if ($truthy((($a = style['$==']("partintro")) ? ($truthy($b = ($truthy($c = $rb_gt(node.$level(), 0)) ? $c : node.$parent().$context()['$!=']("section"))) ? $b : node.$document().$doctype()['$!=']("book")) : style['$==']("partintro")))) {
          
          self.$logger().$error("partintro block can only be used when doctype is book and must be a child of a book part. Excluding block content.");
          return "";
        } else {
          
          id_attr = (function() {if ($truthy(node.$id())) {
            return "" + " id=\"" + (node.$id()) + "\""
          } else {
            return ""
          }; return nil; })();
          title_el = (function() {if ($truthy(node['$title?']())) {
            return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
          } else {
            return ""
          }; return nil; })();
          return "" + "<div" + (id_attr) + " class=\"openblock" + ((function() {if ($truthy(($truthy($a = style) ? style['$!=']("open") : $a))) {
            return "" + " " + (style)
          } else {
            return ""
          }; return nil; })()) + ((function() {if ($truthy((role = node.$role()))) {
            return "" + " " + (role)
          } else {
            return ""
          }; return nil; })()) + "\">\n" + (title_el) + "<div class=\"content\">\n" + (node.$content()) + "\n" + "</div>\n" + "</div>";
        }
      }, TMP_Html5Converter_open_31.$$arity = 1);
      
      Opal.def(self, '$page_break', TMP_Html5Converter_page_break_32 = function $$page_break(node) {
        var self = this;

        return "<div style=\"page-break-after: always;\"></div>"
      }, TMP_Html5Converter_page_break_32.$$arity = 1);
      
      Opal.def(self, '$paragraph', TMP_Html5Converter_paragraph_33 = function $$paragraph(node) {
        var self = this, class_attribute = nil, attributes = nil;

        
        class_attribute = (function() {if ($truthy(node.$role())) {
          return "" + "class=\"paragraph " + (node.$role()) + "\""
        } else {
          return "class=\"paragraph\""
        }; return nil; })();
        attributes = (function() {if ($truthy(node.$id())) {
          return "" + "id=\"" + (node.$id()) + "\" " + (class_attribute)
        } else {
          return class_attribute
        }; return nil; })();
        if ($truthy(node['$title?']())) {
          return "" + "<div " + (attributes) + ">\n" + "<div class=\"title\">" + (node.$title()) + "</div>\n" + "<p>" + (node.$content()) + "</p>\n" + "</div>"
        } else {
          return "" + "<div " + (attributes) + ">\n" + "<p>" + (node.$content()) + "</p>\n" + "</div>"
        };
      }, TMP_Html5Converter_paragraph_33.$$arity = 1);
      
      Opal.def(self, '$preamble', TMP_Html5Converter_preamble_34 = function $$preamble(node) {
        var $a, $b, self = this, doc = nil, toc = nil;

        
        if ($truthy(($truthy($a = ($truthy($b = (doc = node.$document())['$attr?']("toc-placement", "preamble")) ? doc['$sections?']() : $b)) ? doc['$attr?']("toc") : $a))) {
          toc = "" + "\n" + "<div id=\"toc\" class=\"" + (doc.$attr("toc-class", "toc")) + "\">\n" + "<div id=\"toctitle\">" + (doc.$attr("toc-title")) + "</div>\n" + (self.$outline(doc)) + "\n" + "</div>"
        } else {
          toc = ""
        };
        return "" + "<div id=\"preamble\">\n" + "<div class=\"sectionbody\">\n" + (node.$content()) + "\n" + "</div>" + (toc) + "\n" + "</div>";
      }, TMP_Html5Converter_preamble_34.$$arity = 1);
      
      Opal.def(self, '$quote', TMP_Html5Converter_quote_35 = function $$quote(node) {
        var $a, self = this, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, attribution = nil, citetitle = nil, cite_element = nil, attribution_text = nil, attribution_element = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["quoteblock", node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        attribution = (function() {if ($truthy(node['$attr?']("attribution"))) {
          
          return node.$attr("attribution");
        } else {
          return nil
        }; return nil; })();
        citetitle = (function() {if ($truthy(node['$attr?']("citetitle"))) {
          
          return node.$attr("citetitle");
        } else {
          return nil
        }; return nil; })();
        if ($truthy(($truthy($a = attribution) ? $a : citetitle))) {
          
          cite_element = (function() {if ($truthy(citetitle)) {
            return "" + "<cite>" + (citetitle) + "</cite>"
          } else {
            return ""
          }; return nil; })();
          attribution_text = (function() {if ($truthy(attribution)) {
            return "" + "&#8212; " + (attribution) + ((function() {if ($truthy(citetitle)) {
              return "" + "<br" + (self.void_element_slash) + ">\n"
            } else {
              return ""
            }; return nil; })())
          } else {
            return ""
          }; return nil; })();
          attribution_element = "" + "\n<div class=\"attribution\">\n" + (attribution_text) + (cite_element) + "\n</div>";
        } else {
          attribution_element = ""
        };
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<blockquote>\n" + (node.$content()) + "\n" + "</blockquote>" + (attribution_element) + "\n" + "</div>";
      }, TMP_Html5Converter_quote_35.$$arity = 1);
      
      Opal.def(self, '$thematic_break', TMP_Html5Converter_thematic_break_36 = function $$thematic_break(node) {
        var self = this;

        return "" + "<hr" + (self.void_element_slash) + ">"
      }, TMP_Html5Converter_thematic_break_36.$$arity = 1);
      
      Opal.def(self, '$sidebar', TMP_Html5Converter_sidebar_37 = function $$sidebar(node) {
        var self = this, id_attribute = nil, title_element = nil, role = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "<div class=\"title\">" + (node.$title()) + "</div>\n"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + " class=\"sidebarblock" + ((function() {if ($truthy((role = node.$role()))) {
          return "" + " " + (role)
        } else {
          return ""
        }; return nil; })()) + "\">\n" + "<div class=\"content\">\n" + (title_element) + (node.$content()) + "\n" + "</div>\n" + "</div>";
      }, TMP_Html5Converter_sidebar_37.$$arity = 1);
      
      Opal.def(self, '$table', TMP_Html5Converter_table_38 = function $$table(node) {
        var $a, TMP_39, TMP_40, self = this, result = nil, id_attribute = nil, classes = nil, stripes = nil, styles = nil, autowidth = nil, tablewidth = nil, role = nil, class_attribute = nil, style_attribute = nil, slash = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["tableblock", "" + "frame-" + (node.$attr("frame", "all")), "" + "grid-" + (node.$attr("grid", "all"))];
        if ($truthy((stripes = node.$attr("stripes")))) {
          classes['$<<']("" + "stripes-" + (stripes))};
        styles = [];
        if ($truthy(($truthy($a = (autowidth = node.$attributes()['$[]']("autowidth-option"))) ? node['$attr?']("width", nil, false)['$!']() : $a))) {
          classes['$<<']("fit-content")
        } else if ((tablewidth = node.$attr("tablepcwidth"))['$=='](100)) {
          classes['$<<']("stretch")
        } else {
          styles['$<<']("" + "width: " + (tablewidth) + "%;")
        };
        if ($truthy(node['$attr?']("float"))) {
          classes['$<<'](node.$attr("float"))};
        if ($truthy((role = node.$role()))) {
          classes['$<<'](role)};
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        style_attribute = (function() {if ($truthy(styles['$empty?']())) {
          return ""
        } else {
          return "" + " style=\"" + (styles.$join(" ")) + "\""
        }; return nil; })();
        result['$<<']("" + "<table" + (id_attribute) + (class_attribute) + (style_attribute) + ">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<caption class=\"title\">" + (node.$captioned_title()) + "</caption>")};
        if ($truthy($rb_gt(node.$attr("rowcount"), 0))) {
          
          slash = self.void_element_slash;
          result['$<<']("<colgroup>");
          if ($truthy(autowidth)) {
            result = $rb_plus(result, $$($nesting, 'Array').$new(node.$columns().$size(), "" + "<col" + (slash) + ">"))
          } else {
            $send(node.$columns(), 'each', [], (TMP_39 = function(col){var self = TMP_39.$$s || this;

            
              
              if (col == null) {
                col = nil;
              };
              return result['$<<']((function() {if ($truthy(col.$attributes()['$[]']("autowidth-option"))) {
                return "" + "<col" + (slash) + ">"
              } else {
                return "" + "<col style=\"width: " + (col.$attr("colpcwidth")) + "%;\"" + (slash) + ">"
              }; return nil; })());}, TMP_39.$$s = self, TMP_39.$$arity = 1, TMP_39))
          };
          result['$<<']("</colgroup>");
          $send(node.$rows().$by_section(), 'each', [], (TMP_40 = function(tsec, rows){var self = TMP_40.$$s || this, TMP_41;

          
            
            if (tsec == null) {
              tsec = nil;
            };
            
            if (rows == null) {
              rows = nil;
            };
            if ($truthy(rows['$empty?']())) {
              return nil;};
            result['$<<']("" + "<t" + (tsec) + ">");
            $send(rows, 'each', [], (TMP_41 = function(row){var self = TMP_41.$$s || this, TMP_42;

            
              
              if (row == null) {
                row = nil;
              };
              result['$<<']("<tr>");
              $send(row, 'each', [], (TMP_42 = function(cell){var self = TMP_42.$$s || this, $b, cell_content = nil, $case = nil, cell_tag_name = nil, cell_class_attribute = nil, cell_colspan_attribute = nil, cell_rowspan_attribute = nil, cell_style_attribute = nil;

              
                
                if (cell == null) {
                  cell = nil;
                };
                if (tsec['$==']("head")) {
                  cell_content = cell.$text()
                } else {
                  $case = cell.$style();
                  if ("asciidoc"['$===']($case)) {cell_content = "" + "<div class=\"content\">" + (cell.$content()) + "</div>"}
                  else if ("verse"['$===']($case)) {cell_content = "" + "<div class=\"verse\">" + (cell.$text()) + "</div>"}
                  else if ("literal"['$===']($case)) {cell_content = "" + "<div class=\"literal\"><pre>" + (cell.$text()) + "</pre></div>"}
                  else {cell_content = (function() {if ($truthy((cell_content = cell.$content())['$empty?']())) {
                    return ""
                  } else {
                    return "" + "<p class=\"tableblock\">" + (cell_content.$join("" + "</p>\n" + "<p class=\"tableblock\">")) + "</p>"
                  }; return nil; })()}
                };
                cell_tag_name = (function() {if ($truthy(($truthy($b = tsec['$==']("head")) ? $b : cell.$style()['$==']("header")))) {
                  return "th"
                } else {
                  return "td"
                }; return nil; })();
                cell_class_attribute = "" + " class=\"tableblock halign-" + (cell.$attr("halign")) + " valign-" + (cell.$attr("valign")) + "\"";
                cell_colspan_attribute = (function() {if ($truthy(cell.$colspan())) {
                  return "" + " colspan=\"" + (cell.$colspan()) + "\""
                } else {
                  return ""
                }; return nil; })();
                cell_rowspan_attribute = (function() {if ($truthy(cell.$rowspan())) {
                  return "" + " rowspan=\"" + (cell.$rowspan()) + "\""
                } else {
                  return ""
                }; return nil; })();
                cell_style_attribute = (function() {if ($truthy(node.$document()['$attr?']("cellbgcolor"))) {
                  return "" + " style=\"background-color: " + (node.$document().$attr("cellbgcolor")) + ";\""
                } else {
                  return ""
                }; return nil; })();
                return result['$<<']("" + "<" + (cell_tag_name) + (cell_class_attribute) + (cell_colspan_attribute) + (cell_rowspan_attribute) + (cell_style_attribute) + ">" + (cell_content) + "</" + (cell_tag_name) + ">");}, TMP_42.$$s = self, TMP_42.$$arity = 1, TMP_42));
              return result['$<<']("</tr>");}, TMP_41.$$s = self, TMP_41.$$arity = 1, TMP_41));
            return result['$<<']("" + "</t" + (tsec) + ">");}, TMP_40.$$s = self, TMP_40.$$arity = 2, TMP_40));};
        result['$<<']("</table>");
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_table_38.$$arity = 1);
      
      Opal.def(self, '$toc', TMP_Html5Converter_toc_43 = function $$toc(node) {
        var $a, $b, self = this, doc = nil, id_attr = nil, title_id_attr = nil, title = nil, levels = nil, role = nil;

        
        if ($truthy(($truthy($a = ($truthy($b = (doc = node.$document())['$attr?']("toc-placement", "macro")) ? doc['$sections?']() : $b)) ? doc['$attr?']("toc") : $a))) {
        } else {
          return "<!-- toc disabled -->"
        };
        if ($truthy(node.$id())) {
          
          id_attr = "" + " id=\"" + (node.$id()) + "\"";
          title_id_attr = "" + " id=\"" + (node.$id()) + "title\"";
        } else {
          
          id_attr = " id=\"toc\"";
          title_id_attr = " id=\"toctitle\"";
        };
        title = (function() {if ($truthy(node['$title?']())) {
          return node.$title()
        } else {
          
          return doc.$attr("toc-title");
        }; return nil; })();
        levels = (function() {if ($truthy(node['$attr?']("levels"))) {
          return node.$attr("levels").$to_i()
        } else {
          return nil
        }; return nil; })();
        role = (function() {if ($truthy(node['$role?']())) {
          return node.$role()
        } else {
          
          return doc.$attr("toc-class", "toc");
        }; return nil; })();
        return "" + "<div" + (id_attr) + " class=\"" + (role) + "\">\n" + "<div" + (title_id_attr) + " class=\"title\">" + (title) + "</div>\n" + (self.$outline(doc, $hash2(["toclevels"], {"toclevels": levels}))) + "\n" + "</div>";
      }, TMP_Html5Converter_toc_43.$$arity = 1);
      
      Opal.def(self, '$ulist', TMP_Html5Converter_ulist_44 = function $$ulist(node) {
        var TMP_45, self = this, result = nil, id_attribute = nil, div_classes = nil, marker_checked = nil, marker_unchecked = nil, checklist = nil, ul_class_attribute = nil;

        
        result = [];
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        div_classes = ["ulist", node.$style(), node.$role()].$compact();
        marker_checked = (marker_unchecked = "");
        if ($truthy((checklist = node['$option?']("checklist")))) {
          
          div_classes.$unshift(div_classes.$shift(), "checklist");
          ul_class_attribute = " class=\"checklist\"";
          if ($truthy(node['$option?']("interactive"))) {
            if ($truthy(self.xml_mode)) {
              
              marker_checked = "<input type=\"checkbox\" data-item-complete=\"1\" checked=\"checked\"/> ";
              marker_unchecked = "<input type=\"checkbox\" data-item-complete=\"0\"/> ";
            } else {
              
              marker_checked = "<input type=\"checkbox\" data-item-complete=\"1\" checked> ";
              marker_unchecked = "<input type=\"checkbox\" data-item-complete=\"0\"> ";
            }
          } else if ($truthy(node.$document()['$attr?']("icons", "font"))) {
            
            marker_checked = "<i class=\"fa fa-check-square-o\"></i> ";
            marker_unchecked = "<i class=\"fa fa-square-o\"></i> ";
          } else {
            
            marker_checked = "&#10003; ";
            marker_unchecked = "&#10063; ";
          };
        } else {
          ul_class_attribute = (function() {if ($truthy(node.$style())) {
            return "" + " class=\"" + (node.$style()) + "\""
          } else {
            return ""
          }; return nil; })()
        };
        result['$<<']("" + "<div" + (id_attribute) + " class=\"" + (div_classes.$join(" ")) + "\">");
        if ($truthy(node['$title?']())) {
          result['$<<']("" + "<div class=\"title\">" + (node.$title()) + "</div>")};
        result['$<<']("" + "<ul" + (ul_class_attribute) + ">");
        $send(node.$items(), 'each', [], (TMP_45 = function(item){var self = TMP_45.$$s || this, $a;

        
          
          if (item == null) {
            item = nil;
          };
          result['$<<']("<li>");
          if ($truthy(($truthy($a = checklist) ? item['$attr?']("checkbox") : $a))) {
            result['$<<']("" + "<p>" + ((function() {if ($truthy(item['$attr?']("checked"))) {
              return marker_checked
            } else {
              return marker_unchecked
            }; return nil; })()) + (item.$text()) + "</p>")
          } else {
            result['$<<']("" + "<p>" + (item.$text()) + "</p>")
          };
          if ($truthy(item['$blocks?']())) {
            result['$<<'](item.$content())};
          return result['$<<']("</li>");}, TMP_45.$$s = self, TMP_45.$$arity = 1, TMP_45));
        result['$<<']("</ul>");
        result['$<<']("</div>");
        return result.$join($$($nesting, 'LF'));
      }, TMP_Html5Converter_ulist_44.$$arity = 1);
      
      Opal.def(self, '$verse', TMP_Html5Converter_verse_46 = function $$verse(node) {
        var $a, self = this, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, attribution = nil, citetitle = nil, cite_element = nil, attribution_text = nil, attribution_element = nil;

        
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["verseblock", node.$role()].$compact();
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        attribution = (function() {if ($truthy(node['$attr?']("attribution"))) {
          
          return node.$attr("attribution");
        } else {
          return nil
        }; return nil; })();
        citetitle = (function() {if ($truthy(node['$attr?']("citetitle"))) {
          
          return node.$attr("citetitle");
        } else {
          return nil
        }; return nil; })();
        if ($truthy(($truthy($a = attribution) ? $a : citetitle))) {
          
          cite_element = (function() {if ($truthy(citetitle)) {
            return "" + "<cite>" + (citetitle) + "</cite>"
          } else {
            return ""
          }; return nil; })();
          attribution_text = (function() {if ($truthy(attribution)) {
            return "" + "&#8212; " + (attribution) + ((function() {if ($truthy(citetitle)) {
              return "" + "<br" + (self.void_element_slash) + ">\n"
            } else {
              return ""
            }; return nil; })())
          } else {
            return ""
          }; return nil; })();
          attribution_element = "" + "\n<div class=\"attribution\">\n" + (attribution_text) + (cite_element) + "\n</div>";
        } else {
          attribution_element = ""
        };
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<pre class=\"content\">" + (node.$content()) + "</pre>" + (attribution_element) + "\n" + "</div>";
      }, TMP_Html5Converter_verse_46.$$arity = 1);
      
      Opal.def(self, '$video', TMP_Html5Converter_video_47 = function $$video(node) {
        var $a, $b, self = this, xml = nil, id_attribute = nil, classes = nil, class_attribute = nil, title_element = nil, width_attribute = nil, height_attribute = nil, $case = nil, asset_uri_scheme = nil, start_anchor = nil, delimiter = nil, autoplay_param = nil, loop_param = nil, rel_param_val = nil, start_param = nil, end_param = nil, has_loop_param = nil, controls_param = nil, fs_param = nil, fs_attribute = nil, modest_param = nil, theme_param = nil, hl_param = nil, target = nil, list = nil, list_param = nil, playlist = nil, poster_attribute = nil, val = nil, preload_attribute = nil, start_t = nil, end_t = nil, time_anchor = nil;

        
        xml = self.xml_mode;
        id_attribute = (function() {if ($truthy(node.$id())) {
          return "" + " id=\"" + (node.$id()) + "\""
        } else {
          return ""
        }; return nil; })();
        classes = ["videoblock"];
        if ($truthy(node['$attr?']("float"))) {
          classes['$<<'](node.$attr("float"))};
        if ($truthy(node['$attr?']("align"))) {
          classes['$<<']("" + "text-" + (node.$attr("align")))};
        if ($truthy(node.$role())) {
          classes['$<<'](node.$role())};
        class_attribute = "" + " class=\"" + (classes.$join(" ")) + "\"";
        title_element = (function() {if ($truthy(node['$title?']())) {
          return "" + "\n<div class=\"title\">" + (node.$title()) + "</div>"
        } else {
          return ""
        }; return nil; })();
        width_attribute = (function() {if ($truthy(node['$attr?']("width"))) {
          return "" + " width=\"" + (node.$attr("width")) + "\""
        } else {
          return ""
        }; return nil; })();
        height_attribute = (function() {if ($truthy(node['$attr?']("height"))) {
          return "" + " height=\"" + (node.$attr("height")) + "\""
        } else {
          return ""
        }; return nil; })();
        return (function() {$case = node.$attr("poster");
        if ("vimeo"['$===']($case)) {
        if ($truthy((asset_uri_scheme = node.$document().$attr("asset-uri-scheme", "https"))['$empty?']())) {
        } else {
          asset_uri_scheme = "" + (asset_uri_scheme) + ":"
        };
        start_anchor = (function() {if ($truthy(node['$attr?']("start", nil, false))) {
          return "" + "#at=" + (node.$attr("start"))
        } else {
          return ""
        }; return nil; })();
        delimiter = "?";
        if ($truthy(node['$option?']("autoplay"))) {
          
          autoplay_param = "" + (delimiter) + "autoplay=1";
          delimiter = "&amp;";
        } else {
          autoplay_param = ""
        };
        loop_param = (function() {if ($truthy(node['$option?']("loop"))) {
          return "" + (delimiter) + "loop=1"
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<div class=\"content\">\n" + "<iframe" + (width_attribute) + (height_attribute) + " src=\"" + (asset_uri_scheme) + "//player.vimeo.com/video/" + (node.$attr("target")) + (start_anchor) + (autoplay_param) + (loop_param) + "\" frameborder=\"0\"" + ((function() {if ($truthy(node['$option?']("nofullscreen"))) {
          return ""
        } else {
          
          return self.$append_boolean_attribute("allowfullscreen", xml);
        }; return nil; })()) + "></iframe>\n" + "</div>\n" + "</div>";}
        else if ("youtube"['$===']($case)) {
        if ($truthy((asset_uri_scheme = node.$document().$attr("asset-uri-scheme", "https"))['$empty?']())) {
        } else {
          asset_uri_scheme = "" + (asset_uri_scheme) + ":"
        };
        rel_param_val = (function() {if ($truthy(node['$option?']("related"))) {
          return 1
        } else {
          return 0
        }; return nil; })();
        start_param = (function() {if ($truthy(node['$attr?']("start", nil, false))) {
          return "" + "&amp;start=" + (node.$attr("start"))
        } else {
          return ""
        }; return nil; })();
        end_param = (function() {if ($truthy(node['$attr?']("end", nil, false))) {
          return "" + "&amp;end=" + (node.$attr("end"))
        } else {
          return ""
        }; return nil; })();
        autoplay_param = (function() {if ($truthy(node['$option?']("autoplay"))) {
          return "&amp;autoplay=1"
        } else {
          return ""
        }; return nil; })();
        loop_param = (function() {if ($truthy((has_loop_param = node['$option?']("loop")))) {
          return "&amp;loop=1"
        } else {
          return ""
        }; return nil; })();
        controls_param = (function() {if ($truthy(node['$option?']("nocontrols"))) {
          return "&amp;controls=0"
        } else {
          return ""
        }; return nil; })();
        if ($truthy(node['$option?']("nofullscreen"))) {
          
          fs_param = "&amp;fs=0";
          fs_attribute = "";
        } else {
          
          fs_param = "";
          fs_attribute = self.$append_boolean_attribute("allowfullscreen", xml);
        };
        modest_param = (function() {if ($truthy(node['$option?']("modest"))) {
          return "&amp;modestbranding=1"
        } else {
          return ""
        }; return nil; })();
        theme_param = (function() {if ($truthy(node['$attr?']("theme", nil, false))) {
          return "" + "&amp;theme=" + (node.$attr("theme"))
        } else {
          return ""
        }; return nil; })();
        hl_param = (function() {if ($truthy(node['$attr?']("lang"))) {
          return "" + "&amp;hl=" + (node.$attr("lang"))
        } else {
          return ""
        }; return nil; })();
        $b = node.$attr("target").$split("/", 2), $a = Opal.to_ary($b), (target = ($a[0] == null ? nil : $a[0])), (list = ($a[1] == null ? nil : $a[1])), $b;
        if ($truthy((list = ($truthy($a = list) ? $a : node.$attr("list", nil, false))))) {
          list_param = "" + "&amp;list=" + (list)
        } else {
          
          $b = target.$split(",", 2), $a = Opal.to_ary($b), (target = ($a[0] == null ? nil : $a[0])), (playlist = ($a[1] == null ? nil : $a[1])), $b;
          if ($truthy((playlist = ($truthy($a = playlist) ? $a : node.$attr("playlist", nil, false))))) {
            list_param = "" + "&amp;playlist=" + (playlist)
          } else {
            list_param = (function() {if ($truthy(has_loop_param)) {
              return "" + "&amp;playlist=" + (target)
            } else {
              return ""
            }; return nil; })()
          };
        };
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<div class=\"content\">\n" + "<iframe" + (width_attribute) + (height_attribute) + " src=\"" + (asset_uri_scheme) + "//www.youtube.com/embed/" + (target) + "?rel=" + (rel_param_val) + (start_param) + (end_param) + (autoplay_param) + (loop_param) + (controls_param) + (list_param) + (fs_param) + (modest_param) + (theme_param) + (hl_param) + "\" frameborder=\"0\"" + (fs_attribute) + "></iframe>\n" + "</div>\n" + "</div>";}
        else {
        poster_attribute = (function() {if ($truthy((val = node.$attr("poster", nil, false))['$nil_or_empty?']())) {
          return ""
        } else {
          return "" + " poster=\"" + (node.$media_uri(val)) + "\""
        }; return nil; })();
        preload_attribute = (function() {if ($truthy((val = node.$attr("preload", nil, false))['$nil_or_empty?']())) {
          return ""
        } else {
          return "" + " preload=\"" + (val) + "\""
        }; return nil; })();
        start_t = node.$attr("start", nil, false);
        end_t = node.$attr("end", nil, false);
        time_anchor = (function() {if ($truthy(($truthy($a = start_t) ? $a : end_t))) {
          return "" + "#t=" + (($truthy($a = start_t) ? $a : "")) + ((function() {if ($truthy(end_t)) {
            return "" + "," + (end_t)
          } else {
            return ""
          }; return nil; })())
        } else {
          return ""
        }; return nil; })();
        return "" + "<div" + (id_attribute) + (class_attribute) + ">" + (title_element) + "\n" + "<div class=\"content\">\n" + "<video src=\"" + (node.$media_uri(node.$attr("target"))) + (time_anchor) + "\"" + (width_attribute) + (height_attribute) + (poster_attribute) + ((function() {if ($truthy(node['$option?']("autoplay"))) {
          
          return self.$append_boolean_attribute("autoplay", xml);
        } else {
          return ""
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("nocontrols"))) {
          return ""
        } else {
          
          return self.$append_boolean_attribute("controls", xml);
        }; return nil; })()) + ((function() {if ($truthy(node['$option?']("loop"))) {
          
          return self.$append_boolean_attribute("loop", xml);
        } else {
          return ""
        }; return nil; })()) + (preload_attribute) + ">\n" + "Your browser does not support the video tag.\n" + "</video>\n" + "</div>\n" + "</div>";}})();
      }, TMP_Html5Converter_video_47.$$arity = 1);
      
      Opal.def(self, '$inline_anchor', TMP_Html5Converter_inline_anchor_48 = function $$inline_anchor(node) {
        var $a, self = this, $case = nil, path = nil, attrs = nil, text = nil, refid = nil, ref = nil;

        return (function() {$case = node.$type();
        if ("xref"['$===']($case)) {
        if ($truthy((path = node.$attributes()['$[]']("path")))) {
          
          attrs = self.$append_link_constraint_attrs(node, (function() {if ($truthy(node.$role())) {
            return ["" + " class=\"" + (node.$role()) + "\""]
          } else {
            return []
          }; return nil; })()).$join();
          text = ($truthy($a = node.$text()) ? $a : path);
        } else {
          
          attrs = (function() {if ($truthy(node.$role())) {
            return "" + " class=\"" + (node.$role()) + "\""
          } else {
            return ""
          }; return nil; })();
          if ($truthy((text = node.$text()))) {
          } else {
            
            refid = node.$attributes()['$[]']("refid");
            if ($truthy($$($nesting, 'AbstractNode')['$===']((ref = (self.refs = ($truthy($a = self.refs) ? $a : node.$document().$catalog()['$[]']("refs")))['$[]'](refid))))) {
              text = ($truthy($a = ref.$xreftext(node.$attr("xrefstyle"))) ? $a : "" + "[" + (refid) + "]")
            } else {
              text = "" + "[" + (refid) + "]"
            };
          };
        };
        return "" + "<a href=\"" + (node.$target()) + "\"" + (attrs) + ">" + (text) + "</a>";}
        else if ("ref"['$===']($case)) {return "" + "<a id=\"" + (node.$id()) + "\"></a>"}
        else if ("link"['$===']($case)) {
        attrs = (function() {if ($truthy(node.$id())) {
          return ["" + " id=\"" + (node.$id()) + "\""]
        } else {
          return []
        }; return nil; })();
        if ($truthy(node.$role())) {
          attrs['$<<']("" + " class=\"" + (node.$role()) + "\"")};
        if ($truthy(node['$attr?']("title", nil, false))) {
          attrs['$<<']("" + " title=\"" + (node.$attr("title")) + "\"")};
        return "" + "<a href=\"" + (node.$target()) + "\"" + (self.$append_link_constraint_attrs(node, attrs).$join()) + ">" + (node.$text()) + "</a>";}
        else if ("bibref"['$===']($case)) {return "" + "<a id=\"" + (node.$id()) + "\"></a>" + (node.$text())}
        else {
        self.$logger().$warn("" + "unknown anchor type: " + (node.$type().$inspect()));
        return nil;}})()
      }, TMP_Html5Converter_inline_anchor_48.$$arity = 1);
      
      Opal.def(self, '$inline_break', TMP_Html5Converter_inline_break_49 = function $$inline_break(node) {
        var self = this;

        return "" + (node.$text()) + "<br" + (self.void_element_slash) + ">"
      }, TMP_Html5Converter_inline_break_49.$$arity = 1);
      
      Opal.def(self, '$inline_button', TMP_Html5Converter_inline_button_50 = function $$inline_button(node) {
        var self = this;

        return "" + "<b class=\"button\">" + (node.$text()) + "</b>"
      }, TMP_Html5Converter_inline_button_50.$$arity = 1);
      
      Opal.def(self, '$inline_callout', TMP_Html5Converter_inline_callout_51 = function $$inline_callout(node) {
        var self = this, src = nil;

        if ($truthy(node.$document()['$attr?']("icons", "font"))) {
          return "" + "<i class=\"conum\" data-value=\"" + (node.$text()) + "\"></i><b>(" + (node.$text()) + ")</b>"
        } else if ($truthy(node.$document()['$attr?']("icons"))) {
          
          src = node.$icon_uri("" + "callouts/" + (node.$text()));
          return "" + "<img src=\"" + (src) + "\" alt=\"" + (node.$text()) + "\"" + (self.void_element_slash) + ">";
        } else {
          return "" + (node.$attributes()['$[]']("guard")) + "<b class=\"conum\">(" + (node.$text()) + ")</b>"
        }
      }, TMP_Html5Converter_inline_callout_51.$$arity = 1);
      
      Opal.def(self, '$inline_footnote', TMP_Html5Converter_inline_footnote_52 = function $$inline_footnote(node) {
        var self = this, index = nil, id_attr = nil;

        if ($truthy((index = node.$attr("index", nil, false)))) {
          if (node.$type()['$==']("xref")) {
            return "" + "<sup class=\"footnoteref\">[<a class=\"footnote\" href=\"#_footnotedef_" + (index) + "\" title=\"View footnote.\">" + (index) + "</a>]</sup>"
          } else {
            
            id_attr = (function() {if ($truthy(node.$id())) {
              return "" + " id=\"_footnote_" + (node.$id()) + "\""
            } else {
              return ""
            }; return nil; })();
            return "" + "<sup class=\"footnote\"" + (id_attr) + ">[<a id=\"_footnoteref_" + (index) + "\" class=\"footnote\" href=\"#_footnotedef_" + (index) + "\" title=\"View footnote.\">" + (index) + "</a>]</sup>";
          }
        } else if (node.$type()['$==']("xref")) {
          return "" + "<sup class=\"footnoteref red\" title=\"Unresolved footnote reference.\">[" + (node.$text()) + "]</sup>"
        } else {
          return nil
        }
      }, TMP_Html5Converter_inline_footnote_52.$$arity = 1);
      
      Opal.def(self, '$inline_image', TMP_Html5Converter_inline_image_53 = function $$inline_image(node) {
        var $a, TMP_54, TMP_55, $b, $c, $d, self = this, type = nil, class_attr_val = nil, title_attr = nil, img = nil, target = nil, attrs = nil, svg = nil, obj = nil, fallback = nil, role = nil;

        
        if ($truthy((($a = (type = node.$type())['$==']("icon")) ? node.$document()['$attr?']("icons", "font") : (type = node.$type())['$==']("icon")))) {
          
          class_attr_val = "" + "fa fa-" + (node.$target());
          $send($hash2(["size", "rotate", "flip"], {"size": "fa-", "rotate": "fa-rotate-", "flip": "fa-flip-"}), 'each', [], (TMP_54 = function(key, prefix){var self = TMP_54.$$s || this;

          
            
            if (key == null) {
              key = nil;
            };
            
            if (prefix == null) {
              prefix = nil;
            };
            if ($truthy(node['$attr?'](key))) {
              return (class_attr_val = "" + (class_attr_val) + " " + (prefix) + (node.$attr(key)))
            } else {
              return nil
            };}, TMP_54.$$s = self, TMP_54.$$arity = 2, TMP_54));
          title_attr = (function() {if ($truthy(node['$attr?']("title"))) {
            return "" + " title=\"" + (node.$attr("title")) + "\""
          } else {
            return ""
          }; return nil; })();
          img = "" + "<i class=\"" + (class_attr_val) + "\"" + (title_attr) + "></i>";
        } else if ($truthy((($a = type['$==']("icon")) ? node.$document()['$attr?']("icons")['$!']() : type['$==']("icon")))) {
          img = "" + "[" + (node.$alt()) + "]"
        } else {
          
          target = node.$target();
          attrs = $send(["width", "height", "title"], 'map', [], (TMP_55 = function(name){var self = TMP_55.$$s || this;

          
            
            if (name == null) {
              name = nil;
            };
            if ($truthy(node['$attr?'](name))) {
              return "" + " " + (name) + "=\"" + (node.$attr(name)) + "\""
            } else {
              return ""
            };}, TMP_55.$$s = self, TMP_55.$$arity = 1, TMP_55)).$join();
          if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = type['$!=']("icon")) ? ($truthy($d = node['$attr?']("format", "svg", false)) ? $d : target['$include?'](".svg")) : $c)) ? $rb_lt(node.$document().$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')) : $b)) ? ($truthy($b = (svg = node['$option?']("inline"))) ? $b : (obj = node['$option?']("interactive"))) : $a))) {
            if ($truthy(svg)) {
              img = ($truthy($a = self.$read_svg_contents(node, target)) ? $a : "" + "<span class=\"alt\">" + (node.$alt()) + "</span>")
            } else if ($truthy(obj)) {
              
              fallback = (function() {if ($truthy(node['$attr?']("fallback"))) {
                return "" + "<img src=\"" + (node.$image_uri(node.$attr("fallback"))) + "\" alt=\"" + (self.$encode_quotes(node.$alt())) + "\"" + (attrs) + (self.void_element_slash) + ">"
              } else {
                return "" + "<span class=\"alt\">" + (node.$alt()) + "</span>"
              }; return nil; })();
              img = "" + "<object type=\"image/svg+xml\" data=\"" + (node.$image_uri(target)) + "\"" + (attrs) + ">" + (fallback) + "</object>";}};
          img = ($truthy($a = img) ? $a : "" + "<img src=\"" + ((function() {if (type['$==']("icon")) {
            
            return node.$icon_uri(target);
          } else {
            
            return node.$image_uri(target);
          }; return nil; })()) + "\" alt=\"" + (self.$encode_quotes(node.$alt())) + "\"" + (attrs) + (self.void_element_slash) + ">");
        };
        if ($truthy(node['$attr?']("link", nil, false))) {
          img = "" + "<a class=\"image\" href=\"" + (node.$attr("link")) + "\"" + (self.$append_link_constraint_attrs(node).$join()) + ">" + (img) + "</a>"};
        if ($truthy((role = node.$role()))) {
          if ($truthy(node['$attr?']("float"))) {
            class_attr_val = "" + (type) + " " + (node.$attr("float")) + " " + (role)
          } else {
            class_attr_val = "" + (type) + " " + (role)
          }
        } else if ($truthy(node['$attr?']("float"))) {
          class_attr_val = "" + (type) + " " + (node.$attr("float"))
        } else {
          class_attr_val = type
        };
        return "" + "<span class=\"" + (class_attr_val) + "\">" + (img) + "</span>";
      }, TMP_Html5Converter_inline_image_53.$$arity = 1);
      
      Opal.def(self, '$inline_indexterm', TMP_Html5Converter_inline_indexterm_56 = function $$inline_indexterm(node) {
        var self = this;

        if (node.$type()['$==']("visible")) {
          return node.$text()
        } else {
          return ""
        }
      }, TMP_Html5Converter_inline_indexterm_56.$$arity = 1);
      
      Opal.def(self, '$inline_kbd', TMP_Html5Converter_inline_kbd_57 = function $$inline_kbd(node) {
        var self = this, keys = nil;

        if ((keys = node.$attr("keys")).$size()['$=='](1)) {
          return "" + "<kbd>" + (keys['$[]'](0)) + "</kbd>"
        } else {
          return "" + "<span class=\"keyseq\"><kbd>" + (keys.$join("</kbd>+<kbd>")) + "</kbd></span>"
        }
      }, TMP_Html5Converter_inline_kbd_57.$$arity = 1);
      
      Opal.def(self, '$inline_menu', TMP_Html5Converter_inline_menu_58 = function $$inline_menu(node) {
        var self = this, caret = nil, submenu_joiner = nil, menu = nil, submenus = nil, menuitem = nil;

        
        caret = (function() {if ($truthy(node.$document()['$attr?']("icons", "font"))) {
          return "&#160;<i class=\"fa fa-angle-right caret\"></i> "
        } else {
          return "&#160;<b class=\"caret\">&#8250;</b> "
        }; return nil; })();
        submenu_joiner = "" + "</b>" + (caret) + "<b class=\"submenu\">";
        menu = node.$attr("menu");
        if ($truthy((submenus = node.$attr("submenus"))['$empty?']())) {
          if ($truthy((menuitem = node.$attr("menuitem", nil, false)))) {
            return "" + "<span class=\"menuseq\"><b class=\"menu\">" + (menu) + "</b>" + (caret) + "<b class=\"menuitem\">" + (menuitem) + "</b></span>"
          } else {
            return "" + "<b class=\"menuref\">" + (menu) + "</b>"
          }
        } else {
          return "" + "<span class=\"menuseq\"><b class=\"menu\">" + (menu) + "</b>" + (caret) + "<b class=\"submenu\">" + (submenus.$join(submenu_joiner)) + "</b>" + (caret) + "<b class=\"menuitem\">" + (node.$attr("menuitem")) + "</b></span>"
        };
      }, TMP_Html5Converter_inline_menu_58.$$arity = 1);
      
      Opal.def(self, '$inline_quoted', TMP_Html5Converter_inline_quoted_59 = function $$inline_quoted(node) {
        var $a, $b, self = this, open = nil, close = nil, is_tag = nil, class_attr = nil, id_attr = nil;

        
        $b = $$($nesting, 'QUOTE_TAGS')['$[]'](node.$type()), $a = Opal.to_ary($b), (open = ($a[0] == null ? nil : $a[0])), (close = ($a[1] == null ? nil : $a[1])), (is_tag = ($a[2] == null ? nil : $a[2])), $b;
        if ($truthy(node.$role())) {
          class_attr = "" + " class=\"" + (node.$role()) + "\""};
        if ($truthy(node.$id())) {
          id_attr = "" + " id=\"" + (node.$id()) + "\""};
        if ($truthy(($truthy($a = class_attr) ? $a : id_attr))) {
          if ($truthy(is_tag)) {
            return "" + (open.$chop()) + (($truthy($a = id_attr) ? $a : "")) + (($truthy($a = class_attr) ? $a : "")) + ">" + (node.$text()) + (close)
          } else {
            return "" + "<span" + (($truthy($a = id_attr) ? $a : "")) + (($truthy($a = class_attr) ? $a : "")) + ">" + (open) + (node.$text()) + (close) + "</span>"
          }
        } else {
          return "" + (open) + (node.$text()) + (close)
        };
      }, TMP_Html5Converter_inline_quoted_59.$$arity = 1);
      
      Opal.def(self, '$append_boolean_attribute', TMP_Html5Converter_append_boolean_attribute_60 = function $$append_boolean_attribute(name, xml) {
        var self = this;

        if ($truthy(xml)) {
          return "" + " " + (name) + "=\"" + (name) + "\""
        } else {
          return "" + " " + (name)
        }
      }, TMP_Html5Converter_append_boolean_attribute_60.$$arity = 2);
      
      Opal.def(self, '$encode_quotes', TMP_Html5Converter_encode_quotes_61 = function $$encode_quotes(val) {
        var self = this;

        if ($truthy(val['$include?']("\""))) {
          
          return val.$gsub("\"", "&quot;");
        } else {
          return val
        }
      }, TMP_Html5Converter_encode_quotes_61.$$arity = 1);
      
      Opal.def(self, '$generate_manname_section', TMP_Html5Converter_generate_manname_section_62 = function $$generate_manname_section(node) {
        var $a, self = this, manname_title = nil, next_section = nil, next_section_title = nil, manname_id_attr = nil, manname_id = nil;

        
        manname_title = node.$attr("manname-title", "Name");
        if ($truthy(($truthy($a = (next_section = node.$sections()['$[]'](0))) ? (next_section_title = next_section.$title())['$=='](next_section_title.$upcase()) : $a))) {
          manname_title = manname_title.$upcase()};
        manname_id_attr = (function() {if ($truthy((manname_id = node.$attr("manname-id")))) {
          return "" + " id=\"" + (manname_id) + "\""
        } else {
          return ""
        }; return nil; })();
        return "" + "<h2" + (manname_id_attr) + ">" + (manname_title) + "</h2>\n" + "<div class=\"sectionbody\">\n" + "<p>" + (node.$attr("manname")) + " - " + (node.$attr("manpurpose")) + "</p>\n" + "</div>";
      }, TMP_Html5Converter_generate_manname_section_62.$$arity = 1);
      
      Opal.def(self, '$append_link_constraint_attrs', TMP_Html5Converter_append_link_constraint_attrs_63 = function $$append_link_constraint_attrs(node, attrs) {
        var $a, self = this, rel = nil, window = nil;

        
        
        if (attrs == null) {
          attrs = [];
        };
        if ($truthy(node['$option?']("nofollow"))) {
          rel = "nofollow"};
        if ($truthy((window = node.$attributes()['$[]']("window")))) {
          
          attrs['$<<']("" + " target=\"" + (window) + "\"");
          if ($truthy(($truthy($a = window['$==']("_blank")) ? $a : node['$option?']("noopener")))) {
            attrs['$<<']((function() {if ($truthy(rel)) {
              return "" + " rel=\"" + (rel) + " noopener\""
            } else {
              return " rel=\"noopener\""
            }; return nil; })())};
        } else if ($truthy(rel)) {
          attrs['$<<']("" + " rel=\"" + (rel) + "\"")};
        return attrs;
      }, TMP_Html5Converter_append_link_constraint_attrs_63.$$arity = -2);
      return (Opal.def(self, '$read_svg_contents', TMP_Html5Converter_read_svg_contents_64 = function $$read_svg_contents(node, target) {
        var TMP_65, self = this, svg = nil, old_start_tag = nil, new_start_tag = nil;

        
        if ($truthy((svg = node.$read_contents(target, $hash2(["start", "normalize", "label"], {"start": node.$document().$attr("imagesdir"), "normalize": true, "label": "SVG"}))))) {
          
          if ($truthy(svg['$start_with?']("<svg"))) {
          } else {
            svg = svg.$sub($$($nesting, 'SvgPreambleRx'), "")
          };
          old_start_tag = (new_start_tag = nil);
          $send(["width", "height"], 'each', [], (TMP_65 = function(dim){var self = TMP_65.$$s || this;

          
            
            if (dim == null) {
              dim = nil;
            };
            if ($truthy(node['$attr?'](dim))) {
              
              if ($truthy(new_start_tag)) {
              } else {
                new_start_tag = (old_start_tag = svg.$match($$($nesting, 'SvgStartTagRx'))['$[]'](0)).$gsub($$($nesting, 'DimensionAttributeRx'), "")
              };
              return (new_start_tag = "" + (new_start_tag.$chop()) + " " + (dim) + "=\"" + (node.$attr(dim)) + "px\">");
            } else {
              return nil
            };}, TMP_65.$$s = self, TMP_65.$$arity = 1, TMP_65));
          if ($truthy(new_start_tag)) {
            svg = "" + (new_start_tag) + (svg['$[]'](Opal.Range.$new(old_start_tag.$length(), -1, false)))};};
        return svg;
      }, TMP_Html5Converter_read_svg_contents_64.$$arity = 2), nil) && 'read_svg_contents';
    })($$($nesting, 'Converter'), $$$($$($nesting, 'Converter'), 'BuiltIn'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/extensions"] = function(Opal) {
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_plus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs + rhs : lhs['$+'](rhs);
  }
  function $rb_gt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs > rhs : lhs['$>'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var $a, self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $truthy = Opal.truthy, $module = Opal.module, $klass = Opal.klass, $hash2 = Opal.hash2, $send = Opal.send, $hash = Opal.hash;

  Opal.add_stubs(['$require', '$to_s', '$[]=', '$config', '$-', '$nil_or_empty?', '$name', '$grep', '$constants', '$include', '$const_get', '$extend', '$attr_reader', '$merge', '$class', '$update', '$raise', '$document', '$==', '$doctype', '$[]', '$+', '$level', '$delete', '$>', '$casecmp', '$new', '$title=', '$sectname=', '$special=', '$fetch', '$numbered=', '$!', '$key?', '$attr?', '$special', '$numbered', '$generate_id', '$title', '$id=', '$update_attributes', '$tr', '$basename', '$create_block', '$assign_caption', '$===', '$next_block', '$dup', '$<<', '$has_more_lines?', '$each', '$define_method', '$unshift', '$shift', '$send', '$empty?', '$size', '$call', '$option', '$flatten', '$respond_to?', '$include?', '$split', '$to_i', '$compact', '$inspect', '$attr_accessor', '$to_set', '$match?', '$resolve_regexp', '$method', '$register', '$values', '$groups', '$arity', '$instance_exec', '$to_proc', '$activate', '$add_document_processor', '$any?', '$select', '$add_syntax_processor', '$to_sym', '$instance_variable_get', '$kind', '$private', '$join', '$map', '$capitalize', '$instance_variable_set', '$resolve_args', '$freeze', '$process_block_given?', '$source_location', '$resolve_class', '$<', '$update_config', '$push', '$as_symbol', '$name=', '$pop', '$-@', '$next_auto_id', '$generate_name', '$class_for_name', '$reduce', '$const_defined?']);
  
  if ($truthy((($a = $$($nesting, 'Asciidoctor', 'skip_raise')) ? 'constant' : nil))) {
  } else {
    self.$require("asciidoctor".$to_s())
  };
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $parent_nesting) {
      function $Extensions() {};
      var self = $Extensions = $module($base, 'Extensions', $Extensions);

      var def = self.prototype, $nesting = [self].concat($parent_nesting);

      
      (function($base, $super, $parent_nesting) {
        function $Processor(){};
        var self = $Processor = $klass($base, $super, 'Processor', $Processor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Processor_initialize_4, TMP_Processor_update_config_5, TMP_Processor_process_6, TMP_Processor_create_section_7, TMP_Processor_create_block_8, TMP_Processor_create_list_9, TMP_Processor_create_list_item_10, TMP_Processor_create_image_block_11, TMP_Processor_create_inline_12, TMP_Processor_parse_content_13, TMP_Processor_14;

        def.config = nil;
        
        (function(self, $parent_nesting) {
          var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_config_1, TMP_option_2, TMP_use_dsl_3;

          
          
          Opal.def(self, '$config', TMP_config_1 = function $$config() {
            var $a, self = this;
            if (self.config == null) self.config = nil;

            return (self.config = ($truthy($a = self.config) ? $a : $hash2([], {})))
          }, TMP_config_1.$$arity = 0);
          
          Opal.def(self, '$option', TMP_option_2 = function $$option(key, default_value) {
            var self = this, $writer = nil;

            
            $writer = [key, default_value];
            $send(self.$config(), '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];
          }, TMP_option_2.$$arity = 2);
          
          Opal.def(self, '$use_dsl', TMP_use_dsl_3 = function $$use_dsl() {
            var self = this;

            if ($truthy(self.$name()['$nil_or_empty?']())) {
              if ($truthy((Opal.Module.$$nesting = $nesting, self.$constants()).$grep("DSL"))) {
                return self.$include(self.$const_get("DSL"))
              } else {
                return nil
              }
            } else if ($truthy((Opal.Module.$$nesting = $nesting, self.$constants()).$grep("DSL"))) {
              return self.$extend(self.$const_get("DSL"))
            } else {
              return nil
            }
          }, TMP_use_dsl_3.$$arity = 0);
          Opal.alias(self, "extend_dsl", "use_dsl");
          return Opal.alias(self, "include_dsl", "use_dsl");
        })(Opal.get_singleton_class(self), $nesting);
        self.$attr_reader("config");
        
        Opal.def(self, '$initialize', TMP_Processor_initialize_4 = function $$initialize(config) {
          var self = this;

          
          
          if (config == null) {
            config = $hash2([], {});
          };
          return (self.config = self.$class().$config().$merge(config));
        }, TMP_Processor_initialize_4.$$arity = -1);
        
        Opal.def(self, '$update_config', TMP_Processor_update_config_5 = function $$update_config(config) {
          var self = this;

          return self.config.$update(config)
        }, TMP_Processor_update_config_5.$$arity = 1);
        
        Opal.def(self, '$process', TMP_Processor_process_6 = function $$process($a) {
          var $post_args, args, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::Processor subclass must implement #" + ("process") + " method");
        }, TMP_Processor_process_6.$$arity = -1);
        
        Opal.def(self, '$create_section', TMP_Processor_create_section_7 = function $$create_section(parent, title, attrs, opts) {
          var $a, self = this, doc = nil, book = nil, doctype = nil, level = nil, style = nil, sectname = nil, special = nil, sect = nil, $writer = nil, id = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          doc = parent.$document();
          book = (doctype = doc.$doctype())['$==']("book");
          level = ($truthy($a = opts['$[]']("level")) ? $a : $rb_plus(parent.$level(), 1));
          if ($truthy((style = attrs.$delete("style")))) {
            if ($truthy(($truthy($a = book) ? style['$==']("abstract") : $a))) {
              $a = ["chapter", 1], (sectname = $a[0]), (level = $a[1]), $a
            } else {
              
              $a = [style, true], (sectname = $a[0]), (special = $a[1]), $a;
              if (level['$=='](0)) {
                level = 1};
            }
          } else if ($truthy(book)) {
            sectname = (function() {if (level['$=='](0)) {
              return "part"
            } else {
              
              if ($truthy($rb_gt(level, 1))) {
                return "section"
              } else {
                return "chapter"
              };
            }; return nil; })()
          } else if ($truthy((($a = doctype['$==']("manpage")) ? title.$casecmp("synopsis")['$=='](0) : doctype['$==']("manpage")))) {
            $a = ["synopsis", true], (sectname = $a[0]), (special = $a[1]), $a
          } else {
            sectname = "section"
          };
          sect = $$($nesting, 'Section').$new(parent, level);
          $a = [title, sectname], sect['$title=']($a[0]), sect['$sectname=']($a[1]), $a;
          if ($truthy(special)) {
            
            
            $writer = [true];
            $send(sect, 'special=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy(opts.$fetch("numbered", style['$==']("appendix")))) {
              
              $writer = [true];
              $send(sect, 'numbered=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else if ($truthy(($truthy($a = opts['$key?']("numbered")['$!']()) ? doc['$attr?']("sectnums", "all") : $a))) {
              
              $writer = [(function() {if ($truthy(($truthy($a = book) ? level['$=='](1) : $a))) {
                return "chapter"
              } else {
                return true
              }; return nil; })()];
              $send(sect, 'numbered=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];};
          } else if ($truthy($rb_gt(level, 0))) {
            if ($truthy(opts.$fetch("numbered", doc['$attr?']("sectnums")))) {
              
              $writer = [(function() {if ($truthy(sect.$special())) {
                return ($truthy($a = parent.$numbered()) ? true : $a)
              } else {
                return true
              }; return nil; })()];
              $send(sect, 'numbered=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];}
          } else if ($truthy(opts.$fetch("numbered", ($truthy($a = book) ? doc['$attr?']("partnums") : $a)))) {
            
            $writer = [true];
            $send(sect, 'numbered=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ((id = attrs.$delete("id"))['$=='](false)) {
          } else {
            
            $writer = [(($writer = ["id", ($truthy($a = id) ? $a : (function() {if ($truthy(doc['$attr?']("sectids"))) {
              
              return $$($nesting, 'Section').$generate_id(sect.$title(), doc);
            } else {
              return nil
            }; return nil; })())]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])];
            $send(sect, 'id=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];
          };
          sect.$update_attributes(attrs);
          return sect;
        }, TMP_Processor_create_section_7.$$arity = -4);
        
        Opal.def(self, '$create_block', TMP_Processor_create_block_8 = function $$create_block(parent, context, source, attrs, opts) {
          var self = this;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          return $$($nesting, 'Block').$new(parent, context, $hash2(["source", "attributes"], {"source": source, "attributes": attrs}).$merge(opts));
        }, TMP_Processor_create_block_8.$$arity = -5);
        
        Opal.def(self, '$create_list', TMP_Processor_create_list_9 = function $$create_list(parent, context, attrs) {
          var self = this, list = nil;

          
          
          if (attrs == null) {
            attrs = nil;
          };
          list = $$($nesting, 'List').$new(parent, context);
          if ($truthy(attrs)) {
            list.$update_attributes(attrs)};
          return list;
        }, TMP_Processor_create_list_9.$$arity = -3);
        
        Opal.def(self, '$create_list_item', TMP_Processor_create_list_item_10 = function $$create_list_item(parent, text) {
          var self = this;

          
          
          if (text == null) {
            text = nil;
          };
          return $$($nesting, 'ListItem').$new(parent, text);
        }, TMP_Processor_create_list_item_10.$$arity = -2);
        
        Opal.def(self, '$create_image_block', TMP_Processor_create_image_block_11 = function $$create_image_block(parent, attrs, opts) {
          var $a, self = this, target = nil, $writer = nil, title = nil, block = nil;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          if ($truthy((target = attrs['$[]']("target")))) {
          } else {
            self.$raise($$$('::', 'ArgumentError'), "Unable to create an image block, target attribute is required")
          };
          ($truthy($a = attrs['$[]']("alt")) ? $a : (($writer = ["alt", (($writer = ["default-alt", $$($nesting, 'Helpers').$basename(target, true).$tr("_-", " ")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)])]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
          title = (function() {if ($truthy(attrs['$key?']("title"))) {
            
            return attrs.$delete("title");
          } else {
            return nil
          }; return nil; })();
          block = self.$create_block(parent, "image", nil, attrs, opts);
          if ($truthy(title)) {
            
            
            $writer = [title];
            $send(block, 'title=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            block.$assign_caption(attrs.$delete("caption"), ($truthy($a = opts['$[]']("caption_context")) ? $a : "figure"));};
          return block;
        }, TMP_Processor_create_image_block_11.$$arity = -3);
        
        Opal.def(self, '$create_inline', TMP_Processor_create_inline_12 = function $$create_inline(parent, context, text, opts) {
          var self = this;

          
          
          if (opts == null) {
            opts = $hash2([], {});
          };
          return $$($nesting, 'Inline').$new(parent, context, text, opts);
        }, TMP_Processor_create_inline_12.$$arity = -4);
        
        Opal.def(self, '$parse_content', TMP_Processor_parse_content_13 = function $$parse_content(parent, content, attributes) {
          var $a, $b, $c, self = this, reader = nil, block = nil;

          
          
          if (attributes == null) {
            attributes = nil;
          };
          reader = (function() {if ($truthy($$($nesting, 'Reader')['$==='](content))) {
            return content
          } else {
            
            return $$($nesting, 'Reader').$new(content);
          }; return nil; })();
          while ($truthy(($truthy($b = ($truthy($c = (block = $$($nesting, 'Parser').$next_block(reader, parent, (function() {if ($truthy(attributes)) {
            return attributes.$dup()
          } else {
            return $hash2([], {})
          }; return nil; })()))) ? parent['$<<'](block) : $c)) ? $b : reader['$has_more_lines?']()))) {
            
          };
          return parent;
        }, TMP_Processor_parse_content_13.$$arity = -3);
        return $send([["create_paragraph", "create_block", "paragraph"], ["create_open_block", "create_block", "open"], ["create_example_block", "create_block", "example"], ["create_pass_block", "create_block", "pass"], ["create_listing_block", "create_block", "listing"], ["create_literal_block", "create_block", "literal"], ["create_anchor", "create_inline", "anchor"]], 'each', [], (TMP_Processor_14 = function(method_name, delegate_method_name, context){var self = TMP_Processor_14.$$s || this, TMP_15;

        
          
          if (method_name == null) {
            method_name = nil;
          };
          
          if (delegate_method_name == null) {
            delegate_method_name = nil;
          };
          
          if (context == null) {
            context = nil;
          };
          return $send(self, 'define_method', [method_name], (TMP_15 = function($a){var self = TMP_15.$$s || this, $post_args, args;

          
            
            $post_args = Opal.slice.call(arguments, 0, arguments.length);
            
            args = $post_args;;
            args.$unshift(args.$shift(), context);
            return $send(self, 'send', [delegate_method_name].concat(Opal.to_a(args)));}, TMP_15.$$s = self, TMP_15.$$arity = -1, TMP_15));}, TMP_Processor_14.$$s = self, TMP_Processor_14.$$arity = 3, TMP_Processor_14));
      })($nesting[0], null, $nesting);
      (function($base, $parent_nesting) {
        function $ProcessorDsl() {};
        var self = $ProcessorDsl = $module($base, 'ProcessorDsl', $ProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_ProcessorDsl_option_16, TMP_ProcessorDsl_process_17, TMP_ProcessorDsl_process_block_given$q_18;

        
        
        Opal.def(self, '$option', TMP_ProcessorDsl_option_16 = function $$option(key, value) {
          var self = this, $writer = nil;

          
          $writer = [key, value];
          $send(self.$config(), '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];
        }, TMP_ProcessorDsl_option_16.$$arity = 2);
        
        Opal.def(self, '$process', TMP_ProcessorDsl_process_17 = function $$process($a) {
          var $iter = TMP_ProcessorDsl_process_17.$$p, block = $iter || nil, $post_args, args, $b, self = this;
          if (self.process_block == null) self.process_block = nil;

          if ($iter) TMP_ProcessorDsl_process_17.$$p = null;
          
          
          if ($iter) TMP_ProcessorDsl_process_17.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          if ((block !== nil)) {
            
            if ($truthy(args['$empty?']())) {
            } else {
              self.$raise($$$('::', 'ArgumentError'), "" + "wrong number of arguments (given " + (args.$size()) + ", expected 0)")
            };
            return (self.process_block = block);
          } else if ($truthy((($b = self['process_block'], $b != null && $b !== nil) ? 'instance-variable' : nil))) {
            return $send(self.process_block, 'call', Opal.to_a(args))
          } else {
            return self.$raise($$$('::', 'NotImplementedError'))
          };
        }, TMP_ProcessorDsl_process_17.$$arity = -1);
        
        Opal.def(self, '$process_block_given?', TMP_ProcessorDsl_process_block_given$q_18 = function() {
          var $a, self = this;

          return (($a = self['process_block'], $a != null && $a !== nil) ? 'instance-variable' : nil)
        }, TMP_ProcessorDsl_process_block_given$q_18.$$arity = 0);
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        function $DocumentProcessorDsl() {};
        var self = $DocumentProcessorDsl = $module($base, 'DocumentProcessorDsl', $DocumentProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_DocumentProcessorDsl_prefer_19;

        
        self.$include($$($nesting, 'ProcessorDsl'));
        
        Opal.def(self, '$prefer', TMP_DocumentProcessorDsl_prefer_19 = function $$prefer() {
          var self = this;

          return self.$option("position", ">>")
        }, TMP_DocumentProcessorDsl_prefer_19.$$arity = 0);
      })($nesting[0], $nesting);
      (function($base, $parent_nesting) {
        function $SyntaxProcessorDsl() {};
        var self = $SyntaxProcessorDsl = $module($base, 'SyntaxProcessorDsl', $SyntaxProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_SyntaxProcessorDsl_named_20, TMP_SyntaxProcessorDsl_content_model_21, TMP_SyntaxProcessorDsl_positional_attrs_22, TMP_SyntaxProcessorDsl_default_attrs_23, TMP_SyntaxProcessorDsl_resolves_attributes_24;

        
        self.$include($$($nesting, 'ProcessorDsl'));
        
        Opal.def(self, '$named', TMP_SyntaxProcessorDsl_named_20 = function $$named(value) {
          var self = this;

          if ($truthy($$($nesting, 'Processor')['$==='](self))) {
            return (self.name = value)
          } else {
            return self.$option("name", value)
          }
        }, TMP_SyntaxProcessorDsl_named_20.$$arity = 1);
        Opal.alias(self, "match_name", "named");
        
        Opal.def(self, '$content_model', TMP_SyntaxProcessorDsl_content_model_21 = function $$content_model(value) {
          var self = this;

          return self.$option("content_model", value)
        }, TMP_SyntaxProcessorDsl_content_model_21.$$arity = 1);
        Opal.alias(self, "parse_content_as", "content_model");
        Opal.alias(self, "parses_content_as", "content_model");
        
        Opal.def(self, '$positional_attrs', TMP_SyntaxProcessorDsl_positional_attrs_22 = function $$positional_attrs($a) {
          var $post_args, value, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          value = $post_args;;
          return self.$option("pos_attrs", value.$flatten());
        }, TMP_SyntaxProcessorDsl_positional_attrs_22.$$arity = -1);
        Opal.alias(self, "name_attributes", "positional_attrs");
        Opal.alias(self, "name_positional_attributes", "positional_attrs");
        
        Opal.def(self, '$default_attrs', TMP_SyntaxProcessorDsl_default_attrs_23 = function $$default_attrs(value) {
          var self = this;

          return self.$option("default_attrs", value)
        }, TMP_SyntaxProcessorDsl_default_attrs_23.$$arity = 1);
        
        Opal.def(self, '$resolves_attributes', TMP_SyntaxProcessorDsl_resolves_attributes_24 = function $$resolves_attributes($a) {
          var $post_args, args, $b, TMP_25, TMP_26, self = this, $case = nil, names = nil, defaults = nil;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          if ($truthy($rb_gt(args.$size(), 1))) {
          } else if ($truthy((args = args.$fetch(0, true))['$respond_to?']("to_sym"))) {
            args = [args]};
          return (function() {$case = args;
          if (true['$===']($case)) {
          self.$option("pos_attrs", []);
          return self.$option("default_attrs", $hash2([], {}));}
          else if ($$$('::', 'Array')['$===']($case)) {
          $b = [[], $hash2([], {})], (names = $b[0]), (defaults = $b[1]), $b;
          $send(args, 'each', [], (TMP_25 = function(arg){var self = TMP_25.$$s || this, $c, $d, name = nil, value = nil, idx = nil, $writer = nil;

          
            
            if (arg == null) {
              arg = nil;
            };
            if ($truthy((arg = arg.$to_s())['$include?']("="))) {
              
              $d = arg.$split("=", 2), $c = Opal.to_ary($d), (name = ($c[0] == null ? nil : $c[0])), (value = ($c[1] == null ? nil : $c[1])), $d;
              if ($truthy(name['$include?'](":"))) {
                
                $d = name.$split(":", 2), $c = Opal.to_ary($d), (idx = ($c[0] == null ? nil : $c[0])), (name = ($c[1] == null ? nil : $c[1])), $d;
                idx = (function() {if (idx['$==']("@")) {
                  return names.$size()
                } else {
                  return idx.$to_i()
                }; return nil; })();
                
                $writer = [idx, name];
                $send(names, '[]=', Opal.to_a($writer));
                $writer[$rb_minus($writer["length"], 1)];;};
              
              $writer = [name, value];
              $send(defaults, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            } else if ($truthy(arg['$include?'](":"))) {
              
              $d = arg.$split(":", 2), $c = Opal.to_ary($d), (idx = ($c[0] == null ? nil : $c[0])), (name = ($c[1] == null ? nil : $c[1])), $d;
              idx = (function() {if (idx['$==']("@")) {
                return names.$size()
              } else {
                return idx.$to_i()
              }; return nil; })();
              
              $writer = [idx, name];
              $send(names, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            } else {
              return names['$<<'](arg)
            };}, TMP_25.$$s = self, TMP_25.$$arity = 1, TMP_25));
          self.$option("pos_attrs", names.$compact());
          return self.$option("default_attrs", defaults);}
          else if ($$$('::', 'Hash')['$===']($case)) {
          $b = [[], $hash2([], {})], (names = $b[0]), (defaults = $b[1]), $b;
          $send(args, 'each', [], (TMP_26 = function(key, val){var self = TMP_26.$$s || this, $c, $d, name = nil, idx = nil, $writer = nil;

          
            
            if (key == null) {
              key = nil;
            };
            
            if (val == null) {
              val = nil;
            };
            if ($truthy((name = key.$to_s())['$include?'](":"))) {
              
              $d = name.$split(":", 2), $c = Opal.to_ary($d), (idx = ($c[0] == null ? nil : $c[0])), (name = ($c[1] == null ? nil : $c[1])), $d;
              idx = (function() {if (idx['$==']("@")) {
                return names.$size()
              } else {
                return idx.$to_i()
              }; return nil; })();
              
              $writer = [idx, name];
              $send(names, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];;};
            if ($truthy(val)) {
              
              $writer = [name, val];
              $send(defaults, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];
            } else {
              return nil
            };}, TMP_26.$$s = self, TMP_26.$$arity = 2, TMP_26));
          self.$option("pos_attrs", names.$compact());
          return self.$option("default_attrs", defaults);}
          else {return self.$raise($$$('::', 'ArgumentError'), "" + "unsupported attributes specification for macro: " + (args.$inspect()))}})();
        }, TMP_SyntaxProcessorDsl_resolves_attributes_24.$$arity = -1);
        Opal.alias(self, "resolve_attributes", "resolves_attributes");
      })($nesting[0], $nesting);
      (function($base, $super, $parent_nesting) {
        function $Preprocessor(){};
        var self = $Preprocessor = $klass($base, $super, 'Preprocessor', $Preprocessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Preprocessor_process_27;

        return (Opal.def(self, '$process', TMP_Preprocessor_process_27 = function $$process(document, reader) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::Preprocessor subclass must implement #" + ("process") + " method")
        }, TMP_Preprocessor_process_27.$$arity = 2), nil) && 'process'
      })($nesting[0], $$($nesting, 'Processor'), $nesting);
      Opal.const_set($$($nesting, 'Preprocessor'), 'DSL', $$($nesting, 'DocumentProcessorDsl'));
      (function($base, $super, $parent_nesting) {
        function $TreeProcessor(){};
        var self = $TreeProcessor = $klass($base, $super, 'TreeProcessor', $TreeProcessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_TreeProcessor_process_28;

        return (Opal.def(self, '$process', TMP_TreeProcessor_process_28 = function $$process(document) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::TreeProcessor subclass must implement #" + ("process") + " method")
        }, TMP_TreeProcessor_process_28.$$arity = 1), nil) && 'process'
      })($nesting[0], $$($nesting, 'Processor'), $nesting);
      Opal.const_set($$($nesting, 'TreeProcessor'), 'DSL', $$($nesting, 'DocumentProcessorDsl'));
      Opal.const_set($nesting[0], 'Treeprocessor', $$($nesting, 'TreeProcessor'));
      (function($base, $super, $parent_nesting) {
        function $Postprocessor(){};
        var self = $Postprocessor = $klass($base, $super, 'Postprocessor', $Postprocessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Postprocessor_process_29;

        return (Opal.def(self, '$process', TMP_Postprocessor_process_29 = function $$process(document, output) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::Postprocessor subclass must implement #" + ("process") + " method")
        }, TMP_Postprocessor_process_29.$$arity = 2), nil) && 'process'
      })($nesting[0], $$($nesting, 'Processor'), $nesting);
      Opal.const_set($$($nesting, 'Postprocessor'), 'DSL', $$($nesting, 'DocumentProcessorDsl'));
      (function($base, $super, $parent_nesting) {
        function $IncludeProcessor(){};
        var self = $IncludeProcessor = $klass($base, $super, 'IncludeProcessor', $IncludeProcessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_IncludeProcessor_process_30, TMP_IncludeProcessor_handles$q_31;

        
        
        Opal.def(self, '$process', TMP_IncludeProcessor_process_30 = function $$process(document, reader, target, attributes) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::IncludeProcessor subclass must implement #" + ("process") + " method")
        }, TMP_IncludeProcessor_process_30.$$arity = 4);
        return (Opal.def(self, '$handles?', TMP_IncludeProcessor_handles$q_31 = function(target) {
          var self = this;

          return true
        }, TMP_IncludeProcessor_handles$q_31.$$arity = 1), nil) && 'handles?';
      })($nesting[0], $$($nesting, 'Processor'), $nesting);
      (function($base, $parent_nesting) {
        function $IncludeProcessorDsl() {};
        var self = $IncludeProcessorDsl = $module($base, 'IncludeProcessorDsl', $IncludeProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_IncludeProcessorDsl_handles$q_32;

        
        self.$include($$($nesting, 'DocumentProcessorDsl'));
        
        Opal.def(self, '$handles?', TMP_IncludeProcessorDsl_handles$q_32 = function($a) {
          var $iter = TMP_IncludeProcessorDsl_handles$q_32.$$p, block = $iter || nil, $post_args, args, $b, self = this;
          if (self.handles_block == null) self.handles_block = nil;

          if ($iter) TMP_IncludeProcessorDsl_handles$q_32.$$p = null;
          
          
          if ($iter) TMP_IncludeProcessorDsl_handles$q_32.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          if ((block !== nil)) {
            
            if ($truthy(args['$empty?']())) {
            } else {
              self.$raise($$$('::', 'ArgumentError'), "" + "wrong number of arguments (given " + (args.$size()) + ", expected 0)")
            };
            return (self.handles_block = block);
          } else if ($truthy((($b = self['handles_block'], $b != null && $b !== nil) ? 'instance-variable' : nil))) {
            return self.handles_block.$call(args['$[]'](0))
          } else {
            return true
          };
        }, TMP_IncludeProcessorDsl_handles$q_32.$$arity = -1);
      })($nesting[0], $nesting);
      Opal.const_set($$($nesting, 'IncludeProcessor'), 'DSL', $$($nesting, 'IncludeProcessorDsl'));
      (function($base, $super, $parent_nesting) {
        function $DocinfoProcessor(){};
        var self = $DocinfoProcessor = $klass($base, $super, 'DocinfoProcessor', $DocinfoProcessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_DocinfoProcessor_initialize_33, TMP_DocinfoProcessor_process_34;

        def.config = nil;
        
        self.$attr_accessor("location");
        
        Opal.def(self, '$initialize', TMP_DocinfoProcessor_initialize_33 = function $$initialize(config) {
          var $a, $iter = TMP_DocinfoProcessor_initialize_33.$$p, $yield = $iter || nil, self = this, $writer = nil;

          if ($iter) TMP_DocinfoProcessor_initialize_33.$$p = null;
          
          
          if (config == null) {
            config = $hash2([], {});
          };
          $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_DocinfoProcessor_initialize_33, false), [config], null);
          return ($truthy($a = self.config['$[]']("location")) ? $a : (($writer = ["location", "head"]), $send(self.config, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        }, TMP_DocinfoProcessor_initialize_33.$$arity = -1);
        return (Opal.def(self, '$process', TMP_DocinfoProcessor_process_34 = function $$process(document) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::DocinfoProcessor subclass must implement #" + ("process") + " method")
        }, TMP_DocinfoProcessor_process_34.$$arity = 1), nil) && 'process';
      })($nesting[0], $$($nesting, 'Processor'), $nesting);
      (function($base, $parent_nesting) {
        function $DocinfoProcessorDsl() {};
        var self = $DocinfoProcessorDsl = $module($base, 'DocinfoProcessorDsl', $DocinfoProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_DocinfoProcessorDsl_at_location_35;

        
        self.$include($$($nesting, 'DocumentProcessorDsl'));
        
        Opal.def(self, '$at_location', TMP_DocinfoProcessorDsl_at_location_35 = function $$at_location(value) {
          var self = this;

          return self.$option("location", value)
        }, TMP_DocinfoProcessorDsl_at_location_35.$$arity = 1);
      })($nesting[0], $nesting);
      Opal.const_set($$($nesting, 'DocinfoProcessor'), 'DSL', $$($nesting, 'DocinfoProcessorDsl'));
      (function($base, $super, $parent_nesting) {
        function $BlockProcessor(){};
        var self = $BlockProcessor = $klass($base, $super, 'BlockProcessor', $BlockProcessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_BlockProcessor_initialize_36, TMP_BlockProcessor_process_37;

        def.config = nil;
        
        self.$attr_accessor("name");
        
        Opal.def(self, '$initialize', TMP_BlockProcessor_initialize_36 = function $$initialize(name, config) {
          var $a, $iter = TMP_BlockProcessor_initialize_36.$$p, $yield = $iter || nil, self = this, $case = nil, $writer = nil;

          if ($iter) TMP_BlockProcessor_initialize_36.$$p = null;
          
          
          if (name == null) {
            name = nil;
          };
          
          if (config == null) {
            config = $hash2([], {});
          };
          $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_BlockProcessor_initialize_36, false), [config], null);
          self.name = ($truthy($a = name) ? $a : self.config['$[]']("name"));
          $case = self.config['$[]']("contexts");
          if ($$$('::', 'NilClass')['$===']($case)) {($truthy($a = self.config['$[]']("contexts")) ? $a : (($writer = ["contexts", ["open", "paragraph"].$to_set()]), $send(self.config, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))}
          else if ($$$('::', 'Symbol')['$===']($case)) {
          $writer = ["contexts", [self.config['$[]']("contexts")].$to_set()];
          $send(self.config, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];}
          else {
          $writer = ["contexts", self.config['$[]']("contexts").$to_set()];
          $send(self.config, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
          return ($truthy($a = self.config['$[]']("content_model")) ? $a : (($writer = ["content_model", "compound"]), $send(self.config, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        }, TMP_BlockProcessor_initialize_36.$$arity = -1);
        return (Opal.def(self, '$process', TMP_BlockProcessor_process_37 = function $$process(parent, reader, attributes) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::BlockProcessor subclass must implement #" + ("process") + " method")
        }, TMP_BlockProcessor_process_37.$$arity = 3), nil) && 'process';
      })($nesting[0], $$($nesting, 'Processor'), $nesting);
      (function($base, $parent_nesting) {
        function $BlockProcessorDsl() {};
        var self = $BlockProcessorDsl = $module($base, 'BlockProcessorDsl', $BlockProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_BlockProcessorDsl_contexts_38;

        
        self.$include($$($nesting, 'SyntaxProcessorDsl'));
        
        Opal.def(self, '$contexts', TMP_BlockProcessorDsl_contexts_38 = function $$contexts($a) {
          var $post_args, value, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          value = $post_args;;
          return self.$option("contexts", value.$flatten().$to_set());
        }, TMP_BlockProcessorDsl_contexts_38.$$arity = -1);
        Opal.alias(self, "on_contexts", "contexts");
        Opal.alias(self, "on_context", "contexts");
        Opal.alias(self, "bound_to", "contexts");
      })($nesting[0], $nesting);
      Opal.const_set($$($nesting, 'BlockProcessor'), 'DSL', $$($nesting, 'BlockProcessorDsl'));
      (function($base, $super, $parent_nesting) {
        function $MacroProcessor(){};
        var self = $MacroProcessor = $klass($base, $super, 'MacroProcessor', $MacroProcessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_MacroProcessor_initialize_39, TMP_MacroProcessor_process_40;

        def.config = nil;
        
        self.$attr_accessor("name");
        
        Opal.def(self, '$initialize', TMP_MacroProcessor_initialize_39 = function $$initialize(name, config) {
          var $a, $iter = TMP_MacroProcessor_initialize_39.$$p, $yield = $iter || nil, self = this, $writer = nil;

          if ($iter) TMP_MacroProcessor_initialize_39.$$p = null;
          
          
          if (name == null) {
            name = nil;
          };
          
          if (config == null) {
            config = $hash2([], {});
          };
          $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_MacroProcessor_initialize_39, false), [config], null);
          self.name = ($truthy($a = name) ? $a : self.config['$[]']("name"));
          return ($truthy($a = self.config['$[]']("content_model")) ? $a : (($writer = ["content_model", "attributes"]), $send(self.config, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        }, TMP_MacroProcessor_initialize_39.$$arity = -1);
        return (Opal.def(self, '$process', TMP_MacroProcessor_process_40 = function $$process(parent, target, attributes) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'), "" + "Asciidoctor::Extensions::MacroProcessor subclass must implement #" + ("process") + " method")
        }, TMP_MacroProcessor_process_40.$$arity = 3), nil) && 'process';
      })($nesting[0], $$($nesting, 'Processor'), $nesting);
      (function($base, $parent_nesting) {
        function $MacroProcessorDsl() {};
        var self = $MacroProcessorDsl = $module($base, 'MacroProcessorDsl', $MacroProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_MacroProcessorDsl_resolves_attributes_41;

        
        self.$include($$($nesting, 'SyntaxProcessorDsl'));
        
        Opal.def(self, '$resolves_attributes', TMP_MacroProcessorDsl_resolves_attributes_41 = function $$resolves_attributes($a) {
          var $post_args, args, $b, $iter = TMP_MacroProcessorDsl_resolves_attributes_41.$$p, $yield = $iter || nil, self = this, $zuper = nil, $zuper_i = nil, $zuper_ii = nil;

          if ($iter) TMP_MacroProcessorDsl_resolves_attributes_41.$$p = null;
          // Prepare super implicit arguments
          for($zuper_i = 0, $zuper_ii = arguments.length, $zuper = new Array($zuper_ii); $zuper_i < $zuper_ii; $zuper_i++) {
            $zuper[$zuper_i] = arguments[$zuper_i];
          }
          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          if ($truthy((($b = args.$size()['$=='](1)) ? args['$[]'](0)['$!']() : args.$size()['$=='](1)))) {
            
            self.$option("content_model", "text");
            return nil;};
          $send(self, Opal.find_super_dispatcher(self, 'resolves_attributes', TMP_MacroProcessorDsl_resolves_attributes_41, false), $zuper, $iter);
          return self.$option("content_model", "attributes");
        }, TMP_MacroProcessorDsl_resolves_attributes_41.$$arity = -1);
        Opal.alias(self, "resolve_attributes", "resolves_attributes");
      })($nesting[0], $nesting);
      (function($base, $super, $parent_nesting) {
        function $BlockMacroProcessor(){};
        var self = $BlockMacroProcessor = $klass($base, $super, 'BlockMacroProcessor', $BlockMacroProcessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_BlockMacroProcessor_name_42;

        def.name = nil;
        return (Opal.def(self, '$name', TMP_BlockMacroProcessor_name_42 = function $$name() {
          var self = this;

          
          if ($truthy($$($nesting, 'MacroNameRx')['$match?'](self.name.$to_s()))) {
          } else {
            self.$raise($$$('::', 'ArgumentError'), "" + "invalid name for block macro: " + (self.name))
          };
          return self.name;
        }, TMP_BlockMacroProcessor_name_42.$$arity = 0), nil) && 'name'
      })($nesting[0], $$($nesting, 'MacroProcessor'), $nesting);
      Opal.const_set($$($nesting, 'BlockMacroProcessor'), 'DSL', $$($nesting, 'MacroProcessorDsl'));
      (function($base, $super, $parent_nesting) {
        function $InlineMacroProcessor(){};
        var self = $InlineMacroProcessor = $klass($base, $super, 'InlineMacroProcessor', $InlineMacroProcessor);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_InlineMacroProcessor_regexp_43, TMP_InlineMacroProcessor_resolve_regexp_44;

        def.config = def.name = nil;
        
        (Opal.class_variable_set($InlineMacroProcessor, '@@rx_cache', $hash2([], {})));
        
        Opal.def(self, '$regexp', TMP_InlineMacroProcessor_regexp_43 = function $$regexp() {
          var $a, self = this, $writer = nil;

          return ($truthy($a = self.config['$[]']("regexp")) ? $a : (($writer = ["regexp", self.$resolve_regexp(self.name.$to_s(), self.config['$[]']("format"))]), $send(self.config, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
        }, TMP_InlineMacroProcessor_regexp_43.$$arity = 0);
        return (Opal.def(self, '$resolve_regexp', TMP_InlineMacroProcessor_resolve_regexp_44 = function $$resolve_regexp(name, format) {
          var $a, $b, self = this, $writer = nil;

          
          if ($truthy($$($nesting, 'MacroNameRx')['$match?'](name))) {
          } else {
            self.$raise($$$('::', 'ArgumentError'), "" + "invalid name for inline macro: " + (name))
          };
          return ($truthy($a = (($b = $InlineMacroProcessor.$$cvars['@@rx_cache']) == null ? nil : $b)['$[]']([name, format])) ? $a : (($writer = [[name, format], new RegExp("" + "\\\\?" + (name) + ":" + ((function() {if (format['$==']("short")) {
            return "(){0}"
          } else {
            return "(\\S+?)"
          }; return nil; })()) + "\\[(|.*?[^\\\\])\\]")]), $send((($b = $InlineMacroProcessor.$$cvars['@@rx_cache']) == null ? nil : $b), '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
        }, TMP_InlineMacroProcessor_resolve_regexp_44.$$arity = 2), nil) && 'resolve_regexp';
      })($nesting[0], $$($nesting, 'MacroProcessor'), $nesting);
      (function($base, $parent_nesting) {
        function $InlineMacroProcessorDsl() {};
        var self = $InlineMacroProcessorDsl = $module($base, 'InlineMacroProcessorDsl', $InlineMacroProcessorDsl);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_InlineMacroProcessorDsl_with_format_45, TMP_InlineMacroProcessorDsl_matches_46;

        
        self.$include($$($nesting, 'MacroProcessorDsl'));
        
        Opal.def(self, '$with_format', TMP_InlineMacroProcessorDsl_with_format_45 = function $$with_format(value) {
          var self = this;

          return self.$option("format", value)
        }, TMP_InlineMacroProcessorDsl_with_format_45.$$arity = 1);
        Opal.alias(self, "using_format", "with_format");
        
        Opal.def(self, '$matches', TMP_InlineMacroProcessorDsl_matches_46 = function $$matches(value) {
          var self = this;

          return self.$option("regexp", value)
        }, TMP_InlineMacroProcessorDsl_matches_46.$$arity = 1);
        Opal.alias(self, "match", "matches");
        Opal.alias(self, "matching", "matches");
      })($nesting[0], $nesting);
      Opal.const_set($$($nesting, 'InlineMacroProcessor'), 'DSL', $$($nesting, 'InlineMacroProcessorDsl'));
      (function($base, $super, $parent_nesting) {
        function $Extension(){};
        var self = $Extension = $klass($base, $super, 'Extension', $Extension);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Extension_initialize_47;

        
        self.$attr_reader("kind");
        self.$attr_reader("config");
        self.$attr_reader("instance");
        return (Opal.def(self, '$initialize', TMP_Extension_initialize_47 = function $$initialize(kind, instance, config) {
          var self = this;

          
          self.kind = kind;
          self.instance = instance;
          return (self.config = config);
        }, TMP_Extension_initialize_47.$$arity = 3), nil) && 'initialize';
      })($nesting[0], null, $nesting);
      (function($base, $super, $parent_nesting) {
        function $ProcessorExtension(){};
        var self = $ProcessorExtension = $klass($base, $super, 'ProcessorExtension', $ProcessorExtension);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_ProcessorExtension_initialize_48;

        
        self.$attr_reader("process_method");
        return (Opal.def(self, '$initialize', TMP_ProcessorExtension_initialize_48 = function $$initialize(kind, instance, process_method) {
          var $a, $iter = TMP_ProcessorExtension_initialize_48.$$p, $yield = $iter || nil, self = this;

          if ($iter) TMP_ProcessorExtension_initialize_48.$$p = null;
          
          
          if (process_method == null) {
            process_method = nil;
          };
          $send(self, Opal.find_super_dispatcher(self, 'initialize', TMP_ProcessorExtension_initialize_48, false), [kind, instance, instance.$config()], null);
          return (self.process_method = ($truthy($a = process_method) ? $a : instance.$method("process")));
        }, TMP_ProcessorExtension_initialize_48.$$arity = -3), nil) && 'initialize';
      })($nesting[0], $$($nesting, 'Extension'), $nesting);
      (function($base, $super, $parent_nesting) {
        function $Group(){};
        var self = $Group = $klass($base, $super, 'Group', $Group);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Group_activate_50;

        
        (function(self, $parent_nesting) {
          var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_register_49;

          return (Opal.def(self, '$register', TMP_register_49 = function $$register(name) {
            var self = this;

            
            
            if (name == null) {
              name = nil;
            };
            return $$($nesting, 'Extensions').$register(name, self);
          }, TMP_register_49.$$arity = -1), nil) && 'register'
        })(Opal.get_singleton_class(self), $nesting);
        return (Opal.def(self, '$activate', TMP_Group_activate_50 = function $$activate(registry) {
          var self = this;

          return self.$raise($$$('::', 'NotImplementedError'))
        }, TMP_Group_activate_50.$$arity = 1), nil) && 'activate';
      })($nesting[0], null, $nesting);
      (function($base, $super, $parent_nesting) {
        function $Registry(){};
        var self = $Registry = $klass($base, $super, 'Registry', $Registry);

        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Registry_initialize_51, TMP_Registry_activate_52, TMP_Registry_preprocessor_54, TMP_Registry_preprocessors$q_55, TMP_Registry_preprocessors_56, TMP_Registry_tree_processor_57, TMP_Registry_tree_processors$q_58, TMP_Registry_tree_processors_59, TMP_Registry_postprocessor_60, TMP_Registry_postprocessors$q_61, TMP_Registry_postprocessors_62, TMP_Registry_include_processor_63, TMP_Registry_include_processors$q_64, TMP_Registry_include_processors_65, TMP_Registry_docinfo_processor_66, TMP_Registry_docinfo_processors$q_67, TMP_Registry_docinfo_processors_69, TMP_Registry_block_71, TMP_Registry_blocks$q_72, TMP_Registry_registered_for_block$q_73, TMP_Registry_find_block_extension_74, TMP_Registry_block_macro_75, TMP_Registry_block_macros$q_76, TMP_Registry_registered_for_block_macro$q_77, TMP_Registry_find_block_macro_extension_78, TMP_Registry_inline_macro_79, TMP_Registry_inline_macros$q_80, TMP_Registry_registered_for_inline_macro$q_81, TMP_Registry_find_inline_macro_extension_82, TMP_Registry_inline_macros_83, TMP_Registry_prefer_84, TMP_Registry_add_document_processor_85, TMP_Registry_add_syntax_processor_87, TMP_Registry_resolve_args_89, TMP_Registry_as_symbol_90;

        def.groups = def.preprocessor_extensions = def.tree_processor_extensions = def.postprocessor_extensions = def.include_processor_extensions = def.docinfo_processor_extensions = def.block_extensions = def.block_macro_extensions = def.inline_macro_extensions = nil;
        
        self.$attr_reader("document");
        self.$attr_reader("groups");
        
        Opal.def(self, '$initialize', TMP_Registry_initialize_51 = function $$initialize(groups) {
          var self = this;

          
          
          if (groups == null) {
            groups = $hash2([], {});
          };
          self.groups = groups;
          self.preprocessor_extensions = (self.tree_processor_extensions = (self.postprocessor_extensions = (self.include_processor_extensions = (self.docinfo_processor_extensions = (self.block_extensions = (self.block_macro_extensions = (self.inline_macro_extensions = nil)))))));
          return (self.document = nil);
        }, TMP_Registry_initialize_51.$$arity = -1);
        
        Opal.def(self, '$activate', TMP_Registry_activate_52 = function $$activate(document) {
          var TMP_53, self = this, ext_groups = nil;

          
          self.document = document;
          if ($truthy((ext_groups = $rb_plus($$($nesting, 'Extensions').$groups().$values(), self.groups.$values()))['$empty?']())) {
          } else {
            $send(ext_groups, 'each', [], (TMP_53 = function(group){var self = TMP_53.$$s || this, $case = nil;

            
              
              if (group == null) {
                group = nil;
              };
              return (function() {$case = group;
              if ($$$('::', 'Proc')['$===']($case)) {return (function() {$case = group.$arity();
              if ((0)['$===']($case) || (-1)['$===']($case)) {return $send(self, 'instance_exec', [], group.$to_proc())}
              else if ((1)['$===']($case)) {return group.$call(self)}
              else { return nil }})()}
              else if ($$$('::', 'Class')['$===']($case)) {return group.$new().$activate(self)}
              else {return group.$activate(self)}})();}, TMP_53.$$s = self, TMP_53.$$arity = 1, TMP_53))
          };
          return self;
        }, TMP_Registry_activate_52.$$arity = 1);
        
        Opal.def(self, '$preprocessor', TMP_Registry_preprocessor_54 = function $$preprocessor($a) {
          var $iter = TMP_Registry_preprocessor_54.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_preprocessor_54.$$p = null;
          
          
          if ($iter) TMP_Registry_preprocessor_54.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_document_processor', ["preprocessor", args], block.$to_proc());
        }, TMP_Registry_preprocessor_54.$$arity = -1);
        
        Opal.def(self, '$preprocessors?', TMP_Registry_preprocessors$q_55 = function() {
          var self = this;

          return self.preprocessor_extensions['$!']()['$!']()
        }, TMP_Registry_preprocessors$q_55.$$arity = 0);
        
        Opal.def(self, '$preprocessors', TMP_Registry_preprocessors_56 = function $$preprocessors() {
          var self = this;

          return self.preprocessor_extensions
        }, TMP_Registry_preprocessors_56.$$arity = 0);
        
        Opal.def(self, '$tree_processor', TMP_Registry_tree_processor_57 = function $$tree_processor($a) {
          var $iter = TMP_Registry_tree_processor_57.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_tree_processor_57.$$p = null;
          
          
          if ($iter) TMP_Registry_tree_processor_57.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_document_processor', ["tree_processor", args], block.$to_proc());
        }, TMP_Registry_tree_processor_57.$$arity = -1);
        
        Opal.def(self, '$tree_processors?', TMP_Registry_tree_processors$q_58 = function() {
          var self = this;

          return self.tree_processor_extensions['$!']()['$!']()
        }, TMP_Registry_tree_processors$q_58.$$arity = 0);
        
        Opal.def(self, '$tree_processors', TMP_Registry_tree_processors_59 = function $$tree_processors() {
          var self = this;

          return self.tree_processor_extensions
        }, TMP_Registry_tree_processors_59.$$arity = 0);
        Opal.alias(self, "treeprocessor", "tree_processor");
        Opal.alias(self, "treeprocessors?", "tree_processors?");
        Opal.alias(self, "treeprocessors", "tree_processors");
        
        Opal.def(self, '$postprocessor', TMP_Registry_postprocessor_60 = function $$postprocessor($a) {
          var $iter = TMP_Registry_postprocessor_60.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_postprocessor_60.$$p = null;
          
          
          if ($iter) TMP_Registry_postprocessor_60.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_document_processor', ["postprocessor", args], block.$to_proc());
        }, TMP_Registry_postprocessor_60.$$arity = -1);
        
        Opal.def(self, '$postprocessors?', TMP_Registry_postprocessors$q_61 = function() {
          var self = this;

          return self.postprocessor_extensions['$!']()['$!']()
        }, TMP_Registry_postprocessors$q_61.$$arity = 0);
        
        Opal.def(self, '$postprocessors', TMP_Registry_postprocessors_62 = function $$postprocessors() {
          var self = this;

          return self.postprocessor_extensions
        }, TMP_Registry_postprocessors_62.$$arity = 0);
        
        Opal.def(self, '$include_processor', TMP_Registry_include_processor_63 = function $$include_processor($a) {
          var $iter = TMP_Registry_include_processor_63.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_include_processor_63.$$p = null;
          
          
          if ($iter) TMP_Registry_include_processor_63.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_document_processor', ["include_processor", args], block.$to_proc());
        }, TMP_Registry_include_processor_63.$$arity = -1);
        
        Opal.def(self, '$include_processors?', TMP_Registry_include_processors$q_64 = function() {
          var self = this;

          return self.include_processor_extensions['$!']()['$!']()
        }, TMP_Registry_include_processors$q_64.$$arity = 0);
        
        Opal.def(self, '$include_processors', TMP_Registry_include_processors_65 = function $$include_processors() {
          var self = this;

          return self.include_processor_extensions
        }, TMP_Registry_include_processors_65.$$arity = 0);
        
        Opal.def(self, '$docinfo_processor', TMP_Registry_docinfo_processor_66 = function $$docinfo_processor($a) {
          var $iter = TMP_Registry_docinfo_processor_66.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_docinfo_processor_66.$$p = null;
          
          
          if ($iter) TMP_Registry_docinfo_processor_66.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_document_processor', ["docinfo_processor", args], block.$to_proc());
        }, TMP_Registry_docinfo_processor_66.$$arity = -1);
        
        Opal.def(self, '$docinfo_processors?', TMP_Registry_docinfo_processors$q_67 = function(location) {
          var TMP_68, self = this;

          
          
          if (location == null) {
            location = nil;
          };
          if ($truthy(self.docinfo_processor_extensions)) {
            if ($truthy(location)) {
              return $send(self.docinfo_processor_extensions, 'any?', [], (TMP_68 = function(ext){var self = TMP_68.$$s || this;

              
                
                if (ext == null) {
                  ext = nil;
                };
                return ext.$config()['$[]']("location")['$=='](location);}, TMP_68.$$s = self, TMP_68.$$arity = 1, TMP_68))
            } else {
              return true
            }
          } else {
            return false
          };
        }, TMP_Registry_docinfo_processors$q_67.$$arity = -1);
        
        Opal.def(self, '$docinfo_processors', TMP_Registry_docinfo_processors_69 = function $$docinfo_processors(location) {
          var TMP_70, self = this;

          
          
          if (location == null) {
            location = nil;
          };
          if ($truthy(self.docinfo_processor_extensions)) {
            if ($truthy(location)) {
              return $send(self.docinfo_processor_extensions, 'select', [], (TMP_70 = function(ext){var self = TMP_70.$$s || this;

              
                
                if (ext == null) {
                  ext = nil;
                };
                return ext.$config()['$[]']("location")['$=='](location);}, TMP_70.$$s = self, TMP_70.$$arity = 1, TMP_70))
            } else {
              return self.docinfo_processor_extensions
            }
          } else {
            return nil
          };
        }, TMP_Registry_docinfo_processors_69.$$arity = -1);
        
        Opal.def(self, '$block', TMP_Registry_block_71 = function $$block($a) {
          var $iter = TMP_Registry_block_71.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_block_71.$$p = null;
          
          
          if ($iter) TMP_Registry_block_71.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_syntax_processor', ["block", args], block.$to_proc());
        }, TMP_Registry_block_71.$$arity = -1);
        
        Opal.def(self, '$blocks?', TMP_Registry_blocks$q_72 = function() {
          var self = this;

          return self.block_extensions['$!']()['$!']()
        }, TMP_Registry_blocks$q_72.$$arity = 0);
        
        Opal.def(self, '$registered_for_block?', TMP_Registry_registered_for_block$q_73 = function(name, context) {
          var self = this, ext = nil;

          if ($truthy((ext = self.block_extensions['$[]'](name.$to_sym())))) {
            if ($truthy(ext.$config()['$[]']("contexts")['$include?'](context))) {
              return ext
            } else {
              return false
            }
          } else {
            return false
          }
        }, TMP_Registry_registered_for_block$q_73.$$arity = 2);
        
        Opal.def(self, '$find_block_extension', TMP_Registry_find_block_extension_74 = function $$find_block_extension(name) {
          var self = this;

          return self.block_extensions['$[]'](name.$to_sym())
        }, TMP_Registry_find_block_extension_74.$$arity = 1);
        
        Opal.def(self, '$block_macro', TMP_Registry_block_macro_75 = function $$block_macro($a) {
          var $iter = TMP_Registry_block_macro_75.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_block_macro_75.$$p = null;
          
          
          if ($iter) TMP_Registry_block_macro_75.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_syntax_processor', ["block_macro", args], block.$to_proc());
        }, TMP_Registry_block_macro_75.$$arity = -1);
        
        Opal.def(self, '$block_macros?', TMP_Registry_block_macros$q_76 = function() {
          var self = this;

          return self.block_macro_extensions['$!']()['$!']()
        }, TMP_Registry_block_macros$q_76.$$arity = 0);
        
        Opal.def(self, '$registered_for_block_macro?', TMP_Registry_registered_for_block_macro$q_77 = function(name) {
          var self = this, ext = nil;

          if ($truthy((ext = self.block_macro_extensions['$[]'](name.$to_sym())))) {
            return ext
          } else {
            return false
          }
        }, TMP_Registry_registered_for_block_macro$q_77.$$arity = 1);
        
        Opal.def(self, '$find_block_macro_extension', TMP_Registry_find_block_macro_extension_78 = function $$find_block_macro_extension(name) {
          var self = this;

          return self.block_macro_extensions['$[]'](name.$to_sym())
        }, TMP_Registry_find_block_macro_extension_78.$$arity = 1);
        
        Opal.def(self, '$inline_macro', TMP_Registry_inline_macro_79 = function $$inline_macro($a) {
          var $iter = TMP_Registry_inline_macro_79.$$p, block = $iter || nil, $post_args, args, self = this;

          if ($iter) TMP_Registry_inline_macro_79.$$p = null;
          
          
          if ($iter) TMP_Registry_inline_macro_79.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          return $send(self, 'add_syntax_processor', ["inline_macro", args], block.$to_proc());
        }, TMP_Registry_inline_macro_79.$$arity = -1);
        
        Opal.def(self, '$inline_macros?', TMP_Registry_inline_macros$q_80 = function() {
          var self = this;

          return self.inline_macro_extensions['$!']()['$!']()
        }, TMP_Registry_inline_macros$q_80.$$arity = 0);
        
        Opal.def(self, '$registered_for_inline_macro?', TMP_Registry_registered_for_inline_macro$q_81 = function(name) {
          var self = this, ext = nil;

          if ($truthy((ext = self.inline_macro_extensions['$[]'](name.$to_sym())))) {
            return ext
          } else {
            return false
          }
        }, TMP_Registry_registered_for_inline_macro$q_81.$$arity = 1);
        
        Opal.def(self, '$find_inline_macro_extension', TMP_Registry_find_inline_macro_extension_82 = function $$find_inline_macro_extension(name) {
          var self = this;

          return self.inline_macro_extensions['$[]'](name.$to_sym())
        }, TMP_Registry_find_inline_macro_extension_82.$$arity = 1);
        
        Opal.def(self, '$inline_macros', TMP_Registry_inline_macros_83 = function $$inline_macros() {
          var self = this;

          return self.inline_macro_extensions.$values()
        }, TMP_Registry_inline_macros_83.$$arity = 0);
        
        Opal.def(self, '$prefer', TMP_Registry_prefer_84 = function $$prefer($a) {
          var $iter = TMP_Registry_prefer_84.$$p, block = $iter || nil, $post_args, args, self = this, extension = nil, arg0 = nil, extensions_store = nil;

          if ($iter) TMP_Registry_prefer_84.$$p = null;
          
          
          if ($iter) TMP_Registry_prefer_84.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          extension = (function() {if ($truthy($$($nesting, 'ProcessorExtension')['$===']((arg0 = args.$shift())))) {
            return arg0
          } else {
            
            return $send(self, 'send', [arg0].concat(Opal.to_a(args)), block.$to_proc());
          }; return nil; })();
          extensions_store = self.$instance_variable_get(((("" + "@") + (extension.$kind())) + "_extensions").$to_sym());
          extensions_store.$unshift(extensions_store.$delete(extension));
          return extension;
        }, TMP_Registry_prefer_84.$$arity = -1);
        self.$private();
        
        Opal.def(self, '$add_document_processor', TMP_Registry_add_document_processor_85 = function $$add_document_processor(kind, args) {
          var $iter = TMP_Registry_add_document_processor_85.$$p, block = $iter || nil, TMP_86, $a, $b, $c, self = this, kind_name = nil, kind_class_symbol = nil, kind_class = nil, kind_java_class = nil, kind_store = nil, extension = nil, config = nil, processor = nil, processor_class = nil, processor_instance = nil;

          if ($iter) TMP_Registry_add_document_processor_85.$$p = null;
          
          
          if ($iter) TMP_Registry_add_document_processor_85.$$p = null;;
          kind_name = kind.$to_s().$tr("_", " ");
          kind_class_symbol = $send(kind_name.$split(), 'map', [], (TMP_86 = function(it){var self = TMP_86.$$s || this;

          
            
            if (it == null) {
              it = nil;
            };
            return it.$capitalize();}, TMP_86.$$s = self, TMP_86.$$arity = 1, TMP_86)).$join().$to_sym();
          kind_class = $$($nesting, 'Extensions').$const_get(kind_class_symbol);
          kind_java_class = (function() {if ($truthy((($a = $$$('::', 'AsciidoctorJ', 'skip_raise')) ? 'constant' : nil))) {
            
            return $$$($$$('::', 'AsciidoctorJ'), 'Extensions').$const_get(kind_class_symbol);
          } else {
            return nil
          }; return nil; })();
          kind_store = ($truthy($b = self.$instance_variable_get(((("" + "@") + (kind)) + "_extensions").$to_sym())) ? $b : self.$instance_variable_set(((("" + "@") + (kind)) + "_extensions").$to_sym(), []));
          extension = (function() {if ((block !== nil)) {
            
            config = self.$resolve_args(args, 1);
            processor = kind_class.$new(config);
            if ($truthy(kind_class.$constants().$grep("DSL"))) {
              processor.$extend(kind_class.$const_get("DSL"))};
            $send(processor, 'instance_exec', [], block.$to_proc());
            processor.$freeze();
            if ($truthy(processor['$process_block_given?']())) {
            } else {
              self.$raise($$$('::', 'ArgumentError'), "" + "No block specified to process " + (kind_name) + " extension at " + (block.$source_location()))
            };
            return $$($nesting, 'ProcessorExtension').$new(kind, processor);
          } else {
            
            $c = self.$resolve_args(args, 2), $b = Opal.to_ary($c), (processor = ($b[0] == null ? nil : $b[0])), (config = ($b[1] == null ? nil : $b[1])), $c;
            if ($truthy((processor_class = $$($nesting, 'Extensions').$resolve_class(processor)))) {
              
              if ($truthy(($truthy($b = $rb_lt(processor_class, kind_class)) ? $b : ($truthy($c = kind_java_class) ? $rb_lt(processor_class, kind_java_class) : $c)))) {
              } else {
                self.$raise($$$('::', 'ArgumentError'), "" + "Invalid type for " + (kind_name) + " extension: " + (processor))
              };
              processor_instance = processor_class.$new(config);
              processor_instance.$freeze();
              return $$($nesting, 'ProcessorExtension').$new(kind, processor_instance);
            } else if ($truthy(($truthy($b = kind_class['$==='](processor)) ? $b : ($truthy($c = kind_java_class) ? kind_java_class['$==='](processor) : $c)))) {
              
              processor.$update_config(config);
              processor.$freeze();
              return $$($nesting, 'ProcessorExtension').$new(kind, processor);
            } else {
              return self.$raise($$$('::', 'ArgumentError'), "" + "Invalid arguments specified for registering " + (kind_name) + " extension: " + (args))
            };
          }; return nil; })();
          if (extension.$config()['$[]']("position")['$=='](">>")) {
            
            kind_store.$unshift(extension);
          } else {
            
            kind_store['$<<'](extension);
          };
          return extension;
        }, TMP_Registry_add_document_processor_85.$$arity = 2);
        
        Opal.def(self, '$add_syntax_processor', TMP_Registry_add_syntax_processor_87 = function $$add_syntax_processor(kind, args) {
          var $iter = TMP_Registry_add_syntax_processor_87.$$p, block = $iter || nil, TMP_88, $a, $b, $c, self = this, kind_name = nil, kind_class_symbol = nil, kind_class = nil, kind_java_class = nil, kind_store = nil, name = nil, config = nil, processor = nil, $writer = nil, processor_class = nil, processor_instance = nil;

          if ($iter) TMP_Registry_add_syntax_processor_87.$$p = null;
          
          
          if ($iter) TMP_Registry_add_syntax_processor_87.$$p = null;;
          kind_name = kind.$to_s().$tr("_", " ");
          kind_class_symbol = $send(kind_name.$split(), 'map', [], (TMP_88 = function(it){var self = TMP_88.$$s || this;

          
            
            if (it == null) {
              it = nil;
            };
            return it.$capitalize();}, TMP_88.$$s = self, TMP_88.$$arity = 1, TMP_88)).$push("Processor").$join().$to_sym();
          kind_class = $$($nesting, 'Extensions').$const_get(kind_class_symbol);
          kind_java_class = (function() {if ($truthy((($a = $$$('::', 'AsciidoctorJ', 'skip_raise')) ? 'constant' : nil))) {
            
            return $$$($$$('::', 'AsciidoctorJ'), 'Extensions').$const_get(kind_class_symbol);
          } else {
            return nil
          }; return nil; })();
          kind_store = ($truthy($b = self.$instance_variable_get(((("" + "@") + (kind)) + "_extensions").$to_sym())) ? $b : self.$instance_variable_set(((("" + "@") + (kind)) + "_extensions").$to_sym(), $hash2([], {})));
          if ((block !== nil)) {
            
            $c = self.$resolve_args(args, 2), $b = Opal.to_ary($c), (name = ($b[0] == null ? nil : $b[0])), (config = ($b[1] == null ? nil : $b[1])), $c;
            processor = kind_class.$new(self.$as_symbol(name), config);
            if ($truthy(kind_class.$constants().$grep("DSL"))) {
              processor.$extend(kind_class.$const_get("DSL"))};
            if (block.$arity()['$=='](1)) {
              Opal.yield1(block, processor)
            } else {
              $send(processor, 'instance_exec', [], block.$to_proc())
            };
            if ($truthy((name = self.$as_symbol(processor.$name())))) {
            } else {
              self.$raise($$$('::', 'ArgumentError'), "" + "No name specified for " + (kind_name) + " extension at " + (block.$source_location()))
            };
            if ($truthy(processor['$process_block_given?']())) {
            } else {
              self.$raise($$$('::', 'NoMethodError'), "" + "No block specified to process " + (kind_name) + " extension at " + (block.$source_location()))
            };
            processor.$freeze();
            
            $writer = [name, $$($nesting, 'ProcessorExtension').$new(kind, processor)];
            $send(kind_store, '[]=', Opal.to_a($writer));
            return $writer[$rb_minus($writer["length"], 1)];;
          } else {
            
            $c = self.$resolve_args(args, 3), $b = Opal.to_ary($c), (processor = ($b[0] == null ? nil : $b[0])), (name = ($b[1] == null ? nil : $b[1])), (config = ($b[2] == null ? nil : $b[2])), $c;
            if ($truthy((processor_class = $$($nesting, 'Extensions').$resolve_class(processor)))) {
              
              if ($truthy(($truthy($b = $rb_lt(processor_class, kind_class)) ? $b : ($truthy($c = kind_java_class) ? $rb_lt(processor_class, kind_java_class) : $c)))) {
              } else {
                self.$raise($$$('::', 'ArgumentError'), "" + "Class specified for " + (kind_name) + " extension does not inherit from " + (kind_class) + ": " + (processor))
              };
              processor_instance = processor_class.$new(self.$as_symbol(name), config);
              if ($truthy((name = self.$as_symbol(processor_instance.$name())))) {
              } else {
                self.$raise($$$('::', 'ArgumentError'), "" + "No name specified for " + (kind_name) + " extension: " + (processor))
              };
              processor_instance.$freeze();
              
              $writer = [name, $$($nesting, 'ProcessorExtension').$new(kind, processor_instance)];
              $send(kind_store, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            } else if ($truthy(($truthy($b = kind_class['$==='](processor)) ? $b : ($truthy($c = kind_java_class) ? kind_java_class['$==='](processor) : $c)))) {
              
              processor.$update_config(config);
              if ($truthy((name = (function() {if ($truthy(name)) {
                
                
                $writer = [self.$as_symbol(name)];
                $send(processor, 'name=', Opal.to_a($writer));
                return $writer[$rb_minus($writer["length"], 1)];;
              } else {
                
                return self.$as_symbol(processor.$name());
              }; return nil; })()))) {
              } else {
                self.$raise($$$('::', 'ArgumentError'), "" + "No name specified for " + (kind_name) + " extension: " + (processor))
              };
              processor.$freeze();
              
              $writer = [name, $$($nesting, 'ProcessorExtension').$new(kind, processor)];
              $send(kind_store, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;
            } else {
              return self.$raise($$$('::', 'ArgumentError'), "" + "Invalid arguments specified for registering " + (kind_name) + " extension: " + (args))
            };
          };
        }, TMP_Registry_add_syntax_processor_87.$$arity = 2);
        
        Opal.def(self, '$resolve_args', TMP_Registry_resolve_args_89 = function $$resolve_args(args, expect) {
          var self = this, opts = nil, missing = nil;

          
          opts = (function() {if ($truthy($$$('::', 'Hash')['$==='](args['$[]'](-1)))) {
            return args.$pop()
          } else {
            return $hash2([], {})
          }; return nil; })();
          if (expect['$=='](1)) {
            return opts};
          if ($truthy($rb_gt((missing = $rb_minus($rb_minus(expect, 1), args.$size())), 0))) {
            args = $rb_plus(args, $$$('::', 'Array').$new(missing))
          } else if ($truthy($rb_lt(missing, 0))) {
            args.$pop(missing['$-@']())};
          args['$<<'](opts);
          return args;
        }, TMP_Registry_resolve_args_89.$$arity = 2);
        return (Opal.def(self, '$as_symbol', TMP_Registry_as_symbol_90 = function $$as_symbol(name) {
          var self = this;

          if ($truthy(name)) {
            return name.$to_sym()
          } else {
            return nil
          }
        }, TMP_Registry_as_symbol_90.$$arity = 1), nil) && 'as_symbol';
      })($nesting[0], null, $nesting);
      (function(self, $parent_nesting) {
        var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_generate_name_91, TMP_next_auto_id_92, TMP_groups_93, TMP_create_94, TMP_register_95, TMP_unregister_all_96, TMP_unregister_97, TMP_resolve_class_99, TMP_class_for_name_100, TMP_class_for_name_101, TMP_class_for_name_103;

        
        
        Opal.def(self, '$generate_name', TMP_generate_name_91 = function $$generate_name() {
          var self = this;

          return "" + "extgrp" + (self.$next_auto_id())
        }, TMP_generate_name_91.$$arity = 0);
        
        Opal.def(self, '$next_auto_id', TMP_next_auto_id_92 = function $$next_auto_id() {
          var $a, self = this;
          if (self.auto_id == null) self.auto_id = nil;

          
          self.auto_id = ($truthy($a = self.auto_id) ? $a : -1);
          return (self.auto_id = $rb_plus(self.auto_id, 1));
        }, TMP_next_auto_id_92.$$arity = 0);
        
        Opal.def(self, '$groups', TMP_groups_93 = function $$groups() {
          var $a, self = this;
          if (self.groups == null) self.groups = nil;

          return (self.groups = ($truthy($a = self.groups) ? $a : $hash2([], {})))
        }, TMP_groups_93.$$arity = 0);
        
        Opal.def(self, '$create', TMP_create_94 = function $$create(name) {
          var $iter = TMP_create_94.$$p, block = $iter || nil, $a, self = this;

          if ($iter) TMP_create_94.$$p = null;
          
          
          if ($iter) TMP_create_94.$$p = null;;
          
          if (name == null) {
            name = nil;
          };
          if ((block !== nil)) {
            return $$($nesting, 'Registry').$new($hash(($truthy($a = name) ? $a : self.$generate_name()), block))
          } else {
            return $$($nesting, 'Registry').$new()
          };
        }, TMP_create_94.$$arity = -1);
        Opal.alias(self, "build_registry", "create");
        
        Opal.def(self, '$register', TMP_register_95 = function $$register($a) {
          var $iter = TMP_register_95.$$p, block = $iter || nil, $post_args, args, $b, self = this, argc = nil, resolved_group = nil, group = nil, name = nil, $writer = nil;

          if ($iter) TMP_register_95.$$p = null;
          
          
          if ($iter) TMP_register_95.$$p = null;;
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          args = $post_args;;
          argc = args.$size();
          if ((block !== nil)) {
            resolved_group = block
          } else if ($truthy((group = args.$pop()))) {
            resolved_group = ($truthy($b = self.$resolve_class(group)) ? $b : group)
          } else {
            self.$raise($$$('::', 'ArgumentError'), "Extension group to register not specified")
          };
          name = ($truthy($b = args.$pop()) ? $b : self.$generate_name());
          if ($truthy(args['$empty?']())) {
          } else {
            self.$raise($$$('::', 'ArgumentError'), "" + "Wrong number of arguments (" + (argc) + " for 1..2)")
          };
          
          $writer = [name.$to_sym(), resolved_group];
          $send(self.$groups(), '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];;
        }, TMP_register_95.$$arity = -1);
        
        Opal.def(self, '$unregister_all', TMP_unregister_all_96 = function $$unregister_all() {
          var self = this;

          
          self.groups = $hash2([], {});
          return nil;
        }, TMP_unregister_all_96.$$arity = 0);
        
        Opal.def(self, '$unregister', TMP_unregister_97 = function $$unregister($a) {
          var $post_args, names, TMP_98, self = this;

          
          
          $post_args = Opal.slice.call(arguments, 0, arguments.length);
          
          names = $post_args;;
          $send(names, 'each', [], (TMP_98 = function(group){var self = TMP_98.$$s || this;
            if (self.groups == null) self.groups = nil;

          
            
            if (group == null) {
              group = nil;
            };
            return self.groups.$delete(group.$to_sym());}, TMP_98.$$s = self, TMP_98.$$arity = 1, TMP_98));
          return nil;
        }, TMP_unregister_97.$$arity = -1);
        
        Opal.def(self, '$resolve_class', TMP_resolve_class_99 = function $$resolve_class(object) {
          var self = this, $case = nil;

          return (function() {$case = object;
          if ($$$('::', 'Class')['$===']($case)) {return object}
          else if ($$$('::', 'String')['$===']($case)) {return self.$class_for_name(object)}
          else { return nil }})()
        }, TMP_resolve_class_99.$$arity = 1);
        if ($truthy($$$('::', 'RUBY_MIN_VERSION_2'))) {
          return (Opal.def(self, '$class_for_name', TMP_class_for_name_100 = function $$class_for_name(qualified_name) {
            var self = this, resolved = nil;

            try {
              
              resolved = $$$('::', 'Object').$const_get(qualified_name, false);
              if ($truthy($$$('::', 'Class')['$==='](resolved))) {
              } else {
                self.$raise()
              };
              return resolved;
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  return self.$raise($$$('::', 'NameError'), "" + "Could not resolve class for name: " + (qualified_name))
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            }
          }, TMP_class_for_name_100.$$arity = 1), nil) && 'class_for_name'
        } else if ($truthy($$$('::', 'RUBY_MIN_VERSION_1_9'))) {
          return (Opal.def(self, '$class_for_name', TMP_class_for_name_101 = function $$class_for_name(qualified_name) {
            var TMP_102, self = this, resolved = nil;

            try {
              
              resolved = $send(qualified_name.$split("::"), 'reduce', [$$$('::', 'Object')], (TMP_102 = function(current, name){var self = TMP_102.$$s || this;

              
                
                if (current == null) {
                  current = nil;
                };
                
                if (name == null) {
                  name = nil;
                };
                if ($truthy(name['$empty?']())) {
                  return current
                } else {
                  
                  return current.$const_get(name, false);
                };}, TMP_102.$$s = self, TMP_102.$$arity = 2, TMP_102));
              if ($truthy($$$('::', 'Class')['$==='](resolved))) {
              } else {
                self.$raise()
              };
              return resolved;
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  return self.$raise($$$('::', 'NameError'), "" + "Could not resolve class for name: " + (qualified_name))
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            }
          }, TMP_class_for_name_101.$$arity = 1), nil) && 'class_for_name'
        } else {
          return (Opal.def(self, '$class_for_name', TMP_class_for_name_103 = function $$class_for_name(qualified_name) {
            var TMP_104, self = this, resolved = nil;

            try {
              
              resolved = $send(qualified_name.$split("::"), 'reduce', [$$$('::', 'Object')], (TMP_104 = function(current, name){var self = TMP_104.$$s || this;

              
                
                if (current == null) {
                  current = nil;
                };
                
                if (name == null) {
                  name = nil;
                };
                if ($truthy(name['$empty?']())) {
                  return current
                } else {
                  
                  if ($truthy(current['$const_defined?'](name))) {
                    
                    return current.$const_get(name);
                  } else {
                    return self.$raise()
                  };
                };}, TMP_104.$$s = self, TMP_104.$$arity = 2, TMP_104));
              if ($truthy($$$('::', 'Class')['$==='](resolved))) {
              } else {
                self.$raise()
              };
              return resolved;
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  return self.$raise($$$('::', 'NameError'), "" + "Could not resolve class for name: " + (qualified_name))
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            }
          }, TMP_class_for_name_103.$$arity = 1), nil) && 'class_for_name'
        };
      })(Opal.get_singleton_class(self), $nesting);
    })($nesting[0], $nesting)
  })($nesting[0], $nesting);
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/opal_ext/browser/reader"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $module = Opal.module, $klass = Opal.klass, $truthy = Opal.truthy;

  Opal.add_stubs(['$posixify', '$new', '$base_dir', '$start_with?', '$uriish?', '$descends_from?', '$key?', '$attributes', '$replace_next_line', '$absolute_path?', '$==', '$empty?', '$!', '$slice', '$length']);
  return (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting);

    (function($base, $super, $parent_nesting) {
      function $PreprocessorReader(){};
      var self = $PreprocessorReader = $klass($base, $super, 'PreprocessorReader', $PreprocessorReader);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_PreprocessorReader_resolve_include_path_1;

      def.path_resolver = def.document = def.include_stack = def.dir = nil;
      return (Opal.def(self, '$resolve_include_path', TMP_PreprocessorReader_resolve_include_path_1 = function $$resolve_include_path(target, attrlist, attributes) {
        var $a, self = this, p_target = nil, target_type = nil, base_dir = nil, inc_path = nil, relpath = nil, ctx_dir = nil, top_level = nil, offset = nil;

        
        p_target = (self.path_resolver = ($truthy($a = self.path_resolver) ? $a : $$($nesting, 'PathResolver').$new("\\"))).$posixify(target);
        $a = ["file", self.document.$base_dir()], (target_type = $a[0]), (base_dir = $a[1]), $a;
        if ($truthy(p_target['$start_with?']("file://"))) {
          inc_path = (relpath = p_target)
        } else if ($truthy($$($nesting, 'Helpers')['$uriish?'](p_target))) {
          
          if ($truthy(($truthy($a = self.path_resolver['$descends_from?'](p_target, base_dir)) ? $a : self.document.$attributes()['$key?']("allow-uri-read")))) {
          } else {
            return self.$replace_next_line("" + "link:" + (target) + "[" + (attrlist) + "]")
          };
          inc_path = (relpath = p_target);
        } else if ($truthy(self.path_resolver['$absolute_path?'](p_target))) {
          inc_path = (relpath = "" + "file://" + ((function() {if ($truthy(p_target['$start_with?']("/"))) {
            return ""
          } else {
            return "/"
          }; return nil; })()) + (p_target))
        } else if ((ctx_dir = (function() {if ($truthy((top_level = self.include_stack['$empty?']()))) {
          return base_dir
        } else {
          return self.dir
        }; return nil; })())['$=='](".")) {
          inc_path = (relpath = p_target)
        } else if ($truthy(($truthy($a = ctx_dir['$start_with?']("file://")) ? $a : $$($nesting, 'Helpers')['$uriish?'](ctx_dir)['$!']()))) {
          
          inc_path = "" + (ctx_dir) + "/" + (p_target);
          if ($truthy(top_level)) {
            relpath = p_target
          } else if ($truthy(($truthy($a = base_dir['$=='](".")) ? $a : (offset = self.path_resolver['$descends_from?'](inc_path, base_dir))['$!']()))) {
            relpath = inc_path
          } else {
            relpath = inc_path.$slice(offset, inc_path.$length())
          };
        } else if ($truthy(top_level)) {
          inc_path = "" + (ctx_dir) + "/" + ((relpath = p_target))
        } else if ($truthy(($truthy($a = (offset = self.path_resolver['$descends_from?'](ctx_dir, base_dir))) ? $a : self.document.$attributes()['$key?']("allow-uri-read")))) {
          
          inc_path = "" + (ctx_dir) + "/" + (p_target);
          relpath = (function() {if ($truthy(offset)) {
            
            return inc_path.$slice(offset, inc_path.$length());
          } else {
            return p_target
          }; return nil; })();
        } else {
          return self.$replace_next_line("" + "link:" + (target) + "[" + (attrlist) + "]")
        };
        return [inc_path, "file", relpath];
      }, TMP_PreprocessorReader_resolve_include_path_1.$$arity = 3), nil) && 'resolve_include_path'
    })($nesting[0], $$($nesting, 'Reader'), $nesting)
  })($nesting[0], $nesting)
};

/* Generated by Opal 0.11.99.dev */
Opal.modules["asciidoctor/js/postscript"] = function(Opal) {
  var self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice;

  Opal.add_stubs(['$require', '$==']);
  
  self.$require("asciidoctor/converter/composite");
  self.$require("asciidoctor/converter/html5");
  self.$require("asciidoctor/extensions");
  if ($$($nesting, 'JAVASCRIPT_IO_MODULE')['$==']("xmlhttprequest")) {
    return self.$require("asciidoctor/js/opal_ext/browser/reader")
  } else {
    return nil
  };
};

/* Generated by Opal 0.11.99.dev */
(function(Opal) {
  function $rb_ge(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs >= rhs : lhs['$>='](rhs);
  }
  function $rb_minus(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs - rhs : lhs['$-'](rhs);
  }
  function $rb_lt(lhs, rhs) {
    return (typeof(lhs) === 'number' && typeof(rhs) === 'number') ? lhs < rhs : lhs['$<'](rhs);
  }
  var $a, self = Opal.top, $nesting = [], nil = Opal.nil, $$$ = Opal.const_get_qualified, $$ = Opal.const_get_relative, $breaker = Opal.breaker, $slice = Opal.slice, $truthy = Opal.truthy, $gvars = Opal.gvars, $module = Opal.module, $hash2 = Opal.hash2, $send = Opal.send, $hash = Opal.hash;
  if ($gvars[":"] == null) $gvars[":"] = nil;

  Opal.add_stubs(['$==', '$>=', '$require', '$unshift', '$dirname', '$each', '$constants', '$const_get', '$downcase', '$to_s', '$[]=', '$-', '$upcase', '$[]', '$values', '$new', '$attr_reader', '$instance_variable_set', '$send', '$<<', '$define', '$expand_path', '$join', '$home', '$pwd', '$!', '$!=', '$default_external', '$to_set', '$map', '$keys', '$slice', '$merge', '$default=', '$to_a', '$escape', '$drop', '$insert', '$dup', '$start', '$logger', '$logger=', '$===', '$split', '$gsub', '$respond_to?', '$raise', '$ancestors', '$class', '$path', '$utc', '$at', '$Integer', '$mtime', '$readlines', '$basename', '$extname', '$index', '$strftime', '$year', '$utc_offset', '$rewind', '$lines', '$each_line', '$record', '$parse', '$exception', '$message', '$set_backtrace', '$backtrace', '$stack_trace', '$stack_trace=', '$open', '$load', '$delete', '$key?', '$attributes', '$outfilesuffix', '$safe', '$normalize_system_path', '$mkdir_p', '$directory?', '$convert', '$write', '$<', '$attr?', '$attr', '$uriish?', '$include?', '$write_primary_stylesheet', '$instance', '$empty?', '$read_asset', '$file?', '$write_coderay_stylesheet', '$write_pygments_stylesheet']);
  
  if ($truthy((($a = $$($nesting, 'RUBY_ENGINE', 'skip_raise')) ? 'constant' : nil))) {
  } else {
    Opal.const_set($nesting[0], 'RUBY_ENGINE', "unknown")
  };
  Opal.const_set($nesting[0], 'RUBY_ENGINE_OPAL', $$($nesting, 'RUBY_ENGINE')['$==']("opal"));
  Opal.const_set($nesting[0], 'RUBY_ENGINE_JRUBY', $$($nesting, 'RUBY_ENGINE')['$==']("jruby"));
  Opal.const_set($nesting[0], 'RUBY_MIN_VERSION_1_9', $rb_ge($$($nesting, 'RUBY_VERSION'), "1.9"));
  Opal.const_set($nesting[0], 'RUBY_MIN_VERSION_2', $rb_ge($$($nesting, 'RUBY_VERSION'), "2"));
  self.$require("set");
  if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
    self.$require("asciidoctor/js")
  } else {
    nil
  };
  $gvars[":"].$unshift($$($nesting, 'File').$dirname("asciidoctor.rb"));
  self.$require("asciidoctor/logging");
  (function($base, $parent_nesting) {
    function $Asciidoctor() {};
    var self = $Asciidoctor = $module($base, 'Asciidoctor', $Asciidoctor);

    var def = self.prototype, $nesting = [self].concat($parent_nesting), $a, TMP_Asciidoctor_6, TMP_Asciidoctor_7, TMP_Asciidoctor_8, $writer = nil, quote_subs = nil, compat_quote_subs = nil;

    
    Opal.const_set($nesting[0], 'RUBY_ENGINE', $$$('::', 'RUBY_ENGINE'));
    (function($base, $parent_nesting) {
      function $SafeMode() {};
      var self = $SafeMode = $module($base, 'SafeMode', $SafeMode);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_SafeMode_1, TMP_SafeMode_value_for_name_2, TMP_SafeMode_name_for_value_3, TMP_SafeMode_names_4, rec = nil;

      
      Opal.const_set($nesting[0], 'UNSAFE', 0);
      Opal.const_set($nesting[0], 'SAFE', 1);
      Opal.const_set($nesting[0], 'SERVER', 10);
      Opal.const_set($nesting[0], 'SECURE', 20);
      rec = $hash2([], {});
      $send((Opal.Module.$$nesting = $nesting, self.$constants()), 'each', [], (TMP_SafeMode_1 = function(sym){var self = TMP_SafeMode_1.$$s || this, $writer = nil;

      
        
        if (sym == null) {
          sym = nil;
        };
        $writer = [self.$const_get(sym), sym.$to_s().$downcase()];
        $send(rec, '[]=', Opal.to_a($writer));
        return $writer[$rb_minus($writer["length"], 1)];}, TMP_SafeMode_1.$$s = self, TMP_SafeMode_1.$$arity = 1, TMP_SafeMode_1));
      self.names_by_value = rec;
      Opal.defs(self, '$value_for_name', TMP_SafeMode_value_for_name_2 = function $$value_for_name(name) {
        var self = this;

        return self.$const_get(name.$upcase())
      }, TMP_SafeMode_value_for_name_2.$$arity = 1);
      Opal.defs(self, '$name_for_value', TMP_SafeMode_name_for_value_3 = function $$name_for_value(value) {
        var self = this;
        if (self.names_by_value == null) self.names_by_value = nil;

        return self.names_by_value['$[]'](value)
      }, TMP_SafeMode_name_for_value_3.$$arity = 1);
      Opal.defs(self, '$names', TMP_SafeMode_names_4 = function $$names() {
        var self = this;
        if (self.names_by_value == null) self.names_by_value = nil;

        return self.names_by_value.$values()
      }, TMP_SafeMode_names_4.$$arity = 0);
    })($nesting[0], $nesting);
    (function($base, $parent_nesting) {
      function $Compliance() {};
      var self = $Compliance = $module($base, 'Compliance', $Compliance);

      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_Compliance_define_5;

      
      self.keys = $$$('::', 'Set').$new();
      (function(self, $parent_nesting) {
        var def = self.prototype, $nesting = [self].concat($parent_nesting);

        return self.$attr_reader("keys")
      })(Opal.get_singleton_class(self), $nesting);
      Opal.defs(self, '$define', TMP_Compliance_define_5 = function $$define(key, value) {
        var self = this;
        if (self.keys == null) self.keys = nil;

        
        self.$instance_variable_set("" + "@" + (key), value);
        (function(self, $parent_nesting) {
          var def = self.prototype, $nesting = [self].concat($parent_nesting);

          return self
        })(Opal.get_singleton_class(self), $nesting).$send("attr_accessor", key);
        self.keys['$<<'](key);
        return nil;
      }, TMP_Compliance_define_5.$$arity = 2);
      self.$define("block_terminates_paragraph", true);
      self.$define("strict_verbatim_paragraphs", true);
      self.$define("underline_style_section_titles", true);
      self.$define("unwrap_standalone_preamble", true);
      self.$define("attribute_missing", "skip");
      self.$define("attribute_undefined", "drop-line");
      self.$define("shorthand_property_syntax", true);
      self.$define("natural_xrefs", true);
      self.$define("unique_id_start_index", 2);
      self.$define("markdown_syntax", true);
    })($nesting[0], $nesting);
    Opal.const_set($nesting[0], 'ROOT_PATH', $$$('::', 'File').$dirname($$$('::', 'File').$dirname($$$('::', 'File').$expand_path("asciidoctor.rb"))));
    Opal.const_set($nesting[0], 'DATA_PATH', $$$('::', 'File').$join($$($nesting, 'ROOT_PATH'), "data"));
    
    try {
      Opal.const_set($nesting[0], 'USER_HOME', $$$('::', 'Dir').$home())
    } catch ($err) {
      if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
        try {
          Opal.const_set($nesting[0], 'USER_HOME', ($truthy($a = $$$('::', 'ENV')['$[]']("HOME")) ? $a : $$$('::', 'Dir').$pwd()))
        } finally { Opal.pop_exception() }
      } else { throw $err; }
    };;
    Opal.const_set($nesting[0], 'COERCE_ENCODING', ($truthy($a = $$$('::', 'RUBY_ENGINE_OPAL')['$!']()) ? $$$('::', 'RUBY_MIN_VERSION_1_9') : $a));
    Opal.const_set($nesting[0], 'FORCE_ENCODING', ($truthy($a = $$($nesting, 'COERCE_ENCODING')) ? $$$('::', 'Encoding').$default_external()['$!=']($$$($$$('::', 'Encoding'), 'UTF_8')) : $a));
    Opal.const_set($nesting[0], 'BOM_BYTES_UTF_8', [239, 187, 191]);
    Opal.const_set($nesting[0], 'BOM_BYTES_UTF_16LE', [255, 254]);
    Opal.const_set($nesting[0], 'BOM_BYTES_UTF_16BE', [254, 255]);
    Opal.const_set($nesting[0], 'FORCE_UNICODE_LINE_LENGTH', $$$('::', 'RUBY_MIN_VERSION_1_9')['$!']());
    Opal.const_set($nesting[0], 'LF', Opal.const_set($nesting[0], 'EOL', "\n"));
    Opal.const_set($nesting[0], 'NULL', "\u0000");
    Opal.const_set($nesting[0], 'TAB', "\t");
    Opal.const_set($nesting[0], 'MAX_INT', 9007199254740991);
    Opal.const_set($nesting[0], 'DEFAULT_DOCTYPE', "article");
    Opal.const_set($nesting[0], 'DEFAULT_BACKEND', "html5");
    Opal.const_set($nesting[0], 'DEFAULT_STYLESHEET_KEYS', ["", "DEFAULT"].$to_set());
    Opal.const_set($nesting[0], 'DEFAULT_STYLESHEET_NAME', "asciidoctor.css");
    Opal.const_set($nesting[0], 'BACKEND_ALIASES', $hash2(["html", "docbook"], {"html": "html5", "docbook": "docbook5"}));
    Opal.const_set($nesting[0], 'DEFAULT_PAGE_WIDTHS', $hash2(["docbook"], {"docbook": 425}));
    Opal.const_set($nesting[0], 'DEFAULT_EXTENSIONS', $hash2(["html", "docbook", "pdf", "epub", "manpage", "asciidoc"], {"html": ".html", "docbook": ".xml", "pdf": ".pdf", "epub": ".epub", "manpage": ".man", "asciidoc": ".adoc"}));
    Opal.const_set($nesting[0], 'ASCIIDOC_EXTENSIONS', $hash2([".adoc", ".asciidoc", ".asc", ".ad", ".txt"], {".adoc": true, ".asciidoc": true, ".asc": true, ".ad": true, ".txt": true}));
    Opal.const_set($nesting[0], 'SETEXT_SECTION_LEVELS', $hash2(["=", "-", "~", "^", "+"], {"=": 0, "-": 1, "~": 2, "^": 3, "+": 4}));
    Opal.const_set($nesting[0], 'ADMONITION_STYLES', ["NOTE", "TIP", "IMPORTANT", "WARNING", "CAUTION"].$to_set());
    Opal.const_set($nesting[0], 'ADMONITION_STYLE_HEADS', ["N", "T", "I", "W", "C"].$to_set());
    Opal.const_set($nesting[0], 'PARAGRAPH_STYLES', ["comment", "example", "literal", "listing", "normal", "open", "pass", "quote", "sidebar", "source", "verse", "abstract", "partintro"].$to_set());
    Opal.const_set($nesting[0], 'VERBATIM_STYLES', ["literal", "listing", "source", "verse"].$to_set());
    Opal.const_set($nesting[0], 'DELIMITED_BLOCKS', $hash2(["--", "----", "....", "====", "****", "____", "\"\"", "++++", "|===", ",===", ":===", "!===", "////", "```"], {"--": ["open", ["comment", "example", "literal", "listing", "pass", "quote", "sidebar", "source", "verse", "admonition", "abstract", "partintro"].$to_set()], "----": ["listing", ["literal", "source"].$to_set()], "....": ["literal", ["listing", "source"].$to_set()], "====": ["example", ["admonition"].$to_set()], "****": ["sidebar", $$$('::', 'Set').$new()], "____": ["quote", ["verse"].$to_set()], "\"\"": ["quote", ["verse"].$to_set()], "++++": ["pass", ["stem", "latexmath", "asciimath"].$to_set()], "|===": ["table", $$$('::', 'Set').$new()], ",===": ["table", $$$('::', 'Set').$new()], ":===": ["table", $$$('::', 'Set').$new()], "!===": ["table", $$$('::', 'Set').$new()], "////": ["comment", $$$('::', 'Set').$new()], "```": ["fenced_code", $$$('::', 'Set').$new()]}));
    Opal.const_set($nesting[0], 'DELIMITED_BLOCK_HEADS', $send($$($nesting, 'DELIMITED_BLOCKS').$keys(), 'map', [], (TMP_Asciidoctor_6 = function(key){var self = TMP_Asciidoctor_6.$$s || this;

    
      
      if (key == null) {
        key = nil;
      };
      return key.$slice(0, 2);}, TMP_Asciidoctor_6.$$s = self, TMP_Asciidoctor_6.$$arity = 1, TMP_Asciidoctor_6)).$to_set());
    Opal.const_set($nesting[0], 'LAYOUT_BREAK_CHARS', $hash2(["'", "<"], {"'": "thematic_break", "<": "page_break"}));
    Opal.const_set($nesting[0], 'MARKDOWN_THEMATIC_BREAK_CHARS', $hash2(["-", "*", "_"], {"-": "thematic_break", "*": "thematic_break", "_": "thematic_break"}));
    Opal.const_set($nesting[0], 'HYBRID_LAYOUT_BREAK_CHARS', $$($nesting, 'LAYOUT_BREAK_CHARS').$merge($$($nesting, 'MARKDOWN_THEMATIC_BREAK_CHARS')));
    Opal.const_set($nesting[0], 'NESTABLE_LIST_CONTEXTS', ["ulist", "olist", "dlist"]);
    Opal.const_set($nesting[0], 'ORDERED_LIST_STYLES', ["arabic", "loweralpha", "lowerroman", "upperalpha", "upperroman"]);
    Opal.const_set($nesting[0], 'ORDERED_LIST_KEYWORDS', $hash2(["loweralpha", "lowerroman", "upperalpha", "upperroman"], {"loweralpha": "a", "lowerroman": "i", "upperalpha": "A", "upperroman": "I"}));
    Opal.const_set($nesting[0], 'ATTR_REF_HEAD', "{");
    Opal.const_set($nesting[0], 'LIST_CONTINUATION', "+");
    Opal.const_set($nesting[0], 'HARD_LINE_BREAK', " +");
    Opal.const_set($nesting[0], 'LINE_CONTINUATION', " \\");
    Opal.const_set($nesting[0], 'LINE_CONTINUATION_LEGACY', " +");
    Opal.const_set($nesting[0], 'MATHJAX_VERSION', "2.7.4");
    Opal.const_set($nesting[0], 'BLOCK_MATH_DELIMITERS', $hash2(["asciimath", "latexmath"], {"asciimath": ["\\$", "\\$"], "latexmath": ["\\[", "\\]"]}));
    Opal.const_set($nesting[0], 'INLINE_MATH_DELIMITERS', $hash2(["asciimath", "latexmath"], {"asciimath": ["\\$", "\\$"], "latexmath": ["\\(", "\\)"]}));
    
    $writer = ["asciimath"];
    $send(Opal.const_set($nesting[0], 'STEM_TYPE_ALIASES', $hash2(["latexmath", "latex", "tex"], {"latexmath": "latexmath", "latex": "latexmath", "tex": "latexmath"})), 'default=', Opal.to_a($writer));
    $writer[$rb_minus($writer["length"], 1)];;
    Opal.const_set($nesting[0], 'FONT_AWESOME_VERSION', "4.7.0");
    Opal.const_set($nesting[0], 'FLEXIBLE_ATTRIBUTES', ["sectnums"]);
    if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      if ($truthy((($a = $$($nesting, 'CC_ANY', 'skip_raise')) ? 'constant' : nil))) {
      } else {
        Opal.const_set($nesting[0], 'CC_ANY', "[^\\n]")
      }
    } else {
      nil
    };
    Opal.const_set($nesting[0], 'AuthorInfoLineRx', new RegExp("" + "^(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-'.]*)(?: +(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-'.]*))?(?: +(" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + "\\-'.]*))?(?: +<([^>]+)>)?$"));
    Opal.const_set($nesting[0], 'RevisionInfoLineRx', new RegExp("" + "^(?:[^\\d{]*(" + ($$($nesting, 'CC_ANY')) + "*?),)? *(?!:)(" + ($$($nesting, 'CC_ANY')) + "*?)(?: *(?!^),?: *(" + ($$($nesting, 'CC_ANY')) + "*))?$"));
    Opal.const_set($nesting[0], 'ManpageTitleVolnumRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "+?) *\\( *(" + ($$($nesting, 'CC_ANY')) + "+?) *\\)$"));
    Opal.const_set($nesting[0], 'ManpageNamePurposeRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "+?) +- +(" + ($$($nesting, 'CC_ANY')) + "+)$"));
    Opal.const_set($nesting[0], 'ConditionalDirectiveRx', new RegExp("" + "^(\\\\)?(ifdef|ifndef|ifeval|endif)::(\\S*?(?:([,+])\\S*?)?)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'EvalExpressionRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "+?) *([=!><]=|[><]) *(" + ($$($nesting, 'CC_ANY')) + "+)$"));
    Opal.const_set($nesting[0], 'IncludeDirectiveRx', new RegExp("" + "^(\\\\)?include::([^\\[][^\\[]*)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'TagDirectiveRx', /\b(?:tag|(e)nd)::(\S+?)\[\](?=$|[ \r])/m);
    Opal.const_set($nesting[0], 'AttributeEntryRx', new RegExp("" + "^:(!?" + ($$($nesting, 'CG_WORD')) + "[^:]*):(?:[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*))?$"));
    Opal.const_set($nesting[0], 'InvalidAttributeNameCharsRx', new RegExp("" + "[^-" + ($$($nesting, 'CC_WORD')) + "]"));
    if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      Opal.const_set($nesting[0], 'AttributeEntryPassMacroRx', /^pass:([a-z]+(?:,[a-z]+)*)?\[([\S\s]*)\]$/)
    } else {
      nil
    };
    Opal.const_set($nesting[0], 'AttributeReferenceRx', new RegExp("" + "(\\\\)?\\{(" + ($$($nesting, 'CG_WORD')) + "[-" + ($$($nesting, 'CC_WORD')) + "]*|(set|counter2?):" + ($$($nesting, 'CC_ANY')) + "+?)(\\\\)?\\}"));
    Opal.const_set($nesting[0], 'BlockAnchorRx', new RegExp("" + "^\\[\\[(?:|([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+))?)\\]\\]$"));
    Opal.const_set($nesting[0], 'BlockAttributeListRx', new RegExp("" + "^\\[(|[" + ($$($nesting, 'CC_WORD')) + ".#%{,\"']" + ($$($nesting, 'CC_ANY')) + "*)\\]$"));
    Opal.const_set($nesting[0], 'BlockAttributeLineRx', new RegExp("" + "^\\[(?:|[" + ($$($nesting, 'CC_WORD')) + ".#%{,\"']" + ($$($nesting, 'CC_ANY')) + "*|\\[(?:|[" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*(?:, *" + ($$($nesting, 'CC_ANY')) + "+)?)\\])\\]$"));
    Opal.const_set($nesting[0], 'BlockTitleRx', new RegExp("" + "^\\.(\\.?[^ \\t.]" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'AdmonitionParagraphRx', new RegExp("" + "^(" + ($$($nesting, 'ADMONITION_STYLES').$to_a().$join("|")) + "):[ \\t]+"));
    Opal.const_set($nesting[0], 'LiteralParagraphRx', new RegExp("" + "^([ \\t]+" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'AtxSectionTitleRx', new RegExp("" + "^(=={0,5})[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "+?)(?:[ \\t]+\\1)?$"));
    Opal.const_set($nesting[0], 'ExtAtxSectionTitleRx', new RegExp("" + "^(=={0,5}|#\\\#{0,5})[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "+?)(?:[ \\t]+\\1)?$"));
    Opal.const_set($nesting[0], 'SetextSectionTitleRx', new RegExp("" + "^((?!\\.)" + ($$($nesting, 'CC_ANY')) + "*?" + ($$($nesting, 'CG_WORD')) + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'InlineSectionAnchorRx', new RegExp("" + " (\\\\)?\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+))?\\]\\]$"));
    Opal.const_set($nesting[0], 'InvalidSectionIdCharsRx', new RegExp("" + "<[^>]+>|&(?:[a-z][a-z]+\\d{0,2}|#\\d\\d\\d{0,4}|#x[\\da-f][\\da-f][\\da-f]{0,3});|[^ " + ($$($nesting, 'CC_WORD')) + "\\-.]+?"));
    Opal.const_set($nesting[0], 'AnyListRx', new RegExp("" + "^(?:[ \\t]*(?:-|\\*\\**|\\.\\.*|\\u2022|\\d+\\.|[a-zA-Z]\\.|[IVXivx]+\\))[ \\t]|(?!//[^/])" + ($$($nesting, 'CC_ANY')) + "*?(?::::{0,2}|;;)(?:$|[ \\t])|<?\\d+>[ \\t])"));
    Opal.const_set($nesting[0], 'UnorderedListRx', new RegExp("" + "^[ \\t]*(-|\\*\\**|\\u2022)[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'OrderedListRx', new RegExp("" + "^[ \\t]*(\\.\\.*|\\d+\\.|[a-zA-Z]\\.|[IVXivx]+\\))[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'OrderedListMarkerRxMap', $hash2(["arabic", "loweralpha", "lowerroman", "upperalpha", "upperroman"], {"arabic": /\d+\./, "loweralpha": /[a-z]\./, "lowerroman": /[ivx]+\)/, "upperalpha": /[A-Z]\./, "upperroman": /[IVX]+\)/}));
    Opal.const_set($nesting[0], 'DescriptionListRx', new RegExp("" + "^(?!//[^/])[ \\t]*(" + ($$($nesting, 'CC_ANY')) + "*?)(:::{0,2}|;;)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"));
    Opal.const_set($nesting[0], 'DescriptionListSiblingRx', $hash2(["::", ":::", "::::", ";;"], {"::": new RegExp("" + "^(?!//[^/])[ \\t]*(" + ($$($nesting, 'CC_ANY')) + "*[^:]|)(::)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"), ":::": new RegExp("" + "^(?!//[^/])[ \\t]*(" + ($$($nesting, 'CC_ANY')) + "*[^:]|)(:::)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"), "::::": new RegExp("" + "^(?!//[^/])[ \\t]*(" + ($$($nesting, 'CC_ANY')) + "*[^:]|)(::::)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)"), ";;": new RegExp("" + "^(?!//[^/])[ \\t]*(" + ($$($nesting, 'CC_ANY')) + "*?)(;;)(?:$|[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$)")}));
    Opal.const_set($nesting[0], 'CalloutListRx', new RegExp("" + "^<(\\d+|\\.)>[ \\t]+(" + ($$($nesting, 'CC_ANY')) + "*)$"));
    Opal.const_set($nesting[0], 'CalloutExtractRx', /((?:\/\/|#|--|;;) ?)?(\\)?<!?(|--)(\d+|\.)\3>(?=(?: ?\\?<!?\3(?:\d+|\.)\3>)*$)/);
    Opal.const_set($nesting[0], 'CalloutExtractRxt', "(\\\\)?<()(\\d+|\\.)>(?=(?: ?\\\\?<(?:\\d+|\\.)>)*$)");
    Opal.const_set($nesting[0], 'CalloutExtractRxMap', $send($$$('::', 'Hash'), 'new', [], (TMP_Asciidoctor_7 = function(h, k){var self = TMP_Asciidoctor_7.$$s || this;

    
      
      if (h == null) {
        h = nil;
      };
      
      if (k == null) {
        k = nil;
      };
      $writer = [k, new RegExp("" + "(" + ($$$('::', 'Regexp').$escape(k)) + " ?)?" + ($$($nesting, 'CalloutExtractRxt')))];
      $send(h, '[]=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];}, TMP_Asciidoctor_7.$$s = self, TMP_Asciidoctor_7.$$arity = 2, TMP_Asciidoctor_7)));
    Opal.const_set($nesting[0], 'CalloutScanRx', new RegExp("" + "\\\\?<!?(|--)(\\d+|\\.)\\1>(?=(?: ?\\\\?<!?\\1(?:\\d+|\\.)\\1>)*" + ($$($nesting, 'CC_EOL')) + ")"));
    Opal.const_set($nesting[0], 'CalloutSourceRx', new RegExp("" + "((?://|#|--|;;) ?)?(\\\\)?&lt;!?(|--)(\\d+|\\.)\\3&gt;(?=(?: ?\\\\?&lt;!?\\3(?:\\d+|\\.)\\3&gt;)*" + ($$($nesting, 'CC_EOL')) + ")"));
    Opal.const_set($nesting[0], 'CalloutSourceRxt', "" + "(\\\\)?&lt;()(\\d+|\\.)&gt;(?=(?: ?\\\\?&lt;(?:\\d+|\\.)&gt;)*" + ($$($nesting, 'CC_EOL')) + ")");
    Opal.const_set($nesting[0], 'CalloutSourceRxMap', $send($$$('::', 'Hash'), 'new', [], (TMP_Asciidoctor_8 = function(h, k){var self = TMP_Asciidoctor_8.$$s || this;

    
      
      if (h == null) {
        h = nil;
      };
      
      if (k == null) {
        k = nil;
      };
      $writer = [k, new RegExp("" + "(" + ($$$('::', 'Regexp').$escape(k)) + " ?)?" + ($$($nesting, 'CalloutSourceRxt')))];
      $send(h, '[]=', Opal.to_a($writer));
      return $writer[$rb_minus($writer["length"], 1)];}, TMP_Asciidoctor_8.$$s = self, TMP_Asciidoctor_8.$$arity = 2, TMP_Asciidoctor_8)));
    Opal.const_set($nesting[0], 'ListRxMap', $hash2(["ulist", "olist", "dlist", "colist"], {"ulist": $$($nesting, 'UnorderedListRx'), "olist": $$($nesting, 'OrderedListRx'), "dlist": $$($nesting, 'DescriptionListRx'), "colist": $$($nesting, 'CalloutListRx')}));
    Opal.const_set($nesting[0], 'ColumnSpecRx', /^(?:(\d+)\*)?([<^>](?:\.[<^>]?)?|(?:[<^>]?\.)?[<^>])?(\d+%?|~)?([a-z])?$/);
    Opal.const_set($nesting[0], 'CellSpecStartRx', /^[ \t]*(?:(\d+(?:\.\d*)?|(?:\d*\.)?\d+)([*+]))?([<^>](?:\.[<^>]?)?|(?:[<^>]?\.)?[<^>])?([a-z])?$/);
    Opal.const_set($nesting[0], 'CellSpecEndRx', /[ \t]+(?:(\d+(?:\.\d*)?|(?:\d*\.)?\d+)([*+]))?([<^>](?:\.[<^>]?)?|(?:[<^>]?\.)?[<^>])?([a-z])?$/);
    Opal.const_set($nesting[0], 'CustomBlockMacroRx', new RegExp("" + "^(" + ($$($nesting, 'CG_WORD')) + "[-" + ($$($nesting, 'CC_WORD')) + "]*)::(|\\S|\\S" + ($$($nesting, 'CC_ANY')) + "*?\\S)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'BlockMediaMacroRx', new RegExp("" + "^(image|video|audio)::(\\S|\\S" + ($$($nesting, 'CC_ANY')) + "*?\\S)\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'BlockTocMacroRx', new RegExp("" + "^toc::\\[(" + ($$($nesting, 'CC_ANY')) + "+)?\\]$"));
    Opal.const_set($nesting[0], 'InlineAnchorRx', new RegExp("" + "(\\\\)?(?:\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]|anchor:([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)\\[(?:\\]|(" + ($$($nesting, 'CC_ANY')) + "*?[^\\\\])\\]))"));
    Opal.const_set($nesting[0], 'InlineAnchorScanRx', new RegExp("" + "(?:^|[^\\\\\\[])\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]|(?:^|[^\\\\])anchor:([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)\\[(?:\\]|(" + ($$($nesting, 'CC_ANY')) + "*?[^\\\\])\\])"));
    Opal.const_set($nesting[0], 'LeadingInlineAnchorRx', new RegExp("" + "^\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]"));
    Opal.const_set($nesting[0], 'InlineBiblioAnchorRx', new RegExp("" + "^\\[\\[\\[([" + ($$($nesting, 'CC_ALPHA')) + "_:][" + ($$($nesting, 'CC_WORD')) + ":.-]*)(?:, *(" + ($$($nesting, 'CC_ANY')) + "+?))?\\]\\]\\]"));
    Opal.const_set($nesting[0], 'InlineEmailRx', new RegExp("" + "([\\\\>:/])?" + ($$($nesting, 'CG_WORD')) + "[" + ($$($nesting, 'CC_WORD')) + ".%+-]*@" + ($$($nesting, 'CG_ALNUM')) + "[" + ($$($nesting, 'CC_ALNUM')) + ".-]*\\." + ($$($nesting, 'CG_ALPHA')) + "{2,4}\\b"));
    Opal.const_set($nesting[0], 'InlineFootnoteMacroRx', new RegExp("" + "\\\\?footnote(?:(ref):|:([\\w-]+)?)\\[(?:|(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\]))\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineImageMacroRx', new RegExp("" + "\\\\?i(?:mage|con):([^:\\s\\[](?:[^\\n\\[]*[^\\s\\[])?)\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineIndextermMacroRx', new RegExp("" + "\\\\?(?:(indexterm2?):\\[(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]|\\(\\((" + ($$($nesting, 'CC_ALL')) + "+?)\\)\\)(?!\\)))", 'm'));
    Opal.const_set($nesting[0], 'InlineKbdBtnMacroRx', new RegExp("" + "(\\\\)?(kbd|btn):\\[(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineLinkRx', new RegExp("" + "(^|link:|" + ($$($nesting, 'CG_BLANK')) + "|&lt;|[>\\(\\)\\[\\];])(\\\\?(?:https?|file|ftp|irc)://[^\\s\\[\\]<]*[^\\s.,\\[\\]<])(?:\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\])?", 'm'));
    Opal.const_set($nesting[0], 'InlineLinkMacroRx', new RegExp("" + "\\\\?(?:link|(mailto)):(|[^:\\s\\[][^\\s\\[]*)\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'MacroNameRx', new RegExp("" + "^" + ($$($nesting, 'CG_WORD')) + "[-" + ($$($nesting, 'CC_WORD')) + "]*$"));
    Opal.const_set($nesting[0], 'InlineStemMacroRx', new RegExp("" + "\\\\?(stem|(?:latex|ascii)math):([a-z]+(?:,[a-z]+)*)?\\[(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineMenuMacroRx', new RegExp("" + "\\\\?menu:(" + ($$($nesting, 'CG_WORD')) + "|[" + ($$($nesting, 'CC_WORD')) + "&][^\\n\\[]*[^\\s\\[])\\[ *(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])?\\]", 'm'));
    Opal.const_set($nesting[0], 'InlineMenuRx', new RegExp("" + "\\\\?\"([" + ($$($nesting, 'CC_WORD')) + "&][^\"]*?[ \\n]+&gt;[ \\n]+[^\"]*)\""));
    Opal.const_set($nesting[0], 'InlinePassRx', $hash(false, ["+", "`", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:])(?:\\[([^\\]]+)\\])?(\\\\?(\\+|`)(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\4)(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')], true, ["`", nil, new RegExp("" + "(^|[^`" + ($$($nesting, 'CC_WORD')) + "])(?:\\[([^\\]]+)\\])?(\\\\?(`)([^`\\s]|[^`\\s]" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\4)(?![`" + ($$($nesting, 'CC_WORD')) + "])", 'm')]));
    Opal.const_set($nesting[0], 'SinglePlusInlinePassRx', new RegExp("" + "^(\\\\)?\\+(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\+$", 'm'));
    Opal.const_set($nesting[0], 'InlinePassMacroRx', new RegExp("" + "(?:(?:(\\\\?)\\[([^\\]]+)\\])?(\\\\{0,2})(\\+\\+\\+?|\\$\\$)(" + ($$($nesting, 'CC_ALL')) + "*?)\\4|(\\\\?)pass:([a-z]+(?:,[a-z]+)*)?\\[(|" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\])", 'm'));
    Opal.const_set($nesting[0], 'InlineXrefMacroRx', new RegExp("" + "\\\\?(?:&lt;&lt;([" + ($$($nesting, 'CC_WORD')) + "#/.:{]" + ($$($nesting, 'CC_ALL')) + "*?)&gt;&gt;|xref:([" + ($$($nesting, 'CC_WORD')) + "#/.:{]" + ($$($nesting, 'CC_ALL')) + "*?)\\[(?:\\]|(" + ($$($nesting, 'CC_ALL')) + "*?[^\\\\])\\]))", 'm'));
    if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
      Opal.const_set($nesting[0], 'HardLineBreakRx', new RegExp("" + "^(" + ($$($nesting, 'CC_ANY')) + "*) \\+$", 'm'))
    } else {
      nil
    };
    Opal.const_set($nesting[0], 'MarkdownThematicBreakRx', /^ {0,3}([-*_])( *)\1\2\1$/);
    Opal.const_set($nesting[0], 'ExtLayoutBreakRx', /^(?:'{3,}|<{3,}|([-*_])( *)\1\2\1)$/);
    Opal.const_set($nesting[0], 'BlankLineRx', /\n{2,}/);
    Opal.const_set($nesting[0], 'EscapedSpaceRx', /\\([ \t\n])/);
    Opal.const_set($nesting[0], 'ReplaceableTextRx', /[&']|--|\.\.\.|\([CRT]M?\)/);
    Opal.const_set($nesting[0], 'SpaceDelimiterRx', /([^\\])[ \t\n]+/);
    Opal.const_set($nesting[0], 'SubModifierSniffRx', /[+-]/);
    Opal.const_set($nesting[0], 'TrailingDigitsRx', /\d+$/);
    if ($$($nesting, 'RUBY_ENGINE')['$==']("opal")) {
    } else {
      nil
    };
    Opal.const_set($nesting[0], 'UriSniffRx', new RegExp("" + "^" + ($$($nesting, 'CG_ALPHA')) + "[" + ($$($nesting, 'CC_ALNUM')) + ".+-]+:/{0,2}"));
    Opal.const_set($nesting[0], 'UriTerminatorRx', /[);:]$/);
    Opal.const_set($nesting[0], 'XmlSanitizeRx', /<[^>]+>/);
    Opal.const_set($nesting[0], 'INTRINSIC_ATTRIBUTES', $hash2(["startsb", "endsb", "vbar", "caret", "asterisk", "tilde", "plus", "backslash", "backtick", "blank", "empty", "sp", "two-colons", "two-semicolons", "nbsp", "deg", "zwsp", "quot", "apos", "lsquo", "rsquo", "ldquo", "rdquo", "wj", "brvbar", "pp", "cpp", "amp", "lt", "gt"], {"startsb": "[", "endsb": "]", "vbar": "|", "caret": "^", "asterisk": "*", "tilde": "~", "plus": "&#43;", "backslash": "\\", "backtick": "`", "blank": "", "empty": "", "sp": " ", "two-colons": "::", "two-semicolons": ";;", "nbsp": "&#160;", "deg": "&#176;", "zwsp": "&#8203;", "quot": "&#34;", "apos": "&#39;", "lsquo": "&#8216;", "rsquo": "&#8217;", "ldquo": "&#8220;", "rdquo": "&#8221;", "wj": "&#8288;", "brvbar": "&#166;", "pp": "&#43;&#43;", "cpp": "C&#43;&#43;", "amp": "&", "lt": "<", "gt": ">"}));
    quote_subs = [["strong", "unconstrained", new RegExp("" + "\\\\?(?:\\[([^\\]]+)\\])?\\*\\*(" + ($$($nesting, 'CC_ALL')) + "+?)\\*\\*", 'm')], ["strong", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:}])(?:\\[([^\\]]+)\\])?\\*(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\*(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')], ["double", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:}])(?:\\[([^\\]]+)\\])?\"`(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)`\"(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')], ["single", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:`}])(?:\\[([^\\]]+)\\])?'`(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)`'(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')], ["monospaced", "unconstrained", new RegExp("" + "\\\\?(?:\\[([^\\]]+)\\])?``(" + ($$($nesting, 'CC_ALL')) + "+?)``", 'm')], ["monospaced", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:\"'`}])(?:\\[([^\\]]+)\\])?`(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)`(?![" + ($$($nesting, 'CC_WORD')) + "\"'`])", 'm')], ["emphasis", "unconstrained", new RegExp("" + "\\\\?(?:\\[([^\\]]+)\\])?__(" + ($$($nesting, 'CC_ALL')) + "+?)__", 'm')], ["emphasis", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:}])(?:\\[([^\\]]+)\\])?_(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)_(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')], ["mark", "unconstrained", new RegExp("" + "\\\\?(?:\\[([^\\]]+)\\])?##(" + ($$($nesting, 'CC_ALL')) + "+?)##", 'm')], ["mark", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + "&;:}])(?:\\[([^\\]]+)\\])?#(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)#(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')], ["superscript", "unconstrained", /\\?(?:\[([^\]]+)\])?\^(\S+?)\^/], ["subscript", "unconstrained", /\\?(?:\[([^\]]+)\])?~(\S+?)~/]];
    compat_quote_subs = quote_subs.$drop(0);
    
    $writer = [2, ["double", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:}])(?:\\[([^\\]]+)\\])?``(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)''(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')]];
    $send(compat_quote_subs, '[]=', Opal.to_a($writer));
    $writer[$rb_minus($writer["length"], 1)];;
    
    $writer = [3, ["single", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:}])(?:\\[([^\\]]+)\\])?`(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)'(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')]];
    $send(compat_quote_subs, '[]=', Opal.to_a($writer));
    $writer[$rb_minus($writer["length"], 1)];;
    
    $writer = [4, ["monospaced", "unconstrained", new RegExp("" + "\\\\?(?:\\[([^\\]]+)\\])?\\+\\+(" + ($$($nesting, 'CC_ALL')) + "+?)\\+\\+", 'm')]];
    $send(compat_quote_subs, '[]=', Opal.to_a($writer));
    $writer[$rb_minus($writer["length"], 1)];;
    
    $writer = [5, ["monospaced", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:}])(?:\\[([^\\]]+)\\])?\\+(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)\\+(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')]];
    $send(compat_quote_subs, '[]=', Opal.to_a($writer));
    $writer[$rb_minus($writer["length"], 1)];;
    compat_quote_subs.$insert(3, ["emphasis", "constrained", new RegExp("" + "(^|[^" + ($$($nesting, 'CC_WORD')) + ";:}])(?:\\[([^\\]]+)\\])?'(\\S|\\S" + ($$($nesting, 'CC_ALL')) + "*?\\S)'(?!" + ($$($nesting, 'CG_WORD')) + ")", 'm')]);
    Opal.const_set($nesting[0], 'QUOTE_SUBS', $hash(false, quote_subs, true, compat_quote_subs));
    quote_subs = nil;
    compat_quote_subs = nil;
    Opal.const_set($nesting[0], 'REPLACEMENTS', [[/\\?\(C\)/, "&#169;", "none"], [/\\?\(R\)/, "&#174;", "none"], [/\\?\(TM\)/, "&#8482;", "none"], [/(^|\n| |\\)--( |\n|$)/, "&#8201;&#8212;&#8201;", "none"], [new RegExp("" + "(" + ($$($nesting, 'CG_WORD')) + ")\\\\?--(?=" + ($$($nesting, 'CG_WORD')) + ")"), "&#8212;&#8203;", "leading"], [/\\?\.\.\./, "&#8230;&#8203;", "leading"], [/\\?`'/, "&#8217;", "none"], [new RegExp("" + "(" + ($$($nesting, 'CG_ALNUM')) + ")\\\\?'(?=" + ($$($nesting, 'CG_ALPHA')) + ")"), "&#8217;", "leading"], [/\\?-&gt;/, "&#8594;", "none"], [/\\?=&gt;/, "&#8658;", "none"], [/\\?&lt;-/, "&#8592;", "none"], [/\\?&lt;=/, "&#8656;", "none"], [/\\?(&)amp;((?:[a-zA-Z][a-zA-Z]+\d{0,2}|#\d\d\d{0,4}|#x[\da-fA-F][\da-fA-F][\da-fA-F]{0,3});)/, "", "bounding"]]);
    (function(self, $parent_nesting) {
      var def = self.prototype, $nesting = [self].concat($parent_nesting), TMP_load_9, TMP_load_file_13, TMP_convert_15, TMP_convert_file_16;

      
      
      Opal.def(self, '$load', TMP_load_9 = function $$load(input, options) {
        var $a, $b, TMP_10, TMP_11, TMP_12, self = this, timings = nil, logger = nil, $writer = nil, attrs = nil, attrs_arr = nil, lines = nil, input_path = nil, input_mtime = nil, docdate = nil, doctime = nil, doc = nil, ex = nil, context = nil, wrapped_ex = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        try {
          
          options = options.$dup();
          if ($truthy((timings = options['$[]']("timings")))) {
            timings.$start("read")};
          if ($truthy(($truthy($a = (logger = options['$[]']("logger"))) ? logger['$!=']($$($nesting, 'LoggerManager').$logger()) : $a))) {
            
            $writer = [logger];
            $send($$($nesting, 'LoggerManager'), 'logger=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];};
          if ($truthy((attrs = options['$[]']("attributes"))['$!']())) {
            attrs = $hash2([], {})
          } else if ($truthy(($truthy($a = $$$('::', 'Hash')['$==='](attrs)) ? $a : ($truthy($b = $$$('::', 'RUBY_ENGINE_JRUBY')) ? $$$($$$($$$('::', 'Java'), 'JavaUtil'), 'Map')['$==='](attrs) : $b)))) {
            attrs = attrs.$dup()
          } else if ($truthy($$$('::', 'Array')['$==='](attrs))) {
            
            $a = [$hash2([], {}), attrs], (attrs = $a[0]), (attrs_arr = $a[1]), $a;
            $send(attrs_arr, 'each', [], (TMP_10 = function(entry){var self = TMP_10.$$s || this, $c, $d, k = nil, v = nil;

            
              
              if (entry == null) {
                entry = nil;
              };
              $d = entry.$split("=", 2), $c = Opal.to_ary($d), (k = ($c[0] == null ? nil : $c[0])), (v = ($c[1] == null ? nil : $c[1])), $d;
              
              $writer = [k, ($truthy($c = v) ? $c : "")];
              $send(attrs, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;}, TMP_10.$$s = self, TMP_10.$$arity = 1, TMP_10));
          } else if ($truthy($$$('::', 'String')['$==='](attrs))) {
            
            $a = [$hash2([], {}), attrs.$gsub($$($nesting, 'SpaceDelimiterRx'), "" + "\\1" + ($$($nesting, 'NULL'))).$gsub($$($nesting, 'EscapedSpaceRx'), "\\1").$split($$($nesting, 'NULL'))], (attrs = $a[0]), (attrs_arr = $a[1]), $a;
            $send(attrs_arr, 'each', [], (TMP_11 = function(entry){var self = TMP_11.$$s || this, $c, $d, k = nil, v = nil;

            
              
              if (entry == null) {
                entry = nil;
              };
              $d = entry.$split("=", 2), $c = Opal.to_ary($d), (k = ($c[0] == null ? nil : $c[0])), (v = ($c[1] == null ? nil : $c[1])), $d;
              
              $writer = [k, ($truthy($c = v) ? $c : "")];
              $send(attrs, '[]=', Opal.to_a($writer));
              return $writer[$rb_minus($writer["length"], 1)];;}, TMP_11.$$s = self, TMP_11.$$arity = 1, TMP_11));
          } else if ($truthy(($truthy($a = attrs['$respond_to?']("keys")) ? attrs['$respond_to?']("[]") : $a))) {
            attrs = $$$('::', 'Hash')['$[]']($send(attrs.$keys(), 'map', [], (TMP_12 = function(k){var self = TMP_12.$$s || this;

            
              
              if (k == null) {
                k = nil;
              };
              return [k, attrs['$[]'](k)];}, TMP_12.$$s = self, TMP_12.$$arity = 1, TMP_12)))
          } else {
            self.$raise($$$('::', 'ArgumentError'), "" + "illegal type for attributes option: " + (attrs.$class().$ancestors().$join(" < ")))
          };
          lines = nil;
          if ($truthy($$$('::', 'File')['$==='](input))) {
            
            input_path = $$$('::', 'File').$expand_path(input.$path());
            input_mtime = (function() {if ($truthy($$$('::', 'ENV')['$[]']("SOURCE_DATE_EPOCH"))) {
              return $$$('::', 'Time').$at(self.$Integer($$$('::', 'ENV')['$[]']("SOURCE_DATE_EPOCH"))).$utc()
            } else {
              return input.$mtime()
            }; return nil; })();
            lines = input.$readlines();
            
            $writer = ["docfile", input_path];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["docdir", $$$('::', 'File').$dirname(input_path)];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            
            $writer = ["docname", $$($nesting, 'Helpers').$basename(input_path, (($writer = ["docfilesuffix", $$$('::', 'File').$extname(input_path)]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
            if ($truthy((docdate = attrs['$[]']("docdate")))) {
              ($truthy($a = attrs['$[]']("docyear")) ? $a : (($writer = ["docyear", (function() {if (docdate.$index("-")['$=='](4)) {
                
                return docdate.$slice(0, 4);
              } else {
                return nil
              }; return nil; })()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]))
            } else {
              
              docdate = (($writer = ["docdate", input_mtime.$strftime("%F")]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]);
              ($truthy($a = attrs['$[]']("docyear")) ? $a : (($writer = ["docyear", input_mtime.$year().$to_s()]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            };
            doctime = ($truthy($a = attrs['$[]']("doctime")) ? $a : (($writer = ["doctime", input_mtime.$strftime("" + "%T " + ((function() {if (input_mtime.$utc_offset()['$=='](0)) {
              return "UTC"
            } else {
              return "%z"
            }; return nil; })()))]), $send(attrs, '[]=', Opal.to_a($writer)), $writer[$rb_minus($writer["length"], 1)]));
            
            $writer = ["docdatetime", "" + (docdate) + " " + (doctime)];
            $send(attrs, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];;
          } else if ($truthy(input['$respond_to?']("readlines"))) {
            
            
            try {
              input.$rewind()
            } catch ($err) {
              if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                try {
                  nil
                } finally { Opal.pop_exception() }
              } else { throw $err; }
            };;
            lines = input.$readlines();
          } else if ($truthy($$$('::', 'String')['$==='](input))) {
            lines = (function() {if ($truthy($$$('::', 'RUBY_MIN_VERSION_2'))) {
              return input.$lines()
            } else {
              return input.$each_line().$to_a()
            }; return nil; })()
          } else if ($truthy($$$('::', 'Array')['$==='](input))) {
            lines = input.$drop(0)
          } else {
            self.$raise($$$('::', 'ArgumentError'), "" + "unsupported input type: " + (input.$class()))
          };
          if ($truthy(timings)) {
            
            timings.$record("read");
            timings.$start("parse");};
          
          $writer = ["attributes", attrs];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
          doc = (function() {if (options['$[]']("parse")['$=='](false)) {
            
            return $$($nesting, 'Document').$new(lines, options);
          } else {
            return $$($nesting, 'Document').$new(lines, options).$parse()
          }; return nil; })();
          if ($truthy(timings)) {
            timings.$record("parse")};
          return doc;
        } catch ($err) {
          if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {ex = $err;
            try {
              
              
              try {
                
                context = "" + "asciidoctor: FAILED: " + (($truthy($a = attrs['$[]']("docfile")) ? $a : "<stdin>")) + ": Failed to load AsciiDoc document";
                if ($truthy(ex['$respond_to?']("exception"))) {
                  
                  wrapped_ex = ex.$exception("" + (context) + " - " + (ex.$message()));
                  wrapped_ex.$set_backtrace(ex.$backtrace());
                } else {
                  
                  wrapped_ex = ex.$class().$new(context, ex);
                  
                  $writer = [ex.$stack_trace()];
                  $send(wrapped_ex, 'stack_trace=', Opal.to_a($writer));
                  $writer[$rb_minus($writer["length"], 1)];;
                };
              } catch ($err) {
                if (Opal.rescue($err, [$$($nesting, 'StandardError')])) {
                  try {
                    wrapped_ex = ex
                  } finally { Opal.pop_exception() }
                } else { throw $err; }
              };;
              return self.$raise(wrapped_ex);
            } finally { Opal.pop_exception() }
          } else { throw $err; }
        };
      }, TMP_load_9.$$arity = -2);
      
      Opal.def(self, '$load_file', TMP_load_file_13 = function $$load_file(filename, options) {
        var TMP_14, self = this;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        return $send($$$('::', 'File'), 'open', [filename, "rb"], (TMP_14 = function(file){var self = TMP_14.$$s || this;

        
          
          if (file == null) {
            file = nil;
          };
          return self.$load(file, options);}, TMP_14.$$s = self, TMP_14.$$arity = 1, TMP_14));
      }, TMP_load_file_13.$$arity = -2);
      
      Opal.def(self, '$convert', TMP_convert_15 = function $$convert(input, options) {
        var $a, $b, $c, $d, $e, self = this, to_file = nil, to_dir = nil, mkdirs = nil, $case = nil, write_to_same_dir = nil, stream_output = nil, write_to_target = nil, $writer = nil, input_path = nil, outdir = nil, doc = nil, outfile = nil, working_dir = nil, jail = nil, opts = nil, output = nil, stylesdir = nil, copy_asciidoctor_stylesheet = nil, copy_user_stylesheet = nil, stylesheet = nil, copy_coderay_stylesheet = nil, copy_pygments_stylesheet = nil, stylesoutdir = nil, stylesheet_src = nil, stylesheet_dest = nil, stylesheet_data = nil;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        options = options.$dup();
        options.$delete("parse");
        to_file = options.$delete("to_file");
        to_dir = options.$delete("to_dir");
        mkdirs = ($truthy($a = options.$delete("mkdirs")) ? $a : false);
        $case = to_file;
        if (true['$===']($case) || nil['$===']($case)) {
        write_to_same_dir = ($truthy($a = to_dir['$!']()) ? $$$('::', 'File')['$==='](input) : $a);
        stream_output = false;
        write_to_target = to_dir;
        to_file = nil;}
        else if (false['$===']($case)) {
        write_to_same_dir = false;
        stream_output = false;
        write_to_target = false;
        to_file = nil;}
        else if ("/dev/null"['$===']($case)) {return self.$load(input, options)}
        else {
        write_to_same_dir = false;
        write_to_target = (function() {if ($truthy((stream_output = to_file['$respond_to?']("write")))) {
          return false
        } else {
          
          
          $writer = ["to_file", to_file];
          $send(options, '[]=', Opal.to_a($writer));
          return $writer[$rb_minus($writer["length"], 1)];;
        }; return nil; })();};
        if ($truthy(options['$key?']("header_footer"))) {
        } else if ($truthy(($truthy($a = write_to_same_dir) ? $a : write_to_target))) {
          
          $writer = ["header_footer", true];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];};
        if ($truthy(write_to_same_dir)) {
          
          input_path = $$$('::', 'File').$expand_path(input.$path());
          
          $writer = ["to_dir", (outdir = $$$('::', 'File').$dirname(input_path))];
          $send(options, '[]=', Opal.to_a($writer));
          $writer[$rb_minus($writer["length"], 1)];;
        } else if ($truthy(write_to_target)) {
          if ($truthy(to_dir)) {
            if ($truthy(to_file)) {
              
              $writer = ["to_dir", $$$('::', 'File').$dirname($$$('::', 'File').$expand_path($$$('::', 'File').$join(to_dir, to_file)))];
              $send(options, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            } else {
              
              $writer = ["to_dir", $$$('::', 'File').$expand_path(to_dir)];
              $send(options, '[]=', Opal.to_a($writer));
              $writer[$rb_minus($writer["length"], 1)];
            }
          } else if ($truthy(to_file)) {
            
            $writer = ["to_dir", $$$('::', 'File').$dirname($$$('::', 'File').$expand_path(to_file))];
            $send(options, '[]=', Opal.to_a($writer));
            $writer[$rb_minus($writer["length"], 1)];}};
        doc = self.$load(input, options);
        if ($truthy(write_to_same_dir)) {
          
          outfile = $$$('::', 'File').$join(outdir, "" + (doc.$attributes()['$[]']("docname")) + (doc.$outfilesuffix()));
          if (outfile['$=='](input_path)) {
            self.$raise($$$('::', 'IOError'), "" + "input file and output file cannot be the same: " + (outfile))};
        } else if ($truthy(write_to_target)) {
          
          working_dir = (function() {if ($truthy(options['$key?']("base_dir"))) {
            
            return $$$('::', 'File').$expand_path(options['$[]']("base_dir"));
          } else {
            return $$$('::', 'Dir').$pwd()
          }; return nil; })();
          jail = (function() {if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
            return working_dir
          } else {
            return nil
          }; return nil; })();
          if ($truthy(to_dir)) {
            
            outdir = doc.$normalize_system_path(to_dir, working_dir, jail, $hash2(["target_name", "recover"], {"target_name": "to_dir", "recover": false}));
            if ($truthy(to_file)) {
              
              outfile = doc.$normalize_system_path(to_file, outdir, nil, $hash2(["target_name", "recover"], {"target_name": "to_dir", "recover": false}));
              outdir = $$$('::', 'File').$dirname(outfile);
            } else {
              outfile = $$$('::', 'File').$join(outdir, "" + (doc.$attributes()['$[]']("docname")) + (doc.$outfilesuffix()))
            };
          } else if ($truthy(to_file)) {
            
            outfile = doc.$normalize_system_path(to_file, working_dir, jail, $hash2(["target_name", "recover"], {"target_name": "to_dir", "recover": false}));
            outdir = $$$('::', 'File').$dirname(outfile);};
          if ($truthy(($truthy($a = $$$('::', 'File')['$==='](input)) ? outfile['$==']($$$('::', 'File').$expand_path(input.$path())) : $a))) {
            self.$raise($$$('::', 'IOError'), "" + "input file and output file cannot be the same: " + (outfile))};
          if ($truthy(mkdirs)) {
            $$($nesting, 'Helpers').$mkdir_p(outdir)
          } else if ($truthy($$$('::', 'File')['$directory?'](outdir))) {
          } else {
            self.$raise($$$('::', 'IOError'), "" + "target directory does not exist: " + (to_dir) + " (hint: set mkdirs option)")
          };
        } else {
          
          outfile = to_file;
          outdir = nil;
        };
        opts = (function() {if ($truthy(($truthy($a = outfile) ? stream_output['$!']() : $a))) {
          return $hash2(["outfile", "outdir"], {"outfile": outfile, "outdir": outdir})
        } else {
          return $hash2([], {})
        }; return nil; })();
        output = doc.$convert(opts);
        if ($truthy(outfile)) {
          
          doc.$write(output, outfile);
          if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = ($truthy($d = ($truthy($e = stream_output['$!']()) ? $rb_lt(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SECURE')) : $e)) ? doc['$attr?']("linkcss") : $d)) ? doc['$attr?']("copycss") : $c)) ? doc['$attr?']("basebackend-html") : $b)) ? ($truthy($b = (stylesdir = doc.$attr("stylesdir"))) ? $$($nesting, 'Helpers')['$uriish?'](stylesdir) : $b)['$!']() : $a))) {
            
            copy_asciidoctor_stylesheet = false;
            copy_user_stylesheet = false;
            if ($truthy((stylesheet = doc.$attr("stylesheet")))) {
              if ($truthy($$($nesting, 'DEFAULT_STYLESHEET_KEYS')['$include?'](stylesheet))) {
                copy_asciidoctor_stylesheet = true
              } else if ($truthy($$($nesting, 'Helpers')['$uriish?'](stylesheet)['$!']())) {
                copy_user_stylesheet = true}};
            copy_coderay_stylesheet = ($truthy($a = doc['$attr?']("source-highlighter", "coderay")) ? doc.$attr("coderay-css", "class")['$==']("class") : $a);
            copy_pygments_stylesheet = ($truthy($a = doc['$attr?']("source-highlighter", "pygments")) ? doc.$attr("pygments-css", "class")['$==']("class") : $a);
            if ($truthy(($truthy($a = ($truthy($b = ($truthy($c = copy_asciidoctor_stylesheet) ? $c : copy_user_stylesheet)) ? $b : copy_coderay_stylesheet)) ? $a : copy_pygments_stylesheet))) {
              
              stylesoutdir = doc.$normalize_system_path(stylesdir, outdir, (function() {if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
                return outdir
              } else {
                return nil
              }; return nil; })());
              if ($truthy(mkdirs)) {
                $$($nesting, 'Helpers').$mkdir_p(stylesoutdir)
              } else if ($truthy($$$('::', 'File')['$directory?'](stylesoutdir))) {
              } else {
                self.$raise($$$('::', 'IOError'), "" + "target stylesheet directory does not exist: " + (stylesoutdir) + " (hint: set mkdirs option)")
              };
              if ($truthy(copy_asciidoctor_stylesheet)) {
                $$($nesting, 'Stylesheets').$instance().$write_primary_stylesheet(stylesoutdir)
              } else if ($truthy(copy_user_stylesheet)) {
                
                if ($truthy((stylesheet_src = doc.$attr("copycss"))['$empty?']())) {
                  stylesheet_src = doc.$normalize_system_path(stylesheet)
                } else {
                  stylesheet_src = doc.$normalize_system_path(stylesheet_src)
                };
                stylesheet_dest = doc.$normalize_system_path(stylesheet, stylesoutdir, (function() {if ($truthy($rb_ge(doc.$safe(), $$$($$($nesting, 'SafeMode'), 'SAFE')))) {
                  return outdir
                } else {
                  return nil
                }; return nil; })());
                if ($truthy(($truthy($a = stylesheet_src['$!='](stylesheet_dest)) ? (stylesheet_data = doc.$read_asset(stylesheet_src, $hash2(["warn_on_failure", "label"], {"warn_on_failure": $$$('::', 'File')['$file?'](stylesheet_dest)['$!'](), "label": "stylesheet"}))) : $a))) {
                  $$$('::', 'IO').$write(stylesheet_dest, stylesheet_data)};};
              if ($truthy(copy_coderay_stylesheet)) {
                $$($nesting, 'Stylesheets').$instance().$write_coderay_stylesheet(stylesoutdir)
              } else if ($truthy(copy_pygments_stylesheet)) {
                $$($nesting, 'Stylesheets').$instance().$write_pygments_stylesheet(stylesoutdir, doc.$attr("pygments-style"))};};};
          return doc;
        } else {
          return output
        };
      }, TMP_convert_15.$$arity = -2);
      Opal.alias(self, "render", "convert");
      
      Opal.def(self, '$convert_file', TMP_convert_file_16 = function $$convert_file(filename, options) {
        var TMP_17, self = this;

        
        
        if (options == null) {
          options = $hash2([], {});
        };
        return $send($$$('::', 'File'), 'open', [filename, "rb"], (TMP_17 = function(file){var self = TMP_17.$$s || this;

        
          
      