# @antora/expand-path-helper

A module for Node.js that provides a helper function to expand a path to an absolute path.
This function expands the first segment if it matches a shorthand expression, dot (`.`), tilde (`~`), or tilde plus (`~+`).
The expanded path is system dependent.
Developed for use in Antora.

## Install

```sh
$ npm i @antora/expand-path-helper
```

or

```sh
$ yarn add @antora/expand-path-helper
```

## API

```js
function expandPath (path, start = '~+', dot = '.') { ... }
```

Converts path to an absolute path.

* `path` - The path to expand.
This parameter is required and must not be falsy.
* `start` - The starting directory from which to anchor a relative path.
This parameter is optional.
It defaults to the current working directory of the process (`~+`).
* `dot` - The value to use to replace a leading dot (`.`) segment.
This parameter is optional.
If the value of this parameter is itself `.`, which is the default, it uses the value of the start parameter.

The main purpose of this function is path expansion.
If the first segment of the path, the value of the start parameter, or the value of the dot parameter matches `~` or `~+`, that value is expanded to the user's home directory or current working directory, respectively.
If the first segment of the path matches `.`, that value is replaced with the value of the dot parameter after being expanded.

## Usage

The output of `expandPath` depends on the system on which it is run (specifically on the `path.sep` value).

### *nix

```js
const expandPath = require('@antora/expand-path-helper')

expandPath('/absolute/path')
//=> /absolute/path

expandPath('foo/bar')
//=> /current/directory/foo/bar

expandPath('./foo/bar')
//=> /current/directory/foo/bar

expandPath('~/foo/bar')
//=> /home/user/foo/bar

expandPath('~+/foo/bar')
//=> /current/directory/foo/bar

expandPath('foo/bar', '/start/dir')
//=> /start/dir/foo/bar

expandPath('./foo/bar', '/start/dir')
//=> /start/dir/foo/bar

expandPath('./foo/bar', '~+', '/start/dir')
//=> /start/dir/foo/bar
```

### Windows

```js
const expandPath = require('@antora/expand-path-helper')

expandPath('C:\\absolute\\path')
//=> C:\absolute\path

expandPath('foo\\bar')
//=> C:\current\directory\foo\bar

expandPath('.\\foo\\bar')
//=> C:\current\directory\foo\bar

expandPath('~\\foo\\bar')
//=> C:\Users\user\foo\bar

expandPath('~+\\foo\\bar')
//=> C:\current\directory\foo\bar

expandPath('foo\\bar', 'C:\\start\\dir')
//=> C:\start\dir\foo\bar

expandPath('.\\foo\\bar', 'C:\\start\\dir')
//=> C:\start\dir\foo\bar

expandPath('.\\foo\\bar', '~+', 'C:\\start\\dir')
//=> C:\start\dir\foo\bar
```

On Windows, the input path may contain forward slashes, but the expanded path will always have backslashes.

## Copyright and License

Copyright (C) 2018 OpenDevise Inc. and the Antora Project.

Use of this software is granted under the terms of the [Mozilla Public License Version 2.0](https://www.mozilla.org/en-US/MPL/2.0/) (MPL-2.0).
