// Code generated by pg-bindings generator. DO NOT EDIT.

// +build sql_integration

package postgres

import (
"context"
"testing"

"github.com/jackc/pgx/v4/pgxpool"
"github.com/stackrox/rox/pkg/features"
"github.com/stackrox/rox/pkg/fixtures"
"github.com/stackrox/rox/pkg/postgres/pgtest"
"github.com/stackrox/rox/pkg/search"
"github.com/stretchr/testify/assert"
"github.com/stackrox/rox/pkg/testutils/envisolator"
"github.com/stretchr/testify/suite"
)

type AlertsIndexSuite struct {
	suite.Suite
	envIsolator *envisolator.EnvIsolator
}

func TestAlertsIndex(t *testing.T) {
	suite.Run(t, new(AlertsIndexSuite))
}

func (s *AlertsIndexSuite) SetupTest() {
	s.envIsolator = envisolator.NewEnvIsolator(s.T())
	s.envIsolator.Setenv(features.PostgresDatastore.EnvVar(), "true")

	if !features.PostgresDatastore.Enabled() {
		s.T().Skip("Skip postgres index tests")
		s.T().SkipNow()
	}
}

func (s *AlertsIndexSuite) TearDownTest() {
	s.envIsolator.RestoreAll()
}

func (s *AlertsIndexSuite) TestIndex() {
	source := pgtest.GetConnectionString(s.T())
	config, err := pgxpool.ParseConfig(source)
	if err != nil {
		panic(err)
	}
	pool, err := pgxpool.ConnectConfig(context.Background(), config)
	s.NoError(err)
	defer pool.Close()

	Destroy(pool)
	store := New(pool)
	indexer := NewIndexer(pool)

	alert := fixtures.GetAlert()
	foundAlert, exists, err := store.Get(alert.GetId())
	s.NoError(err)
	s.False(exists)
	s.Nil(foundAlert)

	s.NoError(store.Upsert(alert))
	foundAlert, exists, err = store.Get(alert.GetId())
	s.NoError(err)
	s.True(exists)
	s.Equal(alert, foundAlert)

	// Common alert searches
	results, err := indexer.Search(search.NewQueryBuilder().AddExactMatches(search.DeploymentID, alert.GetDeployment().GetId()).ProtoQuery())
	s.NoError(err)
	s.Len(results, 1)

	q := search.NewQueryBuilder().
		AddExactMatches(search.DeploymentID, alert.GetDeployment().GetId()).
		AddExactMatches(search.PolicyID, alert.GetPolicy().GetId()).
		AddStrings(search.ViolationState, storage.ViolationState_ACTIVE.String()).
		ProtoQuery()
	results, err = indexer.Search(q)
	s.NoError(err)
	s.Len(results, 1)
}

