// Code generated by pg-bindings generator. DO NOT EDIT.

//go:build sql_integration

package postgres

import (
	"context"
	"testing"

	"github.com/jackc/pgx/v4/pgxpool"
	"github.com/stackrox/rox/pkg/features"
	"github.com/stackrox/rox/pkg/fixtures"
	"github.com/stackrox/rox/pkg/postgres/pgtest"
	"github.com/stackrox/rox/pkg/testutils/envisolator"
	"github.com/stretchr/testify/suite"
)

type AlertsStoreSuite struct {
	suite.Suite
	envIsolator *envisolator.EnvIsolator
}

func TestAlertsStore(t *testing.T) {
	suite.Run(t, new(AlertsStoreSuite))
}

func (s *AlertsStoreSuite) SetupTest() {
	s.envIsolator = envisolator.NewEnvIsolator(s.T())
	s.envIsolator.Setenv(features.PostgresDatastore.EnvVar(), "true")

	if !features.PostgresDatastore.Enabled() {
		s.T().Skip("Skip postgres store tests")
		s.T().SkipNow()
	}
}

func (s *AlertsStoreSuite) TearDownTest() {
	s.envIsolator.RestoreAll()
}

func (s *AlertsStoreSuite) TestStore() {
	source := pgtest.GetConnectionString(s.T())
	config, err := pgxpool.ParseConfig(source)
	if err != nil {
		panic(err)
	}
	pool, err := pgxpool.ConnectConfig(context.Background(), config)
	s.NoError(err)
	defer pool.Close()

	Destroy(pool)
	store := New(pool)

	alert := fixtures.GetAlert()
	foundAlert, exists, err := store.Get(alert.GetId())
	s.NoError(err)
	s.False(exists)
	s.Nil(foundAlert)

	s.NoError(store.Upsert(alert))
	foundAlert, exists, err = store.Get(alert.GetId())
	s.NoError(err)
	s.True(exists)
	s.Equal(alert, foundAlert)

	alertCount, err := store.Count()
	s.NoError(err)
	s.Equal(alertCount, 1)

	alertExists, err := store.Exists(alert.GetId())
	s.NoError(err)
	s.True(alertExists)
	s.NoError(store.Upsert(alert))

	foundAlert, exists, err = store.Get(alert.GetId())
	s.NoError(err)
	s.True(exists)
	s.Equal(alert, foundAlert)

	s.NoError(store.Delete(alert.GetId()))
	foundAlert, exists, err = store.Get(alert.GetId())
	s.NoError(err)
	s.False(exists)
	s.Nil(foundAlert)
}
